/*****************************************************************

Copyright (c) 1996-2003 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __zoombutton_h__
#define __zoombutton_h__

#include <qcursor.h>
#include <qguardedptr.h>
#include <qpixmap.h>

#include "panelbuttonbase.h"

class ZoomButton : public PanelButtonBase
{
    Q_OBJECT

public:
    ZoomButton();
    ~ZoomButton();
    bool isZoomingEnabled() const { return zooming; }
    bool isAnimationEnabled() const { return doAnimations; }
    bool isWatching( PanelButtonBase* btn );
    void watchMe( PanelButtonBase* btn );
    void unFocus();

public slots:
    void reconfigure();
    void updateIcon();

protected:
    void drawButtonLabel(QPainter *p);
    bool eventFilter( QObject *o, QEvent * e);
    // reimp these to do nothing
    void resizeEvent(QResizeEvent*) {}
    void enterEvent( QEvent*) {}
    void leaveEvent( QEvent*) {}
    void unsetCursor();
    void readAnimatedIconsConfig();

    QEvent* locked;
    QGuardedPtr<PanelButtonBase> watch;
    QCursor _oldCursor;
    QPoint mypos;
    bool zooming;
    bool doAnimations;
    int hideTimer;
};

#endif // __zoombutton_h__

