/*
    KSysGuard, the KDE System Guard

	Copyright (c) 1999 Chris Schlaeger <cs@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	KSysGuard is currently maintained by Chris Schlaeger <cs@kde.org>. Please do
	not commit any changes without consulting me first. Thanks!

*/

#ifndef _ReniceDlg_h_
#define _ReniceDlg_h_

/*
 * kapp.h includes a dirty X.h file that contains marcos that collide with
 * qslider.h. The following defines work around this problem.
 */
#ifdef Above
#undef Above
#endif
#ifdef Below
#undef Below
#endif

#include <kdialogbase.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlcdnumber.h>
#include <qpushbutton.h>
#include <qslider.h>

/**
 * This class creates and handles a simple dialog to change the scheduling
 * priority of a process.
 */
class ReniceDlg : public KDialogBase
{
	Q_OBJECT

public:
	ReniceDlg(QWidget* parent, const char* name, int currentPPrio, int pid);
	~ReniceDlg()
	{
		delete message;

		delete slider;
		delete lcd;
		delete vLay;
	}
public slots:
    void slotOk();
    void slotCancel();

private:
	int value;

	QBoxLayout* vLay;
	QBoxLayout* butLay;
	QBoxLayout* sldLay;

	QLabel* message;

	QSlider* slider;
	QLCDNumber* lcd;

private slots:
	void setPriorityValue(int priority)
	{
		value = priority;
	}
};

#endif
