
  

#include <qcstring.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <qcanvas.h>
#include "qcanvasview_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

QCanvasViewImp::QCanvasViewImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

QCanvasViewImp::~QCanvasViewImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void QCanvasViewImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasViewImp *meth = new QCanvasViewImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void QCanvasViewImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_canvas_4, "canvas" },
        { Method_setCanvas_5, "setCanvas" },
        { Method_worldMatrix_6, "worldMatrix" },
        { Method_inverseWorldMatrix_7, "inverseWorldMatrix" },
        { Method_setWorldMatrix_8, "setWorldMatrix" },
	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasViewImp *meth = new QCanvasViewImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a QCanvasView pointer from an Object.
 */
QCanvasView *QCanvasViewImp::toQCanvasView( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        QObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<QCanvasView *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "QCanvasView" )
        return 0;

    return (QCanvasView *)( op->toVoidStar() );
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object QCanvasViewImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasView_1:
             return QCanvasView_1( exec, args );
             break;
    
         case Constructor_QCanvasView_2:
             return QCanvasView_2( exec, args );
             break;
    
         default:
             break;
    }

    QString msg = i18n("QCanvasViewCons has no constructor with id '%1'.").arg(id);
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Object QCanvasViewImp::QCanvasView_1( KJS::ExecState *exec, const KJS::List &args )
{
    
    // Unsupported parameter QWidget *
    return KJS::Object();
    
    QWidget * arg0; // Dummy
        
    const char *arg1 = (args.size() >= 2) ? args[1].toString(exec).ascii() : 0;
        
    Qt::WFlags arg2; // TODO (hack for QCanvasView)
        

    // We should now create an instance of the QCanvasView object

    QCanvasView *ret = new QCanvasView(
       
          arg0,
          arg1,
          arg2 );

    
}
    
KJS::Object QCanvasViewImp::QCanvasView_2( KJS::ExecState *exec, const KJS::List &args )
{
    
    // Unsupported parameter QCanvas *
    return KJS::Object();
    
    QCanvas * arg0; // Dummy
        
    // Unsupported parameter QWidget *
    return KJS::Object();
    
    QWidget * arg1; // Dummy
        
    const char *arg2 = (args.size() >= 3) ? args[2].toString(exec).ascii() : 0;
        
    Qt::WFlags arg3; // TODO (hack for QCanvasView)
        

    // We should now create an instance of the QCanvasView object

    QCanvasView *ret = new QCanvasView(
       
          arg0,
          arg1,
          arg2,
          arg3 );

    
}
    
KJS::Value QCanvasViewImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = QCanvasViewImp::toQCanvasView( self );

    switch( id ) {

    case Method_canvas_4:
        return canvas_4( exec, self, args );
        break;
    
    case Method_setCanvas_5:
        return setCanvas_5( exec, self, args );
        break;
    
    case Method_worldMatrix_6:
        return worldMatrix_6( exec, self, args );
        break;
    
    case Method_inverseWorldMatrix_7:
        return inverseWorldMatrix_7( exec, self, args );
        break;
    
    case Method_setWorldMatrix_8:
        return setWorldMatrix_8( exec, self, args );
        break;
    
    default:
        break;
    }

    QString msg = i18n( "QCanvasViewImp has no method with id '%1'." ).arg( id );
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Value QCanvasViewImp::canvas_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      instance->canvas(  );
      return KJS::Value(); // Returns 'QCanvas *'
      
}
    
KJS::Value QCanvasViewImp::setCanvas_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    // Unsupported parameter QCanvas *
    return KJS::Value();
    
    QCanvas * arg0; // Dummy
        
      instance->setCanvas( 
       arg0 );
      return KJS::Value(); // Returns void
      
}
    
KJS::Value QCanvasViewImp::worldMatrix_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      instance->worldMatrix(  );
      return KJS::Value(); // Returns 'const QWMatrix &'
      
}
    
KJS::Value QCanvasViewImp::inverseWorldMatrix_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
      instance->inverseWorldMatrix(  );
      return KJS::Value(); // Returns 'const QWMatrix &'
      
}
    
KJS::Value QCanvasViewImp::setWorldMatrix_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    
    QWMatrix arg0; // TODO (hack for qcanvasview)
        
      bool ret;
      ret = instance->setWorldMatrix( 
       arg0 );
      return KJS::Boolean( ret );
      
}
    

} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


