
  

#ifndef KJSEMBED_QFrame_H
#define KJSEMBED_QFrame_H

#include <kjs/interpreter.h>
#include <kjs/object.h>

#include <kjsembed/jsobjectproxy_imp.h>

class QFrame;

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

/**
 * Wrapper class for QFrame methods.
 *
 * @author Richard Moore, rich@kde.org
 */
class QFrameImp : public JSProxyImp
{
public:
   /** Enumerates the constructors supported by this class. */
   enum Constructors {
       Constructor_QFrame_1,

       LastConstuctor = -1
   };

   /** Enumerates the methods supported by this class. */
   enum Methods {

       Method_frameStyle_2,
       Method_setFrameStyle_3,
       Method_frameWidth_4,
       Method_contentsRect_5,
       Method_lineShapesOk_6,
       Method_sizeHint_7,
       Method_frameShape_8,
       Method_setFrameShape_9,
       Method_frameShadow_10,
       Method_setFrameShadow_11,
       Method_lineWidth_12,
       Method_setLineWidth_13,
       Method_margin_14,
       Method_setMargin_15,
       Method_midLineWidth_16,
       Method_setMidLineWidth_17,
       Method_frameRect_18,
       Method_setFrameRect_19,
       Method_Last = -1
   };

   QFrameImp( KJS::ExecState *exec, int id, bool constructor=false );
   ~QFrameImp();

   static void addBindings( KJS::ExecState *exec, KJS::Object &object );

   static QFrame *toQFrame( KJS::Object &object );

   //
   // Constructors implemented by this class.
   //

   KJS::Object QFrame_1( KJS::ExecState *exec, const KJS::List &args );

   //
   // Methods implemented by this class.
   //

   KJS::Value frameStyle_2( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setFrameStyle_3( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value frameWidth_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value contentsRect_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value lineShapesOk_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value sizeHint_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value frameShape_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setFrameShape_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value frameShadow_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setFrameShadow_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value lineWidth_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setLineWidth_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value margin_14( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setMargin_15( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value midLineWidth_16( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setMidLineWidth_17( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value frameRect_18( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value setFrameRect_19( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );

   //
   // JS binding code.
   //

   /** Returns true iff this object implements the construct function. */
   virtual bool implementsConstruct() const { return cons; }

   /** Invokes the construct function. */
   virtual KJS::Object construct( KJS::ExecState *exec, const KJS::List &args );

   /** Returns true iff this object implements the call function. */
   virtual bool implementsCall() const { return !cons; }

   /** Invokes the call function. */
   virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

private:
   QFrame *instance; // Temp
   int id;
   bool cons;
};

} // namespace KJSEmbed

#endif // KJSEMBED_QFrame_H

// Local Variables:
// c-basic-offset: 4
// End:


