/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#ifndef KMTMODULEVIEW_H
#define KMTMODULEVIEW_H

#include <qptrlist.h>
#include <qstringlist.h>
#include <qwidget.h>

class QHBoxLayout;
class QLabel;
class QPushButton;
class QVBoxLayout;


class ModuleView : public QWidget
{
  Q_OBJECT

  public:
    ModuleView(QWidget* parent, const char* name = 0);

    void setName(const QString& name) { _name = name; }
    const QString name( ) const { return _name; }
    void setGroups(const QStringList& groups) { _groups = groups; }
    const QStringList groups( ) const { return _groups; }

    void setHeading(const QString& heading);

    virtual void aboutToActivate( ) = 0;

  signals:
    void signalMessage(const QString&);
    void signalError(const QString&);
    void signalInputPresent(bool);
    void signalReturnPressed( );
    void signalNewCalculation( );

  protected:
    virtual void setMainWidget(QWidget* w) = 0;
    void addMainLayout(QLayout* layout);

  protected slots:
    virtual void slotCalculate( ) = 0;
    virtual void slotClearInput( ) = 0;

  private:
    QString _name;
    QStringList _groups;

    QVBoxLayout* topLayout;
    QLabel* headLabel;
    QPushButton* calcButton;
    QPushButton* clearButton;
};


class SimpleModuleView : public ModuleView
{
  Q_OBJECT

  public:
    SimpleModuleView(QWidget* parent, const char* name = 0);

  protected:
    virtual void setMainWidget(QWidget* w);

  private:
    QHBoxLayout* layout;
};


class ImageModuleView : public ModuleView
{
  Q_OBJECT

  public:
    ImageModuleView(QWidget* parent, const char* name = 0);

    void setPixmap(QPixmap p);

  protected:
    virtual void setMainWidget(QWidget* w);

  private:
    QHBoxLayout* layout;
    QLabel* pixLabel;
};

typedef QPtrList<ModuleView> ModuleViewList;

#endif // KMTMODULEVIEW_H
