#include "mwconfig.h"
#include "mwconfig.moc"
#include "splashscreen.h"
#include <pwd.h>
#include <kdebug.h>
#include <kpushbutton.h>

/*
 *  Constructs a Config which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 */
Config::Config( QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{

	themeID=0L;
	config = kapp->config();

	config->setGroup("Theme");
	themeName=config->readEntry("Name","default");
	config->sync();

    if ( !name )
	setName( "Config" );
    resize( 349, 227 );
    setCaption( i18n( "KMessedWords Configuration" ) );
    ConfigLayout = new QGridLayout( this );
    ConfigLayout->setSpacing( 6 );
    ConfigLayout->setMargin( 11 );

    btnCancel = new KPushButton( KStdGuiItem::cancel(), this, "btnCancel" );

    ConfigLayout->addWidget( btnCancel, 1, 2 );

    TabWidget3 = new QTabWidget( this, "TabWidget3" );
    TabWidget3->setTabShape( QTabWidget::Rounded );

    tab = new QWidget( TabWidget3, "tab" );

    GroupBox1 = new QGroupBox( tab, "GroupBox1" );
    GroupBox1->setGeometry( QRect( 10, 0, 211, 131 ) );
    GroupBox1->setTitle( i18n( "Themes" ) );

    chkBtnPix = new QCheckBox( GroupBox1, "CheckBox1" );
    chkBtnPix->setGeometry( QRect( 7, 54, 140, 20 ) );
    chkBtnPix->setText( i18n( "&Button images" ) );

    chkBgPix = new QCheckBox( GroupBox1, "CheckBox2" );
    chkBgPix->setGeometry( QRect( 7, 74, 170, 20 ) );
    chkBgPix->setText( i18n( "B&ackground image" ) );

    chkThmSnd = new QCheckBox( GroupBox1, "CheckBox3" );
    chkThmSnd->setGeometry( QRect( 7, 94, 130, 20 ) );
    chkThmSnd->setText( i18n( "&Enable sounds" ) );
	 chkThmSnd->setEnabled(false);

    themeSelector = new QComboBox( FALSE, GroupBox1, "ComboBox1" );
    themeSelector->setGeometry( QRect( 7, 24, 180, 22 ) );
    TabWidget3->insertTab( tab, i18n( "&Interface" ) );

    tab_2 = new QWidget( TabWidget3, "tab_2" );

    chkTimer = new QCheckBox( tab_2, "chkTimer" );
    chkTimer->setGeometry( QRect( 10, 30, 160, 20 ) );
    chkTimer->setText( i18n( "Time limit" ) );
    chkTimer->setEnabled(false);

    timerBox = new QSpinBox( tab_2, "SpinBox1" );
    timerBox->setGeometry( QRect( 10, 50, 90, 23 ) );
    timerBox->setEnabled(false);

    chkGfxStyle = new QCheckBox( tab_2, "chkGfxStyle" );
    chkGfxStyle->setGeometry( QRect( 10, 10, 160, 20 ) );
    chkGfxStyle->setText( i18n( "&Use graphical indicators" ) );
    chkGfxStyle->setChecked(true);

    TabWidget3->insertTab( tab_2, i18n( "&Game" ) );

    tab_3 = new QWidget( TabWidget3, "tab_3" );
	nameLabel=new QLabel(tab_3, "nameLabel");
	nameLabel->setGeometry(10,5,45,20);
	nameLabel->setText(i18n("&Name:"));

	nameEdit = new QLineEdit(tab_3, "nameEdit");
	nameEdit->setGeometry(50,5,160,20);

        nameLabel->setBuddy(nameEdit);

   TabWidget3->insertTab( tab_3, i18n( "&User" ) );

    tab_4 = new QWidget( TabWidget3, "tab_4" );
	//enable Sillables...
    chkSilly = new QCheckBox( tab_4, "chkSilly" );
    chkSilly->setGeometry( QRect( 10, 10, 160, 20 ) );
    chkSilly->setText( i18n( "&Enable syllables" ) );
    chkSilly->setChecked(false);
	//get the file
	showSillyFile = new QLabel (tab_4, "showSillyFile");
	showSillyFile->setGeometry(QRect(10,30,250,20));
	showSillyFile->setText(i18n("File: None"));
	showSillyFile->setEnabled(false);

	btnLoadSilly = new QPushButton (tab_4, "showSillyFile");
	btnLoadSilly->setGeometry(QRect(10,55,100,20));
	btnLoadSilly->setText(i18n("Open File..."));
	btnLoadSilly->setEnabled(false);

    chkMemSilly = new QCheckBox( tab_4, "chkSilly" );
    chkMemSilly->setGeometry( QRect( 10, 80, 160, 20 ) );
    chkMemSilly->setText( i18n( "&Remember syllables" ) );
    chkMemSilly->setChecked(true);
    chkMemSilly->setEnabled(false);

   TabWidget3->insertTab( tab_4, i18n( "&Syllables" ) );

    ConfigLayout->addMultiCellWidget( TabWidget3, 0, 0, 0, 2 );

    btnOkay = new KPushButton( KStdGuiItem::ok(), this, "btnOkay" );
    btnOkay->setFocus();

    ConfigLayout->addWidget( btnOkay, 1, 0 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    ConfigLayout->addItem( spacer, 1, 1 );

	 //connections..
    connect(btnOkay, SIGNAL( clicked() ), this, SLOT( slot_ok() ) );
    connect(btnCancel, SIGNAL( clicked() ), this, SLOT( slot_cancel() ) );
    connect(chkTimer, SIGNAL( stateChanged(int) ), this, SLOT( enableTimer() ) );
    connect(chkSilly, SIGNAL(stateChanged(int)), this, SLOT (enableSilly()) );
    connect(btnLoadSilly, SIGNAL(clicked()), this, SLOT(loadSillyFile()) );

   //getting data...
	grabData();
}

Config::~Config() {
}

void Config::slot_ok(){
	config->setGroup("Theme");
	config->writeEntry("Name",themeSelector->currentText());
	config->writeEntry("Sound", chkThmSnd->isChecked());
	config->writeEntry("Background", chkBgPix->isChecked());
	config->writeEntry("Buttons",chkBtnPix->isChecked());
	config->sync();

	config->setGroup("Environment");
	config->writeEntry("UseGfxStyle",chkGfxStyle->isChecked());
	config->writeEntry("SetTimeLimit", chkTimer->isChecked());
	config->writeEntry("Timer", timerBox->value());
	config->writeEntry("GamerName", nameEdit->text());
	config->sync();
	
	config->setGroup("Syllables");
	config->writeEntry("UseSilly",chkSilly->isChecked());
	config->writeEntry("SillyFile", globalSillyFile);
	config->writeEntry("MemSilly", chkMemSilly->isChecked());
	config->sync();
	
	emit sig_reload();
	
	close();
}

void Config::enableTimer() {
	timerBox->setEnabled(chkTimer->isChecked());
}

void Config::grabData() {
	themeSelector->clear();
	QDir d(locate("data","kmessedwords/themes/")); //the theme directory...
	d.setFilter( QDir::Dirs);
	d.setSorting( QDir::Name);

	for ( uint i=0; i<d.count(); i++ ) {
	 	if ((d[i] != ".") && (d[i] != "..")) {
			themeSelector->insertItem(d[i]);
			if (d[i]==themeName){
				themeID=i-2;
			}
		}
	}

	config->setGroup("Theme");
	themeSelector->setCurrentItem(themeID);
	chkThmSnd->setChecked(config->readBoolEntry("Sound",false));
	chkBgPix->setChecked(config->readBoolEntry("Background",true));
	chkBtnPix->setChecked(config->readBoolEntry("Buttons",false));
	config->sync();

	config->setGroup("Environment");
	chkGfxStyle->setChecked(config->readBoolEntry("UseGfxStyle",false));
	chkTimer->setChecked(config->readBoolEntry("SetTimeLimit", false));
	timerBox->setValue(config->readNumEntry("Timer", 0));
	
	QString shareLoginName;
	shareLoginName=config->readEntry("GamerName", "");
	
	struct passwd* pw;
	if (shareLoginName.isEmpty()) {
		pw = getpwuid(getuid());
		if (pw) {
			shareLoginName = pw->pw_gecos;
			int i = shareLoginName.find(',');
			if (i>0)
				shareLoginName.truncate(i);
		}
	}
	nameEdit->setText(config->readEntry("GamerName", shareLoginName));

//we load the memorized syllables support...
	config->setGroup("Syllables");
	chkMemSilly->setChecked(config->readBoolEntry("MemSilly", true));
	chkSilly->setChecked(config->readBoolEntry("UseSilly",false));
	globalSillyFile= config->readEntry("SillyFile", "");
// ^-- is this "safe"?
}

void Config::slot_cancel() {
	grabData();
	close();
}

void Config::enableSilly() {
	showSillyFile->setEnabled(chkSilly->isChecked());
	btnLoadSilly->setEnabled(chkSilly->isChecked());
	chkMemSilly->setEnabled(chkSilly->isChecked());
}

void Config::loadSillyFile() {
	QString getOpenedFile=KFileDialog::getOpenFileName(QString::null, QString::null, this, i18n("Open File"));
	if (! getOpenedFile.isEmpty() ) {
		globalSillyFile=getOpenedFile;
		showSillyFile->setText(getOpenedFile);
	}
}
