#!/usr/bin/env kjscmd

//
// Script to load an image and report some info about it.
//

function image_info( name )
{
    var img = new Image();
    img.load( name );
    if ( !img.isOk() ) {
	return null;
    }

    return img.width()+' x '+img.height()+' x '+img.depth()+ '\t'+img.format();
}

if ( application.args.length == 0 ) {
    System.err.println( 'Usage:' );
    System.err.println( '\timageinfo imgfile ...' );
}
else {
    for ( var i = 0 ; i < application.args.length ; i++ ) {
	var prefix = '';
	if ( application.args.length > 1 ) {
	    prefix = application.args[i] + ':\t';
	}

	var msg = image_info( application.args[i] );
	if ( msg ) {
	    System.err.println( prefix + msg );
	}
    }
}



