#ifndef _qtutils_h
#define _qtutils_h

#include <jni.h>
#include <qobject.h>
#include <qevent.h>

class QtUtils : public QObject
{

    Q_OBJECT

public:
    QtUtils();
    ~QtUtils();

    void postSync(JNIEnv *env, jobject runnable);
    jobject postSyncRet(JNIEnv *env, jobject runnable);
    void postAsync(JNIEnv *env, jobject runnable);

protected:
    virtual void customEvent(QCustomEvent *e);

public:
    static QtUtils* gUtils;

};

#ifdef __cplusplus
extern "C" {
#endif


/*
 * Class:     org_kde_qt_QtUtils
 * Method:    execSyncOnGUIThread
 * Signature: (Lorg/kde/qt/QtUtils$Compute;)Ljava/lang/Object;
 */
JNIEXPORT jobject JNICALL Java_org_kde_qt_QtUtils_execSyncOnGUIThread__Lorg_kde_qt_QtUtils_00024Compute_2
  (JNIEnv *, jclass, jobject);

/*
 * Class:     org_kde_qt_QtUtils
 * Method:    execSyncOnGUIThread
 * Signature: (Ljava/lang/Runnable;)V
 */
JNIEXPORT void JNICALL Java_org_kde_qt_QtUtils_execSyncOnGUIThread__Ljava_lang_Runnable_2
  (JNIEnv *, jclass, jobject);

/*
 * Class:     org_kde_qt_QtUtils
 * Method:    execAsyncOnGUIThread
 * Signature: (Ljava/lang/Runnable;)V
 */
JNIEXPORT void JNICALL Java_org_kde_qt_QtUtils_execAsyncOnGUIThread
  (JNIEnv *, jclass, jobject);


#ifdef __cplusplus
}
#endif

#endif /* _qtUtils_h */
