#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/exports.new
# If you already had your own /etc/exports, this one is probably useless...
rm -f etc/exports.new
# Using config() to install this will help avoid unexpected permissions changes.
config etc/rc.d/rc.nfsd.new

if [ ! -r var/lib/nfs/rmtab ]; then
  touch var/lib/nfs/rmtab
  chmod 644 var/lib/nfs/rmtab
fi
if [ ! -r var/lib/nfs/xtab ]; then
  touch var/lib/nfs/xtab
  chmod 644 var/lib/nfs/xtab
fi
if [ ! -r var/lib/nfs/etab ]; then
  touch var/lib/nfs/etab
  chmod 644 var/lib/nfs/etab
fi

( cd usr/man/man8 ; rm -rf rpc.lockd.8.gz )
( cd usr/man/man8 ; ln -sf lockd.8.gz rpc.lockd.8.gz )
( cd usr/man/man8 ; rm -rf rpc.mountd.8.gz )
( cd usr/man/man8 ; ln -sf mountd.8.gz rpc.mountd.8.gz )
( cd usr/man/man8 ; rm -rf rpc.nfsd.8.gz )
( cd usr/man/man8 ; ln -sf nfsd.8.gz rpc.nfsd.8.gz )
( cd usr/man/man8 ; rm -rf rpc.rquotad.8.gz )
( cd usr/man/man8 ; ln -sf rquotad.8.gz rpc.rquotad.8.gz )
( cd usr/man/man8 ; rm -rf rpc.statd.8.gz )
( cd usr/man/man8 ; ln -sf statd.8.gz rpc.statd.8.gz )
( cd usr/sbin ; rm -rf rpc.lockd )
( cd usr/sbin ; ln -sf /sbin/rpc.lockd rpc.lockd )
( cd usr/sbin ; rm -rf rpc.statd )
( cd usr/sbin ; ln -sf /sbin/rpc.statd rpc.statd )
