#!/bin/sh
#
# Copyright (c) 2005 Linus Torvalds
#

OPTIONS_KEEPDASHDASH=
OPTIONS_SPEC="\
git repack [options]
--
a               pack everything in a single pack
A               same as -a, and turn unreachable objects loose
d               remove redundant packs, and run git-prune-packed
f               pass --no-reuse-object to git-pack-objects
n               do not run git-update-server-info
q,quiet         be quiet
l               pass --local to git-pack-objects
 Packing constraints
window=         size of the window used for delta compression
window-memory=  same as the above, but limit memory size instead of entries count
depth=          limits the maximum delta depth
max-pack-size=  maximum size of each packfile
"
SUBDIRECTORY_OK='Yes'
. git-sh-setup

no_update_info= all_into_one= remove_redundant= unpack_unreachable=
local= quiet= no_reuse= extra=
while test $# != 0
do
	case "$1" in
	-n)	no_update_info=t ;;
	-a)	all_into_one=t ;;
	-A)	all_into_one=t
		unpack_unreachable=--unpack-unreachable ;;
	-d)	remove_redundant=t ;;
	-q)	quiet=-q ;;
	-f)	no_reuse=--no-reuse-object ;;
	-l)	local=--local ;;
	--max-pack-size|--window|--window-memory|--depth)
		extra="$extra $1=$2"; shift ;;
	--) shift; break;;
	*)	usage ;;
	esac
	shift
done

case "`git config --bool repack.usedeltabaseoffset || echo true`" in
true)
	extra="$extra --delta-base-offset" ;;
esac

PACKDIR="$GIT_OBJECT_DIRECTORY/pack"
PACKTMP="$GIT_OBJECT_DIRECTORY/.tmp-$$-pack"
rm -f "$PACKTMP"-*
trap 'rm -f "$PACKTMP"-*' 0 1 2 3 15

# There will be more repacking strategies to come...
case ",$all_into_one," in
,,)
	args='--unpacked --incremental'
	;;
,t,)
	if [ -d "$PACKDIR" ]; then
		for e in `cd "$PACKDIR" && find . -type f -name '*.pack' \
			| sed -e 's/^\.\///' -e 's/\.pack$//'`
		do
			if [ -e "$PACKDIR/$e.keep" ]; then
				: keep
			else
				args="$args --unpacked=$e.pack"
				existing="$existing $e"
			fi
		done
		if test -n "$args" -a -n "$unpack_unreachable" -a \
			-n "$remove_redundant"
		then
			args="$args $unpack_unreachable"
		fi
	fi
	;;
esac

args="$args $local $quiet $no_reuse$extra"
names=$(git pack-objects --honor-pack-keep --non-empty --all --reflog $args </dev/null "$PACKTMP") ||
	exit 1
if [ -z "$names" ]; then
	if test -z "$quiet"; then
		echo Nothing new to pack.
	fi
fi
for name in $names ; do
	fullbases="$fullbases pack-$name"
	chmod a-w "$PACKTMP-$name.pack"
	chmod a-w "$PACKTMP-$name.idx"
	mkdir -p "$PACKDIR" || exit

	for sfx in pack idx
	do
		if test -f "$PACKDIR/pack-$name.$sfx"
		then
			mv -f "$PACKDIR/pack-$name.$sfx" \
				"$PACKDIR/old-pack-$name.$sfx"
		fi
	done &&
	mv -f "$PACKTMP-$name.pack" "$PACKDIR/pack-$name.pack" &&
	mv -f "$PACKTMP-$name.idx"  "$PACKDIR/pack-$name.idx" &&
	test -f "$PACKDIR/pack-$name.pack" &&
	test -f "$PACKDIR/pack-$name.idx" || {
		echo >&2 "Couldn't replace the existing pack with updated one."
		echo >&2 "The original set of packs have been saved as"
		echo >&2 "old-pack-$name.{pack,idx} in $PACKDIR."
		exit 1
	}
	rm -f "$PACKDIR/old-pack-$name.pack" "$PACKDIR/old-pack-$name.idx"
done

if test "$remove_redundant" = t
then
	# We know $existing are all redundant.
	if [ -n "$existing" ]
	then
		( cd "$PACKDIR" &&
		  for e in $existing
		  do
			case " $fullbases " in
			*" $e "*) ;;
			*)	rm -f "$e.pack" "$e.idx" "$e.keep" ;;
			esac
		  done
		)
	fi
	git prune-packed $quiet
fi

case "$no_update_info" in
t) : ;;
*) git-update-server-info ;;
esac
