/* sunos5-5.h

   System dependencies for Solaris 2.x (tested on 2.5 with gcc)... */

/*
 * Copyright (c) 2004-2005 by Internet Systems Consortium, Inc. ("ISC")
 * Copyright (c) 1996-2003 by Internet Software Consortium
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *   Internet Systems Consortium, Inc.
 *   950 Charter Street
 *   Redwood City, CA 94063
 *   <info@isc.org>
 *   http://www.isc.org/
 *
 * This software has been written for Internet Systems Consortium
 * by Ted Lemon in cooperation with Vixie Enterprises and Nominum, Inc.
 * To learn more about Internet Systems Consortium, see
 * ``http://www.isc.org/''.  To learn more about Vixie Enterprises,
 * see ``http://www.vix.com''.   To learn more about Nominum, Inc., see
 * ``http://www.nominum.com''.
 */

/* SunOS defines uint*_t and int*_t, but not u_int*_t.  */

#if defined(_SYS_INT_TYPES_H)
typedef uint8_t		u_int8_t;
typedef uint16_t	u_int16_t;
typedef uint32_t	u_int32_t;
#else /* Older SunOS has no idea what these things mean. */
typedef int8_t char
typedef int16_t short
typedef int32_t int	/* If _LP64, long is 64-bit, int is still 32. */
typedef u_int8_t unsigned char
typedef u_int16_t unsigned short
typedef u_int32_t unsigned int
#endif /* defined(_SYS_INT_TYPES_H) */

/* The jmp_buf type is an array on Solaris, so we can't dereference it
   and must declare it differently. */

#define jbp_decl(x)	jmp_buf x
#define jref(x)		(x)
#define jdref(x)	(x)
#define jrefproto	jmp_buf

#include <syslog.h>
#include <sys/types.h>
#include <sys/sockio.h>

#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/wait.h>
#include <signal.h>
#include <setjmp.h>
#include <limits.h>

extern int h_errno;

#include <net/if.h>
#include <net/if_arp.h>

/* Solaris 2.6 defines AF_LINK, so we need the rest of the baggage that
   comes with it, but of course Solaris 2.5 and previous do not. */
#if defined (AF_LINK)
#include <net/if_dl.h>
#endif

/*
 * Definitions for IP type of service (ip_tos)
 */
#define IPTOS_LOWDELAY          0x10
#define IPTOS_THROUGHPUT        0x08
#define IPTOS_RELIABILITY       0x04
/*      IPTOS_LOWCOST           0x02 XXX */

/* Solaris systems don't have /var/run, but some sites have added it.
   If you want to put dhcpd.pid in /var/run, define _PATH_DHCPD_PID
   in site.h. */
#ifndef _PATH_DHCPD_PID
#define _PATH_DHCPD_PID	"/etc/dhcpd.pid"
#endif
#ifndef _PATH_DHCLIENT_PID
#define _PATH_DHCLIENT_PID "/etc/dhclient.pid"
#endif
#ifndef _PATH_DHCRELAY_PID
#define _PATH_DHCRELAY_PID "/etc/dhcrelay.pid"
#endif

#if defined (__GNUC__) || defined (__SVR4)
/* Varargs stuff: use stdarg.h instead ... */
#include <stdarg.h>
#define VA_DOTDOTDOT ...
#define VA_start(list, last) va_start (list, last)
#define va_dcl
#else /* !__GNUC__*/
/* Varargs stuff... */
#include <varargs.h>
#define VA_DOTDOTDOT va_alist
#define VA_start(list, last) va_start (list)
#endif /* !__GNUC__*/

#define NEED_INET_ATON

#if defined (USE_DEFAULT_NETWORK)
# define USE_DLPI
# define USE_DLPI_PFMOD
#endif

#define USE_POLL

#define EOL	'\n'
#define VOIDPTR	void *

/* Time stuff... */

#include <time.h>

#define TIME time_t
#define GET_TIME(x)	time ((x))

#define HAVE_MKSTEMP

/* Solaris prior to 2.5 didn't have random().   Rather than being clever and
   using random() only on versions >2.5, always use rand() and srand(). */

#if SOLARIS_MAJOR == 5 && SOLARIS_MINOR < 5
#define random()	rand()
#define srandom(x)	srand(x)
#endif

/* Solaris doesn't provide an endian.h, so we have to do it. */

#if !defined (BIG_ENDIAN)
# define BIG_ENDIAN 1
#endif

#if !defined (BIG_ENDIAN)
# define LITTLE_ENDIAN 2
#endif

#if !defined (BYTE_ORDER)
# if defined (__i386) || defined (i386)
#  define BYTE_ORDER LITTLE_ENDIAN
# else
#  if defined (__sparc) || defined (sparc)
#   define BYTE_ORDER BIG_ENDIAN
#  else
@@@ ERROR @@@   Unable to determine byte order!
#  endif
# endif
#endif

#define ALIAS_NAMES_PERMUTED

#if SOLARIS_MAJOR == 5 && SOLARIS_MINOR < 7
typedef int socklen_t;
#endif

#ifdef NEED_PRAND_CONF
const char *cmds[] = {
	"/bin/ps -ef 2>&1",
	"/usr/ucb/netstat -an 2>&1",
	"/bin/df  2>&1",
	"/usr/bin/dig com. soa +ti=1 +retry=0 2>&1",
	"/usr/ucb/uptime  2>&1",
	"/usr/ucb/netstat -an 2>&1",
	"/bin/iostat  2>&1",
	NULL
};

const char *dirs[] = {
	"/tmp",
	"/var/tmp",
	".",
	"/",
	"/var/spool",
	"/var/adm",
	"/dev",
	"/var/mail",
	"/home",
	NULL
};

const char *files[] = {
	"/proc/self/status",
	"/var/adm/messages",
	"/var/adm/wtmp",
	"/var/adm/lastlog",
	NULL
};
#endif /* NEED_PRAND_CONF */
