/* 
 *
 * Copyright (C) 2003-2008 Sebastian Trueg <trueg@k3b.org>
 *
 * This file is part of the K3b project.
 * Copyright (C) 1998-2008 Sebastian Trueg <trueg@k3b.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */


#ifndef _K3B_CONTENTS_VIEW_H_
#define _K3B_CONTENTS_VIEW_H_

#include <qwidget.h>
#include <k3bthememanager.h>

namespace K3b {
    class ThemedHeader;
}


namespace K3b {
class ContentsView : public QWidget
{
    Q_OBJECT

public:
    virtual ~ContentsView();

protected:
    ContentsView( bool withHeader,
                     QWidget* parent = 0 );

    QWidget* mainWidget();
    void setMainWidget( QWidget* );
    void setTitle( const QString& );
    void setLeftPixmap( Theme::PixmapType );
    void setRightPixmap( Theme::PixmapType );

private:
    ThemedHeader* m_header;
    QWidget* m_centerWidget;
};
}

#endif
