#ifndef INC_config_hpp__
#define INC_config_hpp__

/**
 * <b>SOFTWARE RIGHTS</b>
 * <p>
 * ANTLR 2.6.0 MageLang Insitute, 1999
 * <p>
 * We reserve no legal rights to the ANTLR--it is fully in the
 * public domain. An individual or company may do whatever
 * they wish with source code distributed with ANTLR or the
 * code generated by ANTLR, including the incorporation of
 * ANTLR, or its output, into commerical software.
 * <p>
 * We encourage users to develop software with ANTLR. However,
 * we do ask that credit is given to us for developing
 * ANTLR. By "credit", we mean that if you use ANTLR or
 * incorporate any source code into one of your programs
 * (commercial product, research project, or otherwise) that
 * you acknowledge this fact somewhere in the documentation,
 * research report, etc... If you like ANTLR and have
 * developed a nice tool with the output, please mention that
 * you developed it using ANTLR. In addition, we ask that the
 * headers remain intact in our source code. As long as these
 * guidelines are kept, we expect to continue enhancing this
 * system and expect to make other tools available as they are
 * completed.
 * <p>
 * The ANTLR gang:
 * @version ANTLR 2.6.0 MageLang Insitute, 1999
 * @author Terence Parr, <a href=http://www.MageLang.com>MageLang Institute</a>
 * @author <br>John Lilley, <a href=http://www.Empathy.com>Empathy Software</a>
 * @author <br><a href="mailto:pete@yamuna.demon.co.uk">Pete Wells</a>
 */

/*
 * Just a simple configuration file to differentiate between the
 * various compilers used.
 */

/*
	Some compilers do not accept namespaces std:: for example.
	In this case, just define #define ANTLR_USE_NAMESPACE(_x_).

	See SunWorkShop 4.2 for example.
 */
#define ANTLR_USE_NAMESPACE(_x_) _x_::
#define ANTLR_USING_NAMESPACE(_x_) using namespace _x_;
#define ANTLR_BEGIN_NAMESPACE(_x_) namespace _x_ {
#define ANTLR_END_NAMESPACE }
#define ANTLR_C_USING(_x_)

#if defined(_MSC_VER) && !defined(__ICL) // Microsoft Visual C++

// This warning really gets on my nerves.
// It's the one about symbol longer than 256 chars, and it happens
// all the time with STL.
#pragma warning( disable : 4786 )

// Now, some defines for shortcomings in the MS compiler:

// Not allowed to put 'static const int XXX=20;' in a class definition
#define NO_STATIC_CONSTS
// Using vector<XXX> requires operator<(X,X) to be defined
#define NEEDS_OPERATOR_LESS_THAN
// No strcasecmp in the C library (so use stricmp instead)
// - Anyone know which is in which standard?
#define NO_STRCASECMP

#endif

#if defined(__ICL)
#define NO_STRCASECMP
#endif

//
// SunPro Compiler (Using OBJECTSPACE STL)
//
#ifdef __SUNPRO_CC

#if (__SUNPRO_CC >= 0x500)

#define NEEDS_OPERATOR_LESS_THAN
#define NO_TEMPLATE_PARTS

#else

#undef namespace
#define namespace


#if (__SUNPRO_CC == 0x420)

/* This code is specif to SunWspro Compiler 4.2, and will compile with
   the objectspace 2.1 toolkit for Solaris2.6 */
#define HAS_NOT_CASSERT_H
#define HAS_NOT_CSTRING_H
#define HAS_NOT_CCTYPE_H
#define HAS_NOT_CSTDIO_H
#define HAS_OSTREAM_H

/* #define OS_SOLARIS_2_6 
#define OS_NO_WSTRING 
#define OS_NO_ALLOCATORS 
#define OS_MULTI_THREADED 
#define OS_SOLARIS_NATIVE 
#define OS_REALTIME 
#define __OSVERSION__=5 
#define SVR4
*/

// ObjectSpace + some specific templates constructions with stl.
/* #define OS_NO_ALLOCATOR */

// This great compiler does not have the namespace feature.
#undef  ANTLR_USE_NAMESPACE
#define ANTLR_USE_NAMESPACE(_x_)
#undef ANTLR_USING_NAMESPACE
#define ANTLR_USING_NAMESPACE(_x_)
#undef ANTLR_BEGIN_NAMESPACE
#define ANTLR_BEGIN_NAMESPACE(_x_)
#undef ANTLR_END_NAMESPACE
#define ANTLR_END_NAMESPACE

#endif

#undef explicit
#define explicit

#define exception os_exception
#define bad_exception os_bad_exception

// Not allowed to put 'static const int XXX=20;' in a class definition
#define NO_STATIC_CONSTS
// Using vector<XXX> requires operator<(X,X) to be defined
#define NEEDS_OPERATOR_LESS_THAN

#endif

#endif

//
// Inprise C++ Builder 3.0
//
#ifdef __BCPLUSPLUS__

#define NO_TEMPLATE_PARTS
#define NO_STRCASECMP
#endif

#ifdef _AIX
#include <strings.h>
#endif

//
// Metrowerks Codewarrior
//
#ifdef __MWERKS__
#if (__MWERKS__ <= 0x2201)
#define NO_TEMPLATE_PARTS
#define ANTLR_REALLY_NO_STRCASECMP
#endif

#undef ANTLR_C_USING
#define ANTLR_C_USING(_x_)   using std:: ## _x_;
#endif

#endif //INC_config_hpp__
