/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.repository.modify.remove;

import java.beans.PropertyEditor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openrdf.http.webclient.properties.ResourcePropertyEditor;
import org.openrdf.http.webclient.properties.UriPropertyEditor;
import org.openrdf.http.webclient.properties.ValuePropertyEditor;
import org.openrdf.http.webclient.repository.modify.remove.RemovalSpecification;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

public class RemoveStatementsController
extends SimpleFormController {
    final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        HttpSession session = request.getSession();
        HTTPRepository repo = (HTTPRepository)session.getAttribute("openrdf-repository");
        binder.registerCustomEditor(Resource.class, (PropertyEditor)new ResourcePropertyEditor(repo.getValueFactory()));
        binder.registerCustomEditor(URI.class, (PropertyEditor)new UriPropertyEditor(repo.getValueFactory()));
        binder.registerCustomEditor(Value.class, (PropertyEditor)new ValuePropertyEditor(repo.getValueFactory()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) {
        this.logger.info("Removing statements...");
        String actionResult = "repository.modify.remove.statements.success";
        RemovalSpecification toRemove = (RemovalSpecification)command;
        HTTPRepository repo = (HTTPRepository)request.getSession().getAttribute("openrdf-repository");
        RepositoryConnection conn = null;
        try {
            conn = repo.getConnection();
            conn.remove(toRemove.getSubject(), toRemove.getPredicate(), toRemove.getObject(), toRemove.getContexts());
            conn.commit();
            this.logger.info("Remove committed.");
        }
        catch (RepositoryException e) {
            this.logger.warn("Unable to clear repository", (Throwable)e);
            actionResult = "repository.modify.remove.statements.failure";
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
            }
        }
        return new ModelAndView(this.getSuccessView(), "actionResult", (Object)actionResult);
    }
}

