/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.repository.query;

import java.beans.PropertyEditor;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.webclient.properties.RDFFormatPropertyEditor;
import org.openrdf.http.webclient.repository.query.ConstructQueryInfo;
import org.openrdf.http.webclient.repository.query.QueryFormController;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPGraphQuery;
import org.openrdf.repository.http.HTTPQueryEvaluationException;
import org.openrdf.repository.http.HTTPRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.rio.UnsupportedRDFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructQueryFormController
extends QueryFormController {
    final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws ServletException {
        binder.registerCustomEditor(RDFFormat.class, (PropertyEditor)new RDFFormatPropertyEditor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        ModelAndView result = null;
        HTTPRepository repo = (HTTPRepository)request.getSession().getAttribute("openrdf-repository");
        ConstructQueryInfo qInfo = (ConstructQueryInfo)command;
        String resultString = "";
        RepositoryConnection conn = null;
        try {
            conn = repo.getConnection();
            HTTPGraphQuery query = (HTTPGraphQuery)conn.prepareGraphQuery(qInfo.getQueryLanguage(), qInfo.getQueryString());
            query.setIncludeInferred(qInfo.isIncludeInferred());
            GraphQueryResult queryResult = null;
            try {
                queryResult = query.evaluate();
            }
            catch (HTTPQueryEvaluationException e) {
                if (e.isCausedByMalformedQueryException()) {
                    throw e.getCauseAsMalformedQueryException();
                }
                if (e.isCausedByRepositoryException()) {
                    throw e.getCauseAsRepositoryException();
                }
                if (e.isCausedByIOException()) {
                    throw e.getCauseAsIOException();
                }
                throw e;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                QueryResultIO.write(queryResult, qInfo.getResultFormat(), (OutputStream)out);
                resultString = new String(out.toByteArray(), qInfo.getResultFormat().getCharset().name());
            }
            catch (RDFHandlerException e) {
                e.printStackTrace();
            }
            catch (UnsupportedRDFormatException e) {
                e.printStackTrace();
            }
        }
        catch (RepositoryException e) {
            errors.reject("repository.error");
        }
        catch (MalformedQueryException e) {
            errors.rejectValue("queryString", "repository.query.error.malformed", (Object[])new String[]{e.getMessage()}, "Malformed query");
        }
        catch (QueryEvaluationException e) {
            errors.reject("repository.query.error.evaluation");
        }
        if (errors.hasErrors()) {
            result = this.showForm(request, response, errors, errors.getModel());
        } else {
            Map model = errors.getModel();
            model.put("queryinfo", qInfo);
            model.put("queryresult", resultString);
            result = new ModelAndView(this.getSuccessView(), model);
        }
        return result;
    }

    @Override
    protected Map<String, Object> referenceData(HttpServletRequest request) {
        Map<String, Object> result = super.referenceData(request);
        TreeMap<String, String> resultFormats = new TreeMap<String, String>();
        for (RDFWriterFactory factory : RDFWriterRegistry.getInstance().getAll()) {
            RDFFormat resultFormat = factory.getRDFFormat();
            resultFormats.put(resultFormat.getName(), resultFormat.getName());
        }
        result.put("resultFormats", resultFormats);
        return result;
    }
}

