/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra.factories;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.Datatype;
import org.openrdf.query.algebra.Lang;
import org.openrdf.query.algebra.MathExpr;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.Str;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.DatatypeColumn;
import org.openrdf.sail.rdbms.algebra.SqlCase;
import org.openrdf.sail.rdbms.algebra.SqlNull;
import org.openrdf.sail.rdbms.algebra.TrueValue;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;
import org.openrdf.sail.rdbms.algebra.base.SqlExprSupport;
import org.openrdf.sail.rdbms.exceptions.UnsupportedRdbmsOperatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypeExprFactory
extends QueryModelVisitorBase<UnsupportedRdbmsOperatorException> {
    protected SqlExpr result;

    public SqlExpr createDatatypeExpr(ValueExpr expr) throws UnsupportedRdbmsOperatorException {
        this.result = null;
        if (expr == null) {
            return new SqlNull();
        }
        expr.visit(this);
        if (this.result == null) {
            return new SqlNull();
        }
        return this.result;
    }

    @Override
    public void meet(Datatype node) {
        this.result = SqlExprSupport.sqlNull();
    }

    @Override
    public void meet(Lang node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.sqlNull();
    }

    @Override
    public void meet(MathExpr node) throws UnsupportedRdbmsOperatorException {
        boolean divide = node.getParentNode().equals((Object)MathExpr.MathOp.DIVIDE);
        ValueExpr left = node.getLeftArg();
        ValueExpr right = node.getRightArg();
        SqlCase sqlCase = new SqlCase();
        sqlCase.when(SqlExprSupport.in(SqlExprSupport.str(XMLSchema.DOUBLE), this.type(left), this.type(right)), SqlExprSupport.str(XMLSchema.DOUBLE));
        sqlCase.when(SqlExprSupport.in(SqlExprSupport.str(XMLSchema.FLOAT), this.type(left), this.type(right)), SqlExprSupport.str(XMLSchema.FLOAT));
        sqlCase.when(SqlExprSupport.in(SqlExprSupport.str(XMLSchema.DECIMAL), this.type(left), this.type(right)), SqlExprSupport.str(XMLSchema.DECIMAL));
        sqlCase.when(new TrueValue(), divide ? SqlExprSupport.str(XMLSchema.DECIMAL) : SqlExprSupport.str(XMLSchema.INTEGER));
        this.result = sqlCase;
    }

    @Override
    public void meet(Str node) throws UnsupportedRdbmsOperatorException {
        this.result = SqlExprSupport.sqlNull();
    }

    @Override
    public void meet(ValueConstant vc) {
        this.result = this.valueOf(vc.getValue());
    }

    @Override
    public void meet(Var var) {
        this.result = var.getValue() == null ? new DatatypeColumn(var) : this.valueOf(var.getValue());
    }

    @Override
    protected void meetNode(QueryModelNode arg) throws UnsupportedRdbmsOperatorException {
        throw SqlExprSupport.unsupported(arg);
    }

    private SqlExpr valueOf(Value value) {
        URI datatype;
        if (value instanceof Literal && (datatype = ((Literal)value).getDatatype()) != null) {
            return SqlExprSupport.str(datatype.stringValue());
        }
        return SqlExprSupport.sqlNull();
    }

    private SqlExpr type(ValueExpr expr) throws UnsupportedRdbmsOperatorException {
        return this.createDatatypeExpr(expr);
    }
}

