% This is the file `hyphen.fr'.
%
% It contains the same hyphenation patterns as `frhyph.tex'.  Here the
% copyright message:
%
%    frhyph.tex % French hyphenation patterns
%   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    This file is available for free and can used and redistributed
%    asis for free. Modified versions should have another name.
%   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   % \message{frhyph.tex - French hyphenation patterns (V2.11) <2002/01/16>}
%
% Please check the original file for more details.
%
% To make the patterns workable with groff, all accent macros in the
% patterns have been converted to use latin-9 characters directly
% (this is, the oe ligature `' is used), and everything except the
% \pattern command has been discarded since it isn't needed (and groff
% doesn't understand this stuff anyway).
%
%\patterns{
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%*
2'2
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%a
.a4
'a4
.4
'4
ab2h % df-bg 1998/02/07 for abhorrer
                    .ab3ra
                    'ab3ra
ad2h % df-bg 1998/02/07 for adh\`esion & co
                    a12dre
                    .ae3s4ch
                    'ae3s4ch
                    1alcool
                    a2l1algi
                    .amino1a2c
                    'amino1a2c
                    .ana3s4tr
                    'ana3s4tr
                    1a2nesthsi
                    .anti1a2
                    'anti1a2
                    .anti1e2
                    'anti1e2
                    .anti12
                    .anti2enne
                    'anti2enne
                    'anti12
                    .anti1s2
                    'anti1s2
                    .apo2s3ta
                    'apo2s3ta
                    apo2s3tr
                    archi12pis
                    .as2ta
                    'as2ta
                    a2s3tro
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%b
1ba
1b
                    .bai2se3main % hyphen disappeared from french  5/2/94
1be
1b
1b
1b
4be.
4bes.
2bent. % mute syllable: tombent (df) 22/02/94
1bi
1b
                    .bi1a2c
                    .bi1a2t % like .tri1a2t for tri-athlon bg 12/27/93
                    .bi1au
                    .bio1a2
                    .bi2s1a2
                    .bi1u2
1b2l
4ble.
4bles.
2blent. % mute syllable: troublent (df) 28/02/94
1bo
1b
1b2r
4bre.
4bres.
2brent. % mute syllable: palabrent (df) 28/02/94
1bu
1b
1by
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%c
1
1ca
1c
ca3ou3t2 % for caoutchou... added 3/1/94 df-bg
1ce
1c
1c
1c
4ce.
4ces.
% words ending with -cent (df) 22/02/94
        2cent.
      ja3cent.
      ac3cent.
     3cent.
  munifi3cent.
  rti3cent.
privatdo3cent.
    inno3cent.
      es3cent.
 acquies4cent.
      is3cent.
   immis4cent.
%
.ch4
1c2h
4ch.
2chb
4che.
4ches.
2chent. % mute syllable: touchent (df) 22/02/94
                    .ch2vre3feuille % hyphen disappeared from french 5/2/94
2chg
ch2l
4chle.
4chles.
                    chlo2r3a2c
                    chlo2r32t
2chm
2chn
2chp
ch2r
4chre.
4chres.
2chs
2cht
2chw
1ci
1c
                    .ci2s1alp
1c2k
4ck.
2ckb
4cke.
4ckes.
2ckent. % mute syllable: stockent (df) 22/02/94
2ckf
2ckg
2ck3h
2ckp
2cks
2ckt
1c2l
4cle.
4cles.
2clent. % mute syllable: encerclent (df) 28/02/94
1co
1c
                    co1acc
                    co1acq
                    co1a2d
                    co1ap
                    co1ar
                    co1assoc
                    co1assur
                    co1au
                    co1ax
1c0 % final zero essential to terminate cs
                    co12
                    co1ef
                    co1en
                    co1ex
                    .con4  % missing from nb list
                    .cons4 % missing from nb list
                    .contre1s2c
                    .contre3matre % hyphen disappeared from french 5/2/94
                    co2nurb
                    .co1o2
                    .co2o3lie
1c2r
4cre.
4cres.
2crent. % mute syllable: massacrent (df) 28/02/94
1cu
1c
1cy
.cul4 % -- as .con4 .cons4 (march 92)
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%d
1d'
1da
1d
                    .dacryo1a2
d1d2h
1de
1d
1d
1d
4de.
4des.
% words ending with -dent (df) 22/02/94
      2dent.
dca3dent.
   3dent.
   cci3dent.
  inci3dent.
 confi3dent.
   tri3dent.
 dissi3dent.
 chien3dent.
   .ar3dent.
  impu3dent.
   pru3dent.
%
                    .d1a2
                    .d1io
                    .d1o2
                    .d2s % originaly in JD file
                    %.d\'e2s1a2 removed 09/17/92 because wrong for the
                    % original JD 500 words test
                    .d3s2a3cr
                    .ds2a3m % .d\'es2a2mi introduced 09/17/92 bec. i
                               % can't see why d\'esamidonner ran in JD.
                               % Moved to .d\'es2a3m df 12/27/93.
                    .d3s2a3tell
                    .d3s2astr
                    .d3s2c % 1 moved 3 due to .d\'e2s 09/17/92
                    %.d\'e2s1e2 removed 09/17/92 because wrong for the
                    % original JD 500 words test
                    .d2s12
                    .d3s23gr
                    .d3s2ensib
                    .d3s2ert
                    .d3s2exu
                    %.d\'e2s3h removed 09/17/92 because wrong for the
                    % original JD 500 words test
                    .d2s1i2
                    .d3s2i3d
                    .d3s2i3gn
                    .d3s2i3li
                    .d3s2i3nen
                    .d3s2invo
                    .d3s2i3r
                    .d3s2ist
                    %.d\'e2s1o2 removed 09/17/92 because wrong for the
                    % original JD 500 words test
                    .d3s2o3d
                    .d2s10 % final zero essential to terminate cs
                    .d3s2o3l
                    .d3s2o3pil
                    .d3s2orm
                    .d3s2orp
                    .d3s2oufr
                    .d3s2p % 1 moved 3 due to .d\'e2s 09/17/92
                    .d3s2t % 1 moved 3 due to .d\'e2s 09/17/92
                    .d2s1u2n
                    3d2hal
                    3d2houd
1di
1d
                    di2s3cop
                    .di1a2c
                    .di1a2cid
                    .di1ald
                    .di1a2mi
                    .di1a2tom
                    .di1e2n
                    .di2s3h
2dlent. % mute syllable: jodlent (df) 28/02/94
1do
1d
1d2r
4dre.
4dres.
2drent. % mute syllable: engendrent (df) 28/02/94
d1s2
1du
1d
1dy
                    .dy2s3
                    .dy2s1a2
                    .dy2s1i2
                    .dy2s1o2 % missing from nb list
                    .dy2s1u2
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%e
.e4
'e4
.4
'4
.4
'4
.4
'4
d2hi % df-bg 1998/02/07 for r\'edhibitoire
                    12drie
                    12drique
                    12lectr
                    12lment
                    .en1a2
                    'en1a2
                    12nerg
                    e2n1i2vr
                    .en1o2
                    'en1o2
                    pi2s3cop
                    pi3s4cope
                    e2s3cop
                    .eu2r1a2
                    'eu2r1a2
                    eu1s2tat
                    extra1
                    extra2c
                    extra2i
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%f
1fa
1f
1fe
1f
1f
1f
4fe.
4fes.
2fent. % mute syllable: agrafent chauffent (df) 22/02/94
%
1fi
1f
1f2l
4fle.
4fles.
2flent. % mute syllable: gonflent (df) 28/02/94
1fo
1f
1f2r
4fre.
4fres.
2frent. % mute syllable: balafrent (df) 28/02/94
f1s2
1fu
1f
1fy
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%g
1ga
1g
1ge
1g
1g
1g
4ge.
4ges.
% words ending with -gent (df) 22/02/94
       2gent.
   r3gent.
  entre3gent.
   indi3gent.
   dili3gent.
intelli3gent.
  indul3gent.
    tan3gent.
    rin3gent.
 contin3gent.
    .ar3gent.
    'ar3gent.
    ser3gent.
    ter3gent.
rsur3gent.
%
1g2ha
1g2he
1g2hi
1g2ho
1g2hy
1gi
1g
1g2l
4gle.
4gles.
2glent. % mute syllable: meuglent (df) 28/02/94
    1g2n
  'a2g3nat     % (df) 16/01/02
  .a2g3nat     % (df) 16/01/02
   a2g3nos     % (df) 16/01/02 (pattern dia2g3n deleted)
  co2g3niti    % (df) 16/01/02
  'i2g3n    % (df) 16/01/02
  .i2g3n    % (df) 16/01/02
  'i2g3ni      % (df) 16/01/02
  .i2g3ni      % (df) 16/01/02
 .ma2g3nicide  % (df) 16/01/02
 .ma2g3nificat % (df) 16/01/02
 .ma2g3num     % (df) 16/01/02
   o2g3nomoni  % (df) 16/01/02
   o2g3nosi    % (df) 16/01/02
.pro2g3nath    % (df) 16/01/02
  pu2g3nable   % (df) 16/01/02
  pu2g3nac     % (df) 16/01/02
.sta2g3n
.syn2g3nath    % (df) 16/01/02
  wa2g3n
4gne.
4gnes.
2gnent. % mute syllable: accompagnent (df) 28/02/94
1go
1g
1g2r
4gre.
4gres.
2grent. % mute syllable: immigrent (df) 28/02/94
1gu
1g
g1s2
4gue.
4gues.
% words ending with -guent (df) 22/02/94
   2guent.
.on3guent.
'on3guent.
%
1gy
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%h
1ha
1h
1he
1h
1h
1h
                    hmi1
                    hmo1p2t
4he.
4hes.
1hi
1h
1ho
1h
1hu
1h
1hy
                    hypera2
                    hypere2
                    hyper2
                    hyperi2
                    hypero2
                    hypers2
                    hype4r1
                    hyperu2
                    hypo1a2
                    hypo1e2 % missing from nb list
                    hypo12
                    hypo1i2
                    hypo1o2
                    hypo1s2
                    hypo1u2
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%i
.i4
'i4
.4
'4
                    i1algi
                    i1arthr
                    i12dre
% ill patterns missing from nb list
    il2l 
   cil3l
  rcil4l
  ucil4l
 vacil4l
   gil3l
   hil3l
   lil3l
     l3lion
   mil3l
   mil4let
mil4l
 semil4l
  rmil4l
 armil5l
 capil3l
 papil3la
 papil3le
 papil3li
 papil3lom
 pupil3l
 piril3l
 thril3l
 cyril3l
 ibril3l
 pusil3l
 .stil3l
distil3l
instil3l
fritil3l
boutil3l
 vanil3lin
 vanil3lis
   vil3l
  avil4l
chevil4l
 uevil4l
  uvil4l
   xil3l
% end of ill patterns
                    1informat % missing from nb list
                    .in1a2
                    'in1a2
                    .in2a3nit
                    'in2a3nit
                    .in2augur
                    'in2augur
                    .in1e2
                    'in1e2
                    .in12
                    'in12
                    .in2effab % missing from nb list
                    'in2effab
                    .in23lucta
                    'in23lucta
                    .in23narra
                    'in23narra
                    .in2ept
                    'in2ept
                    .in2er
                    'in2er
                    .in2exora % missing from nb list
                    'in2exora
                    .in1i2
                    'in1i2
                    .in2i3miti
                    'in2i3miti
                    .in2i3q
                    'in2i3q
                    .in2i3t
                    'in2i3t
                    .in1o2
                    'in1o2
                    .in2o3cul
                    'in2o3cul
                    .in2ond
                    'in2ond
                    .in1s2tab
                    'in1s2tab
                    'inte4r3
                    .intera2
                    'intera2
                    .intere2
                    'intere2
                    .inter2
                    'inter2
                    .interi2
                    'interi2
                    .intero2
                    'intero2
                    .inte4r3
                    .interu2
                    'interu2
                    .inters2
                    'inters2
                    .in1u2
                    'in1u2
                    .in2uit
                    'in2uit
                    .in2u3l
                    'in2u3l
                    io1a2ct
                    i1oxy
                    i1s2tat
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%j
1j
2jk
4je.
4jes.
2jent. % mute syllable: gal\`ejent (df) 22/02/94
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%k
1ka
1k
1ke
1k
1k
1k
4ke.
4kes.
2kent. % mute syllable: jerkent (df) 22/02/94
1k2h
4kh.
.kh4
1ki
1k
1ko
1k
1k2r
1ku
1k
1ky
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%l
1la
1l
1l
                    la2w3re
1le
1l
1l
1l
4le.
4les.
% words ending with -lent (df) 22/02/94
        2lent.
     .ta3lent.
     iva3lent.
quiva4lent.
  monova3lent.
  polyva3lent.
      re3lent.
     .do3lent.
    indo3lent.
    inso3lent.
   turbu3lent.
   succu3lent.
  fcu3lent.
   trucu3lent.
     opu3lent.
   corpu3lent.
      ru3lent.
   sporu4lent.
%
1li
1l
1lo
1l
l1s2t
1lu
1l
1ly
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%m
1ma
1m
                    .ma2c3k
                    .macro1s2c
                    .ma2l1a2dres
                    .ma2l1a2dro
                    .ma2l1ais
                    .ma2l1ap
                    .ma2l1a2v
                    .ma2l1en
                    .ma2l1int
                    .ma2l1oc
                    .ma2l1o2d
                    .ma2r1x % nb (jbb: ?)
1me
1m
1m
1m
                    .m2g1oh
                    .m2sa % missing from nb list
                    .m3san % missing from nb list
                    .m2s1es
                    .m2s1i
                    .m2s1u2s
                    .mta1s2ta
4me.
4mes.
% words ending with -ment (df) 22/02/94
      2ment.
       da2ment.
       fa2ment.
   amalga2ment.
      cla2ment.
       ra2ment.
tempra3ment.
       ta2ment.
    testa3ment.
      qua2ment.
      2ment.
   car2ment.
 diaphrag2ment.
     ryth2ment.
       ai2ment.
      rai3ment.
   ab2ment.
    ci2ment.
     vidi2ment.
    subli2ment.
    li2ment.
     reli2ment.
       mi2ment.
      ani2ment.
     veni2ment.
       ri2ment.
  dtri3ment.
    nutri3ment.
     inti2ment.
     esti2ment.
        l2ment.
     flam2ment.
     gram2ment.
     .gem2ment.
       om2ment.
     .com3ment.
      2ment.
    slalo2ment.
     chro2ment.
       to2ment.
       ar2ment.
     .sar3ment.
       er2ment.
  antifer3ment.
     .ser3ment.
      fir2ment.
       or2ment.
       as2ment.
       au2ment.
    cu2ment.
       fu2ment.
       hu2ment.
    fichu3ment.
      llu2ment.
      plu2ment.
      bou2ment.
      bru2ment.
       su2ment.
       tu2ment.
%
1mi
1m
                    .milli1am
                    1m2nmo
                    1m2ns
                    1m2nsi
1mo
1m
1m0 % final zero essential to terminate cs
                    .mono1a2
                    .mono1e2
                    .mono12
                    .mono1i2
                    .mono12d
                    .mono1o2
                    .mono1u2
                    .mono1s2
                    mon2t3ral % missing from nb list
m1s2
1mu
1m
1my
                    moye2n12g
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%n
1na
1n
1ne
1n
1n
1n
4ne.
4nes.
% words ending with -nent (df) 22/02/94
          2nent. % fric-tionnent - syllable muette - bg 27/12/93
    rma3nent.
      imma3nent.
     perma3nent.
    .mi3nent.
prmi3nent.
  promi3nent.
  surmi3nent.
      immi3nent.
     conti3nent.
     perti3nent.
     absti3nent.
%
1ni
1n
1no
1n
1n0 % final zero essential to terminate cs
                    .no2n1obs
1nu
1n
                    n3s2at.
                    n3s2ats.
n1x
1ny
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%o
.o4
'o4
'4
.4
%'\"o2 % mjf % deleted 3/1/94 df-bg
                    o2b3long
                    1octet % missing from nb list
                    o1d2l
                    o12dre
                    o1ioni
                    ombud2s3
                    omni1s2
                    o1s2tas
                    o1s2tat
                    o1s2tro
                    o1s2tim
                    o1s2tom
                    o1s2trad
                    o1s2tratu
                    o1s2triction
                    .oua1ou
                    'oua1ou
                    .ovi1s2c
                    'ovi1s2c
                    oxy1a2
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%p
1pa
1p
                    palo12
                    .pa2n1a2f
                    .pa2n1a2m
                    .pa2n1a2ra
                    .pa2n1is
                    .pa2n1o2ph
                    .pa2n1opt
                    .pa2r1a2che
                    .pa2r1a2ch
                    .para1s2
                    .pa2r3h
1pe
1p
1p
1p
4pe.
4pes.
% words ending with -pent (df) 22/02/94
   2pent.
 re3pent.
.ar3pent.
'ar3pent.
ser3pent.
%
                    .pen2ta % pent- or penta- but never pen-ta bg 12/27/93
                    per3h
                    p2nul % p\'e2n1ul moved back 09/17/92 to JD def.
                    .pe4r
                    .per1a2
                    .per1e2
                    .per12
                    .per1i2
                    .per1o2
                    .per1u2
                    p1r22q % 2r1 moved 09/17/92 to 1r2(it was a typo)
                    .pri1os
                    .pri1s2
                    .pri2s3s
                    .pri2s3ta
                    .pri1u2
1p2h
.ph4
4ph.
                    .phalan3s2t
4phe.
4phes.
2phent. % mute syllable: triomphent (df) 22/02/94
ph2l
4phle.
4phles.
2phn
                    photo1s2
ph2r
4phre.
4phres.
2phs
2pht
                    3ph2tal
                    3ph2tis
%%%% Here is an example of a pb involving phonetic and etymologic patterns 5/94
%%%%                .phyto3ph2 % originaly, but wrong for phy-toph-thora   9/92
%%%%                .phy2topha % for -pharmacie but wrong for phyto-biol.. 5/94
1pi
1p
1p2l
4ple.
4ples.
2plent. % mute syllable: accouplent (df) 28/02/94
                    .pluri1a
                    1p2n
                    1p2neu
1po
1p
                    po1astre
                    poly1a2
                    poly1e2
                    poly12
                    poly12
                    poly1i2
                    poly1o2
                    poly1s2
                    poly1u2
                    .pon2tet % JD hypenated it asis 09/17/92, exception
                    .pos2t3h
                    .pos2t1in
                    .pos2t1o2
                    .pos2t3r
                    .post1s2
1p2r
4pre.
4pres.
2prent. % mute syllable: empourprent (df) 28/02/94
                    .pr1a2
                    .pr2a3la % missing from nb list
                    .pr2au
                    .pr12
                    .pr1e2
                    .pr1i2
                    .pr1o2
                    .pr1u2
                    .pr1s2
                    .pro12
                    .pro1s2c
                    pro2s3tat
                    .prou3d2h
                    1p2sych
                    .psycho1a2n
                    1p2tr
                    1p2tr
1pu
                    .pud1d2l
1p
1py
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%q
1q
4que.
4ques.
% words ending with -quent (df) 22/02/94
        2quent.
     3quent.
   lo3quent.
grandilo3quent.
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%r
1ra
1r
                    radio1a2 % missing from nb list
1re
1r
1r
1r
                    .r1a2
                    .r2a3le
                    .r2a3lis
                    .r2a3lit
                    .r2aux
                    .r12
                    .r1e2
                    .r2el
                    .r2er
                    .r2r
                    .r1i2
                    .r2i3fi
                    .r1o2
                    .re1s2
                    .re2s3cap
                    .re2s3cisi % for res-cision  09/17/92 (missing from nb)
                    .re2s3ciso % for res-cisoire 09/17/92(missing from nb)
                    .re2s3cou
                    .re2s3cri
                    .re2s3pect
                    .re2s3pir
                    .re2s3plend
                    .re2s3pons
                    .re2s3quil
                    .re2s3s
                    .re2s3t
                    .re3s4tab
                    .re3s4tag
                    .re3s4tand
                    .re3s4tat
                    .re3s4tn
                    .re3s4tr
                    .re3s4tim
                    .re3s4tip
                    .re3s4toc
                    .re3s4top
                    .re3s4tr
                    .re4s5trein
                    .re4s5trict
                    .re4s5trin
                    .re3s4tu
                    .re3s4ty
                    .ru2 %.r\'e1u2 % pattern rejected 12/2/92
                            % (don't hyphenate as r\'e-union nor r\'eu-nion)
                    .r2uss
                    .rtro1a2
4re.
4res.
% words ending with -rent (df) 22/02/94
       2rent. % es-p\`erent - syllable muette - bg 27/12/93
    .pa3rent.
   appa3rent.
transpa3rent.
    3rent.
    tor3rent.
    cur3rent.
%
1r2h
4rhe.
4rhes.
                    2r3heur
                    2r3hydr
1ri
1r
1ro
1r
1ru
1r
1ry
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%s
1sa
1s
.sch4
                    1s2caph
                    1s2clr
                    1s2cop
 1s2ch
e2s3ch
i2s3ch
i2s3chia
i2s3chio
4sch.
4sche.
4sches.
2schs
1se
1s
1s
1s
                    sesqui1a2
4se.
4ses.
% words ending with -sent (df) 22/02/94
     2sent. % massent - syllable muette - bg 27/12/93
   ab3sent.
pr3sent.
 .res3sent.
%
.seu2le % jbb
.sh4
1s2h
4sh.
4she.
4shes.
2shent. % mute syllable: smashent (df) 22/02/94
2shm
                    2s3hom
2shr
2shs
1si
1s
                    1s2lav
                    1s2lov
1so
1s
1s0 % final zero essential to terminate cs
                    1s2patia
                    1s2perm
                    1s2por
                    1s2phr
                    1s2phr
                    1s2piel
                    1s2piros
                    1s2tandard
                    1s2tein
                    stro1s2
                    1s2tigm
                    1s2tock
                    1s2tomos
                    1s2troph
                    1s2tructu
                    1s2tyle
1su
1s
                    .su2b1a2
                    .su3b2alt
                    .su2b12
                    .su3b23r
                    .su2b1in
                    .su2b3limin
                    .su2b3lin
                    .su2b3lu
                    sub1s2
                    .su2b1ur
                    supero2
                    supe4r1
                    supers2
                    .su2r1a2
                    su3r2ah
                    .su3r2a3t
                    .su2r1e2
                    .su3r2eau
                    .su3r2ell
                    .su3r2et
                    .su2r12
                    .su2r3h
                    .su2r1i2m
                    .su2r1inf
                    .su2r1int
                    .su2r1of
                    .su2r1ox
1sy
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%t
1ta
1t
1t
                    tachy1a2
                    tchin3t2
1te
1t
1t
1t
                    tl1e2
                    tl1i2
                    tl1o2b
                    tl1o2p
                    tl1s2
4te.
4tes.
% words ending with -tent (df) 22/02/94
        2tent. % mentent - syllable muette - bg 27/12/93
     .la3tent.
     .pa3tent.
 comp3tent.
   ni3tent.
 mcon3tent.
  omnipo3tent.
ventripo3tent.
quipo3tent.
    impo3tent.
     mit3tent.
%
.th4
1t2h
4th.
4the.
4thes.
                    thermo1s2
                    2t3heur
2thl % th2l  was wrong for ...ath-lon (jd said 2thl) df 12/27/93
2thm
2thn
th2r
4thre.
4thres.
2ths
1ti
1t
1to
1t
1t2r
                    tran2s1a2
                    tran3s2act
                    tran3s2ats
                    tran2s3h
                    tran2s1o2
                    tran2s3p
                    tran2s1u2
4tre.
4tres.
2trent. % mute syllable: infiltrent (df) 28/02/94
                    .tri1a2c
                    .tri1a2n
                    .tri1a2t
                    .tri1o2n
                    t1t2l
1tu
1t
tung2s3
1ty
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%u
.u4
'u4
.4
'4
                    uni1o2v
                    uni1a2x
                    u2s3tr
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%v
1va
1v
1ve
1v
1v
1v
                    vlo1s2ki
4ve.
4ves.
% words ending with -vent (df) 22/02/94
     2vent.
conni3vent.
 .sou3vent.
%
1vi
1v
1vo
1v
                    vol2t1amp
1v2r
4vre.
4vres.
2vrent. % mute syllable: recouvrent (df) 28/02/94
1vu
1v
1vy
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%w
1wa
1we
4we.
4wes.
2went. % mute syllable: interviewent (df) 22/02/94
1wi
1wo
1wu
1w2r
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%x
2xent. % mute syllable:  malaxent (df) 22/02/94
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%y
.y4
'y4
                    y1asth
                    y1s2tom
                    y1algi
%-------------------%-----------------------%
% phonetic patterns % etymological patterns %
%-------------------%-----------------------%
%%z
1za
1ze
1z
1z
4ze.
4zes.
% words ending with -zent (df) 22/02/94
        2zent.
privatdo3zent.
%
1zi
1zo
1zu
1zy
}

\endinput

% Local Variables:
% coding: latin-9
% End:
%
% End of file `hyphen.fr'.
