/* +-------------------------------------------------------------------+ */
/* | Copyright 1992, 1993, David Koblas (koblas@netcom.com)            | */
/* |                                                                   | */
/* | Permission to use, copy, modify, and to distribute this software  | */
/* | and its documentation for any purpose is hereby granted without   | */
/* | fee, provided that the above copyright notice appear in all       | */
/* | copies and that both that copyright notice and this permission    | */
/* | notice appear in supporting documentation.  There is no           | */
/* | representations about the suitability of this software for        | */
/* | any purpose.  this software is provided "as is" without express   | */
/* | or implied warranty.                                              | */
/* |                                                                   | */
/* +-------------------------------------------------------------------+ */

/* $Id: fontOp.c,v 1.17 2005/03/20 20:15:32 demailly Exp $ */

#ifdef __VMS
#define XtDisplay XTDISPLAY
#define XtWindow XTWINDOW
#endif

#include <math.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/extensions/Xrender.h>
#include <X11/Xft/Xft.h>
#include "xpaint.h"
#include "Paint.h"
#include "PaintP.h"
#include "graphic.h"
#include "misc.h"
#include "ops.h"
#include "protocol.h"

static Atom targetAtom, selectionAtom;

#define	DELAY	500

typedef struct {
    unsigned long pixel;
    char * xft_name;
    double x, y;
    char ch;
} Replay;

typedef struct {
    XtIntervalId id;
    Boolean typing;
    Boolean state;
    double startX, startY, curX, curY;
    Widget w;
    Replay * replay;
    int replay_length;
    char *sptr;
    int maxStrLen;
    char *str;
    Drawable drawable;
    GC gc, gcx;
} LocalInfo;

static void addString(Widget, LocalInfo *, int, char *);

static void 
cursor(LocalInfo * l, Boolean flag)
{
    static int zoom0 = 0;
    int zoom; 
    static int x, y, xp, yp;

    if (l->w == None)
	return;

    XtVaGetValues(l->w, XtNzoom, &zoom, NULL);
    if (zoom != zoom0) l->state = False;
    zoom0 = zoom;
    
    if (l->state == False) {
        if (!Global.xft_font) return;
        if (zoom>0) {
	    x = (int)((l->curX + Global.xft_descent*sin(Global.xft_rot))*zoom);
	    y = (int)((l->curY + Global.xft_descent*cos(Global.xft_rot))*zoom);
	    xp = (int)((l->curX - Global.xft_ascent*sin(Global.xft_rot))*zoom);
	    yp = (int)((l->curY - Global.xft_ascent*cos(Global.xft_rot))*zoom);
	} else {
	    x = (int)((l->curX + Global.xft_descent*sin(Global.xft_rot))/(-zoom));
	    y = (int)((l->curY + Global.xft_descent*cos(Global.xft_rot))/(-zoom));
	    xp = (int)((l->curX - Global.xft_ascent*sin(Global.xft_rot))/(-zoom));
	    yp = (int)((l->curY - Global.xft_ascent*cos(Global.xft_rot))/(-zoom));
	}
    }
    if (flag || l->state) {
	XDrawLine(XtDisplay(l->w), XtWindow(l->w), l->gcx, x, y, xp, yp);
        l->state = !l->state;
    } else
	l->state = False;
}

static void 
flash(LocalInfo * l)
{
    cursor(l, True);
    l->id = XtAppAddTimeOut(XtWidgetToApplicationContext(l->w),
		      DELAY, (XtTimerCallbackProc) flash, (XtPointer) l);
}

static void 
gotSelection(Widget w, LocalInfo * l, Atom * selection, Atom * type,
	     XtPointer value, unsigned long *len, int *format)
{
    if (!l->typing)
	return;

    if (len == 0 || value == NULL)
	return;

    switch (*type) {
    case XA_STRING:
	addString(w, l, *len, (char *) value);
	break;
    }
    XtFree((XtPointer) value);
}

static int
CheckReplay(LocalInfo *l, char *name)
{
}

static void
FreeReplay(LocalInfo *l)
{
    int j, k, found;

    if (!l->replay || !l->replay_length) return;

    for (j=l->replay_length-1; j>=0; j--) {
        found = 0;
        for (k=0; k<j; k++) {
	    if (l->replay[k].xft_name == l->replay[j].xft_name) {
	        found = 1;
                break;
	    }
	}
	if (!found) free(l->replay[j].xft_name);
    }

    if (l->replay) free(l->replay);
    l->replay = NULL;
    l->replay_length = 0;
}

static void 
motion(Widget w, LocalInfo * l, XButtonEvent * event, OpInfo * info)
{
}

static void 
press(Widget w, LocalInfo * l, XButtonEvent * event, OpInfo * info)
{
    if (event->type == ButtonRelease) {
        if (Global.popped_up)
            PopdownMenusGlobal();
        event->type = None;
        return;
    }

    if (event->button == Button3) return;

    if (event->button == Button1) {
	cursor(l, False);

	l->w = w;
	l->typing = True;
	l->gc = info->first_gc;
        FreeReplay(l);

	l->startX = l->curX = info->x + Global.xft_descent * sin(Global.xft_rot) + 0.5;
	l->startY = l->curY = info->y + Global.xft_descent * cos(Global.xft_rot) + 0.5;

	l->sptr = l->str;

	if (l->id == (XtIntervalId) NULL)
	    flash(l);

	UndoStartPoint(w, info, l->curX, l->curY);
	if (info->surface == opPixmap)
	    l->drawable = info->drawable;

    } else if (event->button == Button2) {
	XtGetSelectionValue(w, selectionAtom, targetAtom,
			    (XtSelectionCallbackProc) gotSelection,
                            (XtPointer) l, event->time);
    }
}

static void 
key(Widget w, LocalInfo * l, XKeyEvent * event, OpInfo * info)
{
    char buf[21];
    KeySym keysym;
    int len;

    if (l->w == None)
	return;

    if ((len = XLookupString(event, buf, sizeof(buf) - 1, &keysym, NULL)) == 0)
	return;

    l->gc = info->first_gc;
    l->drawable = info->drawable;
    addString(w, l, len, buf);
}

void
PwUpdateFromLast(Widget w, XRectangle * rect)
{
    Pixmap pix;
    PaintWidget pw = (PaintWidget) w;
    Pixmap draw = GET_PIXMAP(pw);
    int y, offset;

    if (pw->paint.paint != None)
	pw = (PaintWidget) pw->paint.paint;

    pix = pw->paint.undo->alphapix.pixmap;

    XCopyArea(XtDisplay(w), pix, draw, pw->paint.gc,
	      rect->x, rect->y, rect->width, rect->height,
	      rect->x, rect->y);

    if (pw->paint.current.alpha && pw->paint.undo->alphapix.alpha) {
        for (y = rect->y; y < rect->y + rect->height; y++) {
	    offset = rect->x + y*pw->paint.drawWidth;
	    memcpy(pw->paint.current.alpha + offset,
                   pw->paint.undo->alphapix.alpha + offset,
                   rect->width);
	}
    }

    PwUpdate(w, rect, True);
}

static void 
addString(Widget w, LocalInfo * l, int len, char *buf)
{
    Display *dpy = XtDisplay(w);
    PaintWidget pw = (PaintWidget) w;
    XftDraw *draw = NULL, *drawp = NULL;
    XGlyphInfo extents = {};
    XftColor color;
    XftFont *font;
    XRenderColor xre_color;
    Pixmap pixmap;
    XColor xcol;
    Colormap cmap;
    Pixel fg;
    GC gc;
    int i, j, k, width, height, depth, zoom, found;
    double rad, dx, dy;
    XRectangle rect;
    char *ptr;

    if (len != 0)
	cursor(l, False);
    for (i = 0; i < len; i++) {
	if (l->sptr == l->str + l->maxStrLen - 5) {
	    int delta = l->sptr - l->str;
	    l->maxStrLen += 128;
	    l->str = (char *) XtRealloc((XtPointer) l->str, l->maxStrLen);
	    l->sptr = l->str + delta;
	}
	if (buf[i] == '\n' || buf[i] == '\r') {
	    if (!Global.xft_font || !Global.xft_name) continue;
            j = l->replay_length;
            ++l->replay_length;
            l->replay = 
	        (Replay *) realloc(l->replay, l->replay_length*sizeof(Replay));

            l->replay[j].ch = '\n';
            l->replay[j].x = l->curX;
            l->replay[j].y = l->curY;

	    l->startX += Global.xft_height*sin(Global.xft_rot)*Global.xft_linespacing;
	    l->startY += Global.xft_height*cos(Global.xft_rot)*Global.xft_linespacing; 

	    l->curX = l->startX;
	    l->curY = l->startY;
            l->replay[j].xft_name = (char *)xmalloc(2+2*sizeof(double));
            l->replay[j].xft_name[0] = '\0';
            memcpy(l->replay[j].xft_name+2, &l->startX, sizeof(double));
            memcpy(l->replay[j].xft_name+2+sizeof(double), 
                   &l->startY, sizeof(double));
	    *l->sptr++ = '\n';
	} else if (buf[i] == 0x08 || buf[i] == 0x7f) {
            StateSetBusy(True);
            if (l->replay_length == 0) {
	        goto terminate;
	    }
            cursor(l, False);
	    XtVaGetValues(w, XtNcolormap, &cmap, NULL);
            pixmap = pw->paint.undo->alphapix.pixmap;
            GetPixmapWHD(dpy, pixmap, &width, &height, &depth);
            gc = XCreateGC(dpy, l->drawable, 0, 0);
            XCopyArea(dpy, pixmap, l->drawable, gc, 0, 0, width, height, 0, 0);
 	    drawp = XftDrawCreate(XtDisplay(w), l->drawable,
                                  DefaultVisual(dpy, DefaultScreen(dpy)), cmap);
            l->startX = l->replay[0].x;
            l->startY = l->replay[0].y;
            font = NULL;
            ptr = "";
            for (j=0; j<l->replay_length-1; j++) {
	        if (l->replay[j].ch == '\n') {
		    memcpy(&l->startX, l->replay[j].xft_name+2, sizeof(double));
		    memcpy(&l->startY, 
		        l->replay[j].xft_name+2+sizeof(double), sizeof(double));
                    continue;
		}
                xcol.pixel = l->replay[j].pixel;
                xcol.flags = DoRed | DoGreen | DoBlue;
                XQueryColor(dpy, cmap, &xcol);
                xre_color.red = xcol.red;
                xre_color.green = xcol.green;
                xre_color.blue = xcol.blue;
                xre_color.alpha = 255<<8;
                if (!font || strcmp(l->replay[j].xft_name, ptr)) {
		    if (font) XftFontClose(dpy, font);
                    font = XftFontOpenName(dpy, DefaultScreen(dpy), 
                                           l->replay[j].xft_name);
                    ptr = l->replay[j].xft_name;
		}
                if (!font) continue;
                XftColorAllocValue(dpy, DefaultVisual(dpy, DefaultScreen(dpy)),
			           cmap, &xre_color, &color);
  	        XftDrawString8(drawp, &color, font,
			       (int)l->replay[j].x, (int)l->replay[j].y,
                               (XftChar8*)&l->replay[j].ch, 1);
                XftColorFree(dpy, DefaultVisual(dpy, DefaultScreen(dpy)),
			     DefaultColormapOfScreen(XtScreen(w)),
			     &color);
	    }
            if (font) XftFontClose(dpy, font);
  	    j = l->replay_length - 1;
            l->curX = l->replay[j].x;
            l->curY = l->replay[j].y;
            found = 0;
            for (k=0; k<j; k++) {
	        if (l->replay[k].xft_name == l->replay[j].xft_name) {
	            found = 1;
                    break;
		}
	    }
	    if (!found) free(l->replay[j].xft_name);
            l->replay_length = j;
            if (l->replay_length==0) {
	        free(l->replay);
                l->replay = NULL;
            } else
                l->replay = 
	        (Replay *) realloc(l->replay, l->replay_length*sizeof(Replay));
            XftDrawDestroy(drawp);
            XFreeGC(dpy, gc);
            rect.x = 0;
            rect.y = 0;
            rect.width = width;
            rect.height = height;
            PwUpdate(w, &rect, True);
        terminate:
            StateSetBusy(False);
	} else {
	    if (!Global.xft_font || !Global.xft_name) continue;
            /* Fill replay structure for undoing */
            j = l->replay_length;
            ++l->replay_length;
            l->replay = 
	        (Replay *) realloc(l->replay, l->replay_length*sizeof(Replay));

	    XtVaGetValues(w, XtNforeground, &fg, XtNcolormap, &cmap, NULL);
            l->replay[j].pixel = fg;
            found = 0;
            for (k=0; k<j; k++) {
	        if (!strcmp(l->replay[k].xft_name, Global.xft_name)) {
	            l->replay[j].xft_name = l->replay[k].xft_name;
                    found = 1;
                    break;
		}
	    }
	    if (!found) l->replay[j].xft_name = strdup(Global.xft_name);
            l->replay[j].x = l->curX;
            l->replay[j].y = l->curY;
            l->replay[j].ch = buf[i];

            xcol.pixel = fg;
            xcol.flags = DoRed | DoGreen | DoBlue;
            XQueryColor(dpy, cmap, &xcol);
            xre_color.red = xcol.red;
            xre_color.green = xcol.green;
            xre_color.blue = xcol.blue;
            xre_color.alpha = 255<<8;
            XftColorAllocValue(dpy, DefaultVisual(dpy, DefaultScreen(dpy)),
			       cmap, &xre_color, &color);
	    XftTextExtents8(dpy, Global.xft_font,
			    (FcChar8*)&buf[i], 1, (XGlyphInfo*)&extents);
 	    draw = XftDrawCreate(XtDisplay(w), XtWindow(w),
                                 DefaultVisual(dpy, DefaultScreen(dpy)),
				 cmap);
 	    drawp = XftDrawCreate(XtDisplay(w), l->drawable,
                                 DefaultVisual(dpy, DefaultScreen(dpy)),
				 cmap);

  	    XtVaGetValues(w, XtNzoom, &zoom, NULL);
	    if (zoom == 1)
	        XftDrawString8(draw, &color, Global.xft_font,
			       (int)(l->curX), (int)(l->curY),
                               (XftChar8*)&buf[i], 1);
	    XftDrawString8(drawp, &color, Global.xft_font,
			   (int)(l->curX), (int)(l->curY),
                           (XftChar8*)&buf[i], 1);
            XftColorFree(dpy, DefaultVisual(dpy, DefaultScreen(dpy)),
			 DefaultColormapOfScreen(XtScreen(w)),
			 &color);
 	    XftDrawDestroy(draw);
 	    XftDrawDestroy(drawp);
            rad = sqrt(extents.xOff*extents.xOff+extents.yOff*extents.yOff);
	    dx = rad * cos(Global.xft_rot);
	    dy = -rad * sin(Global.xft_rot);
            rad = sqrt(Global.xft_maxadv*Global.xft_maxadv+
                       4*Global.xft_height*Global.xft_height);
	    XYtoRECT((int)(l->curX+0.5*(dx-rad)), 
		     (int)(l->curY+0.5*(dy-rad)), 
                     (int)(l->curX+0.5*(dx+rad)), 
                     (int)(l->curY+0.5*(dy+rad)), &rect);
	    PwUpdate(w, &rect, False);
	    l->curX += dx;
            l->curY += dy;
	    UndoGrow(w, rect.x, rect.y);
            UndoGrow(w, rect.x+rect.width, rect.y+rect.height);

	    *l->sptr++ = buf[i];
	}
    }
}

/*
**  Those public functions
 */
void *
FontAdd(Widget w)
{
    static int inited = False;
    LocalInfo *l = (LocalInfo *) XtMalloc(sizeof(LocalInfo));
    
    if (!inited) {
	selectionAtom = XA_PRIMARY;
	targetAtom = XA_STRING;
    }
    l->id = (XtIntervalId) NULL;
    l->w = None;
    l->typing = False;
    l->state = False;
    l->replay = NULL;
    l->replay_length = 0;

    l->maxStrLen = 128;
    l->str = (char *) XtMalloc(l->maxStrLen);
    l->gcx = GetGCX(w);

    OpAddEventHandler(w, opPixmap | opWindow, 
                      ButtonPressMask|ButtonReleaseMask, FALSE,
		      (OpEventProc) press, l);
    OpAddEventHandler(w, opWindow, PointerMotionMask, FALSE,
		      (OpEventProc) motion, l);
    OpAddEventHandler(w, opPixmap, KeyPressMask, FALSE, (OpEventProc) key, l);

    SetIBeamCursor(w);

    return l;
}
void 
FontRemove(Widget w, void *p)
{
    LocalInfo *l = (LocalInfo *) p;

    OpRemoveEventHandler(w, opPixmap | opWindow, 
                         ButtonPressMask|ButtonReleaseMask, FALSE,
			 (OpEventProc) press, p);
    OpRemoveEventHandler(w, opWindow, PointerMotionMask, FALSE,
		      (OpEventProc) motion, p);
    OpRemoveEventHandler(w, opPixmap, KeyPressMask, FALSE, (OpEventProc) key, p);

    if (l->id != (XtIntervalId) NULL)
	XtRemoveTimeOut(l->id);

    cursor(l, False);
 
    FreeReplay(l);
    XtFree((XtPointer) l->str);
    XtFree((XtPointer) l);
}

void 
FontChanged(Widget w)
{
    LocalInfo *l;

    setFontIcon(w);

    if (CurrentOp->add != FontAdd)
	return;

    l = (LocalInfo *) GraphicGetData(w);

    if (l->id != (XtIntervalId) NULL)
	XtRemoveTimeOut(l->id);

    cursor(l, False);
    XFlush(XtDisplay(w));
    flash(l);
}
