/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.List;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class EvaluationStatistics {
    protected CardinalityCalculator cc;

    public synchronized double getCardinality(TupleExpr expr) {
        if (this.cc == null) {
            this.cc = this.createCardinalityCalculator();
        }
        expr.visit(this.cc);
        return this.cc.getCardinality();
    }

    protected CardinalityCalculator createCardinalityCalculator() {
        return new CardinalityCalculator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CardinalityCalculator
    extends QueryModelVisitorBase<RuntimeException> {
        protected double cardinality;

        protected CardinalityCalculator() {
        }

        public double getCardinality() {
            return this.cardinality;
        }

        @Override
        public void meet(EmptySet node) {
            this.cardinality = 0.0;
        }

        @Override
        public void meet(SingletonSet node) {
            this.cardinality = 1.0;
        }

        @Override
        public void meet(StatementPattern sp) {
            this.cardinality = this.getCardinality(sp);
        }

        protected double getCardinality(StatementPattern sp) {
            List<Var> vars = sp.getVarList();
            int constantVarCount = this.countConstantVars(vars);
            double unboundVarFactor = (double)(vars.size() - constantVarCount) / (double)vars.size();
            return Math.pow(1000.0, unboundVarFactor);
        }

        protected int countConstantVars(Iterable<Var> vars) {
            int constantVarCount = 0;
            for (Var var : vars) {
                if (!var.hasValue()) continue;
                ++constantVarCount;
            }
            return constantVarCount;
        }

        @Override
        public void meet(Join node) {
            node.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit(this);
            this.cardinality *= leftArgCost;
        }

        @Override
        public void meet(LeftJoin node) {
            node.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit(this);
            this.cardinality *= leftArgCost;
        }

        @Override
        protected void meetBinaryTupleOperator(BinaryTupleOperator node) {
            node.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit(this);
            this.cardinality += leftArgCost;
        }

        @Override
        protected void meetUnaryTupleOperator(UnaryTupleOperator node) {
            node.getArg().visit(this);
        }

        @Override
        protected void meetNode(QueryModelNode node) {
            throw new IllegalArgumentException("Unhandled node type: " + node.getClass());
        }
    }
}

