/*
 *  iodbcadm.r
 *
 *  $Id$
 *
 *  The Macintosh resources
 *
 *  The iODBC driver manager.
 *
 *  Copyright (C) 1996-2012 by OpenLink Software <iodbc@openlinksw.com>
 *  All Rights Reserved.
 *
 *  This software is released under the terms of either of the following
 *  licenses:
 *
 *      - GNU Library General Public License (see LICENSE.LGPL)
 *      - The BSD License (see LICENSE.BSD).
 *
 *  Note that the only valid version of the LGPL license as far as this
 *  project is concerned is the original GNU Library General Public License
 *  Version 2, dated June 1991.
 *
 *  While not mandated by the BSD license, any patches you make to the
 *  iODBC source code may be contributed back into the iODBC project
 *  at your discretion. Contributions will benefit the Open Source and
 *  Data Access community as a whole. Submissions may be made at:
 *
 *      http://www.iodbc.org
 *
 *
 *  GNU Library Generic Public License Version 2
 *  ============================================
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; only
 *  Version 2 of the License dated June 1991.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 *  The BSD License
 *  ===============
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution.
 *  3. Neither the name of OpenLink Software Inc. nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL OPENLINK OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <Carbon.r>

data 'cicn' (10000) {
	$"0000 0000 8010 0000 0000 0020 0020 0000"            /* .......... . .. */
	$"0000 0000 0000 0048 0000 0048 0000 0000"            /* .......H...H.... */
	$"0004 0001 0004 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0004 0000 0000 0020 0020"            /* ............. .  */
	$"0000 0000 0004 0000 0000 0020 0020 0000"            /* ........... . .. */
	$"0000 0000 0000 00FF FFFE 00FF FFFE 00FF"            /* ......... */
	$"FFFE 00FF FFFE 00FF FFFE 01FF FFFE 07FF"            /* .... */
	$"FFFE 0FFF FFFE 1FFF FFFE 3FFF FFFE 3FFF"            /* ..?? */
	$"FFFE 7FFF FFFE 7FFF FFFE FFFF FFFE FFFF"            /* .. */
	$"FFFE FFFF FFFE FFFF FFFE FFFF FFFE FFFF"            /*  */
	$"FFFE FFFF FFFE FFFF FFFE 7FFF FF80 7FFF"            /* .. */
	$"FF80 3FFF FF00 3FFF FF00 1FFF FE00 0FFF"            /* ?.?.... */
	$"FC00 07FF F800 01FF E000 007F 8000 0000"            /* .......... */
	$"0000 0000 0000 00FF FFFE 00BB BBBA 00FF"            /* ......... */
	$"FFFE 0080 0002 00FF 8002 01AA 6002 0757"            /* ......`..W */
	$"F802 0AAF FC02 157F FE02 2ABF FF02 353F"            /* ......*.5? */
	$"FF02 6AFF FE82 555F FF82 AAFF FC42 D57F"            /* .jU_B. */
	$"FA42 AA7F FC42 D5FF FC42 AAFF F842 D55F"            /* B.BBB_ */
	$"F042 AABF F842 D55F F07E 6AAF F080 5553"            /* BB_~jUS */
	$"E080 2A83 E100 3503 E100 1801 E200 0800"            /* *.5....... */
	$"C400 0600 1800 0180 6000 007F 8000 0000"            /* ......`...... */
	$"0000 0000 0000 0000 0007 0000 FFFF FFFF"            /* ............ */
	$"FFFF 0001 CCCC CCCC CCCC 0002 9999 6666"            /* ....ff */
	$"3333 0003 0000 9999 FFFF 0004 0000 6666"            /* 33........ff */
	$"0000 0005 0000 0000 DDDD 0006 8888 8888"            /* .......... */
	$"8888 000F 0000 0000 0000 0000 0000 0000"            /* .............. */
	$"0000 0000 0000 0000 0000 0000 0000 5555"            /* ..............UU */
	$"5555 5555 5555 5555 5550 0000 0000 5055"            /* UUUUUUUUUP....PU */
	$"5055 5055 5055 5055 50F0 0000 0000 5555"            /* PUPUPUPUP....UU */
	$"5555 5555 5555 5555 55F0 0000 0000 F000"            /* UUUUUUUUU..... */
	$"0000 0000 0000 0000 00F0 0000 0000 FFFF"            /* ............. */
	$"FFFF F016 6066 6066 60F0 0000 000F F131"            /* .`f`f`....1 */
	$"3131 6FF0 0000 0000 00F0 0000 0FF3 1313"            /* 11o.......... */
	$"1444 444F F066 6066 60F0 0000 F131 3131"            /* .DDOf`f`..111 */
	$"4444 4444 4F00 0000 00F0 000F 1313 1344"            /* DDDDO.........D */
	$"4444 4444 44F6 6066 60F0 00F1 3131 3144"            /* DDDDD`f`.111D */
	$"4344 4444 444F 0000 00F0 00F3 1313 1644"            /* CDDDDO.......D */
	$"3344 4444 444F 6066 60F0 0F31 3131 3433"            /* 3DDDDO`f`.11143 */
	$"4444 4444 4446 F000 00F0 0F13 1313 6414"            /* DDDDDF......d. */
	$"4444 4434 4444 F166 60F0 F131 3131 3444"            /* DDD4DDf`1114D */
	$"4444 3444 4466 6F00 00F0 F313 1313 1344"            /* DD4DDfo......D */
	$"4423 4444 4646 6F66 60F0 F131 3131 6424"            /* D#DDFFof`111d$ */
	$"4344 2422 4466 6F10 00F0 F313 1313 4443"            /* CD$"Dfo.....DC */
	$"3324 2434 2466 6F66 60F0 F131 3131 4423"            /* 3$$4$fof`111D# */
	$"4242 4443 2666 6F10 00F0 F313 1313 1312"            /* BBDC&fo....... */
	$"2424 4422 6666 6F66 60F0 F131 3131 3134"            /* $$D"ffof`11114 */
	$"4242 4444 4666 6F10 00F0 F313 1313 1314"            /* BBDDFfo....... */
	$"2424 4444 6666 6FFF FFF0 0F31 3131 3131"            /* $$DDffo.11111 */
	$"3444 4444 6666 F000 0000 0F13 1313 1313"            /* 4DDDff......... */
	$"1644 4446 6666 F000 0000 00F1 3131 3161"            /* .DDFff....111a */
	$"6144 4446 666F 0000 0000 00F3 1313 1616"            /* aDDFfo......... */
	$"1644 4446 666F 0000 0000 000F 3161 6161"            /* .DDFfo......1aaa */
	$"6664 4446 66F0 0000 0000 0000 F616 1666"            /* fdDFf........f */
	$"6666 4466 6F00 0000 0000 0000 0FF6 6666"            /* ffDfo........ff */
	$"6666 666F F000 0000 0000 0000 000F F666"            /* fffo.........f */
	$"6666 6FF0 0000 0000 0000 0000 0000 0FFF"            /* ffo........... */
	$"FFFF F000 0000 0000 0000 0000 0000 0000"            /* ............. */
	$"0000 0000 0000 0000 0000"                           /* .......... */
};

resource 'PICT' (10000) {
	16848,
	{0, 0, 260, 117},
	$"0011 02FF 0C00 FFFE 0000 0048 0000 0048"
	$"0000 0000 0000 0104 0075 0000 0000 00A1"
	$"01F2 0016 3842 494D 0000 0000 0000 0104"
	$"0075 4772 8970 68AF 626A 0001 000A 0000"
	$"0000 0104 0075 009A 0000 00FF 81D4 0000"
	$"0000 0104 0075 0000 0004 0000 0000 0048"
	$"0000 0048 0000 0010 0020 0003 0008 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0104"
	$"0075 0000 0000 0104 0075 0040 0162 7F00"
	$"4472 7875 7B71 7876 7B75 7B71 7875 7B75"
	$"7C71 7875 7B75 7B72 7875 7B74 7B72 7976"
	$"7B75 7B71 7873 7975 7C71 7875 7B75 7B72"
	$"7875 7B74 7B74 7B76 7B75 7B71 7875 7B75"
	$"7B72 7875 7B73 7972 7875 7B75 7B72 7873"
	$"7975 7B74 7B75 7B75 7B72 7875 7B75 7B72"
	$"7875 7B74 7B72 7876 7B75 7B71 7876 7C75"
	$"7BA7 A7E4 174D 848A 8388 838A 8489 837F"
	$"8883 8983 8883 8983 8A83 8883 8884 8983"
	$"8882 8884 8A83 8883 8983 8983 8983 8983"
	$"8A83 8883 8884 8983 8882 8884 8A83 8883"
	$"8883 8983 8883 8884 8A83 8883 8984 8983"
	$"8883 8884 8A83 8983 8883 8A83 8883 8884"
	$"8A83 8983 8884 8983 8882 8884 8A83 8883"
	$"8883 8982 8883 88B1 B1E4 4176 C2C8 B8BD"
	$"C2C8 BABF B8BD C0C6 B8BD B8BE C2C8 B8BD"
	$"5EB8 BDC1 C6B8 BDB7 BDC4 CAB9 BDB7 BCC0"
	$"C6B8 BDB8 BEC2 C8B8 BDB8 BDC1 C6B8 BDB7"
	$"BDC2 C8B9 BDB8 BDC0 C6B8 BDB8 BDC2 C8B8"
	$"BDB8 BDC1 C6B8 BDB8 BDC2 C8B8 BDB8 BDC1"
	$"C7B8 BDB8 BDC2 C8B7 BCB8 BDC1 C6B8 BDB7"
	$"BDC2 C8B9 BDB8 BDC0 C6B8 BDB8 BDD1 D1E4"
	$"0162 7F25 0041 787B A578 78A5 7B7B A578"
	$"78A5 7B7B A578 78A5 7B7B A578 78A5 7B7B"
	$"A578 78A5 7B7B A678 78A4 797B A578 78A5"
	$"7B7B A578 78A5 7B7B A57A 7AA5 7B7B A578"
	$"78A5 7B7B A578 78A5 7B79 A478 78A5 7B7B"
	$"A678 78A4 797B A57B 7AA5 7B7B A678 78A6"
	$"7B7B A578 78A5 7B7B A678 78A5 7B7B A578"
	$"78A6 7C7B 75A7 D4D6 3218 588A 88B1 8A8A"
	$"B189 887F B189 89B1 8888 B18A 8AB1 8888"
	$"B189 89B1 8888 B189 89B1 8889 B289 89B2"
	$"8988 B18A 8AB1 8888 B189 89B1 8888 B189"
	$"89B1 8888 B189 89B1 8888 B18A 8AB1 8889"
	$"B289 89B1 8888 B28A 8AB2 8988 B18A 89B1"
	$"8888 B28A 8AB2 8988 B189 89B1 8888 B28A"
	$"8AB1 8888 B189 89B0 8888 83B1 DCD6 5D43"
	$"9BC8 BDE3 C8C8 E4BF BDE3 C6C6 E3BD BDE3"
	$"C8C8 E3BD 5EBD E3C6 C6E3 BDBD E3C9 C9E3"
	$"BDBC E2C6 C6E3 BDBD E3C8 C8E3 BDBD E3C6"
	$"C6E3 BDBD E3C8 C8E3 BDBD E3C6 C6E3 BDBD"
	$"E3C8 C8E3 BDBD E3C6 C6E3 BDBD E4C8 C8E3"
	$"BDBD E3C7 C6E3 BDBD E4C8 C8E2 BCBD E3C6"
	$"C6E3 BDBD E4C8 C8E3 BDBD E3C6 C6E3 BDBD"
	$"B8D1 FBD6 00CD 0202 2943 FC75 0176 74FC"
	$"75FF 76FE 7500 76FC 7500 74FE 7503 7475"
	$"7674 FC75 FF76 FE75 0076 FC75 0074 FE75"
	$"0374 7576 74FC 7503 7674 7574 F675 FF74"
	$"E975 0176 74FC 7508 7672 78AA D1A8 092F"
	$"57FB 8301 8283 F283 0082 FE83 0382 8383"
	$"82F1 8300 82FE 8303 8283 8382 FB83 0282"
	$"8382 F683 FF82 E883 0082 FB83 0884 89B0"
	$"D7B0 1F43 93BB FDB8 01B9 B7FC B8FF B9FE"
	$"B801 B9B8 FDB8 00B7 FEB8 03B7 B8B9 B7FC"
	$"B8FF B9FE B800 B9FC B801 B7B8 FEB7 02B8"
	$"B9B7 FCB8 03B9 B7B8 B7FA B8FF B7FF B8FF"
	$"B7ED B8FF B7FF B801 B9B7 FCB8 05B9 C1C6"
	$"CAEF D100 7903 020F 0043 EB44 0045 EA44"
	$"0045 E244 0043 FD44 0643 4445 4443 4445"
	$"FE44 0043 FD44 0045 F844 0841 3FAA AAA8"
	$"0918 2557 FA56 F256 0057 EA56 0057 E256"
	$"0055 FD56 0655 5657 5655 5657 FE56 0055"
	$"FD56 0057 F856 0158 57FE B003 1F2E 5D93"
	$"EF8F FD8F 0090 EA8F 0090 DB8F 0090 FE8F"
	$"0090 F98F 0090 F88F 0499 98CA CAD1 00AC"
	$"0B0F 013C 433E 3E40 3D3E 3E3C 3CEF 3EFF"
	$"3FF9 3EFF 3FFB 3EFF 3CFD 3EFF 3FF9 3EFD"
	$"3CFE 4107 3F44 443C 3C3E 3E40 FB3E 003D"
	$"FE3E 003D FD41 EF3E 083B 3C7C A7A8 1809"
	$"5057 FE5A 0358 5959 5A00 5AFB 59FF 5AF7"
	$"59FF 5AFB 59FD 5AFB 59FF 5AFD 59FF 5AF9"
	$"59FD 5AFE 5807 5756 565A 5A59 595A FB59"
	$"0358 5A5A 59FC 58EE 590A 5A87 B0B0 2D1E"
	$"8D93 A5A5 A4F6 A3FF A5FF A3F1 A3FF A5E5"
	$"A3FF 9903 9B9A 8F8F FDA3 00A4 FAA3 FFA5"
	$"FFA3 FF9B FF99 EDA3 02B6 DCD3 00C3 0329"
	$"0000 43FC 3E02 3D3C 3CEF 3EFF 3F01 3E3D"
	$"FB3E FF3F FB3E FF3C FD3E FF3F 013E 3DFB"
	$"3EFD 3C07 7278 7278 7576 3C3B F73E 003D"
	$"FE3E 0372 3F72 41FC 3E00 40FC 3E00 3DFB"
	$"3EFF 3CFF A706 A82F 0725 575A 5AFE 5901"
	$"585A 005A FB59 FF5A F759 FF5A 0159 58FD"
	$"59FD 5AFB 59FF 5AFD 59FF 5A01 5958 FB59"
	$"FD5A 0684 8984 8A83 845A F559 065A 5959"
	$"8457 8458 FC59 005A FC59 0058 FB59 FF5A"
	$"FEB0 0542 1B5D 93A5 A5F5 A3FF A5FF A3F1"
	$"A3FF A5E5 A305 C1C6 C2C8 B7B8 F5A3 07A4"
	$"A5A3 A3C2 9AC1 99FC A300 A4F3 A3FF DC00"
	$"D300 BF07 010F 3C43 3F3F 3C3C FD3E FF3C"
	$"F53E FF3F E33E FF3C FD3E FF41 0972 787C"
	$"767B 7578 787B 75F7 3E0F 4475 7278 7B7A"
	$"7B75 7841 4343 403E 3F3F F53E 067C A7A8"
	$"0918 5057 FD5A FE59 0459 5A5A 5959 FD5A"
	$"FF59 FF5A FF59 FF5A E759 FF5A FF59 FF5A"
	$"FD59 FF58 0B84 8A87 8288 8389 8988 835A"
	$"5AFB 59FF 5A0C 5683 8489 8887 8883 8A58"
	$"5757 5AF2 5906 88B1 B01E 2D8D 93F5 A3FD"
	$"A5FF A3FF A5E3 A3FF A5F9 A3FF 990B C2C8"
	$"B2AC BDB8 C6C6 BDB8 A5A5 FBA3 FFA5 0C8F"
	$"B8C1 C6BD BCBD B8C8 9B99 99A4 F2A3 02B5"
	$"DBD1 00CE 0700 2900 433F 3F3C 3CFD 3EFF"
	$"3CF5 3EFF 3FE3 3EFF 3CFD 3E0C 3F72 7878"
	$"7676 7B74 7772 7B75 77FC 3E00 3DFE 3E03"
	$"757B 7878 FE75 0A7B 7278 7543 3E40 3F3F"
	$"3E3D F73E FFA7 04A8 072F 2557 FD5A FE59"
	$"0459 5A5A 5959 FD5A FF59 FF5A FF59 FF5A"
	$"E759 FF5A FF59 FF5A FD59 0D57 848A 8A82"
	$"8288 8288 8488 838B 5AFD 5907 5859 5A5A"
	$"8388 8989 FE83 0688 848A 8457 595A FE59"
	$"0058 F759 FFB1 04B0 1B42 5D93 F5A3 FDA5"
	$"FFA3 FFA5 E3A3 FFA5 F9A3 0D98 C1C8 C8AC"
	$"ACBD B7C5 C1BD B8D1 A5FB A3FF A503 B8BD"
	$"C6C6 FEB8 06BD C2C8 C299 A3A4 F3A3 FFDB"
	$"00D1 00CB 030F 013A 41DD 3E00 3DFB 3E00"
	$"3DFD 3EFF 3FF7 3E0D 747A 7575 7B7B 767C"
	$"767C 757B 7575 FC3E 063D 4178 757B 7878"
	$"FE7B 0675 7B74 7871 4141 F93E FF43 0A41"
	$"7244 757E A9A9 180A 5157 FA59 0259 5A5A"
	$"E759 0058 FB59 0058 FD59 FF5A FB59 FF5A"
	$"FF59 0D83 8983 8388 8882 8882 8883 8883"
	$"83FC 59FF 5804 8983 8881 81FE 8806 8389"
	$"8289 8358 58F9 59FF 570A 5884 5683 87B1"
	$"B130 2290 96F9 A3FF A5F9 A3DB A3FF A5FF"
	$"A30D C1C6 B8B8 BDBD B0B5 B0B5 B8BD B8B8"
	$"FBA3 0599 C6B8 BDA4 A4FE BD06 B8BC B6C6"
	$"C09B 9BF9 A3FF 9906 9BC2 8FB8 AAD2 D200"
	$"C803 010F 0041 DC3E 003D F73E FF3F FB3E"
	$"113D 3E3E 3D7A 7A7B 7B90 7CA7 767C 927B"
	$"757A 7BFB 3E0F 7278 757B 7E94 7B90 7BA5"
	$"757B 7878 7141 FB3E FF3D 0C74 7A78 797B"
	$"75A8 C1A8 0A18 2757 FA59 0259 5A5A E659"
	$"0058 F759 FF5A FA59 105A 5958 8989 8888"
	$"9D89 B182 889C 8883 8788 FB59 0A84 8983"
	$"8887 9D88 9D88 B183 FE89 0183 58FB 59FF"
	$"580C 8389 8A8B 8883 B0C8 B022 3062 96F9"
	$"A3FF A5F9 A3DB A311 A4A5 A3A3 C6C6 BDBD"
	$"D0BE DBB0 B5C8 BDB8 BCBD FBA3 0FC1 C6B8"
	$"BDAA BEBD D0BD E3B7 BCC6 C6C2 9BF9 A308"
	$"C1C6 C8C8 BDB8 D1E8 D100 E403 2B02 3544"
	$"D93E FF3C FF3E 013B 3CFB 3EFF 3CFF 3E13"
	$"3D3E 4178 7575 7776 7C76 7B75 7878 7278"
	$"757B 7544 FD3E 0F7B 757C 7672 787B 7B75"
	$"757C A275 7578 41FB 3E0E 757B 757B 7676"
	$"7278 AAD6 D22E 0749 56FB 5900 5A00 5AE1"
	$"59FF 5AFE 5902 5A59 59FB 5AFF 5903 5859"
	$"588A FE83 0C82 8882 8983 8989 848A 8388"
	$"8356 FD59 0F88 8388 8284 8988 8883 8388"
	$"AD83 838A 58FD 59FF 5A0E 8388 8388 8282"
	$"8489 B0DC D642 1D81 8DFB A3FF A5F7 A3E7"
	$"A300 A2FE A3FD A5FB A311 9BC8 B8B8 B1B0"
	$"BDB8 BFBA C6C6 C2C8 B8BD B88F FDA3 0FBD"
	$"B8B5 B0C1 C6BD BDB8 B8B5 D7B8 B8C8 9BFD"
	$"A3FF A50A B8BD B8BD B0B0 C1C6 CAF4 E500"
	$"E803 012A 0044 D93E FF3C 0340 3E3C 3CFC"
	$"3E02 3F3C 3CFD 3E11 4172 7B7B A77C 7C76"
	$"7B75 7972 7878 757B 7544 FD3E 0F75 7B76"
	$"A778 7876 757B 7B76 7C7B 7B72 3FFB 3E0E"
	$"7B75 7B75 7CA7 7878 AAD1 AB06 2D22 56FB"
	$"5900 5A00 5AE1 59FE 5A04 595A 5A59 59FE"
	$"5A02 5B5A 5AFD 5911 5884 8888 B188 8882"
	$"8983 8A84 8A8A 8388 8356 FD59 0A83 8882"
	$"B189 8983 8388 8882 FE88 0184 57FD 59FF"
	$"5A0E 8883 8883 88B1 8989 B0D7 AF1B 4158"
	$"8DFB A3FF A5F7 A3E9 A300 A4FC A3FE A500"
	$"A6FB A311 9BC2 BDBD DBB5 BDB8 BFBA C7C1"
	$"C8C8 B8BD B88F FDA3 0FB8 BDB0 DBC6 C6B9"
	$"B8BD BDB0 B5BD BDC2 9AFD A3FF A50A BDB8"
	$"BDB8 B5DB C6C6 CAEF BF00 EDFF 0001 3C45"
	$"FD3E FF3F E13E 003D FE3E FD41 033E 3D45"
	$"44F9 3E01 4178 FE75 137A 8F79 76A7 757B"
	$"937F 7378 7241 3E3E 4476 7872 7BFE 7509"
	$"A579 767C 7B75 787D 7575 FD3E 1441 7877"
	$"7D7C A178 7275 75AB D7A8 0C0D 5058 5959"
	$"5A5A FE59 E259 0058 FE59 FD58 0359 5857"
	$"56F9 5901 588A FE83 1387 9E89 82B1 8388"
	$"9B88 8589 8458 5959 5683 8984 88FE 8309"
	$"B289 8288 8983 8287 8383 FD59 1458 8982"
	$"8788 AC8A 8483 83AF DBB0 272A 8D94 A3A3"
	$"A5A5 F3A3 E9A3 FF9B FF99 FFA3 0190 8FF9"
	$"A301 9BC8 FEB8 13BC D2BF B0DB B8BD BFAD"
	$"C2C6 C29B A3A3 8FB9 C6C1 BDFE B809 E3BC"
	$"B0B5 BCB7 B1B5 B8B8 FDA3 0C99 C6B0 B5B5"
	$"D6C8 C2B8 B8C1 ECD1 00F9 0327 0000 43FD"
	$"3EFF 3FE0 3E0D 3D3E 3E41 7278 7377 7775"
	$"753E 3E3D FE3E 033D 3E41 72FE 7B13 7579"
	$"7976 7C7B 757E 9379 7878 413E 3E45 7578"
	$"7875 FE7B 0973 7992 7C75 7B7D 927B 43FD"
	$"3E14 7278 7777 7C76 7877 7B7B C4C4 D430"
	$"0C24 5759 595A 5AFE 59E1 590D 5859 5958"
	$"8489 858A 8A83 8359 5958 FE59 0358 5958"
	$"84FE 8813 8389 8982 8888 8387 9B8A 898A"
	$"5859 5957 8389 8983 FE88 0983 899C 8883"
	$"8987 9C88 55FD 5914 8489 8282 8882 8A89"
	$"8888 C8C8 DB4C 275C 93A3 A3A5 A5F3 A3E9"
	$"A307 9BC2 C6C2 CFCF B8B8 F9A3 019B C2FE"
	$"BD13 B8BF BFB0 B5BD B8AC BFC7 C6C8 9BA3"
	$"A390 B8C6 C6B8 FEBD 09B7 BCC8 B5B7 BCB5"
	$"C8BD 8FFD A30C C1C6 B0B0 B5B0 C8C7 BDBD"
	$"D9D9 FB01 0403 010F 3C43 FE3E 023D 3C3C"
	$"E73E FF3C FB3E 0A44 757B 7B75 7B76 7678"
	$"7978 FE41 013F 40FE 3E39 7780 957C 757C"
	$"9278 727C 7578 78A9 7872 413E 3E41 3F7D"
	$"9278 7892 777B 757B 7B76 A773 797C 763F"
	$"3F3C 3C7B 757B A576 7C75 7576 76A8 ADC7"
	$"0818 5057 FE59 0358 5A5A 59E8 59FF 5AFB"
	$"590A 5683 8888 8388 8282 8A8B 8AFE 5801"
	$"5A5B FE59 398A 879B 8881 889C 8A84 8881"
	$"8989 B181 8458 5959 5857 899C 8A8A 9C82"
	$"8983 8888 82B1 8389 8882 5959 5A5A 8883"
	$"88B1 8288 8383 8282 B0B5 C71D 2D8D 93EF"
	$"A3EB A30D 8FB8 BDBD B8BD B0B0 C6C7 C89B"
	$"9999 FCA3 15CF AABE BDB7 B5C8 C8C2 B5AF"
	$"C6C6 D2A5 C29B A3A3 9B9A B6FD C80A B0BC"
	$"B7BD BDB0 DBB7 BCBD B8FD A30C BDB8 BDE3"
	$"AEB3 B8B8 AEAE D1D6 C701 0404 0029 0043"
	$"3DFE 3EFF 3CE7 3EFF 3CFB 3E0F 757B 7575"
	$"7B75 A77C 7873 7278 7241 3F3F FE3E 0C77"
	$"9480 767C 777C 7878 927C 7872 FE78 2A41"
	$"3E40 4172 767C 7872 7D7D 7B75 7B90 7B76"
	$"7973 7C76 3F3F 3C3C 7B75 7B75 7C92 7B7C"
	$"A77C A8CF D607 2F25 5758 FE59 FF5A 0059"
	$"E859 FF5A FB59 0F83 8883 8388 83B1 888A"
	$"8584 8A84 585A 5AFE 5939 8A9A 8782 8883"
	$"888A 8A9C 8889 8481 818A 5859 5A58 8482"
	$"888A 8487 8789 8388 9D87 8289 8388 8259"
	$"595A 5A88 8388 8388 9C88 89B1 88B0 D7D6"
	$"1B42 5D93 EFA3 EBA3 0DB8 BDB8 B8BD B8DB"
	$"B5C6 C2C2 C8C1 99FC A306 CFBD AAB8 BDB1"
	$"B5FE C81A B5C6 C1A5 A5C8 9BA3 A49B C2B0"
	$"B5C8 C2B5 B5BC B7BD D0B4 B0BC B7BD B8FD"
	$"A30C BDB8 BDB8 B3C6 BDBE DAB3 D1F6 D601"
	$"1003 0F01 3C43 E53E FF3F FF3E FF3F FD3E"
	$"FF41 0D78 7277 7776 7C75 7576 7B7D 7778"
	$"3FFD 3E3A 4172 7978 76A7 767C 7575 7C76"
	$"767C 7878 7241 3B3C 4172 7972 75A8 7575"
	$"A776 7878 757B 767C 7273 3D40 3E3E 757B"
	$"777D 7878 7676 7872 ABD6 A818 0A50 57FA"
	$"59FC 59FF 5AF3 59FD 5AFB 59FF 580D 8A84"
	$"8A8A 8288 8383 8286 8782 8957 FD59 3A58"
	$"848A 8982 B182 8883 8388 8282 8889 8984"
	$"5859 5A58 848A 8481 B283 83B1 8289 8983"
	$"8882 8882 8358 5A59 5983 8882 8789 8982"
	$"8289 84B1 DCB0 3022 8D93 F5A3 FFA5 FDA3"
	$"F5A3 FDA5 FDA3 FF9B 0DC6 C1C8 C8B0 B5B8"
	$"B8AC B1B5 B0C6 98FD A336 9BC2 C7C6 B0DB"
	$"B0B5 B8B8 B5B0 B0B5 C6C6 C29B A3A3 9BC2"
	$"C7C1 AFDC B8B8 DBB0 C6C6 B8BD B0B5 B7B8"
	$"A3A4 A3A3 B8BD B0B5 C6C6 B0B0 C6C1 CAF4"
	$"D101 0D03 010F 0043 E53E FF3F FF3E FF3F"
	$"FD3E 0F41 7278 7871 77A1 7C7B 7BA7 767C"
	$"9278 72FD 3E25 3F78 7278 767C 7C92 7B7B"
	$"927C A777 7278 7841 3C3C 4141 7878 7C76"
	$"7B7B 767C 7277 757B 7C93 7942 FD3E 107B"
	$"757D 9272 787C 7678 78AA D1D4 0A18 2557"
	$"FA59 FC59 FF5A F359 FD5A FB59 0658 848A"
	$"8A84 8AAC FE88 05B0 8286 9C89 84FD 5925"
	$"578A 8489 8288 889C 8888 9C88 B183 8489"
	$"8A58 5A5A 5858 8989 8882 8888 8288 8488"
	$"8388 889D 8956 FD59 1088 8387 9C84 8988"
	$"8289 89B0 D7DB 2230 5D93 F5A3 FFA5 FDA3"
	$"F5A3 FDA5 FDA3 0F9B C2C6 C6C2 C8D6 B5BD"
	$"BDD8 ACB4 C8C6 C1FD A325 9AC8 C1C6 B0B5"
	$"B5C8 BDBD C8B5 DBB1 C1C6 C89B A3A3 9B9B"
	$"C6C6 B5B0 BDBD B0B5 C1C5 B8BD B5C9 BD8F"
	$"FDA3 0CBD B8B5 C8C1 C6B5 B0C6 C6CA EFFB"
	$"0106 0329 003C 43E1 3EFF 3CFF 3EFF 3F39"
	$"447B 927C 767C 7278 7676 7D77 7879 7278"
	$"4343 3E3E 4178 917C 767C 757B 907C 7B75"
	$"7878 77A8 7241 3E3E 4475 7C92 7973 7B75"
	$"7B90 7C76 7CA1 7379 7872 FD3E 1076 A772"
	$"787D 78A5 7B92 76AB C3AD 2F07 5057 FA59"
	$"E859 FF5A FF59 FF5A 4E56 889C 8882 8884"
	$"8982 8287 828A 8B84 8957 5759 5958 8A9C"
	$"8882 8883 889D 8988 838A 8A81 B084 5859"
	$"5956 8388 9C89 8389 8388 9D88 8288 AC83"
	$"8989 8459 595A 5A82 B184 8A87 82B1 889C"
	$"82B1 C8AF 421B 8D93 EFA3 EDA3 4A8F BDC8"
	$"B5AE B3C1 C6B0 B0B5 B0C8 C8C1 C69B 9BA3"
	$"A39B C8D1 BFB0 B5B8 BDD0 BEBD B8C8 C8AE"
	$"DAC2 9BA3 A38F B8B5 C8BD B8BF BABD D0B3"
	$"AEB5 D6B8 BDC6 C1A3 A3A5 A5AE DAC2 C8B3"
	$"AFE3 BDC8 B0CA E1BF 0108 0301 2900 43E1"
	$"3EFF 3CFF 3E3B 3F3D 7575 7C76 A776 7878"
	$"767C 7D92 7972 7878 7443 3E3E 3F71 7C7C"
	$"A876 7B75 7B7B 757B 7872 7D77 7841 3E3E"
	$"4475 7C76 7973 7B75 7B7B 76A7 767B 7973"
	$"7841 FE3E 113F 7C76 7878 7777 7B75 7C7C"
	$"AAD6 D509 2F25 57FA 59E8 59FF 5AFF 5950"
	$"5A59 8383 8882 B182 8989 8288 879C 8B84"
	$"8989 8457 5959 5783 8888 B282 8883 8888"
	$"8388 8A84 8781 8A58 5959 5683 8882 8983"
	$"8983 8888 82B1 8287 8983 8958 5959 5A5B"
	$"8882 8A8A 8181 8883 8888 B0DC D71E 425D"
	$"93EF A3EE A34B A2B8 B8B5 B0DA AEC6 C6B0"
	$"B5B5 C8C8 C2C6 C6C2 9BA3 A39A C2BF BFDC"
	$"B0BD B8BD BDB8 BDC8 C2B3 AEC8 9BA3 A38F"
	$"B8B5 B0BD B8BF BABD BDAE DAB0 B4BD B8C6"
	$"99A3 A3A5 A6B3 AEC8 C8AE AEBD B8B5 B5CA"
	$"F4E6 0104 050F 013C 433D 3DDD 3E39 4178"
	$"7B75 7777 7692 7B90 7B7B 757B 927C 4141"
	$"3D3E 4178 7575 747B 747B 7575 7C92 7B76"
	$"7B75 7841 3E3E 4141 7B75 7BA5 767C 767C"
	$"7B75 7872 7B7B 917D FD3E 1075 7C75 75A5"
	$"7B75 7B76 7CAB D2AE 180A 5057 FA59 FC59"
	$"FF5A E959 0F58 8A88 838A 8A82 9C88 9D89"
	$"8983 889C 88FE 5826 5958 8A83 8382 8882"
	$"8883 8388 9C87 8288 838A 5859 5958 5888"
	$"8388 B182 8882 8888 838A 8488 889C 88FD"
	$"5912 8389 8383 B088 8389 8288 AFD6 B630"
	$"228D 93A4 A4F7 A3FF A5FD A3ED A339 9BC8"
	$"BDB8 C8C8 B0C8 BDD0 BFBF B8BD C8B5 9B9B"
	$"A3A3 9BC8 B8B8 B7BD B7BD B8B8 B5C8 B4B0"
	$"BDB8 C89B A3A3 9B9B BDB8 BDE3 AEB3 AEB3"
	$"BDB8 C8C2 BDBD D0BE FDA3 0CB8 BEBA BAE2"
	$"BDBA BFB0 B5C1 E7D7 0104 0302 0F00 43DB"
	$"3E15 7278 757B 7177 7C7D 7B7B 7575 7B75"
	$"7C76 713F 3E3E 4172 FE7B 2075 7AA5 7B7B"
	$"767D 76A7 757B 7241 3E3E 4172 7B75 757B"
	$"76A7 7575 7B75 7878 907C 7C45 FD3E 127B"
	$"757B 7B75 7B74 7B7C 92AB D2C1 0B18 2557"
	$"5A5A FC59 FC59 FF5A E959 1584 8A83 8884"
	$"8A88 8988 8883 8388 8388 8283 5759 5958"
	$"84FE 8820 8387 B188 8882 8982 B183 8884"
	$"5859 5958 8488 8383 8882 B181 8188 838A"
	$"8A9D 8988 55FD 5912 8883 8989 8388 8289"
	$"889C AFD6 C823 305D 93A5 A5F7 A3FF A5FD"
	$"A3ED A315 C2C8 B8BD C2C8 B5B6 BDBD BABA"
	$"BDB8 B5B0 C29A A3A3 9BC2 FEBD 20B8 BCE3"
	$"BDBD B0B6 B0DB B8BD C29B A3A3 9BC2 BDB8"
	$"B8BD AEDA ADAD BDB8 C8C8 D0BE BD8F FDA3"
	$"0CBD B8BF BFB8 BDB9 BFB5 C8C1 E7E8 0116"
	$"0329 003C 43EF 3EFF 3FFD 3EFF 3FFD 3EFF"
	$"3CFB 3E06 7D77 7B75 7C91 75FE 76FF 7818"
	$"A776 7878 7241 3E3E 4078 767C 927C 7575"
	$"76A5 757B 7B75 7C76 77FE 3E12 4474 7178"
	$"7C76 7973 7878 767C 917B 757B 7676 3DFE"
	$"3E10 7178 A776 7C76 7C92 7878 A8CF AD2E"
	$"0550 57FA 59F6 59FF 5AFF 59FD 5AFD 59FF"
	$"5AFB 5919 8782 8883 889C 8383 8282 8989"
	$"B182 8989 8458 5959 5889 8288 9C88 FE83"
	$"07B1 8388 8883 8882 8AFE 5912 5682 8389"
	$"8882 8983 8A8A 8288 9C88 8388 8282 58FE"
	$"5910 8389 B182 8882 889C 8A8A B0D7 B43B"
	$"138D 93EF A3FD A3FF A5F3 A324 B5B0 BDB8"
	$"B5C7 B8B9 B0B0 C6C6 DBB0 C6C6 C29B A3A3"
	$"9DC9 AEB3 C8B5 B8B8 B9E3 B8BD BDB8 B5B0"
	$"CFFE A311 8FB7 C0C6 B3AE BDB8 C8C8 B0B5"
	$"C8B5 B8BD B0B0 FDA3 0CC0 C6DB B0B3 AEB5"
	$"C8C6 C6D1 F6D6 0113 0301 2900 43EF 3EFF"
	$"3FFD 3EFF 3FFD 3EFF 3CFB 3EFF 7717 7CA5"
	$"767C 7B7B 7CA7 7872 767C 7278 4141 3E3E"
	$"4072 A775 7C76 FE7B 077A 757B 747B A776"
	$"76FE 3E11 4475 7878 927B 7379 7378 A17C"
	$"7B75 7B75 7C76 FD3E FF78 0E76 7C76 A776"
	$"7C78 72A8 ADCF 062E 2457 FA59 F659 FF5A"
	$"FF59 FD5A FD59 FF5A FB59 FF82 0289 B182"
	$"FD88 10B1 8984 8288 8489 5858 5959 5884"
	$"B181 8882 FE88 0787 8388 8288 B182 89FE"
	$"5911 5683 8989 9C87 8389 858A AC88 8882"
	$"8883 8882 FD59 FF89 0E82 8882 B182 888A"
	$"84B0 B4D7 143B 5C93 EFA3 FDA3 FFA5 F3A3"
	$"FFB0 17BE E3B0 B5BD BDB5 DBC6 C1B0 B5C1"
	$"C69B 9BA3 A39D C4DA ADB5 B0FE BD07 BCB8"
	$"BDB7 BDDB B0CF FEA3 018F B8FE C60C B3B8"
	$"BDC3 C8D6 B5B5 B0BD B8B5 B0FD A3FF C60A"
	$"B0B5 AEDA B0B5 C6C1 D1D6 F601 03FF 0003"
	$"3C43 403D DD3E 0741 7875 7C7C 777B 90FE"
	$"7506 7C7A 757B 9078 41FE 3E24 7875 7B7A"
	$"7B92 7C76 767B 907B 7476 7C71 403F 3F41"
	$"417B 9079 797C 907B 757B 757B 7578 7876"
	$"7DFD 3EFF 7610 7B75 7878 757B 767C C4D2"
	$"AB0B 0C50 575A 58FC 59F6 59FF 5AEF 5911"
	$"588A 8188 8883 899D 8383 8188 8783 899D"
	$"8A58 FE59 168B 8388 8788 9C88 8282 899D"
	$"8882 8288 8358 5959 5858 889D FE89 0A9D"
	$"8883 8883 8883 8989 8289 FD59 FF82 0F88"
	$"8389 8983 8882 88C8 D6AE 272A 8D93 A4F0"
	$"A3FF A5EF A311 9BC8 ADB3 B5B1 BFD1 B8B8"
	$"AFB5 BCB8 BCCF C89B FEA3 24D0 B8BD BCBD"
	$"C8B5 B0B0 BFD1 BDB7 B8BD C39D A3A3 9B9B"
	$"BDD0 BDBD BED0 BDB8 BDB8 BDB8 C6C6 B0B6"
	$"FDA3 FFAE 0ABD B8C6 C6B8 BDB0 B5D9 E7BF"
	$"010C 0528 0000 433E 40E3 3E00 3DFC 3E05"
	$"7278 7676 7C92 FC7B 2F92 7B75 7B7B 7242"
	$"3E3D 3E77 757B 917B 7C76 7C76 7B7B 757B"
	$"7C76 7840 3F3E 4172 7B7B 7374 7B7B 757B"
	$"7B75 7BA5 7278 7677 3DFE 3E12 7C76 A57B"
	$"7278 757B 927C ABD7 C42F 0B25 5759 5AFC"
	$"59F6 59FF 5AF5 5900 58FC 593A 848A 8282"
	$"889C 8989 8888 879C 8883 8989 8459 5958"
	$"598A 8388 9D88 8882 8882 8989 8388 8882"
	$"8958 5958 5884 8888 8384 8888 8388 8883"
	$"88B1 8489 8283 58FE 5912 8882 B188 8489"
	$"8388 9C88 AFDB C74B 275D 93A3 A4F1 A3FF"
	$"A5EF A311 C2C8 AEAE B5C8 BFBF BDBD B4C8"
	$"BDB8 BCBC C29C FEA3 24CF B8BD D1BD B5B0"
	$"B5B0 BFBF B8BD BDB8 C99D A3A3 9BC2 BDBD"
	$"B8B9 BDBD B8BD BDB8 BDE3 C1C6 B0B1 FDA3"
	$"0CB3 AEE3 BDC1 C6B8 BDC8 B5C1 ECD7 010C"
	$"0601 0F3C 433E 3E3D E03E FF3C 397B 76A6"
	$"7A72 787E 937C 7672 787C A27B 7441 413C"
	$"3C41 727C 767B 7572 78A1 7C7C 927B 7C90"
	$"7C78 413E 3D44 7574 757B A574 75A5 7B93"
	$"7C75 757C 7678 3FFD 3E13 757B 7575 7D92"
	$"7B75 7878 A8A8 D709 1850 5759 5958 FD59"
	$"F659 FF5A F359 FD5A 3988 83B2 8784 8A87"
	$"9B88 8284 8988 AD88 8258 585A 5A58 8488"
	$"8288 8384 89AC 8888 9C88 899D 898A 5859"
	$"5856 8382 8388 B182 83B1 889D 8883 8388"
	$"8289 57FD 5910 8388 8383 899C 8883 8989"
	$"B0B0 DA1E 2D8D 93EF A3FF A5F3 A3FF A5FF"
	$"A339 BDB9 E4BC C2C8 AABE B5B0 C1C6 B5D7"
	$"BDB7 9B9B A3A3 9BC2 B5B0 BDB8 C1C6 D6B5"
	$"B5C8 BDBE D0BE C89B A3A3 8FB8 B7B8 BDE3"
	$"B7B8 E3BD C9B5 B8B8 B5B0 C99C FDA3 0CB8"
	$"BDB8 B8B6 C8BD B8C6 C6D1 D1E9 011B 0300"
	$"2900 43E5 3E00 40FE 3E09 403E 3D3E 3C3C"
	$"4475 7B75 FD78 217C A178 7876 7C75 7B72"
	$"413C 3C41 7892 7C75 7B78 7876 7D76 7C7B"
	$"907B 7B72 4140 3E44 75FE 7B00 75FE 7B08"
	$"757C 767C 7B92 7C78 72FD 3E10 7A75 7B7B"
	$"767C 7B75 7872 A8D4 C407 2F25 57FA 59F6"
	$"59FF 5AF9 5900 5AFE 5902 5A59 59FE 5A29"
	$"5683 8883 8A8A 8181 88AC 8989 8288 8388"
	$"8458 5A5A 588A 9C88 8388 8989 8289 8288"
	$"889D 8888 8458 5A59 5683 FE88 0083 FE88"
	$"0883 8882 8988 9C88 8984 FD59 1087 8388"
	$"8882 8888 8389 84B0 DBC7 1B42 5D93 EFA3"
	$"FFA5 F9A3 00A4 FEA3 2FA4 A3A4 A5A3 A38F"
	$"B8BD B8C8 C8A5 A5B5 D6C6 C6B0 B5B8 BDC2"
	$"9BA3 A39B C8C8 B5B8 BDC6 C6B0 B6B0 B5BD"
	$"D0BD BDC2 9BA4 A38F B8FE BD00 B8FE BD08"
	$"B8B5 B0BE BDC8 B5C9 C4FD A30C BCB8 BDBD"
	$"B0B5 BDB8 C6C1 D1FB D701 1A03 0F01 3C43"
	$"ED3E 023D 3E40 F63E FF3F FF3E 3972 7975"
	$"7B92 7C76 7B78 727C 927B 757B 7578 413E"
	$"3E41 7879 7892 7C91 7B75 7B92 7C75 7B76"
	$"7678 413E 3E41 4178 7276 7C76 7673 7971"
	$"7892 7C78 7276 7CFD 3E10 7B75 A776 7C76"
	$"A57B 757C C6C6 AD18 0A50 57FA 59F4 5905"
	$"5859 5A59 5A5A FB59 FD5A FF59 3984 8B83"
	$"889C 8882 878A 8488 9C88 8388 838A 5859"
	$"5958 8A8A 899C 889C 8883 889C 8883 8882"
	$"828A 5859 5958 5889 8482 8882 8283 8983"
	$"899C 8889 8482 88FD 5910 8883 B182 8882"
	$"B188 8188 C8C8 B530 228D 93EF A3FD A303"
	$"A4A3 A5A5 FBA3 FFA5 FDA3 39C2 C8B8 BDC8"
	$"B5B0 B4C8 C2B5 C8BD B8BD B8C8 9BA3 A39B"
	$"C8C7 C6C8 B5C8 B5B8 BDC8 B5B8 BDAE AEC8"
	$"9BA3 A399 99C6 C1B0 B5AE AEB8 BDC0 C6C8"
	$"B5C6 C1AE B3FD A30C BDB8 DBB0 B5B0 E3BD"
	$"AFB5 D0D0 D601 0C03 010F 0043 DF3E FF3F"
	$"FF3E 3941 787B 757C 767C 9377 7876 7C75"
	$"7B7B 7572 413E 3E41 7272 787C 777B 757A"
	$"757C 767B 757C A772 413E 3E41 7278 7892"
	$"7C7C A773 7978 787C 7678 7877 76FD 3E10"
	$"757B 767C 927C 767B 927C AED5 C00A 1825"
	$"57FA 59F0 59FF 5AFB 59FD 5AFF 5930 588A"
	$"8883 8882 889D 898A 8288 8388 8883 8458"
	$"5959 5884 8489 8883 8882 8783 8882 8883"
	$"88B1 8458 5959 5884 8989 9C88 88B1 83FE"
	$"8905 8882 8989 8382 FD59 1083 8882 889C"
	$"8883 889C 88AF D7C7 2230 5D93 EFA3 FBA3"
	$"FFA5 FBA3 FFA5 FDA3 399B C8BD B8B5 B0B5"
	$"C9C7 C8B0 B5B8 BDBD B8C2 9BA3 A39B C2C1"
	$"C6B5 B1B5 B0BC B8B5 B0BD B8B3 DAC2 9BA3"
	$"A399 C1C6 C6C8 B5B3 DAB8 BDC6 C6B5 B0C6"
	$"C6AF AEFD A30C B8BD B0B5 C8B5 B9BD C8B5"
	$"B8DF E801 2303 2A00 3C43 F53E FF3C FB3E"
	$"FD3F 0540 4243 4341 41F9 3E4E 767C 927C"
	$"767C 7B7B 7676 7B75 7CA2 7278 4343 403E"
	$"4178 7C93 7C76 7778 907B 7D7D 907A 7B75"
	$"7841 3E3E 4172 7676 7878 7676 7B90 7B91"
	$"757B A176 7841 3E3E 403E 7C76 7878 7B75"
	$"7A75 7878 A8A8 D830 0750 57FA 59FC 59FF"
	$"5AF7 5905 5556 5757 5858 F959 0482 889C"
	$"8882 FE88 FF82 4488 8388 AD84 8957 575A"
	$"5958 8A88 9D88 8288 899D 8887 879D 8788"
	$"838A 5859 5958 8482 828A 8A82 8288 9D88"
	$"9C83 88AC 828A 5859 595A 5988 828A 8A88"
	$"8387 8389 89B0 B0DC 431B 8D93 F5A3 FFA5"
	$"FDA3 FBA3 FF8F FF9B FF99 F9A3 04B0 B5C8"
	$"B5B8 FEBD FFB0 40BD B8B5 D7C1 C69B 9BA4"
	$"A39B C8B5 C9B5 B0C5 C6D0 BDB5 B5D0 BCBD"
	$"B8C8 9BA3 A39B C2AE AEC8 C8AE AEBD D0B5"
	$"C8B8 BDD6 B0C8 9BA3 A3A4 A3B5 B0C8 C8BD"
	$"B8BC B8C6 C6D1 D1EB 012F 0301 2900 43F5"
	$"3EFF 3CFB 3E0C 3F3E 3F3E 7373 7A74 7241"
	$"3E3E 40FC 3EFF 7637 7C76 7CA6 7575 7CA7"
	$"747A 767C 7878 7443 3E3E 4172 767D 7CA1"
	$"7872 7B7B 9177 7B7B 757B 7241 3E3E 4141"
	$"7CA7 7872 767C 7C7B 757B 7B76 7D7C 7872"
	$"FD3E 107C A178 7275 7B7B 7578 72A9 D4C3"
	$"092F 2557 FA59 FC59 FF5A FA59 0B58 5958"
	$"8383 8984 8458 5959 5AFC 59FF 8237 8882"
	$"88B0 8383 88B1 8287 8288 8989 8457 5959"
	$"5884 8289 88AC 8984 8888 9B82 8888 8388"
	$"8458 5959 5858 88B1 8A84 8288 8988 8288"
	$"8883 8988 8A84 FD59 1088 AC8A 8483 8888"
	$"8389 84B1 DBC7 1E42 5D93 F5A3 FFA5 FDA3"
	$"FBA3 FFB8 06C8 C2C1 99A3 A3A4 FCA3 FFB0"
	$"37B5 B0BD E3B8 B8B5 DBB7 BCB0 B5C6 C6C2"
	$"9BA3 A39B C2B0 B6B5 D6C6 C1BD BDC7 B0BD"
	$"BDB8 BDC2 9BA3 A39B 9BB3 DAC8 C2AE B3BE"
	$"BDB0 B5BD B9B6 B5C8 C2FD A30C B5D6 C8C2"
	$"B8BD BDB8 C6C1 D2FB D601 3206 0F01 3C43"
	$"3E3E 3DF0 3E0B 4475 7B7B 7878 757B 7973"
	$"4141 FB3E 1D41 777B 7C92 7C72 7976 7C7B"
	$"757B 7576 7C72 413D 3E41 7878 7275 7B76"
	$"7C75 7BFD 7802 A776 77FE 3E11 4172 7872"
	$"757B A776 767C 757B 777D 7575 7C76 FD3E"
	$"1374 7B75 7BA5 7576 A775 7BC4 C4AD 180A"
	$"5057 5959 58FD 59FE 59FF 5AF9 590B 5683"
	$"8888 8A8A 8388 8983 5858 FB59 2458 8988"
	$"899C 8884 8A82 8888 8388 8382 8884 5858"
	$"5958 8A89 8483 8882 8883 8889 8981 81B1"
	$"828A FE59 1158 8489 8483 89B1 8282 8883"
	$"8882 8783 8388 82FD 5910 8288 8388 B183"
	$"82B1 8388 C8C8 B530 228D 93F7 A3FF A5FB"
	$"A3FF A30B 8FB8 BDBD C8C8 B8BD BDB8 9B9B"
	$"FBA3 249B C7BD BEC8 B5C1 C7B0 B5BD B8BD"
	$"B8AE B3C2 9BA3 A39B C8C6 C1B8 BDAE B3B8"
	$"BDC6 C6A5 A5DA AECF FEA3 119B C2C6 C1B7"
	$"BCDA AEB0 B5B8 BDB0 B5B8 B8B5 B0FD A30C"
	$"B7BD B8BD E3B8 B0DB B8BD D9D9 D601 3503"
	$"010D 0043 F03E 0E3D 3E3E 757B 7575 7278"
	$"757B 7379 7872 FC3E 253D 7278 907B 7C76"
	$"7878 7676 7BA5 767B A776 4141 3E3E 4172"
	$"7979 7C75 7CA1 7B75 7278 A878 7C76 77FE"
	$"3E11 413F 7878 757B 767C 7C92 7B75 A877"
	$"7B7B 7676 FD3E 107B 757B 757B 7B76 7D74"
	$"7BAB D7C1 0A16 2557 FA59 FE59 FF5A FC59"
	$"0E58 5959 8388 8383 848A 8388 8389 8A84"
	$"FC59 2558 848A 9D88 8882 8989 8282 88B1"
	$"8388 B182 5858 5959 5884 8A8A 8983 88AB"
	$"8883 8489 B081 8882 8AFE 5911 5857 8989"
	$"8389 8288 889C 8883 B082 8888 8282 FD59"
	$"1088 8388 8388 8882 8982 88AF DBC8 222F"
	$"5D93 F7A3 FFA5 FBA3 FFA3 0BB8 BDB8 B8C2"
	$"C8B8 BDB8 BDC8 C2FB A324 C2C8 D0BD B5B0"
	$"C6C6 B0B0 BDE3 B9BD DAAE 9B9B A3A3 9BC2"
	$"C7C7 BEB8 B3D5 BDB8 C1C6 D1A5 B3AE CFFE"
	$"A311 9B9A C6C6 B7BC AEB3 B5C8 BDB8 DBB0"
	$"BDBD B0B0 FDA3 0CBD B8BD B8BD BDB0 B6B7"
	$"BDC1 ECE8 0142 0729 003C 433E 3E41 3FF2"
	$"3E0E 3D7C 7578 787C 767B 757A 7B75 7C72"
	$"40FD 3EFF 750F 7C75 767D 7A7A A77C 7878"
	$"7C7C 767C 7342 FE41 3C78 927C 907B 7278"
	$"77A8 7B75 7278 757B 7240 3E3E 4272 927C"
	$"757B 767C 757C 7B7B 757C 7C92 7A43 3E40"
	$"3E3E 747B 777D 7575 7B7B 767C AAAA C42E"
	$"0550 5759 595A FD59 FC59 FF5A FC59 0E58"
	$"8983 8A8A 8882 8883 8889 8389 8458 FD59"
	$"FF83 0F88 8181 8781 81B1 8881 8188 8882"
	$"8883 56FE 5810 8A9C 889D 8984 8982 B088"
	$"8384 8A83 8884 58FE 5928 849C 8883 8882"
	$"8883 8988 8883 8988 9C89 5759 5A59 5982"
	$"8882 8783 8388 8882 88B0 B0C8 3B13 8D93"
	$"A3A3 A4F8 A3FF A5FD A3FF A30D BEB8 C8C8"
	$"B5B0 BDB8 BCBC B8BE C199 FDA3 FFB8 48B3"
	$"ADAF B5A5 A5DA B3A5 A5BD BDAE B3B8 8F99"
	$"999B C8C8 B5D1 BFC1 C6B0 DBBD B8C2 C8B8"
	$"BDC4 9DA3 A39C C2C8 B5B8 BDAE B3B8 BEBD"
	$"BDB8 BEB3 C6C8 9BA3 A4A3 A3B7 BDB0 B5B8"
	$"B8BD BDB0 B5CA CAD6 0140 0700 2900 433E"
	$"3E3F 3FF5 3E12 3D3E 3E77 757B 7278 927C"
	$"757B 7575 7B75 7840 40FE 3EFF 7BFF A7FF"
	$"A8FF AA00 A7FE A8FF A6FF A729 7973 7872"
	$"3FA3 7C76 7B7B 7878 777D 757B 7877 7B75"
	$"7840 3E3E 4141 7C76 A57B 76A7 757B 907B"
	$"757B 767C 7A74 FE3E 113D 7BA5 7D92 7B7B"
	$"907C 927C AAD1 D805 2E25 57FA 59FC 59FF"
	$"5AFF 5912 5859 598A 8388 848A 9C88 8388"
	$"8383 8883 8A58 5AFE 59FF 88FF B1FD B001"
	$"B1B2 FDB0 FFB1 0789 8389 8457 B288 82FD"
	$"891D 8287 8388 8A89 8883 8958 5959 5858"
	$"8882 B188 82B1 8388 9D88 8388 8288 8984"
	$"FE59 1158 88B1 879C 8888 9D89 9C88 B0D7"
	$"DB13 3B5D 93F5 A3FF A5FD A310 A3CF B8BD"
	$"C2C8 C8B5 B8BD B7B7 BDB8 C699 A4FE A3FF"
	$"BDFF DAFF DBFF D131 DADB D1D1 E3E3 DADA"
	$"BDB8 C6C1 9AED B5B0 BFBF C6C6 B0B5 B8BD"
	$"C8C7 BDB8 C99D A3A3 9B9B B5B0 E3BD AEDA"
	$"B8BD D0BD B8BD AEB3 C8C2 FDA3 0CBD E3B5"
	$"C8BD BDD0 BEC8 B5CA EFE9 0135 FF00 013C"
	$"44F3 3E00 40FE 3E1A 757B 767B A17C 7B75"
	$"7CA2 7B7B A37E A77C 757B 757B A7A7 A8A8"
	$"A7A7 A9FC A8FF AAFF A829 7C76 7871 7DA7"
	$"A8A7 A8A8 A6AA 7C76 7E93 7B74 76A7 7241"
	$"3E3E 4172 7878 7373 7A75 7B75 7D77 7B91"
	$"7B75 7B76 FE3E 133D 7777 7878 767C 7971"
	$"7B7B C3B0 C10B 0B50 565A 5AFC 59FA 5900"
	$"5AFE 5917 8388 8388 AC88 8883 88AD 8888"
	$"AB87 B188 8388 8388 B1B1 B0B0 FEB1 F8B0"
	$"0488 828A 8489 FEB1 FFB0 1FAC B088 8287"
	$"9B88 8282 B184 5859 5958 8489 8983 8387"
	$"8389 8387 8188 9D88 8387 82FE 5913 5881"
	$"818A 8A82 888B 8388 88C8 B5C8 2729 8C91"
	$"A5A5 F5A3 00A4 FEA3 1AB8 BDB9 BDD6 B5BD"
	$"B8B5 D7BD BDCC AADA B3B8 BDB8 BDDA DAD1"
	$"D1DB DBD2 F8D1 06B5 B0C6 C0B6 DBD2 FED1"
	$"1FC5 CAB5 B0AA BEBD B7AE DAC2 9BA3 A39B"
	$"C2C6 C6B8 B8BC B8BF BAB3 AEBD D1BD B8B4"
	$"B0FD A3FF AEFF C808 B0B5 C8C2 BDBD E1CF"
	$"E801 2D03 2800 0044 EF3E 1975 7B7B 757C"
	$"757B 75A7 7CA5 A5A8 A8A7 A775 7B7B 757C"
	$"A7A8 A87C A7FE A80B A9A8 A8AA AAA8 A8A7"
	$"7678 7876 FEA7 FFA8 FFAA FFA7 FFA8 197B"
	$"A576 7C78 3F3E 3E41 4172 7879 7975 7B75"
	$"7B77 A87B 7B75 7B76 76FD 3E12 7D77 7278"
	$"7C92 7878 7575 AAD1 AD2F 0B24 565A 5AFC"
	$"59F6 590A 8388 8883 8881 8883 B188 B1FE"
	$"B0FF B109 8388 8883 88B1 B0B0 88B1 FEB0"
	$"00B1 FBB0 04B1 828A 8A82 FEB1 FDB0 FFB1"
	$"FFB0 0A88 B182 888A 5759 5958 5884 FE89"
	$"0B83 8883 8981 B088 8883 8882 82FD 5912"
	$"8781 848A 889C 8A8A 8383 B0D7 B54B 275B"
	$"91A5 A5F1 A319 B8BD BDB8 B5AF BDB8 DBB5"
	$"E3E2 D1D1 DADA B8BD BDB8 B3DA D1D1 B5DB"
	$"FED1 00D2 FBD1 05DB B0C6 C6B0 DBFD D1FF"
	$"CAFF DBFF D119 BDE3 AEB3 C89A A3A3 9B9B"
	$"C1C6 BDBD B8BD BABF AEDA BDBD B8BD B0B0"
	$"FDA3 04B3 AEC2 C8B5 FEC8 FFB8 02CA EFD6"
	$"012F 0301 0F3C 43F5 3EFF 3CFD 3E04 757B"
	$"927C 78FC A81F A9A8 A7A7 A8A8 7B75 757B"
	$"93A8 A7A7 A8A8 A77C A77B A77C A77B A7A7"
	$"7B7B 7575 7CA7 FEA8 FCA7 1BA8 A9A8 A8AA"
	$"95A7 463E 3E44 757C 767C 9378 78A0 7B7B"
	$"7575 7BA2 7C78 3FFD 3E10 7278 7C92 7C76"
	$"7C92 7979 AAD1 D209 1850 57FA 59FC 59FF"
	$"5AFD 5904 8388 9C88 81FC B022 B1B0 B1B1"
	$"B0B0 8883 8388 9BB0 B1B1 B0B0 B188 B187"
	$"B188 B187 B0B0 8888 8383 88B1 B0B0 B2FC"
	$"B101 B0B1 FEB0 169B B155 5959 5683 8882"
	$"889D 8A8A AC88 8883 8388 AD88 8A57 FD59"
	$"1084 8988 9C88 8286 9C89 89B0 D7D6 1E2D"
	$"8D93 EFA3 04B8 BDC8 B5A5 FCD1 25D2 D1DB"
	$"DBD1 D1BD B8B8 BDBE D1DA DAD1 D1DA B3DB"
	$"B4DA B3DB B4D1 D1BD BDB8 B8B5 DBD1 D1DC"
	$"DBDA DAFE D11A D2D1 D1CA B6DB 87A3 A38F"
	$"B8B5 B0B5 C9C8 C8DE BDBD B8B8 BDD7 B5C8"
	$"9AFD A30C C1C6 B5C8 BDB8 B4C8 C4C4 CAEF"
	$"E501 2104 0029 0043 3DF6 3EFF 3CFD 3E03"
	$"7CA5 7CA7 F9A8 0DA7 7BA8 A875 7B7B 757E"
	$"A87C A7A8 A8F8 A70C A8A5 757B 7B76 A7A8"
	$"A87C A7A7 7CFE A71A A9A8 A8AA AAA7 7678"
	$"3E44 757C 927C 7678 727B 7A75 7B7B 757C"
	$"7678 72FD 3EFF 780F 767C 767C 777C 7972"
	$"A9D6 AB07 2F25 5758 FB59 FC59 FF5A FD59"
	$"0389 B188 B1F9 B00D B187 B0B0 8388 8883"
	$"87B0 88B1 B0B0 F9B1 11B0 B1B1 8388 8882"
	$"B1B0 B088 B1B1 88B1 B1AF B1FD B015 B182"
	$"8B59 5683 889C 8882 8A84 8887 8388 8883"
	$"8882 8A84 FD59 FF89 0E82 8882 8882 8689"
	$"83AF DCAE 1B42 5D93 EFA3 03BE E3B5 DBF9"
	$"D141 DBB4 D1D1 B8BD BDB8 AAD1 B3DA D1D1"
	$"DADA DBDB DADA DBDB D1D1 E3B8 BDBD B0DB"
	$"D1D1 B5DB DAB3 D1D1 D0D2 D1D1 CACA DBB0"
	$"D0A3 8FB8 B5C8 B5B0 C8C2 BDBC B8BD BDB8"
	$"B5B0 C8C2 FDA3 FFC6 0AB0 B5B8 BDB0 B4C4"
	$"BFC9 F4BF 0137 030F 013C 43F9 3E00 40FC"
	$"3E0D 403E 4375 A7A7 A8A8 A7A7 7CA7 A77C"
	$"FBA8 037B 757B 7BFE A802 A9A8 7FFE A80D"
	$"A7A8 A8A7 A0A5 7B75 7B76 767B A5A9 FAA8"
	$"087C A7A7 7CA8 A97B 7B75 FE7B 24A8 7D75"
	$"7A76 7B78 787B 907B 757B 757C 763E 3E3C"
	$"3C75 75A7 7C7C 7778 7277 A7AA C3D4 180A"
	$"5057 FA59 0159 5AFC 590D 5A59 5583 B1B1"
	$"B0B0 B1B1 88B1 B188 FBB0 0988 8388 88B2"
	$"B2B0 B1B0 88FE B00D AFB0 B0B1 ABB1 8883"
	$"8882 8288 B1B1 FAB0 0888 B1B1 88B0 B188"
	$"8883 FE88 24B0 8783 8782 8781 8188 9D88"
	$"8388 8388 8259 595A 5A83 83B1 8888 8389"
	$"8483 B1B0 C8DB 3022 8D93 F9A3 00A4 FCA3"
	$"03A4 A38F B8FD D1FF DB05 B3DA DAB3 DADA"
	$"FDD1 09BD B8BD BDDC DCD1 D2D1 ABFE D10D"
	$"D0D1 D1DB D6E3 BDB8 BDAE AEBD E3D2 FAD1"
	$"08B3 DADB B5D1 D2BD BDB8 FEBD 0FDA B3B8"
	$"BCB0 B4A5 A5BD D0BD B8BD B8B5 B0FD A3FF"
	$"B80A DBB5 B5B1 C6C1 AFDA C8E0 FB01 2E03"
	$"010F 0042 FD3E 0340 3E3E 40FA 3E07 7775"
	$"7BA7 A7A8 A87C FCA7 01A8 7DFD A809 747B"
	$"7575 767C 937E 78A3 FB78 FF7C 0875 7B75"
	$"4476 7C43 A578 FAA8 FDA7 FFA8 2AA5 757C"
	$"7575 A5A8 A8A5 7BA1 7C7E 937A 7B75 7A75"
	$"7B75 763E 3D3C 3C7B 7B76 767C A178 787C"
	$"76AA D6A8 0A18 2456 FD59 025A 5959 005A"
	$"FA59 078A 8388 B1B1 B0B0 88FC B101 B087"
	$"FDB0 0982 8883 8382 889B 8781 ABFB 81FF"
	$"8808 8388 8356 8288 55B1 81FA B0FD B1FF"
	$"B02A B183 8983 83B1 B0B1 B188 AC88 879B"
	$"8788 8387 8388 8182 5958 5A5A 8888 8282"
	$"88AC 8989 8882 B0DB B022 305C 92FD A303"
	$"A4A3 A3A4 FAA3 02CF B8BD FDD1 01B5 DBFC"
	$"DA00 B3FD D109 B7BD B8B8 B0B5 BEAA A5CC"
	$"FBA5 FFB5 08B8 BDB8 8FAE B38F E3A5 FAD1"
	$"FFDA FFDB FFD1 15E3 B8BE B8B8 E3DA DBE3"
	$"BDD6 B5AA BEBC BDB8 BCB8 BDAF B0FD A3FF"
	$"BDFF B008 B5D6 C6C6 B3AE C8F2 D101 5809"
	$"2900 3C44 3E3E 403E 3C3C FD3E FF41 FF75"
	$"1B7B 757B 75A8 7CAA AAA9 A8A9 AAA7 A7A8"
	$"A2A7 A774 7B3E 3E3D 3D76 7C7B 75FD 78FF"
	$"7BFF 782D 757B 757B 7544 3E3E 3F72 7979"
	$"7576 7C76 7BA5 9F7B AAAA A7A7 A57B 767C"
	$"7B75 7CA7 AAAA A8A8 767C 7C76 7878 A17C"
	$"783F FD3E FF75 FF7B 1375 7B7C 9272 78A9"
	$"A8D6 2F07 5056 5959 5A59 5A5A 59FE 59FF"
	$"58FF 8339 8883 8883 B187 B0B0 B1B0 AFB0"
	$"B1B1 B0AA B1B1 8289 5A5A 5858 8288 8983"
	$"8A8A 8989 8888 8989 8388 8388 8356 5959"
	$"5784 8989 8182 8882 88B1 AB88 B0B0 FEB1"
	$"1488 8288 8882 88B1 B0B0 B2B2 8288 8882"
	$"8A8A AC88 8A57 FD59 FF83 FF88 0F83 8888"
	$"9C84 89B1 B0D6 421B 8C91 A3A3 A4FA A3FF"
	$"9BFF B803 BDB8 BDB8 4DDD B6CA CAD2 D1C9"
	$"CADB DBD1 CBDB DBB9 BFA5 A5A3 A3B0 B5BF"
	$"BAC8 C8C6 C6BD BDC6 C6B8 BDB8 BDB8 8FA3"
	$"A398 C1C4 C4AF B0B5 B0BD E3DD BDCA CADA"
	$"DAE3 BDB0 B5B5 B0B3 DAD1 D1DB DBB0 B5B5"
	$"B0C8 C8D6 B5C8 9AFD A3FF B8FF BD08 B8BD"
	$"B5C8 C1C6 D2D1 D601 5003 0129 0044 FD3E"
	$"FF3C FD3E 0178 72FE 7B12 757B 75A6 A8A5"
	$"AAA8 A8A5 AA7C A778 7E7C 7675 7BFE 3E2F"
	$"4076 767B 7578 7272 7875 7578 7275 7B75"
	$"7B75 4440 3E41 7879 7276 7C7C 927B 757B"
	$"7BA5 AA7C A7A5 7B92 7C75 A6A7 A7AA AA7C"
	$"FEA7 077B 9378 727C 7578 72FD 3EFE 7B0D"
	$"9175 7B76 7C78 78A8 D4C7 092F 2456 FD59"
	$"FF5A 0059 FE59 018A 84FE 8805 8388 83B0"
	$"B1AB FEB0 36AB B088 B181 8788 8283 895A"
	$"5A59 5A82 8289 838A 8484 8983 8389 8483"
	$"8883 8883 565A 5958 8989 8382 8888 9C88"
	$"8388 88AB B088 B1B0 889C 8882 FEB1 FFB0"
	$"0088 FEB1 0787 9D8A 8488 818A 84FD 59FE"
	$"880D 9D83 8882 8889 89B0 DBC7 1E42 5B91"
	$"F7A3 01C8 C2FE BD02 B8BD B84D DBDD C4CA"
	$"D1D1 C4CA B5DB A5AA B5B0 BABF A5A5 A3A4"
	$"B0B0 BFBA C8C2 C1C6 B8B8 C6C1 B8BD B8BD"
	$"B88F A4A3 99C6 C4BF B0B5 B5C8 BDB8 BDBD"
	$"C4CA B3DA E2BD C8B5 B0DB DADA D1D1 B3DA"
	$"DBDB B4C9 C8C2 B5AF C8C2 FDA3 FEBD 09D1"
	$"B8BD B0B5 C6C6 D1FB C701 5503 1203 3C43"
	$"FB3E FF41 5775 7B75 7B73 737B 757B 7BA8"
	$"A8A5 7BA7 7C7B 7C76 767B 7578 7278 723C"
	$"3C3E 3E41 7776 7C77 7D7B 757B 7B76 7C7D"
	$"7778 7272 413E 3E42 7276 7C78 7276 7B7C"
	$"767B 9078 7892 A8A5 757B 7C75 A5A8 A8A7"
	$"A7A9 A8A6 A6A7 7C76 A775 7B76 75FD 3E10"
	$"7692 7B7B 7C76 798F 7C92 ABC4 AD18 0A50"
	$"57FB 5900 5830 5883 8883 8883 8388 8388"
	$"88B0 B0B1 88B1 8888 8982 8289 838A 8489"
	$"845A 5A59 5958 8982 8882 8788 8388 8882"
	$"8887 8189 8484 58FE 5916 8482 8889 8482"
	$"8788 8288 9D8A 8A9A B0B1 8388 8983 B1B0"
	$"B0FE B100 B0FE B106 8882 B183 8882 81FD"
	$"5910 829C 8989 8882 899D 889C AFC8 B530"
	$"228D 93FB A3FF 9B09 B8BD B8BD B8B8 BDB8"
	$"BDBD FFD1 0DE3 BDDB B5BD BEB0 B0BC B7C8"
	$"C2C6 C1FD A339 9BC7 AEB3 B0B5 BDB8 BDBD"
	$"AEB3 B3AE C6C1 C29B A3A3 9CC2 B0B5 C9C4"
	$"B0B4 B5B0 BDD0 C8C8 BDD1 E3B8 BDBE B8E3"
	$"D1D1 DBDB D2D1 DBDB DAB3 B0DB B8BD B1B0"
	$"FDA3 0CB0 C8BC BCB5 B0BD D0B5 C8C1 D9D6"
	$"015D 0303 1200 43FE 3E1A 403E 3E72 787C"
	$"757B 757A 7975 7B75 75A8 A9A5 7B91 7D90"
	$"7B76 7C7B 75FE 7836 773C 3C3E 3E72 78A7"
	$"777D 927C 7575 A576 767D A277 7841 413E"
	$"3E41 787C 9278 787C 927C 927B 7B72 787E"
	$"787B 4475 757B 7CA8 A87C A7A8 A87B A6FE"
	$"A704 7C7A 757C 76FD 3E10 7C7D 7575 7CA1"
	$"7979 767C ABD2 CF0A 1825 57FE 5903 5A59"
	$"5984 4F8A 8983 8883 8A89 8388 8383 B0B1"
	$"B188 9C89 9D88 8288 8983 8A8A 8988 5A5A"
	$"5959 848A B183 879C 8983 83B1 8282 87AB"
	$"8889 5858 5959 588A 889C 8989 889C 889C"
	$"8888 848A 8781 8856 8383 8889 B0B0 88B1"
	$"B0B0 88FD B104 8887 8387 82FD 5910 8889"
	$"8383 88AC 8989 8288 AFD6 D722 305D 93FE"
	$"A30E A4A3 A3C2 C8BE B8BD B8BE BDB8 BDB8"
	$"B80F D1D2 E3BD C7B6 D0BD B0B5 BCB7 C8C8"
	$"C6C5 FDA3 39C2 C8DA AFB5 C8BE B8B8 E3AE"
	$"AEB3 D5C5 C69B 9BA3 A39B C8B5 C8C9 C9B5"
	$"C8B5 C8BD BDC2 C8AA A5BD 8FB8 B8BD BED1"
	$"D1B5 DBD1 D1B5 DBDA DADB B5BC B8B6 B1FD"
	$"A30C B5B6 B7B7 B5D6 BDBD B0B5 C1E7 F601"
	$"5703 2B02 3C43 FD41 5378 A87C 767C 767B"
	$"757B 757B 7578 787A 757B 7578 727C 927B"
	$"7B90 7B92 7C92 763F 3F3E 3E75 757B 7678"
	$"7890 7B7C 767A 7B72 7875 7B76 443E 3E41"
	$"727B 757C 7675 7B72 797C 7679 7375 7A72"
	$"403E 3E44 75A7 A7A8 A7A3 A8AA AAFD A8FF"
	$"AA16 7B44 3E3E 3C3C 7C75 7B7B 7178 757B"
	$"757C A8D4 AB2E 0550 57FD 5802 81B0 884D"
	$"8288 8288 8388 8388 8389 8987 8388 838A"
	$"8488 9C88 889D 889C 889C 825A 5A59 5983"
	$"8388 838A 8A9D 8888 8287 8884 8A83 8883"
	$"5659 5958 8488 8388 8283 8884 8B88 8289"
	$"8383 8784 5859 5956 83B1 B1B0 AFAB F8B0"
	$"2888 5659 595A 5A88 8188 8883 8983 8883"
	$"89B0 DBAF 3D15 8D93 9999 9B9B A5D1 B5B0"
	$"B3AE BDB8 BDB8 BDB8 C6C6 0FBC B8BD B8C8"
	$"C2B5 C8BD BDD0 BDC8 B5C8 B0FD A3FF B837"
	$"BDB9 C8C8 D0BD B5B0 BCBD C2C8 B8BD B98F"
	$"A3A3 9BC2 BDB8 B5B0 B8BD C2C8 B5B0 BDB8"
	$"B8BC C49D A3A3 8FB8 DADA D1D0 CCD1 CACA"
	$"D1D1 D3D3 D1D1 BD8F FDA3 0CB5 AFBD BDC0"
	$"C6B8 BDB8 BED1 FBBF 015A 0902 2B00 4341"
	$"7278 A4A8 A8FD A74D 757B 757B 757B 7241"
	$"7B75 7B75 7878 767C 7B90 7B7B 7C76 7C7C"
	$"3F3F 3E3E 447B 7B75 7872 7B7B 927B 7B90"
	$"7777 757B 7544 3E3E 4178 757B 76A8 7B75"
	$"7878 927C 7379 7B75 7840 3E3E 4475 7C76"
	$"A8A8 7EA8 AAA5 FDA8 FFAA 1DA5 753E 3E3C"
	$"3C7C 937B 9078 7775 7B75 7BA8 A8D2 052E"
	$"2457 5884 8AB3 B0B0 B1FE B111 8388 8388"
	$"8388 8458 8883 8883 8A8A 8288 889D FE88"
	$"3882 8888 5A5A 5959 5688 8883 8A84 8888"
	$"9C87 889D 8989 8388 8356 5959 588A 8388"
	$"82B2 8883 8A8A 9C88 8389 8883 8958 5959"
	$"5683 8882 B0B0 87B0 B0AB FBB0 28B1 8359"
	$"595A 5A88 9D88 9D89 8883 8883 88B0 B0D6"
	$"153D 5C93 99C1 C8EE D1D1 DBDB DADA B8BD"
	$"B8BD B8BD C199 0FBD B8BD B8C8 C8B0 B5BD"
	$"D0BD BDB5 B0B5 B5FD A31B 8FBD BDB8 C8C2"
	$"BDBD C8B4 BDD0 C7C7 B8BD B88F A3A3 9BC8"
	$"B8BD B0DC BDB8 FEC8 1AB5 B8BD BDB8 C99D"
	$"A3A3 8FB8 B3AE D1D1 AAD1 CAC4 D1D1 D3D3"
	$"D1D1 E3B8 FDA3 0CB5 C9BD D0C6 C5B8 BDB8"
	$"BDD1 D1E5 015E FF00 033E 467A AAFE A802"
	$"A7AA AAFE A716 7B72 7872 413E 3F75 7B90"
	$"7B78 A878 7275 7B75 757C 767D 76FD 3E24"
	$"767C 757B 927C 777D 7872 757B 7676 7C75"
	$"7544 3E3E 4172 A876 7B75 7B7B 927C 757B"
	$"A676 7C76 77FE 3EFF 4103 7B75 7871 FEA7"
	$"007C FEA7 1AA6 A8A8 A57B 7544 3E3E 747B"
	$"7878 7676 A575 7C92 ABD7 C10C 0C4E 5581"
	$"FEB0 02B2 B1B0 00B0 FEB1 1687 8489 8458"
	$"5A5B 8388 9D88 81B0 8984 8388 8383 8882"
	$"8882 FD59 2482 8883 889C 8882 878A 8483"
	$"8882 8289 8383 5659 5958 84B2 8288 8388"
	$"889C 8883 88B0 8288 828A FE59 FF58 0388"
	$"838A 83FE B100 88FE B1FE B017 B188 8356"
	$"5959 8288 8A8A 8282 B183 889C AFDB C827"
	$"2981 87A5 FED1 0DDB DAD1 D1DA DADB B4C1"
	$"C6C2 9BA5 A60F B8BD D0BD A5D1 C6C1 B8BD"
	$"B8B8 B5B0 BEB8 FDA3 24B8 BDB8 BDC8 B5B0"
	$"B5C8 C2B8 BDB0 B0BE B8B8 8FA3 A39B C2DB"
	$"AEBD B8BD BDC8 B5B8 BDDB B0B5 B0CF FEA3"
	$"FF9B 20BD B8C8 C2DA DADB B5DA DADB DBD3"
	$"D3E3 BDB8 8FA3 A3B7 BDC8 C8AE AEE3 B8B5"
	$"C8CA F4EA 015A 0F27 0020 7CAA AAA8 A8A7"
	$"7CAA AAA7 7CA7 A7FD 41FF 3E03 7B75 7B7A"
	$"FD78 077B 757B 7B92 7C76 7CFD 3E2F 767C"
	$"757B 7C76 7E92 7878 7B75 A87C 757B 7544"
	$"3E3E 4178 767C 757B 907B 7C76 7B75 7C75"
	$"7CA1 7740 3E3E 4172 7B76 7878 767C FEA7"
	$"1B7C A77C A8A8 A57B 7B75 3E3E 7B75 7278"
	$"7D76 7B7B 767C ABD2 AD30 0C35 88FD B002"
	$"B188 B004 B0B1 88B1 B1FD 58FF 5A0F 8883"
	$"8887 8181 8989 8883 8888 9C88 8288 FD59"
	$"2F82 8883 8888 8288 9C8A 8A88 83B2 8883"
	$"8883 5659 5958 8A82 8883 889D 8888 8288"
	$"8388 8188 AC8A 5A59 5958 8488 838A 8A82"
	$"88FE B11B 88B1 88B0 B0B1 8888 8359 5988"
	$"8384 8A89 8288 8882 88AF D6B5 4C27 6AB5"
	$"FDD1 0DDA B3D1 D1DA B3DB DB99 999B 9BA5"
	$"A50F BDB8 BDBC A5A5 C6C6 BDB8 BDBD C8B5"
	$"B8BD FDA3 06B8 BDB8 BDB5 B0B6 FEC8 40BD"
	$"B8DC B5B8 BDB8 8FA3 A39B C8AE B3B8 BDD0"
	$"BDB5 B0BD B8B5 AFB5 D6CF A4A3 A39B C2BD"
	$"B9C8 C8AE B3DB DBDA B3DB B5D3 D3E3 BDBD"
	$"B8A3 A3BD B8C2 C8B4 AEBD BDB0 B5CA EFD8"
	$"015C 1101 287A AAA8 A8A7 7BA8 A8A6 A7A8"
	$"A17B 7572 41FD 3E61 907B 7C92 7878 7676"
	$"7CA1 7C76 7778 7C76 3E3E 3C3C 7278 76A7"
	$"757C 767C 757B 907B 7B75 7C7B 4141 3E3E"
	$"4172 7878 757B 7B75 767C 767C 757A 757B"
	$"7241 3E3E 4475 7177 7878 7B75 7B75 A7A7"
	$"A8A8 A3A8 A7A7 757B 7B75 A17B 7D93 7B75"
	$"7C92 7877 AAC3 CF0A 2E81 FEB0 01B1 87FE"
	$"B006 B1B2 AC89 8384 58FD 590F 9D88 889C"
	$"8A8A 8282 88AC 8882 898A 8882 FD5A 5C84"
	$"8A82 B183 8982 8883 889D 8888 8389 8858"
	$"5859 5958 8489 8983 8888 8382 8882 8883"
	$"8783 8884 5859 5956 8384 8A81 8188 8388"
	$"83B1 B1B0 B0AB B0B1 B183 8888 83AC 8886"
	$"9B89 8388 9C89 88B0 C8D7 2245 9DCA DADA"
	$"DBB4 D1D1 D9DA DCD6 BCB7 C199 FDA3 02D0"
	$"BDB5 FEC8 FFAE 56B5 D6B5 B0C7 C8B5 B0A5"
	$"A5A3 A3C2 C8AE DAB8 BEAE B3B8 BDD0 BDBD"
	$"B8BE BD9B 9BA3 A39B C2C6 C6B8 BDBD B8B0"
	$"B5B0 B5B8 BCB8 BDC2 9BA3 A38F B8C2 C8A4"
	$"A4BD B8BD B8DA DAD1 D1CE D3DB DBB8 BDBD"
	$"B8D6 B5AB BFBF BAB5 C8C6 C5CA E1F6 0162"
	$"7F45 6495 AAA8 7DA7 A7A8 A9A7 7D7C 7C75"
	$"7B78 413E 403E 3E7B 7B76 7C78 71A7 7D76"
	$"7C7C 9278 7293 7C3E 3E3C 3B41 7876 7C75"
	$"7CA7 767B 747C 7B75 7B90 7B72 413E 3E41"
	$"7778 72A5 7A75 7B7C A27C 927B 757B 7578"
	$"413E 3E44 7577 7778 A87B 757B 757C 76A7"
	$"A8A8 7EA7 7C75 7C75 7BA6 7C93 7E75 7A76"
	$"7C78 72AA D6AD 4A68 9BB0 B087 B1B1 B0B1"
	$"B11A 8988 8883 8989 5859 5A59 5988 8882"
	$"888A 83B1 8982 8888 9C8A 849D 88FE 5A61"
	$"5958 8A82 8883 89B1 8288 8289 8883 889D"
	$"8884 5859 5958 8989 84B1 8783 8888 AD88"
	$"9C88 8388 838A 5859 5956 838A 8A81 B088"
	$"8388 8388 82AF B0B0 87B1 8883 8983 88B1"
	$"899B 8783 8882 8889 84B0 DCB5 5F7B B6CA"
	$"DAB3 DBDB D1D2 DAB4 B5B5 B7BC C699 A3A4"
	$"A3A3 FFBD 5CB0 B5C8 C2DA B4B0 B5B5 C8C8"
	$"C2C9 B5A5 A5A3 A39B C8AE B3B8 BEDA AEBD"
	$"B7BE BDB8 BDD0 BDC2 9BA3 A39B C7C6 C1E3"
	$"BCB8 BDB5 D7B5 C8BD B8BD B8C8 9BA3 A38F"
	$"B8C8 C8A4 D1BD B8BD B8B3 AED0 D1D3 ACDB"
	$"B5B8 BEB8 BDDB B6BF ACBA BEB0 B5C6 C1CA"
	$"F4D6 0159 FF67 007E FCA8 01A6 7CFE 7504"
	$"7B75 7B76 46FE 3E4A 3D76 767C 927A 757B"
	$"757C 7674 7B7B 7578 783E 3E3F 3F75 7B75"
	$"7B76 7C75 7B76 A775 757C 7578 7175 443D"
	$"3E42 7276 7C75 747C 9178 7875 7B7C A573"
	$"7972 413E 3E41 3F7B 917B 7576 7C75 7B75"
	$"7B75 7AFE A814 937B 7578 72A8 A8A7 7C7C"
	$"917B 7576 A7AA C1C4 6969 87FC B002 B188"
	$"83FF 8304 8883 8882 54FE 594A 5882 8288"
	$"9C87 8388 8388 8282 8888 8389 8959 595A"
	$"5A83 8883 8882 8883 8882 B183 8388 8189"
	$"8383 5658 5959 8482 8883 8287 9C8A 8A83"
	$"8889 B183 8984 5859 5958 5788 9D88 8382"
	$"8883 8883 8883 87FE B014 9B89 838A 84B0"
	$"B0B1 8887 9C88 8382 B1B1 C8C7 7272 AAFC"
	$"D101 DAB3 FEB8 04BD B8BD AE85 FDA3 FFB8"
	$"0DB5 C8BC B8BD B8B5 B0B7 BDBD B8C6 C6FD"
	$"A335 B8BD B8BD B0B5 B8BD B0DB B8B8 B3AD"
	$"C6C0 B88F A3A3 9CC2 B0B5 B8B7 B6C9 C8C8"
	$"B8BD BEE3 B8BD C29B A3A3 9B9A BDD1 BDB8"
	$"B0B5 B8BD B8BD B8BC FED1 11BE BCB7 C8C2"
	$"D1D1 DBB5 B6C9 BDB8 AEDA CAE1 D701 5F04"
	$"677E 92A8 A7FE A871 76A6 7B7B 757B 757B"
	$"7676 3E3D 3E3E 7C7C 767C 757B 757B 927C"
	$"7B75 7BA5 7278 3E3E 3F3F 757C 757B 7C92"
	$"7B75 7C76 7B7B 927C 7878 7544 3E3E 4178"
	$"7C93 7B7B 767C 7278 7B74 757B 7379 7841"
	$"3E40 4173 7B7B 757B 7C92 7B75 7B75 7B76"
	$"7EA3 A87E 7B75 7878 A9A8 A7A7 767C 7BA5"
	$"7C76 A9D5 AB69 809A B0AF FEB0 0283 B188"
	$"6E88 8388 8388 8282 5958 5959 8888 8288"
	$"8388 8388 9C88 8883 88B1 8489 5959 5A5A"
	$"8389 8388 889C 8883 8882 8888 9C88 8989"
	$"8356 5959 588A 889D 8888 8287 848A 8882"
	$"8388 8389 8A58 595A 5885 8888 8388 889C"
	$"8883 8883 8883 87AB B087 8983 8A8A B1B0"
	$"B1B1 8287 88B1 8882 B0DC AF72 89BD D1D0"
	$"FED1 09AE DABD BDB8 BDB8 BDAE AEFD A3FF"
	$"BD0D B0B5 B8BD B8BD C8B5 BDB8 BDE3 C1C6"
	$"FDA3 4AB8 BEB8 BDB5 C8BD B8B5 B0BD BDC6"
	$"B3C6 C6B8 8FA3 A39B C8B5 C9BD BDB1 B6C2"
	$"C8BD B7B8 BDB8 BDC8 9BA3 A49B C3BD BDB8"
	$"BDB5 C8BD B8BD B8BD B9AA CCD1 AABC B7C8"
	$"C8D2 D1DB DBB1 B6BD E3B3 AECA F4BF 015D"
	$"1167 7995 AAA8 A87B 757B 7592 7C76 A775"
	$"7B78 72FE 3E10 3D75 A576 7C7C 917B 7478"
	$"7992 7C75 747C 75FD 3E28 767B 75A5 7379"
	$"767C 7278 767C 7B91 7178 4141 3E3E 3F72"
	$"7278 7C92 7B7B 757B 917B 7C77 7D77 7240"
	$"3E3E 44FE 75FF 7B00 74FE 7B1B 75A5 757B"
	$"757B 7CA8 757A 7575 A8A8 A7A7 A8A8 7576"
	$"7278 AAC3 CF68 799B FEB0 0488 8388 839C"
	$"0688 82B0 8388 8A84 FE59 1058 83B1 8288"
	$"879C 8882 8A8B 9C88 8382 8983 FD59 2883"
	$"8883 B183 8982 8884 8A82 8788 9C84 8A58"
	$"5859 5957 8484 8986 9C88 8883 889D 8888"
	$"8387 8184 5859 5956 FE83 FF88 0082 FE88"
	$"2A83 B183 8883 8888 B283 8883 83B0 B0B1"
	$"B1B0 B081 8284 89B0 C8D7 7283 B6CA DADA"
	$"BDB8 BDB8 C8B5 ACD8 B8BD C6C1 FDA3 07B8"
	$"E3AE B3B6 C9BD B7FE C804 B5B8 B7BE B8FD"
	$"A328 B9BD B8E3 B8BD B0B5 C2C8 B1B6 B5C8"
	$"C0C6 9B9B A3A3 9AC2 C1C6 B4C8 BDBD B8BD"
	$"D1BD B5B1 B3AE C49D A3A3 8FFE B8FF BD1C"
	$"B7BD B5B5 B8E3 B8BD B8BD B5DC BABE B8B8"
	$"D1D1 DBDB D1D1 AFB0 C1C6 CAE1 F601 5F25"
	$"677F 7AAA A87C 757B 757B 7C76 7C76 7B75"
	$"7940 3E3E 403E 7B7B 76A7 757C 757B 7872"
	$"7C76 7B7B 757B FD3E 5544 757B 7B73 797C"
	$"A178 7891 7C76 7B78 7872 413E 3E41 7877"
	$"7877 7D7B 907B 757B 7B92 7C77 A878 403E"
	$"3E44 757C 7B7B A075 7B75 917B 7B75 7B75"
	$"7B76 767B 757B 7BA8 A87C A7A8 A8A7 7C78"
	$"78AA D6AD 687F 81B0 B086 8388 8388 881A"
	$"8287 8288 838B 5859 595A 5988 8882 B181"
	$"8783 888A 8488 8288 8883 88FD 5960 5683"
	$"8888 8389 88AC 8A8A 9C87 8388 8A8A 8458"
	$"5959 588A 8889 8287 889D 8883 8888 9C88"
	$"81B0 8958 5959 5683 8988 88AC 8388 829C"
	$"8888 8388 8388 8282 8983 8888 B0B0 88B1"
	$"B0B0 B188 8989 B0DC B572 899D CADA B3B8"
	$"BDB8 BDB5 B0B2 ACBD B8C7 99A3 A3A4 A3FF"
	$"BD0D AEDA B0B6 B8BD C8C2 B5B0 BDBD B8BD"
	$"FDA3 4A8F B8BD BDB8 BDB5 D6C8 C8C9 B6B1"
	$"B5C6 C6C2 9BA3 A39B C8C5 C6B0 B5BD D0BD"
	$"B8BD BDC8 B5AE DAC9 9DA3 A38F B8BE BDBD"
	$"DEB8 BDB0 C8BD BDB8 BDB8 BDB0 B0BF BABD"
	$"BDD1 D1B5 DBD1 D1DB B5C6 C6CA F4D6 0161"
	$"1167 78A3 A875 7C76 7C7D 767B 7B75 7B75"
	$"A576 76FD 3EFF 7567 7B75 7C7C 7B90 7D76"
	$"7878 927D 7B90 3E40 3E3E 757B 7676 7C76"
	$"7B75 7973 7C76 7872 7676 7241 3E3E 4172"
	$"917D 767C 757B 7C76 7B74 7B7B 757B 7241"
	$"3E3E 4141 7C92 7872 7879 927C 7C76 7B90"
	$"7B75 763F 3C3C 7B75 A8A8 A6A6 A77C A7A9"
	$"7675 ABD2 C268 7AAB B083 8982 8889 8288"
	$"0E88 8388 83B1 8282 5A5A 5959 8383 8883"
	$"FE88 4C9D 8982 8989 9C88 889D 595A 5959"
	$"8388 8282 8882 8983 8984 8882 8A84 8282"
	$"8458 5959 5884 9C88 8288 8388 8882 8882"
	$"8888 8388 8458 5959 5858 889C 8A84 898A"
	$"9C88 8882 899D 8883 8958 5A5A 8883 B0B0"
	$"FEB1 1D88 AFB1 8281 AFD6 C970 81CC D1B8"
	$"BEB0 B5B6 B0BD BDB8 BDB8 E3AE AEA5 A5A3"
	$"A3FF B85C BDB8 B5B5 BDD0 B6B0 C6C6 BFAC"
	$"BDD0 A3A4 A3A3 B8BD B8B8 B3AE BFBA BFBA"
	$"B5B0 C8C2 AEAE C29B A3A3 9BC2 C9B7 B0B5"
	$"B8BD B5B0 BDB7 BDBD B8BD C29B A3A3 9B9B"
	$"B5C8 C8C2 C6C7 C6B3 B5B0 BFD1 BDB8 C79B"
	$"A5A5 BDB8 D1D1 DBDB DAB3 D0D2 AEAD C1E7"
	$"E901 5F25 677E 787E 767B A17C 927C 75A5"
	$"7B75 7B7B 7D76 3E3E 403E 7B7B 757B 7692"
	$"7B7B 76A7 7278 7D92 7B7B FD3E 3376 7B7C"
	$"7C92 7C75 7A73 797C 9278 78A7 7C41 413E"
	$"3E41 787C 76A6 767B 75A7 767A 757B 907B"
	$"7578 413E 3E41 727B 7678 7873 777C 767C"
	$"92FE 7B1E 7577 713C 3C44 75A8 A8A6 7BA7"
	$"A6A8 A8A7 7CAC D3AD 6880 8187 8388 AC88"
	$"9C88 8306 B188 8388 8889 82FE 5A10 5988"
	$"8883 8882 9C88 8882 B184 8988 9C88 88FD"
	$"5900 83FE 883E 9C88 8388 8489 889C 8A8A"
	$"B188 5858 5959 588A 8782 B082 8883 B182"
	$"8783 889D 8883 8A58 5959 5884 8782 8A8A"
	$"8588 8882 889C 8989 8883 8A84 5A5A 5683"
	$"B0B0 B188 B1FE B01A B188 B0D7 B570 87A5"
	$"AAB9 BDD6 B5C8 B5B8 E3BD B8BD BDB4 AEA5"
	$"A5A4 A3FF BD0D B8BD B0C8 BDBD B0DB C1C6"
	$"ACBF BDBD FDA3 00B9 FEBD 06C6 B3BA BEBA"
	$"BFB5 FEC8 3CDA B39B 9BA3 A39B C8B6 B1DB"
	$"B0BD B8DB B0BC B8BD D0BD B8C8 9BA3 A39B"
	$"C2B4 B0C8 C8C2 C5B3 AEB5 C8BF BFBD B8C8"
	$"C2A5 A58F B8D1 D1DB B5DA D9D1 D1DA B3C2"
	$"E8D6 0155 0148 54FE 780C 727B 757B 757B"
	$"7573 A476 7678 41FD 3E0F 7C76 7C76 7878"
	$"7676 7B75 7B75 757B 7575 FD3E 0072 FC78"
	$"4FA7 767C A172 787C 7672 7872 413E 3E41"
	$"7875 7B71 7876 7C75 7B76 A875 7B7C 7C72"
	$"413E 3E45 7775 7B76 767C 917C 7778 7875"
	$"75A7 7678 723E 3E3D 3E7A A5AA AAA8 A8A7"
	$"A7A8 A8AA AAD6 4A57 8181 8984 8883 8883"
	$"88FF 8304 B282 8289 58FD 590F 8882 8882"
	$"8A8A 8282 8883 8883 8389 8383 FD59 3F84"
	$"8A81 818A 8AB1 8288 AC84 8A88 8284 8984"
	$"5859 5958 8A83 8883 8982 8883 8882 B283"
	$"8988 8884 5859 5955 8383 8882 8287 9C88"
	$"838A 8A83 83B1 8289 8459 5958 5987 B1FD"
	$"B0FF B1FD B012 D655 61A5 A5C6 C1BD B8BD"
	$"B8BD B8B8 E3B0 B0C6 99FD A30F B3AE B3AE"
	$"C8C8 AEAE BDB8 BDB8 B7BC B8B8 FDA3 39C2"
	$"C8A5 A5C8 C8DA AEB5 D6C1 C6B5 B0C1 C6C2"
	$"9BA3 A39B C8B8 BDC3 C9B0 B5B8 BDAE DBB7"
	$"BCB5 B5C2 9BA3 A38F B9B8 BDB0 B0B6 C9B5"
	$"B1C6 C6B8 B8DA AEC6 C1FD A30C BCE3 CACA"
	$"D1D1 DBDB D1D1 CACA D601 5A11 2C41 7978"
	$"7978 757B 757B 7B75 7979 767C 7872 FD3E"
	$"4D92 7C76 A778 717C A775 7B75 7B7B 757B"
	$"7B3E 3D3E 3E41 78A3 7E78 7276 7C76 7C78"
	$"7976 7678 7841 413E 3E41 727B 7579 7891"
	$"7C75 7B76 7C75 7B76 9278 413E 3E45 767B"
	$"757C A676 7C7C 9278 727B 7B7C 7578 41FD"
	$"3E17 747B A5AA A8A8 7CA7 A8A7 D1D6 D62E"
	$"4382 818A 8983 8883 8888 0683 8989 8288"
	$"8984 FD59 479C 8882 B18A 8388 B183 8883"
	$"8889 8388 8859 5859 5958 8AAB 878A 8482"
	$"8882 888A 8B82 8289 8958 5859 5958 8488"
	$"838A 899C 8883 8882 8883 8982 9C8A 5859"
	$"5955 8288 8388 B082 8788 9C8A 84FE 8802"
	$"8189 58FD 5902 8288 ABFE B018 88B1 B0AF"
	$"D7DB D63A 4EA6 A5C7 C6B8 BDB8 BDBD B8BD"
	$"BDB0 B5C6 C1FD A30F C6B3 AEDA C8C2 B3DA"
	$"B8BD B8BD BCB7 BDBD FDA3 399B C8CC AAC8"
	$"C2AE B3B0 B5C6 C7B0 B0C6 C69B 9BA3 A39B"
	$"C2BD B8CA C9C7 B5B8 BDAE B3B7 BCB0 C8C8"
	$"9BA3 A38F B8BD B8B5 DBB1 B6B5 C8C6 C1BD"
	$"BDB3 ADC6 99FD A30C B7BD C4CA D1D1 B5DB"
	$"D1D0 EFF3 D601 5B11 013E 4677 7C92 7B7B"
	$"7C90 7B75 7C75 7C76 7475 FD3E FF7B 1F73"
	$"7876 7C76 7C7C A7A8 A8A3 A8A7 7C75 7545"
	$"777B A57C 76A8 787C 7B76 7D76 9279 A4FE"
	$"7500 44FE 3E24 7792 7C76 7C79 727C 9278"
	$"7876 7C78 7872 413C 3C41 4178 7875 7C76"
	$"7C75 7B7B 907B 7476 7C76 76FD 3E17 7B75"
	$"7CA7 A8A3 A8A8 A7A7 A9D6 AB09 4355 8388"
	$"9C88 8889 9D88 0683 8881 8882 8283 FD59"
	$"FF88 1F83 8882 8883 8888 B1B0 B0AB B0B0"
	$"8783 8355 8388 B188 82B0 8189 8882 8982"
	$"9C89 B2FE 8300 56FE 5924 8A9C 8882 888A"
	$"8488 9C89 8982 8889 8984 585A 5A58 5889"
	$"8983 8982 8883 8888 9D88 8282 8882 82FD"
	$"591E 8883 88B1 B0AB B0B0 B1B1 AFDC AF1E"
	$"5587 B1B3 C6B5 B5BE D0BD B8B5 AFB5 B0B7"
	$"B8FD A3FF BD1F B8BC B0B5 AEB3 B5DB D1D1"
	$"CCD1 D8B2 B8B8 8FB9 BDE3 B3AE D1A5 BEBD"
	$"B0B6 B0C8 BDE3 FEB8 008F FEA3 24CF C8B5"
	$"B0B5 C7C1 B5C8 C6C6 B0B5 C6C6 C29B A3A3"
	$"9B9B C6C6 B8BE B0B5 B8BD BDD0 BDB7 B0B5"
	$"B0B0 FDA3 0CBD B8B5 DBD1 CCD1 D1DA DAC9"
	$"F4BF 0158 1100 5270 7C76 7C75 917B 7B75"
	$"7C92 7C76 A77B 44FD 3E05 75A5 79A5 A7A7"
	$"FEA6 44A7 A8A8 7EA8 A7A7 7C7A 7C76 7AA5"
	$"A7A7 A8A9 A5A5 A7A7 7C7C 7279 7B7B 7543"
	$"3E40 3E77 7C76 A776 7878 767C 7278 A776"
	$"7278 7841 3C3C 4172 7872 7B75 7C92 7B75"
	$"7B7B 757B 7B92 7C76 FD3E 0475 7B76 767E"
	$"FEA8 0F7C A7D1 D6E1 0757 7C88 8288 829C"
	$"8888 8306 899C 8882 B188 56FD 5903 83B1"
	$"89B3 FDB1 04B0 B1B0 B087 FEB0 0489 8788"
	$"8287 FEB1 00B0 FCB1 FF88 2D82 8988 8883"
	$"5559 5A59 8A88 82B1 8289 8982 8884 89B1"
	$"8284 898A 585A 5A58 8489 8488 8388 9C88"
	$"8388 8883 8887 9C88 82FD 5904 8388 8282"
	$"87FE B016 88B1 D7DC E41B 67AA B5AE B3B0"
	$"C8BD BDB8 BEC8 B5B0 DBBD 8FFD A320 B8E3"
	$"BDE4 DBDB DADA DBDB D1D1 AAD1 D8D8 BEBC"
	$"BDB8 BCE3 DADA D1D2 E3E3 DBDB B5B5 B7FE"
	$"BD29 B88F A3A4 A3CF B5B0 DBB0 C6C6 B0B5"
	$"C1C6 DBB0 C1C6 C89B A3A3 9BC2 C6C1 BDB8"
	$"B5C8 BDB8 BDBD B8BD B4C8 B5B0 FDA3 04B8"
	$"BDB0 B0AA FED1 04B3 DAEF F4F3 0149 1101"
	$"3E78 787B 7B78 7875 75A8 7678 787B 757B"
	$"75FE 4100 72F9 A8FF AA01 7CA6 FDA8 FF75"
	$"0272 7893 FDA8 00A9 FEA8 0FA7 A8A9 A8A8"
	$"A380 4141 3E3E 4172 757B 72FE 781E A77C"
	$"7E78 7177 A876 7341 3E3E 4475 7B75 A776"
	$"7B7B 757B 767C 76A8 757B 7A43 3DFE 3E05"
	$"7B75 7878 7278 FDA8 0DAB D2D7 0A43 8181"
	$"8888 8989 8383 B206 8289 8988 8388 83FE"
	$"5800 84F7 B000 87FC B0FF 8302 8489 9BFD"
	$"B035 B1B0 B0B2 B1B0 B1B0 B0AA 8758 5859"
	$"5958 8483 8884 8981 81B1 8887 8184 8AB1"
	$"8285 5859 5956 8388 83B1 8288 8883 8882"
	$"8882 B283 8889 5758 FE59 0588 838A 8A84"
	$"89FD B018 AFD6 DB22 58A5 A5BD BDC9 C9B8"
	$"B8DC B0C6 C6BD B8BD B89B 9B99 C1FD D1FF"
	$"D3FF D1FF CA01 B2D7 FDD1 FFB8 02C1 C6BE"
	$"FDD1 34D2 D1D1 DCDB D1D2 D1D1 CBAA 9B9B"
	$"A3A3 9BC2 B8BD C4C9 A5A5 E4BD AAA5 C2C8"
	$"D9AC C39B A3A3 8FB8 BDB8 DBB0 BDBD B8BD"
	$"AEB3 B0DC B8BD C89B FDA3 05BD B8C8 C8C1"
	$"C6FD D102 C1E7 EA01 4912 013E 7878 7B90"
	$"7872 7B7B 767C 7872 757B A57B 72FE 7803"
	$"A8A9 A37E FDA8 03A5 AAA7 A6FD A8FF 7BFF"
	$"7800 7EFA A801 7CA7 FDA8 36AA AB78 733E"
	$"3E41 787B 7578 7893 7E7C 76A3 7877 7776"
	$"7C78 413E 3E44 7575 7B76 7C7B 907B 75A7"
	$"767C 777B 757A 753E 3E40 3E75 7B78 7278"
	$"7978 FEA8 0DD2 D7D2 0A43 8181 889D 8984"
	$"8888 820E 8889 8483 88B1 8884 8A89 89B0"
	$"B1AB 87FD B000 ABFA B0FF 88FF 8900 87FA"
	$"B001 88B1 FCB0 35B1 8A85 5959 588A 8883"
	$"8989 9B87 8882 AB81 8A8A 8287 8A58 5959"
	$"5683 8388 8288 889D 8883 B182 8883 8883"
	$"8984 5959 5A59 8388 8A84 898A 81FE B018"
	$"D6DB D622 58A5 A5BD D0C9 C4BD BDB0 B5C6"
	$"C1B8 BDE3 BDC2 C8C6 C60B D1D2 CCAA D3D3"
	$"D1D1 C4CA D8D7 FDD1 FFBD FFC6 00AA FAD1"
	$"01B5 DBFC D135 D2C8 C3A3 A39B C8BD B8C9"
	$"C9BE AABD B8CC A5C8 C8AC B2C8 9BA3 A38F"
	$"B8B8 BDB0 B5BD D0BD B8DA AEB5 B1BD B8C8"
	$"C3A3 A3A4 A3B8 BDC8 C2C6 C7A4 FED1 02E7"
	$"ECE5 0158 0C0F 4572 7E75 7B75 A775 7B7C"
	$"76A3 FDA8 FF78 0C72 767C A8A9 AAAA A8A8"
	$"7CA7 A77C FEA8 027C A8A8 FD75 FFA8 0A7C"
	$"A67B A6A8 A3A8 A8A7 A87C FDA7 447C 7872"
	$"767C 9580 7575 7B7B 757B 7878 7676 7B75"
	$"7241 3E3E 4141 7878 767C 757B 7B75 7872"
	$"7B76 7C76 7873 3F3F 403E 7B90 7C92 7C92"
	$"7B7B A7A7 AAD6 D318 4A7B 8783 8881 B183"
	$"8888 0182 ABFD B006 818A 8482 88B0 B1FD"
	$"B009 88B1 B188 B0B0 B187 B0B0 FD83 FFB0"
	$"0A88 B188 B1B0 ABB0 B0B1 B288 FDB1 0B88"
	$"8984 8288 9B87 8383 8888 83FE 89FF 8217"
	$"8883 8458 5959 5858 8989 8288 8388 8983"
	$"8984 8782 8882 8A85 FE5A 1A59 889D 889C"
	$"889C 8888 B1B1 B0DC D72D 5CA0 AAB8 BDAF"
	$"DBB8 BDB5 B0CC FDD1 04A5 C8C2 AEB3 01D1"
	$"D2FD D109 B3DA DBB5 D1D1 DDB6 D1D1 FDB8"
	$"FFD1 48B3 DAB5 DBD1 CCD1 D1DA DBB5 DBDA"
	$"DADB B5C6 C1B0 B5BE AAB8 B8BD BDBA BFC6"
	$"C6B0 B0BD B8C2 9BA3 A39B 9BC6 C6B0 B5B8"
	$"BDBF BAC6 C1B3 AEB5 B0C8 C3A3 A3A4 A3BD"
	$"D0B5 C8B5 C8BD BDDA DACA F4E6 014C 0C00"
	$"3E78 787B 757C 767B 75A7 A77E FCA8 FF78"
	$"0777 76A8 A8AA AAA8 A8FE A70C A6A8 A8A7"
	$"A7A8 A87B 7B7C 7B78 A8FD A604 7EA7 A8A8"
	$"7CFE A747 7BA7 7677 7878 77A7 AAAB 7B7B"
	$"7575 7B75 7278 7C76 7BA5 7841 3E3E 3F72"
	$"7872 7C92 7B75 7B75 7878 927C 7CA1 7841"
	$"3F3F 3E3E 7B7B 767C 777C 7675 7CA7 D1D6"
	$"D706 4381 8188 8388 8288 83B1 01B1 87FC"
	$"B0FF 8A01 8382 FBB0 FEB1 FAB0 FF88 0389"
	$"8881 B0FD B104 87AF B0B0 88FE B149 87B1"
	$"8283 8989 83B1 B0B1 8888 8383 8983 8489"
	$"8882 88B1 8A58 5959 5784 8984 889C 8883"
	$"8983 8989 9C88 88AC 8A58 5A5A 5959 8888"
	$"8288 8388 8383 88B1 D7DC DB1A 55A5 A5BD"
	$"B8B5 B0BD B8DB DBAA FCD1 FFC8 01AF AEFB"
	$"D1FF DAFF DBFF D1FF DCFF D1FF BD33 BEBD"
	$"A5D1 DADA DBDB AAD0 D1D1 B3DA DBDB B3DA"
	$"B0B1 C6C6 B1DB D1D2 BDBD B8B8 BFBA C1C6"
	$"B5B0 BDE3 C89B A3A3 9AC2 C6C1 B5C8 BDB8"
	$"BFBA FEC6 04B3 B5D6 C89B FDA3 FFBD 0AB0"
	$"B5B1 B5B9 B8B3 DAEF F4EA 0157 0D00 4572"
	$"7E73 7977 7DA8 A8A7 A7A8 A8FE A71D 7C76"
	$"7678 78A8 7CA8 A87C A7A9 A87C A77C 767C"
	$"907B 7541 7275 757E A37B A5A1 FEA7 FFA6"
	$"FFAA FDA8 04A4 7975 757C FEA7 FFA8 1FA7"
	$"7DA1 7B75 7BA0 7C74 7572 413C 3C41 727C"
	$"927A 7A7C 767C A17C 767B 747B 767B 75FD"
	$"3F09 767C 7278 7C76 7B7B 757B FED2 0A0D"
	$"4C7B 8783 8982 87B0 B0B1 02B1 B0B0 FEB1"
	$"1D88 8282 8989 B187 B0B0 88B1 B1B0 88B1"
	$"8882 899D 8883 5884 8383 87AB 88B0 ACFC"
	$"B1FB B004 B289 8383 88FE B1FF B02D AF87"
	$"AD88 8388 AB88 8283 8458 5A5A 5884 889C"
	$"8989 8882 88AC 8882 8882 8883 8883 5A5A"
	$"5959 8288 848A 8882 8888 8388 FED6 152B"
	$"68A1 ACB8 BDB0 B5D1 D1DB DBD1 D1DB DBDA"
	$"B3B0 B0C6 C61F DDB6 D1D1 B5DB D2D1 B5DB"
	$"B5B0 BED0 BDB8 9BC2 B8B8 AACC BDE2 D6DB"
	$"DADA DCDC CACA FDD1 04E3 BDB8 B8B3 FEDA"
	$"FFD1 10DB B5DF BDB8 BDD6 B5B7 B8C2 9BA3"
	$"A39B C2B5 FEC8 0BB3 AEB5 D6B3 AEBD B7BD"
	$"B9BD B8FD A30C AEB3 C2C8 B5B0 BDBD B8BD"
	$"E7E7 E501 5D35 003C 727E 7379 A8A7 A8A8"
	$"A77C A8A8 A77C A7A7 767C 7872 A7A7 A878"
	$"A776 7778 7676 7C92 7B7B 757B 4141 4444"
	$"7878 7B75 7C7C 767C 757B AAA5 FDA8 0B79"
	$"737B 7B76 A77C A7A8 A87D A2FE 7B1A 747C"
	$"767B 7B77 413C 3B41 4177 7C7A 7477 A776"
	$"7C76 A77B 757B 747B 75FD 3F17 7C92 7878"
	$"927C 75A6 747B ABD7 D70E 447B 8783 89B0"
	$"AFB0 B0B1 0A88 B0B0 B188 B1B1 8288 8984"
	$"FEB0 1C81 B182 8081 8282 889C 8888 8388"
	$"5858 5656 8181 8883 8888 8288 8288 B0AB"
	$"FDB0 0B89 8388 8882 B188 B1B0 B087 ABFE"
	$"8841 8288 8288 8889 585A 5958 5883 8889"
	$"8483 B182 8882 B188 8388 8288 835A 5A59"
	$"5988 9C8A 8A9C 8883 B282 88AF DBDB 2E61"
	$"A1AC B8BD DBDB D1D1 DBB5 D1D1 DBB5 DADA"
	$"B0B5 C6C1 FFDC 1DD1 A5DB B0A4 A5B0 B0B5"
	$"C8BD BDB8 BD9B 9B8F 8FA4 A4BD B8B5 B5AE"
	$"B3B1 B6CA C4FD D10B BDB8 BDBD AEDA B3DA"
	$"D1D1 B5D6 FEBD 1AB7 B5B0 BDBD C79B A3A3"
	$"9B9B B1B5 C8C2 AFDA B0B5 AEDA BDB8 BDB7"
	$"BDB8 FDA3 01B3 C6FE C807 B5B8 E4B7 BDC1"
	$"ECEA 0151 030F 4578 78FD A805 7EA8 A7A8"
	$"A77C FEA8 0176 7BFE 7503 7B75 7B75 FB7B"
	$"2375 7A76 7C7B 903E 3D3E 3E41 7875 7B75"
	$"757C 767B 9078 7876 7CA7 A775 7B75 7C7C"
	$"A7A8 A8A7 A7FD A830 937E 767C 7676 7840"
	$"3E3E 4475 7872 7C92 7878 757B 7B76 7279"
	$"927C 7544 3E40 3E3E 7278 797E 7872 7C76"
	$"7B75 AAD1 D618 4A81 81FD B002 87B0 AF07"
	$"B0B1 88B0 B0B2 8288 FE83 0388 8389 83FB"
	$"8823 8387 8288 889D 5958 5959 588A 8388"
	$"8383 8882 889D 8A8A 8288 B1B1 8388 8389"
	$"88B1 B0B0 B1B1 FDB0 309B 8782 8882 8289"
	$"5859 5956 8389 8488 9C8A 8A83 8888 8384"
	$"8A9C 8883 5659 5A59 5984 8982 8789 8488"
	$"8288 83B0 D6D5 2D5C A4A4 FDD1 0AAA D1D0"
	$"D1DA B3D1 D1DB AEBD FEB8 03BD B8BC B7FB"
	$"BD05 B8BC B0B5 BDD0 FDA3 199B C8B8 BDB7"
	$"B7B3 AEBD D0C8 C8B0 B5DA DAB8 BDB8 BEB5"
	$"DBD1 D1DB DBFD D10E BEAA B0B5 AEAE C99D"
	$"A3A3 91BA C6C1 B5FE C81A B8BD BDB9 C1C7"
	$"C8B5 B88F A3A4 A3A3 C1C6 A6AA C6C1 BDB8"
	$"BDB8 C8ED D401 4403 003E 78A9 FCA8 09A3"
	$"A8A8 A7A7 A8A7 A77C 75FE 4402 7B75 7BFB"
	$"7506 A575 7B7C 927B 7BFD 3E0B 7278 7B75"
	$"7C7B 76A7 7A7C 7378 FE76 0A7C 7B75 7B75"
	$"76A7 A8A9 7BA7 FBA8 1A7C 927C A771 403E"
	$"3E44 7578 7876 7C72 787B 7575 7B78 787C"
	$"767B 753D FE3E FE78 0DA3 7878 767C 747B"
	$"AAD6 D607 4381 B1FC B001 ABB0 07B0 B1B1"
	$"B0B0 B188 83FE 5602 8883 89FB 8306 B183"
	$"8888 9C88 88FD 590B 848A 8883 8A89 82B1"
	$"8789 858A FE82 FF88 0883 8883 82B1 B0B1"
	$"87B1 FBB0 1A88 9C88 B183 5859 5956 8389"
	$"8982 8884 8A88 8383 8889 8988 8288 8358"
	$"FE59 FF89 0D81 AB89 8982 8882 88B0 DBD5"
	$"1B55 A4FB D109 CCD1 D1DA DAD1 D0DA B3B8"
	$"FE8F 03BD B8BC B7FC B806 E3B8 BDB5 C8BD"
	$"BDFD A319 C2C8 BDB8 BDBC AEDA BCBE C3C8"
	$"B0B0 AEB3 BDB8 BDB8 B0DB D1D2 B4DB FBD1"
	$"19B5 C8B3 DAC3 9DA3 A391 BAC6 C6B0 B5C2"
	$"C8BD B8B8 BDC6 C6B5 B0BD B8FD A3FF C60A"
	$"A5CC C6C6 B8BD B7BD C8F2 D401 540A 3E76"
	$"7AAA A8A8 7CA7 A8A8 7DFE A70A 927C 7575"
	$"3C3C 3E3E 757B 75FB 7B06 757C 917B 757B"
	$"75FD 3EFF 7637 7D92 7C76 7973 7575 7B75"
	$"7B7B 7973 7342 4172 7BA5 A7A7 AAAA A8A8"
	$"7CA8 A6A6 A8A8 7B75 7841 3C3C 4141 7C92"
	$"7B7B 747B 8F79 7C7C 9276 767C 7872 FD3E"
	$"FF76 0D77 717C 927B 75A5 7BAA D2A8 437A"
	$"81FE B004 88B1 B0B0 89FE B10D 9C88 8383"
	$"5A5A 5959 8388 8288 8989 FE88 0683 889C"
	$"8883 8883 FD59 FF82 0487 9B88 8289 FE83"
	$"0A88 8388 8889 8383 5658 8488 FEB1 FDB0"
	$"1D88 B2B1 B1B0 B088 838A 585A 5A58 5888"
	$"9C88 8882 889D 8988 889C 8282 888A 84FD"
	$"59FF 821C 8A84 889C 8883 B188 B0D7 B058"
	$"8C9D CAD1 D1B3 DAD1 D1B6 DBDA DAC8 B5B8"
	$"B8FD A305 B8BD B0B5 BFBF FEBD 06B8 BDD0"
	$"BDB8 BDB8 FDA3 FFB0 04B6 C9B5 B0BD FEB8"
	$"01BD B8FE BDFF B828 8F9B C2BD E3DA DACA"
	$"CAD1 D1B5 DCDA DAD1 D1BD B8C8 9BA3 A39B"
	$"9BB5 C8BD BDB7 BDD0 BDB3 B3C6 AEB0 B5C8"
	$"C2FD A3FF AE0A C8C2 B5C8 BDB8 E3BD CAF0"
	$"D101 5C25 457C 95AA A8A8 A7A7 A8A8 A7A8"
	$"7C76 7C76 7B44 3C3C 3E3E 7B75 7B91 7B91"
	$"7B90 7B75 7D7C 757B 757B FD3E 0776 7D77"
	$"7C7C A179 73FE 7B0E 75A5 7573 7873 4341"
	$"4144 757C A7A5 AAFE A816 A7A6 7CA8 A8A5"
	$"7B72 413C 3C41 7176 7C7B 907B 7579 7992"
	$"76FE 7C16 9278 413E 3D3E 3E7B A776 7776"
	$"7C7B 757A 75AB AAD4 4A80 9BFE B0FF B1FF"
	$"B000 B11A B288 8288 8288 565A 5A59 5988"
	$"8388 9C89 9E88 9D88 8388 8883 8883 88FD"
	$"5907 8289 8186 88AC 8983 FE88 0D83 B183"
	$"8388 8357 5858 5683 88B1 ABFE B017 B2B1"
	$"B188 B0B0 B188 8458 5A5A 5883 8288 889D"
	$"8883 8989 9C82 FE88 259C 8A58 5958 5959"
	$"87B1 898A 8288 8883 8783 B1B0 DB5F 91B6"
	$"CAD1 D1DA DAD1 D1DB DCB3 AEB5 B0BD 8FFD"
	$"A30F BDB8 B5C8 BFD2 BDD0 BDB8 BEBD B8BD"
	$"B8BD FDA3 07B0 B6B1 B5B5 D6BD B8FE BD2E"
	$"B8E3 B8B8 BCB8 909B 9B8F B8B3 DAC4 CAD1"
	$"D1DC DBDA B3D1 D1E3 BDC2 9BA3 A39B C2B0"
	$"B5BD D0BD B8BD BDC6 AEB3 B3B5 C8C8 9BFD"
	$"A30C B3DA C7C8 B0B5 BDB8 BCB8 CACA FB01"
	$"5611 6778 A5AB 7CA8 AAAA 7BA6 7475 757B"
	$"7878 7676 FD3E 0F75 7BA6 7B75 7B75 7B75"
	$"7B76 7C75 7BA1 7CFD 3E10 447C 7C76 7872"
	$"7878 927C 907B 757B 7D77 77FD 3E05 7778"
	$"7E7B A57C FEA7 FFA8 00A7 FEA8 16A7 463E"
	$"3E41 727B 7578 7976 7C75 7579 7776 7C92"
	$"7C7B 753B FE3C FF75 1577 7C72 7893 7D75"
	$"7BC4 D7AB 697A ABB1 88B2 B0B0 88B2 82FF"
	$"8304 888A 8A82 82FD 590F 8388 B288 8388"
	$"8388 8388 8288 8388 AC88 FD59 1056 8988"
	$"828A 8489 899C 889D 8883 8887 828A FD59"
	$"058A 8187 88B1 88FE B1FF B01A B1B2 B0B0"
	$"B155 5959 5884 8883 8A8B 8288 8383 8A88"
	$"8288 9C88 8883 59FE 5AFE 831B 8884 899D"
	$"8983 88C7 DBAF 7283 C4CA B3DB CACA BDE4"
	$"B7B8 B8BD C8C8 AEAE FDA3 0FB8 BDE4 BDB8"
	$"BDB8 BDB8 BDAE B3B8 BDD6 B5FD A310 8FBE"
	$"B5B0 C8C2 C6C6 C8B5 D0BD B8BD B5B0 CFFD"
	$"A324 CFA5 AABD E3B3 DADB DBD1 D1DB DCD1"
	$"D1DB 87A3 A39B C2BD B8C8 C8AE B3B8 B8C7"
	$"C5B0 B5C6 B3BD B8FD A3FF B80A B1B5 C1C6"
	$"C9B6 B8BD D7EA BF01 5409 677E 7AAA A8A7"
	$"AA95 7B75 FE7B 0475 7278 7C76 FD3E 0F7B"
	$"7575 7B7B 757B 75A5 7B75 A77B 757C 76FD"
	$"3EFF 750D 7C92 7878 7278 7C76 7B7B 757B"
	$"927D FC3E 0477 7893 7B75 FEA7 387C A8A8"
	$"A77B A8A8 A776 3E3E 3F41 7B76 7278 A876"
	$"7B7B 7277 A17C 7C76 7B76 3C3C 3B3C 7B7A"
	$"7C92 7878 7C76 7B75 ABD2 D269 8081 B0B2"
	$"B1B0 9B88 8388 FF88 0483 848A 8882 FD59"
	$"0F88 8383 8888 8388 83B1 8881 B188 8388"
	$"82FD 59FF 830D 889C 8A8A 8489 8882 8888"
	$"8388 9C87 FC59 048A 819B 8883 FEB1 3788"
	$"B0B0 B187 B0B0 B182 5959 5758 8883 848A"
	$"B282 8888 8488 AC88 8882 8883 5A5A 595A"
	$"8887 889C 8989 8882 8883 AFD6 D672 899D"
	$"CADB DACA B6BD B8FE BD04 B8C2 C8B3 AEFD"
	$"A30F BDB8 B8BD BDB8 BDB8 E3BD ADDA BDB8"
	$"B5B0 FDA3 FFB8 00B5 FEC8 09C1 C6B5 B0BD"
	$"BDB8 BDC8 B5FC A324 CFA5 BEBD B8DA DADB"
	$"B5D1 D1DB B4D1 D1DB B0A3 A39A 9BBD B9C2"
	$"C8DB AEBD BDC1 C5D6 B5B3 AEBD B9FD A30C"
	$"BDBC B5C8 C6C6 B5B0 BDB8 BFE5 E501 5911"
	$"6778 95AA A8A3 7878 757B 767C 907B 7C92"
	$"7841 FD3E 1072 787C 757D A178 7875 7579"
	$"7371 7775 7B3D FE3E 1975 7B75 7B7C 927C"
	$"7676 7C75 757C 7678 7875 443E 3E44 7678"
	$"7975 7BFE 7500 A7FD A833 A77C A77C 7B75"
	$"3E78 76A7 7B75 757B 7CA1 7B75 7B75 7C76"
	$"7841 3E3E 3C3C 7575 7B7B 7575 7CA1 7878"
	$"A7D4 AB69 7A9B B0B0 AB8A 8A83 8882 0688"
	$"9D88 889C 8958 FD59 1084 8A88 8189 AC89"
	$"8983 8389 8384 8A83 8858 FE59 1D83 8883"
	$"8888 9C88 8282 8883 8388 8289 8983 5659"
	$"5956 8389 8A83 8883 8381 B1FD B03A B188"
	$"B188 8883 598B 82B1 8883 8388 88AB 8883"
	$"8883 8882 8958 5959 5A5A 8383 8888 8383"
	$"88AC 8A8A AFDB AF72 83B6 CAD1 CCC8 C8B8"
	$"BDB8 BDD0 BDB5 C8C6 99FD A30F C2C8 B5AF"
	$"B6D6 C6C6 B8B8 BDB8 C2C8 B8BD FDA3 1DB8"
	$"BDB8 BDB5 C8B3 AEB0 B5B8 B8B5 B0C6 C6B8"
	$"8FA3 A38F B9C6 C7B8 BDB7 B7AF DBFD D117"
	$"DAB3 DBB5 BDB8 A3D0 AEDA BDB8 B8BD B3D5"
	$"BDB8 BDB8 B5B0 C699 FDA3 FFB8 FFBD FFB8"
	$"06B5 D6C6 C6D0 FBBF 015D 1148 78AA AA78"
	$"7E78 727B 757C 767B 7B77 7C78 72FE 3E10"
	$"4078 7876 767C 7678 727B 7B73 7977 7775"
	$"7BFD 3E3D 757C 757B 767C 76A7 7C92 7B7B"
	$"937C 7772 7544 3E3E 4475 7872 7B76 7B7B"
	$"7C76 A878 A8A8 A7A7 A876 7B75 773E 767C"
	$"757B 7B76 767C 757B 757B 927C 7241 3E3E"
	$"3C3C FE7B 1490 7B7B 767C 7872 A8A8 D24A"
	$"7AB0 B081 878A 8488 8388 0682 8888 8388"
	$"8984 FE59 105A 8A8A 8282 8882 8984 8888"
	$"8389 8A8A 8388 FD59 3D83 8983 8882 8882"
	$"B188 9C88 889D 8888 8483 5659 5956 8389"
	$"8488 8389 8988 82B0 81B0 B0B1 B1B2 8288"
	$"838A 5982 8883 8888 8382 8883 8883 889C"
	$"8884 5859 595A 5AFE 881B 9D88 8882 888A"
	$"84B0 B0D6 5583 CACA A5AA C8C2 BDB8 BDB8"
	$"BDBD B1B5 C6C1 FEA3 00A4 FFC8 FFB0 0BB5"
	$"B0C6 C1BD BDB8 BDC8 C8B8 BDFD A339 B8BE"
	$"B8BD B0B5 AEDA B5C8 BDBD C9B5 C5C1 B88F"
	$"A3A3 8FB8 C6C1 BDB9 BCBC B5B0 D1A5 D1D1"
	$"DADA DCB0 BDB8 CFA3 AEB3 B8BD BDB9 AEB3"
	$"B8BD B8BD C8B5 C199 FDA3 FEBD 09D0 BDBD"
	$"B0B5 C6C1 D1D1 E501 5325 677E 7776 7B75"
	$"757B A17C 76A8 7576 7C75 7676 3F3F 3E3E"
	$"7692 7B7B 7379 767C 937C 7B90 7C92 7872"
	$"FD3E 0F42 7B7B 907A 747B 7578 787C 7678"
	$"7992 7DFC 3E09 3D7C A178 7892 7C75 7B76"
	$"FCA7 3175 7B75 7B75 7BA7 767B 757C A77B"
	$"757B 7B76 7C78 7278 413E 3D3E 3E75 7592"
	$"7B7B 907B 7576 A7A9 D6A7 6980 8382 8883"
	$"8388 AC88 821A B283 8388 8182 825A 5A59"
	$"5982 9C88 8883 8982 889D 8888 9D88 9C89"
	$"84FD 590F 5589 889D 8782 8883 8A8A 8882"
	$"8A8B 9C89 FC59 0958 88AC 8A8A 9C88 8388"
	$"82FE B1FF B038 8388 8389 8388 B182 8883"
	$"88B1 8883 8888 8288 8984 8A58 5958 5959"
	$"8383 9C87 889D 8983 82B1 AFDC B072 89B1"
	$"B0BD B8B8 BDD6 B5B0 DCB8 B9B5 AFAE AEFD"
	$"A30F AEC6 BDBD B8BD AEB3 C7B3 BDD0 B5C8"
	$"C6C1 FDA3 0B90 BFBD D0BC B7BD B8C8 C8B5"
	$"B0FE C800 B6FB A301 B5D6 FEC8 1EB5 B8BD"
	$"AEDA DBDB D8D8 B8BD B7BC B8BD DAAE BDB8"
	$"B3DA BDB8 BDBD B0B5 C6C1 C89B FDA3 FFB8"
	$"0AC8 B4BD D0BC B7AE DAC9 F4D1 0154 2567"
	$"5477 7C75 7B7B 757B 767C 767B 7B92 7C7C"
	$"763F 3F3D 3E7C 7C75 A573 79A7 767C 757B"
	$"7B76 7C78 78FD 3EFF 75FF 7B0C 757B 7B75"
	$"7872 7CA1 7871 7C76 77FC 3E23 767C 7279"
	$"7C76 A57B 7C76 7C76 A77C 757B 757B 757B"
	$"7CA7 757B 7676 7B75 A575 7C92 7778 7241"
	$"FD3E 177A 7B7C 767B 7B75 7B7C 76AA D1D4"
	$"6957 8388 8388 8883 8782 881A 8288 889C"
	$"8888 825A 5A58 5988 8883 B183 89B1 8288"
	$"8188 8882 8889 89FD 59FF 83FF 880C 8388"
	$"8883 8A84 88AC 8A83 8882 8AFC 5923 8288"
	$"848B 8882 B188 8882 8882 B087 8388 8389"
	$"8388 88B1 8388 8282 8883 B183 889C 8889"
	$"8458 FD59 1E87 8888 8288 8883 8988 82B0"
	$"D7DC 7261 B1B5 B8BD BDB8 B4B0 B5B0 BDBD"
	$"C8B5 B3AE FDA3 FFB3 0DB8 E3B8 BDDA AEB3"
	$"ADBD BDB0 B5C6 C6FD A3FF BAFF BD0C B8BD"
	$"BDB8 C8C2 B5D6 C8C2 B5B0 CFFC A323 B0B5"
	$"C2C8 B5B0 E3BD B3AE B5B0 D8B2 B8BD B7BC"
	$"B8BD B3DA B8BD AEAE BDB8 E3B8 B5C8 C5C6"
	$"C29B FDA3 0CBC BDB5 B0BD BDB7 BCB3 AECA"
	$"EFFA 0156 1100 3E72 7878 72A7 777B 7B76"
	$"7C7C 757B 7578 41FD 3E0F 7B75 7B76 7B75"
	$"7278 757B 927C 7278 797A FD3E 3772 7892"
	$"7C75 A574 7B92 7C75 7B76 7C72 7872 403C"
	$"3D3E 3E3F 717C 7672 7876 767B 757B 7578"
	$"737B 757B 767B 7575 A5A8 9378 727C 767B"
	$"7578 7875 75FB 3E17 767C 767C 7575 A57A"
	$"777D AAAB C408 437B 818A 84B1 8389 8982"
	$"FF88 0481 8883 8958 FD59 0F88 8388 8389"
	$"8384 8983 889C 8884 8A80 81FD 5939 848A"
	$"9C88 83B1 8288 9C88 8388 8288 8489 8458"
	$"5A5B 5959 5884 8882 8489 8282 8883 8983"
	$"8985 8883 8883 8883 83B1 B09B 8A84 8882"
	$"8883 8A8A 8383 5A5A FD59 1E82 8882 8883"
	$"83B1 8782 87B0 B1C7 2158 A0A5 C8C2 DBB1"
	$"BFBF B0B5 B3AD BDB8 C699 FDA3 0FBD B8BD"
	$"B9BC B7C1 C6B8 BDC8 B5C2 C8A3 A4FD A339"
	$"C2C8 C8B5 B8E3 B7BD C8B5 B8BD B7BC C1C6"
	$"C49D A3A4 A3A3 9BC2 B5B0 C1C6 B0B0 BDB8"
	$"BFBA C6C2 BDB8 BDB9 BDB8 B8E3 D1BE C6C1"
	$"B5B0 BDB8 C8C8 B8B8 A5A5 FDA3 0CAE B3B0"
	$"B5B8 B8E3 BCB0 B5CA CAD7 0155 1101 3E78"
	$"7E78 7876 7C91 7B92 7C76 A775 7B78 72FD"
	$"3E0F 767B 757B 757B 7878 7B75 7C76 7879"
	$"9580 FD3E 3741 787C 767B 7B75 7B7C 777B"
	$"757B 7679 7840 403C 3C3E 3E3F 3F7C A178"
	$"7876 7C7B 767B 7541 4175 7B75 7B7B 757B"
	$"7C7E A878 7892 7C7B 7578 727B 44FB 3EFF"
	$"7615 7C92 7B7B 757B 927D AAD1 D70A 4381"
	$"878A 8A82 889E 899C 0688 82B1 8388 8984"
	$"FD59 0483 8883 8883 FE89 0788 8388 828A"
	$"8B9B 86FD 5939 588A 8882 8888 8388 8883"
	$"8883 8782 8A89 5858 5A5A 5959 5858 88AC"
	$"8989 8288 8883 8983 5858 8388 8388 8883"
	$"8889 87B0 8A8A 9C88 8883 8A84 8856 5A5A"
	$"FD59 FF82 1C88 9C88 8883 889C 87B0 D7DB"
	$"2258 A5AA C8C8 B0B5 D2BF C8B5 AEDA B8BD"
	$"C6C1 FDA3 0FB9 BDB8 BDB7 BCC6 C6BD B8B5"
	$"B0C8 C8BD AAFD A311 9BC8 B5B0 BDBD B8BD"
	$"B5B1 BDB8 BBB7 C7C6 9D9D FDA3 FF9B 21B5"
	$"D6C6 C6B0 B5BD B9BF BA99 99B8 BDB8 BDBD"
	$"B8BD BEAA D1C6 C6C8 B5BD B8C8 C2BD 8FA5"
	$"A5FD A3FF AE0A B5C8 BDBD B8BD C8B5 CAEF"
	$"EA01 4F0E 0F45 607E 7575 7C7C 7872 7677"
	$"767C 7BFE 75FD 3E0F 7B90 7878 A17C 7591"
	$"7BA5 747B 927C 7879 FD3E 1275 7B75 7B75"
	$"767C 9278 7892 7C7C A178 7275 4440 FD3E"
	$"1E3D 3E3D 7676 7872 7278 3F40 3E3E 4172"
	$"7B75 757B 7575 7CA7 A776 7B75 75A6 7575"
	$"FD3E FF3F FF3E 1743 7A78 7876 7C77 7D78"
	$"72AB D7A8 184A 6A87 8383 8787 8984 8903"
	$"8A82 8888 FE83 FD59 2688 9D89 89AC 8882"
	$"9C88 B182 889C 8889 8A59 595A 5A83 8883"
	$"8881 8288 9C8A 8A9C 8888 AC89 8483 565A"
	$"FD59 2258 5958 8282 8A84 8489 5A5B 5959"
	$"5884 8883 8389 8383 88B1 B182 8883 83B2"
	$"8383 5959 5A5A FD59 1B56 888A 8A82 8882"
	$"8789 84AE DBB0 2D5C 90AA B8B8 B6B6 C6C1"
	$"C7C8 AEB3 BDFE B8FD A31A BDD0 C6C6 D6B5"
	$"B0C8 BDE3 B7BD C6B3 C6C7 A3A3 A5A5 B8BD"
	$"B8BD AFB0 B5FD C8FF B505 D6C6 C1B8 8FA4"
	$"FAA3 FFB8 03C8 C2C1 C6FD A315 9BC2 BDB8"
	$"BABF B8B8 B5DB DAAE BDB8 B8E4 B8B8 A3A3"
	$"A5A5 FDA3 0C97 C4C8 C8AE B3B0 B5C6 C1C0"
	$"ECD1 0145 1100 3E78 787B 7B91 7678 7871"
	$"7776 767B A57B 43FD 3E0F 7B7C 7278 767C"
	$"7B7B 757B 757B 7C76 7278 FD3E 1175 7B75"
	$"7BA7 7C76 7C72 787D 767B 7679 7775 44F9"
	$"3E01 4345 FD41 FF3F FF3E FF41 0C75 7B7B"
	$"747B 7B75 767C 767B 757B FE44 FD3E FF3F"
	$"FF3E 1743 7473 7877 A777 7778 78C4 C4D4"
	$"0743 8181 8888 9C82 8989 8406 8A82 8288"
	$"B188 55FD 5904 8889 8489 82FE 881D 8388"
	$"8388 8882 8489 5959 5A5A 8388 8388 B188"
	$"8288 848A 8982 8782 8A88 8356 F959 0154"
	$"55FD 58FF 5AFF 59FF 580C 8388 8982 8888"
	$"8182 8882 8883 88FE 56FF 59FF 5AFD 591E"
	$"5683 858A 83B1 8282 8989 C8C8 DB1B 55A5"
	$"A5BD BDC9 B1C6 C6C2 C8AE AEBD E3BD 8FFD"
	$"A304 BDBE C1C6 B0FE B51D B8BD B8BD B3AE"
	$"C1C6 A3A3 A5A5 B8BD B8BD DBB5 B0B5 C2C8"
	$"B6B0 B4B0 C7C5 B88F F9A3 058E 8F9B 9B99"
	$"99FD A3FF 9B0C B8BD BFB9 BDBD AFB0 B3AE"
	$"BDB8 BDFE 8FFF A3FF A5FD A30C 97BF C3C8"
	$"AFDA B0B0 C6C6 D9D9 FB01 0C11 013E 7878"
	$"7C76 7873 7C92 7B75 A67D 7776 7872 FD3E"
	$"0F7D 927C 7679 7377 767C 757C 7575 A57B"
	$"75FD 3E0F 4172 7C76 7575 7878 767C 907B"
	$"767C 757B F73E FF3F F83E 0C40 3E3E 767C"
	$"7575 7878 757B 7544 F53E 173D 3E75 757B"
	$"7578 7876 7CA7 CFA8 0A43 8181 8882 8A85"
	$"889C 8806 83B0 8883 8289 84FD 590F 879C"
	$"8882 8983 8180 8983 8881 83B1 8883 FD59"
	$"0F58 8488 8283 8389 8982 889D 8882 8883"
	$"88EC 590C 5A59 5982 8883 838A 8A83 8883"
	$"56F5 591E 5859 8383 8883 8A8A 8287 B1D7"
	$"B022 58A5 A5B5 B0C8 C3B5 C8BD B8E3 BEB1"
	$"B0C6 C1FD A30F B5C8 B3AE BDB8 AEAD BEB8"
	$"B3AD B8E3 BDB8 FDA3 0F9B C2B5 B0B8 B8C6"
	$"C6B0 B5D0 BDB0 B5B8 BDEC A30C A4A3 A3B0"
	$"B5B8 B8C8 C8B8 BDB8 8FF3 A3FF B808 BDB8"
	$"C8C8 ACB2 D1F6 D301 1811 0F45 727E 7C92"
	$"7878 767C 757B 767C 767B 7841 FE3E 243D"
	$"777D 76A7 7379 A87D 7B75 A776 7B7B 747B"
	$"3E3E 3D3E 4178 927C 7B7B 7872 A776 7B7B"
	$"7C92 7B75 FC3E FF3D 043E 403E 3F3F F73E"
	$"0B3D 3E76 767C 7B78 7276 7B75 7BF3 3EFF"
	$"4413 7B75 7872 A776 A7AD A818 4A7B 8788"
	$"9C8A 8A82 8883 0688 8288 8287 8958 FE59"
	$"1758 8287 82B1 8389 B087 8883 B182 8888"
	$"8288 5959 5859 588A 9CFE 8803 8984 B182"
	$"FE88 029C 8883 FC59 FF58 0159 5AF4 590B"
	$"5859 8282 8988 8A84 8388 8388 F359 FF56"
	$"0D88 838A 84B0 82B1 B6B0 305F A0AA B5FE"
	$"C809 B0B5 B8BD B8BD B0B4 C699 FDA3 0FB0"
	$"B5AE DAB8 BDDA B3BD B8DA AEBD BDB7 BDFD"
	$"A30F 9BC8 C8B5 BDBD C6C1 DBB0 BDBD B5C8"
	$"BDB8 F9A3 00A4 F2A3 FFB0 07BE BDC8 C2B9"
	$"BDB8 BDF3 A3FF 8F08 BDB8 C8C2 D8AC D1D6"
	$"D301 0F11 003E 7776 757B 7B8F 7C7C 798F"
	$"7973 7C76 907B FD3E 0F78 7278 7875 7B75"
	$"7576 7C72 7876 767B 75FD 3E0F 4172 7879"
	$"9276 927C 767B 7675 757B 7B75 F73E FF3F"
	$"FD3E 0340 3E3E 3DFE 3E0C 3D3E 3E76 7675"
	$"7B78 727B 7575 44F1 3EFF 750F 4172 A7A7"
	$"A807 4383 8283 8888 9C88 8889 069D 8983"
	$"8882 9D89 FD59 0F8A 8489 8983 8883 8382"
	$"8884 8A82 8288 83FD 590F 5884 8A8B 9C82"
	$"9C88 8489 8281 8388 8883 F759 FF5A FD59"
	$"035A 5959 58FE 590C 5859 5982 8283 8989"
	$"8488 8383 56F1 59FF 8316 5884 B1B1 B01B"
	$"55B1 B0B8 BDBD CFB5 B5BD D0BD B8B5 B0D1"
	$"BFFD A30F C8C2 C6C6 B8BD B8B8 B0B5 C2C8"
	$"B0B0 BDB8 FDA3 019B C2FE C80A B0C8 B5BA"
	$"BFAE ADB8 BDBD B8F1 A300 A4F8 A3FF B807"
	$"BABF C6C1 BDB8 B88F F1A3 FFB7 0499 C1DB"
	$"DBD1 0107 1A01 3E75 7C7B 757A 7B76 9279"
	$"7973 79A1 7C7B 443D 3E3E 4078 7872 7875"
	$"FE7B 07A7 7678 797C 76A5 7BFD 3EFF 4101"
	$"7378 FE7C 0876 7B75 7CA7 7B75 7544 FC3E"
	$"0040 FD3E FF3F F33E 0945 7C7B 7578 7874"
	$"7C7B 75F1 3EFF 44FF 410D 7CA7 A809 4381"
	$"8888 8387 8882 9C89 0F89 8389 AC88 8956"
	$"5859 595A 8A8A 8489 83FE 8807 B182 8A8B"
	$"8882 B188 FD59 FF58 0185 8AFE 8808 8289"
	$"8388 B188 8383 56FC 5900 5AFD 59FF 5AF3"
	$"5909 5588 8983 8989 8289 8883 F159 FF56"
	$"FF58 1488 B1B0 1E55 AFB5 BDB8 BCBD B0C8"
	$"BDBD B8BD D6B5 BF91 FEA3 00A4 FFC8 02C1"
	$"C6B8 FEBD 07DB B0C8 C8B5 B0E3 BDFD A3FF"
	$"9B01 C3C8 FEB5 08B0 BFBA B3DA BDB8 B88F"
	$"FCA3 00A4 EDA3 098F BDBF BAC6 C6B7 BEBD"
	$"B8F1 A3FF 8FFF 9902 B5DB D100 FC11 013E"
	$"7278 76A7 7677 7878 757B 757B 7B75 7872"
	$"FD3E 1177 927B 757C 9275 757B 757C A175"
	$"7B75 753C 3CFD 3E0B 4172 787D 757A 757B"
	$"7C76 7278 F33E FF3F FF3E FF3F FB3E 0B3D"
	$"403F 3F75 7B75 7B75 7A75 7BF0 3E10 403D"
	$"3EA7 A7A8 0A43 7B81 82B1 8283 8989 821C"
	$"8883 8888 8389 845A 5A59 5983 9C88 8288"
	$"9C83 8388 8388 AC83 8883 835A 5AFD 590B"
	$"5884 8287 8387 8388 8882 848A F359 FF5A"
	$"FF59 FF5A FB59 0058 FE5A 0783 8883 8883"
	$"8783 88F0 591B 5A58 59B1 B1B0 2258 A0A5"
	$"AEDA B0B1 C6C6 B0B5 B8BD BDB8 C6C1 A5A5"
	$"A3A3 0FB1 C8B5 B0B5 C8BA BABD B8B5 D6B8"
	$"BDB8 B8FB A30B 99C1 B1B5 B8BC B8BD B5B0"
	$"C2C8 E6A3 0AA4 A3A3 B8BD B8BD B8BC B8BD"
	$"F0A3 05A4 A3A3 DBDB D101 1C27 013E 787E"
	$"7C76 7CA7 7772 7C91 7B75 7B75 7841 3E3D"
	$"3E3E 7C7C 75A6 767C 7B7B 757B 767C 7B75"
	$"7B7B 3B3C FD3E FF41 0B7D 927B 75A5 7B92"
	$"7C78 413E 40FE 3E00 40F9 3EFF 3F06 3E40"
	$"3F3F 3E3E 3DFC 3EFF 3F08 4475 7B74 7B75"
	$"7B75 77F3 3E01 403D FE3E 0D7C A7A8 0A43"
	$"8187 8882 88B1 8884 8907 9C88 8388 8389"
	$"585A FE59 FF88 0F82 B182 8889 8983 8882"
	$"8888 8388 8859 5AFD 59FF 580B 879C 8883"
	$"B188 9C88 8A58 595A FE59 005A F959 FF5A"
	$"0059 FE5A FF59 0058 FC59 FF5A 0856 8388"
	$"8288 8388 838A F359 015A 58FE 5918 88B1"
	$"B022 58A5 AAB3 AEB5 DBC5 C1B6 C8BD B8BD"
	$"B8C6 99A5 A4A3 A3FF B50D B0DB B0B5 BFBF"
	$"B8BD B0B5 BDB8 BDBD FBA3 FF99 0BB5 C8BD"
	$"B8E3 BDC8 B5C8 9BA3 A4FE A300 A4F6 A300"
	$"A4F5 A308 8FB8 BDB7 BDB8 BDB8 CFF3 A300"
	$"A4FD A302 B5DB D100 F311 0F45 5F7E 757B"
	$"7575 767C 757B 7B90 7878 9379 FE3E 1240"
	$"757B 7872 7B75 7C92 7D77 7B74 7B7B 7576"
	$"3F3F F93E 0578 7275 7541 3BF8 3E00 3DFD"
	$"3E02 3D3E 3DF0 3E07 7278 757B 767C 757B"
	$"FB3E 003D FE3E FF3C 0040 FC3E FEA8 0A18"
	$"4A69 8783 8883 8382 8883 FF88 049D 8A8A"
	$"9C82 FE59 105A 8388 8A84 8883 889C 8782"
	$"8882 8888 8383 F759 0589 8483 8360 5CF8"
	$"5900 58FD 5902 5859 58F8 59FF 5AFB 5907"
	$"8489 8389 8288 8388 FB59 0058 FE59 FE5A"
	$"FC59 FEB0 112D 5C8F AAB8 BDB8 B8B0 B5B8"
	$"BDBD D0C8 C8BD A5FE A300 A40F B8BD C8C2"
	$"BDB8 B5C8 B5B0 BDB7 BDBD B8B9 F7A3 05C6"
	$"C1BA BAB1 ADE7 A3FF A5FB A307 C1C6 B7BC"
	$"B0B5 B8BD F5A3 00A4 FCA3 FED1 00F8 1100"
	$"3E78 787B 757B 7B7C 927B 757B 7B72 797E"
	$"78FD 3E0C 7C75 7878 757B 767C 7EA3 7B75"
	$"A0FE 7B00 3FF8 3EFF 41FF 44FF 3BFD 3E00"
	$"40FD 3E00 40EF 3E00 3DFC 3E0B 4178 757B"
	$"7C92 7B75 773E 3E40 FB3E FF3C FB3E 0878"
	$"A8A8 0743 8181 8883 FE88 019C 8806 8388"
	$"8884 8B87 81FD 590C 8983 8A8A 8388 8288"
	$"88AC 8883 ACFE 8801 5958 F959 FF58 FF56"
	$"FF5C FD59 005A FD59 005A F159 FF5A 0058"
	$"FC59 0B58 8983 8988 9C88 838A 5959 5AFB"
	$"59FF 5AFB 5914 81B0 B01B 55A5 A5BD B8BD"
	$"BDB5 C8BD B8BD BDC2 C8AA A4FD A30C BEB8"
	$"C8C8 B8BD B0B5 B6D7 BDB8 DEFE BDF7 A3FF"
	$"99FF 91FF ADFD A300 A4FD A300 A4F1 A3FF"
	$"A5FB A30B 99C6 B7BC B5C8 BDB8 CFA3 A3A4"
	$"F3A3 02A5 D1D1 00F9 1100 4472 7E75 7B90"
	$"7B75 7B7C 767C 927B 7578 41FD 3E19 76A7"
	$"7575 7CA2 7C76 7B75 7878 757C 9276 3E3E"
	$"403D 3E3E 403E 3E40 F63E 023D 3E40 E73E"
	$"0941 727B 9078 7772 7876 76FB 4117 7544"
	$"7241 7544 7544 7241 AAC3 A80D 4B7B 8783"
	$"889D 8883 8888 0682 889C 8883 8958 FD59"
	$"1982 B183 8388 AD88 8288 8389 8983 899C"
	$"8259 595A 5859 595A 5959 5AF6 5902 5859"
	$"5AE7 5909 5884 889D 8A89 848A 8282 FB58"
	$"1E83 5684 5883 5683 5684 58B0 C8B0 2B67"
	$"A0AA B8BD D0BD B8BD B5B0 B5C8 BDB8 C699"
	$"FDA3 12B0 DBB8 B8B5 D7B5 B0BD B8C6 C6B8"
	$"BEC8 B0A3 A3A4 FEA3 03A4 A3A3 A4F4 A300"
	$"A4E7 A31C 99C1 BDD0 C6C5 C2C8 AEAE 9B9B"
	$"9999 9B9B B88F C29B B88F B88F C199 CAE1"
	$"D100 E511 003C 727E 7B75 7B7B 757B 76A8"
	$"757C 7B75 7872 FD3E 0F7C 767A 7B76 7C7C"
	$"927B 7478 737B 747C 7CE4 3EFF 3D02 403E"
	$"3DF1 3EFF 4125 437C 7873 7878 A77C 7278"
	$"7178 7278 7B75 7878 757B 7B75 7978 AAD7"
	$"A80E 447B 8788 8388 8883 8882 06B2 8188"
	$"8883 8984 FD59 0F88 8287 8882 8888 9C88"
	$"8289 8588 8288 88E4 59FF 5802 5A59 58F1"
	$"59FF 582C 5589 8A85 8A8A B188 848A 8389"
	$"848A 8883 8A8A 8388 8883 8A89 B0DC B02E"
	$"61A0 AABD B8BD BDB8 BDB0 DCAF B5BD B8C6"
	$"C1FD A30F B5B0 BCBD B0B5 B5C8 BDB7 C6C2"
	$"BDB7 B5B5 E2A3 00A4 EFA3 FF99 1A8F BEC6"
	$"C2C8 C8DA B3C2 C8C0 C6C2 C8BD B8C8 C8B8"
	$"BDBD B8C7 C6CA F5D1 012B 110F 4578 7876"
	$"A775 7BA1 7C75 7B78 7276 7C75 76FE 3E21"
	$"4075 7B77 A87B 7578 7975 7B92 7C7B 757C"
	$"7644 4441 3F46 7644 757C 7575 7B76 767B"
	$"4475 FE44 FD41 FF3C 0040 FE3E 003D EF3E"
	$"0840 4343 4475 A7A7 A8A8 FEA7 1C76 7B75"
	$"7872 754A 7676 4772 7147 7575 A9A7 C418"
	$"4A81 8182 B183 88AC 8883 0688 8A84 8288"
	$"8182 FE59 215A 8388 81B0 8883 898A 8388"
	$"9C88 8883 8882 5656 5857 5582 5683 8881"
	$"8388 8282 8856 83FE 56FD 58FE 5AFE 5900"
	$"58EF 592F 5A57 5756 83B1 B1B0 B0B1 B1B0"
	$"8288 8389 8483 5B82 825D 8483 5D83 83B1"
	$"AFC7 2D5C A5A5 AEDA B8BD D6B5 B8BD C8C2"
	$"B0B5 ADAE FEA3 00A4 20B8 BDAE DABD B8C6"
	$"C7B8 BDC8 B5BD B8B5 B08F 8F99 9887 B08F"
	$"B8BD B7B8 BDB0 B0BD 8FB8 FE8F FF9B FF99"
	$"FFA3 00A4 EBA3 1DA4 9999 8FB8 DADA D1D1"
	$"DADA DCB1 BDB8 C6C1 B894 B0B0 9EC1 C09E"
	$"B8B8 D2D0 D701 2611 003E 5F7E 7C77 7B75"
	$"7C76 7B75 7878 A17C 7C76 FD3E 207B 757D"
	$"777B 7572 787B 757C 76A5 7B92 7C75 7578"
	$"A3A7 A7A5 7BA6 7CA5 7BA7 7CA5 A57B FEA5"
	$"05A3 7878 7275 3CED 3E00 3DFE 3E27 4374"
	$"7B75 7CA7 A37D A87C A87C 757B 7247 7575"
	$"7C76 7872 7872 7B44 A8D4 AB07 4369 8788"
	$"8388 8388 8288 0683 8A8A AC88 8882 FD59"
	$"1388 8387 8188 8384 8988 8388 82B1 889C"
	$"8883 8389 B2FE B109 88B0 88B1 88B1 88B1"
	$"B188 FEB1 05B2 8A89 848B 5AED 5900 58FE"
	$"592E 5783 8883 88B1 AB86 B288 B187 8388"
	$"845D 8383 8882 8984 8984 8856 B0DB AF1B"
	$"558F AAB3 AFBD B8B5 B0BD B8C8 C8D6 B5B3"
	$"AEFD A320 BDB8 B3AE BDB8 C1C6 BDB8 B5B0"
	$"E3BD C8B5 B8B8 C6EB DBDB E3BD E3BD E3BD"
	$"DBB5 E3E3 BDFE E304 EDC8 C6C1 CFE8 A31C"
	$"99C1 BDB8 B3DA CCA9 DBB3 DDB6 B8BD C19E"
	$"B8B8 B5B0 C6C1 C6C1 BD8F D1FB BF01 4012"
	$"003C 767C 757B 7C76 7878 927C 7777 7B75"
	$"7841 3DFE 3E2F 757B 757B 76A7 7379 927C"
	$"7CA7 7AAA A8A8 7B75 7CA8 7EA8 7CA7 A8A7"
	$"7BA5 A8A8 7EA8 A8A9 A57B AAAA A8A8 A575"
	$"3E3E 4141 3C3C FB3E FF3F FB3E FF41 FF75"
	$"277B 757B 7576 A67C A7A8 A37D A87A 4375"
	$"7578 7875 4A75 7B44 7B75 7BAA AAC2 0E44"
	$"8288 8388 8882 8989 9C07 8881 8188 8389"
	$"5858 FE59 0C83 8883 8882 B183 899C 8888"
	$"B181 FEB0 1388 8388 B287 B088 B1B0 B088"
	$"B1B0 B087 B0B0 B1B1 88FD B007 B183 5959"
	$"5858 5A5A F359 FF57 FF83 2E89 8388 8383"
	$"B188 B1B0 AB89 B289 5783 8389 8983 5B83"
	$"8856 8883 89B0 B0C9 2E61 B0B5 B8BD B5B0"
	$"C6C6 C8B5 AEAE BDB8 C699 FDA3 0CB8 BDB8"
	$"BDB0 DBB8 BDC8 B5B3 DAA5 FED1 1DBD B8B3"
	$"DBAA D1B3 DAD1 D0BD E3D1 D1AA D1D3 D4E3"
	$"BDCA CAD1 D1E3 B8A3 A39B 9BF1 A3FF 97FF"
	$"B81C BCB7 BDB8 AEDA B5DB D1CC B6DC C699"
	$"B8B8 C6C6 B894 B8BD 8FBD BABF CACA EB01"
	$"3F11 0044 717C 767B 927C 7972 7C76 A87D"
	$"7A75 7872 FE3E 303D 7BA6 757B 767C 7973"
	$"7CA7 A7A8 AAAA A8A8 757B A7A7 A3A8 A7A7"
	$"7EA3 A57B A37D A3A8 78A8 7BA5 95AA 78A8"
	$"7B7B 7777 7241 3C3C FB3E FF3F FB3E 1879"
	$"727B 7B75 7B44 757C 76A7 76A9 7EA7 A77A"
	$"747C 7B72 3F75 767B FE75 0F7B 75AA D2AD"
	$"0D4B 7D88 8388 9C88 8A84 8806 82B0 8787"
	$"8389 84FE 590C 5888 B283 8882 8889 8388"
	$"B1B1 B2FD B01F 8388 B1B1 ABB0 B1B1 87AB"
	$"B188 AB86 ABB0 81B0 88B1 9BB0 81B0 8888"
	$"8A8A 8458 5A5A F359 1889 8388 8883 8956"
	$"8388 83B1 82B1 87B1 B189 8389 8884 5783"
	$"8388 FE83 1689 83B0 D7B5 2B67 ABB5 B9BD"
	$"C8B5 C7C1 B5B0 DAB3 BCB8 C6C1 FDA3 0BBD"
	$"E4B8 BDB0 B5BD B8B5 DBDA DBFD D11D B8BD"
	$"DADA CCD1 DADA AACC E3BD CCA9 CCD1 A7D3"
	$"BDE3 B6CA A5D1 BDBD CFCF C29B F1A3 18C4"
	$"BFBD BDB7 BC8F B8B3 AEDB B0D2 AADB DBC6"
	$"C1BE BDC1 98B8 B9BD FEB8 04BF BACA F0D8"
	$"015F 0114 42FE 781B 727B 76A2 7C78 7876"
	$"767B 907B 753C 3C3E 3E74 757C 767C 76A8"
	$"A8A7 A7A8 FEA7 FFAA 217B A7A8 7EA5 7BA4"
	$"80A8 A87C B2A6 A6A7 7CA7 A7A8 A77B A6A7"
	$"A7AA 7A75 7577 7875 7B40 40FE 3E01 403D"
	$"FE3E FF41 2D76 7C75 7B44 7578 7278 7875"
	$"7B7C A5A8 A8AA 7AA7 7C75 757B 7B77 7144"
	$"7B79 4175 7BAA AAD2 1642 8181 8984 8883"
	$"AD88 8A10 8A82 8288 9D88 835A 5A59 5982"
	$"8388 8288 82FE B001 B1B2 FEB1 FFB0 0B87"
	$"B1B0 87B1 88AB 87B0 B088 BCFE B112 88B1"
	$"B1B0 AF88 B2B1 B1B0 8183 8389 8A83 8858"
	$"58FE 5914 5A59 5A59 5958 5882 8883 8856"
	$"8389 848A 8A83 8889 B1FE B023 81B1 8883"
	$"8389 898A 8456 888B 5883 88B0 B0D6 244E"
	$"A5A5 C6C1 BDB9 D7B5 C8C8 AEAE BDD0 BDB8"
	$"FDA3 05B7 B8B3 AEB5 B0FD D100 DCFE DBFF"
	$"D121 B4DB D1AA E3BD CCAA D1D1 B5E5 DBDB"
	$"DAB3 DBDB D1D0 BDE4 DADA D1A5 B8B8 C7C8"
	$"B8BD 9D9D FEA3 FFA4 12A5 A3A3 9999 B0B5"
	$"B8BD 91BA C6C1 C8C8 B8BD BEE3 FED1 11A5"
	$"DAB3 B8B8 BCBC C8C2 8FBD C89B B8BD CACA"
	$"E501 5701 0442 FD78 1275 7B7C 7572 787C"
	$"767B 7B75 443C 3C3E 3E7B 7C76 FEA7 FFA8"
	$"FEA7 267C A77C AAAA A7A7 A8A3 7BA5 AAAA"
	$"78A8 A77C A67B A7A7 7CA7 78A8 A57B A77C"
	$"AA7A 7B7B 7278 757B 7278 FB3E 313D 3E72"
	$"7776 7743 757B 7541 7872 417B 7575 7BA8"
	$"78AA AAA7 A87B 4475 753F 7775 7572 7974"
	$"44AA D1AB 0642 8181 8989 8388 8881 840D"
	$"8A88 8288 8883 565A 5A59 5988 8982 FEB1"
	$"FFB0 FEB1 2688 B188 B0B0 B1B1 B0AB 88B1"
	$"B0B0 81B0 B188 B188 B1B1 88B1 81B0 B088"
	$"B188 B081 8888 848A 8388 8489 FD59 FF5A"
	$"3858 5984 8882 8355 8389 8358 8984 5888"
	$"8383 88B0 81B0 B0B1 B288 5683 8358 8A83"
	$"8384 8B82 56B0 D7AF 144E A5A5 C6C6 B8BD"
	$"B5AF C2C8 B3AE BDBD B88F FDA3 05BD BEAE"
	$"DADB DBFD D127 DBB5 DBB5 D1D1 DBDB D1CC"
	$"BDE3 D1D1 A5D1 DBB5 DBB5 DADA B5DB A5D1"
	$"E2BD DAB3 D1A5 BDBD C2C8 B8BD C4C9 FDA3"
	$"FFA5 FFA3 24C1 C5B0 B18F B8BF BA99 C6C2"
	$"9BBD B8B8 BDD1 A5D1 D1DA DBBD 8FB7 B79B"
	$"C8B8 B8C2 C8B7 8FCA EFBF 015A 1803 4173"
	$"8076 7CA0 7B76 7D7D A278 7E90 7B7B 7541"
	$"4146 4678 7EA8 FEA7 FFA8 FFAA FDA8 5BAA"
	$"C380 AA7E A8A7 7C76 A77B 7B77 7D76 7C75"
	$"7BA1 7CA8 7EAB AB7E A3A7 7C76 7C78 7E78"
	$"7E74 7B75 7B41 4146 4641 7875 7B72 787E"
	$"7E76 7C7B 7575 7B46 767E 77A8 A87C A778"
	$"A87B 757B 7B75 7B72 7847 727B 7BA8 ADC4"
	$"0743 7A87 8288 AC88 8289 8710 AB81 879D"
	$"8888 8358 5855 5581 87B0 AFB1 B1F8 B065"
	$"C887 B087 B0B1 8882 B188 8880 8682 8883"
	$"88AC 88B0 87AF AF87 ABB1 8882 8881 8781"
	$"8782 8883 8858 5854 5458 8A83 8884 8A87"
	$"8782 8888 8383 8854 8287 80B0 B088 B181"
	$"B088 8388 8883 8884 895D 8488 88B0 B5C7"
	$"144E 96A2 AEB3 DEBD AEB4 AACC A5AA D0BD"
	$"BDB8 9B9B 8787 5EA5 AAD1 D0DB DBD1 D1CA"
	$"CAD3 D3D1 D1CA E1A2 CAAC D3DB B5AE DABD"
	$"BDA4 A9B0 B5B8 BDD6 B5D1 AAC1 C1AA CCDB"
	$"B5B0 B5A5 AAA5 AAB7 BDB8 BD9B 9B85 859B"
	$"C8B8 BDC1 C6AA AAB0 B5BD B8B8 BD85 AEAA"
	$"A4D3 D3B5 DBA5 D1BD B8BD BDB8 BDC1 C69E"
	$"C1BD BDD1 D6D7 0162 1667 B7D6 D1A7 767C"
	$"7B92 7C77 A7CF A87B 7B75 7B41 A3C0 D3CF"
	$"FEA8 05A7 7CA8 A8AA C3FE A85C A7AA D6DF"
	$"D1C1 A876 767C 7675 75A8 C1A7 7675 7A76"
	$"7CA8 DED2 C4A9 A8A7 767C C0D4 DED0 A875"
	$"7B75 7B72 78A7 C078 737B 7546 A3C1 CFA7"
	$"A775 437B 75A7 A7D4 C1C1 7EA7 A7A8 A8A5"
	$"7BA5 757B 7547 7272 7875 A5A8 CFAB 69B9"
	$"DCD7 B182 8988 9C88 820B B1D7 B088 8883"
	$"8858 B2C9 DAD7 FEB0 01B1 88FE B000 C8FE"
	$"B067 AFB0 DCE5 D7C8 B082 8288 8283 83B0"
	$"C8B1 8283 8782 88B0 E3D6 C8B1 B0B1 8288"
	$"C9DB E3D7 B083 8883 8884 8AB1 C98A 8588"
	$"835D B3C8 D7B1 B183 5588 83B1 B1DB C8C8"
	$"87B1 B1B0 B0B1 88B1 8388 835D 8484 8983"
	$"B1B0 D7AF 72C1 F4EF DAAE BEBD C6B3 A5D1"
	$"F6D1 BDBD B8BD 9BED F2FC 00F6 FED1 5ADB"
	$"B5D1 D1CA E1D3 D3D1 D0CA F4FC EFEA D3B0"
	$"B0B3 AEB8 B8D1 E8DB B0B8 BCB0 B5D1 FCE7"
	$"D9D2 D1DB B0B5 F2FB FCF7 D1B8 BDB8 BDC2"
	$"C8DA F1C8 C3BD B89E EBE8 F6DB DBB8 8FBD"
	$"B8DA DAFB E8EA ACDB DBD1 D1E3 BDE3 B8BD"
	$"B89E C1C1 C6B8 E3D1 F6BF 015F FFC8 1DAA"
	$"D1D7 C47A 757D A8AA D6D6 AA76 767B 75C4"
	$"D7A7 CED7 E1AA AAA8 A8C4 D7E3 D9FD A85B"
	$"D2D7 D0AD D6D1 A77C 754A 7EA8 D7D7 A77C"
	$"7676 7ECF E1C4 D4D4 CF7E 7379 D4D9 CFCF"
	$"D6D6 A77C 76A7 ABD2 E1D7 767C 4072 ABD2"
	$"D4A8 D6D1 A77C 767C D3D7 A8D4 D6D1 A77D"
	$"A87D ABC4 AAAA 7278 757B 767C 7CA7 C4B1"
	$"CFC8 C8AF D6DB C787 8386 B0B0 FFDC 0AB0"
	$"8282 8883 C8DB B1D7 DBE4 FDB0 03C7 DBE4"
	$"DBFD B066 D6DB D7B5 DCD7 B188 835B 87B0"
	$"DBDB B188 8282 87D7 E4C8 DBDB D787 8389"
	$"D6DB D7D7 DCDC B087 82B1 AFD6 E4DB 8288"
	$"5884 AFD6 DBB0 DCD7 B188 8288 D7DB B0DB"
	$"DCD7 B189 B086 AFC8 B0B0 848A 8389 8288"
	$"88B1 C8B5 D7C8 C8CA F0EA D7BC B8A9 D1CA"
	$"F4F4 CAB0 B0BD B8D9 ECDB FB5E ECF4 CACA"
	$"D1D1 D7EA ECE3 DADA D1D1 E7EC F7D6 F4EF"
	$"DBB5 B894 AAD1 EAEA DBB5 AEAE AAF6 F4D9"
	$"FBFB F6AA B8BD DEE3 F8F8 F4F4 DCB6 AEDA"
	$"BFE5 F3EA B0B5 99C1 C1E7 FBD1 F4EF DBB5"
	$"B0B5 E6EA D1FB F4EF DBB6 D1A9 C1D9 C8C8"
	$"C2C8 BABF B0B5 B3DA DAC8 F801 6220 C779"
	$"7AAA D7D2 A57B 77C1 D6D1 D1AA 7C76 7BA5"
	$"D7C4 7C7C D2D7 D1AA A8A8 D7E1 F0E3 7DFE"
	$"A84A D7E1 A877 AAD6 CF7C 7576 C1D4 D2D2"
	$"A776 7C76 A9D4 D281 48C1 D4A8 7973 D4D5"
	$"7E7D AAD1 CE7C 767C E1D7 E1D7 A776 7978"
	$"E1D7 A878 AAD6 CE7C 76D4 D2AB 7878 AAD6"
	$"A7A7 93A9 D2D7 C3AA 7841 757B 76FE A70D"
	$"C4D2 ADC7 7980 AFDB D6B1 8880 C8DC FFD7"
	$"0BB0 8882 88B1 DBC8 8888 D6DB D7FE B004"
	$"DBE4 F2E4 87FE B04A DBE4 B080 B0DC D788"
	$"8383 C8DB D6D5 B182 8882 B1DB D686 53C8"
	$"DBB0 8983 D6D7 8786 B0D7 D687 8288 E4DB"
	$"E4DB B182 8B8A E4DB B081 B0DC D788 82DB"
	$"D6AF 8181 B0DC B1B1 9BB1 D6DB C8B0 8A58"
	$"8389 82FE B118 C8D6 B5C7 799D CAEA E5E3"
	$"BDA4 E8F4 EFEF CAB5 B0BD E3EC D9B5 B559"
	$"E7EC EFCA D1D1 EAF3 F9EC B3DA D1D1 ECF4"
	$"D1A4 CAF4 FBB5 B8B9 E8FB E5E4 DBB0 B3AE"
	$"D2FB E799 7BE8 FBD1 BDB8 DEDF ACAB CAEF"
	$"FBB6 AEB3 F3EA F3EA DBB0 C7C6 F4EC D1A5"
	$"CAF4 FBB5 B0FC E5BF A5A5 CAF4 DBDB BED2"
	$"E7EC E0C8 C89B BABF B0DB FEDA 01E8 D801"
	$"6119 C767 5E7C D4D9 A878 7877 AADF D6AA"
	$"7B75 80D1 D6AA 7278 D2E0 D6AA FEA8 62C1"
	$"D7E1 A776 AAAA E1D7 7278 7AD1 D7AA 757B"
	$"7C75 D7D2 7B7B 4178 D2D8 A473 7CA7 DAD4"
	$"76A7 ADA7 3F3F 7ED4 E1AB 7EA8 A7D4 E3E3"
	$"7BA8 7AAA D7C4 7872 7ECF D6AA 7DCF D47C"
	$"7B7B D2C4 CF7E A7A6 AAD1 ADA8 7272 7872"
	$"7C76 79A4 D4A8 C4C7 676C 88D6 DBB0 818A"
	$"89B0 0DE5 DCB0 8883 87D7 DBB0 8489 D6E3"
	$"DCFD B03F C8DB E4B1 82B0 B0E4 DB84 8981"
	$"D7DC B083 898A 83DB D689 8958 89D6 DCB2"
	$"8388 B1DC D682 B1B6 B159 5987 DBE4 AF87"
	$"B0B1 DCE4 E487 B280 AFDB C88A 8487 D7DC"
	$"B087 D7DB FE88 2AD6 C7D7 87B1 B0B0 D7B5"
	$"B084 8489 8488 8289 B2DB B0C7 C767 9BB5"
	$"E5EA D1A5 C6C5 CAFC F4CA BDB8 A2EF F2C8"
	$"C1C6 03E7 F4F4 CAFE D157 E8EC F4DB B0CA"
	$"CAF3 EAC1 C69D EFF5 CABA BFC0 BAEA E5BF"
	$"BF99 C6E7 ECE3 B8B3 DAE4 DEB0 DBD6 D1A5"
	$"A5AA FBF4 C1AA D1D3 FCEC ECB4 DC9D CAEC"
	$"D9C6 C1AA F6F4 CAAA F6FC B5BD BDE5 D7F6"
	$"AADA D9CA EFD6 D1C1 C1C6 C1B5 B0BD E3FB"
	$"D1D7 0162 7FD6 7976 7BE3 D9C2 7E72 787A"
	$"D6D1 AA75 7AC3 D6E0 AA78 78AB D8DF AAA8"
	$"A87E A8D7 E17C A7AA D1D7 D272 457A D6D1"
	$"AA7B 7575 7BD2 D7A5 7572 78D7 D279 7A76"
	$"A7D4 D47C D4CF A73F 3F78 CFD2 AB93 A8A7"
	$"A7E3 D9A7 A7AA D2D2 D772 4678 D4D1 AAA7"
	$"D4CE 7C75 75AB ABD4 A8A7 7CAA AAD0 A847"
	$"7872 4776 7679 A4A8 D4AB D679 8287 E5DB"
	$"C987 848A 810D DCD7 B083 87C8 DCE4 B089"
	$"89AF DCE5 FEB0 6E87 B0DB E488 B1B0 D7DB"
	$"D684 5C81 DCD7 B089 8383 89D6 DBB1 8384"
	$"89DB D689 8A82 B1D6 D688 DBD7 B159 5981"
	$"D7D6 AF9B B0B1 B1E4 DBB1 B1AF D7D6 DB84"
	$"5D81 DBD7 B0B1 DCD7 8883 83AF AFDB B0B1"
	$"88B0 B0D7 B05D 8984 5D82 8289 B2B0 DBAF"
	$"D679 B0B4 F4EA E9AA C1C6 9DF4 EFCA B8BC"
	$"E1F4 FBC8 C6C6 2BC1 ECFC CAD1 D1AA D1EC"
	$"F4B5 DBCA EFEA E5C1 9D9D F4EF CABF BABA"
	$"BFE5 EAE4 BAC1 C6EC E7BD BEAE DADE DEB5"
	$"FCF6 D1FE A52F F6E7 C1BE D1D3 D3EC E3DB"
	$"DBCA F0E7 ECC1 9EA5 FBEF CAD1 FBFB B5B8"
	$"B8BF BFFB D1DA B3CA CAF7 D19E C6C1 9EB0"
	$"B0BD E3D1 FBBF 0162 7FC6 7E78 A8D4 D4C1"
	$"7E79 737D DED6 AAA8 A8AB E1D6 AA75 75AA"
	$"D6DE A873 797A AAE1 E1A7 A77E CFD7 D27B"
	$"757B CED6 AA72 7875 7BD2 D2A5 7B72 78D5"
	$"D9A8 784A A5D7 D77C C0C3 AA3E 3E78 ADCF"
	$"7E7D A87F C0D7 E1A7 7CA8 D4D7 D27A 7577"
	$"D4D2 ABAA D1CF 7E75 7BAA D6C1 A87C A7AA"
	$"AAD4 A876 7677 727B 757C A7C3 AAD2 C880"
	$"81B0 D6D6 C887 8983 8801 E5DC FEB0 7AAF"
	$"E4DC B083 83B0 DCE3 B083 8981 B0E4 E4B1"
	$"B187 D7DB D688 8388 D7DC B084 8983 88D6"
	$"D6B1 8884 89D7 DBB0 815B B1DB DB88 C9C8"
	$"B059 5981 B5D7 8787 B088 C8DB E4B1 88B0"
	$"DBDB D687 8380 DBD6 AFB0 D7D7 8783 89B0"
	$"DCC8 B088 B1B0 B0DB B082 8289 8488 8388"
	$"B1C8 B0D6 D089 A5D1 DEDE EAAC BDB8 ACFC"
	$"F4CA D1D1 BFF3 F4CA B8B8 5ECA F4FC D3B8"
	$"BD9D CAF4 F4DA DAAA F6EA E5BD B8B5 FBF4"
	$"CAC1 C6B8 BDE5 E5E3 BDC1 C6DF E3D1 A594"
	$"E3EA EAB5 F2E1 CAA3 A3A5 D6F6 AAB3 DAAD"
	$"E9EA F3DB B5D1 FBEC E7BC B8A4 FBE5 BFCA"
	$"EFF6 AAB7 BCCA F4E8 D1B3 DACA CAFB D1B0"
	$"B0C5 C1BD B8B3 DAE1 CAE5 0161 7FC6 6794"
	$"7EE3 DAAD 9379 737D CFDF AAA8 A8AC E1D1"
	$"AA7B 7BAA D1D4 7E73 79A9 C3D7 D7A7 7CA8"
	$"A8D2 D775 7B45 D3D1 A978 417A 75D7 D77B"
	$"7579 78E3 D4A8 7875 A5C3 D2A7 ACD6 AA3E"
	$"3E78 CFD4 A877 777E C1D7 E1A7 A77E C1E1"
	$"D775 7B77 D4D2 ABAA D6CF 7E75 7BAA C3AD"
	$"78A7 A7AA C3D4 A87C 7640 7875 7B75 A7D7"
	$"AAAB C869 9C87 E4DC B59B 8983 8801 D7E5"
	$"FDB0 79E4 D7B0 8888 B0D7 DC87 8389 AFC8"
	$"DBDB B188 B0B0 D6DB 8388 55DB D7AF 8958"
	$"8783 DBDB 8883 8A89 E4D6 B081 83B1 C8D6"
	$"B1B6 DCB0 5959 81D6 DBB0 8181 87C8 DBE4"
	$"B1B1 87C8 E4DB 8388 80DB D6AF B0DC D787"
	$"8389 B0C8 B581 B1B1 B0C8 DBB0 8882 588A"
	$"8388 81B1 DCB0 AFD0 72BF AAEC E4D8 BFBD"
	$"B8AC F8FC CAD1 D1C0 F3EF CABD BD5E CAEF"
	$"FCAC B8BD C9E1 ECEC DAB3 D1D1 E5EA B8BD"
	$"87FC EFC9 C699 BCB8 EAEA BDB8 C7C6 ECDE"
	$"D1A5 B8E3 D7E5 DBE0 F4CA A3A3 A5F5 FBD1"
	$"AEAE ACEA EAF3 DBDB AAE8 F4EC B8BD A4FB"
	$"E5BF CAF4 F6AA B7BC CAE1 D6A5 DADA CAE1"
	$"FBD1 B5B0 99C6 B8BD ADDA F5CA BF01 627F"
	$"C475 95AA D7E0 CF7D 767C 7ADF D6AA A7A7"
	$"AAD6 D6AA 7575 81D2 C178 7BA0 A7AC E3D4"
	$"A776 76A7 D7D2 4772 78CF D6AA 757B 754A"
	$"D4D4 A67B 7893 D9D4 7A79 75A7 D7D2 7FCF"
	$"C3AA 3E3E 4AD3 D1AA 7872 7CA7 D7E1 7E93"
	$"A9D4 D9E3 A77C 7ECF D6AA A8D4 CF7E 7B75"
	$"AAD7 CF77 A57B A8A8 D4C6 7973 7B75 7B75"
	$"7BA5 C3D6 D2C8 799B B0DB E5D7 8782 8781"
	$"7FE5 DCB0 B1B1 B0DC DCB0 8383 86D6 C881"
	$"88AC B1B6 E4D6 B182 82B1 DBD6 5D84 81D7"
	$"DCB0 8388 835B D6D5 B288 819B DAD5 8A89"
	$"81B1 DBD6 88D7 C8AF 5959 5BDA D7B0 8984"
	$"88B1 DBE4 879B B1DB DBE5 B188 87D7 DCB0"
	$"B0DB D787 8883 B0DC D780 B188 B0B0 D6C7"
	$"8983 8883 8883 88B1 C8DC D6D0 82B6 CAEA"
	$"F3F6 AAAC B29D FCF4 CAD1 D1CA F4F4 CAB8"
	$"B85E A2EF E8A5 BDDE DADF ECDE DAAE B0DB"
	$"EAE5 9EC1 A5F6 F4CA B8BD B894 DEDD E4BD"
	$"A5BE ECE7 BEBD AFDB EAE5 ABF6 E2CA A3A3"
	$"94FC EFCA C6C1 B5DB EAF3 AABE D2FB E3ED"
	$"DAB3 AAF6 F4CA D1FB F6AA BDB8 CAF5 F5A3"
	$"E3BD D1D1 E5D7 BDB8 BDB8 BDB8 BDE3 E1F4"
	$"E501 622C C47B 7AAA E0D7 A777 A776 7FDF"
	$"D6D1 A7A8 AADF E0AA 7B44 ABC4 D47E 754A"
	$"76A7 D9D4 7B76 7CA7 D7D2 7772 7ED4 D1AA"
	$"7BFE 754F D4D9 A543 787E D5D9 A473 7CA7"
	$"D2D7 78A8 D6AA 3E3E 7BCD D180 4178 76A7"
	$"D2D7 A8A8 7EC1 E3E3 A7A7 78D4 D1AA 7ECF"
	$"D07F 757B AAD1 A87E 7BA5 A8A8 D9AC 7973"
	$"7B75 4475 7BA5 D6AA ABC7 7F81 B0E5 DBB1"
	$"82B0 8286 21E5 DCD7 B1B1 B0E5 E5B0 8856"
	$"AFC8 DB87 835B 82B1 DBD6 8782 88B1 DBD6"
	$"8884 87DB D7B0 88FE 835A D6DB B155 8187"
	$"D6DA B283 88B1 D6DB 81B0 DBAF 5959 88D5"
	$"D787 5889 82B1 D6DB B0B0 87C8 E4E4 B1B1"
	$"81DB D7B0 87D7 D788 8388 B0D7 B087 88B1"
	$"B0B0 DBAE 8983 8883 5683 88B1 DCB0 AFCF"
	$"889D CAF3 EAD1 A5D8 ACA1 FCF4 EFD1 D2CA"
	$"FCFD CABD 8F16 CAE1 FBAA B894 AEDA E3DE"
	$"B3AE B5DB EAE5 C5C1 AAFB EFCA BDFE B844"
	$"DEE3 E38F A5AA E8EC E3B8 B5DB E5EA A5D1"
	$"F4CA A3A3 BDFB EFA2 99C6 B0DB E5EA D1D1"
	$"AAE8 ECEC DADA A5FB EFCA AAF6 F7AB B8BD"
	$"CAEF D1AA BDE3 D1D1 EABF BDB8 BDB8 8FB8"
	$"BDE3 F4CA BF01 627B F1D6 D4D9 E4E4 A77C"
	$"7B7B AADF E1D2 AAA9 ACD7 E3D4 787D C6D9"
	$"C07C 7676 78A4 D4D9 7278 757B D2D7 C8AE"
	$"D9F0 EFAB 7E78 7777 D7D2 A776 7878 D4D9"
	$"D281 7BD2 D7D2 7EA8 C4D2 4545 ABD7 D478"
	$"7B75 757B E3D9 ABD2 D7EF F0D9 C6AD ABE1"
	$"D5A8 78D4 D7AB 7778 D6D1 D7C4 D4E3 D2D7"
	$"E1AB A77B 7278 7B75 7CA7 ABC4 D4F1 D6D6"
	$"DBE4 E4B1 FE88 00B0 7FE5 E4D6 B0AF B0DB"
	$"E4D6 8186 C8DB C988 8282 88B2 D6DB 8489"
	$"8388 D6DB C8AF DBF2 F1AF 8781 8A8A DBD6"
	$"B182 8A8A D6DB D685 81D7 DBD6 87B0 C7D6"
	$"5555 AFDB DB81 8883 8388 E4DB AFD6 DBF1"
	$"F1DA C7AF AFE4 DCB0 81DB DBAF 8282 DCD7"
	$"DBC8 D6E4 D6DB E4AF B086 8489 8883 88B1"
	$"AFC7 DBF1 D6DE E3E4 E4DB B5BD BDCA FCF3"
	$"E5CA C9C0 EAEC DEA5 A95E D0E3 F2B5 B1B1"
	$"BCE3 DEE3 C1C6 B8BD E5EA D0B8 E3F9 FEC1"
	$"AAA5 C8C8 EAE5 DBB0 C8C8 DCE1 E597 93E7"
	$"EAE5 AAD1 D7E5 8F8F BFEA FBA5 BDB8 B8BD"
	$"ECE3 C1E7 EAFE FAE3 D7BF C1F4 FCD1 A5FB"
	$"EABF A5A6 F4EF ECD9 DEEC E7EC F3BF DCB5"
	$"C1C6 BDB8 B3DA BFD7 FB01 627F F1E4 E3F0"
	$"F1F1 A7A7 74A6 AAD6 D7D7 D6DF E1E1 F0D9"
	$"D4DE F0F0 7C76 7C76 7379 D4D4 4771 7B75"
	$"D8EF F1E3 F0F0 D7E1 CFA8 3F71 D2D8 7C76"
	$"7278 E3F0 EFE1 D7EE EFD8 CFD4 ABD7 A6A6"
	$"D2D3 A878 757B 7BA5 E3F0 D2D7 D2D7 F0FD"
	$"F0D9 D7E1 CF7E 78A8 C4D2 A7A7 D7D6 D2D8"
	$"D4D9 D7E1 EFD7 A776 7841 757B 76A6 D2AB"
	$"A8F1 E4E4 F2F1 F1B1 B182 B2B0 7FDC DBDB"
	$"DCE5 E4E4 F2DB DBE3 F2F2 8882 8782 8389"
	$"D6D6 5D83 8883 DCF1 F1E3 F2F1 DBE4 D7B0"
	$"5884 D6DC 8882 848A E4F2 F1E4 DCF2 F1DC"
	$"D7DB AFDB B0B0 D6D7 B081 8388 88B1 E4F2"
	$"D6DB D6DB F1FD F1DB DBE4 D787 81B0 C7D6"
	$"B1B1 DCDC D6DC D6DB DBE4 F1DB B082 8958"
	$"8388 82B0 D6AF B0F1 E4EC F9F1 F1DB DBB7"
	$"E4CA F4EA EAF4 FCF3 F3F9 E3FB FCFF F95C"
	$"B5B0 B6B1 B8BD DEDE 9EC0 BDB8 EBFE F9EC"
	$"F9F9 ECF4 F6D1 9BC2 E5EB B5B0 C2C8 EAF8"
	$"FEF3 ECFE FEEB F6FB BFEA E3E3 E5E6 D1A5"
	$"B8BD BDE3 ECF9 E7EC E5EA FAFF FEEA ECF4"
	$"F6AA A5D1 D7E5 D1D1 F5F4 E7EC DEE3 ECF4"
	$"FEEA DCB1 C699 B8BD AED9 E5BF D101 6113"
	$"E4F1 F0F0 EFD7 AAA9 A8A8 AADF E1D2 EFD7"
	$"EFD7 D7EE FEEF 08D7 7278 7247 76A7 D4D4"
	$"FE76 59A7 D2D7 F0F0 EFE1 D7D2 D7D7 A878"
	$"D3CE A57B 7CA7 D2D7 F0F0 EFEF D2D7 D2AB"
	$"76A7 D4CF D4A8 7279 7940 7AC3 EFE1 D7D2"
	$"D9E3 D7EF F0F0 D7D3 A57B 7278 A9D4 B0DF"
	$"E2D9 D2AB D7D2 E1D7 F0E3 CF7E 7676 7A75"
	$"7BA5 A9D5 C6E4 F1F2 F2F1 DBB0 AFFE B007"
	$"E5E4 D6F1 DBF1 DBDC FEF2 09F1 DB84 8984"
	$"5D82 B1DB DBFE 8267 B1D6 DBF2 F2F1 E4DB"
	$"D6DB DBB0 81DB D7B1 8888 B1D6 DBF2 F2F1"
	$"F2D6 DAD6 AF82 B1DB D7DB B284 8A89 5680"
	$"C8F1 E4DB D6DB E5DB F1F2 F2DA D7B1 8884"
	$"89B1 DBB5 E5E4 DBD6 AFDB D6E4 DBF2 E4D7"
	$"8782 8287 8388 B1B0 DCC7 E4F1 F9F9 FEEA"
	$"C8C7 D1D1 CAFC F3E5 FEEA FEEA ECFE F9F9"
	$"5EFE ECC1 C6C1 9EAE DAFB FBAC ACB0 DBE5"
	$"EAF9 F9FE F3EA E5EA EAD1 A5FC FBE3 BDB3"
	$"DAEF F4F9 F9FE FEE5 E9E7 C1AE DAFB F6FC"
	$"DBC4 CAC4 969B E0FE F3EC E7E3 EDEC FEF9"
	$"F9EB E8E3 BDC1 C6D2 FBCF FCF3 EAE7 C1EA"
	$"E5F4 ECF9 ECF6 AAAE AEBC B8BD E3CA F4D7"
	$"0160 39C7 D6E3 D9D7 E1D6 C3A8 A8AA AAAB"
	$"D7D7 E0D7 D2D2 D7D3 D8D7 D278 4172 7876"
	$"7C78 7876 7B7C D4D2 D7D4 D9D7 D7C4 D7D2"
	$"C4D4 A745 7B75 4476 A6AB D7D4 D9FE D73F"
	$"C4D8 D246 7678 7E7C 7678 4073 79AA D6D7"
	$"D7C4 D7D4 C6D7 E1D9 E2EF AB7B A5A3 4778"
	$"78AA D0D9 C6D7 D2D7 D2D7 E1E3 D9D4 A87B"
	$"767B 7675 7BA9 D0AD C7D6 E4DB DBE4 DBC8"
	$"FEB0 1BB0 AFDB DBE3 DBD6 D7DC D6DB DBD6"
	$"8958 8489 8288 8181 8287 88DB D6DB D6FE"
	$"DB0E C7DB D6C7 DBAF 5588 8356 82B0 AFDB"
	$"D6FD DB0D C7DC D654 8281 8788 8289 5884"
	$"89B0 FEDB 3CC8 DBD6 C8DB E4DB E3F1 AF88"
	$"B1B2 5D81 81B0 D6DB C7DB D6DB D6DB E4E4"
	$"DBDB B087 8288 8383 88B0 D7AF C7D6 ECE3"
	$"EAF3 F2E0 D1D1 CACA BFEA EAF2 EAE5 E7EC"
	$"DEE3 5EEC E7C6 99C1 C6AE B3A5 A5AC B1B5"
	$"FCE5 EADE E3EA EAD7 EAE5 D7FB D087 B5B8"
	$"8FAE D9CA F4DE E3EC ECEA D7EC E785 AEA5"
	$"AAB3 AEC9 9DC0 C4C8 F2EA EAD9 ECDE D0EC"
	$"F4E3 EBFE C1BD E3EB 9EA5 A5CA EEEA D7EC"
	$"E7EA E5EC F4EC E3FB D1B3 AEBD B9B8 BDCA"
	$"EFBF 0161 FF99 4CD2 D7E1 E0E3 D9C3 AAD2"
	$"AAD1 D2E1 E1E0 D7D2 D2D6 C3D2 B176 7B7B"
	$"7678 407C 7647 72D4 D5D7 C4D4 A7A8 A9AA"
	$"D1B0 D6D2 AB7C 7678 7279 79DE CFD4 C1D2"
	$"C4D1 D6C4 B13F 787C 7678 787B 757B 75AA"
	$"D1C4 D7CF FEA8 2DAA D6E1 D7E1 D7A8 A876"
	$"A772 78C4 D7D2 D7C1 AFA5 7AD1 D6D7 E1E3"
	$"E37B 7447 7278 72A8 ADC2 9A9A D6DB E4E3"
	$"E4DB C8B0 D702 B0D7 D7FE E43D DCD6 D6DC"
	$"C8D6 B583 8888 838A 5888 825D 84D6 D7DA"
	$"C7DB B1B0 B1B0 D7B5 DCD6 AF88 8289 8489"
	$"89E3 D7DB C8D6 C8D7 DCC8 B557 8988 8281"
	$"8188 8388 83B0 D7C8 DBD7 FDB0 15DC E4DB"
	$"E4DB B0B0 82B1 8489 C8DB D6DB C9B7 B187"
	$"D7DC DBFE E41E 8982 5D84 8984 B0B5 C8A3"
	$"A3E7 ECF3 F2EC E3E1 CAF0 CAEF F0F3 F3FB"
	$"F3E5 E5F4 E15E E7C6 B9BD BDB9 C699 BDB8"
	$"9EC1 DEDF E9D7 FCDB D1D1 CAEF CFF4 E7C1"
	$"B3AE C6C1 C4C4 FCF8 FBE8 E7D9 EFF4 D9C6"
	$"98C6 B5B0 A5A5 BDB8 BDB8 CAEF D9EC F6D1"
	$"DADA CAF4 F3EA F4EC D1D1 B0DB C1C6 D9EC"
	$"E5EA E8D6 E3BC EFF4 EAF3 ECEC BFB9 9EC1"
	$"C6C1 D1D6 E901 627F 4878 7CE1 D7D7 E3F1"
	$"D6AA B0C3 B0AA ABAB AAAA 82D2 D6D6 D2D2"
	$"7B75 4475 7278 767C 7278 D9C6 D7D2 A77C"
	$"7878 80C3 D1D1 D7D2 A776 4772 7279 7E7E"
	$"787E ABD7 AAD6 D2C4 7772 A8A7 A9A8 A57B"
	$"7BA5 D6D6 C4D7 A87E 777D 79C3 D7E1 D7D2"
	$"A8A7 A77B 7878 D7C4 D7C4 D578 757B 81DF"
	$"E1D7 D9E3 A57B 7278 7247 A8C1 AF4A 7A80"
	$"E4DB DBE4 F3DC B0B5 7FC8 B5B0 AFAF B0B0"
	$"86D6 DCDC D6D6 8883 5683 848A 8288 8489"
	$"DAC8 DBD6 B188 8181 87C8 D7D7 DBD6 B182"
	$"5D84 8389 8787 8187 AFDA B0DC D6C8 8884"
	$"B2B1 B1B0 B188 88B1 DCDC C8DB B087 8187"
	$"80C8 DBE4 DBD6 B0AF B187 8989 DBC8 DBC7"
	$"DC81 8388 88E5 E4DB DBE4 B189 8489 845D"
	$"B0C8 B555 8393 F4EA EAEC FAF4 CACF E1CF"
	$"CABF BFC8 C898 E5F4 F4FF E75C BDB8 8FB8"
	$"C1C6 B8BD C1C6 E2D0 EAE5 DBB5 A4A4 A2E1"
	$"EFEF ECE7 DAAE 9EC1 BFC4 ACAC A5AA C1EB"
	$"CAF4 E7D9 C5C1 DCDB D2D1 E3BD BDE3 F4F4"
	$"D9EC D1AA AEB3 9CE1 EAF3 ECE7 D1D0 DBB4"
	$"C6C6 ECD9 EAD7 FAA4 B8BD A3FC F3EA E3EC"
	$"E4BF C1C6 C19E D1E8 D601 5D34 A899 96AB"
	$"E3F1 D9E3 D7AC CFA7 A8A8 A7A7 A57B AAD6"
	$"D4D4 D7D7 A37E A87E 81A5 7C7C AAC3 D7D7"
	$"D2D7 A777 7872 7878 D7C4 D7D2 A77C 7278"
	$"7CFE 7609 7B75 7CCE D7D2 D7D7 C3AA FDA8"
	$"39AA C3C3 D2D9 D4D6 D1A7 7647 7278 78D4"
	$"D4E1 D7D1 80A8 A7AE D4D2 D7D2 D7A8 A881"
	$"A6A8 C1D8 E1E3 E3DF 80A8 787B 75AB D1C1"
	$"AA9A 9AAF E4F3 DBE4 DBB0 D702 B1B0 B0FE"
	$"B12F 88B0 DCD6 D6DA DBAB 87B0 8787 AA88"
	$"88B0 C8DA DBD6 DBB1 8389 8489 89DB C7DB"
	$"D6B0 8784 8A88 8382 8288 8388 D7DB D6DB"
	$"DBC8 FBB0 21C8 C7D6 DBD6 DCD7 B182 5D84"
	$"8A8A D6D6 E4DB D787 B0AF AFD6 D6DB D6DB"
	$"B0B0 86AA B0C8 DBFE E413 E587 B081 8883"
	$"B1D7 C9B2 A3AD C1EC FAE3 ECEA C0F6 FED1"
	$"FFDB 05E3 BDCA F4DE DE2B EBEC CCAA D1AA"
	$"A1C3 B5B5 CAE1 EBEC E5EA DBB1 C6C1 C9C9"
	$"EAD7 ECE7 D8B2 C2C8 B3AE B0B0 BDB8 B5FB"
	$"EAE5 ECEC E1CA FDD1 22CA E1D6 E5E3 DEF4"
	$"EFDB B09E C1C8 C8DE DEF4 ECEF A2D1 D0B8"
	$"DEE7 ECE5 EAD1 D1A2 C4D1 E8E3 FEEC 08FC"
	$"A2D1 A5BD B8CA EFE8 0162 7FA7 AED2 ABE3"
	$"D9E3 F0E1 C3AC A7A8 A87C A77B A5D1 D6E3"
	$"D9E1 E1A8 A8C1 A8D2 AAA6 C0AA D6E1 E1D7"
	$"E17C 7672 4772 78D3 D8C4 D7A8 7678 4176"
	$"767D 757B 757C D4D2 D7E1 E1D6 AACF ADC1"
	$"ADC3 B0AB D7E3 E3D6 D676 7C72 7872 78D5"
	$"D9D7 E1D1 AAA8 A8D5 F0D7 EFD7 E0A8 A8C4"
	$"ABA8 ADEF EFF0 D9DF AAA8 A875 44A9 AAAE"
	$"A9AF D6AF E4DB E4F2 E4C7 B54D B1B0 B088"
	$"B188 B1D7 DCE4 DBE4 E4B0 B0C8 B0D7 B0B0"
	$"C9B0 DCE4 E4DB E488 8284 5D84 89D7 DCC8"
	$"DBB1 828A 5883 8389 8188 8388 DBD6 DBE4"
	$"E4DC B0D6 B5C8 B5C8 B5AF DBE4 E4DB DC82"
	$"8884 8984 8AD7 DBDB E4D7 FEB0 0BD7 F2DB"
	$"F1DB E5B0 B0C8 AFB0 B5FE F201 DBE5 FEB0"
	$"0F83 56AF B0B6 B1B8 E7C1 ECE3 ECF9 F3D6"
	$"D6FE D107 B5DB BDE3 EFF4 ECE3 FFF4 FFD1"
	$"06E8 D1EE C8DB F2CA FEF4 19EA F3B5 B0C1"
	$"9EC4 C9E6 EBD9 ECD9 ACC8 9BAE AEB6 AFBD"
	$"B8B5 FCE5 EAFE F426 CAF5 D6E8 D6E1 CFBF"
	$"EAEC ECF3 F4B0 B5C1 C6C2 C8DF E3EC F4EF"
	$"CAD1 D1DF F9EC FEEA F3D1 D1E1 CAD1 D6FE"
	$"F909 E3FC CAD1 D1B8 8FC9 CAD6 0162 28A9"
	$"B8C4 D7F2 F2D7 EFD6 D0AA AAA7 A7A8 A8A5"
	$"75D4 D9EF E1EF D7D1 B0C1 ADA8 D4A9 D0B1"
	$"EFF0 D9F0 E37B 757B FE75 53B0 D1D7 C5D4"
	$"7C75 7578 4772 7875 7B7C E1D7 E1F0 D9AA"
	$"C3AD C0A9 D0AA D2D5 F1E1 EFE3 E37B 757B"
	$"7541 78C4 D7C5 D7D6 A978 A8D9 E3F0 E3F0"
	$"E3A8 D4A8 A8AB C4E1 D7F0 F0EF ABA7 A83F"
	$"417E C1A8 A9B8 C8DB F1F1 DBF1 DCD7 B01D"
	$"B0B1 B1B0 B0B1 83D6 DBF2 E4F1 DBD7 B5C9"
	$"B6B0 DBB0 D7B5 F1F2 DBF2 E488 8388 FE83"
	$"5EB5 D7DB C9DB 8882 828A 5D84 8A83 8880"
	$"E4DB E5F2 DAAF C8B5 C8B0 D7B0 D7D5 F1E4"
	$"F1E3 E388 8288 8358 8AC7 DBC9 DBDC AF81"
	$"B0DB E4F2 E4F2 E4B0 DBB0 B0AF C8E4 DBF1"
	$"F2F1 AFAF B057 5887 C9B0 A9B8 D9EC F1F1"
	$"ECFE F4EF CACA DADA D1D1 E4BA DEE3 F9EC"
	$"5EFE ECEF CFEB D9D1 FBCA EFC6 FEF9 E3F9"
	$"ECBD B8BD B8B7 B7CF EFEC DAFC B5B0 B0C8"
	$"9FC2 C8B8 BD93 F4EA F4F9 E2CA E2D8 E9CA"
	$"EFCA F0DE F9F4 FEEC ECB5 B0BD B89B C8D7"
	$"EADA ECF4 C9A5 D1E3 ECF9 ECF9 ECD1 FBD1"
	$"D1CA E1F3 EAF9 F9FE BFD0 D198 99AA E8D1"
	$"015E 61B8 A9C4 D7E4 F1EF D7EC AEC3 AA7C"
	$"A778 A87B 7AD4 E3D9 EFD7 EFA9 C3AD C1A8"
	$"A7C1 AED2 E1E2 F1E3 D97B 757B 7549 75AA"
	$"D1D7 D2CE 7C75 7B72 7277 4175 7BAB E1EF"
	$"D7F0 F0AA AAC1 ADC2 AEC3 B0AE F1D7 D7F1"
	$"DBBF 7B75 7B72 78AB D2D7 D2D1 AAA9 A8D4"
	$"F0F0 D9F0 D9FD A8FF AB09 D7EF D9E3 EFD7"
	$"A8A8 7241 FEA8 0AB8 A9C8 DBE3 F0F1 DBF0"
	$"B5C8 56B0 88B1 81B0 8988 D6E4 DCF2 DBF1"
	$"AFC8 B6C9 B0AF C8B5 D6E4 E3F3 E4DB 8883"
	$"8883 5A83 B0D7 DBD6 D788 8288 8484 8958"
	$"8388 AFE4 F1DB F2F2 AFAF C8B5 C9B5 C8B5"
	$"AFF1 DBDB F1DB C988 8388 848A AFD6 DBD6"
	$"D7B0 B1B0 D6F2 F2DB F2DB FDB0 FFAF 09DB"
	$"F1DB E4F1 DAB0 B084 58FE B015 B8A9 D9EC"
	$"E4F1 FEEC FECF E1CA B3DA A5D1 BFBE DEEC"
	$"E4F9 4BEC FEC9 E1D9 EBD1 D0E1 CFE7 F4EB"
	$"FAEC E3BD B8BD B892 B7CA EFEC E7FB B5B0"
	$"B5C2 C2C7 9BB8 BDC1 F4FE EAF9 F9CA CAEA"
	$"D8E2 CFE1 CFB8 F9EC ECF9 E4F2 B5B8 BDC2"
	$"C8BF E5EC E7EF CAD2 D1DE F9F9 E3F9 E3FD"
	$"D1FF CA09 EAFE E3EC FEE9 D1D1 C199 FED1"
	$"0159 04A7 ACC6 D9F1 FEF0 59E3 D47C A7A8"
	$"A8A5 A5A8 76B1 EFE3 F0E3 E3D4 A8C3 B0C4"
	$"D7AA ABD2 D7EF D7F1 E472 7844 7B73 79A8"
	$"D5D1 AFD1 AA73 4675 7B75 7C75 7BC4 D7E4"
	$"F1D9 F0AA D6AA C3A9 C1A8 A8D2 D7F0 F0E3"
	$"E3AF C37B 747B 75A8 ADD5 D4D6 AAA7 A7D7"
	$"D7F1 F1D9 E3FB A8FF E1FF F00D D7C4 A8A8"
	$"4141 7CA6 A9AA AFC7 DAF3 FEF2 02E5 D688"
	$"56B1 B0B0 B1B1 B282 B5F1 E4F2 E4E4 DBB0"
	$"C8B5 C8DB B0B1 D6DB F1DB F1E4 848A 5688"
	$"8389 B0DC D6B5 D7B0 855D 8388 8389 8388"
	$"C8DB E4F1 DAF1 B0DC B0C8 B0C8 B0B0 D6DB"
	$"F2F2 E4E4 B5C8 8882 8883 B0B5 D6D5 DCB0"
	$"B1B1 DBDB F1F1 DBE5 FBB0 FFE4 FFF2 0DDA"
	$"C7B0 B058 5888 B1B1 B2B7 D0E3 FAFE F90D"
	$"EDDE B5DB D1D1 E4E4 DBAE C6FE ECF9 FFEC"
	$"49FB D1E1 CFD9 ECCA CAE5 EAFE ECF1 E4C1"
	$"C68F BDB8 BDD1 FAF0 CFEF CAC2 9EB8 BDB8"
	$"BEB8 BDD9 ECE4 F1E3 FACA F4CA E1CA E1D1"
	$"D1E5 EAF9 F9EC ECCF E2BD B7BD B8D3 D8DF"
	$"DFF4 CADB DBEA EAF0 F0E3 EDFB D1FF F3FF"
	$"F908 E9D7 D1D1 9999 B3DA D201 5961 A7B6"
	$"C6E2 D9F0 F0D9 F0AE A7A7 7EA3 7B7B 767C"
	$"D2EF D9E3 DAF0 A8A8 D1AA C5AB AAC4 D7EF"
	$"D8E1 E4E4 7878 7575 7973 A8D5 C3D6 D180"
	$"7872 757B 4475 7BA5 D2D7 F1E4 E2F0 AAC3"
	$"B0C3 AEC1 AEC1 D7EF E3D9 F0D9 AAC3 A57B"
	$"757A A9CF D4D9 D1AA 7CA8 E1EF F1F1 E3D4"
	$"FBA8 FFD7 15F0 D9E1 D7A8 A872 41A6 A6A8"
	$"AAB9 C7E4 DBF2 F2DB F2AF B117 B187 AB89"
	$"8982 88D6 F1DB E4DC F2B0 B0D7 B0C9 AFB0"
	$"C9DB F1DC FEE4 FF8A FF83 3289 83B0 DCC8"
	$"DBD7 878A 8483 8856 8388 B1D6 DBF1 E4E4"
	$"F1B0 C8B5 C8B5 C8B6 C8DB F1E4 DBF2 DBAF"
	$"C8B1 8883 87B1 D7D5 DAD7 B088 B2E4 FEF1"
	$"01E4 D6FB B0FF DB20 F2DB E4DB B0B0 8458"
	$"B1B1 B0B2 C1D0 ECE3 F9F9 E3F9 B8DB DBAA"
	$"CCBF BFAE B3E7 FEE3 EC4B E4F9 D1D1 EFCA"
	$"DAC1 CAE2 EAFE ECF4 E4E4 C6C6 B8B8 BDB8"
	$"D1FA E2F4 EFA2 C6C1 B8BD 8FB8 BDE3 E7EC"
	$"F1E4 ECFA CAE1 CFE1 CFE1 D7E8 EAFE ECE3"
	$"F9E3 CAE2 E3BD B8BC D4F8 DFE3 EFCA B5DC"
	$"F3FE F0F0 ECDE FBD1 FFEA 0AF9 E3F3 EAD1"
	$"D1C1 99DA DAD1 0162 35A8 AEC7 D9F0 F0F1"
	$"F1D6 C3A8 7DA7 A77B 7575 7BD4 D9F0 F0EF"
	$"D7C2 B0AA D1AD C1B0 C3D7 E1F0 F0D9 D876"
	$"7678 737B 74AA D1D7 D2D4 A875 7B45 76FE"
	$"7846 A8D7 E1E3 D9F1 DAC3 AFC3 AACF ADC4"
	$"ABD7 E1E2 F0E3 D9C4 B0C1 A875 75AA D6D7"
	$"C4D4 A7A8 A8D7 EFF0 D9EF D7A8 A8A7 A7A8"
	$"A8D4 F0D7 EFF0 D4A8 A845 3E7F AAA8 AAAF"
	$"C9DA F2F2 F1F1 DCC8 B07F 87B0 B088 8383"
	$"89D6 DBF2 F1F2 DBC7 B5B0 D7B5 C8B5 C8DB"
	$"E4F2 F2DC DB82 8289 8588 82B0 D7DA D6DB"
	$"B083 8855 828A 8A81 B0DB E4E4 DBF1 DAC8"
	$"B5C8 B0D7 B5C7 AEDB E4E3 F2E4 DBC8 B5C8"
	$"B083 83B0 DCDB C8DB B1B0 B0DB F1F2 DBF1"
	$"DBB0 B0B1 B1B0 B0D6 F2DB F1F2 D6B0 B05E"
	$"5986 B0B0 B2B8 D0E2 F9F9 F1F1 F4E1 DBB5"
	$"D8D8 BDB8 BABF DEE3 F9F9 5EFE ECE0 CFCA"
	$"EFD6 E8CF E1EA F3F9 F9E9 E9B0 B0C6 C2BD"
	$"B7CA EFEB E7FB D1B8 BD8F B8C8 C8A5 D1EC"
	$"F4EC E3F9 E3E2 CFE1 CAF6 D6D7 BFEA F3EB"
	$"F9EC E3E1 CFE8 D1B8 B8CA F4EC D9FC DAD1"
	$"D1EA FEF9 E3FE EAD1 D1DA DAD1 D1DE F9EC"
	$"FEF9 DED1 D1A8 A3AC D3D1 0162 64B7 C6C6"
	$"D4D9 F0F1 F1D6 AAA8 A876 7C75 7C75 7BC6"
	$"F0D9 E3D7 EFAA D1AA AAC1 ADC4 AAD2 D7E3"
	$"D9EF E17C 7678 4175 7BAA D6C4 D7C1 7D75"
	$"7B7C 7672 78A8 A8D2 D7F1 F0E3 F1AB C3B0"
	$"C4A8 A8AB D2D2 D7F0 D9F0 E3AB C4AD A87B"
	$"7BAA D1D7 C4D4 7C78 A8E1 D7F1 F0D7 D2A9"
	$"A97C FEA8 17D9 E3EF D7F0 D9A8 A871 3EA4"
	$"AAA8 B9C8 C8D6 DBF2 F1F1 DCB0 B07F B182"
	$"8783 8983 89C8 F2DB E4DB F1B0 D7B0 B0C8"
	$"B5C9 B0D6 DBE4 DBF2 E488 8289 5883 88B0"
	$"DCC8 DBC8 8683 8888 8284 8AB0 B0D6 DBF3"
	$"F2E3 F1B0 C8B6 C9B0 B0AF D6D6 DBF2 DBF2"
	$"E4AF C8B5 B088 88B0 D7DB C8DB 8881 B0E4"
	$"DBF3 F2DB D6B1 B188 B2B0 B0DB E4F1 DAF2"
	$"DBB0 B085 59AA B0B0 C1D0 D0DE E3F9 F1F1"
	$"F4CA DBDC ACB2 B8BE BABF D0F9 E3EC 5EEC"
	$"FECA EFCA CAE8 D6E2 CAE5 EAEC E3FE F2B5"
	$"B0C6 99B8 BDCA F4D9 ECE8 A9B8 BDBD B8C2"
	$"C8D1 D1E7 ECFA F9EC F9CB E2D0 E2D1 D1BF"
	$"E5E5 EAF9 E3F9 ECCA E1D6 D1BD BDCA EFEC"
	$"D9FC B3A5 D1F3 EAFA F9EA E5D2 D2B3 DBD1"
	$"D1E3 ECFE EBF9 E3D1 D1CA A3CE D3D1 0160"
	$"FFC7 15AB D8F0 D9F0 F0EF AB7C 767B 757C"
	$"7674 7BA7 D4E3 E3E1 D7FD A763 A8CF A8A8"
	$"D7EF E3F0 E3E3 7C75 757B 7872 AAD6 C3D6"
	$"D2AB 4A75 7278 44A5 AAD6 AEF0 D9E3 D9F0"
	$"AFC2 7B7B 7872 7B7B D7EF D9E3 E1D7 D6AA"
	$"C3AA A777 A8D4 C4D7 C4AC 7BA6 D2EF D7E1"
	$"D7D2 7877 917B A8A8 D2D7 F1F2 D7D2 A8A8"
	$"4141 7CA7 A8C7 C7AF DCF2 DBF2 F1F1 AF88"
	$"0882 8883 8882 8288 B1DB FEE4 00DB FDB1"
	$"6EB0 D7B0 B0DB F1E4 F2E4 E489 8383 888A"
	$"84B0 DCC8 DCD6 AF5B 8384 8956 B1B0 DCAF"
	$"F2DB E4DB F2B5 C888 8889 8488 88DB F1DB"
	$"E4E4 DBDC B0C8 B0B1 83B0 DBC8 DBC8 AF88"
	$"B1D6 F1DB E4DB D68A 899D 88B0 B0D6 DBF1"
	$"F2DA D6B0 B058 5888 B1B0 C7C7 C1EC F9E3"
	$"F9F9 FEBF B5B0 BDB8 B5B0 B7BD DBFC ECEC"
	$"5EF4 ECDA DADB DBD1 F6D1 D1EA FEEC F9EC"
	$"ECBE B8B8 BDC8 C2CA F4E1 F4E5 BF93 B7C1"
	$"C691 E4CA F4B8 F9E3 ECE3 F9D8 EABD BDC6"
	$"C1BD BDEA FEE3 ECF3 EAF4 CAE1 CADB B1D1"
	$"FBD9 ECD6 BEB5 DBE5 FEEC F4EA E5C8 C7D1"
	$"BDD1 D1E5 EAF1 F2E9 E5D1 D199 99B5 DBD1"
	$"0162 FFC7 7DC4 D2E3 F0F0 D9E1 AB77 7675"
	$"7B76 767B 767C D4D4 D9D7 D276 7D76 7CAD"
	$"A8D4 A8D2 D7F0 D9E3 D97B 757B 7541 78AA"
	$"D2D1 B0D3 AB75 7545 727B A5C3 A9D4 F0E3"
	$"F0F1 F0AA AA75 7541 7875 74AC E1F0 F0D7"
	$"E1AA C3B0 D1A7 7CA8 D4C4 D7D3 AC75 75AB"
	$"D7D2 D7E1 AB72 4144 44A8 A9D7 EFF1 E3EF"
	$"D7A8 A872 41A7 A7A8 C7C7 C8D6 E4F2 F2DB"
	$"E4AF 837F 8283 8882 8288 8388 DBD6 DBDB"
	$"D682 8982 88B5 B0DB B0D6 DBF2 DBE4 DB88"
	$"8388 8358 8AB0 D7D7 B5D7 AE83 835C 8489"
	$"B1C8 AFD6 F2E4 F2F3 F2B0 B083 8358 8983"
	$"82B0 E4F2 F2DB E4B0 C8B5 D7B1 88B0 DBC8"
	$"DBD6 AF82 82AF DBD6 DBE4 AE84 5856 56B0"
	$"B1DB F1F1 E3F1 DBB0 B084 58B1 B1B0 C7C7"
	$"D9E7 ECF9 F9E3 F3BF B1B0 B8BD B0B0 BDB9"
	$"B5FC DEE3 5EEC E7AE B4B0 B5D6 D1FB D1E5"
	$"EAF9 E3EC E3BD B8BD B89B C8CA F0EF CFE6"
	$"BFB7 B79D C1BF E4E1 C9DE F9EC F9FA F9D3"
	$"D3B8 B899 C6B8 B7C0 F3F9 F9EA F3CA E1CF"
	$"EFDB B5D1 FBD9 ECE4 BEB0 B0BF EAE7 ECF3"
	$"BFC2 9B8F 8FD1 D1EA FEF1 E3FE EAD1 D1C1"
	$"99DB DBD1 0161 FEC6 71D9 D7EF D7EF E1AB"
	$"7978 7543 7A4A 757A 7AD1 D7C4 D2D7 7872"
	$"7872 C5AB A8C1 D8E1 E3F0 F0D9 757B 4178"
	$"7475 A9D6 D7D2 D47E 757B 777D 7AAA B0C3"
	$"B0EE D9F0 D9E3 A57B 757B 7475 7878 A8D4"
	$"E3D9 F0E3 A8A8 C3AA D4A8 AAD1 D7C4 D47C"
	$"757B ABD2 D7D2 D6AA 7841 3D3E A8A8 C4D7"
	$"E3D9 EFD2 D2AA 453E 7CA7 A8FE C807 DBDA"
	$"F1DB F2E4 AF8B 698A 8355 895D 8387 81D7"
	$"DBC7 D6DB 8984 8A84 C8AF B0C8 DCE4 E4F2"
	$"F2DB 8389 5889 8283 AFDC DBD6 DB87 8388"
	$"8187 81B0 B5C8 B5F1 DBF2 DAE4 B188 8389"
	$"8283 8989 B0DB E4DB F2E4 B0B0 C8B0 DCB0"
	$"B0D7 DBC8 DB88 8388 AFD6 DBD6 DCB0 8A58"
	$"5859 B0B0 C7DB E4DB F1D6 D7B0 5E59 88B1"
	$"B0FE D012 E3EB FEED FEF3 BFC8 C8B8 8FC6"
	$"9FB8 BC9D EFEA D75E E7EC C6C1 C8C2 D8BF"
	$"D3EA EBF3 ECF9 F9E3 B7BC 99C6 B7B8 C9F4"
	$"ECE7 FBAA B8BD AEB3 9DCA CFE1 CFFE E3F9"
	$"E2EC E3BD BABF B7B8 C9C9 D1FB ECE3 F9EC"
	$"D1D1 E1CA FCD3 CAEF ECD9 FCB5 B8BD CAEF"
	$"ECE7 F4CA C89B A3A3 D1D1 D7EA ECE3 FEE5"
	$"F0CA A8A3 B5DB D101 607F C6AE C6D4 D7EF"
	$"E1D7 EFAB 7278 7B75 7475 7B75 80D1 D2D7"
	$"ABD2 4178 4178 ACD2 ADA8 D2D7 F0D9 E2E3"
	$"7C75 7972 7B7B AAD1 D2D7 C1A8 757B 7777"
	$"AAC3 AAD1 D1D6 F0E3 E3F0 7B75 7A76 7B44"
	$"7240 7EDF E3F0 D9E3 A8D4 AAAA A8A8 AAD6"
	$"C4D7 C07C 7B76 81D2 D7D2 D6C3 7872 3E3E"
	$"A8A8 D7E1 F0F0 D7D7 AAAA 713E A7A7 A8C8"
	$"AFC8 D6DB F1E4 DBF1 AF84 448A 8883 8384"
	$"8883 87D7 D6DB AFD6 5889 588A B0D6 B5B0"
	$"D6DB F2DB E3E4 8A83 8A84 8888 B0D7 D6DB"
	$"C8B0 8388 8181 B0C8 B0D7 D7DC F2E4 E4F2"
	$"8883 8884 8856 8458 87E4 E4F2 DBE4 B0DB"
	$"FCB0 35DC C8DB C988 8883 86D6 DAD6 DCC8"
	$"8A84 5959 B0B0 DBE4 F2F2 DBDB B0B0 8559"
	$"B1B1 B0D0 B8D0 DEEC FEF6 EDFE BFC2 C8BD"
	$"B8C1 C2BD B8A2 EFE5 EA57 C1E7 99C6 9BC8"
	$"C0E5 D8D3 E5EA F9E3 EBEC BDB7 C7C1 BDBD"
	$"CAEF E7EC E8D1 B8BD AEAE CAE1 CAEF EFF4"
	$"F9EC ECF9 BDB8 BEBA BD8F C49D AAFC ECF9"
	$"E3EC D1FB CACA D3D3 CAF4 D9EC F2B5 BDB9"
	$"A2EF EBE7 F4E1 C8C2 A3A3 D1D1 EAF3 F9F9"
	$"EAEA FECA 03A3 DBDB D101 62FF C672 C4D7"
	$"E3D9 F0F0 D7D2 7B75 4172 7878 7676 7CD4"
	$"D7D2 D7D2 7C76 7575 B0A9 C3C2 B1EF E3F0"
	$"D9E3 7B75 7247 7676 AAD1 B1D2 CF7E 4772"
	$"4772 ADC0 ADA8 D7E1 EFD8 F0D9 7278 754A"
	$"757B 7C76 7ECF D7E1 F0D9 AAAA CFAD C4AB"
	$"D2C4 D6D1 DE7D 754A 76D4 C5D7 C4D7 757B"
	$"3E3E A8A8 D2EF D9F0 EFAB CFA8 4141 78A8"
	$"A8FE C807 DBE4 DBF2 F2DB D688 7F83 5884"
	$"8A8A 8282 88DB DBD6 DBD6 8882 8383 B5AF"
	$"C8C7 B5F1 E4F2 DBE4 8883 845D 8282 B0D7"
	$"B5D6 D787 5D84 5D84 B6C9 B5B0 DBE5 F2DB"
	$"F2DB 848A 835B 8388 8882 87D7 DBE4 F2DB"
	$"B0B0 D7B5 C8AF D6C7 DCD7 E386 835B 83DC"
	$"C9DB C7DB 8388 5959 B0B0 D6F2 DBF2 F1AE"
	$"D7B0 5858 81B0 B0D0 D0D9 ECEC E3F9 F9EA"
	$"E5BD B899 C1C8 C8AE AEB5 FCEA E502 ECE7"
	$"BDFE B858 CFC9 E1E0 C6FE ECF9 E3EC BDB8"
	$"C19E B0B0 CAEF C6E7 F6AA 9EC1 9FC2 D6E8"
	$"D6D1 ECF5 FEE9 F9E3 C1C6 B894 B8BD B5B0"
	$"AAF6 ECF4 F9E3 CACA F6D6 D9C1 E5D7 F4EF"
	$"FCA9 B894 AEFC DAEC D7EA B8BD A3A3 D1D1"
	$"E7FE E3F9 FEBF F6D1 9999 A5D1 D101 6171"
	$"AEC6 ABD2 E3F0 D9E3 EFAB 7B75 7878 723F"
	$"777C 7CCE ABC3 D7D2 7C76 7C7B C3D1 AAB0"
	$"C4E1 F0D9 F0F1 7B75 7872 767C D7D6 D2D2"
	$"D478 7178 7278 A7A7 A8C1 ABE1 D8E1 F0E3"
	$"7840 7575 7B75 7676 7ED0 D7EF E2F0 AAD1"
	$"A8A9 C4AB D8D7 D6AA D478 7675 45A6 D2D7"
	$"D2D7 757B 3E3E A8A8 D7D7 F0F0 D7D2 ADA8"
	$"7241 FEA8 0AAF C8AF D6E4 F2DB E4F1 AF88"
	$"6683 8989 8457 8388 88D7 AFC7 DBD6 8882"
	$"8988 C8D7 B0B5 C8E4 F2DB F2F3 8883 8984"
	$"8288 DCDC D6D6 DB81 8389 848A B1B1 B0C8"
	$"AEE4 DBE4 F2E4 8A58 8383 8883 8282 87D7"
	$"DBF1 E3F2 B0D7 B0B1 C8AF DCDB DCB0 DB81"
	$"8383 55B1 D6DB D6DB 8388 5959 B0B0 DBDB"
	$"F2F2 DBD6 B5B0 8458 FEB0 15B8 D0C1 E7EC"
	$"F9E3 ECFE BFBD B8C6 C6C2 9AAF B3B5 FBBF"
	$"D61F ECE7 BDB8 BEBD E1EF CACF D9F4 F9E3"
	$"F9FA BDB8 C6C1 B0B5 F5F4 E7E7 FBA5 C0C6"
	$"C2C8 FED1 38E8 C0F4 E9F2 F9EC C699 B8B8"
	$"BDB8 B0B0 AAF7 ECFE EBF9 CAEF D1D2 D9C1"
	$"EBEA F4CA FBA5 B9B8 85DA E7EC E5EA B8BD"
	$"A3A3 D1D1 ECEC F9F9 EAE5 D6D1 C199 FED1"
	$"0162 67B8 C7D2 D7D9 F0E3 F0D6 C3A5 757C"
	$"457B 7578 7280 D1D6 D6C4 D744 7B71 41AA"
	$"AFC4 C4AE DDD9 F0E3 E3A7 7678 727B 75D2"
	$"D3D7 B0C0 7C76 7678 72C3 D6AA D6D2 D7F0"
	$"F0D7 E176 7C77 7175 4A78 737D A6F0 E3D7"
	$"EFD7 ABB0 D1AD D0D7 C4D4 D9A7 7C78 4143"
	$"A6D8 D2D7 C479 7378 41AA AAFE E314 DAE1"
	$"ABD1 AA45 3E7C A7A8 B8C7 D6DB DBF2 E4F1"
	$"DCC8 B17F 8388 5588 8389 8487 D7DC DCC8"
	$"DB56 8883 58B0 B5C8 C8B7 E4DB F2E4 E4B1"
	$"828A 8488 83D6 D7DC B5C9 8882 828A 84C8"
	$"DCB0 DCD6 DBF2 F2DB E482 888A 8583 5B88"
	$"8389 B0F2 E4DB F1DB AFB5 D6B5 D7DB C7D6"
	$"DBB1 888A 5856 B2DC D6DB C789 8389 58B0"
	$"B0E4 E4E3 DAE5 AFD7 B05E 5988 B1B0 B8C7"
	$"E8ED E3F9 ECF9 F4E1 E3B8 BD8F BDB8 C6C1"
	$"A2EF F4F4 51D9 EC8F BDC2 9BD1 D6D9 D9D7"
	$"FCE3 F9EC ECDB B0C6 C1BD B8E5 E6F5 CFF2"
	$"B5B0 B0C6 C1E1 F4CA F4E7 ECF9 F9EC F4AE"
	$"B3CF CAB8 94BC B8B4 D9F9 ECEA FEEC C1CD"
	$"EDD6 F7EA D7DE E3DA B3C8 9B97 EBEC E7EA"
	$"D7BD B8C6 99CA CAFE EC09 E3F4 BFEF CAA8"
	$"A3B5 DBD1 0162 7FA9 C7AB E1F0 E3D9 F0D6"
	$"ABA5 4A76 777B 7547 72AA D1D1 D6C4 D775"
	$"7578 78C2 AAB1 C4A7 D5E3 E3DA F0A7 7C40"
	$"7844 A5D7 ABD1 D1A7 467C 7678 78A9 AAC3"
	$"AAD7 E1D9 F0E1 D776 7677 4575 7573 7976"
	$"A7D9 E3EF D7D2 C4AA C3A8 D4E1 D7C6 D4A7"
	$"7772 4143 7AC4 D7D2 D7A4 7972 41AA C3D9"
	$"F0F1 F1D7 D2B0 C371 3EA7 A8A8 A9C7 B0E4"
	$"F2E5 DBF2 DCB1 B138 5B82 8388 835D 84B0"
	$"D7D7 DCC8 DB83 838A 8AC8 B0B5 C8B1 DDE4"
	$"E4DC F2B1 8858 8A56 B1DB AFD7 D7B1 5588"
	$"828A 8AAF B0C8 B0DB E4DB F2E4 DB82 828A"
	$"5EFE 8343 8982 B1DB E4F1 DBD6 C8B0 C8B0"
	$"DBE4 DBC8 D6B1 8384 5856 88C8 DBD6 DBB2"
	$"8984 58B0 C8DB F2F1 F1DB D6B5 C885 59B1"
	$"B2B0 A9C7 C3F6 F9ED E3F9 F4CA E394 B8B9"
	$"BDB8 9EC1 CAEF EFF4 2DD9 ECB8 B8C8 C8E9"
	$"D1C6 D9D1 FCEC ECE4 F9DB B599 C68F E3EA"
	$"BFEF EFDB 87B5 B0C6 C6C9 CAE1 CAEC F4E3"
	$"F9F4 ECAE AECF A8FE B821 BDAE DAE3 ECFE"
	$"EAE7 D9C8 E0D1 FBF3 EAD0 DEDA AFC2 9B97"
	$"C4D9 ECE5 EAE3 BDC1 99CA E1E3 FEF9 08EA"
	$"E5CF E1CA A3DB DCD1 0161 0FA9 C7E3 F1D9"
	$"E3EF D7C4 ABA7 767B 757D A7FD AB46 D6C3"
	$"D7D2 7EA9 80A9 D7D2 A8D4 ABC3 D7EF EFD7"
	$"D2AB 807A AAD6 D2D7 D2D6 7B75 7C44 76A7"
	$"D9D4 D6D6 D4F0 EFD8 E1D7 A87E A5AB A77D"
	$"7B43 757B E1D7 E4F1 D7D7 D0B0 D6E4 D7C4"
	$"D6D1 7841 78FE 3E21 AAD6 D2D7 E3B7 7C4B"
	$"C3D7 E1D7 E1D7 D1AA C3AA 4141 7EA8 A8A9"
	$"C7E4 F3DB E4F1 DBC7 AFB1 0582 8883 87B1"
	$"AEFE AF46 DCC8 DBD6 87B1 87AF DBD6 B0DB"
	$"B0C8 DBF1 F1DB D6AF 8781 B0DC D6DB D7DC"
	$"8883 8956 82B1 DBD6 DCDC D5F2 F2DB E4DB"
	$"B087 ABB0 B189 8855 8388 E4DB E4F1 DBDB"
	$"D6B5 D6E4 DBC7 DCD7 8958 8BFE 592C B0DC"
	$"D6DB E4B9 875A C7DB E4DB E4DB D7B0 C8B0"
	$"5858 87B0 B0A9 C7EC FAE3 ECFE ECD7 BFDB"
	$"B0BD B8AA D1BF BFCA CAF4 E144 ECE7 AAD2"
	$"A2C9 EAE5 D1FB BFD7 ECFE FEEA E7C1 A29D"
	$"CAF4 E7EC F0F4 BDB8 BE8F AEDA E3DE F4F4"
	$"DDF9 F9E3 F4EC D1AA BCC1 DBB6 BD8F B8BD"
	$"F3EA E4F1 ECEC EECF D6E4 EAD7 F4EF C699"
	$"D0FE A316 CAF4 E5EA ECC1 B68C D8EC F3EA"
	$"F4EC EFCA E1CA 9999 AAD1 D101 61FF E457"
	$"E3D9 F0F0 D7E1 ABD2 A77C 757B CFD4 C5D2"
	$"C4D7 C3B0 C4AB CFA8 C2C4 D2AB A8A8 ABC3"
	$"D7EF D7E1 D7D2 D1C3 D6C3 D7C4 D6A9 757B"
	$"7575 7CA7 E3E3 D6DF E3D9 E1E1 EFD7 C1D4"
	$"D2D7 CE46 7575 7B75 ABE1 F1E4 EFE1 D6DF"
	$"F1F1 D7D2 D7AA 7278 FE3E 173D AAD1 C5D7"
	$"D4D9 CEDD D7E1 D7E1 EFD7 C3B0 C3B0 7241"
	$"A3A8 A8FE E407 DBF2 F2DB E4AF D6B1 1288"
	$"8388 D7DC C8D6 C8DB C8B5 C8AF D7B0 C7C9"
	$"D6AF FEB0 38C8 DBF1 DBE4 DBD6 D7C8 DBC8"
	$"DBC8 DCAF 8388 8383 88B1 E4E4 DCE5 E4DB"
	$"E4E4 F2DB C8DB D7DC D755 8383 8883 AFE4"
	$"F1E4 F1E4 DCE5 F1F1 DBD6 DCB0 8489 FE59"
	$"2D58 B0D7 C8DB D6DB D6E2 DBE4 DBE4 F1DB"
	$"C8B5 C8B5 8458 ABB0 B0E4 E4EC E3F9 F9EC"
	$"F4BF E5DB B5B8 BDF6 FBD8 E5E1 F4E1 CF43"
	$"D9C1 F6D1 E0E2 E5BF D1D1 BFD7 ECFE EAF3"
	$"ECE7 EFE1 F3E1 ECD9 F4C9 B8BD B8B8 B3DA"
	$"ECEC F4FC ECE3 ECEC FEEC E8FB E7EC FB87"
	$"B8B8 BDB8 BFF3 F1E4 FEF4 F4FC F1F1 EAE5"
	$"F5CA C1C6 FDA3 16CA EFD8 EADE E3FB FCEC"
	$"F4EA F3FE ECE1 CFE1 CFC1 99CC D1D1 0162"
	$"7FD6 F1E3 F0E1 D7F0 ADD8 ABA7 7C7A AAF1"
	$"E3D6 B0D6 AAD6 E4FF F1D7 D8D2 B1D6 AAAA"
	$"D1F0 D9C4 D7F0 E3D7 D7F1 F1F0 D9D2 D7A7"
	$"7CAE D4D7 D7AB D2D7 EFE3 D9F1 F1FF F1D7"
	$"D2D7 D2D7 D7F0 F0AD 7E75 7B7E ECD7 D7F1"
	$"F1F0 E3D7 E1EF D8DF AAA7 7C72 413E 3E41"
	$"A9D7 D2D7 D2D9 D4E1 D7F1 E3D7 D2B0 D2B0"
	$"C440 3E7C A7A7 D6F1 E4F2 E4DB F1AF DCAF"
	$"B17F 8881 B0F3 E4DC B5DC B0D6 E4FF F1DB"
	$"DCD6 B5DB AFB0 D7F2 DBC8 DBF2 E4DB DBF1"
	$"F1F2 DBD6 DBB1 88AF D6DB DBAF D6DB F2E4"
	$"DBF1 F1FF F1DB D6DB D6DB DBF2 F2B5 8783"
	$"8887 EFDB DAF1 F1F2 E4DB E4F2 DBE5 B0B1"
	$"8884 5859 5958 B8DB D6DB D6DB D6E4 DBF3"
	$"E4DB D6B5 D6B5 C85A 5988 B1AF D6F1 ECF9"
	$"F3EA FEC1 F4CA DBB5 9DCA FAEC F4CF F4CA"
	$"D6E4 0EFF F1EA EBE7 C6F4 CACA EFF9 E3D9"
	$"ECF9 FEEC FFF1 4AF9 E3E5 EADB B5B8 DEEC"
	$"ECBF E5EC FEEC E3F1 F1FF F1EC E7EA E5EC"
	$"ECF9 F9D8 ACB8 BDAC FDEA E9F1 F1F9 ECEC"
	$"F4F9 E3FC CADB B5C1 99A3 A39B F2EA E5EC"
	$"E7EA E5F6 EDFA ECEC E7CF EFCF E1A4 A3B5"
	$"DBD0 0161 0FD6 E4D9 F0D7 E1D4 ADAB D2A8"
	$"A7AA FCF0 D9FE D16C D6F1 F1F2 F1FD EFD2"
	$"C4DF AAD6 D6FE F1AB D2D9 E3EF EFF1 F1F0"
	$"FED7 D27C C0F0 F0D2 EFEF D7EF D7F0 F0F1"
	$"F1FF F1EF D7C4 D7EF EFF0 D9EC EC7B 757E"
	$"CFEF FDF1 F2D9 F0EF D7EF E1AA AAA7 A778"
	$"413D 3E41 72D7 E1D7 D2D9 D4D7 E1D9 F0D2"
	$"ABD2 ABD2 AB77 3EA7 A7A8 D6E4 DBF2 DBE4"
	$"D5AF AFD6 B204 B1B0 FCF2 DAFE D712 DCF1"
	$"F1F2 F1FD F1D5 C8E4 AFDC DCFE F3AF D6DB"
	$"E4FD F15A F2FE DBD6 88C9 F2F2 D6F1 F1DB"
	$"F1DB F2F2 F1F1 FFF1 F1DB C7DB F1F1 F2DB"
	$"EFEF 8883 87D7 F1FD F1F2 DBF2 F1DB F2E4"
	$"B0B0 B1B1 8958 5859 5884 DBE4 DBD6 DBD6"
	$"DBE4 DBF2 D6AF D6AF D6AF 8A59 B1B1 B0D6"
	$"E4E3 F9EA F3E7 C1CA EFDC DBCA FFF9 E2FE"
	$"EF02 F4F1 F15E F2F1 FFFE E6D9 FCCA F4F4"
	$"FFFA C1E7 E3EC FEFE F1F1 F9FF EAE5 B5F2"
	$"F9F9 E7FE FEEA FEEC F9F9 F1F1 FFF1 FEEC"
	$"D7EA FEFE F9E3 FDFD BDB8 ACF8 FEFF F1F2"
	$"E3F9 FEEC F9EC CACA DBDB C699 A3A3 9BC2"
	$"EAF3 ECE7 EAE5 EDF6 E3F9 E7C1 EFCA EFCA"
	$"CFA3 DBDB D101 617F E3F0 E3E3 D6C3 B0D1"
	$"A8AD C3D7 EEEE FDD7 CED4 D1D6 F1F0 D3A5"
	$"EFFD D4AC EEAA F1FE F2FF A7A7 D1D6 F1FF"
	$"DED5 D7EF EFAB 7FEE D4A8 7BA5 F1F1 EFEF"
	$"D7EF FFFF FEF0 D7D2 D6E0 FEF0 CE76 D8E1"
	$"C17E 76D4 F1F1 FEFE E3F0 D9F0 EED7 A776"
	$"7CA7 A544 3F3F 7871 A7D4 C1D5 D1D6 EFE1"
	$"DFAA B0C3 D6AA D6AA 7141 7CA7 A8E4 F2E4"
	$"E4DC C8B5 D7B0 B5C8 28DC F2F2 FDDB D7DB"
	$"D7DC F3F2 DAB1 F1FD DBB6 F1B0 F3FE F2FF"
	$"B1B0 D7DC F1FF E5DC DBF1 F1AF 86F1 DBB0"
	$"89B1 FDF1 01DB F1FE FE4D F2DB D6DB E4FE"
	$"F2D7 82DC E4C8 8782 DBF1 F1FE FEE4 F2DB"
	$"F2EF DBB1 8288 B1B1 565A 5A8A 83B1 DBC9"
	$"DCD7 DCF1 E4E5 B0B5 C8DB B0DC B083 5888"
	$"B1B0 ECF9 ECEC F4E1 CFEF D1D6 E1F5 FEFE"
	$"FFEC FBFC EFF4 FAF9 23FC E3FE FFFC E0FE"
	$"CAFA FFF2 FFD1 D1EF F4F1 FFFC F4EC FEFE"
	$"C1A1 FEFB D1BF E4F1 F1FE FEEA FEFE FF37"
	$"F9EC E7F2 FBFF F9FB B0EC F4E8 AAB0 FCF9"
	$"F9FF FFEC F9E3 F9FD F4DB B0B3 DAE3 8FA3"
	$"A3C8 C2DA FCE8 FAEF F4FE F4FC CACF E1F3"
	$"CAF4 CAC0 99B5 DBD3 0162 7FAE C6D4 AEC3"
	$"B0C3 AAA8 C1AA AA80 EEE1 AB7C 4680 EDE3"
	$"AE44 44AB D7DE 46AA AAD4 D9F2 FFAD CFAA"
	$"D6F1 F1A9 A9AB EFEF ABAA EEDE 7F75 7BF1"
	$"F1D7 ABAC C4DA F2F0 D9C4 7C80 E0F0 AE7C"
	$"7CAB E1D4 777C A7C7 DAF0 D9D4 D9D4 D4D7"
	$"AA76 7C76 A77B 753F 3F41 417C 76A8 7EAA"
	$"AAD7 ABAA AAC3 D6AA D1C4 AA41 41A7 A7A8"
	$"AFC8 D6AF C8B5 C8B0 B0C8 B07F B085 F2E4"
	$"AF88 5587 F0E4 AF56 56AF DBE3 55B0 B0D6"
	$"DBF2 FFB6 D7B0 DCF1 F1B0 B0AF F1F1 AFB0"
	$"F1E3 8883 89F1 F1DB AFB0 C7DA F2F2 DBC8"
	$"8086 E4F2 AF88 88AF E4DB 8088 B1C7 DAF2"
	$"DBD5 DBD6 D6DB AE82 8882 B188 835A 5A58"
	$"5888 82B0 87B0 B0DB AFB0 B0C8 DCB0 D7C9"
	$"B058 58B1 B1B0 B8D0 DEB8 E1CF E1CA D1E8"
	$"CACA 98FE F4C1 B587 A2FE ECB8 FF8F 5CBF"
	$"EAFC 87CA CADE E3F2 FFD6 F6CA F4F1 F1CA"
	$"CAC1 FEFE C1CA FEFC ABBA BFF1 F1EC C1C0"
	$"D7E3 FAF9 E3D9 93A0 FBF9 B8B5 B5C1 F4FB"
	$"A4B5 DBD0 E3F9 E3DD E3DE DEF4 C9B0 B5AE"
	$"DABD B8A3 A39B 9BB3 AED1 AACA CAEC C1CA"
	$"CAE1 F4CA EFE2 CA99 99DB DBD3 0162 7F9A"
	$"B9AA C3AD C1AA D6AA D6A8 A87A EED6 AA76"
	$"7680 EED4 A83E 3EAA DFDE 7EA8 A8A9 D6F1"
	$"F1C2 AAAB EFF0 D972 727A D6EF D2D4 D9EE"
	$"7A78 73D9 F0F0 C6AC C0AE F0F0 D9A4 79AA"
	$"DFEF AB76 76AA EEE0 8080 C3AE CFF0 F0A8"
	$"A8AA D6E3 D978 727C A775 7B3E 403E 3E75"
	$"A57C 767A 75C3 ABA8 A8D6 AAD2 B1A9 AD75"
	$"447E B2A8 9AB9 B0C8 B4C8 B0DC B0DC B044"
	$"B080 F1DC B082 8286 F1DB B059 59B0 E5E3"
	$"87B0 B0AF DCF1 F1C7 B0AF F1F2 DB84 8481"
	$"DCF1 D6D6 DBF1 818A 85DB F2F2 C8B6 C9AF"
	$"F2F2 DBB2 89B0 E5F1 AF82 82B0 F1E5 8787"
	$"C8B6 D7F2 F2FE B037 DCE4 DB89 8488 B183"
	$"8859 5A59 5983 B188 8287 83C8 B1B0 B0DC"
	$"B0D6 B5B1 B583 5687 BAB0 9AB9 CAE1 D6E8"
	$"CAF4 CAF4 D1D1 9BFE F4CA AEAE A0FE FAD1"
	$"FFA3 5CCA FCFC AAD1 D1C9 F4F1 F1E0 CABF"
	$"FEF9 E3C1 C19D F4FE E5DE E3FE 9DC8 C3E3"
	$"F9F9 D0E0 F2B8 F9F9 E3E3 BDCA FCFE BFAE"
	$"AECA FEFD A2A2 E1D7 F6F9 F9D1 D1CA F4EA"
	$"E1C6 C1B3 DAB8 BDA3 A4A3 A3B8 E3B5 B0BC"
	$"B8E0 C9D1 D1F4 CAE7 C6D2 D6B8 8FAA DBD1"
	$"015E 5B99 B9AA AAC1 ADC3 AAC3 AAC1 7E80"
	$"EEEE AA7C 75AA E0DE 7E3E 4080 EED4 78A8"
	$"A8AA DFF1 F1AA D7AB EFF0 F078 477A EED7"
	$"D7C6 F0D6 7A41 78F1 F0D9 C6A7 ACC6 F0F1"
	$"D4A4 79A9 D6EF AB7C 76AB D6EE AA7A D2A8"
	$"D4E3 D9CF ADC3 D6E3 C672 4776 A77B 75FD"
	$"3EFF 7B0F A17C 757B D6AB A7A8 C3AA D2D2"
	$"CFA8 7644 FEA8 0A99 B9B0 B0C8 B5C8 B0C8"
	$"B0C8 1087 86F1 F1B0 8881 B0E4 E387 595A"
	$"87F1 DB81 FEB0 3CE5 F1F1 B0DC AFF1 F2F2"
	$"895D 81F1 DBDA C8F2 DC81 588A F3F2 DBC8"
	$"B1B6 C8F2 F3D6 B289 AFDC F1AE 8882 B1DC"
	$"F1B0 81D7 B0DB E4DB D7B5 C8DC E4C7 845D"
	$"82B1 8883 FD59 FF88 0FAC 8883 88DB B1AF"
	$"B0C8 B0D6 D6D7 B083 56FE B015 99B9 CACA"
	$"E8D6 E1CA E1CA E8AA A0FE FECA B3AD C8FB"
	$"FCAA 45A3 A4A2 FEFB A5D1 D1CA FCF1 F1CA"
	$"F5BF FEF9 F9C6 9E9D FEEA E9D0 F9F4 9D9B"
	$"C8FA F9E3 D0DB E0D0 F9FA DEE3 BDC9 F4FE"
	$"BFB3 AECA F4FE CA9D F0D1 FBEC E3F6 D6E1"
	$"F4EA CEC1 9EAE DABD B8FD A3FF BD0F D6B5"
	$"B8BD F2C9 D0D1 E1CA E7E7 F6D1 B98F FED1"
	$"0162 7F99 B7B5 B1D2 ABC0 ACC3 B0A8 A879"
	$"D6EF AB75 7AAB EFF1 C77B 75AA D6DF 7AA8"
	$"A8AA D6FF F1D2 ABD2 D7F1 F17A AA81 EFEF"
	$"C4D8 EFEC 7E7C 76F0 F0EE B0C4 D2D9 FEFF"
	$"F1EF ABAE F0EE AA41 78AB EFD6 AAA9 AEC6"
	$"D9F1 F1AB D2C4 D7DF B07C 7675 A5A1 7C3C"
	$"3C3E 3E76 A6A8 A8A7 A8D4 D4A8 A8AD CFB0"
	$"A9D4 A83E 3E7C A7A8 9AB9 B9B5 D6AF C9B6"
	$"C8B5 B010 B080 DCF1 AF83 87AF F2F1 C788"
	$"83B0 DCE5 81FE B041 DCFF F1D6 AFD6 DBF1"
	$"F181 B086 F1F1 C7DB F2EF 8788 82F2 F2F1"
	$"B5C7 D6DB FEFF F1F1 AFAF F2F1 B058 89AF"
	$"F1DC B0B0 B5C7 DBF1 F1AF D6C8 DBE5 B588"
	$"8283 B1AC 885A 5A59 5982 FEB0 26AF B0D5"
	$"D5B0 B0B5 D7B5 AFDB B059 5988 B1B0 A1C0"
	$"CAC6 E5BF F2E0 E1CF D1D1 9CF4 FEC1 B8BC"
	$"C1FE F1C7 5EBD B8CA F4FC 9DD1 D1CA F4FF"
	$"F1E7 C1E5 EAF1 F1A5 D199 FEFE D7E3 F9FD"
	$"AAB5 B0F9 F9FE CFD7 E5E3 FFFF F1FE C1B8"
	$"F9FE CA99 C6C1 FEF4 CACA CFCE E1F1 F1BF"
	$"E5D9 ECFC CFB5 B0B8 E3D6 B5A5 A5A3 A3AE"
	$"D9D1 D1D0 D1E7 E7D1 D1D6 F6CF C9FB D1A3"
	$"A3B5 DBD1 015F 61A8 AEC4 C4D7 C4AC A7C3"
	$"AAC1 7E7A EEEF AB7B A5AB EFF1 C77B A5AA"
	$"EEDF 7FA8 A8AA D1F1 FFD7 E1D7 EFF1 F1D6"
	$"AAD2 EFD7 D7C4 EFD4 7876 76D9 FED6 C3D7"
	$"D7E3 F0FF F1E1 D7E3 F0D6 AA78 72AB E1DF"
	$"AAC1 ECE3 F0F1 F1E1 D7D7 EFD6 D176 767B"
	$"7B7C 763C 3D3E 3E7C A7FD A8FF D917 ADCF"
	$"CFAD C3D1 A8A8 773E A7A7 A8AA AFC8 C8DB"
	$"C7B6 B1C8 B0C8 1087 81F1 F1AF 88B1 AFF2"
	$"F1C7 88B1 B0F1 E586 FEB0 05D7 F1FF DBE4"
	$"DBFE F12F DCB0 D6F1 DBDA C8F2 DB81 8282"
	$"DBFE DCC8 DBDB E4F2 FFF1 E4DB E4F2 DCB0"
	$"8984 AFE4 E5B0 C8F0 E4F2 F1F1 E4DB DBF1"
	$"DCD7 8282 FE88 0682 5A5B 5959 88B1 FDB0"
	$"FFDA 22B5 D7D7 B5C8 D7B0 B08A 59B1 B1B0"
	$"B1B6 D9D9 EAD7 E0DB E1CA E8AA 9DFE FEC1"
	$"BDE3 C1FE F1C7 4BBD E3CA FEFC A1D1 D1CA"
	$"EFF1 FFEC F4EA FEF1 F1FB D1E7 FEEA E9D0"
	$"F9FB A5B0 B0E3 FFF4 E1EA EAEC F9FF F1F4"
	$"ECEC F9F4 CAC6 C1C1 F4FC CAE1 FEEA F8F1"
	$"F1F3 EAEC FEF4 EFB0 B0BD BDB5 B0A5 A6A3"
	$"A3B3 DAFD D1FF EC0C D6F6 F6D6 E1EF D1D1"
	$"CFA3 DBDB D101 614C A8B7 C3B0 C3AA C3D6"
	$"AAD6 A9A8 7ED4 E0AB A8A8 AAEE EFB1 A77C"
	$"D4F0 EC48 A8A9 AAD6 F1F1 D7E1 D9F0 FFF1"
	$"C3D6 C6F0 EFAB AAEF EC7E 7878 F1F1 E0D7"
	$"E3F1 E4FF FFF1 D7E0 D5F0 F0AE 757B ABEF"
	$"D4A8 D6D6 E3FE F100 D7FD E12A D872 4779"
	$"A87B 753E 3E44 75A8 A8AA A9A8 A8D2 D2C6"
	$"DAAB D2A8 D5AA C341 4180 C2AB AAB9 C8B5"
	$"C8B0 C8DC B0DC B104 B087 DBE3 AFFE B0FF"
	$"F14A B4B1 88D6 F2EF 53B0 B1B0 DCF1 F1DB"
	$"E4DB F2FF F1C8 DCC8 F2F1 AFB0 F1EF 8789"
	$"89F1 F1E3 DBE4 F3E4 FFFF F1DC E5D7 F2F2"
	$"AF83 88AF F1DB B0DC DBE4 F3F1 F1DB E4E4"
	$"E5E4 DB84 5D82 B088 8359 5956 83FE B027"
	$"AFB0 B0D6 D6C8 DCAF D6B0 DCB0 C858 5887"
	$"C8AF B2C1 D9C6 E1CA E1F4 D1FB D4D3 AAFB"
	$"F4C1 D1D1 CAFE FEC5 5EDB B5DE F9FD 7BD1"
	$"D1CA F4F1 F1EC F4E3 F9FF F1E1 F4D0 F9FE"
	$"BFCA FEFD AAC6 C6F1 F1F4 ECEC FAE4 FFFF"
	$"F1EC F5DF F9F9 B8B8 BDC1 FEFB D1F4 F3EC"
	$"FAF1 F1EA F3F4 F5F2 E9C1 9EA6 D1BD B8A3"
	$"A38F B8D3 D3CA C9D1 D1E7 E7D0 E4C1 E7D1"
	$"FCCA E19B 9BAA E9BD 015E 049A ADC3 D2D6"
	$"FCAA 46C1 7E78 EDEF D8A8 A8AA D6FD E07C"
	$"A1D9 F0D4 78A8 A8AA DFF1 FFE1 D7E3 F0F1"
	$"F1D6 AAD9 FEE1 ABAA D6EC 7D72 78F1 F1D7"
	$"E0E3 D9F1 F1FF F1E1 D7D9 F0FE E37B 75D7"
	$"E1D4 A8C3 D6D9 F0F1 FFE1 FED7 25E1 AC78"
	$"727E A37B 763E 3E75 7BA8 A8C3 AAA8 A8D7"
	$"D7C6 D4D7 D2AD C1D6 A972 41AA AAD3 9BAE"
	$"C8D7 DCFC B000 C804 8781 F0F1 DCFE B008"
	$"DCFD E388 ACDB F2DB 81FE B043 E5F1 FFE4"
	$"DBE4 F2F1 F1DC B0DB FEE5 AFB0 DCEF 8684"
	$"89F1 F1DB E3E4 DBF1 F1FF F1E6 DCDB F2FE"
	$"E588 83DB E4DB B0C8 DCDB F2F1 FFE4 DADB"
	$"DBE4 AF89 8487 AB88 8359 5983 88B0 B0C8"
	$"FEB0 FFDB 11C8 D6DB D6B5 C8DC AF84 58B0"
	$"B0D6 A4B7 D9E7 F4FE CAFF D10B EAAC A5FE"
	$"FEEC D1D1 CAF4 FFF2 5EB5 D6E3 F9FB A5D1"
	$"D1CA FCF1 FFF4 ECEC F9F1 F1F4 CAE3 FFF4"
	$"BFCA F4FD A9C1 C6F1 F1EC F4EC E3F1 F1FF"
	$"F1F5 ECE3 F9FF EDBD B8EC F4FB D1E1 F4E3"
	$"F9F1 FFF3 E9EC ECF2 BEC6 C1AA CCBD B9A3"
	$"A3B8 BDD3 D3E1 CAD1 D1EC ECD0 DEEC E7D6"
	$"E8F4 C9C2 9BD1 D1E4 015F 0F9A B8C4 ABD1"
	$"AAD6 AAD1 B0C1 7E7D EBF0 AEFE A747 A8F1"
	$"F0C3 D7F0 F1C0 7CA8 A8AA D6F1 F1DF D6DF"
	$"D6F0 F0F1 E4F1 F1D4 7C76 D4F1 E3AE E3F0"
	$"F0E3 D9F0 F0D9 FEF0 D9D7 D2C4 D7F0 FFAB"
	$"ABE1 E1A7 7CD2 E1D8 EFF1 F1D9 E3E1 E1D7"
	$"E1A8 A9A7 7C77 FE3E 017B A5FD A81B A67C"
	$"D4D9 AAD6 D2D7 D2C4 A7A7 3E3E A8AD AB9A"
	$"B8C8 AFD7 B0DC B0D7 B5C9 FF87 0EF0 F2AF"
	$"B1B1 AFB0 F3F2 C7DB F2F3 C988 FEB0 31DC"
	$"F1F1 E5DC E4DB F2F2 F1E4 F1F1 DB88 82DB"
	$"F1E3 AFE3 F2F2 E4DB F2F2 DBFE F2DB DBD6"
	$"C7DB F0FE AFAF E4E4 B188 D6E4 DBF2 F1F1"
	$"DBFE E406 DBE4 B0B1 B188 8AFE 5901 88B1"
	$"FDB0 26B2 89D6 DBB0 DCD6 DBD6 C7B1 B159"
	$"59B0 B5AF 9AB8 D9C1 EFCA F4CA EFCF E8AA"
	$"AAFD F9B8 DADA D0D1 FAF9 44D8 ECF9 FAF2"
	$"B5D1 D1CA F4F1 F1FC F4FC F4F9 F9F1 E4F1"
	$"F1FC B5B0 FCF9 ECB8 ECF9 F9EC E3F9 F9E3"
	$"FFF9 E3EC E7D7 EAF9 FFBF BFF4 F4DB B5E7"
	$"F4E9 FEF1 F1E3 ECF4 F4EA F3D1 D2DA B3CF"
	$"FEA3 01BD E3FD D110 E4BE E5EA CAF4 E7EC"
	$"E5D7 DBDB A3A3 D1D6 BF01 5B27 9AB8 ABD2"
	$"D6AA AAC3 AAC3 A7A8 77D4 F0D5 A77C A878"
	$"AEE3 D7EF D9C6 7CA7 A8A8 AAD1 F1FF B0C2"
	$"AFC3 AEF0 FDF1 FF76 2B7C 76D5 DBF1 F1D4"
	$"D9E3 F0F0 D9E3 F0F0 E3AB D2D7 D2DA F1EF"
	$"EFD7 AC76 77AB D7C4 D8F1 F1E3 E3D7 D7C4"
	$"ABA8 A8A7 76FD 3E01 A57B FEA8 1C78 7B75"
	$"ADD5 D6D1 D7C4 D7AB ACA7 773E A8C1 C59A"
	$"B8AF D5DC B0B0 C8B0 C8B0 10B0 82DC F2D7"
	$"B188 B081 AFE4 DBF1 DBC8 88B1 FEB0 08D7"
	$"F1FF B5C7 B5C8 AFF2 FDF1 FF82 1488 82D5"
	$"DBF1 F1D6 DBE4 F2F2 DBE4 F2F1 E4AF D6DB"
	$"D6DA FEF1 13DB B082 83AF DBC8 DBF1 F1E4"
	$"E4DB DBC7 AFB0 B0B1 82FD 5901 B188 FEB0"
	$"2781 8883 AFD7 DCD7 DBC8 DBAF B6B1 8A59"
	$"B0C8 C89A B8C1 E6F4 CACA E1CA E1D0 D1A5"
	$"FBF9 DFDA B3D1 A5B8 EC11 ECFE E3D0 B5DB"
	$"D1D1 CAEF F1FF CFE0 CFE2 B8F9 FDF1 FFB0"
	$"21B5 B0DE E4F9 F9DE E3EC F9F9 E3EC F9F9"
	$"ECC1 E7EA E5E3 F9FE FEEC C2B0 B1C1 ECD6"
	$"E9F1 F1FD EC05 D7BF D1D1 DAAE FDA3 01E3"
	$"BDFE D111 A5BD B8BF E6F4 EFEC D9EA BFE0"
	$"DBCF A3D1 E8D8 0161 4E89 AEC5 B1C3 AAD5"
	$"A8AD A8A6 7B76 7CA7 A7A8 A873 7972 4177"
	$"77A6 A5A7 A6AA AAAB AAAD A8C3 AAC3 AAA7"
	$"ACD2 D7D7 AB7B 7B41 7876 7CA7 7C7C CED9"
	$"E2D7 E1D1 AAA7 A7C0 A8D6 D1DA D4AC A775"
	$"7B75 7B7C A6A8 A8C4 FED7 02D2 E1A6 FE7B"
	$"2776 443E 403E 77A1 7C9E 79A5 7B76 7BD2"
	$"ABC3 D6C4 D7AA D1C3 AA41 72AA AAAB 8AAF"
	$"C9B5 C8B0 DCB0 B5B0 B10F 8882 88B1 B1B0"
	$"B083 8984 588B 8BB2 B1B1 FEB0 2CB1 B0B5"
	$"B0C8 B0C8 B0B1 B6D6 DBDB AF88 8858 8A82"
	$"88B0 8787 D6DB E3DB E4D7 B0B1 B1C7 B0DC"
	$"D7DC D6B6 B183 8883 8888 FEB0 00C8 FEDB"
	$"02D6 E4B1 FE88 3283 5659 5A59 8AAC 88AC"
	$"89B1 8883 88D6 AFC8 DCC8 DBB0 D7C8 B058"
	$"84B0 B0B6 93B8 DAC6 E1CA FCD1 D6D1 DBB5"
	$"AEB3 DBDB D1D1 B8BD C199 FFD1 03E4 E3DB"
	$"DBFD CA54 D6D1 E1CA E0C8 DBE0 E5EA F4CA"
	$"BDBD 9BC8 AEB3 DCB6 B6FB E3EB EAF3 EFCA"
	$"DADA E8D1 F4EF E2DC E0DB B8BD B8BD B3D9"
	$"D1D1 D9EC EAEA E8F6 DBB5 BDBD B98F A3A4"
	$"A3CF D6B5 DDBD E3BD B9BD EFCA E1F4 D9EC"
	$"CAEF E1CA 99C1 CACA E801 602F 99B6 B5D2"
	$"B0C3 A8A8 C1A8 CE7B 76A7 A77C A8A8 7379"
	$"7841 3E3E 7B7B A77C D1AA AAC3 A8C1 A9AA"
	$"B0C3 7CCE ABD2 C4D7 7575 7278 FD76 2145"
	$"D3F0 E3EF D7AA D6A7 ACA8 7ED1 B0D5 D4CE"
	$"7C75 447B 7576 A7C1 ADC5 D7E1 E1D7 D7A6"
	$"A6FE 7500 44FE 3E0F 78A7 7C79 7975 7B7B"
	$"75B0 D3B0 D1D7 C4D6 FEAA 0F41 78AA C3A6"
	$"9AB8 B9D6 B5C8 B0B0 C8B0 D724 8882 B1B1"
	$"88B0 B083 8989 585A 5A88 88B1 88D7 B0B0"
	$"C8B0 C8AF B0B5 C888 D7AF D6C8 DB83 8384"
	$"8AFD 8221 54DA F2E4 F1DB B0DC B1B6 B087"
	$"D7B5 D7D6 D788 8356 8883 82B1 C8B5 C9DB"
	$"E4E4 DBDB B1B1 FE83 0056 FE59 0F8B B188"
	$"8989 8388 8883 B5D7 B5D7 DBC8 DCFE B01A"
	$"5889 B0C8 B2A3 C0CA E7CF E1D1 D1E8 D1FB"
	$"B5AE DADB B5D1 D1B8 BDC6 99FF A5FF BD3B"
	$"DBB5 EFCA CAE1 D1E8 C9CA CDE0 B5FB BFE5"
	$"E1F4 B8B8 C2C8 AEAE B1B1 87FC F9EC FEEA"
	$"CAF4 DADF D1AA EFCF DDDC FBB5 B88F BDB8"
	$"AEDA E8D6 DAEC F3F3 EDED DBDB FEB8 008F"
	$"FEA3 0FD0 DBB5 BDBD B8BD BDB8 CFF0 CFEF"
	$"ECD9 F4FE CA04 99C6 CAE1 E401 5D04 7CB6"
	$"AAAA CFFE A8FF AA19 A77C 757B A8A8 A7A7"
	$"7741 7575 3E3E A27B A2A7 ADA8 A7A7 AAAA"
	$"ADC1 FEA8 30C1 D4A8 D7AB 7247 7B75 4778"
	$"4178 7EEC E1D8 E3F0 A8A8 AAC3 A775 D7D3"
	$"CFD4 C17E 767C 757B 7CA7 AAAA ABE1 E1D7"
	$"D4E3 A87D 757B FD3E 1D46 A17D 92A8 A37B"
	$"7572 78AA AAC4 D2B0 C3D6 ABA7 A745 76A8"
	$"ADC4 80B9 B0B0 D7FC B000 B118 8883 88B0"
	$"B0B1 B189 5883 8359 59AD 87AB B1B5 B0B1"
	$"B1B0 B0B5 C8FE B012 C8DB B0DB AF84 5D88"
	$"835D 8958 8A87 EFE4 DCE4 F2FE B01A C8B1"
	$"81DB D7D7 DBC8 8782 8883 8888 B1B0 B0AF"
	$"E4E4 DBD6 E4B2 8983 88FD 5910 55AC 899C"
	$"B0AB 8883 8489 B0B0 C7D5 B5C8 DCFE B109"
	$"5582 B0B4 C787 C0CA CAF6 FED1 FFCA 0BDB"
	$"B5B8 BDD1 D1DA DAC7 9BB8 B8FF A30B D7B4"
	$"CCD1 D6D1 DBDB CACA D6E8 FED1 30E8 FBD1"
	$"ECC1 C19E BDB8 9EC6 9BC8 AAFD F6EE ECF9"
	$"D1D1 CAE1 DBAF EAE6 F6FB E8AA B8BD B8BD"
	$"B5DB D1D1 C1F4 F3EA DEEC DBB4 B8BD FDA3"
	$"1887 D6B6 C8D1 CCBD B8C1 C6CA CAD7 E4CF"
	$"E1F4 CADB DB8F B8D1 D6D7 0158 2187 B6AA"
	$"D1AD A7C1 ADC2 AAA7 767B A5A8 78A8 7C72"
	$"7875 4A3E 407C A77D A7C1 A8A7 ACAA C3FC"
	$"A830 ADC1 ADD2 C478 7275 7B72 7278 727F"
	$"DED7 EFE3 DAA8 A8AA AAA7 7CAB C4D4 ADCF"
	$"7E76 7C44 757C C0AA AAD2 D7D7 D2E3 D9A7"
	$"7675 7BFD 3E23 46A7 7CA7 7E78 7B75 7878"
	$"AAD1 ABD7 C3D6 D2AA A77C 7C76 A8C1 AB8B"
	$"B9B0 D7B5 AFC8 B5C7 B0B1 1682 88B1 B081"
	$"B288 848A 835B 595A 88B1 87B1 C8B0 B1B6"
	$"B0C8 FCB0 12B4 C8B5 D6C8 8984 8388 8484"
	$"8A84 88E3 DBF1 E4DC FDB0 19B1 88AF C7DB"
	$"B5D7 8782 8856 8388 C9B0 B0D6 DBDB D6E4"
	$"DBB1 8283 88FD 592E 55B1 88B1 8781 8883"
	$"8989 B0D7 AFDB C8DC D7B0 B188 8882 B0C8"
	$"AE92 C0CA EFD6 D0E8 D6E0 CADB B0BD E3D1"
	$"A5DB B3C2 C8B8 940B A3A4 B5DB AAD1 E8D1"
	$"DBE0 CAE1 FCD1 30D6 E8D6 E7D9 C6C1 B8BD"
	$"C1C1 C8C2 ABFC EDFE ECE4 D1D1 CACA DBB5"
	$"BFD7 FBD6 F6AA B8BD 8FB8 B5F2 D1D1 E7EC"
	$"EAE5 ECE3 DAAE B8BD FDA3 1887 DBB5 DBAA"
	$"A5BD B8C6 C6CA EFBF EAE1 F4F0 CADB B5BD"
	$"B8D1 E8BF 0151 049A A9B4 AAC1 FCA8 13A7"
	$"7C76 A8A7 A7A8 787B 757B 753D 3E75 A6A7"
	$"7BD1 AAFC A816 A7A8 A8AA C3D6 C3D5 A978"
	$"7278 4175 7B75 75AA DFE3 DAE1 D7FD A8FF"
	$"A701 AAD6 FED4 137E 7575 7B7B 76A7 A8A8"
	$"AAD6 D2D7 D7D2 A57B 7278 3DFE 3E1D 757B"
	$"A776 7B7B 7479 7575 C1AE C4B1 D0AA CFAD"
	$"A7A1 4178 AAAA AD9A A9BA B0C8 FCB0 00B1"
	$"1188 81B0 B1B1 B081 8883 8883 5859 82B1"
	$"B187 D6FB B000 AFFE B012 C8DC C8DC B089"
	$"848A 5883 8883 83B0 E5E3 DAE4 DBFD B0FF"
	$"B10B B0DC D6D6 DB87 8383 8888 82B1 FEB0"
	$"09DC D6DB DBD6 B188 848A 58FE 591D 8388"
	$"B182 8888 8489 8383 C8B6 C8B5 D6B0 D7B5"
	$"B1AC 5889 B0B0 B59A A9D3 CAE8 FCD1 02DB"
	$"B5AF FEDB 05D1 A5BD B8BD B8FF A305 B0DB"
	$"DBB4 EDC8 FCD1 16D0 D1D1 CAE1 F4E1 F4CA"
	$"C6C1 C89B B8BD B8B8 CAFC ECE3 F3EA FDD1"
	$"FFDB 17CA F4DE DEFB AAB8 B8BD BDB0 DBD1"
	$"D1CA F4E7 ECEC E7E3 BDC1 C6FD A318 B8BD"
	$"DBB0 BDBD B9BD B8B8 E8D7 D9C6 EECA F6D6"
	$"DBD6 99C6 CACA D601 4A06 9AA9 AAAA ADA8"
	$"A7FE A813 A776 7DA8 7CA7 A8A8 7544 757B"
	$"3E3E 7B75 A7A7 AAAA F9A8 1380 C3AA D6C1"
	$"D572 4772 7874 7B44 7BAA D6E3 E3D7 D2FC"
	$"A818 7CC3 D6C5 D9C1 A87B 4475 747C A7A8"
	$"A8AA DFD7 D2D2 D77B 7546 72FD 3E1F 757B"
	$"A77C A07B 7379 7B7B A8A8 D2D2 B0D1 ADC1"
	$"7C7C 7241 AAC3 C19A A9B0 B0B5 B0AF FEB0"
	$"00B1 1082 87B0 88B1 B0B0 8356 8388 5959"
	$"8882 B1B1 F7B0 1387 C8B0 DCC8 DC84 5D84"
	$"8A82 8856 88B0 DCE3 E3DB D6FD B00D B288"
	$"C8DC C7DB C8B0 8856 8382 88B1 FEB0 08E5"
	$"DBD6 D6DA 8883 5D84 FD59 1F83 88B1 88AC"
	$"8883 8988 88B0 B0D6 D6B5 D7B5 C888 8884"
	$"58B0 C8C8 9AA9 CACA D6D1 D0FE D10B DBB0"
	$"B5DB B5DB D1D1 B88F B8BD FFA3 05B5 B0DB"
	$"DBC8 C8F9 D113 A2E1 CAF4 E1F4 C19E C2C8"
	$"B7BD 8FBD CAF4 ECEC EAE5 FDD1 19DC B5E1"
	$"F4CF E3E8 D1BD 8FB8 B7B5 DBD1 D1CA FCEC"
	$"E7E7 EBBD B89E C1FD A306 B8BD DBB5 DEBD"
	$"B8FE BDFF D1FF E70A CFEF D6E8 B5B5 C199"
	$"CAE1 E801 5405 7EA8 B4AA C3AA FDA8 FF78"
	$"0E75 A5A3 A8A6 7C75 7B7B 753E 3E75 A67E"
	$"FEA8 FFA7 01A8 A7FD A813 A7AC D3AC D1AB"
	$"7C76 7575 4772 7C76 80D1 DFD6 E3D4 FDA8"
	$"FFA7 17AD D4B0 D1CF 7E7B 757B 7CA7 A7A8"
	$"A8A9 D1D9 D4D7 D3A7 7676 7BFD 3E1D 76A7"
	$"76A7 7C7C 7177 927D A8A7 A9AD D2AB C1A8"
	$"A17C 7972 A8AD AC80 AABA B0C8 FCB0 008A"
	$"0F8A 83B1 ABB0 B088 8388 8883 5959 83B2"
	$"87FE B0FF B101 B0AF FCB0 12B6 D6AF D7B1"
	$"8882 8383 5D84 8882 87D7 E5DC E4D6 FDB0"
	$"FFB1 17AF D6B5 D7D7 8788 8388 89B1 B1B0"
	$"B0AF D7DB D6DB D7B1 8283 88FD 591E 82B0"
	$"82B0 8787 848A 9C87 B0AF B1B5 D6AF C8B0"
	$"AC88 8983 B0B5 B089 B2D3 CAE1 CAFD D1FF"
	$"C809 BAE4 CCD1 E3BD B8BD BDB8 FFA3 02B7"
	$"E2AA FED1 FFDB 01D1 D0FD D113 DCE1 E4BE"
	$"EFCA B3AE B8B8 9EC1 B5B0 A2EF FCF4 ECDE"
	$"FDD1 FFDB 17BF E5CF EFF6 AABD B8BD BEDB"
	$"DBD1 D1C9 EFE3 DEEC E8DA AEB9 BDFD A318"
	$"ACD8 B1DC B6B6 C2C8 C8B5 D1D0 D2D6 E7C1"
	$"E8D1 D6B5 C4BF D3D8 C001 5001 A8A9 FDAA"
	$"FDA8 1078 727B 7BA8 7EA6 7C7C 7575 7B3E"
	$"3E7B 7BA3 FEA8 04A7 7CA8 A8A7 FEA8 137C"
	$"CFC4 D8AA D776 767B 7B72 7876 76AA D1D6"
	$"D6E2 D9FD A819 A77C ADD4 D6C3 D4A8 757B"
	$"7575 7CA6 A8A8 AAD6 D4D4 D7D2 7C76 7B75"
	$"FD3E 0977 7CA7 7CA1 7677 7677 7DFE A80D"
	$"CFAB D2AD A87C 7641 79A8 C1C4 AAAB F9B0"
	$"008A 0F84 8989 B087 B088 8983 8388 5959"
	$"8989 ABFE B004 B188 B0B0 AFFE B013 87D7"
	$"C8DB B0DC 8282 8888 8489 8282 B0D7 DCDC"
	$"E3DB FDB0 0CB1 88AF D6DC C8DB B083 8883"
	$"8388 FDB0 08DC D6D6 DBD6 8882 8883 FD59"
	$"0982 87B0 87AB 828A 8982 87FE B00D D7AE"
	$"D6B5 B088 8257 89B0 C8C7 B2B3 FDCA FDD1"
	$"0BC8 C2BF BFD1 AAE3 BDBE B8B8 BDFF A3FF"
	$"BC00 CCFE D104 DBB5 D1D1 D0FE D113 B6FB"
	$"D6E9 CAF5 AEAE BDBD C1C6 B0B0 CAEF F4F4"
	$"EBE3 FDD1 19DB B5BF E5F4 E1FA D1B8 BDB8"
	$"B8B5 DBD1 D1CA F4DE DEEC E7B3 AEBD B8FD"
	$"A309 ADB2 DCB6 D7B1 C8C7 B0B5 FED1 0BF6"
	$"C0E7 D6D1 B5B0 97C4 D3EA D701 5F02 A99A"
	$"A5FE AA37 7CA8 79A4 7675 7EB2 A7A7 A894"
	$"7247 7575 3E3E 76A7 A57B C3AA 7DA2 A87D"
	$"A77C A67C A3AD D1B0 D4C5 7847 7272 7677"
	$"4878 A8D4 D4E3 D8C4 79A4 7CA7 FEAA 16D6"
	$"D2D7 C17E 7544 7C75 7CA7 A77C ABE1 D6D6"
	$"C4D7 7278 447B FD3E 1B75 7B93 7E7B 7B74"
	$"757B 75A8 A8D1 B0D1 B0C1 A874 7B75 76A8"
	$"ADA8 A99A ABFE B004 88B2 89B2 8232 8187"
	$"BAB1 B1B0 9C84 5D83 8359 5982 B1B1 88C8"
	$"B087 ABB0 87B1 88B1 88AB B5D7 B5D5 C789"
	$"5D84 8482 835E 89B0 DBD6 E4DB C889 B288"
	$"B1FE B016 DCD6 DBC9 8783 5689 8388 B1B1"
	$"88AF E4DC DCC8 DB84 8956 89FD 5925 8388"
	$"9B87 8888 8283 8883 B0B0 D7B5 D7B5 C8B0"
	$"8288 8383 B0B5 B0A8 98C4 CAD1 D1B5 DCBD"
	$"E3B0 AFAA FEDB 05D1 BFC1 9EB8 B8FF A325"
	$"AEDA E3BD E1CA B5D6 DBB5 DBB5 DAB3 CED8"
	$"EFCF E7D9 C69E C1C1 AEAF 9FC6 D1FB DEEC"
	$"E9D6 BDE3 B5DB FECA 0DF4 E7EC E8AA B88F"
	$"BEB8 B5DB DAB3 C1FE F405 D9EC C1C6 8FBC"
	$"FDA3 18B8 BDBE AABD BDB7 B8BD B8D1 D1EF"
	$"CFEF CFE8 D1B7 BDB8 B9D1 D6D3 015D 01A9"
	$"9AFD AA51 7CA1 A579 767C 79A8 7CA7 A87E"
	$"7872 7B7B 3E3E 7CA7 7BA5 AAA9 7CA8 7DA2"
	$"7CA1 A6A6 7EC1 D6C3 B2D4 7272 7847 7C76"
	$"7272 7ECF D9E3 D8D3 A479 A27B 95AA AAD1"
	$"D7C4 D5A8 7B75 767B A776 A7A7 ABD2 C3D6"
	$"ABD2 4772 7575 FD3E 1A75 7BA8 A890 7A7B"
	$"7B76 7BA8 A8AA C3AA C3A8 7E7B 757B 44A9"
	$"C2A8 A99A FDB0 0488 ACB3 8982 4C88 82B0"
	$"88B1 B087 8984 8888 5959 88B1 88B1 B0AF"
	$"86B0 87AB 88AC B1B1 87C8 DCC8 B4D5 8484"
	$"895D 8882 8484 87D7 DBE4 DBD6 B289 AD87"
	$"9BB0 B0D7 DBC8 DCB0 8883 8388 B182 B1B1"
	$"AFD6 C8DC AFD5 5D84 8383 FD59 0983 88B0"
	$"B09D 8788 8883 88FE B021 C8B0 C8B0 8788"
	$"8388 56B1 C9B0 A898 CACA D1D1 B5D6 E4BD"
	$"B0B5 A6D1 B5DB D1AA C6C1 BDBD FFA3 3FB3"
	$"DABD E3CA C9B4 DBB5 D6B5 D6DA DAAC EAF4"
	$"E1C6 E7C1 C1C6 9EB3 AEC1 C1AA F6E3 ECE9"
	$"E4E3 BDD7 B4B6 CACA EFEC D9FA D1BD B8B9"
	$"BDDB B0DA DAC1 E7E1 F4C1 E69E C1B7 B7FD"
	$"A318 B8BD D1D1 D0BC BDBD B9BD D1D1 CAE1"
	$"CAE1 D1AA BDB8 BD8F D2E9 D301 6158 B57C"
	$"96AB A877 A57A A775 7B75 7CA7 B17C A8A8"
	$"757B 4475 7241 7C76 A7A6 A776 A878 A5A5"
	$"7CA7 7C76 A8C1 AAD6 C3D6 4178 7575 7247"
	$"7C76 A8D5 D4D9 D2D7 76A7 A57B A57B C5D8"
	$"ABD7 D180 757B 7B75 7BA5 747B ABD7 B1D2"
	$"CFD4 7676 7B7B 3DFE 3E09 75A5 7B7B 7CA1"
	$"7C92 7B75 FEA7 16A8 D4A8 A77C 767C 4172"
	$"A8D5 A8B9 809A AFB0 80B1 87B1 8188 4D83"
	$"88B1 BB88 B0B0 8388 5683 8458 8882 B1B0"
	$"B182 B081 B0B1 88B1 8883 B0C8 B0DC C8DC"
	$"588A 8383 845D 8882 B0DC D6DB D6DA 82B1"
	$"B188 B188 C8DC B0DC D787 8388 8883 88B1"
	$"8288 AFDB B5D6 D7DB 8282 8888 58FE 5901"
	$"83B1 FE88 29AC 889C 8883 B1B1 AFB0 DBB0"
	$"B188 8288 5884 B0DC B0CA 93AD C1D1 A4E3"
	$"BCDA ADBD B8B3 DAE4 B5D1 D1B8 BD8F B841"
	$"C29B B3AE DBDB DAAE D1A5 E2E3 B5DB B3AE"
	$"D1E8 CAF4 E1F4 9BC8 B8B8 C19E B5B0 D1FC"
	$"DEE3 E5E9 B0DB E3BD E3BD D8EB C1EC EFA2"
	$"B8BD BDB8 BDE3 B7BD C8F2 C6E7 F6FB AEAE"
	$"BDBD FDA3 18B8 E3BD BDB5 D6B5 C8BD B8DB"
	$"DBD2 D3FB D1DA B3B0 B599 C1D1 FAD1 0160"
	$"67B5 7CA6 ABA8 A87B A575 7C75 7B76 A77C"
	$"A7A8 787C 7575 7B41 4176 A77B A7A7 7C78"
	$"A87B 7B77 A776 A67E A8D6 C3B0 C378 724A"
	$"7578 7276 767E C1D4 D4D7 C47C A77B 75A5"
	$"7BC4 D7D2 D2D1 7A7B 7544 A57C A57C A5AB"
	$"C4D2 D2AD A876 7C75 753E 3D3D 3E45 7B7B"
	$"A07C A676 7C75 7B7C A7FE A801 A9A8 FE76"
	$"0141 78FE A80A B980 AAAF B0B0 88B1 8188"
	$"8336 8882 B188 B1B0 8189 8383 8858 5882"
	$"B187 B1B1 8881 B088 8883 B183 B187 B0DC"
	$"C8B5 C88A 845B 8389 8482 8287 C8D6 D6DB"
	$"C788 B188 83B1 88C7 DBFE D722 8188 8356"
	$"B189 B189 B1AF C7D5 D6B5 B082 8883 8359"
	$"5858 5957 8888 AC88 B082 8883 8888 B1FE"
	$"B001 B1B2 FE82 0158 89FE B015 CA93 BCC1"
	$"D1D1 BDE3 ADB3 B8BD AEDA B5DB D1A5 BEB8"
	$"B8BD FF9B 3FAE DAB4 DBDA B3A5 D1BD BDB1"
	$"DBAE DAAA D1F4 E1CF E1C8 C294 B8C6 C1B0"
	$"B0AA E8DE DEEA D7B5 DBBD B8E3 BDD7 EAE7"
	$"E7EF 9DBD B88F E3BE E3BE E3C8 DFE6 E7D6"
	$"D1AE B3B8 B8FD A315 90BD BDDE B5DB B0B5"
	$"B8BD B5DB D3D3 D1D2 DBAE B0B0 99C6 FED1"
	$"0161 7FA9 897A AAA7 757C 767B 757B 757A"
	$"A4A8 A8A7 7C75 7B7B 7541 41A7 7BAA A5A6"
	$"7C78 7893 A87B 7AA5 7BA5 D6AA D1D2 D875"
	$"7B75 7B75 7B47 787E CFB0 D6D2 C47C 7679"
	$"A475 7BD4 D9AA D6AB 7B76 7D78 72A8 787B"
	$"907F D4A8 D5C4 AB79 4178 413E 3E3C 3B76"
	$"A7A3 7EA8 A87C 7C7D 92A7 7CA8 A8C3 AAA5"
	$"7B41 7841 71AA AAD0 A989 80AF B181 8882"
	$"8883 887F 838A B2B0 B0B1 8883 8888 8358"
	$"58B1 87AF AAB1 888A 8A9B B088 87B1 89AB"
	$"DCB0 D7D6 DC83 8883 8883 885D 8987 D7B5"
	$"DCD6 C788 8289 B283 88D6 DBB0 DCB7 8982"
	$"898A 84B0 8188 9D88 DBB0 DCC8 AF89 578A"
	$"5859 595A 5982 B1AB 87B0 B088 8887 9CB1"
	$"88B0 B0C8 B0B1 8858 8A58 83B0 B0D7 A887"
	$"9DCA DAAD B5B0 BDB8 BDB8 BEE3 D1D1 DAB3"
	$"B8BD BDB8 FF9B 3FDA B3CA C5DA B3C8 C8BE"
	$"D1BD BCE4 BFC4 F4CA EFE7 ECB8 BDB8 BDB8"
	$"BD9E C6AA F6CF F4E5 D7B5 B0BD E3B8 BDDE"
	$"E3CA F4E9 BFB0 B6C6 C1D1 A5BD D0AB FBD1"
	$"FCD9 C1C4 97C8 9BFD A305 AEDA CCAA D1D1"
	$"FEB5 0FC8 DBB5 D1D1 E1CA E3BD 9BC8 99C0"
	$"CACA F701 6147 A99A 95AA 7BA7 76A7 757B"
	$"7544 7379 A37E A7A7 757B 757B 7872 A7A7"
	$"AAAA A676 7278 7E78 A575 757B 80D1 D1B0"
	$"C4AB 7B74 7B75 7B75 7272 78D4 C3D1 D7D7"
	$"7CA1 7973 A57B D5D4 D6C4 CD7B 7676 FE78"
	$"11A8 7B7B A8C1 D5A8 D2AB 7972 7872 3E3E"
	$"3C3C 46FE A81F 78A8 A792 A87D A776 C1AD"
	$"AAAA 7B75 4172 7878 AAD0 ADA9 9A9B AF87"
	$"B182 B183 8883 7F56 8389 AB87 B1B1 8388"
	$"8388 8A84 B1B1 AFAF B183 848A 8781 B183"
	$"8389 87D7 D7B5 C8AF 8882 8883 8883 8484"
	$"81DB C8D7 DBDB 88AC 8983 B188 D7D6 DCC9"
	$"D589 8282 8A8A 81B0 8888 B0C8 DCB0 D6AF"
	$"8983 8A84 5959 5A5A 54B2 B0B0 81B0 B19C"
	$"B087 B182 C8B5 B0B0 8883 5884 8989 B0D6"
	$"B5A8 98B7 CAB3 DAB0 DBB8 BDB8 8FB8 BDCC"
	$"AADA DAB8 BDB8 BD41 C8C2 DADA CACA DAAE"
	$"C2C8 AAA5 E3B8 BABF A2EF EFCF D9C1 BDB7"
	$"BDB8 BDB8 C1C1 A5FB E1EF EAEA B5D6 BDB8"
	$"E3BD DFDE F4E2 FBBF B0B0 C6C6 A5D1 BDBD"
	$"D1E8 FCD1 E7C1 C4BF C8C2 FDA3 1885 DBD1"
	$"D1A5 D1DB C8DB B5DB B0E8 D6CA CABD B89B"
	$"C2C6 C6CA EED6 015C 57A9 9A78 A8A5 7578"
	$"787C 7672 7876 A77C A2A7 A77C 767D 767B"
	$"757B A57E A878 4076 A776 7C72 787C 76A7"
	$"C0B1 C4D6 D690 7B7C 7B76 447B 757B A5CF"
	$"ADC4 C4A7 7C91 7C7C 77D6 D6C4 D6C0 7879"
	$"A47C 927B 75A7 757C C0AA D6A8 A872 7875"
	$"7BFD 3E0B 4178 7BA7 A8A8 A57B 7E78 7BA5"
	$"FDA8 137B 4477 3E44 75AA D6C4 A99A 81B0"
	$"B183 8989 8882 844C 8982 B188 ADB1 B188"
	$"8289 8288 8388 B187 B08A 5882 B182 8884"
	$"8A88 82B1 C9B5 C8DC DC9D 8889 8883 5689"
	$"8388 B1D7 B5C7 C7B1 889C 8886 81DC DCC9"
	$"DCC7 8189 B288 9C88 83B1 8188 C9B0 DBB0"
	$"B084 8983 88FD 590B 5889 87B1 B0B0 B188"
	$"8781 88B1 FDB0 1E88 568A 5956 83B0 DCC7"
	$"A99A A5D1 E3B8 C9C9 B3AE C1C6 AEDA B5D7"
	$"DADA B5B0 B4AE 41BD B8BD E3AA D1C6 99B0"
	$"DBB0 B5C2 C8B5 B0DB F2C6 D9F4 F4D0 BDBE"
	$"BDB9 8FBF BABD E3F8 D8D7 D7DB B5D0 BDB3"
	$"AEF4 F4E2 F4E8 A5BD E3B5 C8BD B8DB AFB5"
	$"F2CA F3D1 D1C1 C6B8 BDFD A30B 99C6 B4DB"
	$"D1D1 E3BD AAA5 BDE3 FDD1 08BD 8FCF A38F"
	$"B8CA F4D7 0161 2DA9 9A78 A87B 7B78 7276"
	$"7647 727C 76A7 7CA7 7BA1 7CA7 767B 75A5"
	$"7BA3 A878 727C 767B 9178 7892 7C7C ACC4"
	$"D2AA C37B 7BFE 7536 7C75 7B44 A5AD CFAB"
	$"D7A7 767C 7C77 A8D1 AAD6 AAA8 7D79 7375"
	$"7C7B 757C 76A7 ACD1 AAA8 A878 417B 753E"
	$"3D3E 3E41 72A7 76A8 A8A5 7B93 A87B A5FE"
	$"A814 7875 753E 3D45 75AA C3AB A99A 81B0"
	$"8888 8984 8282 5D22 8488 82B1 88B1 87AC"
	$"88B1 8288 83B1 88AB B08A 8488 8287 9C8A"
	$"8A9C 8888 B6C8 D6B0 C888 88FE 831F 8983"
	$"8956 B0B5 D7AF DBB1 8288 8881 B1D7 B0DC"
	$"B0B0 8689 8381 8888 8388 82B1 B6D7 FEB0"
	$"1389 5888 8359 5859 5958 84B1 82B0 B0B1"
	$"889B B088 B1FE B01F 8183 8359 5857 83B0"
	$"C8AF A99A A5D1 BDBD C9C4 AEAE 9EC1 B3AE"
	$"DBB5 DAB3 D6B5 DAAE 0BBD B8E3 BDCC D1C6"
	$"C1B5 B0B4 C7FE C8FF B506 E0D9 E7CA E1BD"
	$"BDFE B826 BEBA BF8F E2D8 F8BF EADB B0BD"
	$"BDAE DBEF CAF4 CAD1 A9BD B8AF B5BD B8B5"
	$"B0DB E0EF CAD1 D1C6 99BD B8FD A30B 99C1"
	$"DBB0 D1D1 E3BD BED1 BDE3 FED1 09A5 B8B8"
	$"A3A3 90B8 CAE1 BF01 540E 9AA9 767C A378"
	$"A575 7B7B 7179 777D 7CFD A718 7C76 7C7C"
	$"A778 A87B A540 3E75 7B78 78AA AAA8 A8AB"
	$"C4A7 ACD1 B0FE AA1A A97B 7578 727B 75C4"
	$"ABD4 A8C4 AB7C 76AA D1AD CFC4 D77B 7575"
	$"7B7B 75FD A8FF AAFF A80D AAC4 7CA7 767C"
	$"7241 3E3E 4173 7B7B FDA8 1B7C 7BA5 ABA8"
	$"A87B 7B3E 3D3F 7243 3EA8 ADC1 9AA9 8288"
	$"AB81 B183 8888 8203 8981 8788 FDB1 0E88"
	$"8288 88B1 81B0 88B1 5A59 8388 8A8A FDB0"
	$"05AF C8B1 B6D7 B5FE B01A AF88 8389 8488"
	$"83C8 AFDB B0C8 AF88 82B0 D7B5 D6C8 DB88"
	$"8383 8988 83F8 B00C C988 B182 8884 5859"
	$"5958 8588 88FD B026 8988 ABB1 B0B0 8888"
	$"5958 5784 5D59 B0B5 C89A A9AE B3CC A4E3"
	$"B8BD BDBE C4AE B3B5 DBDA DADB B5AE B315"
	$"B5DB A5D1 BDE3 A4A3 B8BD C8C8 CACA D1D1"
	$"C1D9 DADF EFCF FECA 1AC9 BDB8 C6C1 BDB8"
	$"D9C1 FBD1 D9C1 B5B0 CAEF D6F5 D9EC BDB8"
	$"BABF BDB8 FDD1 FFCA FFD1 0DCA E2B3 DAB0"
	$"B5C1 99A3 A399 C2BD BDFD D110 BEBD C4CA"
	$"D1D1 BDBD A3A3 9AC2 A7A3 D1D6 E801 5711"
	$"A99A 76A7 7EA8 7B7B 75A5 7147 7777 7CA1"
	$"7C76 FDA7 33A1 7C7E A37B 763E 3E7B 7572"
	$"78B4 AAA8 A8AB C4D4 A7AA C3AA C3AA C3AB"
	$"7572 4775 7BAB C4A8 D4AB C4CE ACC3 B0C1"
	$"ADC4 AB75 7B7B 757B A6FE A806 A9AA C3A8"
	$"A8AA AAFD A707 7841 3E40 4141 75A5 FDA8"
	$"FFA5 FFAA FFA8 FF75 133E 7741 4171 3EA8"
	$"C2AD A99A 82B1 87B0 8888 83B1 8206 5C81"
	$"8188 AC88 82FD B10C AC88 87AB 8883 5959"
	$"8883 848A BAFE B023 AFC8 DBB1 B0C8 B0C8"
	$"B0C8 B683 845D 8388 AFC8 B0DB AFC8 D7B6"
	$"C8B5 C8B5 C8AF 8388 8983 88B2 FEB0 02B1"
	$"B0C8 FDB0 FDB1 0789 5859 5A58 5883 B1FD"
	$"B0FF B1FD B0FF 831E 598A 5858 8559 B0C9"
	$"B5A9 9AAE DAAA D1BD BDB8 E3BE 9CAE AEB5"
	$"D6B3 AEDB DBDA DA33 D6B5 AACC BDB9 A3A3"
	$"BDB8 C2C8 D3CA D1D1 C1D9 FCDA CAE1 CAE1"
	$"CAE1 E8B8 C19E B8BD C1D9 D1FB C1D9 FBE0"
	$"E1CF E8D6 D9C1 B8BD BFBA BDE4 FED1 12D2"
	$"CAE1 D1D1 CACA DADA DBDB C699 A3A4 9999"
	$"B8E3 FDD1 FFE3 FFCA FFD1 FFB8 08A3 CF9B"
	$"9BCA A3D1 E9D6 014A 4D7E A895 8091 7B76"
	$"A87B 7B7D 7772 7875 7BA8 A8A7 7CA7 A7A8"
	$"A872 78A3 4174 4375 7B76 7CA8 A8AA C3A8"
	$"A8AA AAC0 ADC1 A8B0 C3A7 7C7C 7672 727B"
	$"ABC4 ABC0 ACAA D1AB D2C3 C3A5 7B7C 767B"
	$"7572 78AB C4A7 C0F7 A801 7841 FD3E 2141"
	$"72A8 A8A7 A7A8 A87C A77C A777 3F41 413F"
	$"3F3E 3EA8 A8C4 80AA 9B87 9C88 82B2 8888"
	$"8716 8284 8983 88B0 B0B1 88B1 B1B0 B084"
	$"89B2 5883 5783 8882 88FE B000 C8FD B023"
	$"C8B5 C8B0 B5C8 B188 8882 8484 88B6 C7AF"
	$"C9B6 B0D7 AFD6 C8C8 B189 8882 8883 8489"
	$"AFC8 B1C9 F7B0 3289 5859 595A 5A58 84B0"
	$"B0B1 B1B0 B088 B188 B18B 5A58 585A 5A59"
	$"59B0 B0C7 89B2 B6A2 C8B5 B0DC BDBD B5B0"
	$"C1C6 B8BD D1D1 DBB5 DADA FFDB 35C1 C6ED"
	$"9BC1 99B8 BDAE B3D1 D1CA E1D3 D3CA CAE9"
	$"D8E8 D1CF E1DA B3B5 B0C1 C1BD E8D7 BFF2"
	$"E0CA EFC1 E7E1 E1E4 BFB3 AEBD B8C1 C6C1"
	$"D9D1 E8F7 D115 C699 A3A3 A5A5 9BC2 D1D1"
	$"DBDB D1D1 B5DB B3DA CFA3 9999 FDA3 FFD1"
	$"00D7 0149 1699 A895 AA7B 75A7 7CA0 7B77"
	$"7747 7275 7B93 7E7C A17C A77D FE78 FF41"
	$"FF43 0274 7B76 FEA8 FFAA FFA8 25AA C4AD"
	$"C1A8 ADC4 AAA7 7676 7547 7875 75AB C5AC"
	$"A7C3 B0D2 ABB0 AA7B 7576 767B 7578 78C4"
	$"ABA8 ADF7 A802 7241 40FE 3E07 4178 A8A8"
	$"A77C A8A8 FEA7 1676 3F3F 7241 3F3F 403E"
	$"A8A8 AB9A AA9B B088 82B1 88AC 8882 1682"
	$"5D84 8388 9B87 88AC 88B1 8782 8989 5858"
	$"5757 8288 82B2 FAB0 24C9 B5C8 B0B5 C9B0"
	$"B182 8281 5D89 8383 AFC8 B6B1 C8B5 D6AF"
	$"B5B0 8983 8282 8883 8989 C8AF B1B6 F7B0"
	$"0D84 585A 595A 5A58 8AB0 B0B1 88B0 B0FE"
	$"B104 825A 5A84 58FE 5A19 59B0 B0AF A3B2"
	$"B6CA B5B0 DBB5 DEBD B0B0 9EC1 B8BD BEAA"
	$"B5D6 B3DA 37B5 B1C6 C69B 9B99 99B7 BDAE"
	$"DBD1 D1CA CAD3 D3CA E2D8 EAD1 D6E2 CADA"
	$"AEB0 AF9E C6B8 B8BF D8E0 DBE1 CFE7 C1CF"
	$"CABF BAAE AEBD B8C6 C6D9 C1D2 D6F7 D11C"
	$"C199 A4A3 A5A5 9BC8 D1D1 DBB5 D1D1 DBDB"
	$"DAAE A3A3 C199 A3A3 A4A3 D1D1 BF01 5021"
	$"997E A77C 78A8 7B75 7CA7 7278 7278 7B75"
	$"7B7B A3A9 A792 A57B 7575 3E3E 3B3C 7972"
	$"7B75 FEA7 02A6 A4A5 FDA7 1FA8 C1A5 A5A7"
	$"7C47 727B 757C 7B7A A5A7 C0A8 A8A7 A7A5"
	$"7B76 7C7B 7B75 7B75 75A7 ACF7 A729 7BA5"
	$"7141 403D 3E3D 7278 757B A8A2 A57B A17C"
	$"A442 3E3E 3C3C 4172 3D3E 7CA7 A89A 80B1"
	$"8881 B088 8388 B184 0E89 8489 8883 8989"
	$"ABB1 B19C B188 8383 FE59 045A 8B84 8883"
	$"FEB1 02B0 B2B3 FDB1 01B0 C8FE B10C 885D"
	$"8488 8389 8887 B1B1 C9B0 B0FE B10A 8882"
	$"8889 8983 8883 83B1 B6F7 B134 88B1 8358"
	$"5A58 5958 848A 8388 B0AA B188 AC88 B256"
	$"5959 5A5A 5884 5859 87B0 B0A3 89DB B5A5"
	$"D1BD B8B3 DAC1 C6C1 C6BD B8BC BCCC D2DB"
	$"C803 E3BD B8B8 FDA3 3CC8 C2BD B8DB DBDA"
	$"D9E3 E4DA DADB DBD1 E8E3 E3DA B39E C1BD"
	$"B8BE BDBC E3DB F2DA DADB DBE3 BDB0 B5BC"
	$"BCB8 BDB8 B8DB E0DA DADB DBDA DADB DBDA"
	$"DABD E3C0 99A4 FEA3 0BC2 C8B8 BDD1 CBE3"
	$"BDD6 B5E3 8FFD A306 9BC2 A3A3 B6DC D101"
	$"5E16 8988 76A7 7878 7C75 7677 4772 783F"
	$"757B 7575 7E78 7C7C 75FE 441B 3E40 3C3C"
	$"4179 757B 767C 767C 7979 767C 767C 787E"
	$"7B7B 7675 7871 7544 FE75 207B 7D7C A87D"
	$"A77C 767C 7676 7575 7B75 7B7B 7676 7B75"
	$"7C76 7C76 7C76 4676 7544 4141 FD3E 213F"
	$"7874 7A78 7E75 7B7C 7673 423E 3D3C 3C41"
	$"413E 3EA7 A7A8 8A89 82B1 8181 8983 8283"
	$"5D0B 8489 5783 8883 8387 8188 8883 FE56"
	$"0059 FE5A 1758 8B83 8882 8882 8889 8982"
	$"8882 8881 8788 8882 8189 8383 56FE 8320"
	$"8889 88B0 87B1 8883 8982 8283 8388 8388"
	$"8882 8287 8188 8288 8288 8254 8283 5658"
	$"58FD 5913 578A 8287 8187 8388 8882 8356"
	$"5958 5A5A 5858 5959 FEB0 1593 92B0 DBA5"
	$"A5BE B8AE AF9E C1C6 98B8 BDB7 B7AA A5B5"
	$"B500 B8FE 8F1B A3A4 A3A3 9BC8 B8BD B0B5"
	$"AEB3 BDBD AEB3 B0B5 A5AA BDBD AEAD C6C0"
	$"B88F FEB8 20BD B6B5 DAB3 DBB5 B9BE B0B0"
	$"B7B7 BDB8 BDBD B0B0 B3AD B5B0 B3AE B5B0"
	$"85AE B88F 9999 FDA3 0B9A C8B7 BCA4 AAB8"
	$"BDB5 B0B8 8FFD A3FF 9BFF A3FF DC00 D101"
	$"4C17 7E89 7AAA 7542 7278 7378 767C 7373"
	$"7841 757B 7278 7575 7841 FB3E FF75 1878"
	$"417C 7578 7275 7678 7278 7279 7475 7C72"
	$"7875 7B79 7875 7B4A FE75 FF73 1972 7175"
	$"757B 7B74 7A75 7B76 767B 757B 7572 7872"
	$"7872 7875 7A7C 76FD 3EFF 3C0F 7C75 7973"
	$"7878 A17C 757B 3E40 3D3E 3D3C FD3E 0D7C"
	$"A7A8 808A 81B0 8B5F 8489 8589 820C 8883"
	$"838A 5883 8884 8A83 838A 58FB 59FF 8318"
	$"8958 8983 8984 8182 8A84 8984 8984 8389"
	$"8489 8388 8A89 8388 5BFC 8300 84FE 83FF"
	$"8813 8389 8388 8282 8883 8883 848A 8489"
	$"8489 8387 8882 FD59 FF5A 0F89 8389 838A"
	$"8AAC 8883 8859 5A58 595B 5AFD 5918 88B1"
	$"B089 939D CACF A8C1 C6C2 C6B0 B5B8 B8C8"
	$"9BB8 BDC2 C8B8 B801 C89B FBA3 FFB8 18C6"
	$"99BE B8C6 C1AF B0C8 C2C6 C1BD B9B8 BEC1"
	$"C6B8 BDC7 C6B8 BD94 FCB8 19C1 C0BA BABD"
	$"BDC1 C6B8 BDAE AEBD B8BD B8C2 C8C1 C6C1"
	$"C6B8 BCB5 B0FB A30E BEB8 BDB8 C8C8 D6B5"
	$"B8BD A3A4 A3A3 A4FC A302 B5DB D101 47FF"
	$"8915 95AA 756F 7147 7247 7676 4672 7872"
	$"7B75 4278 447B 7241 FB3E 1875 4A72 7975"
	$"4472 4776 7C41 7872 4773 427B 7541 7844"
	$"7541 727B FE75 FF7B 1B48 7378 477B 7B76"
	$"7543 7A75 4476 7C75 7B75 4478 3F78 4172"
	$"4775 7B76 76FD 3EFF 3C09 7B75 7873 7872"
	$"7C76 7A75 FD3E FF3C FD3E FFA7 0BA8 8A8A"
	$"9BB0 8B85 835D 845D 820C 825B 828A 8488"
	$"8359 8A56 8884 58FB 5918 835B 848A 8356"
	$"845D 8288 588A 845D 8356 8883 5889 5683"
	$"5884 88FE 83FF 881B 5C83 895D 8989 8383"
	$"5789 8356 8288 8388 8356 8A57 8958 845D"
	$"8388 8282 FD59 FF5A 0988 8388 838A 8488"
	$"8287 83FD 59FF 5AFD 59FF B116 B093 93B6"
	$"CACF CAC0 9EC1 9EB0 B093 B7C8 C2BD B89C"
	$"C88F BD01 C29B FBA3 18B8 94C1 C7B8 8FC1"
	$"9EB0 B59B C8C1 9EB8 8FBD B899 C68F B899"
	$"C1BD FEB8 FFBD 1B94 B8C6 9EBF BFB9 B899"
	$"C6B8 8FAE B3B8 BDB8 8FC8 9AC6 99C1 9EB8"
	$"BDB0 B0FB A309 BDB8 BCB8 C8C2 B5B0 BCB8"
	$"F7A3 FFDB 00D1 0143 FF8A 1577 A790 7B76"
	$"767B 7579 727C 7647 7278 417D 7779 7278"
	$"41FB 3EFF 751D 7B75 7B7B 7677 7872 7575"
	$"7B75 7878 757B 777D 757B 7B75 4772 7941"
	$"7272 7379 FE75 0C44 7978 7C75 7776 7247"
	$"7544 7B7A FE75 167B 7676 7841 7841 3E3E"
	$"3C3C 4172 7B75 A57A 757B 757B 7544 F73E"
	$"0D7B A7A8 8A8A 82B1 9D88 8282 8883 8B0C"
	$"8488 825D 8489 5887 8289 838A 58FB 59FF"
	$"831D 8883 8888 8283 8984 8383 8883 8A8A"
	$"8389 8389 8388 8883 5D84 8957 8484 8389"
	$"FE83 0C56 8B8A 8983 8A89 845D 8356 8887"
	$"FE83 1688 8282 8958 8A58 5959 5A5A 5884"
	$"8883 B187 8388 8388 8356 F759 1887 B1B0"
	$"8888 A7D3 D0BD B1B1 BDB8 C8C2 B3AE 9EC1"
	$"C699 B5B0 C4BF 01C8 9BFB A3FF B82D BDB8"
	$"BDBD AEAF C6C1 B8B8 BDB8 C8C8 BABF AFB4"
	$"B8BD BDB8 9EC1 C497 C1C1 B8BD BABA B88F"
	$"C8C8 BEB8 C8C7 C19E B88F BDBC FEB8 06BD"
	$"B0B0 C699 C89B FDA3 0B99 C1BD B8E3 BCB8"
	$"BDB8 BDB8 8FF7 A302 B4DB D101 45FF 9A15"
	$"76A7 7B7B 7C77 757B 4178 7676 7278 7278"
	$"7777 7247 723F FB3E 4948 7575 4475 757C"
	$"7648 727B 4475 7B72 4175 7B76 767B 7576"
	$"7B72 7872 7978 4773 7844 7B7C 7672 4175"
	$"7B3F 7178 727B 7675 757B 7B75 7B7C 7672"
	$"7872 783D 3E3C 3C41 7875 7B75 7B75 7B75"
	$"7B75 44F8 3E0E 3DA7 A7A8 9A9A 81B1 8888"
	$"8783 8388 580C 8A82 8284 8984 8982 8283"
	$"5C84 57FB 592C 5A83 8356 8383 8882 5E84"
	$"8856 8388 8458 8389 8282 8883 8388 8489"
	$"8389 895D 8388 5689 8983 8458 8388 5884"
	$"8984 88FE 83FF 8817 8388 8882 8489 848A"
	$"5859 5A5A 5889 8388 8388 8388 8388 8356"
	$"F859 1958 B1B1 B098 98A6 D3BD BDB6 B1B8"
	$"BD9B C8AE AEC1 C6C1 C6B0 B0BF 9C01 C29A"
	$"FBA3 3993 B8B8 8FB8 B8B3 AE9F C1BD 8FB8"
	$"BDC2 9BBA BFAE AEBD B8B9 BDC1 C6BF C4C6"
	$"9EB8 BC91 BFBE B9C2 9BB8 BD9B C2C6 C1BD"
	$"B9B8 B8BD BDB8 BDB5 B0C1 C6C2 C8FD A30B"
	$"99C6 B8BD B8BD B8BD B8BD B88F F7A3 FFDB"
	$"00D1 0145 FF8A 6396 ABA8 A872 4775 7A75"
	$"447E 787C 4673 7872 787C 7672 413D 3E3C"
	$"3C3E 3E75 757C 7B78 7841 7876 7C75 7B7A"
	$"447B 7578 4178 4775 4478 4175 744A 7574"
	$"7A75 757D 7672 7878 7278 7275 7B75 7478"
	$"7278 7844 754A 7441 784A 7573 403E 3D3F"
	$"3F7B 757B 757B 747C 7678 72F5 3E05 78A8"
	$"A88A 8A9B FEB0 0484 5D83 8783 5A56 8781"
	$"8855 858A 8489 8882 8458 5859 5A5A 5959"
	$"8383 8887 8A8A 5889 8288 8388 8756 8983"
	$"8A58 895D 8356 8958 8382 5B83 8389 8383"
	$"8982 8489 8A84 8984 8389 8382 8A84 8989"
	$"5683 5B82 588A 5B83 8355 5958 5A5A 8883"
	$"8883 8882 8882 8984 F759 FF5A 1881 B0B0"
	$"8A8A AEC3 D1D1 C19E B8BC B88F AAA5 B587"
	$"C3C8 C1C6 B5B0 01C1 99FB A3FF B837 BCBB"
	$"C8C8 99C6 B8BD B8BD BC8F BCB7 C89B C69E"
	$"B88F C699 B8B7 94B8 C1C6 B8B8 B6B0 C1C6"
	$"C8C2 C6C1 BABF B8B7 C8C2 C6C6 8FB8 94B7"
	$"9BC8 94B8 B88F FDA3 09BD B8BD B8BD B7B5"
	$"B0C6 C1F7 A3FE A5FF D101 4228 8A9A 96AB"
	$"79A8 7872 7B75 757B 7893 9276 7841 7247"
	$"7776 7841 3E3E 3C3C 3E3E 754A 7677 4172"
	$"7279 7645 7BFD 7538 7B72 7872 7275 7B78"
	$"727B 7B75 7549 7475 4A76 7647 7241 7872"
	$"4775 7B44 7B41 7841 7275 7B75 7578 7275"
	$"7579 733E 3E3F 3D75 7B75 7B74 7B92 7C78"
	$"3FF5 3EFE A80A 8A9A 9BB0 82B0 8984 8883"
	$"831D 8881 9B9C 828A 5884 5D83 8289 5859"
	$"595A 5A59 5983 5B82 8358 8484 8A82 5588"
	$"FD83 3889 848A 8484 8388 8984 8888 8383"
	$"5C83 835B 8282 5D84 588A 845D 8389 5688"
	$"588A 5884 8388 8383 8A84 8383 8983 5959"
	$"5A59 8388 8388 8288 9C88 8957 F759 FF5A"
	$"FEB0 158A 9AAE C3A6 D1C6 C1BD B8B8 BDA5"
	$"BEC8 B0C8 9BC1 9EB1 B001 C699 FBA3 0AB8"
	$"94B7 B89B C2C1 C7B8 8FBD FEB8 2BB7 BCC2"
	$"C8C1 C1B8 BDC6 C1BD BDB8 B89E C1B8 94B0"
	$"B09E C19B C8C1 9EBA BF8F BD9B C899 C1B8"
	$"BDB8 B8C8 C2B8 B8BD B8FE A30A A2B8 BDB8"
	$"BDB7 BDC8 B5C6 98F7 A3FF A5FE D101 4AFF"
	$"8A15 99AE AAAA A776 783F 7B76 7D98 9B9B"
	$"767C 7C76 783F 7841 FB3E 4772 7874 7A76"
	$"7C78 7278 7278 4078 7875 4478 7276 7B79"
	$"7276 7C43 7578 7875 7B72 7972 7775 7B75"
	$"757B 757B 757B 757D 7778 7872 7872 7972"
	$"7871 4774 483E 3E44 7C7A 75A5 7B75 7B78"
	$"7272 40F9 3EFF 3FFF 3E0D 7CA7 A88A 8A9A"
	$"AFB0 B0B1 8289 5788 0C83 809A 9999 8288"
	$"8882 8957 8A58 FB59 4784 8A83 8882 8889"
	$"848A 848A 588A 8A83 5689 8483 888A 8482"
	$"8855 8389 8983 8884 8A84 8983 8883 8388"
	$"8388 8388 8387 8289 8984 8A83 8984 8A83"
	$"5D83 5B59 5956 8988 83B1 8883 888A 8484"
	$"58FB 59FF 5AFD 5918 88B1 B08A 8AA3 B8CA"
	$"CADB B0C6 98BD B991 AB9A 9AAE B3B5 B0C6"
	$"9801 C89B FBA3 47C2 C8BF C4B0 B5C6 C1C8"
	$"C2C6 99C8 C8B8 8FC6 C1B9 BDC7 C1AE B38F"
	$"B8C6 C6B8 BDC1 C7C2 C7B8 BDB8 B8BD B8BD"
	$"B8BD B8B5 B0C6 C6C2 C8BF C4C2 C8C0 9EC1"
	$"9DA3 A38F BEBE BAE3 BDB8 BDC8 C2C1 99FB"
	$"A3FF A5FD A302 B5DB D101 4E10 688A 9AA8"
	$"A5AA 7CA7 7277 757B 7D98 9BAB 77FE 7603"
	$"7872 7141 FB3E 4741 7874 4976 7641 7841"
	$"7872 7871 417B 7572 4775 4472 4776 767B"
	$"753F 717B 7547 7278 417B 757B 4475 7B44"
	$"7575 7B77 7672 4178 4179 4178 4178 727A"
	$"743E 3E75 767B 757B 757B 7578 7840 40F9"
	$"3EFF 3F0F 403E A7A7 A868 8A9B AAAB B088"
	$"B184 8883 0588 809A 99AA 83FE 8203 8984"
	$"8358 FB59 4758 8A83 5C82 8258 8958 8A84"
	$"8A83 5888 8384 5D83 5684 5D82 8288 8357"
	$"8388 835D 848A 5888 8388 5683 8856 8383"
	$"8882 8184 588A 5889 578A 5889 8489 8359"
	$"5983 8389 8388 8388 838A 8A58 58FB 59FF"
	$"5AFF 591A 5A59 B1B1 B068 8AA4 B2C4 CAB5"
	$"DBC1 C5B8 BD91 AB9A AAAF AEB0 B0C6 C101"
	$"C29B FBA3 479B C8BF 9CB0 B099 C69B C8C1"
	$"C6C2 9BBD B8C1 9EB8 8FC1 9EAE AEBD B898"
	$"C0BD B89E C1C8 9BBD B8BD 8FB8 BD8F B8B8"
	$"BDB0 AFC1 99C8 9BC4 97C8 9BC6 C1C6 C1A3"
	$"A3B8 B9BF BABD B8BD B8C8 C899 99FB A3FF"
	$"A5FF A304 A4A3 DBDB D101 4417 4878 78A8"
	$"ABA6 A37E 7C75 4772 7B7B 9A9A 967C 7841"
	$"7872 7841 FB3E 2F7B 7572 7872 787C 7675"
	$"757C 7672 7875 7B78 727A 7B75 7B3F 7872"
	$"787C 7641 7876 767B 7572 4775 7B7B 7572"
	$"787B 4478 417C 7BFE 7612 7C76 7572 7875"
	$"753E 3E7B 7B75 7A75 7A72 7877 76FB 3EFF"
	$"3FFB 3E0D 7EA8 A84A 7A81 B0AF AAAB 8788"
	$"815D 0284 8888 FE9A 0680 8A58 8984 8A58"
	$"FD59 FF5A 2F88 8384 8984 8A88 8283 8388"
	$"8284 8983 888A 8487 8883 8857 8984 8988"
	$"8258 8A82 8288 8384 5D83 8888 8384 8A88"
	$"568A 5889 88FE 8212 8882 8184 8A83 8359"
	$"5989 8983 8883 8784 8983 82FB 59FF 5AFB"
	$"5918 87B0 B055 83A5 D1BF BACC AAB3 AD9E"
	$"C1BD BD9A 9AAB 91C8 9BC6 C101 C89B FDA3"
	$"FFA5 45BD B8C1 C6C2 C8B3 AEB8 B8BD B8C1"
	$"C6B8 BDC8 C2BC BDB8 BD98 C6C1 C6B3 AE9B"
	$"C8AE AEBD B8C1 9EB8 BDBD B8C2 C8BD 8FC8"
	$"9BBE BDB0 B0B8 BDB0 AFC1 C6B8 B8A3 A3BC"
	$"BCB7 BCB8 BCC1 C6B1 B0F3 A302 AAD1 D301"
	$"4517 5467 78A8 ABA6 A8A8 A17C 7278 7574"
	$"9A9A A67C 7279 7247 7241 FC3E 463D 4475"
	$"4772 7841 7676 7B7B 4376 4773 7B75 4178"
	$"7575 7B75 7872 4772 7676 7872 767C 4475"
	$"7872 7B75 4475 7841 7575 7278 7576 767C"
	$"7C77 767D 783E 754A 3E77 7575 7B75 7C74"
	$"7878 7545 FB3E FF3F FB3E 0DA3 A8A8 5769"
	$"81B0 AFAA B0B0 AB88 840C 8983 829A 9AAA"
	$"8084 8B84 5D84 58FD 5947 5A59 5683 5D84"
	$"8A58 8282 8888 5482 5D85 8883 588A 8383"
	$"8883 8984 5D84 8282 8A84 8288 5683 8984"
	$"8883 5683 8A58 8383 848A 8383 8288 8883"
	$"8289 8A57 835B 598A 8383 8983 8982 8989"
	$"8154 FB59 FF5A FB59 18AB B0B0 6172 A5D1"
	$"BFBA D1D1 D5B3 C1C6 B8B7 9A9A BA91 C2C8"
	$"C19E 01C2 9BFD A347 A5A4 8FB8 9EC1 C89B"
	$"AEAE BDBD 8EB8 9EC2 BDB8 9BC8 B8B8 BDB8"
	$"C6C1 9EC1 AEAE C8C2 AEB3 8FB8 C6C1 BDB8"
	$"8FB8 C89B B8B8 C2C8 B8B9 B0B5 BDB9 B0B6"
	$"C698 B894 A3CF B7B7 BCB7 BEB7 C6C6 AF86"
	$"F3A3 02CC D1D3 013C 0445 5278 A878 FEA8"
	$"4DAA 8076 7647 727E 939A 9A7C 7576 7678"
	$"413F 3F4C 4C3E 3E72 7876 7C72 7878 4178"
	$"7275 7B77 7B41 7876 7645 7175 7B75 7579"
	$"7347 7874 7A47 7279 7278 7276 7C77 7875"
	$"7B78 7278 7247 783F 7841 7844 7B72 78FD"
	$"75FF 7805 767C 76A7 7373 F33E FF3C 0D7C"
	$"A7A8 4A56 81B0 81B0 A9AA B087 824A 825D"
	$"8487 9B9A 9A88 8182 828A 585A 5A51 5159"
	$"5984 8A82 8884 8989 5889 8483 8883 8758"
	$"8982 825E 8583 8883 8389 835D 8A83 895C"
	$"838A 848A 8482 8888 8983 8889 848A 845D"
	$"8957 8A58 8956 8884 89FD 83FF 8A05 8288"
	$"82B1 8383 F359 FF5A 1888 B1B0 5F6A A5D1"
	$"A5D1 BCBD CAA2 B0B0 9EC1 AABE 9A9A B5AF"
	$"AEAE 3FC8 9BA3 A367 67A3 A3C2 C8AE B3C1"
	$"C6C6 99C6 C1B8 BDB1 B499 C6B0 B0A8 CAB8"
	$"BDB8 B8BD B89F C8C1 C69C BFC7 C1C8 C2AE"
	$"B3C5 C6B8 BDC6 C1C8 C29E C69A C899 C68F"
	$"BDC1 C6FD B8FF C805 AEB3 B0DB B8B8 F1A3"
	$"02B5 DBD1 013C 5552 4560 7EA8 A8AD ADA5"
	$"B47C 7678 7278 78A9 9A92 7C7C 7672 413F"
	$"3FA1 A13E 3E41 7876 7647 7272 7872 4775"
	$"7B76 7678 727C 7677 7744 754A 7573 7973"
	$"7349 7472 7972 4772 4776 7772 417A 7541"
	$"7941 7872 7278 7272 7875 7541 78FD 7B07"
	$"7178 76A7 7C75 7942 F33E FF3C FFA7 0BA8"
	$"564A 6A87 B0B0 AFAF ABBA 884A 8289 8481"
	$"81A9 9A9C 8888 8284 585A 5AA5 A559 5958"
	$"8A82 825D 8484 8984 5D83 8882 8289 8488"
	$"828A 8A56 835B 8383 8985 855C 8383 8984"
	$"5D84 5D82 8384 5887 8358 8A58 8A84 848A"
	$"8484 8983 8358 89FD 8807 838A 82B1 8881"
	$"8956 F359 FF5A FFB1 16B0 6A5F 90AA D1D1"
	$"C1C1 C4D3 B5B0 C6C1 A5A5 A99A C8B5 B3AE"
	$"3FC2 9BA3 A3B7 B7A3 A39B C8AE AE9E C1C1"
	$"C6C1 9EB8 BDB0 B0C6 C1B5 B0CF CF8F B894"
	$"B8B8 BDC3 C39E C1BF C4C1 9EC2 9FAE AFC1"
	$"99BC B899 C79B C8C1 C1C8 C2C1 C6B8 B899"
	$"C6FD BD07 C2C8 AEDA B5AF BD8F F1A3 FFDB"
	$"00D1 013F 0F45 6440 78A8 78AB A6AB A6A8"
	$"7C72 787B 75FE 9A4E 7E78 4178 4145 6FAA"
	$"AA85 4A72 783F 7875 7578 717D 7772 7841"
	$"7876 764A 7572 7875 7B75 7B4A 7572 7875"
	$"7B74 757C 7675 7B72 4774 7B75 757B 757C"
	$"7672 7872 7875 7B72 787C 7676 7D75 757B"
	$"757B 7575 7B72 41F3 3EFF 3C0D 7BA6 A84B"
	$"694C 81B0 81AE AAAF AAB2 5688 8489 8883"
	$"9A9A 9B80 8A58 8A58 557C A4A4 8B52 8489"
	$"5789 8383 8A83 8781 8489 588A 8282 5B83"
	$"8489 8388 8388 5B83 8489 8388 8283 8882"
	$"8388 845D 8288 8383 8883 8882 848A 848A"
	$"8388 8489 8882 8187 8383 8883 8883 8389"
	$"8458 F359 FF5A 1886 B0B0 5D7A 75A5 D1A5"
	$"C0BC BFBA DCB5 C1C6 BDB8 9A9A A489 C89B"
	$"4BC8 9B87 AA7E 7EA7 71C1 C698 C6B8 B8C8"
	$"C2B3 AEC1 C69B C8B8 B894 B8C1 C6B8 BDB8"
	$"BD94 B8C1 C6B8 BDB7 B8B5 B0B8 BDC2 9FB7"
	$"BDBA BABD B8B5 B0C1 C6C2 C8B8 BDC1 C6B3"
	$"AEAF B5BA BABD B8BD B8B7 BCC1 99F1 A302"
	$"B5DB D101 4534 5345 727E 78A8 ABA6 ABA6"
	$"A6A7 7841 757B 9A9A 9999 7278 7241 4575"
	$"AAAA 9F4A 4772 7278 754A 7147 7777 4772"
	$"7278 457C 7576 7841 7B75 7BFE 7529 7841"
	$"757B 754A 7676 7B75 7872 757B 7548 757B"
	$"7676 4672 4178 4475 4772 7676 7DA3 7B7B"
	$"757A 757B 7B75 4141 FE3E 003D F73E FF3C"
	$"FFA7 0BA8 584B 7B87 81B0 AFAA AFAA B004"
	$"B189 5883 88FD 9A20 848A 8458 5582 A4A4"
	$"A552 5D84 8489 835B 835D 8181 5D84 848A"
	$"5588 8383 8958 8883 88FE 8329 8958 8388"
	$"835B 8282 8883 8A84 8388 835A 8388 8282"
	$"5D84 588A 5683 5D84 8282 87AC 8989 8387"
	$"8388 8983 5858 FE59 0058 F759 FF5A FEB0"
	$"1569 5DA0 AAA5 D1C1 BCBF BADB DBC6 99B8"
	$"BD9A 9AA3 A3C2 C81E C29B 87B0 7E7E BF71"
	$"9EC1 C1C6 B894 C29F AEAE 9EC1 C2C8 8FBD"
	$"B8B9 C699 BDB8 BDFE B829 C699 B8BD B894"
	$"B0B0 BDB8 C8C2 B8BD BA95 B8BD B0B0 9EC1"
	$"9BC8 8FB8 9EC1 AEAE B5D7 BFBF B8BC B8BD"
	$"BCB7 9999 F1A3 FFDC 00D1 0145 FF56 3D62"
	$"8078 A8A6 ACA6 ABA8 78A7 7679 737C 96AA"
	$"A47B 7979 3F3D 3EAB ABA5 8175 7579 7276"
	$"7C76 7678 7876 7B7B 7578 727B 7B41 7275"
	$"4A72 787B 7B41 7875 447B 757B 75FE 761C"
	$"7C77 7778 727B 4378 7875 7B76 767B 7578"
	$"727B 7BA5 A575 7B7C 7678 7271 3FF7 3EFF"
	$"3FFB 3E0D 7EB2 A856 5669 8781 B0AA B0AA"
	$"AFB0 3481 B182 8983 809A AAA4 8280 8B57"
	$"595A A3A3 A47F 8383 8983 8288 8383 8A8A"
	$"8388 8883 8984 8989 5884 835B 8489 8888"
	$"5889 8356 8883 8883 FE82 1C88 8181 8A84"
	$"8855 8A8A 8388 8282 8883 8984 8888 B1B1"
	$"8388 8882 8984 8458 F759 FF5A FF59 FF5A"
	$"FF59 1887 BAB0 5656 86A2 A5D1 BCC2 BABF"
	$"D1A5 DAAE BDB8 91AB A09B 9E9C 49C8 9AA4"
	$"A57E 7E9A 75B8 B8C4 BFB0 B5AE AEC8 C8B9"
	$"BDBD B8C6 C1BF BF99 C1B8 94C1 C6BD BD99"
	$"C6B8 8FBD B8BD B8AE AEB0 B5AE AEC8 C2BD"
	$"8FC8 C8B8 BDB0 B0BD B8C6 C1BD BDE3 E3B8"
	$"BDB5 B0C6 C1C2 9BF3 A3FF A5FF A302 AADB"
	$"D101 49FF 6853 637A 7878 ABA6 AC96 A8A8"
	$"A77C 7379 7C96 9AAA 957A 7241 3E3E ABAB"
	$"A57C 447B 7247 7675 7C76 4173 7B75 4375"
	$"7247 7575 7878 7575 783F 7575 7872 7B75"
	$"7B75 757B 767C 7676 7D77 3F78 7575 7241"
	$"7B75 7C76 7A75 7147 A5A5 FE7B 0675 76A8"
	$"7878 3F3F FA3E 043D 3E3E 3F3F FB3E FEA8"
	$"FF68 006A FE81 04AF AAB0 9AB0 4AB0 B188"
	$"8389 809A 9AAA 9B81 8458 5A5A A3A3 A47A"
	$"5688 835C 8281 8883 5885 8883 5583 845D"
	$"8383 8989 8383 8957 8383 8984 8883 8883"
	$"8388 8288 8282 8781 578A 8383 8458 8883"
	$"8882 8783 835D B1B1 FE88 0683 82B2 8989"
	$"5858 FA59 0A58 5959 5A5A 5959 5A5A 5959"
	$"FEB0 FF68 1387 9DA5 A5C1 BCC0 ABD1 D1DA"
	$"B3B8 BD91 AB91 A0B6 9D3F C29B A5A5 7E7E"
	$"9A6F 8FBD BF9C B0AF B3AE 9BC3 BDB8 8FB8"
	$"C19E BABA C6C6 B8B8 C698 B8B8 C6C1 BDB8"
	$"BDB8 B8BD AEB3 B0B0 B3AE 9AC8 B8B8 C29B"
	$"BDB8 B5B0 BCB8 C09E E3E3 FEBD 06B8 B0DC"
	$"C6C6 9B9B F3A3 FFA5 FFA3 FED1 0145 5D54"
	$"4878 787D 7773 79A8 7EA8 7EAA AA7E 787C"
	$"7C9B A5A9 7F75 443E 3E7D CEA8 8F75 757B"
	$"7578 7841 7875 7B41 7872 787C 7640 7876"
	$"7678 7275 7C41 7975 7A72 7978 7876 767B"
	$"754A 7575 7B76 7778 7872 7875 7B72 4772"
	$"477E A37E A3A7 A875 7B7C 7672 41FE 3E00"
	$"3DFC 3E00 40F7 3E0D 7CA7 AD57 4A81 8187"
	$"8283 89B0 87B0 5687 B0B0 8681 8888 99A3"
	$"A97F 8356 5959 79CB A48A 8383 8883 8989"
	$"5889 8388 5889 8489 8882 5889 8282 8A84"
	$"8389 588B 8387 8389 8181 8282 8883 5B83"
	$"8388 8283 8989 848A 8388 845D 845D 87AB"
	$"87AB B1B2 8388 8882 8458 5A5A 5958 FC59"
	$"005A F759 1888 B1AF 6155 A5A5 B5B0 B8BD"
	$"D1AA D1AA CACA A29D B5B5 919B A97F 49B8"
	$"8FA3 A364 BA87 6BB8 B8BD B8C9 C999 C6B8"
	$"BD99 C6C1 C6B3 AE9D C9B8 B8C8 C2B8 BE9B"
	$"C8B8 BCBF C4A5 A5B0 B0BD B894 B8B8 BDB0"
	$"B1C6 C6C2 C8B8 BDC1 9EC1 9EAC CEAA CCDB"
	$"DCB8 BDBD B8C1 99A5 A5FA A300 A4F7 A302"
	$"B3DA BF01 3760 6766 607E 7777 7973 A9A3"
	$"A8A3 AAA5 B2B2 7681 9BAB A4A9 7644 3E3E"
	$"83A7 A8A9 754A 757B 4072 7872 7B76 7872"
	$"7245 7676 7872 7D45 7841 7B75 7872 4475"
	$"4772 7878 7C76 757B 7575 7B75 767C 4172"
	$"4178 7544 7972 7278 A37E A8A8 7CA7 757B"
	$"767C 4141 3E3D 3DF0 3EFF A70B D469 686A"
	$"8782 8289 83B1 ABB0 55AB B0AB BABA 828D"
	$"99AA A4A9 8356 5959 7FA4 A4A5 835B 8388"
	$"5884 8984 8883 8984 845C 8282 8984 8855"
	$"8A58 8883 8A84 5683 5C83 8181 8882 8388"
	$"8383 8883 8288 5884 588A 8356 8A84 8489"
	$"AB87 B0B0 88B1 8388 8288 5858 5A59 58F0"
	$"59FF B116 D672 7190 AAB0 B0BD B8D2 CCD1"
	$"CCCA C4D3 D3B0 B991 A1A4 A949 B98F A3A3"
	$"6B91 8788 B894 B8BD 9DC4 C6C1 BDB9 C6C1"
	$"C19D AEAE C9C4 BE8F C89B BDB8 C8C2 8FB8"
	$"9CBF A5A5 B5B0 B8BD B8B8 BDB8 B0B5 99C1"
	$"9BC8 B88F C7C1 C1C6 CEAC D1D1 B5DB B8BD"
	$"B8BD 9999 A5A4 EFA3 FFDA 00E5 013B 1552"
	$"4440 797B 7578 9396 ABA8 A8A9 B8B8 A9B8"
	$"A9AB A5A9 99FD 3E34 4CA1 ADD4 7A7A 7871"
	$"7279 767C 4172 7379 7B75 7278 757B 4475"
	$"7B75 757B 7278 7C76 7A7A 787E 7676 4772"
	$"7B75 7778 7D77 7C7C 7278 757B 76FE 7CFE"
	$"A707 7CA8 9378 727B 753D F43E FF3F FD3E"
	$"FF3C 0DA8 C1D7 5649 4C82 8883 819B 9AAF"
	$"AA0A AAA9 B8B8 A9B9 AAA9 A3A9 9AFD 591F"
	$"51A5 A4CC 8181 8983 848A 8288 5884 8389"
	$"8883 8489 8388 5683 8883 8388 8489 8882"
	$"FE81 1187 8282 5D84 8883 8081 8782 8888"
	$"848A 8389 82FE 88FE B107 88B0 9B89 8488"
	$"8358 FA59 FF5A FD59 FF5A FD59 FF5A 18B0"
	$"C8DB 6A5E 75A6 BDB8 A5BE ABBF B2B2 A9B8"
	$"B8A9 BAAB A09B B2A3 FDA3 3767 B76A 959D"
	$"9DC6 C0C1 C7AE B39B C2B8 BDBD B8C1 C6B8"
	$"BD8F B8BD B8B8 BDC1 C6B3 AE9D 9DA5 AAB0"
	$"B09E C1BD B8A4 A5B5 B0BC BCC2 C8BA BFB8"
	$"BDB5 B5FE DB06 B5D1 BEC6 C1BD B8F9 A3FF"
	$"A5F7 A3FF A502 D1E8 EA01 430D 4552 7879"
	$"757B 787E 7C96 AEB7 B8A9 FDB8 FFAB 0299"
	$"7E77 FE3E 444C A1A7 AD94 7A41 7872 4776"
	$"7678 7842 7376 7B41 7844 757B 7575 7B44"
	$"7547 7276 7695 7A93 787C 7678 7275 7B77"
	$"7877 7776 7678 417B 7545 76A7 A07C A77C"
	$"A1A8 7D78 7775 443E 3E3D F63E FF3F FD3E"
	$"FF3C 0DA8 ADC5 4A56 8182 8388 8187 809A"
	$"AF0B B9B8 A9B8 B8B9 B9AA A99A 7E8A FE59"
	$"2B51 A59F A49A 8158 8984 5D82 828A 8A56"
	$"8383 8858 8956 8388 8383 8856 835D 8482"
	$"829B 819B 8188 8289 8483 8880 81FD 8214"
	$"8A58 8983 5582 B1AB 88B1 88AC B086 8988"
	$"8356 5959 58FC 59FF 5AFD 59FF 5AFD 59FF"
	$"5A18 B0B5 C85F 6AA5 A6B8 BDA5 AA91 ABB8"
	$"C1B8 A9B8 B8BA BAA1 A0A3 8800 CFFE A341"
	$"67B7 646A B59D 99C6 C19E AEAE C8C8 8FB8"
	$"B9BD 99C6 8FB8 BDB8 B8BD 8FB8 9EC1 AEAE"
	$"B69D BEA5 B5B0 C6C1 B8BD A4A5 B0B0 B7B7"
	$"C89B BFBA 8FB8 DBD6 B5DB B5D6 D1A9 C6C5"
	$"B88F F9A3 FFA5 F7A3 FFA5 02D1 D6D8 013C"
	$"FF54 083E 4C79 7376 767B 7676 FEA7 37A3"
	$"A8A6 ABA5 A575 7B72 413E 3E47 83D2 AB99"
	$"847C 7678 7281 9B9D 837B 7B41 7876 7C75"
	$"7B72 7778 727B 7B76 7681 9680 957B 7572"
	$"7875 437B 7576 76FE 7808 4776 7675 7B7C"
	$"A77B A5FE A806 7DA8 A890 443F 3FEF 3EFF"
	$"3F0F 757B AAD6 C457 574E 5A89 8382 8287"
	$"8282 FEB1 43AB B0AA AFAB AB83 8984 5859"
	$"5953 8CCB A49A 8588 8289 847F 9A9A 7F88"
	$"8858 8A82 8883 8884 8889 8488 8882 8286"
	$"9A86 9B88 8384 8983 5588 8382 8281 8189"
	$"5D82 8283 8888 B188 B1FE B004 87B0 B09D"
	$"56F9 59FF 5AF9 59FF 5AFF 591A 8388 B0DC"
	$"C761 6181 8BBD B8B0 B0B3 AEB0 DBDA DACC"
	$"D1BA BFBC BCBA BF43 C29B A3A3 7CB0 9F74"
	$"A18D B3AE C6C1 7590 866B BDBD 9BC8 AEB3"
	$"B8BD C1C5 C6C1 BDBD B0B0 99AD A0B4 BDB8"
	$"C4C9 B88F BDB8 AEAE A5A5 C69E AEAE B8BD"
	$"B5DB BDE3 D1D1 DAB3 D1D1 CF8F F9A3 FFA5"
	$"F9A3 FFA5 FFA3 04B8 BDCA F4D7 013A 5353"
	$"485E 7673 7976 7C76 767C 767C A77E A7AB"
	$"A6AB ABA5 7B41 413E 3E47 72AB ABCA 7E76"
	$"7647 72AB CDCA 9D75 7572 7976 767B 7578"
	$"4172 4775 7576 7C96 9795 7A7B 7578 4075"
	$"7B7B 757C 7693 7E72 7276 7B7B 75A7 A7A5"
	$"7BA8 78FD A8FF 44FF 3FF1 3E13 3D3E 3E3F"
	$"7B75 AAD1 AB55 4A6C 8283 8982 8882 8288"
	$"4282 88B1 87AF AEAA B0B0 B189 5858 5959"
	$"537B A4A4 CC80 8282 5D84 AACC C79A 8383"
	$"848B 8282 8883 8958 845D 8383 8288 9A9B"
	$"9B80 8883 8958 8388 8883 8882 9B87 8484"
	$"8287 8883 FEB1 0288 B081 FDB0 FF56 F959"
	$"FF5A F859 1D5A 5859 8883 B0D7 AF60 559B"
	$"B0B8 BDB0 B5AE AEB5 B0B3 DAAA D0BF BAC1"
	$"C1E4 BFFF 9BFF A33F 7CA1 7474 D287 AEAE"
	$"9EC1 A0C2 B586 B8B8 C2C8 AEAE BDB8 C699"
	$"C19E B8B8 B0B5 ADAE B49B BDB8 C99D B8BD"
	$"BDB8 B3AE BEAA C1C1 AEB3 BDB8 DBDB E3BD"
	$"D1A5 DADA D1D1 8F8F F9A3 FFA5 F9A3 08A4"
	$"A5A3 A3BD B8CA EFBF 0142 4B48 6644 7C75"
	$"757B 7577 7176 7C76 A6AA A5AD BCAE AEAD"
	$"ADA8 4F46 463C 3CAD CFD0 8478 7275 7BAE"
	$"D5F9 A378 7874 7B41 7841 7275 7B76 7678"
	$"4376 7C87 9775 7B75 7B75 7B7C 7675 7D7A"
	$"A47C 7C7B 757B 7BFE A708 7BA3 A8A7 A680"
	$"AA76 7CFE 3E00 40FE 3E00 3DF5 3EFF 4111"
	$"757B 757B ABD2 AD4A 6856 8983 8388 838A"
	$"8582 0688 82B0 B0AB A8B8 FDA9 35AA 5155"
	$"555A 5AA4 C7CC 7F89 8483 88A5 CCF1 9B89"
	$"8982 8858 8958 8483 8882 828B 5D82 888B"
	$"9B83 8883 8983 8888 8281 8981 AA80 8088"
	$"8388 88FE B108 87AB B0B1 B087 B082 88FE"
	$"5900 5AFE 5900 58F5 59FF 581C 8388 8388"
	$"AFD6 B555 718F BEB8 B8BD B8CF CAB0 B5AE"
	$"D9CA C497 A68D 8D97 9741 B25B 8787 A3A3"
	$"6A91 B261 C6C1 B8BD 618D C061 C6C6 B7BD"
	$"99C6 9BC2 B8BD B1B1 D0A7 B0B5 9AAA B8BD"
	$"B7BC B8BD B3AE AFB6 9DC4 9393 BDB8 BDBD"
	$"DADA DBB4 CCD1 DBDB AAD1 B8BD FEA3 00A4"
	$"F1A3 FF99 06B8 BDB8 BDC1 E7D6 012D 3F67"
	$"545D 7B44 7B44 7577 4576 777C 7680 B4D4"
	$"A8D5 CFD3 D3A8 A392 763C 3CAD ADCF 9E72"
	$"4875 7BAE D1CF B272 417B 7578 7278 7844"
	$"757C 7671 7776 767C 7C7B 7475 437B 75FD"
	$"7613 8095 9697 757B 7AA0 7CA7 76A7 A87E"
	$"A77C A4AA 7C75 ED3E 1341 727C 757B 75AB"
	$"D2CF 6957 6C88 5688 5683 8A5E 8234 8388"
	$"8287 BAD0 A3D0 CBD0 D0AA A59C 825A 5AA4"
	$"A4CB 9984 5E83 88A5 C7C7 AA84 5888 8389"
	$"848A 8A56 8387 8285 8A82 8280 8088 8283"
	$"5588 83FD 8213 879B 9A9B 8388 87AC 88B1"
	$"82B1 B087 B188 ABB0 8881 ED59 1E58 8489"
	$"8388 83AF D6D7 7261 A4BD 8FBD 8FB8 CFA8"
	$"B0B1 B3AE A2D3 BF91 B6B1 BFBF 41B2 ADC8"
	$"B0A3 A36A 6AB1 7DC1 9FB8 BD61 8892 72C1"
	$"99BD B8C6 C1C8 C88F B8B6 B1CA CFB0 B090"
	$"90BD B7B7 8EBD B8AE AEB0 B0A2 B6AD AEB8"
	$"BDBC DEB3 DAB0 DBD1 AADB B5CC D1BD B7ED"
	$"A308 99C1 BEB8 BDB8 C1E7 F601 394B 7E78"
	$"4576 757B 757B 7676 7B75 7B75 76A7 A5B4"
	$"B7B6 ADCE D1BF D4AD D7AF ACAD D4AD 7B75"
	$"7B75 AEFC D2A1 757B 7544 7278 7675 7B7B"
	$"7247 757B 4178 7B7B 7575 7B7B 7A7A 7E99"
	$"7C7C 7878 9AA9 7AAA A57B FEA8 0AA7 7CA1"
	$"A8A8 7B75 7272 3F3F F33E FD3F 1372 7876"
	$"7B72 78AA D6A7 807A 5482 8388 8388 8282"
	$"894E 8388 8382 B0AB BAB9 B8A9 CACB B9CC"
	$"A4CC A5A4 A4CC A589 8389 83A5 F2CB 9A83"
	$"8883 5684 8983 8388 8884 5D83 8858 8A88"
	$"8883 8388 8881 8180 9A80 8081 819A A981"
	$"B0B1 88B0 B0B2 B188 ACB0 B089 8384 845A"
	$"5AF1 59FF 581E 8489 8287 8489 B0DC AF89"
	$"8387 B1B8 BDB8 BDB8 B8BC B7BD B8B1 DCC4"
	$"D3C1 C097 B941 A995 956A 8E61 696A 976C"
	$"BCB7 BFBA 61B7 9F69 B8BD B88F C1C6 B9B8"
	$"BDBD C19E B8BD 9BC8 BDBD B8B8 BDBD 9D9D"
	$"87A1 9393 A7A7 9AA9 9DCA E3BD D1D1 DCDB"
	$"B5D6 D1D1 BFBA C1C1 EFA3 FF9B 08C1 C6B8"
	$"BCC1 C6CA F4D2 013B FF89 3591 7C7B 757B"
	$"7545 7C75 7B44 757C 7680 AAAE A8BC BCB0"
	$"D1AD D4D6 D6AD CFD4 AD75 7B75 7BAE D5CE"
	$"A275 7B75 7B78 4175 4A75 7478 727B 7578"
	$"73FE 751E 4A74 757A 95A8 9996 967E 93A9"
	$"B8B4 AA7B A6A3 7EA7 7CA7 7CA8 797B 7547"
	$"783D 3FF3 3EFE 3F14 7179 787C 7678 78AA"
	$"C3A8 8A8A 9C87 8883 8883 5588 830D 8956"
	$"8387 8287 B0B0 AAB8 B8A9 CBA4 FECC 1BA4"
	$"C7CC A583 8983 89A5 CCC7 9B83 8883 8889"
	$"5883 5B83 8289 8488 838A 85FE 8305 5B82"
	$"8381 9BAA FE9A 1587 9BA9 B8BA B088 B2AB"
	$"87B1 88B1 88B0 8289 835D 8959 5AF1 5920"
	$"5884 8A89 8882 8989 B0C8 B093 93C9 B6BD"
	$"B8BD B88F BDB7 BC8F B8B6 B1A2 CAB8 B2A6"
	$"A621 85A9 6A95 8D8D 6A91 976C B7BC BABF"
	$"618D 9A6A B8BD B8BD C699 B894 B8B7 C6C1"
	$"BDB8 C8C3 FEB8 1D94 B7B8 9DB6 B1A1 ADAD"
	$"ACBF A9B8 D3CA BDE4 CCAA DBB5 DBB5 D1A6"
	$"BFBA 9EC6 A2F0 A30A 9BC2 C7C6 BDB8 C6C6"
	$"CAE1 D301 4C48 897E 7AAA 757B 754A 747B"
	$"4475 7B7B 4171 7676 7BA5 A8A3 9276 A8A8"
	$"A4CB D1D1 A399 7841 767C AEFB CFB2 7B44"
	$"7872 757B 767C 7246 7272 7349 7278 7278"
	$"7B75 7B74 9AA8 9A9A A9A9 A6AB B7B7 A3FE"
	$"A80B 7CA6 A8A3 A7A7 767C 7278 7676 F83E"
	$"0040 FD3E 053D 3E41 4179 78FE 7510 7B75"
	$"75A8 ADA8 8A80 80B0 8389 835B 8288 560F"
	$"8388 8858 8382 8288 B1B0 AB9C 82AA AAA4"
	$"FECB 23A5 9A89 5882 88A5 F1C7 AA88 5689"
	$"8483 8882 8884 5D84 8483 5D84 8A84 8988"
	$"8388 829A A89A 9AFE AA03 AFB9 B9AB FEB0"
	$"0B88 B1B0 ABB1 B182 8884 8982 82F8 59FE"
	$"5AFF 5905 5859 5858 8B8A FE83 1B88 8383"
	$"B0B6 B093 899B C8BA BFB8 94B7 BD8F B8BD"
	$"BD9B C2AE AEBD E3D1 CC32 C8B0 B2B2 A4CB"
	$"A6A6 ADA3 C699 B0B5 61B6 9170 BD8F C6C1"
	$"B8BD B0B5 C19E C1C1 B895 C2C8 C1C6 BDB8"
	$"BDB7 9AA8 9A9A ABAB BABF C1C1 CCFE D10B"
	$"B3DA D1CC DADA B8BD C1C6 B0B0 F8A3 02A4"
	$"A5A5 FDA3 FF99 FFC8 FEB8 05BD B8B8 DBE0"
	$"D101 42FF 8908 95AA A57B A575 7B75 7BFE"
	$"75FF 782F 7C76 757C A87E 7C7C 7DA8 857F"
	$"B0B0 B884 A378 7676 AED5 FAA3 7576 7247"
	$"757B 7676 7872 7847 7372 7841 7841 767B"
	$"4475 A89A FEA9 14B8 A5AB A8AE A97E A37E"
	$"A6A6 7EA8 7C76 7C76 4178 757C F13E 0972"
	$"7872 787B 7B7A 757B 7BFE A8FF 8A08 9BB0"
	$"B189 B183 8883 88FE 83FF 8A47 8882 8389"
	$"B087 8888 7FAA 857F A9A9 BA86 B289 8282"
	$"A5CC F29B 8383 845D 8388 8282 8A84 895D"
	$"8382 8A58 8958 8388 5683 A89A A9A9 AAB9"
	$"A9AF AAAF B187 AB87 B1B1 87B0 8882 8882"
	$"5889 8188 F759 FF5A FD59 0984 8984 8A88"
	$"8887 8388 88FE B0FF 9308 B4C8 E4BF E3B8"
	$"BDB8 BDFE B8FF C805 B3AE B8BE D1AA FFB5"
	$"3F88 B285 7F82 82C2 8FEB C6B0 B061 8DBF"
	$"5FB8 B9C1 9EB8 BDB0 B0C6 C1C6 9EB8 B7C8"
	$"9BC6 99B9 BD8F B8A8 9AA9 A9AB BAB9 BFB2"
	$"B8D2 AACC AADA DAAA D1B3 AEBD B899 C6AF"
	$"B5F7 A3FF A5FD A30C C1C6 C2C8 BDBD BCB8"
	$"BDBD DBDB D101 4557 7C86 787E A7A7 A8A8"
	$"7C76 7771 4778 7574 4278 7872 76A7 7E93"
	$"B2D4 B0B0 7A7A 7CA6 A77C A77C DDD4 CFA3"
	$"7878 7379 7575 7847 7676 7278 7278 757C"
	$"7575 7871 81BA A8D5 A6AB ADD3 CFBD 7FA8"
	$"77A7 A8A8 A776 A57B 7676 7A75 7B75 4772"
	$"F53E 1B3C 3B41 727B 757B 7572 7273 7974"
	$"4278 A8A8 808A 8187 B1B1 B0B0 8882 8A4C"
	$"845D 8983 8259 898A 8482 B187 9BAA CCA9"
	$"A981 8188 B0B1 88B1 88D2 C9C7 9B89 8983"
	$"8983 8389 5D82 8284 8984 8981 8883 838A"
	$"837F B9A3 D0AA AFA9 D0CB B888 B082 B1B0"
	$"B0B1 82B0 8882 8287 8388 835D 84F5 5926"
	$"5A59 5884 8883 8883 8282 8389 8356 81B0"
	$"B091 9CA5 AADA DAD1 D1B3 AEC8 C29E C6B8"
	$"B79A C6C8 C2AE DA41 AABE 7297 8585 9D9D"
	$"B5DB DAB3 DBB5 8076 9261 C6C6 B8BD BABA"
	$"C69E AEAE C1C6 C1C6 AFB5 B8B8 C8C2 75AF"
	$"88B6 BABF 97BF B19D ABD1 A5D1 D3D3 DAAE"
	$"E2BD AEAE BCB8 BDB8 9EC1 F3A3 0E9B C2BD"
	$"B8BD B8B7 B7B8 BDC1 98A5 D1D1 0144 2087"
	$"7C93 A8A6 7CA3 7EA7 A777 7772 724A 7578"
	$"7341 7876 7C78 78D4 D4D1 D1B4 7AA7 A775"
	$"FEA7 33D8 D4F9 B278 7279 7375 4872 7276"
	$"7C47 7272 4776 767B 7A78 78BA CDD5 BDA6"
	$"ABB2 CEAE D5A3 A8A7 A77D A37C A77B 7576"
	$"7C75 447B 7572 78F5 3EFF 3C05 7978 757B"
	$"757B FE79 1073 4342 A8A8 A98B 809B B0B0"
	$"88AB 87B1 B18A 158A 8484 5B83 8985 588A"
	$"8288 8181 CCCC CBCB BA81 B1B1 81FE B133"
	$"CDC9 F1AA 8984 8983 835A 8484 8288 5D84"
	$"845D 8282 8887 8A8A B9CC D0B8 AAAF AFCB"
	$"A9D0 ABB0 B1B1 86AB 88B1 8883 8288 8356"
	$"8883 8489 F559 FF5A 058B 8A83 8883 88FE"
	$"891B 8357 56B0 B0B1 9D91 BED1 D9B3 CCAA"
	$"DADA C8C8 C1C1 94B8 C6C2 9BC8 AEB3 FFA5"
	$"FF97 FFA9 2AD3 9DDB DBAD DADB DB7B 76C0"
	$"72C6 C1BD B8BA 95C1 C1AE B39E C1C1 9EB0"
	$"B0BD BCC8 C8AF C2B6 9DBA BF9C BA8D B6CC"
	$"FED1 0DAB CEB3 DABD B8AE B3B8 8FBD B8C1"
	$"C6F3 A3FF C802 B8BD B8FD BD05 B899 98D1"
	$"D1D2 0159 FF89 557A AA7C A1A7 A8A8 7EA3"
	$"A87B 7B74 7B77 7D76 7647 723E 3E96 A1D5"
	$"D5D8 D8B0 B0A9 AA7C A7D9 D9FC B0A8 A87B"
	$"A67C A77B 7B7C 7BA3 7DA7 A7A5 7BA8 A8AE"
	$"B7D7 D7A5 BAA5 7AAB A5D7 D2AB B07C A6A7"
	$"7C79 7375 7C47 7245 7872 7877 77FD 3E00"
	$"3DFA 3E1B 757B 7676 7872 7C76 757B 7341"
	$"3F3F 7CA7 A78A 8A81 B088 ACB1 B2B0 87AB"
	$"54B0 8888 8288 8389 8282 5D84 5959 9AA4"
	$"CCCC CDCD A9A9 AFB0 88B1 CCCC F2A6 B0B0"
	$"88B2 88B1 8888 8988 AB86 B0B0 B188 B0B0"
	$"AFB9 D0D0 A3B8 B38A B0AB D0CB A9AE 88B0"
	$"B188 8983 8188 5D84 5C89 8489 8282 5A5A"
	$"5959 5859 5A5A FD59 2683 8882 8289 8488"
	$"8283 8885 5859 5988 B1AF 9393 9DCA B5D6"
	$"DBDC D1AA CCD1 BDBD B7BD AFB4 B0B0 9EC1"
	$"FFA3 41AB B58D 8D7B 7B85 85C9 CAB5 DB7B"
	$"7BAF 59DA DABD E4B3 DABD BDBE BDCC A9D8"
	$"D8E3 BDD1 D1B8 C1A4 A49B B0E5 C0C1 BCA4"
	$"9FA0 A6B3 D9DB B5BD B8AF B59E C19D C6C1"
	$"C6B0 B0A5 A5FD A3FF A5FD A310 B8BD B0B0"
	$"C6C1 BDB8 B8BD C39B A3A3 B5DB D001 5C0B"
	$"897E 95AB A77C A77C A3A8 7EA8 FEA5 1E7B"
	$"7676 7C76 7278 3D3E 4C7C ADD5 D8D4 D1D1"
	$"A5AA A17C D9FE D2DB 7DA7 A57B A7A7 FDA5"
	$"1FA8 A77C A77B A5A8 78AE A3D2 D7BA AB79"
	$"A4AB A5B1 D2CC ABA7 76A7 7673 7976 7672"
	$"79FE 7203 477D 773F FE3E 0240 3E3D FD3E"
	$"1C77 757B 7C76 7878 767C 7B75 4141 3F3F"
	$"A7A8 A88A 809B B1B1 88B1 88AB B087 20B0"
	$"B1B1 B088 8282 8882 8489 5859 5180 A4CC"
	$"CDC9 CBCB ABB0 AC88 CCF2 C8D1 87AF B188"
	$"FBB1 1FB0 AF87 B088 B1B0 81AF A5CB D0B8"
	$"A989 B2B0 ABA9 CACB A9B1 82B1 8283 8982"
	$"8284 8AFE 840A 5D87 825B 5A59 595A 5959"
	$"5AFE 5927 8A83 8888 8289 8982 8888 8358"
	$"5859 59B1 B2B0 9389 B6CA DBB5 DBB5 CCD1"
	$"AAD1 E3E3 E2BD AEAE B5B0 C1C6 FFA3 1565"
	$"9160 8D7B 76A9 A9C4 CAD6 B57B A580 8AB3"
	$"D9E3 BDDA DAFD E31F D1D0 B2D8 BDE3 D1A5"
	$"B8AD 9FA4 B0A0 BFE4 C1BC 7A9E C3A0 DAAE"
	$"DBB0 B8BD B0B0 C1C7 FEC1 0A9E B5B0 A6A5"
	$"A3A3 A4A3 A4A5 FEA3 11CF B8BD B5B0 C6C6"
	$"B8BD BDB8 9B9B A3A3 DBDC D101 5C03 7E89"
	$"927D FDA7 367C A7A8 A97E A37B A5A7 A77C"
	$"7C7B 743F 3F3E 3E44 6FA5 CDDA FFD8 D8AF"
	$"B5DB D2FB C3A8 79A7 A7AE AED6 B5A1 7CA8"
	$"7EA3 A8A8 78A7 A7C0 D2D7 D2A3 FEA8 1A7C"
	$"A7A9 D0D6 D6AB 7C78 717B 7577 3F78 7272"
	$"7879 7372 7872 413E 3E40 FE3E 0B45 767C"
	$"757C 757B 747C 927B 75FD 3E08 403E 7CA7"
	$"A880 8A9C 87FD B102 88B1 B003 B187 AB88"
	$"FEB1 FE88 2982 5A5A 5959 567D A4CC CDF2"
	$"CDCD A9AE D1C7 F1B9 B082 B1B1 A9A9 CBAA"
	$"AC88 B087 ABB0 B081 B1B1 B8CB D0CB ABFE"
	$"B01A 88B1 A9D0 CCCC AF80 8A83 8883 8A58"
	$"8984 848A 8983 8489 8458 5959 5AFE 590D"
	$"5582 8983 8983 8882 889C 8983 5959 FE5A"
	$"1959 86B1 B087 92BE AAD1 D1DB DBB3 DAD1"
	$"D1AA CCBD E3DA DAB5 B5BD B7FD A324 8FB3"
	$"9AC2 719C 7B7B 8D93 8B81 B678 D1A6 DBDB"
	$"8D8D 8B65 D6B5 D1AA CCD1 D1A5 DADA 8B9F"
	$"A49F CCFE D11A B5DB A9D0 8585 BF91 C8C2"
	$"BDB8 C89B C6C1 C2C8 BDB8 C4C9 C199 A3A3"
	$"A4FE A314 8FB8 BEB8 BEB8 BDB7 B5C8 BCB7"
	$"A3A3 A5A5 A4A3 A9D1 D101 56FF 8957 77A7"
	$"A777 A77C A7A7 A878 A8A8 A57B A67C A7A1"
	$"A57B 4571 3E3E 4444 538B DAD7 D8FE D1D1"
	$"D6D6 FBAE A8A7 A77C AEF5 F8DC 7CA7 A3A8"
	$"A87E A8A8 A77C D2D7 D2B1 A87E A878 A7A7"
	$"AFB8 D6D6 A17C 4178 7544 7771 773F 7841"
	$"7379 4078 4141 FB3E 0B76 7C75 7B75 7B75"
	$"7B76 7C75 43FB 3E0D A2A7 A88A 8A82 B1B1"
	$"82B1 88B1 B1B0 4E81 B0B0 B188 B088 B1AC"
	$"B188 5F85 5959 5656 528A CDCA CDF2 CBCB"
	$"CCCC F1A5 B0AF B188 A9F1 EDD1 88B1 ABB0"
	$"B087 B0B0 B188 CBD0 CBA9 B087 B081 B1B1"
	$"AFB8 CCCC A480 588A 8356 8A84 8857 8A58"
	$"8389 5889 5858 FB59 2A82 8883 8883 8883"
	$"8882 8883 5559 595A 5A59 59AB B1B0 9292"
	$"A5D1 D1A5 DBB5 DADA D1A4 D1D1 E3BD D9B3"
	$"DBD6 E3BD 43A7 CAA3 A38F 8F45 7F71 6D7B"
	$"A5B1 B186 86B6 61D1 D0DB B58D D9B0 92B5"
	$"DBCC D1D1 AAD1 D1DA B39F A49F 7AD1 AAD1"
	$"A5DB DBAF B885 85B5 919B C8B8 8FC8 C2C5"
	$"98C8 9BB8 BD9D C999 99FB A314 B8BD B8BD"
	$"B8BD B8BD B0B5 B78E A3A3 A5A5 A3A3 CCD1"
	$"D101 5369 787E 95AA 79A4 A8A3 7EA8 7BA5"
	$"AA80 A7A3 A8A8 7CA7 7CA1 757B 7C76 7872"
	$"7241 7AA5 D4CF DAFF D8FC D5DA 7EA8 7DA2"
	$"D9D5 FDB0 A8A7 7CA7 7CA7 A37E B1BA D6D7"
	$"CBAF A8A8 7CA7 AA80 7893 ABD2 ABB0 7B75"
	$"7872 757B 757B 757B 7475 7A74 7544 3E3E"
	$"4343 7B7B 7872 7B75 7B75 7B7B 7575 F93E"
	$"0D7C A7A8 7A80 9BB0 89B2 B0AB 87B0 885E"
	$"B1B0 87AF ABB0 B088 B188 AB83 8988 828A"
	$"8484 5881 ABCC C7CD F2CA EFCB D087 B087"
	$"ABCD C9F3 A6B2 B188 B188 B1AB 87B0 B9CC"
	$"CDCB AFB0 B088 B1B0 8781 9BA4 CBA3 A989"
	$"8389 8483 8883 8983 8882 8389 8483 5659"
	$"5957 5788 8889 8488 8388 8388 8883 83F9"
	$"5918 88B1 B083 89B6 CABD E3D3 CEAA D1BD"
	$"E3D1 AAD0 CCD1 D1B5 DBB3 D553 B7BC BCB7"
	$"C8C2 C199 9DC4 9591 6A95 5D87 979D AAD1"
	$"AACC 736E B059 DBDA B5DB B5DB CCAA A6AF"
	$"8586 CBAF D1D1 B3DA CAA2 A5BE 749F 7E83"
	$"BCB7 C6C1 B8BD B7BC B8BD B7B8 C8C2 B88F"
	$"A3A3 9999 BDBD C6C1 BDB8 BDB8 BDBD B8B8"
	$"F9A3 02B5 DBD1 0152 1154 6779 AAA4 79A8"
	$"7EA8 A3A5 7BAA A47E A87E A3FE A704 7C7B"
	$"757C 76FD 78FF AA49 B2D9 D6FF DCFF D1C2"
	$"A8A3 A7A7 D9FF F7C4 A77C A8A7 A17B A8A8"
	$"ABCD D6D6 B8B0 78A8 A776 A595 7E78 B1D2"
	$"D3AA 757B 4178 7544 7B75 757B 447C 7449"
	$"7544 3E40 7A74 7576 7779 757B 757B 907B"
	$"4444 F93E 0DA8 A7A8 5769 80B0 B289 B087"
	$"B0AB B106 88B0 AB87 B087 ABFE B123 8889"
	$"8388 828A 8A89 89B0 B0AA D1C9 F2CE F1C7"
	$"B8B0 ABB1 B1CD F3ED BAB1 88B2 B1AC 87B0"
	$"B0AA FECC 20B8 B081 B0B1 82AB 9B87 81A9"
	$"CBCB A283 8958 8983 5689 8383 8856 8984"
	$"5D83 5659 5A89 FE83 0988 8A83 8883 889D"
	$"8856 56F9 5918 B2B1 B061 729C CAE3 BDD3"
	$"ACD1 CCE3 BDD1 CCAA D1AA CCDB DBDA B353"
	$"BCB7 BCB7 C8C8 C6C6 CACA 709B 6695 628C"
	$"9282 D1CC D1D1 739D A970 DAB3 DCDB D6B4"
	$"D1D1 A0C2 8585 B8B0 A5D1 DAAE C4B6 AAA5"
	$"7A9F A97D B7BC 99C6 B88F BCB7 B8BD 8FBE"
	$"C29F B88F A3A4 C6C1 B8B9 C5C7 B8BD B8BD"
	$"D0BD 8F8F F9A3 02DC DBD1 014D FF45 1772"
	$"787E A3A7 A8A7 7CA7 A77C A7A6 A6A7 7CA7"
	$"76A7 7C75 7B75 7BFD 7511 86D1 D7B6 A8CA"
	$"F4D3 CDAB A57B AEA8 FFD8 CFAE FEA8 297D"
	$"A7A7 7CA7 BFD1 D2D7 76A7 A77C 81AB AED5"
	$"D387 7EA3 D4D4 7676 7872 7B7B 7575 4772"
	$"7872 7B76 783F 7278 75FE 7BFF 7605 7B90"
	$"7878 3E3D F93E FF40 0D7C A6A8 4A4A 7B81"
	$"87AB B1B2 B087 B001 B088 FDB1 0888 B182"
	$"B188 8388 8389 FD83 117F CBD0 AEAA CCEC"
	$"CBD1 AFB1 88AF AAF1 CACB A9FE B029 87B1"
	$"B188 B1B8 CBCB D082 B1B1 887F AAA5 CCCC"
	$"8080 A5CC CC82 8289 8488 8883 835D 8489"
	$"8487 8289 5784 8A83 FE88 FF82 0588 9D89"
	$"8959 58F9 59FF 5A0F 88B1 B05F 5FA0 A5AA"
	$"CCDB DCD8 B2DC DCB5 FEDB 05DA B3DB B0DA"
	$"B303 B8BD BABF FDB8 3E56 A8AD 89B2 D4C2"
	$"9FE2 C1E3 BDB8 B28C 5DB1 8DD1 D1DB B5DA"
	$"DAB5 DB94 A89F A4AE DADB B575 A061 8DA0"
	$"4B89 AD97 97B0 B0C6 C1BD BDB8 B89E C1C6"
	$"C1B4 B0C6 98C2 C8B8 FEBD FFAC 03BD D0C6"
	$"C6F7 A3FF A402 B3DA D101 4FFF 5267 407E"
	$"79A8 7CA7 76A7 7CA7 A17B A67B A7A7 7CA7"
	$"A776 7B75 7B75 7B7B 7A7B D6D1 D2D2 AE84"
	$"B7B2 80A6 7AA5 AECF D8FF CFB3 7EA3 7DA2"
	$"A87C A7A7 B0D1 D2B1 A77C 7676 9BCD D5D5"
	$"D2D2 7E99 D4B2 767C 7247 7575 447B 7872"
	$"7247 7676 7972 7878 757B 7575 A77C 7B7B"
	$"7341 3E3E 3D3D F93E FFA6 0BA8 5656 4C87"
	$"82B0 88B1 82B0 8713 B0AC 87B1 88B1 B188"
	$"B1B1 8288 8389 8388 8887 88D0 FECB 1EAF"
	$"86AF A985 AA87 B1AF D1CA F1CB AE87 AB87"
	$"ABB2 88B1 B1A9 CBCB A9B1 8882 829A FECC"
	$"FFCB 2380 9ACC AA82 8884 5D83 8356 8889"
	$"8484 5D82 828A 848A 8A83 8883 83B0 8788"
	$"8885 5859 5958 58F9 59FF B116 B06A 6A75"
	$"AAA6 D1B5 DBAC D8B6 DCD6 B4DB B5DA DAB5"
	$"DBDA AE08 BDB8 BFBA BDBD BCBD ADFE A843"
	$"B88F 807A 98BC BCE3 B8D9 5D8C B193 AACC"
	$"B5D6 DBB3 DBDB 83A8 9F7A DAB3 B0B0 90C2"
	$"8D8D 9F9F 89A3 9772 B0B5 C19E B8B8 8FBD"
	$"C6C1 C19E B0B0 C7C1 C8C8 B8BD B8B8 D8B2"
	$"BDBD C299 F5A3 FFDA 00D1 0149 2545 5276"
	$"767B 757C A1A5 A5AA A57B A5A8 92A7 7CAA"
	$"AA7C 767B 9078 7876 7675 7BAE F5D8 FFD5"
	$"C2A8 7EFE A72C 7CAE CFFF D8CD 81A7 A7A6"
	$"7CA7 A1A7 7DA5 7BA1 7C76 757B 7BA3 D4D6"
	$"D7D5 D5D2 877C 7675 7B76 7678 7872 7275"
	$"7B76 7CFE A70A 7C75 757C 9378 7876 7672"
	$"41FD 3EFF 3DF9 3E0D 7DB2 A84A 5682 8288"
	$"8388 ACB1 B1B0 0EAB 88B1 B09A B188 B0B0"
	$"8882 889D 8989 FE83 0888 A9F1 CAF1 CBB8"
	$"B087 FEB1 0688 A9CB F1CA D186 FEB1 2288"
	$"B1AC B087 B188 AC88 8383 8888 9BCC CCCD"
	$"CCCC CB80 8882 8388 8282 8A8A 8484 8388"
	$"8288 FEB1 0A88 8383 889D 8A8A 8282 8458"
	$"FD59 FF58 F959 1886 BAB0 5F6A B0B0 BDB8"
	$"B5D6 E3E3 CAC4 BDE3 D1BD DAB3 CACA B3AE"
	$"0FBD D0C6 C6B9 B9B8 BD8D D95D 8C97 82D3"
	$"ACFE DA2C B38D B18C 5DE3 9BDA DAE2 BCDB"
	$"D6DC B6E3 BDD6 B5B9 B8BD BD61 9785 868D"
	$"8D9F 4BB5 B0B8 BDAE AEC8 C8C1 C1B8 BDAE"
	$"B3FE DB0A B5B7 B7B5 C9C8 C8AE AEC2 9BF3"
	$"A302 A9DB D101 4165 5245 3E7C 4475 7C76"
	$"7B7B AAAA A67B A87E A7A7 A5AA A776 7B7B"
	$"7278 7B7B 757B AEAE FFD8 D5D6 B2A8 A77C"
	$"A6A7 B2CF D8FF A6AB 7CA7 7CA7 7C7C 7677"
	$"757B 767C 447B 7575 D4D4 D2B0 AED5 D2D3"
	$"817C 4475 7C76 4172 7847 757B A7A7 7CA7"
	$"7C92 7B7B 767C 7278 7C76 4141 3E3D F53E"
	$"FEA8 0A56 4A4E 8856 8388 8288 88B0 5AB0"
	$"B288 B087 B1B1 ABB0 B182 8888 8489 8888"
	$"8388 A9A9 F1CA CBCC BAB0 B188 B0B1 ADCB"
	$"CAF1 AAB0 88B1 88B2 8888 8081 8388 8288"
	$"5688 8383 CCCC C8A6 A5CC CBCC 8D88 5683"
	$"8882 5884 895D 8388 B1B1 88B1 889C 8989"
	$"8288 848A 8882 5858 5958 F559 FEB0 156A"
	$"5F81 B58F B8B5 B0BD BDCA CAE4 BDD1 AADA"
	$"DAC4 CADA AEFF BD4B C1C6 BDBD B8BD 8D8D"
	$"8C5D 9798 DCD3 DAB3 D9DA 92B1 5D8C BDC3"
	$"B3DA BCE3 B5B5 B0B1 B8BD B0B5 8FBD B8B8"
	$"9797 8059 618D 9FA0 B9B5 8FB8 B3AE 9BC2"
	$"C69E B8BD DADA B5DB B5C8 BCBC B0B5 C2C8"
	$"B3AE 9B9B F3A3 FED1 0132 3148 673E 7675"
	$"7B41 7876 7675 7BA7 A1A7 A87D A87B A57C"
	$"7C74 7975 7576 7672 727C A7AB F3FB DAD5"
	$"B3A9 A47C A1B4 D5FE D876 A775 7BFD 76FF"
	$"7919 7278 4475 7C76 4B76 D8D8 CE9D 7ECA"
	$"D4D8 D5A4 7D77 4A75 7978 7AAA FEA8 0A7D"
	$"A3A8 A57A 7C76 7B74 7972 EF3E 0D7C A7A8"
	$"4A69 4E82 8388 588A 8282 8326 88B1 ACB1"
	$"B286 B088 B188 8884 8983 8382 8284 8487"
	$"B0AA F2EE CDCB A9B1 AB88 ACAA CCF2 CD82"
	$"B183 88FD 82FF 8918 848A 5683 8882 5A82"
	$"CDCD CB9A 80CC C8CC CC9A 8782 5B83 8A89"
	$"81FD B00A 87AB B0B1 8788 8288 828B 84EF"
	$"5918 88B1 B055 7281 B0B8 BD9B C8AE AEB8"
	$"BDDB D6DB DCA9 D1BD E3B5 B549 B9BD B8B8"
	$"B0B0 C1C1 B6DC 97E1 906A 9772 D2CD B5D6"
	$"678D A57B B0DB B8BD B0B0 AEAE BDBD C1C6"
	$"8FB8 B3AE 8CB1 7B7B BA86 89D4 777C 8D54"
	$"B5B0 93B7 CAC9 A5D1 DBDB DAB3 CCD1 E3BC"
	$"B5B0 BDB7 C8C2 EFA3 02B5 DBD1 0143 3B55"
	$"673E 7C7B 7572 7976 7B7B 757C 7CA8 7CA8"
	$"A3A5 7BA1 7679 737B 7B76 7C47 4176 7681"
	$"9CDB D6D5 D578 7E76 7CAE F6D4 B17C 767B"
	$"7576 7C76 7C73 7346 7275 7BFE 7622 91D8"
	$"D4CF 887E 7ED8 D8D1 D592 7D75 A678 A3AA"
	$"AA7D A877 A8A8 7EA5 7B92 7C7B 7541 413E"
	$"40F7 3E00 3DFC 3EFF A70B A858 694E 8888"
	$"8384 8B82 8788 3083 8888 B288 B0AB B188"
	$"AC82 8983 8888 8288 5D58 8282 809A CEC9"
	$"CBCB 8187 8288 A5EC C9A7 8882 8883 8288"
	$"8288 8383 5D84 8388 FE82 229C CDC9 CC85"
	$"8080 CCCC C7CC 9C87 83B2 89B2 B0B0 87B0"
	$"81B0 B087 B188 9C88 8883 5858 595A F759"
	$"0058 FC59 FFB1 16B0 6272 81B5 BDB8 C2C8"
	$"AEB3 BDB8 B5B5 DCB5 D1CC E3BD D6B0 4BBD"
	$"B8BD BDB0 B59E 99B1 B16B 866B 6697 97A5"
	$"AAB0 B561 B176 4EB5 B0BD B8B0 B5AE B3B8"
	$"B89E C1B8 BDAE AEB1 C97B 76BB 7189 897C"
	$"7C88 8DC8 B5B7 E2C9 EED1 D1B5 DBAE DAD1"
	$"AAE3 BDC8 B5BD B89B 9BA3 A4F1 A3FF DB00"
	$"D101 2C1C 4855 4676 7247 7676 4772 767C"
	$"7776 7CA0 A57B A8A8 7878 777C 757B 757B"
	$"75FE 7B3B 7C76 9BCD D7D4 D287 7C76 D6D6"
	$"D1B0 7374 767B 7872 4572 7941 767C 7871"
	$"4679 7FA4 DAD6 A17C 7B75 80CC D9D5 D6C4"
	$"AB80 A8A3 7BA5 A87D A7A7 7CA7 A37E 7575"
	$"ED3E FF3F 0D7D A7A8 4A58 5582 845D 8282"
	$"5D84 8211 8883 8288 ABB1 88B1 B189 8983"
	$"8883 8883 8883 FD88 3A82 9ACC CCC9 CB80"
	$"8882 CCCC CBA9 8384 8388 8A84 5C84 8B58"
	$"8288 8983 5B89 7FA4 CDC9 A580 8883 7ECB"
	$"CDC9 CCBA B187 B0AB 88B1 B086 B1B1 88B1"
	$"AB87 8383 ED59 FF5A 1887 B1B0 5562 87B0"
	$"C19E B0B0 9EC1 B0B5 AFAE B5D6 E3BD D2D2"
	$"C6C6 06B9 BDB8 BDB8 BDB8 FEBD 3BB3 AE90"
	$"C27A 769F 4BB5 B085 85A8 83B8 B9B9 BDC8"
	$"C29D C1C8 9BAE B3C6 C09B C47F A46A 66B7"
	$"93BD B87F CB73 6E85 70CA A2D1 CCBD E3D1"
	$"A9DA DAB5 DBCE ACB8 B8EB A302 AAD1 D101"
	$"2CFF 5459 707C 7278 7C76 7278 7676 7C76"
	$"7D76 7BA5 7DA2 7278 767C 757B 757A 757B"
	$"A5A5 A7A7 B0AB D8D8 D2D2 7675 D6D6 CD86"
	$"7979 4475 4178 7278 7278 7676 4178 7272"
	$"85CB FBDA A681 757B AFAA D9FF F7D6 B4A4"
	$"7EA8 A57B A3A8 7DA7 A17C A878 4444 ED3E"
	$"FF3F 0DA1 A7A8 5757 7C88 8489 8882 8489"
	$"8212 8288 8289 8288 B187 AB84 8982 8883"
	$"8883 8783 88FD B139 AFAA CDCD CBCB 8281"
	$"CCCC C77F 8989 5683 588A 8489 848A 8282"
	$"5889 8383 85CB EECD AA86 8388 AEA9 CDF3"
	$"EDCC BAAA 87B0 B188 ABB0 89B1 AC88 B081"
	$"5656 ED59 FF5A 18AA B1B0 6161 AAB5 C1C6"
	$"B5B0 C1C6 B0B0 B3AE B6B0 BDE3 AACC C1C6"
	$"45B8 BDB8 BDB8 BCB8 BDE3 E3DA DAA5 A07B"
	$"7B9F 9FB0 AF85 85A3 56BD BD8F B89B C8C1"
	$"C6C2 C8AE AE99 C6BF BF85 CB90 6ABC 99B8"
	$"BDAF A973 9DA9 85D3 C4AA D1E3 BDCC D1B4"
	$"DAD6 B5D3 A78F 8FEB A302 CBD1 D101 27FF"
	$"4525 3E46 7C76 4178 7872 7A49 777D 7278"
	$"7576 757B 7872 7C92 7872 7B75 7B75 A17C"
	$"A97E A8A8 BACD FED8 FDD6 30CB 8578 7879"
	$"737B 757B 4475 7B75 7B7D 787B 7BA4 F6D8"
	$"D8A3 A9A7 A77B A7B8 CBDA FBD1 C4A8 7EA8"
	$"A87D A7A1 A77B 7B75 7B3F 3D3D EC3E 0D7C"
	$"A7A8 4A4A 4E55 8882 588A 8984 891B 5C81"
	$"8784 8981 8283 8889 8488 9C89 8488 8388"
	$"83AC 88B1 87B0 B0B9 CCF2 FCCC 16CB 8581"
	$"8189 8388 8388 5683 8883 8886 8188 889B"
	$"ECCD CDAB FEB1 1687 B1B8 CBCD EEC7 BAB0"
	$"87B0 B089 B1AC B188 8883 895A 5958 EC59"
	$"1888 B1B0 5F5F 8187 B3AE 9BC8 C6C1 C69E"
	$"AEB3 C4C9 ADAE B8BD C6C1 11B5 C8C6 C1BD"
	$"B8BD B8D6 B5D2 AAD1 D1AF C2A6 7CFD 852F"
	$"D48F A7A7 BDB8 BDB8 BD8F B8BD B8BD A9A5"
	$"BDBD 55B1 7B7B CCD2 DADA B4DB B8CB 6A90"
	$"7F70 D1AA D1D1 B6DB D6DB BDBD BABF A3A2"
	$"EBA3 02B5 DBD1 0127 2752 5170 7C76 7678"
	$"7273 4774 7477 7878 4076 7C7B 7541 7876"
	$"7C79 7875 7C75 7B7C A8A3 A8A8 78B0 BAD8"
	$"D8FE D630 D7B8 AEA8 A879 A4A6 7BA5 A5A6"
	$"7AA5 7BA3 A8A5 A5DA D5FF D8A8 7EA7 7CA7"
	$"A785 B8DA FFD6 FCA3 A878 A8A7 767C 7C75"
	$"757B 753F 40EB 3E0D A7A6 A856 557C 8882"
	$"828A 8485 5D83 5083 8182 8958 8288 8883"
	$"5889 8288 8A89 8389 8388 88B2 ABB0 B081"
	$"AFB9 CCCC CBCC CCCD B8AF B0B0 89B2 B288"
	$"B1B1 B287 B188 ABB0 B1B1 D1CC F3CD B087"
	$"B188 B1B1 85B8 CDF2 CCF2 ABB0 81B0 B182"
	$"8888 8383 8983 5A5B EB59 18B1 B0B0 6A69"
	$"AAB5 AEAE C8C2 C29E C1C1 AEAF C99D AEB3"
	$"BDB8 99C6 43B0 B5C7 C6B8 BEB8 BDB5 DCCC"
	$"D1D1 A5A5 AF7C 7C84 8585 86C1 B8D3 D3BD"
	$"E3E4 BDE3 E3E4 BCE3 BDCC D1E3 E392 8DA6"
	$"7BD1 AADA B3DB DB85 B86A 9585 AFCC D1A5"
	$"D1DB B0B5 B5B8 B8BF BAE9 A3FF DB00 D101"
	$"3259 4552 4676 7941 7D77 4772 7B75 4778"
	$"7278 7273 7544 3E3D 3E3E 7576 7878 757B"
	$"A7A7 7CA7 86D2 D4B2 BACC FED8 FCD6 B4A5"
	$"7BA5 AFA9 D6D6 A681 A8A8 7DA7 A478 A878"
	$"D9FB D1DA A7A7 A3A8 AF9A B2B2 A9CB D6F7"
	$"A6AB A776 7973 7872 767C 4279 FE3E 0040"
	$"EE3E 0E40 7CA7 A84A 5655 828A 5887 825D"
	$"8488 4E83 5D89 848A 8485 8356 5A59 5A5A"
	$"8383 8A8A 8388 B1B1 88B1 85D1 CCAA B8CB"
	$"F2CD F2CC BAAB 88B1 AFA9 CCCC AA86 B0B0"
	$"89B1 B288 B081 CDEE C7D1 B1B1 ABB0 AD98"
	$"AFAF A9CB CCED AAAF B182 8983 8984 8288"
	$"5689 FE59 005A EE59 195A 88B1 B05F 6A87"
	$"B0C7 99B5 B09E C1BD B89E C6C2 C8C1 C2B8"
	$"8FA5 A4FF A541 B8B9 C8C8 B8BD DBDB B3DA"
	$"7BC9 9772 B0C3 A379 AD83 D3C4 BDE3 AFA9"
	$"8585 C4A2 D1D1 B4DA E3BC D1A5 6990 8892"
	$"DBDB CCD1 A590 9C9C A9CB 85A9 BCC1 DAAE"
	$"BDB8 C6C1 B0B5 8FBD FEA3 00A4 EEA3 03A4"
	$"B5DB D101 2713 5245 5E7C 7278 7777 7278"
	$"757B 7272 4178 7847 7544 FD3E FF44 3F41"
	$"727B 75A7 7CA7 A7AB CCD4 D4B0 ABD8 D8D6"
	$"DB80 AAA5 7BAF CBD6 D6B5 AB7E A3A7 A779"
	$"A4A8 A8DA FFD1 C37C A77E A8AA CCCE CEB0"
	$"AFD6 C496 7C7C 7673 7972 4776 7673 73EB"
	$"3E01 403E FEA7 0A56 4A6C 8884 8982 8284"
	$"8983 0888 8484 588A 895D 8356 FD5A FF56"
	$"2C58 8488 83B1 88B1 B1AA CBCD CDAE A9CD"
	$"CDCC D187 B0B1 88AF CBCC CCB9 AF87 ABB1"
	$"B189 B2B0 B0CD F2C7 B988 B187 B0A8 FECB"
	$"0FB0 AFCC BA9A 8088 8283 8984 5D82 8283"
	$"83EB 591A 5A59 B1B1 AF6A 5F9B B5C1 C6B0"
	$"B0C1 C6B8 BDC1 C19B C8C6 9EB8 8FA5 A5FF"
	$"A5FF 8F3F 9BC2 BDB8 DBB5 DADA A1C3 9898"
	$"A6A0 7979 8389 A2CA E3BD AFCB 8585 D3CA"
	$"AACC DADA BDE3 D1D1 6A95 8878 B5DB AAD1"
	$"9FC3 BABA B0AF 8570 AD93 B3AE B8BD C19E"
	$"B0B0 B8B8 EBA3 04A4 A3DB DBD0 011B 1449"
	$"663E 767B 753F 777B 7572 417B 757C 7675"
	$"763E 3E3D F83E 1276 7C92 7CAF CBD6 D6AD"
	$"B1A8 A2A8 A3A5 79AA AAB2 FED4 22A3 A8A7"
	$"A77C A7A8 A381 A6FF FFCE B2A3 A8AB A6FF"
	$"FCDC FCD6 AF7F 7F71 4777 7D47 727C 7641"
	$"FE78 0372 413E 3DED 3E0D 77A7 A849 674E"
	$"8288 8359 8A88 8384 0958 8883 8882 8384"
	$"5A5A 58F8 5912 8288 9C88 AFCB CCCC AAAE"
	$"B0AA B0AB B389 B0B0 AAFE CC29 ABB0 B1B0"
	$"88B1 B0AB 85AA EDED CBAF ABB0 AFAA F1EF"
	$"CEEF CDA6 7F7F 835D 8187 5D84 8882 588A"
	$"8989 8458 5958 ED59 1881 B0B0 5571 81B0"
	$"BDB8 9DC9 BDB8 C29B BDB8 BDB8 B7B8 A5A5"
	$"A3A3 F9A3 12B0 B5C8 B5AF CB85 85A1 A6D1"
	$"CBD1 CCE4 BDCA CA72 FE97 00CC FED1 23B3"
	$"DAD1 CC97 BA77 77BA 9CCC D1BF BA8C 8762"
	$"8785 597F 7FC0 9EAE B39E C1B3 AE9B C8C6"
	$"C6C2 9BEB A302 A4D1 D101 1315 5567 3E7C"
	$"4475 7771 7544 7878 757B 7645 7B7B 3D3E"
	$"3E40 F93E FE76 0E7C 7FA9 D6D6 CEAC 7EA8"
	$"7EA8 79A4 96AA FED4 28C1 A87E A27D A777"
	$"A87E ABCD FFE0 CEB2 A87E 7CA6 D8DC FCDC"
	$"D2D6 CBA9 7278 7777 7278 7676 7872 4172"
	$"7841 EB3E FFA7 0BA8 5668 4E88 5683 8A85"
	$"8356 8A0A 8A83 8882 5589 8959 5A59 5AF9"
	$"59FE 820E 887F A9CC CCCB A987 B087 B089"
	$"B29C B0FE CC28 B9B0 87AB 87B1 83B0 87AF"
	$"D1ED CFCB AFB0 8780 AACA CEEF CEC9 CDCB"
	$"A984 8981 8184 8982 828A 8458 848A 58EB"
	$"59FE B015 6172 81B5 8FB8 C9C4 B88F C8C8"
	$"B8BD B88F BCBC A4A5 A3A4 F9A3 FEB0 0EB5"
	$"7FA9 8585 C3A0 AAD1 AAD1 BDE3 B7CA FE97"
	$"2882 D1AA CCAA DAAF D1AA BFE0 7753 BA9C"
	$"D1AA 91BA 5D62 8762 8085 CBA9 C1C6 AEAE"
	$"C1C6 AEAE C8C2 99C1 C89B EBA3 FED1 0123"
	$"FF45 0F5E 7C74 7B72 457B 7578 7244 7B72"
	$"7874 73FD 3EFF 3F45 3D3E 3F3F 3E3E 4279"
	$"7772 7B75 ADCE D2B1 767D 757B A37E AEA8"
	$"D4D9 CBAF A7A7 A9A8 A7A7 7CA2 81C8 D1FB"
	$"9276 767B 7AA5 FCDD D1AA FBD1 D8D4 D5A3"
	$"7C52 7776 4578 757B 7872 7241 3F3F EF3E"
	$"FF3F 0D7C A7A8 4A4A 6C88 8288 845C 8883"
	$"8A06 8456 8884 8984 83FB 591B 5859 5A5A"
	$"5959 5689 8884 8883 A9CB CBA9 8289 8388"
	$"AB87 AFAA CCD1 CBAF FEB1 24B0 B1B1 88AD"
	$"85CC C8F2 9C82 8388 80AA EFCF CBA4 F1C7"
	$"CDC9 CB99 8056 8382 5C89 8388 8984 8458"
	$"ED59 FF5A 1488 B1B0 5F5F 9BB5 B7BD C29E"
	$"BDB8 C8C2 8FBD C1C6 B9B8 FDA3 F9A3 3D8F"
	$"BDC5 C1BD B897 BA9F 7AB0 B6B8 BDCC AAB8"
	$"B295 9BCB AFDA DAD2 D1DA DAB5 D797 DB86"
	$"B5C8 B0B9 BD9D C587 63A8 7EB6 887B 7697"
	$"6091 6AB1 B09D C6B8 BDC6 C1C2 9BEB A302"
	$"B5DB D101 2CFF 520F 4676 7B75 7872 757B"
	$"4178 7575 4772 7942 FE3E 4940 3F3F 3E3E"
	$"3F3F 3D3E 7373 7841 757B 83A7 ABD2 927C"
	$"747A 7878 7EA3 D4AD 9A7F 7646 7878 4676"
	$"7C76 7C7C B4AF 7C7D 4474 8095 D8D8 D187"
	$"8AD5 D8D8 D5D5 C896 7C76 7272 7B75 7247"
	$"7841 3F3F 3DF0 3E0F 3F40 A7A7 A856 5655"
	$"8288 838A 8483 8858 068A 8383 5D84 8956"
	$"FE59 005A FD59 FF5A 4258 5983 8389 5883"
	$"887F A4A4 CB9C 8882 8781 8180 A5CC A49A"
	$"7F82 5481 8154 8288 8280 80AB A588 8956"
	$"8286 9BCA CACB 8081 CCCD CDCB CBCC 9A88"
	$"8284 8488 8384 5D8A 5859 5958 F059 165A"
	$"5BB1 B1B0 6A6A 87B0 BDB8 C8C2 B8BD 9BC8"
	$"B8B8 9EC1 BD8F FEA3 00A4 F9A3 FFB8 3BC6"
	$"99B8 BD6B 9174 9FC8 B5B7 BCA5 A589 AD95"
	$"6A9A 7FAE 85A5 A585 AEB5 B091 9165 5FB5"
	$"B68F B7A3 B75D 5DA8 5738 8D7B 7B97 97DB"
	$"ABB5 B0C1 C1BD B8C1 9EC8 9BEB A3FF DB00"
	$"D101 1C13 5245 5F7C 7544 7C76 4772 7575"
	$"7878 7676 7940 3D3C F93E 323D 3E71 4576"
	$"7678 7278 A3CF AEA4 7F7A 757C 76AD CFAB"
	$"A578 4775 7C78 787A 7478 7377 7776 7674"
	$"7475 7B7C A6DC FFA3 7E7B 7599 CBD1 FED6"
	$"06AA 867B 4A75 447B FE75 0040 EC3E 0D7D"
	$"A7A8 564A 6B88 8356 8882 5D84 8308 8389"
	$"8982 828B 585B 5AF8 593B 5A85 5E82 828A"
	$"8481 ABCB A9A4 7F88 8388 82A9 CBAA A489"
	$"5D83 898A 8A87 8288 838B 8B82 8284 8483"
	$"8980 AACE F1A5 8088 839B CCC7 CCCB CBA4"
	$"7F88 5B83 5688 FE83 005A EC59 1587 B1B0"
	$"6A5F 99B3 B88F B5B0 9EC1 B8B8 C6C6 B0B0"
	$"C799 A4FE A3FB A340 A4A5 CAA8 AEAE C8C2"
	$"A5CC B18D A47F BEBA B5B0 8DB0 A09A C69E"
	$"B8BE C8C8 BCB7 BCB8 D1D1 B0B0 C2C2 B7BC"
	$"91BA 628C AD89 BDB8 9ACB 888E 8B8B 7E56"
	$"BD94 B88F BDB8 BABA A4EC A302 AAD1 D101"
	$"2C13 6445 5F4C 757B 7676 7871 7B7B 7241"
	$"767C 7240 3C3C FC3E 0040 FC3E 3C77 767C"
	$"7841 7E78 AEA8 A99A 7544 7C92 ADA8 A681"
	$"7272 7B75 7241 757B 4273 4471 767C 497A"
	$"7C75 7C96 FCD8 A384 757B 7E7E A4D5 D6AF"
	$"D1D1 9075 747B 7B75 7B7B FE3E 0040 EF3E"
	$"0DA2 A7A8 684A 6B5A 8388 8282 8983 8808"
	$"8884 5882 8884 585A 5AFC 5942 5A59 595A"
	$"5A59 8A82 888A 5887 81A9 A3A9 9A83 5688"
	$"9CA9 A4A5 7F84 8488 8384 5883 8856 835F"
	$"8582 885D 898A 8380 9AEF CAA5 8683 8880"
	$"809B CCCB A5CB CB9D 8382 8888 8389 89FE"
	$"5900 5AEF 5914 ABB1 B07B 5F99 89B8 BDB0"
	$"B0C6 C0BD BDC1 99B0 B5C1 99FD A3FE A342"
	$"A4A3 A3A5 A5A3 CFAE B3C8 9BAA A58D 88A9"
	$"9ABA 91B5 C88D 879B 75C1 C1BD B8C2 9BB8"
	$"BD8F B8AA CCB0 B59F C8BD B791 AB87 5DAD"
	$"8FB8 BD7F 7F55 8D8B 5FA8 A8D0 B8B7 BDBD"
	$"B8BF BFFE A300 A4EF A302 CCD1 D101 290F"
	$"4955 407E 757B 3F78 757B 4475 7879 7347"
	$"FC3E 0040 FE3E 003D FD3E 3F77 7D72 4076"
	$"7C75 7B7E A4A7 AD78 7E7E 99A8 ADA3 7E7B"
	$"7578 417B 767B 7578 7275 7B74 7B76 7644"
	$"7B7E 93D8 D9CB 8575 7578 727B 75A5 CDD4"
	$"ADCB 7F78 7275 4A72 7275 44EF 3EFF 3F0D"
	$"7CA7 A849 564C 8783 8857 8A83 8856 0483"
	$"898A 855D FC59 005A FE59 0058 FD59 4182"
	$"8784 5882 8883 8880 A5A4 A981 8780 9AA3"
	$"A8AB 8788 8389 5888 8388 8389 8483 8882"
	$"8882 8256 8887 9BCC CDCB 8583 8389 8488"
	$"83A4 CCCC A5CB 7F89 8483 5B84 8483 565A"
	$"5AF1 59FF 5A12 88B1 B055 6175 AAB8 BD9A"
	$"C8B8 BD8F B8C6 C7C2 9EFC A300 A4F9 A341"
	$"B0B5 C199 B0B5 B8BD 89AE 9197 A5AA 89A3"
	$"888C CCAA BDB8 C699 BDB9 BDB8 C9C4 B8BD"
	$"B7BD AEAE 8FBD AABE 7273 CB85 B8B8 C6C1"
	$"BDB8 9AC2 976C CB7F C6C1 B894 C1C1 B88F"
	$"A5A5 EFA3 02B5 DBD1 0118 0F55 6872 787B"
	$"7578 7244 757B 753F 7278 72F3 3EFF 77FF"
	$"78FF 763A 7B75 7EA8 ADA8 A378 99A8 A8A9"
	$"7878 757B 7278 757B 7543 7978 7544 7B75"
	$"767C 7575 46A3 FAD9 A47F 4A75 783F 757B"
	$"8181 ACD4 9A7F 7247 7575 7847 7544 3FF0"
	$"3EFF 3FFF A70B A856 697B 8188 838A 8456"
	$"8388 0483 5784 8984 F359 FF82 FF8A FF82"
	$"3B88 8380 AAA9 A5AB 819A AAA3 A481 8183"
	$"8884 8983 8883 558A 8983 5688 8382 8883"
	$"8352 ABEE CDA4 7F5B 8389 5783 887F 7FA4"
	$"CC9A 7F84 5D83 8389 5D83 565B 5AF1 59FF"
	$"5AFF B110 B061 73A0 A5BD B8C8 C28F B8BD"
	$"B898 C1C6 C1FB A3F9 A3FF B0FF C6FF B03B"
	$"BDB8 89B2 9792 CCA5 A3B2 8889 A5A5 B8BD"
	$"C1C6 B8BD B88F CAC9 B88F BDB8 AEB3 B8B8"
	$"7ACC 9873 A47F 94B8 C698 B8BD 7575 6B97"
	$"9A7F C19E B8B8 C69E B88F A6A5 EFA3 FFDB"
	$"00D1 0112 FF45 0D3A 7974 447A 747B 7B72"
	$"787B 757B 75F3 3E3F 4178 4475 7778 497A"
	$"7F7A A4A9 9B9A 9AA9 A67C 757B 4179 4576"
	$"7B44 757B 7676 7878 7342 7841 7B7B 7C96"
	$"DAFB A181 757B 767C 829E 9E84 817C 787E"
	$"767C 7278 7676 7B75 EE3E 0E40 7CA7 A84A"
	$"4A50 8982 5689 8388 8884 0489 8883 8883"
	$"F359 3F58 8A56 8388 8951 8186 81A4 A99B"
	$"9A9A A9AA 8083 8858 8B55 8288 5683 8882"
	$"8289 8983 5689 5888 8880 9ACD EEA4 8583"
	$"8882 887F 9B99 7F86 8081 8782 8884 8982"
	$"8288 83EE 5913 5A87 B0B0 5F5F 8ABD B78F"
	$"C6C1 BDBD C1C6 BDB8 BDB8 FBA3 F9A3 3F9B"
	$"C88F B8C5 C670 9DA9 A5A4 A99B 9A9A A9BC"
	$"93B8 BD9B C88F B8BD 8FB8 BDB0 B0C6 C6B8"
	$"8FC6 99BD BD91 AB6A 90B5 97B8 BDAE B360"
	$"7E7D 6199 93A5 AAB0 B5C1 C6B0 B0BD B8EE"
	$"A303 A4B6 DCD3 0117 FF52 0D3A 7976 7B74"
	$"4975 7578 4175 7C75 43F7 3E00 40FE 3E0B"
	$"7279 757B 4172 95A5 957A 7F99 FD9A 1F96"
	$"7C7B 7578 7276 7C74 757B 7576 7C41 7273"
	$"7972 7875 757C A6D6 DAA6 7C7A 7576 76FD"
	$"CF0B A1A7 9379 7676 7247 767C 757B EE3E"
	$"0E3D A7A7 A856 5650 8983 8883 5C83 8389"
	$"0458 8389 8355 F759 005A FE59 0B84 8B83"
	$"8858 849B AB9B 817F 99FC 9A25 8088 838A"
	$"8482 8882 8388 8382 8858 8483 8984 8983"
	$"8380 AAC9 CDAA 8087 8382 82CC CCCB CBA5"
	$"AB9B FE82 0584 5D82 8883 88EE 5900 58FE"
	$"B0FF 6A0D 8ABD B9BD C19E B8B8 C699 B8BE"
	$"B88F FBA3 FDA3 00A4 FEA3 0BC2 C8B8 BD99"
	$"C1B6 C4BE A57F 99FD 9A1F AD93 BDB8 C8C2"
	$"B8BD B7B8 BDB8 B0B5 99C1 B8BD C1C6 B8B8"
	$"91BA 666A BA91 BCB8 AEAE FDB1 0BB7 BDBE"
	$"A6B0 B0C1 9EB0 B5B8 BDED A3FF DC00 D301"
	$"180E 4564 4078 7872 7777 7841 747B 7544"
	$"78F2 3E43 7544 7B75 7B75 7C97 997E 7D93"
	$"A99A A99A 757B 7378 767C 7841 7B7B 4178"
	$"4772 7B7B 4772 7B75 4772 8095 D6FF A37F"
	$"447B 85A3 D6D6 ABD3 D4AD D2B1 AB9A 807F"
	$"7A80 4273 7B44 3F3F F53E FF3F FF3E 0D80"
	$"AAA9 4A68 4C81 8984 8181 8958 8203 8883"
	$"568B F259 4183 5688 8388 8380 9B9A 8086"
	$"9BA9 9AA9 9A83 8885 8982 8889 5889 8958"
	$"895D 8488 885D 8488 835D 8487 9BC9 F2A4"
	$"7F56 8885 A4CC CCA5 CCCC A5CB A9A9 9880"
	$"7F81 8756 8389 56EF 5911 86B0 B15F 7B75"
	$"A5C6 C1AE AEC6 99B7 BDB7 8FD0 FAA3 F9A3"
	$"41B8 8FBD B8BD B891 ACA3 89A9 BEA9 9AA9"
	$"9AB8 BDC2 C6B7 BCC6 99BC BC99 C69F C2BD"
	$"BD9E C1BD B89E C1AA BE66 95AD 898F BD8F"
	$"AD83 8373 9E97 6C9F 7AA0 9080 7F9D A28F"
	$"B8BF 91EF A302 AAD1 D201 200D 5245 7878"
	$"4178 7D77 7872 7B75 7B75 F63E 013D 40FE"
	$"3E0B 7B75 757B 757B 7CA6 99A8 7878 FD9A"
	$"337A 7478 3F76 4472 7875 7578 7172 7875"
	$"7572 7844 7578 724A A4DA D6A3 8575 757F"
	$"A3D6 D6AB ABD4 ADAB D2A5 ABCB AA95 9573"
	$"7975 753F 3FF5 3EFF 3FFF 3E0D A5AA A856"
	$"4A81 8158 8987 8189 8488 0283 8983 F659"
	$"0158 5AFE 590B 8883 8388 8388 80AA 9AAA"
	$"8181 FD9A 3187 8289 5782 5484 8983 8389"
	$"8384 8A83 8384 8956 8389 8453 ABCD C9A4"
	$"8583 837F A4CC CCA5 A5CC A5A4 CBA3 A9CB"
	$"AA9B 9B83 8983 83EF 5910 ABB0 B06A 5FA5"
	$"A599 C6B3 AEC6 C1BD B8BC B7F9 A3FD A300"
	$"A4FE A30B BDB8 B8BD B8BD 91BA A3B2 A5A5"
	$"FD9A 31BC B7C6 98B7 8EC1 C6B7 B7C6 C0C2"
	$"C8B8 B8C1 C68F B8C6 C17B CC6A 66AD 8FB8"
	$"B889 AD83 8373 7397 6C74 9F9B A0CB AAB6"
	$"B6B8 BDBA BAEF A302 CCD1 D101 290F 4853"
	$"3E7C 7C76 4178 447B 7247 757B 3E3D F93E"
	$"003D FC3E 0F44 7B7B 7541 7878 9397 7C7C"
	$"767B 7572 78FE 7530 7B80 957A 7A73 4775"
	$"7B75 754A 7578 7175 7B75 7B7B A5D8 FFA6"
	$"7B78 477E 94D4 D4A4 8578 A3A5 95CD A5AB"
	$"A5AB 9BA9 8A78 7278 41F8 3E00 3DFB 3E0D"
	$"7CA7 A84A 554E 8888 8258 8A56 8884 045D"
	$"8388 5958 F959 0058 FC59 0F56 8888 8358"
	$"8A81 9B9B 8088 8288 8384 89FE 8330 8887"
	$"9B81 8185 5D83 8883 835B 838B 8483 8883"
	$"8880 AACA F1AA 7F89 5D87 9CCC CCA4 8581"
	$"ABAB 9BCC A4AA A4A9 99A9 8A89 8489 58F8"
	$"5900 58FB 5910 88B1 B055 6081 B5B3 AE9B"
	$"C88F BDC1 9EB8 BDF9 A3F9 A30F 8FBD BDB8"
	$"9BC8 A5BE AE93 B3AE BDB8 C1C6 FEB8 30BD"
	$"A2B6 9D9D C29E B8BD B8B8 94B8 C8C2 B8BD"
	$"B8BD 91BA 5D8C BA91 C69E AABF 8D8D A485"
	$"A5CC C4B6 C29A A09A A091 A98A C6C1 C699"
	$"F1A3 02B5 DBD1 0133 0254 663E FE76 0878"
	$"7275 7578 7275 443D F83E FF3D FD3E FF75"
	$"4644 7578 727E 797C 9676 777B 7578 3F75"
	$"4A7B 757A 9595 7A78 727B 7544 7B75 7677"
	$"3F7B 7575 7B7B 96FF D8A1 8172 7278 78D4"
	$"ADCB 7E7E 7880 7A81 819B ABA5 AB9A 9A47"
	$"7178 723E 3D3E 3E40 F93E 083D 3E3E A7A7"
	$"A957 684E FE82 048A 8483 8389 0384 8356"
	$"58F8 59FF 58FD 59FF 8346 5683 8A84 8782"
	$"809A 8283 8883 8957 835B 8883 819B 9B81"
	$"8984 8883 5688 8383 8A58 8883 8388 809B"
	$"F1CA A485 8484 8181 CCA5 CB7E 8781 8781"
	$"7F7F 9AAA A3A9 9A9A 5D83 8984 5958 5959"
	$"5AF9 5902 5859 59FE B10D 6171 81B0 AEAE"
	$"C8C2 B8B8 C6C1 B88F F9A3 F9A3 FFB8 418F"
	$"B8C8 C2AA A693 ADAE AFBD B8C6 98B8 94BD"
	$"B89D B6B6 9DC6 C1BD B88F BDB8 B9C8 9BBD"
	$"B8B8 BD91 AB8D 5DB5 97C1 C1A5 A58D 61CB"
	$"7EAA A5A2 9D75 7590 A09B A09A 9A9E C0C6"
	$"C1FD A300 A4F6 A3FF DB00 D201 2C0C 4552"
	$"467C 7247 7178 7741 757B 77F0 3E3A 757B"
	$"7A74 7872 7676 A378 767C 4178 757B 7B75"
	$"7878 9999 747B 754A 7278 767C 7247 767C"
	$"7247 7C45 7E92 CFD4 A378 7278 7575 ADD4"
	$"CF83 7278 777D 7B75 7DFE 7607 937E 7878"
	$"7C76 7C76 FD41 013B 3CFD 3FFD 3E0D 80AA"
	$"AB4A 5655 8884 5D83 8A89 5883 0188 8AF0"
	$"593A 8388 8983 8984 8282 AB81 8288 588A"
	$"8388 8883 8181 9A9A 8288 835B 848A 8288"
	$"845D 8288 845D 8855 879B C7CC AB81 848A"
	$"8383 A6CC CC80 848A 8187 8883 89FE 8207"
	$"9B87 8181 8882 8882 FD58 0559 5A59 595A"
	$"5AFD 590F 87B0 AF5F 6A87 B5C1 9EC2 C8C7"
	$"9BB8 BDCF F8A3 F9A3 49B8 BDC6 C1C6 C1AE"
	$"AECC A5AE B39B C8B8 BDBD B8A5 A5A3 A3B7"
	$"BDB8 94C1 C6B0 B5C1 9EB0 B5C1 9EBD 8FAA"
	$"BC92 97CC A5C2 C8B8 B86D 97B1 61C2 C8AE"
	$"B3BD B8B4 AEB0 B0BE AAA5 A5B3 AEB5 B099"
	$"999B 9BF7 A302 AAD1 BF01 270B 5245 5E76"
	$"7872 7841 7279 7544 F03E 3A40 4475 7943"
	$"7247 7C76 787E 7576 7872 7B75 757B 7878"
	$"7FA9 757B 7575 7246 7676 7872 7676 7872"
	$"7676 7877 B2AD 787E 4178 7B7A ADD4 CF9E"
	$"7841 7777 757C FE76 007C FD78 FD76 0578"
	$"7272 413C 3CFD 3FFD 3E0D AAC2 C456 4A6C"
	$"8289 848A 5884 8B83 0056 F059 3A5A 5683"
	$"8857 845D 8882 8187 8182 8A84 8883 8388"
	$"8181 7FA9 8388 8383 845D 8282 8984 8282"
	$"8984 8282 8180 AAA5 8187 588A 8887 A5CC"
	$"CC9A 8A58 8181 8389 FE82 0088 FD81 FD82"
	$"0989 8484 585A 5A59 595A 5AFD 590E B0C8"
	$"C76A 5F9B B0C6 C1C8 9BC2 C8B8 8FF7 A3FA"
	$"A33E A48F B8C5 99C1 9EB3 AEA5 AAAD AEC8"
	$"C2BD B8B8 BDA5 A589 B2B8 BDB8 B8C1 9EB0"
	$"B0C6 C1B0 B0C6 C1B8 B8A4 A372 6CA5 AA9B"
	$"C8BD BC6C 97B1 7DC8 9BAE AEB8 BEAE AEB0"
	$"B5FD A5FF AEFF B003 C6C1 C29B F7A3 02D1"
	$"E9D7 0139 0B48 673E 7C41 7976 7679 7378"
	$"72EF 3E0F 747A 7378 7C76 757B 7893 767C"
	$"7575 7247 FE78 10A3 7676 7247 757B 7972"
	$"7841 7841 7878 4375 FE78 3A72 7C76 7B75"
	$"783F 7677 ADA7 D2AB 767D 7841 7F78 9BAB"
	$"AB9B 9A9A 9999 7C96 7A95 7A7A 7877 7278"
	$"7543 7575 4171 7C76 A9D5 A84A 694E 8857"
	$"8982 828A 858A 0084 F159 FF5A 0F83 8985"
	$"8987 8283 8881 9C82 8883 8384 5DFE 812A"
	$"AB82 8284 5D83 8889 838A 5889 588A 8A55"
	$"838A 8A89 8488 8288 838A 5782 82A9 A4CB"
	$"A482 8989 5888 819A AAA9 99FD 9A03 809A"
	$"819B FE81 1980 8489 8355 8383 5883 8882"
	$"B0DC B055 7281 B597 C4B0 B0C7 C2C8 C2F7"
	$"A3FB A3FF A50F C1C6 C2C6 B6B1 B8BD A4BD"
	$"AEB3 BABA C19E FEA5 43CC B0B0 C29F B8BD"
	$"C4BF C89B C699 C8C8 8FB8 C8C8 C6C1 BDB8"
	$"BDB8 C89A ACAD 9791 9F74 B0B6 C699 ABA5"
	$"90A0 A091 9A9A A3A3 93AD 9DB6 9D9D A5A4"
	$"C1C6 B88F B8B8 9BC2 B3AE CAF4 D101 3A0B"
	$"5467 3E76 7972 767C 7841 7841 EF3E 4749"
	$"7447 7276 767B 7578 7E76 7674 4A78 7378"
	$"787E 7876 7C78 727B 7441 7972 7872 7872"
	$"4175 7B3F 7241 7876 457B 7572 7876 7C83"
	$"CED2 B176 7672 7878 93A5 9BA5 9BA9 9BA8"
	$"7EA6 7CAB 7B7A 95FE 7801 4175 FE7B 1177"
	$"7876 76A9 C1A8 5769 4E82 8983 8288 8958"
	$"8A00 58F1 59FF 5A09 5C83 5D84 8282 8883"
	$"8187 FE82 3F5B 8985 8181 8781 8288 8A84"
	$"8882 5789 848A 8489 8458 8388 5784 5889"
	$"8255 8883 848A 8287 7FCB CBA9 8282 8489"
	$"819B A49A A399 A99B AA80 AA80 B182 819B"
	$"8181 8958 83FE 8812 898A 8282 B0C8 B061"
	$"7281 B0C4 BFB0 B5C6 99C8 9BF7 A3FB A3FF"
	$"A54C 9EC1 9EC1 B1B1 BDB8 A4AA AEAE B996"
	$"C6C2 A5A5 AAA5 B0B5 C8C2 BDB7 97C4 C2C8"
	$"C1C6 C29B B8BD 9AC2 99C6 B88F BDB8 C2C8"
	$"ACB2 6BBA 9F7A B0B0 C1C6 A5BE 9A90 9B91"
	$"A99B B289 BC93 CA9E 9DB6 A5A5 C699 B8FE"
	$"BD06 C7C8 AEAE CAE1 D101 3E09 4854 4676"
	$"777C 4772 7575 ED3E FF75 4976 7C47 7247"
	$"727B 7576 7C76 7B76 757C 7695 7A7B 7572"
	$"7876 7C76 7678 7275 7C71 3F7B 757B 7578"
	$"727B 7B72 4576 7778 4181 A1D6 AE93 7E44"
	$"7B7A 95AB AB96 9676 767B 7475 7676 757B"
	$"7B76 7B76 7CFD 7611 7544 7847 AAAA D44A"
	$"5655 8283 885D 8483 8359 FC59 FF5A FF59"
	$"FD5A FB59 FF83 4982 885D 845D 8488 8382"
	$"8883 8882 8188 829B 8188 8384 8982 8882"
	$"828A 8483 8984 5888 8388 8389 8488 8884"
	$"5C82 8389 5886 A5CC A59B 8756 8880 9BA9"
	$"A99A 9A82 8289 8281 8282 8188 8884 8982"
	$"88FD 8210 8356 8A5D B0B0 DB53 5F87 B0B9"
	$"BD9E C1B8 B8FB A3FF A5FF A3FF A5FF A5FB"
	$"A3FF BA54 AEB3 9EC1 9EC1 BDB8 AEB3 B9BD"
	$"B0AF B3AE BEA5 BDB8 C1C6 B8BD AEAE C8C2"
	$"B8BE C29B BDB8 BDB8 C6C1 BDBD C19D B8B9"
	$"C699 99B7 8E61 BFAC 8FBD 9BB4 9E9E ADAD"
	$"AEAE BFB9 ADAE B0AF BDBD BABF AEB3 B0B0"
	$"AEAE BA91 C89F CACA FB01 40FF 5407 707C"
	$"4577 7278 447C ED3E 6144 7B76 7678 7278"
	$"7275 7B76 767B 7576 7C76 7680 7A7B 7478"
	$"4176 437C 7641 7944 7577 3F44 757B 7578"
	$"4175 7478 727B 4378 727C A6D5 D593 7E76"
	$"7580 959B A596 8176 7C75 7B7C 767C 7675"
	$"757B 7576 767C 767C 767B 7572 72AA C3A8"
	$"5656 7C88 5583 8489 5689 59FC 59FF 5AFF"
	$"59FD 5AFB 5960 5689 8282 8984 8984 8388"
	$"8282 8883 8288 8282 8781 8882 8958 8254"
	$"8882 588B 5683 8A58 5683 8883 8958 8382"
	$"8984 8754 8984 80AA CCCC 9B87 8383 869B"
	$"9AA4 9A86 8288 8389 8882 8882 8383 8983"
	$"8282 8882 8882 8983 8484 B0C8 B05F 5FAA"
	$"B58F B9C1 C68F BEFB A3FF A5FF A3FF A5FF"
	$"A5FB A356 91BF AEAE C6C1 C6C1 B8BD AEAE"
	$"BDB8 B0B5 AEAE AAA5 BDB7 C699 B88E B3AE"
	$"9BC8 8FB8 C89B 8FB8 BDB8 C699 B8B7 C6C1"
	$"BC8E C6C1 93BC 8D8D BFAC B9B8 A0B4 8E98"
	$"AD99 AEB3 BABF B3AE B5B0 B8B8 BFBA AEAE"
	$"B5B0 B3AE BFBA C2C2 CAE1 D101 38FF 450B"
	$"3E76 7878 757B 7241 3E3E 3C3C F13E 467C"
	$"7577 4175 7B72 7875 757D 7775 7B76 7675"
	$"7A75 7B72 4576 767B 7B72 787B 7578 7875"
	$"443E 3E71 4576 7678 4172 7875 7B76 767E"
	$"93AD AD9A 7F78 4776 769B ABA9 8A7C 767B"
	$"7573 737C 767E FE78 177C 7676 7776 7647"
	$"7278 78A8 ADC4 4A4A 4E82 8989 8388 8458"
	$"5902 595A 5AF1 5940 8983 8958 8389 8489"
	$"8383 8781 8388 8282 8387 8388 855D 8282"
	$"8888 8489 8883 8A8A 8356 5959 845E 8282"
	$"8A58 8489 8388 8282 879B A4A4 9A7F 895D"
	$"8282 9AAA A98A 8882 89FE 8302 8882 87FE"
	$"8116 8882 8283 8282 5D84 8989 B0B5 C75F"
	$"5F81 B0C6 C6B8 BDC1 99F5 A3F9 A346 BEB8"
	$"C79B BABF C1C6 B8B8 B3AE B8BD AEAE B8BC"
	$"B8BD C39F AEAE BDBD C1C6 BDB8 C6C6 B78F"
	$"A3A3 CAA8 AEAE C89B C1C6 B8BD AEAE AABE"
	$"6A6A 9A7F C69E B0B0 90A0 A98A B3AE BFBA"
	$"B8B8 B5B0 AAFE A50C B3AE B0B1 AEAE 9EC1"
	$"C6C6 D1D6 D701 400D 5264 3E7C 7241 7B75"
	$"4141 3E3E 3C3C F63E 003D FD3E 4975 4479"
	$"727B 7541 7844 7A77 777B 757C 767B 757B"
	$"7571 7776 7C75 7678 4175 7B72 4075 433D"
	$"3E45 7176 7C78 7278 4175 7B76 7C78 78D4"
	$"D4CB 7F72 7276 7C9B A59A 9A76 7675 4479"
	$"7976 7678 9478 78FE 7614 7C76 7C72 7841"
	$"72A8 D0AB 5668 4E88 8458 8883 5858 5902"
	$"595A 5AF6 5900 58FD 5949 8356 8B84 8983"
	$"5889 5687 8181 8883 8882 8883 8883 848A"
	$"8288 8383 8958 8388 8458 8355 5859 5E84"
	$"8288 8A84 8958 8388 8288 8181 CCCC CB7F"
	$"8484 8288 9AA4 9A9A 8282 8356 8989 8282"
	$"819C 8181 FE82 1388 8288 8489 5884 B0D7"
	$"AF6A 7B81 B5C1 99BD B899 99F5 A3F9 A33A"
	$"B88F C8C2 BFBA 99C6 8FBC AEAE BDB8 B3AE"
	$"BDB8 BDB8 C2C8 AEB3 B8B9 C699 B8BD C199"
	$"B78E A3A3 A8CA AEB3 C8C2 C699 B8BD AEB3"
	$"A5A5 9595 CB7F C1C1 B0B5 90FE 9AFF AE16"
	$"BA91 BDBD B0B0 A5BF A5A5 AEAE B0B5 AEB3"
	$"C1C6 99C1 D1F7 BF01 3A06 4552 7878 7B75"
	$"77EC 3EFF 3F35 747A 757B 7247 7676 7B75"
	$"7278 4475 7278 7241 7147 7676 4772 4772"
	$"757B 7544 7B7A 7841 3E3E 4172 7841 767C"
	$"757B 7543 7841 7B75 AEA8 A883 FE78 2442"
	$"7E92 A99A 9580 4778 7544 7C76 9580 757B"
	$"757B 7B75 4A75 7872 7B75 A7AD CF4A 5681"
	$"8188 838A FD59 FE59 FF5A FD59 FF5A FB59"
	$"FF5A 5D84 8983 8884 5D82 8288 8384 8956"
	$"8384 8984 5883 5D82 825D 845D 8483 8883"
	$"5688 878A 5859 5958 8489 5882 8883 8883"
	$"5589 5888 83A9 A3A3 7E89 898A 5987 9AA9"
	$"9A9B 875D 8983 5688 829B 8783 8883 8888"
	$"835B 8389 8488 83B1 B6D7 5F6A A5A5 BDB8"
	$"CFFA A3FF A5FD A3FF A5F9 A356 C2C8 B8BD"
	$"C19E AEAE BDB8 C1C6 8FB8 C1C6 C29B C09E"
	$"B0B0 9EC1 9EC1 B8BD B88F BDBC C89B A3A3"
	$"9BC2 C699 B0B5 B8BD B88F C699 BDB8 8D88"
	$"916B C6C6 C89C AABD A99A B6A2 9EC6 B88F"
	$"B5B0 B6A2 B8BD B8BD BDB8 94B8 C9C4 BDB8"
	$"D1D6 F601 3906 5245 4078 7B75 3DEC 3EFF"
	$"3F1C 437A 7544 7873 7C75 7B75 4572 7B75"
	$"7841 7878 7278 7C76 7972 7278 4475 7BFE"
	$"753D 7241 3E3E 4141 7278 7576 7B75 7B75"
	$"7871 7B75 9ED0 CF9E 723F 7278 7879 9AA9"
	$"947A 7272 7B76 7675 7A95 7B75 7B75 757B"
	$"7575 4078 757B A7C0 AD56 4A4C 8188 8358"
	$"FD59 FE59 FF5A FD59 FF5A FB59 FF5A 1C57"
	$"8983 5689 8588 8188 835C 8488 8389 588A"
	$"8A84 8988 828A 8484 8956 8388 FE83 3C84"
	$"5859 5958 5884 8981 8288 8388 8389 8388"
	$"8399 CCCA 9984 5784 8A81 829A A99A 8184"
	$"8488 8382 8181 9B88 8388 8383 8883 8358"
	$"8983 88B1 C9B5 6A5F 75A5 BDB8 F9A3 FFA5"
	$"FDA3 FFA5 F9A3 1C9B C8B8 8FC6 C2B3 ADBD"
	$"B89D C1BD B8C6 99C8 C8C1 C6B5 B0C7 C1C1"
	$"C68F B8BD FEB8 36C2 9BA3 A39B 9BC1 C6AF"
	$"B0BD B8BD B8C6 C0BD B87D B2BA 86C1 98C2"
	$"C8A5 A69A A9B5 9DC1 C1BD B9B0 AF9D B6BD"
	$"B8BD B8B8 BDB8 B89D C9B8 BDD1 E8D6 0135"
	$"0548 673C 7B41 78FE 3E00 40ED 3E21 7576"
	$"7879 757B 7278 4273 7C76 7278 7575 7277"
	$"7575 7942 7279 7872 7A7B 7278 7841 7841"
	$"FD3E 1541 7247 7844 7B41 7875 7B41 787A"
	$"A093 7E75 7B7B 7575 7BFE 9907 9A76 7C72"
	$"787C 927E FE78 127C 7648 7272 787B 754A"
	$"75A8 A8C4 4A69 4F88 5889 FE59 015A 59FE"
	$"59FF 5AF3 59FF 831F 8A8B 8388 8489 5683"
	$"8882 8489 8383 8489 8383 8956 8389 8984"
	$"8889 848A 8958 8A58 FD59 2058 845D 8956"
	$"8858 8A83 8858 8A81 A69B 8783 8888 8383"
	$"889A 9A99 9A82 8884 8988 9C87 FE81 1288"
	$"825E 8484 8988 835B 83B0 B0C7 5572 8ABD"
	$"99C6 FEA3 00A4 FDA3 FFA5 FBA3 F9A3 21B8"
	$"B9C8 C8B8 BDC1 C68F B8B3 AEC1 C6B8 B8C2"
	$"C7BA BABD 8FBF C4C6 C1BC BCC2 C8C6 99C8"
	$"9BFD A320 99C1 9EC6 8FBD 9BC8 B8BD 9BC8"
	$"9DC0 BEAA B8BD BDB8 B8BD A4A4 999A B0B5"
	$"C1C6 B5C8 AAFE A50C B3AE 9FC1 C1C6 BDB8"
	$"96BA D1D1 D701 3F05 5455 4475 7241 FC3E"
	$"023D 3E3D F63E 0040 FD3E 2144 7B41 727B"
	$"7541 7973 7977 7645 7244 7B78 4175 4A73"
	$"7379 4172 4775 7578 4172 7872 41FE 3E37"
	$"3D41 4172 7275 7578 7144 7578 727A 8078"
	$"787B 7575 447B 757E 999A 9A76 7647 7276"
	$"7C77 9378 7876 7678 7247 7276 7B75 75A8"
	$"D4AB 5758 5683 8458 FC59 0458 5958 5A5A"
	$"F859 005A FD59 2156 8858 8488 8358 8A83"
	$"8983 825C 8456 888A 5883 5B83 8389 5784"
	$"5D83 838A 5884 8984 58FE 59FE 58FF 84FF"
	$"8310 8A83 5683 8A84 8187 8181 8883 8356"
	$"8883 7FFE 9AFF 821A 5D84 8288 809B 8181"
	$"8282 8984 5D84 8388 8383 B0DB AF61 628F"
	$"B8C1 99F9 A3FF A5FB A3FE A300 A4FD A321"
	$"8FBD 9BC2 BDB8 99C7 B8BD AFAE 9DC1 8FBD"
	$"C89B BA96 B8B8 C497 C19E B7B7 C89B C1C6"
	$"C29B FDA3 FF99 FFC1 FFB8 2AC8 C28F B8C8"
	$"C29D A2A5 A5BD B8B8 8FBD B88A A49A 9AB0"
	$"B09E C1B0 B5A4 BEA5 A5AE AEC6 C19E C1B9"
	$"BDBA BAD1 FBBF 0135 0352 455D 7BFE 3E00"
	$"40ED 3E27 403E 757B 757B 4475 7872 7C75"
	$"4778 757B 7972 757B 767C 7377 757B 7677"
	$"7841 757B 7373 7841 3E3E 403F FE3E FF78"
	$"2F72 767C 7772 757B 7B75 7872 4772 7B7B"
	$"7278 7676 A99A 7A80 7676 7871 7B76 7E78"
	$"757B 767C 7379 4475 7878 AAAA CF56 4A6C"
	$"88FE 5903 5A59 595A 005A F159 5C5A 5983"
	$"8883 8856 8389 8489 835D 8983 888A 8483"
	$"8882 8885 8883 8882 8389 5883 8883 838A"
	$"5859 595B 5A59 595A 8C89 8482 8889 8483"
	$"8888 838A 845D 8488 8884 8982 82A9 9A81"
	$"8782 828A 8489 8487 8183 8882 8883 8956"
	$"838A 8AB0 B0D7 6A5F 9BB5 FEA3 04A4 A3A3"
	$"A5A5 F7A3 FBA3 23A4 A3B8 BDB8 BD8F B8C6"
	$"C1BE B89E C6B8 BDC7 C1B8 BDAE B3C2 C5B8"
	$"BDB0 B1C6 99B8 BDB8 B8C8 9BFB A32E A5D2"
	$"C6C1 B0B5 C7C2 B8BD BDB8 C8C2 9FC2 BDBD"
	$"C1C6 B0B0 A898 A5AA AEAE C6C0 BCB8 AAA5"
	$"B8BD B0B5 B8BD 8FB8 C8C8 CACA F601 2403"
	$"5245 3D45 E73E 2544 757B 757B 7678 4175"
	$"7B72 737B 7572 4775 7B77 7647 727C 757C"
	$"7678 727B 7548 7372 413E 3E3F 3FFE 3E31"
	$"3D72 4776 7672 4775 4475 7B41 7872 7875"
	$"7447 727C 759A AA95 7A7C 7646 7275 7B78"
	$"937B 7576 7679 737B 7541 73AA C3AD 564A"
	$"4E55 FB59 005A 005A EF59 5A56 8388 8388"
	$"8389 5883 8884 8588 8384 5D83 8883 825D"
	$"8489 8388 8289 8488 835C 8384 5859 595A"
	$"5A59 595A 5984 5D82 8284 5D83 5683 8858"
	$"8A84 8A83 825D 8488 819A AA9B 8188 825D"
	$"8483 8981 9B88 8382 8289 8388 8358 85B0"
	$"C8B5 6A5F 8187 FBA3 FFA5 F7A3 F9A3 218F"
	$"B8BD B8BD B9C6 99B8 BDC1 C2BD B8C1 9EB8"
	$"BDAF AE9E C1BE B8B5 B0C6 C1BD B894 B8C2"
	$"9BFB A32E A5A4 C19E B0B0 C29F B88F B8BD"
	$"9BC8 C2C8 B8B7 9EC1 B5AF 98A9 BEA5 B3AE"
	$"9EC1 B7BC A5BE BDB8 B0B0 BDB8 BDB8 9BC3"
	$"CAE1 D601 1503 523F 3C43 E73E 2172 7843"
	$"7578 727C 7747 7272 7875 4A75 7B75 7547"
	$"717B 7572 4775 4A75 7C44 7B72 7878 41F8"
	$"3E33 7771 457C 767B 7C72 7876 7678 7240"
	$"7877 7D72 787A 959A 9A75 7B76 7677 727C"
	$"7679 787D 7741 7872 7875 7BA8 ADC7 5643"
	$"5057 5959 5A5A FE59 EE59 2184 8A55 8389"
	$"8488 835D 8484 8A83 5B83 8883 835D 8388"
	$"8384 5D83 5B83 8956 8884 898A 58F8 5933"
	$"8A85 5E88 8288 8984 8982 8289 8458 8981"
	$"8784 8981 9B9A 9A83 8882 8288 8488 8282"
	$"8187 8258 8984 8A83 88B0 B5C7 614E 8D93"
	$"A3A3 A5A5 F3A3 F9A3 21C2 C88F B8C6 C1B3"
	$"AF9E C1C1 C6B8 94B8 BDB8 B89E C0BD B8C2"
	$"9FB8 94B8 BE8F BDC1 C6C8 9BF8 A32B CFCA"
	$"A8BD B8BD BEC1 C6B0 B0C6 C19D C9AE B3C1"
	$"C69D B69A 9AB8 BDB0 B0C5 C1BD B8A6 A5B5"
	$"B099 C6C2 C8B8 BDD3 D8C7 0112 0346 2900"
	$"43E7 3E1A 4178 757B 7247 7676 7872 7840"
	$"7575 7B75 447B 7278 7544 7872 7475 7BFE"
	$"7503 7841 7241 F73E 3245 7176 7C75 7547"
	$"7376 7C41 7872 7877 7747 7281 95A9 9A75"
	$"4476 7C47 7276 7C78 7877 7779 7278 417B"
	$"75A8 CFC7 4A2E 2457 5959 5A5A FE59 EE59"
	$"1A58 8A83 8884 5D82 8289 848A 5883 8388"
	$"8356 8884 8983 568A 8482 8388 FE83 0389"
	$"5884 58F7 5932 5E85 8288 8383 5D85 8288"
	$"5889 8489 8181 5D84 889B A99A 8356 8288"
	$"5D84 8288 8181 8282 8A84 8A58 8883 B0D7"
	$"C755 3A5C 93A3 A3A5 A5F3 A3F9 A31A 9BC8"
	$"B8BD C19E AEAE C6C1 C699 B8B8 BDB8 8FBD"
	$"C1C6 B88F C8C2 B7B8 BDFE B803 C699 C29B"
	$"F7A3 2AA8 CAB8 BDB8 B89E C2B0 B599 C6C4"
	$"C9AE AE9E C1A3 B6A9 9AB8 8FB0 B59E C1B8"
	$"BDA5 A5B0 B0C7 C1C8 9BBD B8D3 F8C7 0122"
	$"FF00 013C 43EB 3E25 3D3E 3E3F 7576 7872"
	$"4475 7878 757B 4178 7772 757B 7B75 7B75"
	$"7878 7278 7B75 447B 7671 767C 7141 FE3E"
	$"0040 FB3E 1F41 7278 417B 7576 7C45 7276"
	$"7678 4178 7276 7B72 7295 957B 7B71 7776"
	$"7678 727B 75FC 7609 7C72 47AA AAAD 0909"
	$"5057 FD59 FF5A 0059 F259 2558 5958 5981"
	$"8289 8456 8389 8983 8858 8988 8483 8888"
	$"8388 838A 8A84 8989 8356 8889 8582 8883"
	$"58FE 5900 5AFB 591F 5884 8958 8883 8288"
	$"5C84 8282 8A58 8984 8287 8484 9B9B 8888"
	$"848A 8282 8984 8883 FC82 0988 845D B0B0"
	$"B522 228D 93FD A3FF A5F5 A3F9 A321 B7B8"
	$"C6C1 8FB8 C6C6 B8BD 99C6 C5C1 B8BD BDB8"
	$"BDB8 C8C8 C1C6 BFBA 8FBD CFCA AEB3 C29B"
	$"FEA3 00A4 FBA3 2A9B C2C6 99BD B8AE B39D"
	$"C1AE AEC8 9BC6 C1B0 B4C1 C1B6 B6BD BDC2"
	$"C8AE AEC6 C1BD B8B0 B0AE AEB0 B5C1 9ECA"
	$"CAD6 0120 0310 0000 43ED 3E00 3DFE 3E23"
	$"413F 4B76 4178 7C75 7241 7B76 7872 7247"
	$"7544 757B 4475 4172 7941 757B 7675 4577"
	$"7675 783F F73E 2E3F 4141 7275 7B76 7672"
	$"787D 7778 7272 4776 7647 787A 8075 7577"
	$"3F7C 7647 7275 7B76 7D76 7C76 7578 72AA"
	$"D1C2 1A09 2557 FD59 FF5A 0059 F459 0058"
	$"FE59 235A 595A 8258 8989 8384 5888 8389"
	$"8484 5D83 5683 8856 8358 848A 5883 8983"
	$"835E 8A82 818A 57F7 592E 5758 5884 8388"
	$"8282 8489 8983 8A84 845D 8282 5D89 8187"
	$"8383 8A58 8882 5D84 8388 8289 8288 8281"
	$"8984 B0D7 C934 225D 93FD A3FF A5F5 A3FB"
	$"A323 A4A3 94B8 99C6 BEB8 C199 BDB9 C6C1"
	$"C19E B88F B8BD 8FB8 9BC2 C799 BABF B9B8"
	$"A8CF AEAD C89A F7A3 2A9A 9B99 C1B8 BDAE"
	$"AEC1 C6B4 AFC8 C2C1 9EB0 B09E C69D A2B8"
	$"B8C8 9BB3 AE9E C1B8 BDB0 B6AE B3B0 AFC6"
	$"C1CA EFE9 011E 0301 0D3C 43FE 3E02 3D3F"
	$"3FED 3E0D 757B 7B75 7278 757B 447B 7575"
	$"7872 FE7B FF75 0E7B 7878 7676 4772 7872"
	$"7575 7847 7644 F83E 2F40 3F3F 3E3E 4470"
	$"4778 7872 4178 4475 7872 7878 7676 7B76"
	$"7177 7575 7278 7676 7B75 7B75 7676 7247"
	$"7676 A8AD AB0A 1650 57FE 5903 585A 5A59"
	$"FC59 FF5A F559 0D83 8889 8384 8983 8856"
	$"8883 838A 84FE 88FF 830E 888A 8A83 835D"
	$"8489 8483 8389 5D83 56F8 5900 5AFD 592A"
	$"5F84 5D89 8A84 5889 5683 8984 8A8A 8282"
	$"8883 858A 8383 8489 8282 8883 8883 8282"
	$"845D 8282 B0B4 AF22 2F8D 93F5 A3FF A5FD"
	$"A3F9 A30D B8BD BCB7 C1C6 B8BD 8FBD B8B8"
	$"C8C2 FEBD FFB8 0EBD C8C8 AEAE 9EC1 C6C1"
	$"B8B8 C69E B98F F8A3 00A4 FDA3 26AA CB9E"
	$"C6C8 C299 C691 BAC6 C1C8 C8AE AEBD B9CA"
	$"CFB8 B8C1 C6B0 B0BD B8BD B8AE AEC1 9EAE"
	$"AED1 D6BF 0112 0301 2800 43FD 3EFF 3FED"
	$"3E0D 4375 757B 7247 757B 7575 447B 4178"
	$"FE75 1144 7B75 7241 767C 7278 4178 754A"
	$"7172 7544 3DF8 3EFF 3FFD 3EFF 7226 4178"
	$"7278 757B 4178 7141 767C 4475 4577 447B"
	$"7245 767B 4475 7B75 757B 7278 767C A8C1"
	$"D20A 2E25 57FD 59FF 5A00 59FC 59FF 5AF5"
	$"590D 5583 8389 845D 8388 8383 5688 588A"
	$"FE83 1156 8883 8458 8388 8489 5889 835B"
	$"8384 8356 58F4 59FF 5AFF 8426 588A 8489"
	$"8389 5889 8358 8288 5683 5E8A 5688 845C"
	$"8287 5683 8883 8187 8489 8288 B0C8 D622"
	$"455D 93F5 A3FF A5FD A3F9 A30D 8FB8 B7BC"
	$"C19E B8BD B8B8 8FBD 9BC8 FEB8 108F BDB8"
	$"C29B AEB3 C1C6 99C6 B894 C0C1 B88F F3A3"
	$"FFA5 FFC1 229B C8C1 C6BA BF99 C6C2 9BAE"
	$"B38F B8A8 CF8F BDC1 9DB0 B48F B8BD B8AD"
	$"B3C1 C6AE B3D1 E8E5 0106 030F 013C 44EF"
	$"3EFF 3CFB 3E1D 7378 4475 7872 7872 7B7B"
	$"757B 7676 4773 7878 7278 747B 7872 7B75"
	$"7B75 7872 FE78 0041 F33E FF3C FF3E 2678"
	$"7278 737C 757B 757B 7A72 7875 7B76 7678"
	$"727C 7678 7278 7875 7B77 7778 7278 41A8"
	$"ADAB 180A 5056 FA59 F659 FF5A FB59 2385"
	$"8956 8389 8489 8488 8883 8982 825D 858A"
	$"8A84 8982 8889 8488 8388 838A 8489 898A"
	$"585A 5AF5 59FF 5AFF 5926 8A84 8A85 8983"
	$"8983 8887 848A 8389 8282 8984 8782 8984"
	$"8989 8388 8181 8A84 8958 B0B5 AF30 228C"
	$"91EF A3F9 A323 C5C9 8FB8 C6C1 C6C1 BDBD"
	$"B7BC B0B0 9EC2 C8C8 C1C6 B7BD C6C1 BDB8"
	$"BDB8 C8C2 C6C6 C89B A5A5 F1A3 22C8 C2C8"
	$"C3BE B8BC B7BD BCC1 C6B7 BCAE AEC6 C1B2"
	$"ACC6 C1C6 C6B8 BDAE AEC8 C2C6 99D1 D6BF"
	$"0106 0301 0F00 44EF 3EFF 3CFB 3E21 4078"
	$"7B75 4772 7247 7575 7B75 7C76 7872 4172"
	$"7841 7B76 4178 7544 757B 4178 7341 7241"
	$"F33E FF3C FF3E FF41 2472 4775 7B75 4475"
	$"7546 727B 757C 7572 4776 7645 7272 417C"
	$"757D 7741 7872 78A8 D0C4 0A18 2456 FA59"
	$"F659 FF5A FB59 2358 8988 835D 8484 5D83"
	$"8389 8388 8289 8458 8489 5888 8358 8983"
	$"5683 8858 8A85 5884 585A 5AF5 59FF 5AFF"
	$"59FF 5824 845D 8388 8356 8383 5D84 8983"
	$"8881 845D 8282 5C84 8458 8983 8781 588A"
	$"8489 B0D7 C722 305B 91EF A3F9 A323 9DC9"
	$"BDB8 9EC1 C19E B8B8 BCB7 B5B0 C6C1 9BC2"
	$"C699 BDB9 99C6 B88F B8BD 9BC8 C299 C29B"
	$"A5A5 F1A3 FF9B 20C2 9FB8 BDB7 8FB8 B89E"
	$"C1BC B7B3 ADC1 9EAC AC9D C1C1 99BE B8B3"
	$"AE9B C8C1 C6D1 F7D7 00F8 0329 003C 43EF"
	$"3EFF 3CFB 3EFF 7318 7278 7676 7B75 7345"
	$"7245 7544 7872 7B7B 7178 7575 7C76 7177"
	$"7BFE 7503 7872 7941 EC3E 233D 7443 757B"
	$"7872 7B75 7247 7247 757B 7377 767D 7B75"
	$"7247 757B 7B44 7675 AAD6 A82F 0750 57FA"
	$"59F6 59FF 5AFB 59FF 8318 8489 8282 8883"
	$"855C 845C 8356 8984 8888 8389 8383 8882"
	$"858A 88FE 8307 8984 8B58 5959 5A5A F059"
	$"2358 8457 8388 8A84 8883 845D 845D 8388"
	$"8588 8288 8883 845D 8388 8856 8383 B0DB"
	$"B043 1D8D 93EF A3F9 A3FF B818 C1C6 B0B0"
	$"BDB8 C39E C19D B78F C6C1 BDBD C0C6 B8B8"
	$"B3AE CACF BDFE B807 C6C1 C89B A3A3 A5A5"
	$"EFA3 1EC2 9BB8 BDC8 C2BD B8C1 9EC1 9EB8"
	$"BDC2 C5B8 BEBD B8C1 9EB8 BDBD 8FB9 B8CA"
	$"F3D1 00F6 0302 2900 43EF 3EFF 3CFB 3E21"
	$"4873 4772 757C 4375 7872 7872 757B 7247"
	$"7475 4179 754A 7676 4577 7544 7B7B 4179"
	$"7341 EB3E 1644 437B 7541 7875 4478 7278"
	$"727B 7578 417B 7644 7578 727B FE75 FF7B"
	$"06AA C4A8 092F 2557 FA59 F659 FF5A FB59"
	$"255C 835D 8481 8855 838A 8489 8483 8984"
	$"5D82 8358 8A83 5B82 825E 8A83 5688 8858"
	$"8A85 5859 595A 5AEF 5916 5857 8883 588A"
	$"8356 8984 8984 8883 8958 8782 5683 8984"
	$"88FE 83FF 8806 B0C9 B01F 435D 93EF A3F9"
	$"A325 94B8 9EC1 AFB5 8FB8 C8C2 C6C1 B7BC"
	$"C19E B7B8 99C7 B894 AEAE A8CF B88F BDBD"
	$"99C7 C39B A3A3 A5A5 EFA3 169C 9BBD B89B"
	$"C8B8 8FC6 C1C6 C1BD B8C6 99BC B88F B8C6"
	$"C1BD FEB8 FFBD 02CA E2D1 00B3 050F 013C"
	$"433D 3DED 3E03 403E 3C3C FD3E 0040 F33E"
	$"023D 3F3F FD3E FF3F FD3E FF3F EF3E 003D"
	$"FA3E 2041 7241 7472 7275 7B72 4176 7C75"
	$"7B78 7872 4176 7C47 727B 44AA AAD4 180A"
	$"5057 5858 FC59 F259 035A 595A 5AFD 5900"
	$"5AF3 5900 58FD 59FF 5AFB 59FF 5AEF 5900"
	$"58FA 591E 5884 608C 8484 8388 8458 8288"
	$"8388 8989 8458 8288 5D84 8856 B0B0 DB30"
	$"228D 93EF A3FD A300 A4FA A300 A4EE A3FD"
	$"A5E1 A31A 9BC2 B1D8 C1C1 B8BD C29B AEB3"
	$"B8BD C6C6 C29B AEB3 9EC1 BD8F CACA FB00"
	$"B403 020F 0043 E93E FF3C F83E 003D FA3E"
	$"0340 3E3E 3FFC 3E07 403F 3E3D 3E3E 3F40"
	$"F03E 003D F93E FF41 1C3A 3B41 4774 4478"
	$"7876 7744 7572 4178 7876 7672 7775 75AA"
	$"C3A8 0B18 2557 FA59 F059 FF5A F859 0058"
	$"FA59 005A FE59 0258 5959 FE5A FF59 0458"
	$"5959 5A5B F059 0058 F959 FF58 1C5B 5C58"
	$"5D82 568A 8A82 8356 8384 588A 8A82 8284"
	$"8883 83B0 C8B0 2330 5D93 EFA3 E8A3 00A4"
	$"FBA3 FFA5 01A6 A5E1 A3FF 9B18 ACAD 999E"
	$"B78F C8C8 AEAF 8FB8 C199 C8C8 AEAE C1C5"
	$"B8B8 CAE1 D100 B203 2900 3C43 F53E FF3F"
	$"F23E 003D F83E 003D FC3E 013D 40FE 3E04"
	$"3D3E 3F3F 3DFE 3EFF 3CE9 3E04 403E 3F3F"
	$"3DFD 3E17 3D3E 3E41 3B77 3E78 7241 7245"
	$"7145 713E 77A5 ABA8 2F06 5057 FA59 FC59"
	$"FF5A F259 0058 FD59 FF5A FF59 005A FB59"
	$"0158 5AFE 5904 5859 5A5A 58FE 59FF 5AE9"
	$"5904 5A59 5A5A 58FD 5917 5859 5960 5C8A"
	$"5989 8458 845E 855E 8559 8AB1 B6B0 3D15"
	$"8D93 EFA3 F1A3 FFA5 FFA3 01A5 A4FB A300"
	$"A4DC A300 A4F6 A310 B1AD CFA3 C6C1 9BC2"
	$"A8CA A8CA A3CF E3E8 D100 9403 0129 0043"
	$"F53E FF3F FA3E 0040 F13E 003F F63E 033D"
	$"3E3F 3FFD 3EFF 3CEA 3E04 3D3E 3E40 3FF9"
	$"3EFF 3B01 3E40 FD41 FD3E 083D 3E7B A5A9"
	$"072F 2457 FA59 FC59 FF5A FA59 005A F559"
	$"FF5A FF59 015B 5AF7 5903 5859 5A5A FD59"
	$"FF5A EA59 0458 5959 5B5A F959 FF5C 0159"
	$"5AFD 58FD 5908 5859 88B1 B117 3D5C 93EF"
	$"A3FE A300 A4F5 A3FF A5FF A301 A6A5 C9A3"
	$"FFAD 05A3 A499 999B 9BFB A302 BDE3 D201"
	$"37FF 000D 4048 4040 4141 4544 4343 4040"
	$"4444 FD41 0744 4340 4041 4144 44FD 41FF"
	$"42FF 4115 4344 4545 4141 4443 4444 4140"
	$"4241 4444 4343 4040 4444 FD41 FF44 FF41"
	$"0340 3F44 44FD 41FF 44FF 41FE 4300 42FD"
	$"41FF 44FF 40FF 4101 4443 FD41 FF45 FD41"
	$"FF44 FF43 FF41 FF42 FF41 FFA8 04A9 0B0C"
	$"4C53 FC57 0156 57FE 57FF 56FD 5701 5655"
	$"FD57 FF56 FD57 FF56 FF57 1556 5755 5557"
	$"5758 5756 5657 5658 5756 5657 5758 5856"
	$"56FD 57FF 56FE 57FE 56FD 57FF 56FF 57FF"
	$"5601 5756 FD57 FF56 FF58 FF57 0156 55FD"
	$"57FF 55FD 57FD 56FF 57FF 56FF 57FF B004"
	$"B127 2A75 7BFD 96FF 8FFD 96FF 8FFD 96FF"
	$"8FFD 96FF 8FFD 96FF 8FFF 961B 9798 8F8F"
	$"9696 9796 8F8F 9695 9897 8F8F 9696 9797"
	$"8F8F 9797 9696 8F8F FE96 0E95 8F8F 9595"
	$"9797 8F8F 9696 9595 908F FD96 FF8F FF97"
	$"FF96 FF8F FD96 FF8F FD96 FF8F FF97 FF96"
	$"FF8F FF96 FFDB 00D2 0162 7F29 0006 4000"
	$"383A 003D 3D00 3C38 003C 3C00 3A3A 003C"
	$"3C00 383A 003C 3C00 3A3A 003A 3A00 383C"
	$"003D 3D00 3A3C 003C 3E00 3A39 003C 3C00"
	$"3C38 003C 3C00 393A 003C 3C00 3A38 003C"
	$"3C00 3A38 003B 3C00 3A3C 003A 3A00 3A3A"
	$"003C 3C00 383A 003C 3C00 3A3A 003D 3D00"
	$"3A3A 003C 3C00 3C3A 003A 3A00 3A47 77A9"
	$"300B 1E4C 2851 5127 5050 277F 5051 284F"
	$"4F28 5151 284F 4F28 5151 274F 4F28 5151"
	$"2850 5028 5050 284F 4F27 5150 274F 5028"
	$"5151 284F 4F27 5052 284F 4F28 5151 284F"
	$"4F28 5151 284F 4F27 5150 284E 4F28 5150"
	$"2750 5028 5151 284F 4F28 5251 284F 4F28"
	$"5151 274F 4F28 5151 284F 4F28 5051 2850"
	$"5028 5154 82B1 4D27 4B75 6390 9062 8989"
	$"6390 9064 8A8A 6390 9063 8A8A 5E63 9090"
	$"628A 8A63 9090 638A 8A63 8F92 658A 8A62"
	$"9090 638A 8B63 9092 658A 8A63 9092 658A"
	$"8A65 9290 638A 8A63 9090 638A 8A62 8F91"
	$"6589 8A63 908F 628A 8A63 9090 648A 8A65"
	$"9290 638A 8A63 9090 628A 8A63 9090 638A"
	$"8A65 9290 638A 8A63 9087 B0D2 0162 7F0F"
	$"0002 0229 0002 0F00 0028 0000 0F00 000F"
	$"0002 2B00 000F 0001 0F00 0028 0000 0F00"
	$"000F 0000 2900 0011 0002 0F00 0028 0000"
	$"0F00 000F 0002 2A00 000F 0003 1200 0027"
	$"0000 1100 0011 0000 2900 000F 0001 0E00"
	$"0028 0000 0F00 000F 0002 2B00 000F 0001"
	$"0F00 0027 0000 0F00 000F 0000 2900 000F"
	$"000B 4A44 1808 0606 2F07 0918 0B0B 2F7F"
	$"0B07 180B 0C18 0706 2E0B 0B18 0709 180B"
	$"0B2F 0B07 180C 0D18 0706 2F0B 0B19 0709"
	$"180C 0C2F 0B07 180B 0C17 0606 2D0A 0A18"
	$"0708 170B 0B30 0C07 190C 0D19 0706 2F0B"
	$"0B18 0709 160C 0C2F 0B07 180B 0C18 0706"
	$"2E0C 0B18 0709 180B 0B30 0C07 180A 0C18"
	$"0706 2F0F 0F18 071C 5256 3021 1818 421B"
	$"1F2E 2727 4B27 1B2D 272A 2D1B 1840 2726"
	$"5E2E 1D1E 2D27 274B 271D 2E27 2A2E 1D15"
	$"3D27 272E 1B1F 2E27 274B 271B 2D27 2A2A"
	$"1818 3E25 252E 1D1E 2D27 264C 271D 2F27"
	$"2A2F 1D15 3D27 272D 1B1E 2B27 274B 271B"
	$"2D27 2A2D 1B18 4027 262E 1D1E 2D27 274C"
	$"271D 2E25 272E 1D15 3D30 302D 1B40 718F"
	$"0162 6C10 012B 1201 0E00 2900 0E00 0029"
	$"0128 0029 0112 0200 2802 2900 2900 0E00"
	$"002A 0227 0029 0210 0000 2801 2900 2900"
	$"0C00 0129 0128 002A 0211 0201 2802 2901"
	$"2B00 0E00 0027 0227 0029 0210 0000 2801"
	$"2900 2900 0C00 0029 0128 0029 0112 0200"
	$"2702 2900 2900 0E00 002A 0227 0029 0229"
	$"FE00 0F29 0126 003C 190A 2E17 0916 072F"
	$"0C19 0B7F 0C2F 092F 0B2F 0817 060C 2F09"
	$"2F07 2F0C 190B 0C30 0930 0C2F 0918 060C"
	$"2F09 2F07 2F0E 1A0B 0D2F 092F 0B30 0816"
	$"070C 3009 2F06 2E0C 190C 0D2E 0930 0C2F"
	$"0918 060C 2F09 2F07 2F0D 1A0B 0C2F 092F"
	$"0B2F 0817 060D 3009 2F07 2F0C 190C 0D30"
	$"092F 0A2F 092F 060F 112F 0931 114F 3222"
	$"402A 1E2B 1D43 2A38 272A 421E 4B27 421D"
	$"2A18 2A4B 5E1F 431B 422A 3827 2A44 1F4C"
	$"2743 1F28 152A 4B1E 421D 432B 3827 2B42"
	$"1E4B 2741 1B29 1A27 491F 431B 422A 3827"
	$"2A42 1F4C 2743 1F28 152A 4B1E 421B 422A"
	$"3827 2A42 1E4B 2742 1D2A 182A 4C1F 431B"
	$"422A 3827 2A44 1F49 2543 1F3D 1530 3342"
	$"1E53 338A 00FF"
};
