%
%  Wordstar Mode for JED   ------- Pre ALPHA version
%
%   Put the line: "wordstar.sl" evalfile pop
%   in your jed.rc startup file.
%

Help_File = Null_String;

. " Jed %v : %b   (%m%n)   (%p %c)"
#ifdef MSDOS
.  "   %t" strcat
#endif
. 1 set_status_line

. Null_String =Help_File  % no help file yet

. 30 set_abort_char    % ^^ (Control 6 on most keyboards)
% Note, the above command BREAKS ^G emacs abort.
. "^K"	unsetkey 
. "^X"	unsetkey
. "^W"	unsetkey
. "^F"	unsetkey
. "next_char_cmd"		"^D"	setkey
. "previous_char_cmd"	"^S"	setkey
. "previous_line_cmd"	"^E"	setkey
. "next_line_cmd"		"^X"	setkey
. "page_up"		"^R"	setkey
. "page_down"		"^C"	setkey
. "skip_word"		"^F"	setkey
. "bskip_word"		"^A"	setkey
. "delete_char_cmd"	"^G"	setkey 
. "ws_delete_word"	"^T"	setkey
. "ws_delete_line"	"^Y"	setkey
. "ws_repeat_search"	"^L"	setkey
. "ws_window_up"		"^W"	setkey
. "ws_window_down"	"^Z"	setkey % Lose ^Z suspension
%
% Control-Q keys  --- hope you figure out how to pass ^Q/^S through system
%
. "eol"			"^Q^D"	setkey
. "eol"			"^QD"	setkey
. "bol"			"^Q^S"	setkey
. "bol"			"^QS"	setkey
. "bob"			"^Q^R"	setkey
. "bob"			"^QR"	setkey
. "eob"			"^Q^C"	setkey
. "eob"			"^QC"	setkey
. "ws_search"		"^Q^F"	setkey
. "ws_search"		"^QF"	setkey
. "replace_cmd"		"^Q^A"	setkey
. "replace_cmd"		"^QA"	setkey
. "kill_line"		"^Q^Y"	setkey
. "kill_line"		"^QY"	setkey
. "goto_top_of_window"	"^QE"	setkey
. "goto_top_of_window"	"^Q^E"	setkey
. "goto_bottom_of_window"	"^Q^X"	setkey
. "goto_bottom_of_window"	"^QX"	setkey
%
% Control-K map
%
. "ws_begin_block"	"^K^B"	setkey
. "ws_begin_block"	"^KB"	setkey
. "ws_end_block"		"^K^K"	setkey
. "ws_end_block"		"^KK"	setkey
. "ws_delete_block"	"^K^Y"	setkey
. "ws_delete_block"	"^KY"	setkey
. "ws_copy_block"		"^K^C"	setkey
. "ws_copy_block"		"^KC"	setkey
. "insert_file"		"^K^R"	setkey
. "insert_file"		"^KR"	setkey
. "ws_save_buffer"	"^K^S"	setkey
. "ws_save_buffer"	"^KS"	setkey
. "exit_jed"		"^K^Q"	setkey
. "exit_jed"		"^KQ"	setkey
. "ws_exit_jed"		"^K^D"	setkey
. "ws_exit_jed"		"^KD"	setkey

. ( window_line 1 + recenter ) ws_window_up
. ( window_line 1 - recenter ) ws_window_down
% Not implemented:
%    ^K^H  - Hide or unhide the currently selected block

. ( search_forward ) ws_search
. ( 1 right pop LAST_SEARCH fsearch {"Not found" error} !if ) ws_repeat_search



% the blocks are very different.  Here we cheat.  Two marks are pushed--
% One at beginning of block and one at end.  Assumption is that the spots
% we see are the ones we put.

. [WS_Mark_Pushed] 0 =WS_Mark_Pushed

. (
.   1 WS_Mark_Pushed 1 { pop 0 pop_mark } _for
.   1 =WS_Mark_Pushed
.   push_mark push_mark
.   "set_mark_cmd" call
.   "Begin Block."  message
. ) ws_begin_block

. (
.   WS_Mark_Pushed 1 != 
.     {
.        WS_Mark_Pushed {0 pop_mark} loop 0 =WS_Mark_Pushed 
.        "Begin Block First!" error 
.     } if
.   markp {0 =WS_Mark_Pushed "Wordstar Error." error } !if
.   2 =WS_Mark_Pushed
.   0 pop_mark           % pops visible mark from begin block
.   push_mark
.   "Block Defined." message
. ) ws_end_block

. (
   % want 2 marks or we signal error
.    WS_Mark_Pushed 2 < { "Block Not defined." error} if
   
.    1 pop_mark del_region
. ) ws_delete_block

% copies block to internal buffer-- preserves block
. [WS_Block_Buffer] " *ws-internal*" =WS_Block_Buffer
. (
.    WS_Mark_Pushed 2 < { "Block Not defined." error} if
.    push_spot
.    1 pop_mark % end of block
.    dupmark pop   % dup beginning because we want to keep it
.    whatbuf 
.       WS_Block_Buffer setbuf erase_buffer
.    setbuf
.    WS_Block_Buffer copy_region
.    push_mark
.    pop_spot
. ) ws_copy_block_to_buffer

. (
.   ws_copy_block_to_buffer
.   WS_Block_Buffer insbuf
.   "Region Copied." message
. ) ws_copy_block
  

. (
.    [flags dir file]
.    getbuf_info =flags pop =dir =file
.    flags 1 & {return} !if  % buffer not modified
.    file strlen 
.     {dir file dircat write_buffer pop}
.     {"save_buffers" call} 
.    else
. ) ws_save_buffer

. ( ws_save_buffer exit_jed ) ws_exit_jed
. ( bol push_mark eol 1 right pop del_region) ws_delete_line

. (
.   push_mark
.   POINT " \t" skip_chars POINT -
.   {skip_word} !if
.   del_region
. ) ws_delete_word
