#!/bin/sh

umask 022

if [ -e /etc/ld.so.cache ] ; then
	echo Deleting old /etc/ld.so.cache
	rm -f /etc/ld.so.cache
fi

if [ ! -e /etc/ld.so.conf ] ; then
	for dir in /usr/local/lib /usr/openwin/lib /usr/X386/lib ; do
		if [ -d $dir ] ; then
			echo Adding $dir to /etc/ld.so.conf
			echo $dir >> /etc/ld.so.conf
		fi
	done
fi

echo Installing ldd in /usr/bin
install -c ldd /usr/bin

if [ -e /lib/ld.so ] ; then
	echo Backing up existing ld.so
	ln -f /lib/ld.so /lib/ld.so.old
fi
echo Installing ld.so in /lib
install -c ld.so /lib/ld.so.new
ln -f /lib/ld.so.new /lib/ld.so
rm /lib/ld.so.new

if [ -d /sbin ] ; then
	echo Installing ldconfig in /sbin
	install -c ldconfig /sbin
	/sbin/ldconfig
else
	echo Installing ldconfig in /etc
	install -c ldconfig /etc
	/etc/ldconfig
fi

echo Installing libldso.a in /usr/lib
install -c -m 644 libldso.a /usr/lib

echo Installing manual pages in /usr/man
install -c -m 644 ldd.1 /usr/man/man1
install -c -m 644 ldconfig.8 ld.so.8 /usr/man/man8

echo Installation complete
