/*
 *  krt_symbols_nlist.c,v 1.3 1993/04/04 16:28:13 jch Exp
 */

/* Gated Release 3.0 */
/* Copyright (c) 1990,1991,1992,1993 by Cornell University. All rights reserved. */
/* Refer to Particulars and other Copyright notices at the end of this file. */


#define	INCLUDE_NLIST
#define	INCLUDE_IOCTL
#define	INCLUDE_KVM
#define	INCLUDE_NETOPT_IBMR2
#include "include.h"
#ifdef	PROTO_INET
#include "inet.h"
#endif	/* PROTO_INET */
#include "krt.h"
#include "krt_var.h"


#ifdef	PROTO_INET
static struct nlist *krt_ipforwarding;
static struct nlist *krt_udpcksum;
#endif	/* PROTO_INET */

static struct nlist *krt_version;
static struct nlist *krt_rthsz;
static struct nlist *krt_rth[2];

static struct {
    const char *nl_name;
    struct nlist **nl_ptr;
} nl_names[] = {
    {"_rthost", &krt_rth[KRT_RTHOST]},
    {"_rtnet", &krt_rth[KRT_RTNET]},
    {"_rthashsize", &krt_rthsz},
#ifdef	KRT_LLADDR_KMEM
    {"_ifnet", &krt_ifnet},
#endif	/* KRT_LLADDR_KMEM */
#ifdef	PROTO_INET
    {KSYM_IPFORWARDING, &krt_ipforwarding},
    {KSYM_UDPCKSUM, &krt_udpcksum},
#endif	/* PROTO_INET */
#ifndef	VRS_SYM
#define	VRS_SYM	"_version"
#endif	/* VRS_SYM */
    {VRS_SYM, &krt_version},
    {NULL, NULL}
};

#define	NL_SIZE	(sizeof (nl_names)/sizeof (nl_names[0]))


int
krt_symbols __PF0(void)
{
    int i;
    static struct nlist nl[NL_SIZE];

    for (i = NL_SIZE; i--;) {
	register struct nlist *nlp = &nl[i];

	/* Use bcopy to avoid warning about const char * */
	bcopy((caddr_t) &nl_names[i].nl_name, (caddr_t) &nlp->n_un.n_name, sizeof(char *));
	if (nl_names[i].nl_ptr) {
	    *nl_names[i].nl_ptr = nlp;
	}
    }

/*    if (KVM_NLIST(kd, nl) < 0) {
	trace(TR_ALL, LOG_ERR, "krt_symbols: %s",
	      KVM_GETERR(kd, "kvm_nlist error"));

	return EINVAL;
    } 

    if (krt_version->n_value) {
	char *p;

	krt_version_kernel = (char *) task_block_alloc(task_block_pagesize);
	if (KVM_READ(kd,
		     (off_t) krt_version->n_value,
		     krt_version_kernel,
		     task_pagesize - 1) < 0) {
	    trace(TR_ALL, LOG_ERR, "krt_symbols: reading kernel version: %s",
		  KVM_GETERR(kd, "kvm_read error"));
	    return EINVAL;
	}
	if (p = (char *) index(krt_version_kernel, '\n')) {
	    *p = (char) 0;
	}
	p = task_mem_strdup(krt_task, krt_version_kernel);
	task_block_free(task_block_pagesize, krt_version_kernel);
	krt_version_kernel = p;
	trace(TR_KRT, 0, NULL);
	trace(TR_KRT, 0, "krt_symbols: %s = %s",
	      krt_version->n_un.n_name,
	      krt_version_kernel);
    }

#ifdef	PROTO_INET
    if (krt_ipforwarding->n_value) {
	if (KVM_READ(kd,
		     (off_t) krt_ipforwarding->n_value,
		     (caddr_t) &inet_ipforwarding,
		     sizeof(inet_ipforwarding)) < 0) {
	    trace(TR_ALL, LOG_INFO, "krt_symbols: reading IP forwarding enable flag: %s",
		  KVM_GETERR(kd, "kvm_read error"));
	}
    }
    if (krt_udpcksum->n_value) {
	if (KVM_READ(kd,
		     (off_t) krt_udpcksum->n_value,
		     (caddr_t) &inet_udpcksum,
		     sizeof(inet_udpcksum)) < 0) {
	    trace(TR_ALL, LOG_INFO, "krt_symbols: reading UDP checksum enable flag: %s",
		  KVM_GETERR(kd, "kvm_read error"));
	}
    }
#endif	/* PROTO_INET */
    return 0;
}

