.TH iclass 1 "29 November 1989" "InterViews" "InterViews Reference Manual"
.SH NAME
iclass \- class browser
.SH SYNOPSIS
.B iclass
.RB [ -r ]
.RB [ -v ]
.RB [ -c ]
.I path
.RI [ path... ]
.SH DESCRIPTION
.I Iclass
is a simple class browser that lets you navigate through C++ class
hierarchies and view the definition of a particular class.  You can
select classes from three browsers: the first shows a list of all
known classes; the second shows the parents of the selected class, if
any; and the third shows the children of the selected class, if any.
You can choose a name from any of these lists and tell \fIiclass\fP to
show the definition of that class, or you can type the name of a class
explicitly in the StringEditor labeled ``selected class.''  The view
of the class definition shows the source code from the header file
that defines the selected class.
.SH ARGUMENTS
\fIIclass\fP interprets arguments that specify the header files to
search for class definitions.
Each non-option argument on the command line should specify a pathname
to a header file or a directory containing header files.
If the pathname is a filename ending in the suffix ``.h'',
then \fIiclass\fP will scan that header file.
If the pathname is a directory,
then it will scan every header file in that directory.
\fIIclass\fP will ignore filenames that do not end in the suffix ``.h'',
unless the ``\-c'' option is given.
In this case \fIiclass\fP will search both ``.h'' and ``.C'' files for
class definitions.
.PP
You may use any of the standard options accepted by InterViews
programs in addition to the following options:
.TP
.B \-r
Recursively scan subdirectories for additional header files when
scanning a directory.
.TP
.B \-v
Verbosely print the name of every header file scanned.
.TP
.B \-c
Allow \fIiclass\fP to search ``.C'' files as well as ``.h'' for class
definitions.
This option should be used carefully.
Because of the way that iclass searches for definitions, it is possible
for it to get confused by code in a ``.C'' file and think it is a definition.
Nonetheless, this is a useful option if there are C++ input files that
contain definitions.
.SH COMMANDS
\fIIclass\fP provides pull-down menus for issuing commands.  The
``File'' menu includes the following commands:
.TP 4
.B "Scan Files/Directories..."
Prompt for additional pathnames to scan.
.TP
.B "Clear Classes"
Purge iclass of all classes it has scanned.
.TP
.B Quit
Close the window and exit.
.PP
Commands in the ``Search'' menu include:
.TP
.B "Forward Search..."
Search forward in the class definition for a match with a given
regular expression, wrapping from the end to the beginning of the
buffer if necessary.
.TP
.B "Backward Search..."
Search backward for a match with a given regexp.
.TP
.B "Go to Line..."
Move the cursor to the beginning of the given line, scrolling the
display if necessary.
.SH MOUSE BINDINGS
The left mouse button selects text.  Left-clicking inside a browser,
StringEditor, or class definition also focuses keyboard input to it,
which lets it interpret subsequent keyboard commands as scrolling or
selection operations.  Double left-clicking inside a browser is
equivalent to selecting a class and then pressing the ``Show'' button.
.PP
The middle and right mouse buttons scroll text in different ways.
Middle-clicking lets you ``grab-scroll'' the text.  During
grab-scrolling, the text is scrolled to follow the mouse position,
making it appear as though you are dragging the text itself.
Right-clicking engages ``rate-scrolling,'' a joy-stick-like scrolling
interface in which the scrolling rate increases as you drag the mouse
away from the initial click point.  For example, dragging the mouse
downwards after the initial click scrolls a browser downwards at an
increasing rate; dragging upwards thereafter reduces the rate until
scrolling stops entirely at the initial click point.  Dragging up
beyond this point makes the browser scroll in the reverse direction.
.SH KEYBOARD BINDINGS
For convenience, all menu commands have keyboard equivalents:
.TP
.B "(^V)"
Scan a file or directory.
.TP
.B "(^Q)"
Quit.
.TP
.B "(^S)"
Search forward.
.TP
.B "(^R)"
Search backward.
.TP
.B "(^N)"
Go to a line.
.PP
\fIIclass\fP also provides keyboard commands for changing focus:
.TP
.B "ESC or TAB"
Set focus to the StringEditor showing the selected class.
.TP
.B "CR"
Show the selected class (equivalent to pressing the Show button) and
set focus to the class definition.
.SH SEE ALSO
Regexp(3I), StringBrowser(3I), StringEditor(3I), TextEditor(3I)
