#include <stdio.h>

main()
{
  int u,s;
  
  printf("Minimum uid for restriction is: %d\n",MinLimitUid());
  printf("Maximum size of an acceptable mailbox is: %d\n",MailLimit());
  for (u=MinLimitUid()-1;u<MinLimitUid()+2;u++)
    for (s=MailLimit()-1;s<MailLimit()+2;s++)
      printf("User %d Size %d is %s.\n",u,s,OverMailLimit(u,s)?"bad":"ok");
}

static int MinUser = -1;
static int MaxSize = -1;

static void InitMailLimit();

/*
 * return the minimum uid to which the mailbox quota applies
 * returns 0 if no mailbox quotas are enabled
 */
int
MinLimitUid()
{
	InitMailLimit();
	return (MinUser);
}

/*
 * return the maximum permissible size of a system mailbox, for users
 * to which the quota applies
 */
int
MailLimit()
{
	InitMailLimit();
	return (MaxSize);
}

/*
 * Is the given user over his or her quota?  returns nonzero if yes,
 * zero for no
 */
int
OverMailLimit(uid, size)
	int uid;	/* the uid in question */
	int size;	/* the size of the mailbox */
{
	InitMailLimit();
	return (MinUser && uid >= MinUser && MaxSize && size > MaxSize);
}

/*
 * read our configuration file.  QUOTAFILE should be the subject of a -D
 * define at compile time.  The configuration file should consist of two
 * numbers; the first is the minimum uid to which the mail limit should
 * apply, and the second is the maximum size a mailbox can be and still
 * have messages deposited into it.  These values should be on separate
 * lines.  Any number of comment lines (beginning with a '#') or blank
 * lines may be present.  After finding its second number, the function
 * closes the file.
 * Here is a sample configuration file:
 *	# those users with uid's greater than or equal to:
 *	200
 *	# may have mailboxes no bigger than:
 *	69999
 *	# if they want to have their mail delivered to them.
 */
static void
InitMailLimit()
{
	char buf[256];
	FILE *cfig;
	int foundUser = 0;
	int value;
  
	if (MinUser != -1)
		return;
	MinUser = MaxSize = 0;
	if ((cfig = fopen(QUOTAFILE, "r")) != NULL)
	{
		while (fgets(buf, sizeof(buf), cfig))
			if (*buf != '#' && sscanf(buf, "%d", &value))
				if (!foundUser)
				{
					MinUser = value;
					foundUser++;
				}
				else
				{
					MaxSize = value;
					break;
				}
		fclose(cfig);
	}
}
