/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	attr.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Various attribute related classes
 *
 *	RCSid = "$Id: attr.H,v 4.6.1.1 1993/06/01 22:52:19 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_attr_H
#define OI_attr_H

	class OI_pixmap;
	class OI_connection;

	class OI_attr {
		private:
			OI_attr		*nxt;
			OI_attr		*prv;
			unsigned long	ref_cnt;
			short unsigned	bytelen;
		protected:
			short unsigned	cksum;
		protected:
			void		unref()			{ --ref_cnt; }		/* special use by OI_font only! */
		public:
					OI_attr(short unsigned);
		virtual			~OI_attr();
			short unsigned	byte_length()		{ return (bytelen); }
		virtual	OI_bool		compare(OI_attr *)=0;
		virtual	void		create(OI_connection *);
			void		deref()			{ if (--ref_cnt <= 0) delete this; }
		virtual	void		make_sum();
			OI_attr		*next()			{ return (nxt); }
			OI_attr		*prev()			{ return (prv); }
			void		ref()			{ ref_cnt++; }
			unsigned long	reference_count()	{ return (ref_cnt); }
		virtual	OI_attr		*search(OI_attr *);
			void		set_next(OI_attr *n)	{ nxt = n; }
			void		set_prev(OI_attr *p)	{ prv = p; }
			void		set_sum(short unsigned s)	{ cksum = s; }
			short unsigned	sum()			{ if (!cksum) make_sum(); return (cksum); }
	};

	class OI_attr_colors : public OI_attr {
		public:
			PIXEL		bkg_pxl ;		/* background pixel */
			PIXEL		fg_pxl ;		/* foreground pixel */
			PIXEL		bdr_pxl ;		/* border pixel */
			PIXEL		top_pxl ;		/* top bevel pixel */
			PIXEL		bot_pxl ;		/* bottom bevel pixel */
			PIXEL		dn_pxl ;		/* down bevel pixel */
			PIXEL		ffrm_pxl;		/* focus frame color pixel. */
			OI_pixmap	*ffrm_pm;		/* focus frame pixmap */
		public:
					OI_attr_colors();
		virtual			~OI_attr_colors();
			PIXEL		bdr_pixel()			{ return (bdr_pxl); }
			PIXEL		bkg_pixel()			{ return (bkg_pxl); }
			PIXEL		bottom_pixel()			{ return (bot_pxl); }
			OI_attr_colors	*clone();
		virtual	OI_bool		compare(OI_attr *);
			PIXEL		down_pixel()			{ return (dn_pxl); }
			PIXEL		fg_pixel()			{ return (fg_pxl); }
			OI_pixmap	*focus_frame_pixmap()		{return(ffrm_pm);}
			PIXEL		focus_frame_pixel()		{return(ffrm_pxl);}
			PIXEL		top_pixel()			{ return (top_pxl); }
			void		set_bdr_pixel(PIXEL p)		{ bdr_pxl = p; }
			void		set_bkg_pixel(PIXEL p)		{ bkg_pxl = p; }
			void		set_bottom_pixel(PIXEL p)	{ bot_pxl = p; }
			void		set_down_pixel(PIXEL p)		{ dn_pxl = p; }
			void		set_fg_pixel(PIXEL p)		{ fg_pxl = p; }
			void		set_focus_frame_pixmap(OI_pixmap *p)	{ ffrm_pm = p; }
			void		set_focus_frame_pixel(PIXEL p)	{ ffrm_pxl = p; }
			void		set_top_pixel(PIXEL p)		{ top_pxl = p; }
	};

	class OI_attr_layout : public OI_attr {
		public:
			OI_number	tp_sp ;			/* required space at top */
			OI_number	bt_sp ;			/* required space at bottom */
			OI_number	lf_sp ;			/* required space at left */
			OI_number	rt_sp ;			/* required space at right */
			OI_gravity	grav ;			/* gravity */
			OI_size_track	size_trk ;		/* how the object should track the parent's size */
			OI_number	def_hz_sp ;		/* default horizontal space for children */
			OI_number	def_vt_sp ;		/* default vertical space for children */
		public:
					OI_attr_layout();
		virtual			~OI_attr_layout();
			OI_attr_layout	*clone();
		virtual	OI_bool		compare(OI_attr *);
			OI_number	top_space()			{ return(tp_sp); }
			OI_number	bottom_space()			{ return(bt_sp); }
			OI_number	left_space()			{ return(lf_sp); }
			OI_number	right_space()			{ return(rt_sp); }
			OI_gravity	gravity()			{ return(grav); }
			OI_size_track	size_track()			{ return(size_trk); }
			OI_number	def_horizontal_space()		{ return(def_hz_sp); }
			OI_number	def_vertical_space()		{ return(def_vt_sp); }

			void	set_top_space(OI_number s)		{ tp_sp = s; }
			void	set_bottom_space(OI_number s)		{ bt_sp = s; }
			void	set_left_space(OI_number s)		{ lf_sp = s; }
			void	set_right_space(OI_number s)		{ rt_sp = s; }
			void	set_gravity(OI_gravity g)		{ grav = g; }
			void	set_size_track(OI_size_track s)		{ size_trk = s; }
			void	set_def_horizontal_space(OI_number s)	{ def_hz_sp = s; }
			void	set_def_vertical_space(OI_number s)	{ def_vt_sp = s; }
	};

	class OI_attr_misc : public OI_attr {
		public:
			OI_number	bdr_wid ;		/* border width */
			OI_number	bvl_wid ;		/* 3D bevel width */
			OI_bevel_style	bvl_styl;		/* style of 3D bevel width */
			OI_number	ffrm_wid;		/* focus frame width. */
			int		csr_idx ;		/* index to cursor in cursor font; -1 => not a font cursor */
			Cursor		csr ;			/* cursor to use when in object */
			OI_model_type	mdl ;			/* interaction model */
		public:
					OI_attr_misc();
		virtual			~OI_attr_misc();
			OI_attr_misc	*clone();
		virtual	OI_bool		compare(OI_attr *);
		virtual	void		make_sum();
			OI_number	border_width()			{ return(bdr_wid); }
			OI_number	bevel_width()			{ return(bvl_wid); }
			OI_bevel_style	bevel_style()			{ return(bvl_styl); }
			OI_number	focus_frame_width()		{ return(ffrm_wid); }
			int		cursor_index()			{ return(csr_idx); }
			Cursor		cursor()			{ return(csr); }
			OI_model_type	model()				{ return (mdl); }

			void		set_abs_model(OI_model_type m)	{ mdl = m; }
			OI_attr_misc	*set_border_width(OI_connection*, OI_number);
			OI_attr_misc	*set_bevel_width(OI_connection*, OI_number);
			OI_attr_misc	*set_bevel_style(OI_connection*, OI_bevel_style);
			void		set_abs_focus_frame_width(OI_number w)		{ ffrm_wid = w; }
			OI_attr_misc	*set_focus_frame_width(OI_connection*, OI_number);
			OI_attr_misc	*set_cursor_index(OI_connection*, int);
			OI_attr_misc	*set_cursor(OI_connection*, Cursor);
			OI_attr_misc	*set_model(OI_connection*, OI_model_type);
	};


#endif /* OI_attr_H */
