/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	callback.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_callback class header
 *		OI_callback's sole purpose is to provide an ancestor class for
 *		OI_d_tech and user defined classes such that user defined
 *		objects can have their member functions used as callbacks.
 *		Any user defined classes which are going to have member
 *		functions used as callbacks must be derived from OI_callback.
 *
 *		OI_callback has been superceded by CommonBase
 *
 *	RCSid = "$Id: callback.H,v 4.5.1.1 1993/06/01 22:53:06 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_callback_H
#define OI_callback_H

#ifdef CPLUSPLUS20
// use NULL_PMF to get around a C++ 2.00.04 bug when initializing struct fields to a NULL ptr to member function
#define NULL_PMF	{0}
#else
#define NULL_PMF	0
#endif

#ifndef ComBas_H
#include <OI/ComBas.H>
#endif /* ComBas_H */

#define OI_callback CommonBase

#endif /* OI_callback_H */
