/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1992, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	d_tech.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_d_tech class header
 *		OI_d_tech is the base class for all displayable OI objects
 *		conceptually, although it is actually derived from OI_callback
 *		to allow callbacks to user object member functions to work.
 *
 *	RCSid = "$Id: d_tech.H,v 4.93.1.10 1993/08/16 17:59:17 toml Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_d_tech_H
#define OI_d_tech_H

#ifndef OI_defs_H
#include <OI/defs.H>
#endif /* OI_defs_H */

#ifndef OI_globals_H
#include <OI/globals.H>
#endif /* OI_globals_H */

#ifndef OI_functs_H
#include <OI/functs.H>
#endif /* OI_functs_H */

#ifndef OI_layout_H
#include <OI/layout.H>
#endif /* OI_layout_H */

#ifndef OI_scroll_H
#include <OI/scroll.H>
#endif /* OI_scroll_H */

#ifndef OI_connect_H
#include <OI/connect.H>
#endif /* OI_connect_H */

#ifndef OI_selection_H
#include <OI/selection.H>
#endif /* OI_selection_H */

#ifndef OI_attr_H
#include <OI/attr.H>
#endif /* OI_attr_H */

	// class forward reference declaration
	class OI_mdl_d_tech;
	class OI_action_table_rec;
	class OI_app_window;
	class OI_cb_inf;
	class OI_cb_class;
	class OI_ctlr_1d;
	class OI_dnd_drop_sites;
	class OI_geometry;
	class OI_layout_method;
	class OI_layout_slot;
	class OI_lw_quark_array;
	class OI_panner;
	class OI_pixmap;
	class OI_quark_pointer;
	class OI_selection;
	class OI_size_constraints;
	class OI_string;
	class OI_tab_obj;
	class OI_tab_group;
	class OI_tm_record;
	class OI_translation_table;

	struct OI_alpha_callback;
	struct OI_xrm_resource;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_resize_fn)(OI_d_tech*,void*) ;			/* callback function when resize occurs */
	typedef	void	(OI_callback::OI_resize_memfn)(OI_d_tech*,void*) ;	/* callback member function when resize occurs */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_resize_fnp)(OI_d_tech*,void*) ;			/* callback function when resize occurs */
	typedef	void	(OI_callback::*OI_resize_memfnp)(OI_d_tech*,void*) ;	/* callback member function when resize occurs */
#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_destroy_fn)(OI_d_tech*,void*) ;			/* callback function when object is destroyed */
	typedef	void	(OI_callback::OI_destroy_memfn)(OI_d_tech*,void*) ;	/* callback member function when object is destroyed */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_destroy_fnp)(OI_d_tech*,void*) ;			/* callback function when object is destroyed */
	typedef	void	(OI_callback::*OI_destroy_memfnp)(OI_d_tech*,void*) ;	/* callback member function when object is destroyed */
#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_focus_fn)(OI_d_tech*,void*) ;			/* callback function when input focus changes */
	typedef	void	(OI_callback::OI_focus_memfn)(OI_d_tech*,void*) ;	/* callback member function when input focus changes */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_focus_fnp)(OI_d_tech*,void*) ;			/* callback function when input focus changes */
	typedef	void	(OI_callback::*OI_focus_memfnp)(OI_d_tech*,void*) ;	/* callback member function when input focus changes */

#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_drag_preview_fn)(OI_d_tech*,void*,OI_dnd_operation,long,long) ;			/* callback function when drag occurs */
	typedef	void	(OI_callback::OI_drag_preview_memfn)(OI_d_tech*,void*,OI_dnd_operation,long,long) ;	/* callback member function when drag occurs */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_drag_preview_fnp)(OI_d_tech*,void*,OI_dnd_operation,long,long);			/* callback function when drag occurs */
	typedef	void	(OI_callback::*OI_drag_preview_memfnp)(OI_d_tech*,void*,OI_dnd_operation,long,long) ;	/* callback member function when drag occurs */
#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_drop_fn)(OI_d_tech*,void*,OI_dnd_operation,long,long) ;			/* callback function when drop occurs */
	typedef	void	(OI_callback::OI_drop_memfn)(OI_d_tech*,void*,OI_dnd_operation,long,long) ;	/* callback member function when drop occurs */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_drop_fnp)(OI_d_tech*,void*,OI_dnd_operation,long,long) ;			/* callback function when drop occurs */
	typedef	void	(OI_callback::*OI_drop_memfnp)(OI_d_tech*,void*,OI_dnd_operation,long,long) ;	/* callback member function when drop occurs */
#ifdef TYPEDEF_MEMFN
	typedef	void	(OI_drop_preview_fn)(OI_d_tech*,void*,OI_dnd_operation,long,long) ;			/* callback function when drop occurs */
	typedef	void	(OI_callback::OI_drop_preview_memfn)(OI_d_tech*,void*,OI_dnd_operation,long,long) ;	/* callback member function when drop occurs */
#endif /* TYPEDEF_MEMFN */
	typedef	void	(*OI_drop_preview_fnp)(OI_d_tech*,void*,OI_dnd_operation,long,long);			/* callback function when drop occurs */
	typedef	void	(OI_callback::*OI_drop_preview_memfnp)(OI_d_tech*,void*,OI_dnd_operation,long,long) ;	/* callback member function when drop occurs */


 /* OI_d_tech class */

                //-------------------------------------------------------------------------------------------------
                //
                //      END OF DOCUMENTED SECTION
                //
                //-------------------------------------------------------------------------------------------------

 /* control bits for cnstrnts member */
#define		OI_HORZ_MOVE		0x1L		/* technique is moveable horizontally */
#define		OI_VERT_MOVE		0x2L		/* technique is moveable vertically */
#define		OI_MOVE			(OI_HORZ_MOVE|OI_VERT_MOVE)	/* technique is moveable some way */
#define		OI_HORZ_RESIZE		0x4L		/* technique is resizeable horizontally */
#define		OI_VERT_RESIZE		0x8L		/* technique is resizeable vertically */
#define		OI_RESIZE		(OI_HORZ_RESIZE|OI_VERT_RESIZE)	/* technique is resizeable somehow */
#define		OI_ROOT_CONFIGURE	0x10L		/* object does not have OI_NO_CLIP set, but has root level configuration callback */
#define		OI_USER_VAR		0x20L		/* user program needs variable named after object */
#define		OI_MAP_RAISED		0x40L		/* raise window when mapped */
#define		OI_USER_ARG		0x80L		/* object value may be used as argument in OI_form_cmd */
#define		OI_USER_ARG_RQD		0x100L		/* user arg can't be empty */
#define		OI_D_TECH_IN_MY_CTOR	0x200L		/* in d_tech constructor */
#define		OI_RES_FETCHED		0x200L		/* temp flag used in get_child_resources; OK to overload on OI_D_TECH_IN_MY_CTOR */
#define		OI_NO_CLIP		0x400L		/* X_window is parented to root; origin.* are parent relative */
#define		OI_CREATED_CHILDREN	0x800L		/* All children not in NOT_DISPLAYED state have been created */
#define		OI_IS_ORPHANAGE		0x1000L		/* object is orphanage */
#define		OI_TRACK_UNMAP		0x2000L		/* object is unmapped because it is tracking and not visible */
#define		OI_NEEDS_RESIZE		0x4000L		/* 1 => object needs to be resized following resource fetch */
#define		OI_TRANSLATIONS_ENABLED	0x8000L		/* translations have been enabled */
#define		OI_DEF_PLACE		0x10000L	/* object is placed at default location */
#define		OI_TRANSIENT		0x20000L	/* X window has WM_TRANSIENT_FOR property set */
#define		OI_GROUP		0x40000L	/* X window has group id set */
#define		OI_CB_REFRESH		0x80000L	/* 1 => callback being refreshed */
#define		OI_VIR_ROOT_NTFY	0x100000L	/* PropertyNotify for virtual root change has been set */
#define		OI_OVERRIDE_REDIRECT	0x200000L	/* window has override redirect set */
#define		OI_OUTSIDE_REL		0x400000L	/* window location is relative to outside decoration */
#define		OI_FORCE_WITHIN_ROOT	0x800000L	/* window forced within absolute root */
#define		OI_MODEL_INFO		0x1000000L	/* model info has been set */
#define		OI_INTERNAL_OBJECT	0x2000000L	/* object is an internal OI object, not one created by the user */
#define		OI_GRAVITY_SET		0x4000000L	/* gravity was set via set_gravity (shorthand for is_req(q_gravity) */
#define		OI_FOCUS_NTFY		0x8000000L	/* Focus notify events have been set */
#define		OI_NEEDS_FOCUS		0x10000000L	/* the object needs the keyboard focus events */
#define		OI_HAS_FOCUS		0x20000000L	/* object has the input focus */
#define		OI_DISABLE		0x40000000L	/* the object is disabled (differs from state==OI_INACTIVE), used mainly by prototyper */
#define		OI_IS_ROOT		0x80000000L	/* object is a root object */
 /* control bits for cnstrnts2 member */
#define		OI_TRACK_HORIZONTAL	0x1L		/* object tracks parent movement horizontally */
#define		OI_TRACK_VERTICAL	0x2L		/* object tracks parent movement vertically */
#define		OI_ADOPTING		0x4L		/* the object is being adopted, layout is inconsistent */
#define		OI_SUSPENDED		0x8L		/* On if object inactive or its parent inactive. */
#define		OI_BKG_IS_DOWN		0x10L		/* use down pixel for background */
#define		OI_NO_MY_RESOURCES	0x20L		/* don't fetch resources on this object */
#define		OI_CLICK_TO_TYPE	0x40L		/* click to type has been selected */
#define		OI_DRAGGING		0x80L		/* a drag and drop operation is in process */
// #define		OI_unused	0x100L		/* 1 => */
#define		OI_INDEPENDENT_LOC	0x200L		/* unclipped object should not track its parent loc */
#define		OI_ALLOW_TRANSLATIONS	0x400L		/* Don't put any translations on this object. */
#define		OI_VALID_PARENT		0x800L		/* parent() should stop at object even though it is marked as internal */
#define		OI_IN_UNPARENT		0x1000L		/* object is being unparented but not yet removed from property vector */
#define		OI_TAKES_FOCUS		0x2000L		/* object can take focus when the WM sends client message:take_focus. */
#define		OI_AUTO_ACCELERATORS	0x4000L		/* object should automatically have its accelerators installed */
#define		OI_RES_CHILDREN		0x8000L		/* we have gone through res_children() once */
// #define		OI_unused	0x10000L	/* 1 => */
#define		OI_ENABLE_NEEDS_FOCUS	0x20000L	/* OI_NEEDS_FOCUS bit is turned on only if this is on. */
#define		OI_TOP_SPACE		0x40000L	/* res_top_space() or set_top_space() has been called */
#define		OI_BOTTOM_SPACE		0x80000L	/* res_bottom_space() or set_bottom_space() has been called */
#define		OI_LEFT_SPACE		0x100000L	/* res_left_space() or set_left_space() has been called */
#define		OI_RIGHT_SPACE		0x200000L	/* res_right_space() or set_right_space() has been called */
//#define		OI_unused	0x400000L	/* */
#define		OI_RECORD_RES		0x800000L	/* record calls to "res" functions */
#define		OI_IN_GET_RESOURCES	0x1000000L	/* we are in the middle of get resources, set and cleard in cvt.OI */
#define		OI_IGNORE_HELP		0x2000000L	/* object inelegible for keyboard help */
#define		OI_INVALID		0x4000000L	/* object invalid (not actually deleted, but logically deleted, as in delete_delayed) */
#define		OI_MODIFIABLE_INTERNAL	0x8000000L	/* object is internal, but can be modified by user (e.g. via sproto) */
#define		OI_FROM_CONFIG		0x10000000L	/* 1 => Child was created by a config file somehow (eg a uib subclass) */
#define		OI_NO_RESOURCES		0x20000000L	/* 1 => remove this object from the stack before fetching child resources */
//#define		OI_unused	0x40000000L	/* 1 => */
#define		OI_UIB_TOP_LEVEL	0x80000000L	/* 1 => treat as top level for saving */

	class OI_d_tech : public CommonBaseWithId	{	/* generalized display technique */
			OI_mdl_d_tech	*mdl_dep ;		/* ptr to model dependent object */
	protected:
		static	XrmQuark	q_OI_accelerators;
		static	XrmQuark	q_OI_acceleratorsRecord;
		static	XrmQuark	q_OI_backgroundPixmap;
		static	XrmQuark	q_OI_colormap ;
		static	XrmQuark	q_OI_data;
		static	XrmQuark	q_OI_drag;
		static	XrmQuark	q_OI_language;
		static	XrmQuark	q_OI_mnemonics;
		static	XrmQuark	q_OI_mnemonicsRecord;
		static	XrmQuark	q_OI_placement;
		static	XrmQuark	q_OI_res_children;
		static	XrmQuark	q_accelerators;
		static	XrmQuark	q_background ;
		static	XrmQuark	q_backgroundPixmap;
		static	XrmQuark	q_bevelWidth;
		static	XrmQuark	q_bevelStyle;
		static	XrmQuark	q_borderColor;
		static	XrmQuark	q_borderWidth;
		static	XrmQuark	q_bottomBevelColor;
		static	XrmQuark	q_bottomSpace ;
		static	XrmQuark	q_cbClick ;		/* quark for click callback */
		static	XrmQuark	q_children ;
		static	XrmQuark	q_colormap;
		static	XrmQuark	q_cursor ;
		static	XrmQuark	q_defaultLanguage ;
		static	XrmQuark	q_downColor;
		static	XrmQuark	q_focusFramePixmap ;
		static	XrmQuark	q_focusFrameColor ;
		static	XrmQuark	q_focusFrameWidth ;
		static	XrmQuark	q_font;
		static	XrmQuark	q_foreground ;
		static	XrmQuark	q_frameWidth;
		static	XrmQuark	q_language ;
		static	XrmQuark	q_leftSpace ;
		static	XrmQuark	q_mnemonics ;
		static	XrmQuark	q_rightSpace ;
		static	XrmQuark	q_OI_sizeConstraints;
		static	XrmQuark	q_state;
		static	XrmQuark	q_topBevelColor;
		static	XrmQuark	q_topSpace ;
		static	XrmQuark	q_translations;
		static	XrmQuark	q_RTranslationTable;
		static	XrmQuark	q_RClass;
		static	XrmQuark	q_RString;
		static	XrmQuark	q_x;
		static	XrmQuark	q_callbacks;
		static	XrmQuark	q_y;
		static	XrmQuark	q_width;
		static	XrmQuark	q_height;
		static	XrmQuark	q_helpTopic;
		static	XrmQuark	q_helpFile;
		static	XrmQuark	q_gravity;
		static	XrmQuark	q_sizeTrack;
		static	XrmQuark	q_layout;
		static	XrmQuark	q_row;
		static	XrmQuark	q_column;
		static	XrmQuark	q_defaultHorizontalSpace;
		static	XrmQuark	q_defaultVerticalSpace;
		static	XrmQuark	q_NnoInherit;
		static	XrmQuark	q_CNoInherit;
		static	XrmQuark	q_CFunction;
		static	XrmQuark	q_RQuotedStringList;
		static	XrmQuark	q_placement;
		static	XrmQuark	q_cbDrop ;		/* quark for drop callback */
		static	XrmQuark	q_cbDropPreview ;	/* quark for drop preview callback */
		static	XrmQuark	q_cbDestroy ;		/* quark for destroy callback */
		static	XrmQuark	q_cbDragPreview ;	/* quark for drag preview callback */
		static	XrmQuark	q_cbFocusin ;		/* quark for focus in callback */
		static	XrmQuark	q_cbFocusout ;		/* quark for focus out callback */
		static	XrmQuark	q_cbResize ;		/* quark for resize callback */
		static	XrmQuark	q_cbOIDestroy ;		/* quark for oi internal destroy callback */
		static	XrmQuark	q_cbOITrackReloc ;	/* quark for tracking object relocation callback */
		static	XrmQuark	q_cbSelectionConvert ;	/* quark for selection conversion callback */
	 protected:
			OI_lw_quark_array	*set_res;	/* resources that have been "set" */
			OI_lw_quark_array	*rec_res;	/* resources that have been recorded for output */
			OI_quark_pointer_array	*attr;		/* quark/attribute pair array */
			OI_attr_colors	*colors;		/* the colors that this object is using */
			OI_attr_layout	*layattr;		/* layout attributes of this object */
			OI_attr_misc	*misc;			/* misc attributes */
			OI_state	tech_state ;		/* current state of technique */
			OI_font_bounds 	*fntbnds ;		/* ptr to font bounds and font list for text object */
			OI_origin	origin  ;		/* upper left corner, relative to parent (0,0), pixels */
			OI_xy		extent  ;		/* size, pixels */
			OI_char_encode_type	char_encode_typ ;	/* encoding type for text */
			OI_connection	*conp ;			/* ptr to connection to X server this object is on */
			OI_class	*classp ;		/* ptr to class record for final object (e.g. OI_entry_field::clsp) */
			OI_d_tech	*prntp ;		/* ptr to parent technique, NULL if none */
			OI_number	nprop ;			/* # properties in property list */
			OI_number	mxprop ;		/* max # properties in property list */
			OI_d_tech	**propp ;		/* vector of techniques belonging to this technique */
			OI_origin	track_org ;		/* logical origin for object tracking a scrollable object */
			unsigned long	cnstrnts ;		/* misc control bits */
			unsigned long	cnstrnts2 ;		/* more misc control bits */
			OI_layout_method	*layoutp ;	/* ptr to geometry management layout object */
			OI_layout_slot	*slotp;			/* pointer to slot occupied by this object */
			OI_number	wl_cnt ;		/* count of windowless children */
			OI_number	help_posted ;		/* # help events outstanding for object */
			OI_tm_record	*trm;			/* translation management structures */
			OI_action_table_rec *actions;		/* translation management object action table */
			OI_tab_obj	*tab_obj;
			OI_tab_group	*tab_grp;
			OI_d_tech	*no_clp ;		/* ptr to chain of descendants with OI_NO_CLIP set */
			OI_cb_inf	*cb_infp ;		/* ptr to callback routines */
			XrmQuark	hlp_qtop;		/* Help topic to bring up */
			XrmQuark	hlp_qfil;		/* from this file */
			OI_d_tech	*lst_focus;		/* If this is a top_level_object then this stores the last obj. to have the focus.*/
#ifdef OI_USE_NAM
			char		*nam ;			/* ptr to name string for object */
#endif /* OI_USE_NAM */
	 public:
		static	OI_class	*clsp ;			/* ptr to class record for this piece of object */
		static	XrmQuark	q_cbOIResize ;		/* quark for oi internal resize callback */
		static	XrmQuark	q_OI_drop;
		static	short unsigned	cb_id;			/* unique callback identifier */
		static	int		classp_offset ;		/* offsetof(OI_d_tech,classp) for use in cvt.OI */
		static	XrmQuark	q_OI_drop_sites;
		static	XrmQuark	q_OI_selectionHandler;

	 private:
//		virtual	void		DUMMY_VIRTUAL()	;
			void		abs_cb_inf_del(XrmQuark) ;		/* delete callback info */
			void		abs_cb_inf_del(XrmQuark, OI_fnp, OI_callback*, OI_memfnp, void*) ;
			void		abs_refresh_callback(OI_cb_inf*) ;
			void		adjust_callbacks(OI_d_tech*) ;		/* force callbacks to match template */
			void		allow_adopting()		{ cnstrnts2 |= OI_ADOPTING; }
//			void		cb_inf_del(XrmQuark, OI_fnp, OI_callback*, OI_memfnp, void*) ;
			OI_cb_inf	*cb_inf_ptr(XrmQuark) ;			/* (OBSOLETE) get ptr to callback info for particular type of callback */
			void		clear_in_my_constructor()	{ cnstrnts &= ~OI_D_TECH_IN_MY_CTOR; }
			void		clear_res_fetched()		{ cnstrnts &= ~OI_RES_FETCHED; }
		virtual	void		clear_root_configure();			/* clear root configuration callback */
			void		create_window_chain() ;			/* create window and ancestor windows */
			void		disallow_adopting()		{ cnstrnts2 &= ~OI_ADOPTING; }
			void		init_classes(OI_connection*) ;
			OI_bool		in_my_constructor()		{return(((cnstrnts&OI_D_TECH_IN_MY_CTOR) != 0) ? OI_yes : OI_no);}
			OI_bool		is_adopting()			{ return((cnstrnts2 & OI_ADOPTING) ? OI_yes : OI_no); }
			void		layout_child(OI_d_tech*,void*,void*) ;	/* add child to layout method */
			void		make_visible_for_focus(OI_bool) ;	/* force object visible so it can accept focus */
			void		purge_grab_pointer() ;			/* purge pointer grabs for object and all children */
			OI_bool		get_args(OI_number*,OI_number*,char***) ;		/* retrieve args for form_cmd() */
			void		res_accelerators(void *);		/* callback for accelerators resource */
			void		res_callback_list(void *);		/* callback for callback resource */
			void		res_clip(void *);			/* callback for clip resource */
			void		res_auto_resize(void *);		/* resource setting callback */
			OI_bool		res_fetched()			{ return(((cnstrnts&OI_RES_FETCHED) != 0) ? OI_yes : OI_no); }
			void		res_horz_move(void *);			/* resource setting callback */
			void		res_horz_resize(void *);		/* resource setting callback */
			void		res_independent_loc(void *);		/* callback for independent loc resource */
			void		res_map_raised(void *);			/* callback for map raised resource */
			void		res_move(void *);			/* resource setting callback */
			void		res_object_resources(void *);		/* resource setting callback */
			void		res_resize(void *);			/* resource setting callback */
			void		res_track(void *);			/* resource setting callback */
			void		res_user_arg(void *);			/* callback for user arg resource */
			void		res_user_arg_rqd(void *);		/* callback for user arg rqd resource */
			void		res_vert_move(void *);			/* resource setting callback */
			void		res_vert_resize(void *);		/* resource setting callback */
			void		res_bdr_pixel(void *);			/* callback for border pixel resource */
			void		res_bkg_is_down(void *);		/* resource setting callback */
			void		res_bkg_pixel(void *);			/* callback for background pixel resource */
			void		res_bkg_pixmap(void *);			/* callback for background pixmap resource */
			void		res_bottom_pixel(void *);		/* callback for bottom pixel resource */
			void		res_bottom_space(void *);		/* callback for bottom space resource */
			void		res_bvl_style(void *);			/* callback gor bevel style resource */
			void		res_column_position(void *);		/* callback for column position resource */
			void		res_cursor(void *);			/* callback for cursor resource */
			void		res_down_pixel(void *);			/* callback for down pixel resource */
			void		res_fg_pixel(void *);			/* callback for foreground pixel resource */
			void		res_focus_frame_pixel(void *);		/* callback for focus frame pixel resource */
			void		res_focus_frame_pixmap(void *);		/* callback for focus frame pixmap resource */
			void		res_focus_frame_width(void *);		/* callback for focus frame width */
			void		res_frame_width(void *);		/* callback for frame width resource */
			void		res_gravity(void *);			/* callback for gravity resource */
			void		res_layout(void *);			/* callback for layout method resource */
			void		res_left_space(void *);			/* callback for left space resource */
			void		res_mnemonics(void *);			/* callback for mnemonics resource */
			void		res_right_space(void *);		/* callback for right space resource */
			void		res_row_position(void *);		/* callback for row position resource */
			void		res_size_track(void *);			/* callback for size_track resource */
			void		res_top_pixel(void *);			/* callback for top pixel resource */
			void		res_top_space(void *);			/* callback for top space resource */
			void		res_translations(void *);		/* callback for translations resource */
			void		res_override_translations(void *);	/* callback for translations resource */
			void		res_augment_translations(void *);	/* callback for translations resource */
			void		res_substitute_translations(void *);	/* callback for translations resource */
			void		set_in_my_constructor()		{ cnstrnts |= OI_D_TECH_IN_MY_CTOR; }
			void		set_res_fetched()		{ cnstrnts |= OI_RES_FETCHED; }
		virtual	void		set_root_configure();					/* set root configuration callback */
		/*
		 *	Note!  The following routines are needed only to support changing these resources
		 *	from a user program such as the prototyper, not the general resource fetching mechanism
		 */
			void		res_language(void *);
			void		res_bdr_width(void *);
			void		res_bvl_width(void *);
			void		res_loc_x(void *);
			void		res_loc_y(void *);
			void		res_user_var(void *);
			void		res_state(void *);
	 protected:
			OI_cb_inf	*abs_callback_get(XrmQuark, OI_cb_inf* =NULL) ;
			OI_bool		abs_callbacks_lock(XrmQuark);
			void		abs_callbacks_unlock(XrmQuark);
		virtual	int		are_you_a(short unsigned id) ;
			OI_stat		associate(OI_d_tech*,void*,void*,OI_bool) ;		/* establish parent with changed state */
			OI_cb_inf	*callback_add(XrmQuark, OI_fnp, OI_callback*, OI_memfnp, void*) ;
			void		callback_chain(OI_cb_inf *);
			void		callback_delete(XrmQuark, OI_fnp, OI_callback*, OI_memfnp, void*) ;
		virtual	OI_d_tech	*callback_object(XrmQuark) ;				/* get object to which callback will be applied */
			OI_cb_inf	*callback_set(XrmQuark, OI_fnp, OI_callback*, OI_memfnp, void*) ;
			OI_bool		check_for_res_child(const char *);
			void		client_message(const XEvent *,void*) ;			/* ClientMessage event handler */
			OI_stat		common_associated_object(OI_d_tech*,void*,void*,OI_state,OI_bool) ;	/* common ?_associate_object code */
			long		constraints()		{return(cnstrnts);}		/* get constraints governing object behavior */
			void		construct() ;						/* most ctor work, so vtbl part installed */
		virtual	OI_stat		create() = 0 ;						/* create in X environment */
			OI_stat		create_children(OI_stat) ;				/* create tree of subchildren in X environment */
			void		destruct() ;						/* do actual destructor work */
		virtual	void		font_resize() ;						/* resize object because of font change */
//			void		generic_new_fontset(OI_font_bounds *, OI_font **, OI_font_bounds **);
			void		generic_new_fontset(OI_font_bounds *, OI_font_bounds **);
		virtual	void		handle_delete_window();
			OI_bool		is_clip_completely_visible(long,long,OI_number,OI_number) ;	/* OI_yes if clip rectangle is completely visible */
			OI_bool		is_clip_partially_visible(long,long,OI_number,OI_number) ;	/* OI_yes if clip rectangle is partially visible */
			OI_bool		is_clip_visible(long,long,OI_number,OI_number) ;	/* OI_yes if clip rectangle is visible */
			OI_bool		refresh_callback_lock() ;				// OI_yes => lock successfully set
			void		refresh_callback_unlock()		{ cnstrnts &= ~OI_CB_REFRESH; }
			void		mod_create(int,int,OI_bool=OI_yes) ;			/* modify for consistency after X window creation */
		virtual	void		new_connection(OI_connection*) = 0 ;			/* change to another X display/screen */
			void		new_fontset(OI_font_bounds *);
		virtual	void		new_model(OI_model_type) ;				/* change interaction model */
			void		noclip_unchain(OI_d_tech*) ;				/* unchain object, all descendants from no_clp chain */
			void		noclip_chain(OI_d_tech*) ;				/* add object, all descendants to no_clp chain (if unclipped) */
			void		notify_sender(XSelectionEvent*,void*) ;			/* notify sender of successful receipt of property */
		virtual	void		paint(const XEvent*, void* =NULL) ;			/* paint object */
		virtual	void		parent_post_associate(OI_d_tech *) ;			/* Do after associate() things. */
		virtual	void		post_associate() ;					/* Do after associate() things. */
			OI_bool		pre_create_mod(int*,int*,Window*) ;			/* modify XCreateWindow() params prior to X window creation */
		virtual	void		pre_configure(long, long, OI_number, OI_number) ;	/* window is about to be configured with XConfigureWindow */
			void		pre_delete() ;						/* clean up prior to deletion of object */
		virtual	void		pre_unparent() ;					/* Do before unparent() things. */
		virtual	void		post_remove_from_layout();				/* clean up after removing from layout */
			void		res_font(void *);					/* callback for font resource */
			void		res_fontset(void *);					/* callback for fontSet resource */
			void		re_configure(OI_configure *);				/* re_configure the object */
			OI_selection	*selection_object();
			void		selection_release(Atom) ;				/* get rid of global selection ownership */
			void		selection_request(Atom,Atom,Atom,Time) ;		/* request selection be placed on window */
		virtual	void		set_model_info() ;					/* set properties related to model */
			void		space_change() ;
		virtual	void		start_next() ;						/* start up entry */
			void		turn_on_children() ;					/* activate input events for all children (recursively) */
			void		turn_off_children() ;					/* deactivate input events for all children (recursively) */
		virtual	void		void_select() ;						/* cancel current selection */

	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_d_tech(OI_class *, const char *) ;			/* constructor */
					// spare virtuals, document when you use.
		virtual	void		*redirect_0(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_1(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_2(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_3(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_4(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_5(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_6(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_7(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_8(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_9(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_10(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_11(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_12(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_13(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_14(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_15(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_16(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_17(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_18(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_19(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_20(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_21(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_22(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_23(void*, void*, void*, void*, void*, void*);
		virtual	void		*redirect_24(void*, void*, void*, void*, void*, void*);
			OI_number	abs_bottom_space() ;
			OI_number	abs_left_space() ;
			OI_number	abs_right_space() ;
			OI_number	abs_top_space() ;
			void		abs_new_def_horz_space(OI_number);
			void		abs_new_def_vert_space(OI_number);
		virtual	void		abs_resume_layout(OI_bool=OI_yes);
		virtual	void		abs_suspend_layout();
			OI_tm_record	*accelerators_record();
			OI_bool		accepts_help()			{ return ((OI_bool)(cnstrnts2&OI_IGNORE_HELP)? OI_no : OI_yes); }
		virtual	OI_bool		accepts_event(const XEvent*) ;				/* will this object process event of a particular type? */
			void		after_get_resources();
		virtual	OI_number	alignment_loc_x(OI_alignment = OI_alignment_default);
		virtual	OI_number	alignment_loc_y(OI_alignment = OI_alignment_default);
		virtual	void		allow_abs_associate();		/* allow absolute association */
			void		allow_bkg_is_down()		{ cnstrnts2 |= OI_BKG_IS_DOWN; }
			void		allow_bottom_space()		{ cnstrnts2 |= OI_BOTTOM_SPACE; }
		virtual	void		allow_builder_mode();
			void		allow_dragging()		{ cnstrnts2 |= OI_DRAGGING; }
		virtual	void		allow_focus_notify();
			void		allow_force_within_root()	{ cnstrnts |= OI_FORCE_WITHIN_ROOT; }
			void		allow_gravity()			{ cnstrnts |= OI_GRAVITY_SET; }
			void		allow_help()			{ cnstrnts2 &= ~OI_IGNORE_HELP; }
			void		allow_in_get_resources()	{ cnstrnts2 |= OI_IN_GET_RESOURCES; }
			void		allow_left_space()		{ cnstrnts2 |= OI_LEFT_SPACE; }
			void		allow_needs_resize()		{ cnstrnts |= OI_NEEDS_RESIZE; }
			void		allow_record_res()		{ cnstrnts2 |= OI_RECORD_RES; }
			void		allow_right_space()		{ cnstrnts2 |= OI_RIGHT_SPACE; }
			void		allow_root_configure()		{ cnstrnts |= OI_ROOT_CONFIGURE; }
			void		allow_internal_resources()	{ cnstrnts2 &= ~OI_NO_RESOURCES; }
			void		allow_top_space()		{ cnstrnts2 |= OI_TOP_SPACE; }
			void		allow_translations_enabled()	{ cnstrnts |= OI_TRANSLATIONS_ENABLED; }
			void		allow_uib_top_level()		{ cnstrnts2 |= OI_UIB_TOP_LEVEL; }
			OI_d_tech	*ancestor_str( const char * );		/* Due to a bug in the SGI compiler, this must be here -- imp  */
			OI_d_tech	*ancestor_derived_from_str(const char*,OI_bool=OI_no) ;	/* ditto -- imp */
		virtual	OI_d_tech	*associate_parent(OI_d_tech* =NULL) ;			/* actual parent which will be used in association */
			OI_quark_pointer_array *attributes()			{ return (attr); }
			OI_quark_pointer *attribute(XrmQuark q)			{ return (is_attribute(q)); }
			void		attribute_del(XrmQuark q)		{ del_attribute(q); }
			void		*attribute_get(XrmQuark q)		{ return (get_attribute(q)); }
			OI_quark_pointer *attribute_set(XrmQuark q, void *p)	{ return (set_attribute(q, p)); }
			OI_d_tech	*attribute_str(const char *q);
			void		before_get_resources();					/* prepare to get resources for self and children */
			OI_cb_inf	*cb_inf_change_proto(XrmQuark, const char*, const char*, const char*) ;	/* change prototyper callback info */
			XrmQuark	*callback_quark_list() ;
			XrmQuark	cb_drag_preview()		{ return (q_cbDragPreview); }
			XrmQuark	cb_drop()			{ return (q_cbDrop); }
			XrmQuark	cb_drop_preview()		{ return (q_cbDropPreview); }
			XrmQuark	cb_selection_convert()		{ return (q_cbSelectionConvert); }
			void		change_connection(OI_connection*, OI_number, OI_number) ;
			void		change_model(OI_model_type, OI_bool=OI_yes) ;
		virtual	OI_char_encode_type	char_encode_type() ;
			OI_number	child_number() ;
 		virtual	void		circulate(OI_number =1);				/* rotate in stacking order amongst siblings. */
			void		clear_in_unparent()		{ cnstrnts2 &= ~OI_IN_UNPARENT; }
			void		clear_res_children()		{ cnstrnts2 &= ~OI_RES_CHILDREN; }
		virtual	void		clone_adjust(OI_d_tech*) ;				/* adjust characteristics to match those of another obj */
		virtual	void		clone_adjust_after_descendants(OI_d_tech*) ;		/* adjust characteristics after children added */
			OI_bool		clone_children(OI_d_tech*) ;				/* clone all the children */
			OI_bool		completed_res_children()	{ return ((OI_bool)((cnstrnts2&OI_RES_CHILDREN)?OI_yes:OI_no)); }
			void		construct_children(OI_class *);
		virtual	OI_number	decoration_size_x() = 0 ;
		virtual	OI_number	decoration_size_y() = 0 ;
			void		decoration_size(OI_number *, OI_number *) ;
			OI_number	def_horz_space() ;
			OI_number	def_vert_space() ;
			void		del_attribute(XrmQuark);
			void		disable_all_callbacks() ;				/* disable all user callbacks */
//			void		disable_callback(const char*) ;			/* disable a callback */
//			void		disable_callback(XrmQuark) ;
		virtual	void		disallow_abs_associate();	/* disallow absolute association */
			void		disallow_all_help(OI_bool);	/* disallow help on all descendants */
			void		disallow_bkg_is_down()		{ cnstrnts2 &= ~OI_BKG_IS_DOWN; }
		virtual	void		disallow_builder_mode();
			void		disallow_dragging()		{ cnstrnts2 &= ~OI_DRAGGING; }
			void		disallow_force_within_root()	{ cnstrnts &= ~OI_FORCE_WITHIN_ROOT; }
			void		disallow_gravity()		{ cnstrnts &= ~OI_GRAVITY_SET; }
			void		disallow_help()			{ cnstrnts2 |= OI_IGNORE_HELP; }
			void		disallow_in_get_resources()	{ cnstrnts2 &= ~OI_IN_GET_RESOURCES; }
			void		disallow_needs_resize()		{ cnstrnts &= ~OI_NEEDS_RESIZE; }
			void		disallow_root_configure()	{ cnstrnts &= ~OI_ROOT_CONFIGURE; }
			void		disallow_record_res()		{ cnstrnts2 &= ~OI_RECORD_RES; }
			void		disallow_internal_resources()	{ cnstrnts2 |= OI_NO_RESOURCES; }
			void		disallow_translations_enabled()	{ cnstrnts &= ~OI_TRANSLATIONS_ENABLED; }
			void		disallow_uib_top_level()	{ cnstrnts2 &= ~OI_UIB_TOP_LEVEL; }
		virtual	void		do_clear_working();					/* do actual clear_working functionality for single object */
		virtual	void		do_set_working(Cursor);					/* do actual set_working functionality for single object */
			void		enable_all_callbacks() ;				/* enable all user callbacks */
//			void		enable_callback(const char*) ;				/* enable a previously disabled callback */
//			void		enable_callback(XrmQuark) ;
		virtual	OI_number	expected_event();
			void		expose(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		focus_in(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		focus_out(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	OI_d_tech	*focus_obj() ;						/* get ptr to actual obj to receive focus */
			OI_geometry	*geometry();
			void		*get_attribute(XrmQuark);
			void		get_child_resources();					/* get resources for children */
 			Atom		get_drop_selection();
			void		get_resources(OI_class*);				/* get resources for class */
		virtual	void		get_resources();					/* get resources for self */
		virtual	Cursor		grab_cursor() ;						/* cursor to use when pointer is grabbed */
		virtual	Window		group_leader();
		virtual	void		handle_drop(OI_dnd_operation , long, long);
			OI_bool		in_unparent()			{ return (cnstrnts2&OI_IN_UNPARENT ? OI_yes : OI_no); }
		static	OI_bool		init(OI_connection*) ;
			void		install_callback(XrmQuark) ;		/* install a callback */
			void		install_callback_list() ;		/* install all callbacks from resources */
			void		install_child_drop_sites(OI_d_tech *, OI_dnd_drop_sites*);
			void		install_drop_sites(OI_d_tech *);
			OI_bool		invalid()			{ return ((cnstrnts2 & OI_INVALID) ? OI_yes : OI_no); }
		virtual	OI_bool		is_acceptable_child(OI_d_tech*) ;			/* chk if object is suitable as child */
		virtual	OI_bool		is_acceptable_parent(OI_d_tech*) ;	/* chk if object is suitable as parent */
			OI_quark_pointer *is_attribute(XrmQuark);
		virtual	OI_bool		is_basic_menu();
			OI_bool		is_bkg_down()			{ return((cnstrnts2&OI_BKG_IS_DOWN) != 0 ? OI_yes : OI_no); }
			OI_bool		is_bottom_space()		{ return ((cnstrnts2&OI_BOTTOM_SPACE)?OI_yes:OI_no); }
			OI_bool		is_completely_visible(long,long,OI_number,OI_number) ;	/* OI_yes if clip rect completely visible and object visible */
		virtual	OI_bool		is_container() ;					/* OI_yes this object can be a container for other objects.*/
			OI_bool		is_dragging()			{ return ((cnstrnts2&OI_DRAGGING)?OI_yes:OI_no); }
			OI_bool		is_focus_notify()		{ return ((cnstrnts&OI_FOCUS_NTFY)?OI_yes:OI_no); }
			OI_bool		is_force_within_root()		{ return ((cnstrnts&OI_FORCE_WITHIN_ROOT)?OI_yes:OI_no); }
		virtual	OI_bool		is_frozen() ;						/* OI_yes if i/o is frozen */
			OI_bool		is_gravity()			{ return ((cnstrnts&OI_GRAVITY_SET)?OI_yes:OI_no); }
			OI_bool		is_in_get_resources()		{ return ((cnstrnts2&OI_IN_GET_RESOURCES)?OI_yes:OI_no); }
			OI_bool		is_laid_out_child()		{ return (slotp ? OI_yes : OI_no); }
			OI_bool		is_left_space()			{ return ((cnstrnts2&OI_LEFT_SPACE)?OI_yes:OI_no); }
		virtual	OI_bool		is_menu();
		virtual	OI_bool		is_menu_cell();
			OI_bool		is_needs_resize()		{ return ((cnstrnts&OI_NEEDS_RESIZE)?OI_yes:OI_no); }
			OI_bool		is_partially_visible(long,long,OI_number,OI_number) ;	/* OI_yes if clip rect partially visible and object visible */
			OI_bool		is_record_res()			{ return ((OI_bool)(cnstrnts2&OI_RECORD_RES)? OI_yes : OI_no); }
			OI_bool		is_right_space()		{ return ((cnstrnts2&OI_RIGHT_SPACE)?OI_yes:OI_no); }
			OI_bool		is_root_configure()		{ return ((cnstrnts&OI_ROOT_CONFIGURE)?OI_yes:OI_no); }
		virtual	OI_bool		is_scroll_menu();
			OI_bool		is_suspended()			{ return ((cnstrnts2&OI_SUSPENDED) ? OI_yes : OI_no); }
			OI_bool		is_internal_resources()		{ return ((cnstrnts2&OI_NO_RESOURCES) ? OI_no : OI_yes); }
			OI_bool		is_top_space()			{ return ((cnstrnts2&OI_TOP_SPACE)?OI_yes:OI_no); }
			OI_bool		is_transient()			{ return ((OI_bool)((cnstrnts&OI_TRANSIENT)?OI_yes:OI_no)); }
			OI_bool		is_translations_enabled()	{ return ((OI_bool)((cnstrnts&OI_TRANSLATIONS_ENABLED)?OI_yes:OI_no)); }
			OI_bool		is_uib_top_level()		{ return ((cnstrnts2&OI_UIB_TOP_LEVEL)?OI_yes:OI_no); }
			OI_bool		is_visible(long,long,OI_number,OI_number) ;		/* OI_yes if clip rectangle is visible and object is visible */
		virtual	void		key_hlp(OI_d_tech*, const XEvent*, const char* const *, unsigned int *) ;	/* help activated by pressing help key */
 		virtual	void		lower(OI_d_tech* =NULL);				/* lower in stacking order amongst siblings. */
		static	OI_d_tech	*make_minimal(const char*,OI_minimal_type) ;
			void		mark_subclass_internals( OI_class * = NULL, OI_bool = OI_no, OI_bool = OI_no ) ;
		virtual	void		min_outside_size(OI_number,OI_number,OI_number*,OI_number*) ;
			OI_tm_record	*mnemonics_record();
			void		new_bvl_pixels();					/* calculate bevel pixels */
		virtual	void		new_children(const char *);				/* callback for children resource */
			OI_stat		new_loc(long, long) ;					/* change pixel location of object */
		virtual	void		new_geometry(OI_geometry *);
			void		new_top_level_geometry(OI_geometry *);
			void		new_gravity(OI_gravity g) ;				/* change object gravity */
		virtual	OI_stat		new_outside_size(OI_number, OI_number) ;
		virtual	OI_stat		new_size(OI_number,OI_number);
			void		uib_set_state_for_save(OI_state) ;	/* change state */
			XrmQuark	nameq() ;						/* quark corresponding to object name */
		virtual	void		new_size_track(OI_size_track);
		virtual	void		new_bvl_style(OI_bevel_style);
			OI_d_tech	*no_clip()			{ return(no_clp); }
		virtual	void		nominal_outside_size(OI_number*,OI_number*);
			OI_bool		object_resources()		{ return ((cnstrnts2 & OI_NO_MY_RESOURCES) ? OI_no : OI_yes); }
			OI_bool		ok_for_focus();			/* true if object is legitimate to take focus during default focus search */
			OI_d_tech	*oi_object() ;						/* for user derived classes */
		virtual	void		post_get_resources();
		virtual	void		pre_get_resources();
			OI_font		*primary_font() ;					/* ptr to primary font, convenience function */
			void		print_error(const char *rtn) ;
		virtual	void		private_allow_wm_decoration(OI_wm_decoration);
		virtual	void		private_disallow_wm_decoration(OI_wm_decoration);
			void		process_key_hlp(const XEvent *,void * =NULL);
		virtual	void		pseudo_delete() ;					/* fake a delete, needed for unclipped objects, del_delayed */
			void		purge_dispatch(OI_bool) ;				/* purge dispatch table for object & all descendants */
			void		purge_last_focus() ;					/* purge this object as lst_focus for top level objects */
 		virtual	void		raise(OI_d_tech* =NULL);				/* raise in stacking order amongst siblings. */
			void		record_res(XrmQuark);
			OI_lw_quark_array	*record_resource_array()	{ return (rec_res); }
			XrmQuark	*record_resources() ;
			void		redirect_event(const XEvent*, void*) ;
			void		refresh_callback(OI_cb_inf*) ;
			void		refresh_children() ;					/* force repaint of all children */
			void		resume(OI_bool all=OI_no) ;
		virtual	int		resume_obj(OI_bool=OI_no) ;						/* back out most recent suspend() */
			void		res_children(void *);					/* callback for children resource */
			void		res_geometry(void *);
			OI_quark_pointer *set_attribute(XrmQuark, void*);
			void		set_bkg_pixmap(OI_pixmap*) ;				/* change background pixmap for object */
		virtual	void		set_char_encode_type(OI_char_encode_type t) ;
			void		set_error_status(OI_stat st)	{ OI_status=st; }
		virtual	void		set_expected_event(OI_number);
			void		set_geometry(OI_geometry *);
			void		set_in_unparent()		{ cnstrnts2 |= OI_IN_UNPARENT; }
			void		set_invalid() ;						/* mark object invalid, it's logically destroyed */
			void		set_model_type(OI_model_type);
			void		set_res_children()		{ cnstrnts2 |= OI_RES_CHILDREN; }
			OI_lw_quark_array	*set_resource_array()		{ return (set_res); }
			void		set_resource(const char *n) ;
			void		set_resourceq(XrmQuark);
			XrmQuark	*set_resources() ;
 		virtual	void		set_stacking_level(OI_number);				/* set the stacking level to one specified. */
		virtual	OI_size_constraints	*size_constraints() ;
		virtual	OI_size_constraints	*size_constraints_object() ;
			void		strategy(const XEvent*,void*) ;
			OI_d_tech	*subobject_str( const char * );		/* Due to a bug in the SGI compiler, this must be here -- imp  */
		virtual	OI_number	super_caret_loc();
			void		suspend() ;
		virtual	void		suspend_obj() ;						/* suspend input processing */
			void		unrecord_res(XrmQuark q) ;
			void		unrecord_res(const char *q) ;
			void		unset_resourceq(XrmQuark q) ;

			Atom		decode_selection(const char* const *, unsigned int *) ;	/* figure out what selection to use */
			OI_bool		selection_aquire(Atom,Time) ;				/* acquire global selection ownership */
		virtual	OI_bool		delete_selection(Atom) ;				/* delete text for selection */
		virtual	OI_bool		send_select_data(Window,Atom,Atom,Atom)	;		/* send data to requestor */
		virtual	OI_bool		process_select_data(Atom,Atom) ;			/* process data from selection request */
		virtual	OI_bool		retrieve_select_data(Atom,Atom) ;			/* get data from selection request */
			void		setup_help() ;						/* setup help callbacks related to model */
		virtual	Window		x_window_id() = 0 ;
		virtual	void		destroy_x_window() = 0 ;
			void		set_gc(PIXEL fg=OI_UNKNOWN_PIXEL,PIXEL bg=OI_UNKNOWN_PIXEL,OI_font *fp=NULL);
			OI_bool		remove_obj(OI_d_tech*) ;				/* remove object from property vector */
			void		insert_obj(OI_d_tech*) ;				/* add object to property vector */
			void		vir_rt_chg(const XEvent*,void*) ;			/* process change in virtual root object */
			OI_bool		tree_save(FILE*, XrmDatabase=0) ;			/* save all children of object */
			OI_bool		save_callbacks(FILE*, XrmDatabase=0) ;			/* save callbacks for object */
			OI_bool		save_obj(FILE*, XrmDatabase=0) ;			/* save properties common to all objects */
			OI_cb_inf	*callback_vector()		{ return( cb_infp ); }	/* returns pointer to all set callbacks */
			OI_bool		save_callback(OI_cb_inf*,FILE*, XrmDatabase=0) ;	/* save callback */
			OI_cb_inf	*bind_callback(OI_alpha_callback*,OI_class* =NULL) ;	/* cvt alpha callback to real callback */
			OI_cb_inf	*bind_callback(OI_alpha_callback*,OI_cb_class*) ;	/* cvt alpha callback to real callback */
			OI_layout_slot	*slot()				{return(slotp);}
			void		set_slot(OI_layout_slot *s)	{ slotp = s;}
			OI_model	*model_obj() ;
			void		set_help_topic(const char *) ;
			void		new_help_topic(const char *) ;
			char		*help_topic() ;
			XrmQuark	help_qtopic() ;
			void		set_help_file(const char *) ;
			void		new_help_file(const char *) ;
			char		*help_file() ;
			XrmQuark	help_qfile() ;
		virtual	long		def_loc_x() ;						/* location used for default placement */
		virtual	long		def_loc_y() ;
		virtual	void		paint_focus_frame(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		clear_focus_frame(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		activate_main_menu(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		activate_popup(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			OI_pixmap	*focus_frame_pixmap() ;
			PIXEL		focus_frame_pixel() ;
			OI_number	focus_frame_width()		{ return (misc->focus_frame_width()); }
			void		set_focus_frame_width(OI_number);
			void		set_focus_frame_pixel(PIXEL);
			void		set_focus_frame_pixmap(OI_pixmap *);
			void		set_last_focus(OI_d_tech *d)	{lst_focus = d; }	/* set the last focus object */
			void		tm_translate_event(const XEvent *, void*);
			OI_d_tech	*last_focus()			{return(lst_focus);}
			OI_d_tech	*first_interior_focus();				/* Find first interior focus obj.*/
			OI_d_tech	*first_interior_obj();					/* Find first interior focus obj.*/
			OI_d_tech	*last_interior_focus();					/* Find last interior focus obj.*/
			OI_d_tech	*last_interior_obj();					/* Find last interior focus obj.*/
			OI_d_tech	*default_next_focus(OI_d_tech * =NULL);			/* Find next focus obj.*/
			OI_d_tech	*default_next_obj();					/* Find next focus obj.*/
			OI_d_tech	*default_prev_focus(OI_d_tech * =NULL);			/* Find prev focus obj.*/
			OI_d_tech	*default_prev_obj();					/* Find prev focus obj.*/

			void		set_primary() ;						/* establish this object as primary object */
			char		*get_resource(XrmQuark n, XrmQuark c) ;
			char		*get_resource(const char *n, const char *c) ;
			OI_dispatch	*dispatch() ;
	virtual	const	char		*wm_name() ;						/* name for window manager WM_NAME property */
		virtual	OI_bool		is_pinned() ;
			OI_class	*class_object()		{return(classp);}
		virtual	OI_class	*class_object_for_save() ;
			void		adopt_layout(OI_d_tech*) ;				/* take over someone else's layout method */
			void		set_class_object(OI_class *) ;
			void		process_drag(const XEvent*,void*) ;
												/* Loc, pixels, top left corner of outside window border, 0-n */
			void		set_abs_loc(long lx, long ly)		{ origin.x=lx; origin.y=ly;}	/* offset of 0,0 from location of object */
			void		set_abs_focus_frame_width(OI_number);
			void		set_abs_size_track(OI_size_track);
			void		set_language(const char *);
			void		new_language(const char *);
			char		*language() ;
			XrmQuark	languageq();
		virtual	OI_bool		has_private_window() ;
			long		loc_x_outside_rel() ;
			long		loc_y_outside_rel() ;
			void		loc_outside_rel(long *, long *) ;
			OI_bool		is_enable_needs_focus()	{return(OI_bool)((cnstrnts2&OI_ENABLE_NEEDS_FOCUS) != 0 ? OI_yes : OI_no);}
/*KNOWN*/		void		enable_needs_focus()	{ cnstrnts2 |= OI_ENABLE_NEEDS_FOCUS; }
/*KNOWN*/		void		disable_needs_focus()	{ cnstrnts2 &= ~OI_ENABLE_NEEDS_FOCUS; }
			OI_bool		needs_focus()		{return(OI_bool)((cnstrnts&OI_NEEDS_FOCUS) != 0 ? OI_yes : OI_no);}
			void		allow_focus()		{ if (is_enable_needs_focus()) cnstrnts |= OI_NEEDS_FOCUS;
									else cnstrnts &= ~OI_NEEDS_FOCUS;}
			void		disallow_focus()	{ cnstrnts &= ~OI_NEEDS_FOCUS; }
			OI_bool		takes_focus()		{return(OI_bool)((cnstrnts2&OI_TAKES_FOCUS) != 0 ? OI_yes : OI_no);}
/*KNOWN*/		void		allow_takes_focus()	{ cnstrnts2 |= OI_TAKES_FOCUS; }
			void		disallow_takes_focus()	{ cnstrnts2 &= ~OI_TAKES_FOCUS; }
			OI_bool		click_to_type()		{return(OI_bool)((cnstrnts2&OI_CLICK_TO_TYPE) != 0 ? OI_yes : OI_no);}
		virtual	void		allow_click_to_type();
			void		disallow_click_to_type();
			OI_bool		has_focus()		{return(OI_bool)((cnstrnts&OI_HAS_FOCUS) != 0 ? OI_yes : OI_no);}
			void		set_has_focus()		{ cnstrnts |= OI_HAS_FOCUS; }
			void		clear_has_focus()	{ cnstrnts &= ~OI_HAS_FOCUS; }
			OI_bool		is_outside_rel()	{return(OI_bool)((cnstrnts&OI_OUTSIDE_REL) != 0 ? OI_yes : OI_no);}
			OI_bool		is_track_unmap()	{return(OI_bool)((cnstrnts&OI_TRACK_UNMAP) != 0 ? OI_yes : OI_no);}
			void		allow_track_unmap()	{cnstrnts|=OI_TRACK_UNMAP;}
			void		disallow_track_unmap()	{cnstrnts&= ~OI_TRACK_UNMAP;}
			OI_bool		is_def_loc()		{return(OI_bool)((cnstrnts&OI_DEF_PLACE) != 0 ? OI_yes : OI_no);}
			void		allow_def_loc()		{cnstrnts|=OI_DEF_PLACE;}
			void		disallow_def_loc()	{cnstrnts&= ~OI_DEF_PLACE;}
			OI_bool		is_virtual_root_notify()	{return(OI_bool)((cnstrnts&OI_VIR_ROOT_NTFY) != 0 ? OI_yes : OI_no);}
			OI_bool		is_override_redirect()	{return(OI_bool)((cnstrnts&OI_OVERRIDE_REDIRECT) != 0 ? OI_yes : OI_no);}
			OI_bool		is_model_info()		{return(OI_bool)((cnstrnts&OI_MODEL_INFO) != 0 ? OI_yes : OI_no);}
			void		allow_model_info()	{cnstrnts|=OI_MODEL_INFO;}
			void		disallow_model_info()	{cnstrnts&= ~OI_MODEL_INFO;}
			OI_bool		is_internal_object()	{return((cnstrnts&OI_INTERNAL_OBJECT) != 0 ? OI_yes : OI_no);}
			void		allow_internal_object(OI_bool mod=OI_no)
								{ cnstrnts|=OI_INTERNAL_OBJECT; if (mod) cnstrnts2 |= OI_MODIFIABLE_INTERNAL; }
			void		disallow_internal_object()	{ cnstrnts &= ~OI_INTERNAL_OBJECT; }
			OI_bool		is_modifiable_internal()	{ return((cnstrnts2&OI_MODIFIABLE_INTERNAL) != 0 ? OI_yes : OI_no);}
			void		disallow_modifiable_internal()	{ cnstrnts2 &= ~OI_MODIFIABLE_INTERNAL; }
			void		all_internal_objects(OI_bool) ;				/* mark all descendants as internal objects */
			void		allow_from_config()	{cnstrnts2 |= OI_FROM_CONFIG;}
			void		disallow_from_config()	{cnstrnts2 &= ~OI_FROM_CONFIG;}
			OI_bool		is_from_config()	{return((cnstrnts2 & OI_FROM_CONFIG) ? OI_yes : OI_no);}
			OI_bool		is_valid_parent()	{return(OI_bool)((cnstrnts2&OI_VALID_PARENT) != 0 ? OI_yes : OI_no);}
			void		allow_valid_parent()	{cnstrnts2|=OI_VALID_PARENT;}
			void		disallow_valid_parent()	{cnstrnts2&= ~OI_VALID_PARENT;}
			OI_bool		in_layout() ;
			void		set_in_layout() ;
			void		clear_in_layout() ;
			OI_bool		is_enable()		{return(OI_bool)((cnstrnts&OI_DISABLE) != 0 ? OI_no : OI_yes);}
			void		allow_enable()		{cnstrnts&= ~OI_DISABLE;}
			void		disallow_enable()	{cnstrnts|=OI_DISABLE;}
			OI_d_tech	*user_obj() ;
		virtual	void		configure(const XEvent*,void* =NULL) ;			/* configure obj parented to root due to change in size/loc */
		virtual	void		configure_descendant() ;				/* configure object parented to root  to avoid clipping */
			OI_number	abs_size_x()		{return((OI_number)extent.x);}	/* x part of size */
			OI_number	abs_size_y()		{return((OI_number)extent.y);}	/* y part of size */
			OI_number	outside_size_x() ;
			OI_number	outside_size_y() ;
			long		track_org_x()		{return(track_org.x);}		/* x part of tracking origin */
			long		track_org_y()		{return(track_org.y);}		/* y part of tracking origin */
//		virtual	OI_d_tech	*val_assoc(OI_d_tech*,long *,long *,OI_bool);
		virtual	OI_d_tech	*val_assoc(OI_d_tech*);
			OI_stat		set_abs_size(OI_number w, OI_number h)		{ extent.x=w; extent.y=h; return(OI_OK); }
			OI_stat		set_abs_size_x(OI_number w)			{ extent.x=w; return(OI_OK); }
			OI_stat		set_abs_size_y(OI_number h)			{ extent.y=h; return(OI_OK); }
		virtual	OI_stat		set_outside_size(OI_number w, OI_number h) ;
		virtual	void		val_unparent(OI_d_tech*) ;				/* let parent cleanup for unparent operation */
			OI_number	abs_num_props()		{return(nprop);}		/* # direct descendants */
			OI_number	max_props()		{return(mxprop);}
			OI_number	num_windowless_children()	{ return(wl_cnt); }
			OI_d_tech	**prop_vec()		{return(propp); }
			OI_d_tech	*abs_parent()		{return(prntp);}		/* direct parent */
			OI_d_tech	*abs_numbered_child(OI_number n)	{return((n<nprop) ? *(propp+n) : NULL);}
			OI_bool		is_resq(XrmQuark);
			OI_bool		is_setq(XrmQuark);
		virtual	OI_bool		is_write_resq(XrmQuark);
			OI_bool		is_set(const char *n) ;
			OI_bool		is_bvl_width_set() ;
			OI_bool		is_bdr_width_set() ;
			OI_bool		is_font_set() ;
			OI_bool		is_colormap_set() ;
			OI_bool		is_translations_set() ;
		virtual	OI_pixmap	*bkg_pixmap();
		virtual	PIXEL		bkg_paint_pixel();
		virtual	PIXEL		fg_paint_pixel();
		virtual	PIXEL		fg_reverse_paint_pixel();
			XrmQuark	font_quark() ;
//			OI_font		*oi_font() ;
			OI_number	font_x_border() ;
			OI_font_bounds  *font_bounds() ;
			
			Colormap	colormap();
		virtual	void		new_bkg_pixmap(OI_pixmap*) ;				/* change background pixmap generically */
		virtual	void		new_bkg_pixel(PIXEL, OI_bool=OI_no) ;					/* change background pixel generically */
		virtual	void		new_fg_pixel(PIXEL, OI_bool=OI_no) ;					/* change foreground pixel generically */
		virtual	void		new_bdr_pixel(PIXEL, OI_bool=OI_no) ;					/* change window border pixel generically */
		virtual	void		new_top_pixel(PIXEL, OI_bool=OI_no) ;			/* change top bevel pixel generically */
		virtual	void		new_bottom_pixel(PIXEL, OI_bool=OI_no) ;		/* change bottom bevel pixel generically */
		virtual	void		new_down_pixel(PIXEL, OI_bool=OI_no) ;			/* change down pixel generically */
		virtual	void		new_pixels(PIXEL,PIXEL,PIXEL, OI_bool=OI_no) ;		/* change background, foreground, border pixels generically */
		virtual	void		new_focus_frame_width(OI_number);
			void		new_focus_frame_pixel(PIXEL);
			void		new_focus_frame_pixmap(OI_pixmap *);
		virtual void		new_frame_width(OI_number);
		virtual void		new_bdr_width(OI_number);
			void		set_abs_bdr_width(OI_number);
		virtual void		new_bvl_width(OI_number);
			void		set_abs_bvl_width(OI_number);
		virtual void		set_font(XrmQuark,OI_charset = OI_charset_latin1) ;	/* change font for object */
		virtual void		new_font(OI_font *, OI_charset=OI_charset_latin1);	/* change font generically */
//			void		generic_new_font(OI_font *, OI_charset, OI_font**, OI_font_bounds**);
			void		generic_new_font(OI_font *, OI_charset, OI_font_bounds**);
		virtual void		new_cursor(Cursor) ;					/* change cursor generically */
			void		set_standard_colormap(Atom) ;				/* change colormap for object */
			void		set_colormap(Colormap) ;				/* change colormap for object */
		virtual	void		new_colormap(Colormap) ;				/* change colormap generically */
			void		prop_colormap(Colormap) ;				/* propogate colormap to subobjects */
			void		new_bottom_space(OI_number s);
			void		new_left_space(OI_number s);
			void		new_right_space(OI_number s);
			void		new_selection_targets(Atom *, OI_bool, OI_number);
			void		new_top_space(OI_number s);
			void		set_translations(OI_translation_table *);
			void		new_translations(OI_translation_table *);
			void		set_accelerators(OI_translation_table *);
		virtual	void		new_accelerators(OI_translation_table *);
			void		set_mnemonics(OI_translation_table *);
		virtual	void		new_mnemonics(OI_translation_table *);
			void		new_space(OI_number s) ;
			void		res_def_horz_space(void *);
			void		res_def_vert_space(void *);
		virtual	void		new_def_horz_space(OI_number sp);
		virtual	void		new_def_vert_space(OI_number sp);
			void		new_def_space();
			void		set_def_horz_space(OI_number);
			void		set_def_vert_space(OI_number);
			OI_bool		save(FILE*, XrmDatabase=0) ;					/* save object to file */
		virtual	void		pre_paint();
		virtual	void		post_paint();
			void		paint_focus(int x, int y, int w, int h) ;
			void		paint_focus(int x, int y, int w, int h, OI_bool f) ;
			void		paint_bevel(int, int, int, int,OI_bool, int=-1);	/* paint the 3D bevel */
			void		paint_bevel(Window, int, int, int, int, OI_bool, int=-1);	/* paint the 3D bevel */
			void		set_bvl_gc(OI_bevel, OI_bool);				/* set up the GC to draw the 3D bevel */
			void		reset_bvl_gc();						/* reset the GC following bevel drawing */
			OI_action_table_rec *action_table()			{ return (actions); }
			void		push_action_table(OI_action_table_rec *t);
			OI_tm_record 	*tm()						{ return (trm); }
			void		bind_actions() ;
			void		bind_actions(OI_tm_record *t) ;
			void            set_tma_translations(OI_translation_table *);
			void            set_tm_translations(OI_translation_table *);
			OI_translation_table *tm_translations() ;
			OI_translation_table *tm_accelerators();
			OI_translation_table *my_accelerators();
			OI_translation_table *tm_mnemonics();
			OI_translation_table *my_mnemonics();
			void		pre_install_translations();
			void		install_translations(OI_translation_table *);
			void		uninstall_translations();
		virtual	void		update_translations();
			void		override_translations(OI_translation_table *);
			void		augment_translations(OI_translation_table *);
			void		substitute_translations(OI_translation_table *);
			OI_translation_table *accelerators(void);
			void		install_accelerators(OI_d_tech * = NULL, OI_bool = OI_yes);
			OI_translation_table *mnemonics(void);
			void		install_mnemonics(OI_d_tech * = NULL);
		virtual	void		enable_translations(OI_translation_table *);
			void		disable_translations();
			void		allow_auto_accelerators()			{ cnstrnts2 |= OI_AUTO_ACCELERATORS; }
			void		disallow_auto_accelerators()			{ cnstrnts2 &= ~OI_AUTO_ACCELERATORS; }
		virtual	OI_bool		auto_accelerators();
			void	 	install_popup_translations(OI_d_tech*, OI_number = 0, OI_number = 0);
			void		add_accelerator_user(OI_d_tech *);
			void		del_accelerator_user(OI_d_tech *);
		virtual	void		popup_child(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			OI_d_tech	*abs_next_child(OI_d_tech*);			/* Returns next child without skipping internal objs. */
			OI_d_tech	*abs_prev_child(OI_d_tech*);			/* Returns last child without skipping internal objs. */
			OI_number	user_num_props() ;				/* For object having internal objects returns # child objs. */
			OI_d_tech	*user_numbered_child(OI_number n) ;		/* For object having internal objects returns n th obj. */
		virtual	void		disable() ;					/* disable interaction, painted ACTIVE (for prototyper use) */
		virtual	void		enable() ;					/* enable interaction (for prototyper use) */
			void		allow_user_var()	{cnstrnts|=OI_USER_VAR;}
			void		disallow_user_var()	{cnstrnts&= ~OI_USER_VAR;}
			OI_bool		is_user_var()		{return(OI_bool)((cnstrnts&OI_USER_VAR) != 0 ? OI_yes : OI_no);}
			OI_bool		is_translations()	{return(OI_bool)((cnstrnts2&OI_ALLOW_TRANSLATIONS) != 0 ? OI_yes : OI_no);}
			void		allow_translations()	{cnstrnts2|=OI_ALLOW_TRANSLATIONS;}
			void		disallow_translations()	{cnstrnts2&= ~OI_ALLOW_TRANSLATIONS;}
		virtual	void		move_window(Window, int, int);
			void		allow_auto_resize() ;
			void		disallow_auto_resize() ;
			OI_bool		is_auto_resize() ;
		virtual	OI_d_tech	*descendant_focus_obj();			/* Find a descendant obj. needing focus,(start at first obj)*/
		virtual	OI_d_tech	*descendant_last_focus_obj();			/* Find a descendant obj. needing focus,(start at last obj) */
		virtual	void		new_layout(OI_layout l, OI_number= -1, OI_number= -1) ;	/* set layout method and default spacing */
			void		set_tab_object(OI_tab_obj *o) ;
			void		set_tab_group(OI_tab_group *g) ;
			OI_tab_obj	*tab_object() ;
			OI_tab_group	*tab_group() ;
			void		kbd_translations();				/* Install keyboard related translations on object. */
			void		top_level_mapped(const XEvent *, OI_bool *);		/* top level window has been mapped */
			void		uninstall_accelerators(OI_d_tech*);
			void		uninstall_mnemonics(OI_d_tech*);
		virtual	void		set_wm_class(const char* = NULL, const char* = NULL);	/* set WM_CLASS */
		virtual	void		set_wm_hints(XWMHints *);
			void		set_wm_name();
		virtual	void		or_wm_hints(XWMHints *);
		virtual	void		set_wm_normal_hints(XSizeHints *);			/* set wm_normal_hints on the window */
		virtual	void		or_wm_normal_hints(XSizeHints *);			/* or wm_normal_hints on the window */
		virtual	void		or_wm_normal_hints(unsigned long);
			void		wm_take_focus(Time);
		virtual	void		lift_object(long, long, int, int);			/* remove the object from the display */
		virtual	void		place_object(long, long, int, int);			/* put the object in a new location */
		virtual	void		xlower() = 0 ;						/* do XLowerWindow or equiv */
		virtual	void		xmap() = 0 ;						/* do XMapWindow or equiv */
		virtual	void		xmapraised() = 0 ;					/* do XMapRaised or equiv */
		virtual	void		xraise() = 0 ;						/* do XRaiseWindow or equiv */
		virtual	void		xunmap() = 0 ;						/* do XUnmapWindow or equiv */
		virtual	OI_bool		resource_cnv_catch(OI_xrm_resource*, XrmValue*, XrmValue*); /* Resource catch all function */
		virtual	OI_bool		resource_uncnv_catch(OI_xrm_resource*, XrmValue*, XrmValue*); /* Resource catch all function */
	virtual	const	char* const	*resource_str_catch(OI_xrm_resource*);			/* Resource catch all function */

		friend	void		dmpOI_d_tech(OI_d_tech*) ;	/* diagnostic dump procedure */

		//	OBSOLETE RESTRICTED MEMBER FUNCTIONS
			void		set_bottom_pixel(PIXEL) ;
			void		set_down_pixel(PIXEL) ;
			void		set_top_pixel(PIXEL) ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_cb_inf	*cb_arg_change(const char*, void *) ;			/* change arg for callback */
			OI_cb_inf	*cb_arg_change(XrmQuark, void *) ;			/* change arg for callback */
			void		*cb_argp(const char *) ;				/* get arg for callback */
			void		*cb_argp(XrmQuark) ;					/* get arg for callback */
			OI_fnp		cb_fnp(const char *) ;					/* get function ptr for callback */
			OI_fnp		cb_fnp(XrmQuark) ;					/* get function ptr for callback */
			OI_cb_inf	*cb_inf_change(const char*, OI_fnp, void* =NULL) ;
			OI_cb_inf	*cb_inf_change(XrmQuark, OI_fnp, void* =NULL) ;
			OI_cb_inf	*cb_inf_change(const char*, OI_callback*, OI_memfnp, void* =NULL) ;
			OI_cb_inf	*cb_inf_change(XrmQuark, OI_callback*, OI_memfnp, void* =NULL) ;
			OI_cb_inf	*cb_inf_get(const char*) ;				/* get ptr to callback info, NULL if none there */
			OI_cb_inf	*cb_inf_get(XrmQuark) ;					/* get ptr to callback info, NULL if none there */
			OI_memfnp	cb_memfnp(const char *) ;				/* get member function ptr for callback */
			OI_memfnp	cb_memfnp(XrmQuark) ;					/* get member function ptr for callback */
			OI_callback	*cb_objp(const char *) ;				/* get object ptr for callback */
			OI_callback	*cb_objp(XrmQuark) ;					/* get object ptr for callback */
		// For row/column related member functions, refer to documentation for layout methods derived from OI_lm_row_col
		virtual	OI_number	column_position();					/* column number this object is in */
		virtual	OI_number	first_column(OI_number = OI_undefined);			/* first column in this object */
		virtual	OI_number	first_row(OI_number = OI_undefined);			/* first row in this object */
		virtual	OI_number	in_column(OI_number c, long x, OI_number r= OI_undefined, OI_number=100) ;	/* is x psn before,in,after col? */
		virtual	OI_number	in_row(OI_number r, long y, OI_number c= OI_undefined, OI_number=100) ;	/* is y position before,in,after row? */
		virtual	OI_number	last_column(OI_number = OI_undefined);			/* last column used */
		virtual	OI_number	last_row(OI_number = OI_undefined);			/* last row used */
		virtual	void		new_column(OI_number, OI_number= OI_undefined) ;	/* allocate new column number; shift existing if in use */
		virtual	void		new_row(OI_number, OI_number= OI_undefined) ;		/* allocate new row number; shift existing if in use */
		virtual	OI_number	next_column(OI_number, OI_number= OI_undefined) ;	/* next used column number */
		virtual	OI_number	next_row(OI_number, OI_number= OI_undefined) ;		/* next used row number */
		virtual	OI_number	prev_column(OI_number, OI_number= OI_undefined) ;	/* previous used column number */
		virtual	OI_number	prev_row(OI_number, OI_number= OI_undefined) ;		/* previous used row number */
		virtual	OI_number	row_position();						/* row number this object is in */
			void		set_bkg_pixel(PIXEL) ;
			void		set_fg_pixel(PIXEL) ;
			void		set_bdr_pixel(PIXEL) ;
			void		set_pixels(PIXEL,PIXEL,PIXEL) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmers manual, and are
		//		available to the toolkit users.  Functions not contained in user documentation
		//		are subject to change without notice and should never be used.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		//	Defined above due to forward reference of undocumented public member:
		//-------------------------------------------------------------------------------------------------		
		//-------------------------------------------------------------------------------------------------		
		//	Out of order due to forward reference:
		//-------------------------------------------------------------------------------------------------		
		virtual	void		attach_X_window(Window);
			OI_number	bottom_space() ;
			OI_number	left_space() ;
			OI_number	top_space() ;
			OI_number	right_space() ;
		virtual	OI_number	space_x() ;						/* x part of total occupied space */
		virtual	OI_number	space_y() ;						/* y part of total occupied space */
		//-------------------------------------------------------------------------------------------------		
		//	Remainder:	
		//-------------------------------------------------------------------------------------------------		

		virtual			~OI_d_tech() ;						/* destructor ~OIc */
			OI_stat		abs_layout_associated_object(OI_d_tech*,OI_number,OI_number,OI_state=OI_same);
			OI_stat		abs_layout_associated_object(OI_d_tech*,void*,void*,OI_state=OI_same);
			OI_layout_method	*abs_layout_method()	{return(layoutp);}
			Cursor		abs_cursor()			{ return (misc->cursor()); }
			OI_d_tech	*abs_root() ;
		virtual	OI_stat		add_to_layout(OI_number,OI_number) ;			/* convert child to laid out object */
		virtual	OI_stat		add_to_layout(void*,void*) ;				/* convert child to laid out object */
			OI_number	all_space_x() ;						/* x part of total occupied space */
			OI_number	all_space_y() ;						/* y part of total occupied space */
		virtual	void		allow_clip() ;						/* clip by parent(default) (reparents X win to parent) */
			void		allow_drag(Cursor = None, Cursor = None);
			void		allow_drop(OI_dnd_clip_rectangle* = NULL, OI_number = 0);
			void		allow_horz_move()	{cnstrnts|=OI_HORZ_MOVE;}
		virtual	void		allow_horz_resize() ;
			void		allow_independent_loc()	{cnstrnts2|=OI_INDEPENDENT_LOC;}
			void		allow_map_raised() ;
			void		allow_move()		{cnstrnts|=OI_MOVE;}
			void		allow_object_resources()	{ cnstrnts2 &= ~OI_NO_MY_RESOURCES; }
			void		allow_override_redirect() ;
			void		allow_resize() ;
			void		allow_track(OI_orient=(OI_orient)(OI_horizontal|OI_vertical)) ;
		virtual	void		allow_transient(Window);
			void		allow_user_arg()	{cnstrnts|=OI_USER_ARG;}
			void		allow_user_arg_rqd()	{cnstrnts|=OI_USER_ARG_RQD;}
			void		allow_vert_move()	{cnstrnts|=OI_VERT_MOVE;}
		virtual	void		allow_vert_resize() ;
		virtual	void		allow_wm_decoration(OI_wm_decoration);
		virtual	char		*alpha_value() ;				/* value converted to an ascii string */
			OI_d_tech	*ancestor(const char*) ;				/* find named ancestor */
			OI_d_tech	*ancestor(XrmQuark) ;					/* find named ancestor */
			OI_d_tech	*ancestor_derived_from(const char*,OI_bool=OI_no) ;	/* get nearest ancestor derived from a particular class */
			OI_d_tech	*ancestor_derived_from(XrmQuark,OI_bool=OI_no) ;
			OI_d_tech	*ancestor_derived_from(OI_class*,OI_bool=OI_no) ;
			void		ancestor_loc(OI_d_tech*,long*,long*) ;			/* find position relative to ancestor */
			long		ancestor_loc_x(OI_d_tech*) ;				/* find x position relative to ancestor */
			long		ancestor_loc_y(OI_d_tech*) ;				/* find y position relative to ancestor */
			OI_app_window	*app_window() ;						/* get parent application window */
			void		augment_translations(const char *t) ;
			OI_number	bdr_width()			{ return (misc->border_width()); }
			PIXEL		bdr_pixel() ;
			PIXEL		bkg_pixel() ;
			PIXEL		bottom_pixel() ;
			OI_number	bvl_width()			{ return (misc->bevel_width()); }
			OI_bevel_style	bvl_style()			{ return (misc->bevel_style()); }
			OI_bool		call_action_proc(XrmQuark, const XEvent *, const char* const *, unsigned int) ;
			OI_bool		call_action_proc(const char *, const XEvent *, const char* const *, unsigned int) ;
			OI_cb_inf	*callback_add(const char*, OI_fnp, void* =NULL) ;	/* add arbitrary callback function */
			OI_cb_inf	*callback_add(XrmQuark, OI_fnp, void* =NULL) ;
			OI_cb_inf	*callback_add(const char*, OI_callback*, OI_memfnp, void* =NULL) ;
			OI_cb_inf	*callback_add(XrmQuark, OI_callback*, OI_memfnp, void* =NULL) ;
			OI_cb_inf	*callback_set(const char*, OI_fnp, void* =NULL) ;	/* set arbitrary callback function */
			OI_cb_inf	*callback_set(XrmQuark, OI_fnp, void* =NULL) ;
			OI_cb_inf	*callback_set(const char*, OI_callback*, OI_memfnp, void* =NULL) ;
			OI_cb_inf	*callback_set(XrmQuark, OI_callback*, OI_memfnp, void* =NULL) ;
			void		callback_delete(const char*) ;				/* delete callback info */
			void		callback_delete(XrmQuark) ;					/* delete callback info */
			void		callback_delete(const char*, OI_fnp, void* =NULL) ;	/* add arbitrary callback function */
			void		callback_delete(XrmQuark, OI_fnp, void* =NULL) ;
			void		callback_delete(const char*, OI_callback*, OI_memfnp, void* =NULL) ;
			void		callback_delete(XrmQuark, OI_callback*, OI_memfnp, void* =NULL) ;
			OI_cb_inf	*callback_get(const char*, OI_cb_inf* =NULL) ;		/* get ptr to callback info, NULL if none there */
			OI_cb_inf	*callback_get(XrmQuark, OI_cb_inf* =NULL) ;		/* get ptr to callback info, NULL if none there */
			OI_bool		callbacks_lock(const char*);				/* lock callbacks for start of callback loop */
			OI_bool		callbacks_lock(XrmQuark);				/* lock callbacks for start of callback loop */
			void		callbacks_unlock(const char*);				/* unlock callbacks at end of callback loop; free invalids */
			void		callbacks_unlock(XrmQuark);				/* unlock callbacks at end of callback loop; free invalids */
		virtual	void		clear_working();					/* make the object un-busy */
			OI_d_tech	*clone() ;						/* clone an object and all it's progeny */
			OI_stat		clone_subobjects(OI_d_tech*) ;				/* clone all children of one object into another object */
			OI_connection	*connection()		{return(conp);}
			Cursor		cursor();
			int		cursor_index()			{ return (misc->cursor_index()); }
			void		*data();
		virtual	OI_number	decoration_offset_x() = 0 ;
		virtual	OI_number	decoration_offset_y() = 0 ;
			void		decoration_offset(OI_number *, OI_number *) ;
		virtual	OI_number	default_horz_space();
		virtual	OI_number	default_vert_space();
			void		del() ;							/* delete object */
			void		delete_all() ;						/* delete object and all children */
		virtual	void		delete_all_delayed() ;					/* mark object for delayed delete_all */
			void		delete_delayed() ;					/* mark object for delayed delete */
			void		delete_drop_data();					/* delete dropped data */
		virtual	OI_d_tech	*descendant(const char*) ;				/* find descendant by name */
		virtual	OI_d_tech	*descendant_by_window(Window) ;				/* find descendant object by X window id */
		virtual	void		disallow_clip(OI_bool = OI_no) ;			/* prevent clipping by parent (reparents X win to X root) */
			void		disallow_drag();
			void		disallow_drop();
			void		disallow_horz_move()	{cnstrnts&= ~OI_HORZ_MOVE;}
		virtual	void		disallow_horz_resize() ;
			void		disallow_independent_loc()	{cnstrnts2&= ~OI_INDEPENDENT_LOC;}
			void		disallow_map_raised()	{cnstrnts&= ~OI_MAP_RAISED;}
			void		disallow_move()		{cnstrnts&= ~OI_MOVE;}
			void		disallow_object_resources()	{ cnstrnts2 |= OI_NO_MY_RESOURCES; }
			void		disallow_override_redirect() ;
			void		disallow_resize() ;
			void		disallow_track(OI_orient=(OI_orient)(OI_horizontal|OI_vertical)) ;
		virtual	void		disallow_transient();
			void		disallow_user_arg()	{cnstrnts&= ~OI_USER_ARG;}
			void		disallow_user_arg_rqd()	{cnstrnts&= ~OI_USER_ARG_RQD;}
			void		disallow_vert_move()	{cnstrnts&= ~OI_VERT_MOVE;}
		virtual	void		disallow_vert_resize() ;
		virtual	void		disallow_wm_decoration(OI_wm_decoration);
			Display		*display() ;
			PIXEL		down_pixel() ;
			OI_stat		error_status()		{ return(OI_status); }
			PIXEL		fg_pixel() ;
		virtual	OI_d_tech	*first_focus();						/* set following object to get focus on client-msg */
			XFontStruct	*font() ;						/* get X font reference */
			OI_number	font_ascent() ;						/* character height above baseline */
			OI_number	font_descent() ;					/* character height below baseline */
			OI_number	font_height() ;						/* character height, pixels, no interline spacing */
			OI_number	font_line_height() ;					/* line height(pixels) includes interline spacing(currently always 0) */
			OI_number	font_line_space() ;					/* interline spacing, currently always zero */
			char            *font_name() ;						/* get font name */
			OI_number	font_width() ;						/* character width, pixels, includes intercharacter space */
			OI_number	font_y_base() ;						/* baseline psn for drawing chars, rel to window oriigin, pixels */
			void		force_within_abs_root(long,long, OI_d_tech* = NULL) ;	/* force entirely within absolute root */
			char		*form_cmd(const char*) ;				/* form command string from values in objects */
			OI_number	frame_width()	{ return (bdr_width() + bvl_width()); }	/* get frame width */
		virtual	void		freeze() ;						/* freeze all input/output from the window */
			char		*full_name() ;						/* complete path name of object */
 			void		*get_drop_data(const char *, const char* = NULL);
			void		get_resources(OI_resource *, unsigned int, void *, XrmQuark* = NULL);	/* get addition resources on an object */
			void		*get_selection_data(const char *s, const char *t, Atom *r, int *f, unsigned long *n)
									{ return (get_selection_data(conp->atom(s), conp->atom(t), r, f, n)); }
			void		*get_selection_data(const char *t, Atom *r, int *f, unsigned long *n)
									{ return (get_selection_data(None, conp->atom(t), r, f, n)); }
			void		*get_selection_data(Atom t, Atom *r, int *f, unsigned long *n)
									{ return (get_selection_data(None, t, r, f, n)); }
			void		*get_selection_data(Atom, Atom, Atom*, int*, unsigned long*);
			void		get_sub_resources(const char *n, const char *c, OI_resource *r, unsigned int cnt, void *base, XrmQuark *s=NULL) ;
			void		get_sub_resources(XrmQuark, XrmQuark, OI_resource *, unsigned int, void *, XrmQuark* = NULL);
			OI_gravity	gravity() ;
		virtual	OI_number	help_stack_size() ;					/* get # items in help stack of closest app_window ancestor */
		virtual	char		*help_str() ;						/* get contents of help line of closest app_window ancestor */
			OI_number	help_str_posted()	{return(help_posted);}
		virtual	OI_help		*hyper_help() ;						/* Hyper help object for this object */
		virtual	OI_bool		in_obj(long x, long y, int wid, int ht) ;		/* check if (x,y) relative to object window is in object */
		virtual	OI_bool		in_obj(long x, long y) ;
			OI_bool		initiate_dragdrop(OI_dnd_operation, int, int, Cursor = None, Cursor = None, OI_number = 0);
			OI_bool		is_bdr_set() ;
			OI_bool		is_bkg_set() ;
			OI_bool		is_bottom_set() ;
			OI_bool		is_bottom_space_set() ;
			OI_bool		is_clip()		{return(OI_bool)((cnstrnts&OI_NO_CLIP) == 0 ? OI_yes : OI_no);}
			OI_bool		is_cursor_set() ;
			OI_bool		is_default_horz_space_set() ;
			OI_bool		is_default_vert_space_set() ;
			OI_bool		is_derived_from(const char*) ;
			OI_bool		is_derived_from(XrmQuark) ;
			OI_bool		is_derived_from(OI_class*) ;
			OI_bool		is_descendant(OI_d_tech*) ;
			OI_bool		is_down_set() ;
			OI_bool		is_drag();		// is this object draggable?  (dnd)
			OI_bool		is_drop();		// is this object a drop site?  (dnd)
			OI_bool		is_fg_set() ;
			OI_bool		is_horz_move()		{return(OI_bool)((cnstrnts&OI_HORZ_MOVE) != 0 ? OI_yes : OI_no);}
			OI_bool		is_horz_resize()	{return(OI_bool)((cnstrnts&OI_HORZ_RESIZE) != 0 ? OI_yes : OI_no);}
			OI_bool		is_independent_loc()	{return(OI_bool)((cnstrnts2&OI_INDEPENDENT_LOC) != 0 ? OI_yes : OI_no);}
			OI_bool		is_left_space_set() ;
			OI_bool		is_map_raised()		{return(OI_bool)((cnstrnts&OI_MAP_RAISED) != 0 ? OI_yes : OI_no);}
			OI_bool		is_move()		{return(OI_bool)((cnstrnts&OI_MOVE) != 0 ? OI_yes : OI_no);}
			OI_bool		is_orphanage()		{ return((cnstrnts & OI_IS_ORPHANAGE) ? OI_yes : OI_no); }
			OI_bool		is_resize()		{return(OI_bool)((cnstrnts&OI_RESIZE) != 0 ? OI_yes : OI_no);}
			OI_bool		is_right_space_set() ;
			OI_bool		is_root()		{ return((cnstrnts & OI_IS_ROOT) ? OI_yes : OI_no); }
			OI_bool		is_root_or_orphanage()	{ return((cnstrnts & (OI_IS_ROOT|OI_IS_ORPHANAGE)) ? OI_yes : OI_no); }
			OI_bool		is_top_set() ;
			OI_bool		is_top_space_set() ;
			OI_bool		is_track(OI_orient=(OI_orient)0) ;
			OI_bool		is_user_arg()		{return(OI_bool)((cnstrnts&OI_USER_ARG) != 0 ? OI_yes : OI_no);}
			OI_bool		is_user_arg_rqd()	{return(OI_bool)((cnstrnts&OI_USER_ARG_RQD) != 0 ? OI_yes : OI_no);}
			OI_bool		is_vert_move()		{return(OI_bool)((cnstrnts&OI_VERT_MOVE) != 0 ? OI_yes : OI_no);}
			OI_bool		is_vert_resize()	{return(OI_bool)((cnstrnts&OI_VERT_RESIZE) != 0 ? OI_yes : OI_no);}
			OI_bool		is_visible() ;						/* OI_yes if object and all ancestors are mapped */
			OI_bool		is_within_abs_root(long,long,OI_d_tech* = NULL) ;	/* chk if entirely within absolute root */
		virtual	OI_bool		is_working();
		virtual	OI_layout	layout() ;
		virtual	OI_stat		layout_associated_object(OI_d_tech*,OI_number,OI_number,OI_state=OI_same) ;	/* establish parent with changed state */
		virtual	OI_stat		layout_associated_object(OI_d_tech*,void*,void*,OI_state=OI_same) ;	/* establish parent with changed state */
		virtual	OI_layout_method	*layout_method() ;
			void		loc(long *lxp, long *lyp) ;
			long		loc_x()			{return(origin.x);}		/* x part of current location */
			long		loc_y()			{return(origin.y);}		/* y part of current location */
			OI_model_type	model()			{ return (misc->model()); }
#ifdef OI_USE_NAM
		const	char		*name()			{return(nam);}			/* name of object */
#else
		const	char		*name() ;
#endif 
			OI_d_tech	*next();						/* get following object in data entry sequence order*/
		virtual	OI_d_tech	*next_child(OI_d_tech*) ;				/* get child from property list */
			void		next_entry(OI_number) ;					/* start next/prev entry */
		virtual	OI_number	num_props() ;						/* # of user objects as children */
		virtual	OI_d_tech	*numbered_child(OI_number n) ;
			OI_d_tech	*orphanage() ;
			Window		outside_X_window() ;					/* outermost X window id for object */
			void		override_translations(const char *t) ;
			OI_d_tech	*parent() ;
			void		pop_help_str(OI_number=1, OI_bool =OI_no) ;		/* pop help text in nearest application window */
			OI_d_tech	*prev();						/* get preceding object in data entry sequence order*/
			OI_d_tech	*prev_child(OI_d_tech*) ;				/* get last child from property list */
			void		push_actions(struct OI_actions_rec *a, OI_number n) ;
			void		push_compiled_actions(OI_compiled_action_table);
			OI_stat		push_help_str(const char*, OI_bool =OI_no) ;  		/* push help text as single string in nearest application window */
			void		refresh();
		virtual	void		repaint(OI_bool=OI_yes) = 0 ;
			OI_stat		remove_from_layout(long=OI_def_loc,long=OI_def_loc) ;	/* convert child to non laid out object */
			char		*resource_value(XrmQuark);				/* Value of the resource for this object */
			char		*resource_value(const char *res) ;
		virtual	void		resume_layout(OI_bool=OI_yes);
			OI_d_tech	*root() ;
			OI_d_tech	*root_ancestor() ;					/* get top level ancestor (just below root) */
			void		set_accelerators(const char *);
		virtual	char		*selection_data(Atom) ;					/* return specified selection's data */
		virtual	char		*selection_data(const char *) ;				/* return specified selection's data */
		virtual	OI_stat		set_associated_object(OI_d_tech*,long=OI_def_loc,long=OI_def_loc,OI_state=OI_same) ;	/* establish parent */
			OI_stat		set_bdr_color(const char *clr) ;
			void		set_bdr_color(PIXEL) ;					/* change window border pixel for object */
			void		set_bdr_width(OI_number);				/* change brdr width  */
			OI_stat		set_bkg_color(const char *clr) ;
			void		set_bkg_color(PIXEL) ;					/* change background pixel for object */
			void		set_bkg_pixmap(Pixmap) ;				/* change background pixmap for object */
			void		set_bkg_pixmap(XrmQuark) ;				/* change background pixmap for object */
			void		set_bkg_pixmap(const char *n) ;
			OI_stat		set_bottom_color(const char *clr) ;
			void		set_bottom_color(PIXEL) ;				/* change bottom bevel pixel for object */
			void		set_bottom_space(OI_number);				/* change bottom space */
			void		set_bvl_width(OI_number);				/* change bevel width  */
			void		set_bvl_style(OI_bevel_style);				/* change bevel style  */
		virtual	void		set_click(OI_click_fnp, void* =NULL) ;			/* set click function */
		virtual	void		set_click(OI_callback*, OI_click_memfnp, void* =NULL) ;	/* set click function */
			OI_stat		set_colors(const char*, const char*, const char*) ;	/* change bkg,fg,bdr color */
			void		set_colors(PIXEL, PIXEL, PIXEL) ;			/* change bkg,fg,bdr color */
		virtual void		set_cursor(Cursor) ;					/* change cursor for object */
		virtual void		set_cursor(int) ;					/* change cursor for object */
		virtual void		set_cursor(const char *, const char *) ;		/* change cursor for object */
		virtual void		set_cursor(Pixmap, Pixmap, unsigned int, unsigned int);	/* change cursor for object */
			void		set_data(void *);
			void		set_destroy(OI_destroy_fnp fp, void *argp=NULL) ;
			void		set_destroy(OI_callback *objp, OI_destroy_memfnp mfp, void *argp=NULL) ;
			OI_stat		set_down_color(const char *clr) ;
			void		set_down_color(PIXEL) ;					/* change down pixel for object */
			void		set_drop(OI_drop_fnp fp, void *argp=NULL) ;
			void		set_drop(OI_callback *objp, OI_drop_memfnp mfp, void *argp=NULL) ;
			void		set_drop_preview(OI_drop_preview_fnp fp, void *argp=NULL) ;
			void		set_drop_preview(OI_callback *objp, OI_drop_preview_memfnp mfp, void *argp=NULL) ;
			void		set_drag_preview(OI_drag_preview_fnp fp, void *argp=NULL) ;
			void		set_drag_preview(OI_callback *objp, OI_drag_preview_memfnp mfp, void *argp=NULL) ;
			OI_stat		set_fg_color(const char *clr) ;
			void		set_fg_color(PIXEL) ;					/* change foreground pixel for object */
		virtual	void		set_first_focus(OI_d_tech *);				/* set following object to get focus on client-msg */
		virtual	void		set_focus(Time=CurrentTime, OI_bool=OI_no) ;		/* set the input focus to this */
			void		set_focus_in(OI_focus_fnp fp, void *argp=NULL) ;
			void		set_focus_in(OI_callback *objp, OI_focus_memfnp mfp, void *argp=NULL) ;
			void		set_focus_next(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);	/* Set focus to next obj. */
		virtual	void		set_focus_next_tab(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);/* Set focus to next obj. */
			void		set_focus_next_window(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);/* Set focus to next top-obj. */
			void		set_focus_out(OI_focus_fnp fp, void *argp=NULL) ;
			void		set_focus_out(OI_callback *objp, OI_focus_memfnp mfp, void *argp=NULL) ;
			void		set_focus_prev(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);	/* Set focus to previous obj. */
		virtual	void		set_focus_prev_tab(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);/* Set focus to previous obj. */
			void		set_focus_prev_window(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);/* Set focus to previous top-obj. */
		virtual void		set_font(const char *,OI_charset cs=OI_charset_latin1) ;	/* change font */
			void		set_frame_width(OI_number);				/* change outside decoration width  */
			void		set_gravity(OI_gravity g) ;				/* change object gravity */
			OI_stat		set_help_str(const char*) ;				/* set help text in nearest application window */
			void		set_horz_space(OI_number s) ;
			void		set_layout(OI_layout l, OI_number= -1, OI_number= -1) ;	/* set layout method and default spacing */
			void		set_left_space(OI_number);				/* change left space */
			OI_stat		set_loc(long, long) ;					/* change pixel location of object */
			OI_stat		set_loc_outside_rel(long x,long y) ;
			void		set_mnemonics(const char *);
			void		set_name(const char*) ;					/* set name of object */
			void		set_next(OI_d_tech *) ;					/* set following object in data entry sequence order*/
			void		set_next_group(OI_d_tech *);
		virtual	void		set_resize(OI_resize_fnp, void* =NULL) ;
		virtual	void		set_resize(OI_callback*, OI_resize_memfnp, void* =NULL) ;
			void		set_resource_value(const char *r, const char *v, OI_bool rec=OI_yes) ;
			void		set_resource_value(XrmQuark, const char *, OI_bool=OI_yes);/* Set resource r to value v, record if rec */
			void		set_right_space(OI_number);				/* change right space */
			OI_stat		set_root_loc(long,long) ;				/* set loc relative to root (reparents X win to X root) */
			void		set_selection_convert(OI_sel_cvt_fnp fp, void *argp=NULL) ;
			void		set_selection_convert(OI_callback *objp, OI_sel_cvt_memfnp mfp, void *argp=NULL) ;
			void		set_selection_targets(Atom *, OI_bool=OI_yes);
			void		set_selection_data(Atom, Atom, void *, unsigned int, unsigned int);
		virtual	OI_stat		set_size(OI_number,OI_number) ;				/* change size of object */
			void		set_size_track(OI_size_track) ;
			void		set_space(OI_number s) ;
		virtual	OI_stat		set_state(OI_state) ;					/* change state */
			OI_stat		set_top_color(const char *clr) ;
			void		set_top_color(PIXEL) ;					/* change top bevel pixel for object */
			void		set_top_space(OI_number);				/* change top space */
			void		set_translations(const char *);
			void		set_vert_space(OI_number s) ;
		virtual	void		set_working();						/* make the object busy */
		virtual void		set_working(Cursor) ;					/* make the object busy */
		virtual void		set_working(int) ;					/* make the object busy */
		virtual void		set_working(const char *, const char *) ;		/* make the object busy */
		virtual void		set_working(Pixmap, Pixmap, unsigned int, unsigned int);/* make the object busy */
			void		size(OI_number *sxp, OI_number *syp) ;			/* make the object busy */
			OI_size_track	size_track() ;
		virtual	OI_number	size_x() ;						/* x part of size */
		virtual	OI_number	size_y() ;						/* y part of size */
			void		space(OI_number *sxp, OI_number *syp) ;			/* Total space occupied by object, pixels */
			OI_state	state()			{return(tech_state);}		/* get state of technique */
		virtual	OI_d_tech	*subobject(const char*) ;				/* find child object by name */
		virtual	OI_d_tech	*subobject(XrmQuark) ;					/* find child object by name */
			void		substitute_translations(const char *t) ;
		virtual	void		suspend_layout();
			OI_d_tech	*top_ancestor() ;					/* get top level object (just below root or orphanage) */
			PIXEL		top_pixel() ;
			OI_d_tech	*top_X_ancestor() ;					/* top level X obj (top_ancestor() or 1st unclipped ancstr) */
			OI_orient	track_type() ;						/* type of tracking object is doing */
		virtual	void		unfreeze() ;						/* freeze all input/output from the window */
		virtual	void		unparent() ;						/* remove technique from parent's property list */
			void		update_resources(OI_bool=OI_no);			/* refetch resources */
			void		update_specific_resources(const char* const *, unsigned int, OI_bool=OI_no);	/* refetch only these resources */
		virtual	OI_bool		user_layout_ok() ;					/* OI_yes => user can set_layout() on this object */
			void		wait_state_change(OI_state,OI_bool=OI_no) ;		/* Set state active, process events until object not active */
			void		window_loc(long*,long*);				/* find position relative to closest windowed-d-tech*/
			void		window_size(long*,long*);				/* Get size of closest ancestor with a window. */
		virtual	Window		X_window() ;						/* get object's X_window id for user/reference stuff (i.e. interior box of app_window, etc) */
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		drag_copy_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		drag_end(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		drag_move_start(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		


//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

#endif /* OI_d_tech_H */
