/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	key.H
 *
 *	Functions(s):
 *
 *	Description:
 *		key definitions
 *
 *	RCSid = "$Id: key.H,v 4.2.1.1 1993/06/01 22:54:53 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_key_H
#define OI_key_H

#include <X11/keysym.h>

	typedef	long	OI_key ;				/* low 16 bits are KeySym; upper 16 bits are modifiers */

 	struct	OI_xlate_key	{				/* translation table entry */
			OI_key		user_key ;		/* Key actually typed by user */
			OI_key		int_key ;		/* Unchanging internal code we use for the key */
		} ;

 /* the following modifiers may be combined */
#define	OI_K_SHIFT	(ShiftMask<<16)		/* shifted key */
#define	OI_K_CAP	(LockMask<<16)		/* key pressed with caps lock on */
#define	OI_K_CTRL	(ControlMask<<16)	/* key pressed with control on */
#define	OI_K_META	(Mod1Mask<<16)		/* key pressed with meta (either left or right) on */

 /* general purpose high byte bits and masks for OI_key */
#define	OI_K_SYMMASK	0x000FFFF	/* mask for keysym only */
#define	OI_K_MODMASK	0x0FF0000	/* mask for modifiers only */
#define	OI_K_KEYMASK	0x0FFFFFF	/* mask for modifiers and keysym, no special (LATIN_1,GRAPHIC,MODIFIER) info */
#define	OI_K_LATIN_1	0x1000000	/* key is a Latin-1 char (graphic or control) */
#define	OI_K_GRAPHIC	0x2000000	/* key is a graphic Latin-1 char */
#define	OI_K_MODIFIER	0x4000000	/* key is a modifier, not a real key */

 /* Function keys */
 /* Cursor control keys.  Note!!!  These are the same as some function keys, so be careful! */
#define	OI_K_UP		XK_Up
#define	OI_K_DOWN	XK_Down
#define	OI_K_LEFT	XK_Left
#define	OI_K_RIGHT	XK_Right

 /* editing function related keys */
#define	OI_K_DONE	XK_Return				/* done entering an entry */
#define	OI_K_BACKDEL	XK_Delete				/* backward delete */
#define	OI_K_FWDDEL	(OI_K_SHIFT|OI_K_BACKDEL)		/* forward delete */
#define	OI_K_BOLDEL	(OI_K_CTRL|OI_K_BACKDEL)		/* delete to BOL */
#define	OI_K_EOLDEL	(OI_K_CTRL|OI_K_SHIFT|OI_K_BACKDEL)	/* delete to EOL */
#define	OI_K_ENTRYDEL	XK_BackSpace				/* Delete entire entry */
#define	OI_K_DEFAULT	XK_Linefeed				/* Replace with default entry */
#define	OI_K_INS_LINE	(OI_K_META|XK_o)			/* insert line */
#define	OI_K_DEL_LINE	(OI_K_META|XK_d)			/* delete line */
#define	OI_K_INSERT_MODE	(OI_K_META|XK_i)		/* set insert mode */
#define	OI_K_REPLACE_MODE	(OI_K_META|XK_r)		/* set replace mode */
#define	OI_K_TOGGLE_MODE	(OI_K_META|XK_asciitilde)	/* toggle insert/replace mode */
#define	OI_K_HELP	(XK_Help)				/* help */
#define	OI_K_COMPOSE	(XK_Multi_key)				/* compose sequence */

 /* miscellaneous */
#define	OI_K_ALT	XK_Alt_R

#endif /* OI_key_H */
