/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	line.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_lm_line class header
 *
 *	RCSid = "$Id: lmline.H,v 1.2.1.1 1993/06/01 22:55:11 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_lmline_H
#define OI_lmline_H

#ifndef OI_wldtech_H
#include <OI/wldtech.H>
#endif /* OI_wldtech_H */

	class OI_lm_line : public OI_wl_d_tech {
			OI_xy		pt1 ;		/* coordinates of start point */
			OI_xy		pt2 ;		/* coordinates of end point */
			/**********************************************************************
			 * resources 
			 **********************************************************************/
			/**********************************************************************
			 * end of resources
			 **********************************************************************/
		public:
		static	OI_class	*clsp ;					/* ptr to class record */
		
		private:
			void		construct(OI_number,OI_number,OI_number,OI_number) ;
		protected:
					OI_lm_line(OI_class*, const char*, OI_number, OI_number, OI_number, OI_number) ;
		public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
					OI_lm_line(const char*, OI_number, OI_number, OI_number, OI_number);
					~OI_lm_line() ;
		static	OI_bool		init(OI_connection*) ;
		static	OI_lm_line	*make_minimal(const char*,OI_minimal_type) ;
		virtual	void		paint(const XEvent*, void* =NULL) ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		clone_adjust(OI_d_tech*) ;
		virtual	OI_bool		is_acceptable_child(OI_d_tech*) ;		/* chk if object is suitable as child */
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		set_points(OI_number,OI_number,OI_number,OI_number) ;
			void		point1(OI_number *xp, OI_number *yp)	{ *xp=pt1.x; *yp=pt1.y; }
			void		point2(OI_number *xp, OI_number *yp)	{ *xp=pt2.x; *yp=pt2.y; }
			OI_number	x1()					{ return(pt1.x); }
			OI_number	x2()					{ return(pt2.x); }
			OI_number	y1()					{ return(pt1.y); }
			OI_number	y2()					{ return(pt2.y); }
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_lm_line	*oi_create_lm_line(const char*, OI_number, OI_number, OI_number, OI_number) ;

#endif /* OI_lmline_H */
