/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1992, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	pane.H
 *
 *	Functions(s):
 *
 *	Description:
 *		Object Interface OI_paned_box class header
 *
 *	RCSid = "$Id: pane.H,v 4.22.1.1 1993/06/01 22:55:53 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_pane_H
#define OI_pane_H

#ifndef OI_box_H
#include <OI/box.H>
#endif /* OI_box_H */

 /* private ctl_bits */
#define OI_PANE_IN_CONSTRUCTOR	0x01L
#define OI_PANE_ALLOW_DRAG	0x02L
#define OI_PANE_GRIP_VISIBLE	0x04L
#define OI_PANE_RESIZE_ADJUST	0x08L
#define OI_PANE_NO_CHANGE	0x10L

#define	OI_pane_grip_def_height		6
#define	OI_PANE_GRIP_DEF_HEIGHT		OI_pane_grip_def_height
#define	OI_pane_grip_def_width		6
#define	OI_PANE_GRIP_DEF_WIDTH		OI_pane_grip_def_width
#define	OI_pane_grip_def_indent		-10
#define	OI_PANE_GRIP_DEF_INDENT		OI_pane_grip_def_indent
#define	OI_pane_grip_def_show_sep	OI_yes
#define	OI_PANE_GRIP_DEF_SHOW_SEP	OI_pane_grip_def_show_sep

#define OI_def_pane_min		1
#define OI_DEF_PANE_MIN		OI_def_pane_min

	class OI_pane : public OI_box {

	 friend class OI_paned_box;
	 friend class OI_pane_grip;

	 private: /* variables */
			unsigned long	ctl_bits ;		/* object specific control bits */
			OI_pane_grip		*_grip;			/* pointer to the grip for this pane */
			long		_new_size;		/* new size that the pane will be changed to */
			long		_orig_size;		/* size the pane was before current grip move */
			OI_number	_pane_num;		/* Where the pane is layed out in the OI_paned_box */

			/**********************************************************************
			*  OI_pane resources
			**********************************************************************/
			OI_number	sz_max; 		/* maximum size in major axis */
			OI_number	sz_min; 		/* minimum size in major axis */
			OI_bool		resize_adjust;	/* Whether this pane can be adjusted if its paned_box changes size */
			/**********************************************************************
			* end of OI_pane resources
			**********************************************************************/

	 protected: /* variables */
	 public: /* variables */
		static	OI_class		*clsp ;		/* ptr to class record */

	 private: /* functions */
			void		clear_grip_visible()		{ctl_bits&= ~OI_PANE_GRIP_VISIBLE;}
			void		clear_in_my_constructor()	{ctl_bits&= ~OI_PANE_IN_CONSTRUCTOR;}
			void		clear_no_change_flag()		{ctl_bits&= ~OI_PANE_NO_CHANGE;}
			void		construct(OI_number min, OI_number max, OI_number grip_width, OI_number grip_height, OI_number indent, OI_bool show_sep) ;
			OI_bool		in_my_constructor()		{return((ctl_bits&OI_PANE_IN_CONSTRUCTOR) ? OI_YES : OI_NO);}
			OI_bool		is_no_change_flag()		{return((ctl_bits&OI_PANE_NO_CHANGE) ? OI_YES : OI_NO);}
			void		set_grip_visibility();
			void		set_in_my_constructor()		{ctl_bits|=OI_PANE_IN_CONSTRUCTOR;}
			void		set_number(OI_number val)	{_pane_num = val;}
			void		set_no_change_flag()		{ctl_bits|=OI_PANE_NO_CHANGE;}

	 protected: /* functions */
					OI_pane(OI_class *clsp, const char *namep, OI_number width, OI_number height, OI_number min, OI_number max, OI_number grip_width=OI_PANE_GRIP_DEF_WIDTH, OI_number grip_height=OI_PANE_GRIP_DEF_HEIGHT, OI_number indent=OI_PANE_GRIP_DEF_INDENT, OI_bool show_sep=OI_PANE_GRIP_DEF_SHOW_SEP) ;
			OI_number	get_new_size()			{ return (_new_size);}
			OI_number	orig_size()			{ return(_orig_size);}
		virtual	void		post_remove_from_layout();
			void		store_new_size( long val)	{ _new_size = val;}

	 public: /* functions */
		//-------------------------------------------------------------------------------------------------
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------
					OI_pane(const char*,OI_number,OI_number,
						OI_number min=OI_DEF_PANE_MIN,
						OI_number max=OI_number_max,
						OI_number grip_width=OI_PANE_GRIP_DEF_WIDTH,
						OI_number grip_height=OI_PANE_GRIP_DEF_HEIGHT,
						OI_number indent=OI_PANE_GRIP_DEF_INDENT,
						OI_bool show_sep=OI_PANE_GRIP_DEF_SHOW_SEP) ;	/* constructor */
					~OI_pane() ;
			void		allow_resize_adjust()		{ctl_bits|=OI_PANE_RESIZE_ADJUST;}
			void		disallow_resize_adjust()	{ctl_bits&= ~OI_PANE_RESIZE_ADJUST;}
			void		clone_adjust(OI_d_tech*);
		static	OI_bool		init(class OI_connection*) ;
			OI_bool		is_grip_visible()		{ return ((ctl_bits & OI_PANE_GRIP_VISIBLE) ? OI_YES : OI_NO);}
			OI_bool		is_resize_adjust()		{ return ((ctl_bits & OI_PANE_RESIZE_ADJUST) ? OI_YES : OI_NO);}
		static	OI_pane		*make_minimal(const char*,OI_minimal_type);
			void		new_max_size(OI_number val);
			void		new_min_size(OI_number val);
			void		res_max_size(void*);
			void		res_min_size(void*);
			void		set_orig_size(OI_number val)	{ _orig_size = val;}
		//-------------------------------------------------------------------------------------------------
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------
		virtual	OI_stat		layout_associated_object(OI_d_tech*,OI_number,OI_number,OI_state=OI_SAME) ;
		virtual	OI_stat		layout_associated_object(OI_d_tech*,void*,void*,OI_state=OI_SAME) ;
		virtual	OI_stat		set_associated_object(OI_d_tech*,long=OI_DEF_LOC,long=OI_DEF_LOC,OI_state=OI_SAME) ;
		virtual	void		unparent() ;

		//-------------------------------------------------------------------------------------------------
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------

		//-------------------------------------------------------------------------------------------------
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------
			OI_pane_grip	*grip() 			{ return (_grip);}
			OI_number	maximum() 			{return (sz_max);}
			OI_number	minimum() 			{return (sz_min);}
			OI_number	number() 			{return (_pane_num);}
			void		set_max_size(OI_number val);
			void		set_min_size(OI_number val);
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_pane	*oi_create_pane(const char *namep, OI_number size_x, OI_number size_y, OI_number min=OI_def_pane_min, OI_number max = OI_number_max,
				OI_number grip_width=OI_pane_grip_def_width,
				OI_number grip_height=OI_pane_grip_def_height,
				OI_number indent=OI_pane_grip_def_indent,
				OI_bool show_sep=OI_pane_grip_def_show_sep) ;

#endif /* OI_pane_H */
