/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	sqentfld.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_seq_entry_field.H class header
 *
 *	RCSid = "$Id: sqentfld.H,v 4.17.1.1 1993/06/01 22:56:53 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_sqentfld_H
#define OI_sqentfld_H

#ifndef OI_entfld_H
#include <OI/entfld.H>
#endif /* OI_entfld_H */

	// class forward reference declarations
	class OI_seq_entry_field;
	class OI_mdl_seq_entry_field;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		Definitions in this section were previously documented, but have been marked as
		//		obsolete.  These definitions have been removed from the programmer's manual.
		//		These definitions are subject to removal from the toolkit and should no longer be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

#ifdef TYPEDEF_MEMFN
	typedef	int	(OI_sequence_fn)(OI_seq_entry_field*,void*) ;			/* OBSOLETE, use OI_ef_sequence_fn */
	typedef	int	(OI_callback::OI_sequence_memfn)(OI_seq_entry_field*,void*) ;	/* OBSOLETE, use OI_ef_sequence_memfn */
#endif /* TYPEDEF_MEMFN */
	typedef	int	(*OI_sequence_fnp)(OI_seq_entry_field*,void*) ;			/* OBSOLETE, use OI_ef_sequence_fnp */
	typedef	int	(OI_callback::*OI_sequence_memfnp)(OI_seq_entry_field*,void*) ;	/* OBSOLETE, use OI_ef_sequence_memfnp */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		enum OI_ef_sequence_status {	/* return values for end of entry validation functions */
			OI_ef_sequence_bad	= 0,			/* reject, entry is invalid */
			OI_ef_sequence_ok	= 1			/* ok */
		} ;

#ifdef TYPEDEF_MEMFN
	typedef	OI_ef_sequence_status	(OI_ef_sequence_fn)(OI_seq_entry_field*,void*,OI_ef_sequence_status) ;			/* inc/dec callback function */
	typedef	OI_ef_sequence_status	OI_callback::OI_ef_sequence_memfn(OI_seq_entry_field*,void*,OI_ef_sequence_status) ;	/* inc/dec callback member function */
#endif /* TYPEDEF_MEMFN */
	typedef	OI_ef_sequence_status	(*OI_ef_sequence_fnp)(OI_seq_entry_field*,void*,OI_ef_sequence_status) ;			/* inc/dec callback function */
	typedef	OI_ef_sequence_status	(OI_callback::*OI_ef_sequence_memfnp)(OI_seq_entry_field*,void*,OI_ef_sequence_status) ;	/* inc/dec callback member function */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		

 /* ctl_bits private bits */
#define		OI_SEQ_ENTRY_FIELD_INC_DEC_CHK	0x1	/* 1 => call check functions when inc/dec buttons used */
#define		OI_SEQ_ENTRY_FIELD_INC_DOWN	0x2	/* 1 => the increment button is painted "down" */
#define		OI_SEQ_ENTRY_FIELD_DEC_DOWN	0x4	/* 1 => the decrement button is painted "down" */

	class OI_seq_entry_field : public OI_entry_field {  /* sequenced entry field */
			OI_mdl_seq_entry_field	*mdl_dep ;		/* ptr to model dependent aspects of OI_box object */
			unsigned long		ctl_bits ;		/* object specific control bits */
			Window			inc_X_win_id ;		/* X window for increment button */
			Window			dec_X_win_id ;		/* X window for decrement button */
			OI_number		intrvl ;		/* scroll interval, ms, for repeats */
		static	XrmQuark		q_cbDecCheck ;		/* OBSOLETE quark for decrement callback */
		static	XrmQuark		q_cbIncCheck ;		/* OBSOLETE quark for increment callback */
	 protected:
		static	XrmQuark		q_cbSeqDecCheck ;	/* quark for decrement callback */
		static	XrmQuark		q_cbSeqIncCheck ;	/* quark for increment callback */
	 public:
		static	OI_class		*clsp ;			/* ptr to class record */
	 private:
			void			construct() ;
			void			refresh_my_callback(OI_cb_inf*) ;
			void			resize(OI_d_tech *, void *) ;
	 protected:
						OI_seq_entry_field (OI_class*, const char*, OI_number, const char*, const char*, OI_number) ;
		virtual	OI_stat			create() ;		/* create in X environment */
		virtual	OI_number		horz_overhead_other();			/* horizontal overhead for non data entry area only */
			void			new_interval(OI_number t)	{intrvl=t;}
		virtual	void			new_model(OI_model_type) ;
		virtual	OI_number		object_height() ;
		virtual	void			paint(const XEvent*, void* =NULL) ;	/* process exposure events */
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_seq_entry_field (const char*, OI_number, const char* =NULL, const char* =NULL, OI_number =0) ;
						~OI_seq_entry_field() ;				/* destructor */
			void			allow_dec_down()	{ctl_bits |= OI_SEQ_ENTRY_FIELD_DEC_DOWN; }
			void			allow_inc_down()	{ctl_bits |= OI_SEQ_ENTRY_FIELD_INC_DOWN; }
		virtual	OI_number		baseline() ;
		virtual	void			clone_adjust(OI_d_tech*) ;
			void			disallow_dec_down()	{ctl_bits &= ~OI_SEQ_ENTRY_FIELD_DEC_DOWN; }
			void			disallow_inc_down()	{ctl_bits &= ~OI_SEQ_ENTRY_FIELD_INC_DOWN; }
			void			disable() ;
			void			enable() ;
			OI_entry_field		*entry_field()		{return(this);}		/* get ptr to underlying OI_entry_field */
			void			inc_dec_timer();
		static	OI_bool			init(OI_connection*) ;
			OI_bool			is_dec_down()	{ return ((ctl_bits&OI_SEQ_ENTRY_FIELD_DEC_DOWN)?OI_YES:OI_NO); }
			OI_bool			is_inc_down()	{ return ((ctl_bits&OI_SEQ_ENTRY_FIELD_INC_DOWN)?OI_YES:OI_NO); }
		static	OI_seq_entry_field	*make_minimal(const char*,OI_minimal_type) ;
		virtual	void			new_top_pixel(PIXEL, OI_bool=OI_NO) ;
		virtual	void			new_bottom_pixel(PIXEL, OI_bool=OI_NO) ;
		virtual	void			new_down_pixel(PIXEL, OI_bool=OI_NO) ;
		virtual	void			new_bkg_pixel(PIXEL, OI_bool=OI_NO) ;		/* change background pixel generically */
		virtual	void			new_bdr_pixel(PIXEL, OI_bool=OI_NO) ;		/* change border pixel generically */
		virtual	void			new_fg_pixel(PIXEL, OI_bool=OI_NO) ;		/* change foreground pixel generically */
		virtual	void			new_pixels(PIXEL,PIXEL,PIXEL, OI_bool=OI_NO) ;	/* change background, foreground, border pixels generically */
		virtual	OI_stat			new_size(OI_number,OI_number) ;			/* change size of object */
			int			resume_obj(OI_bool=OI_NO) ;			/* resume input processing */
			void			res_inc_dec_chk(void *) ;			/* callback for inc_dec_chk resource */
			void			res_interval(void *);				/* callback to set scroll repeat interval, ms */
			void			strategy(const XEvent*) ;			/* process X input events */
			void			suspend_obj() ;					/* suspend input processing */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_ef_char_chk_status	def_c_chk(OI_entry_field*,void*,OI_number,char) ;	// use def_c_check
			OI_ef_sequence_status	def_dec(OI_seq_entry_field*,void*) ;			// use def_decrement
			OI_ef_sequence_status	def_inc(OI_seq_entry_field*,void*) ;			// use def_increment
			void			set_dec(OI_sequence_fnp fp, void *argp=NULL) ;
			void			set_dec(OI_callback *objp, OI_sequence_memfnp mfp, void *argp=NULL) ;
		virtual	void			set_entry_chk(OI_ef_entry_chk_fnp fp, void *argp=NULL) ;
		virtual	void			set_entry_chk(OI_callback *objp, OI_ef_entry_chk_memfnp mfp, void *argp=NULL) ;
			void			set_inc(OI_sequence_fnp fp, void *argp=NULL) ;
			void			set_inc(OI_callback *objp, OI_sequence_memfnp mfp, void *argp=NULL) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void			repaint(OI_bool=OI_YES) ;
		virtual	void			set_entry_check(OI_ef_entry_check_fnp fp, void *argp=NULL) ;
		virtual	void			set_entry_check(OI_callback *objp, OI_ef_entry_check_memfnp mfp, void *argp=NULL) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			allow_inc_dec_chk()	{ctl_bits |= OI_SEQ_ENTRY_FIELD_INC_DEC_CHK;}
			OI_ef_char_chk_status	def_c_check(OI_entry_field*,void*,OI_ef_char_chk_status,OI_number,char) ;
			OI_ef_sequence_status	def_decrement(OI_seq_entry_field*,void*,OI_ef_sequence_status) ;
			OI_ef_sequence_status	def_increment(OI_seq_entry_field*,void*,OI_ef_sequence_status) ;
			void			disallow_inc_dec_chk()	{ctl_bits &= ~OI_SEQ_ENTRY_FIELD_INC_DEC_CHK;}
			OI_bool			is_inc_dec_chk()	{return(OI_bool)((ctl_bits&OI_SEQ_ENTRY_FIELD_INC_DEC_CHK) != 0);}
			OI_number		interval()		{return(intrvl);}		/* scroll repeat interval, ms */
			void			set_decrement(OI_ef_sequence_fnp fp, void *argp=NULL) ;
			void			set_decrement(OI_callback *objp, OI_ef_sequence_memfnp mfp, void *argp=NULL) ;
			void			set_increment(OI_ef_sequence_fnp fp, void *argp=NULL) ;
			void			set_increment(OI_callback *objp, OI_ef_sequence_memfnp mfp, void *argp=NULL) ;
			void			set_interval(OI_number);				/* set scroll repeat interval, ms */
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			decrement(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			increment(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			paint_decrement(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void			paint_increment(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_seq_entry_field	*oi_create_seq_entry_field(const char*, OI_number,const char* =NULL, const char* =NULL,OI_number =0) ;

#endif /* OI_sqentfld_H */
