/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL, KEVIN E. MARTIN, RICKARD E. FAITH, AND TIAGO GONS DISCLAIM
ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL, KEVIN E. MARTIN, RICKARD E. FAITH, OR TIAGO GONS BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

Modified for the 8514/A by Kevin E. Martin (martin@cs.unc.edu)
Modified for the Mach-8 by Rickard E. Faith (faith@cs.unc.edu)
Further modifications by Tiago Gons (tiago@comosjn.hobby.nl)

******************************************************************/

/* $XFree86: mit/server/ddx/x386/accel/mach8/mach8line.c,v 2.5 1993/12/25 13:59:01 dawes Exp $ */

/* $XConsortium: cfbline.c,v 1.19 91/08/13 18:48:42 keith Exp $ */

#include "X.h"

#include "gcstruct.h"
#include "windowstr.h"
#include "pixmapstr.h"
#include "regionstr.h"
#include "scrnintstr.h"
#include "mistruct.h"

#include "cfb.h"
#include "cfbmskbits.h"
#include "regmach8.h"
#include "mach8.h"

/* single-pixel lines on a color frame buffer

   NON-SLOPED LINES
   horizontal lines are always drawn left to right; we have to
move the endpoints right by one after they're swapped.
   horizontal lines will be confined to a single band of a
region.  the code finds that band (giving up if the lower
bound of the band is above the line we're drawing); then it
finds the first box in that band that contains part of the
line.  we clip the line to subsequent boxes in that band.
   vertical lines are always drawn top to bottom (y-increasing.)
this requires adding one to the y-coordinate of each endpoint
after swapping.

   SLOPED LINES
   when clipping a sloped line, we bring the second point inside
the clipping box, rather than one beyond it, and then add 1 to
the length of the line before drawing it.  this lets us use
the same box for finding the outcodes for both endpoints.  since
the equation for clipping the second endpoint to an edge gives us
1 beyond the edge, we then have to move the point towards the
first point by one step on the major axis.
   eventually, there will be a diagram here to explain what's going
on.  the method uses Cohen-Sutherland outcodes to determine
outsideness, and a method similar to Pike's layers for doing the
actual clipping.

*/

#define OUTCODES(result, x, y, pbox) \
    if (x < pbox->x1) \
	result |= OUT_LEFT; \
    else if (x >= pbox->x2) \
	result |= OUT_RIGHT; \
    if (y < pbox->y1) \
	result |= OUT_ABOVE; \
    else if (y >= pbox->y2) \
	result |= OUT_BELOW;

#define OUTCODES2(result, x, y, l, r, t, b) \
    if (x < l) \
	result |= OUT_LEFT; \
    else if (x >= r) \
	result |= OUT_RIGHT; \
    if (y < t) \
	result |= OUT_ABOVE; \
    else if (y >= b) \
	result |= OUT_BELOW;


void
mach8Line(pDrawable, pGC, mode, npt, pptInit)
    DrawablePtr pDrawable;
    GCPtr	pGC;
    int		mode;		/* Origin or Previous */
    int		npt;		/* number of points */
    DDXPointPtr pptInit;
{
    int nboxInit;
    register int nbox;
    BoxPtr pboxInit;
    register BoxPtr pbox;
    register DDXPointPtr ppt;	/* pointer to list of translated points */

    unsigned int oc1;		/* outcode of point 1 */
    unsigned int oc2;		/* outcode of point 2 */

    int xorg, yorg;		/* origin of window */

    int adx;		/* abs values of dx and dy */
    int ady;
    int signdx;		/* sign of dx and dy */
    int signdy;
    int e, e1, e2;		/* bresenham error and increments */
    int len;			/* length of segment */
    int axis;			/* major axis */
    short cmd = CMD_LINE | DRAW | PLANAR | WRTDATA | LASTPIX;
    short cmd2;
    short fix;

				/* a bunch of temporaries */
    int tmp, npttmp;
    register int y1, y2;
    register int x1, x2;
    RegionPtr cclip;
    cfbPrivGCPtr    devPriv;

/* 11-jun-93 TCG : is VT visible */
    if (!x386VTSema)
    {
        cfbLineSS(pDrawable, pGC, mode, npt, pptInit);
        return;
    }

    devPriv = (cfbPrivGC *)(pGC->devPrivates[cfbGCPrivateIndex].ptr); 
    cclip = devPriv->pCompositeClip;
    pboxInit = REGION_RECTS(cclip);
    nboxInit = REGION_NUM_RECTS(cclip);

    if ((nboxInit < 5) && (nboxInit < npt)) {
        /* 14 sep 93 TCG: iterate lines against clipboxes using the Mach-8
                          direct linedraw registers */
        WaitQueue(5);
        outw(DP_CONFIG, 0x2211);
        outw(FRGD_MIX, FSS_FRGDCOL | mach8alu[pGC->alu]);
        outw(WRT_MASK, (short)pGC->planemask);
        outw(FRGD_COLOR, (short)pGC->fgPixel);

        if (pGC->capStyle != CapNotLast)
            outw(LINEDRAW_OPT, 0);
        else
            outw(LINEDRAW_OPT, 4);

        while (nboxInit--) {

            WaitQueue(5);

            outw(MULTIFUNC_CNTL, SCISSORS_L | pboxInit->x1);
            outw(MULTIFUNC_CNTL, SCISSORS_R | (pboxInit->x2 - 1));
            outw(MULTIFUNC_CNTL, SCISSORS_T | pboxInit->y1);
            outw(MULTIFUNC_CNTL, SCISSORS_B | (pboxInit->y2 - 1));
            outw(LINEDRAW_INDEX, 0);

            xorg = pDrawable->x;
            yorg = pDrawable->y;
            ppt = pptInit;
            npttmp = npt;

            x2 = ppt->x + xorg;
            y2 = ppt->y + yorg;
            oc2 = 0;
            OUTCODES2(oc2, x2, y2, 0, 0, 1024, 1024); /* screenboundaries */

            WaitQueue(2);
            outw(LINEDRAW, x2);
            outw(LINEDRAW, y2);

            while(--npttmp)
            {

            	x1 = x2;
            	y1 = y2;
            	oc1 = oc2;
            	ppt++;
            	if (mode == CoordModePrevious)
            	{
            	    xorg = x1;
            	    yorg = y1;
            	}
            	x2 = ppt->x + xorg;
            	y2 = ppt->y + yorg;

            	if ((x1 != x2) || (y1 != y2))
            	{
                	oc2 = 0;
                	OUTCODES2(oc2, x2, y2, 0, 0, 1024, 1024); /* screenboundaries */

                    if ((oc1 || oc2) && !(oc1 & oc2))
                    {
                        /*
                         * let the mfb helper routine do our work;
                         * better than duplicating code...
                         */
                        BoxRec box;
                        DDXPointRec pt1Copy; /* clipped start point */
                        DDXPointRec pt2Copy; /* clipped end point */
                        int err;             /* modified bresenham error term */
                        int clip1, clip2;    /* clippedness of the endpoints */
                        int clipdx, clipdy;  /* difference between clipped and
                                                unclipped start point */
                        DDXPointRec pt1;


                        pt1.x = pt1Copy.x = x1;
                        pt1.y = pt1Copy.y = y1;
                        pt2Copy.x = x2;
                        pt2Copy.y = y2;
                        box.x1 = pboxInit->x1;
                        box.y1 = pboxInit->y1;
                        box.x2 = pboxInit->x2-1;
                        box.y2 = pboxInit->y2-1;
                        clip1 = 0;
                        clip2 = 0;

                        cmd2 = cmd;
                        signdx = 1;
                        if ((adx = x2 - x1) < 0)
                        {
                            adx = -adx;
                            signdx = -1;
                            fix = 0;
                        } else
                        {
                            cmd2 |= INC_X;
                            fix = -1;
                        }
                        signdy = 1;
                        if ((ady = y2 - y1) < 0)
                        {
                            ady = -ady;
                            signdy = -1;
                        } else
                            cmd2 |= INC_Y;

                        if (adx > ady)
                        {
                            axis = X_AXIS;
                            e1 = ady << 1;
                            e2 = e1 - (adx << 1);
                            e = e1 - adx;
                        } else
                        {
                            axis = Y_AXIS;
                            e1 = adx << 1;
                            e2 = e1 - (ady << 1);
                            e = e1 - ady;
                            cmd2 |= YMAJAXIS;
                        }

                        if (mfbClipLine (pboxInit, box,
                                         &pt1, &pt1Copy, &pt2Copy, 
                                         adx, ady, signdx, signdy, axis,
                                         &clip1, &clip2) == 1)
                        {
                            if (axis == X_AXIS)
                                len = abs(pt2Copy.x - pt1Copy.x);
                            else
                                len = abs(pt2Copy.y - pt1Copy.y);
    
                            len += (clip2 != 0);
                            if (len)
                            {
                                /* unwind bresenham error term to first point */
                                if (clip1)
                                {
                                    clipdx = abs(pt1Copy.x - x1);
                                    clipdy = abs(pt1Copy.y - y1);
                                    if (axis == X_AXIS)
                                    err = e+((clipdy*e2) + ((clipdx-clipdy)*e1));
                                    else
                                    err = e+((clipdx*e2) + ((clipdy-clipdx)*e1));
                                }
                                else
                                    err = e;

                                WaitQueue(7);
                                outw(CUR_X, (short)pt1Copy.x);
                                outw(CUR_Y, (short)pt1Copy.y);
                                outw(ERR_TERM, (short)(err + fix));
                                outw(DESTY_AXSTP, (short)e1);
                                outw(DESTX_DIASTP, (short)e2);
                                outw(MAJ_AXIS_PCNT, (short)len);
                                outw(CMD, cmd2);
                            }
                        }

                        WaitQueue(3);
                        outw(LINEDRAW_INDEX, 0);
                        outw(LINEDRAW, x2);
                        outw(LINEDRAW, y2);

                    } else {
                        WaitQueue(2);
                        outw(LINEDRAW, x2);
                        outw(LINEDRAW, y2);
                    }
                }
            }
            pboxInit++;
        }
	    
        WaitQueue(7);
        outw(LINEDRAW_OPT, 0);
        outw(MULTIFUNC_CNTL, SCISSORS_L | 0);
        outw(MULTIFUNC_CNTL, SCISSORS_R | 1023);
        outw(MULTIFUNC_CNTL, SCISSORS_T | 0);
        outw(MULTIFUNC_CNTL, SCISSORS_B | 1023);
        outw(FRGD_MIX, FSS_FRGDCOL | MIX_SRC);
        outw(BKGD_MIX, BSS_BKGDCOL | MIX_SRC);

    } else { /* original routine iterates clipboxes against lines */

        WaitQueue(3);
        outw(FRGD_MIX, FSS_FRGDCOL | mach8alu[pGC->alu]);
        outw(WRT_MASK, (short)pGC->planemask);
        outw(FRGD_COLOR, (short)pGC->fgPixel);

        xorg = pDrawable->x;
        yorg = pDrawable->y;
        ppt = pptInit;
        x2 = ppt->x + xorg;
        y2 = ppt->y + yorg;
        while(--npt)
        {
            nbox = nboxInit;
            pbox = pboxInit;

            x1 = x2;
            y1 = y2;
            ++ppt;
            if (mode == CoordModePrevious)
            {
                xorg = x1;
                yorg = y1;
            }
            x2 = ppt->x + xorg;
            y2 = ppt->y + yorg;

            if (x1 == x2)
            {
                /* make the line go top to bottom of screen, keeping
                   endpoint semantics
                */
                if (y1 > y2)
                {
                    register int tmp;

                    tmp = y2;
                    y2 = y1 + 1;
                    y1 = tmp + 1;
                }
                /* get to first band that might contain part of line */
                while ((nbox) && (pbox->y2 <= y1))
                {
                    pbox++;
                    nbox--;
                }

                if (nbox)
                {
                    /* stop when lower edge of box is beyond end of line */
                    while((nbox) && (y2 >= pbox->y1))
                    {
                        if ((x1 >= pbox->x1) && (x1 < pbox->x2))
                        {
                            int y1t, y2t;
                            /* this box has part of the line in it */
                            y1t = max(y1, pbox->y1);
                            y2t = min(y2, pbox->y2);
                            if (y1t != y2t)
                            {
                                WaitQueue(4);
                                outw(CUR_X, (short)x1);
                                outw(CUR_Y, (short)y1t);
                                outw(MAJ_AXIS_PCNT, (short)(y2t-y1t-1));
                                outw(CMD, CMD_LINE | DRAW | LINETYPE | PLANAR |
                                          WRTDATA | (6 << 5));
                            }
                        }
                        nbox--;
                        pbox++;
                    }
                }
                y2 = ppt->y + yorg;
            }
            else if (y1 == y2)
            {
                /* force line from left to right, keeping
                   endpoint semantics
                */
                if (x1 > x2)
                {
                    register int tmp;

                    tmp = x2;
                    x2 = x1 + 1;
                    x1 = tmp + 1;
                }

                /* find the correct band */
                while( (nbox) && (pbox->y2 <= y1))
                {
                    pbox++;
                    nbox--;
                }

                /* try to draw the line, if we haven't gone beyond it */
                if ((nbox) && (pbox->y1 <= y1))
                {
                    /* when we leave this band, we're done */
                    tmp = pbox->y1;
                    while((nbox) && (pbox->y1 == tmp))
                    {
                        int x1t, x2t;

                        if (pbox->x2 <= x1)
                        {
                            /* skip boxes until one might contain start point */
                            nbox--;
                            pbox++;
                            continue;
                        }

                        /* stop if left of box is beyond right of line */
                        if (pbox->x1 >= x2)
                        {
                            nbox = 0;
                            break;
                        }

                        x1t = max(x1, pbox->x1);
                        x2t = min(x2, pbox->x2);
                        if (x1t != x2t)
                        {
                            WaitQueue(4);
                            outw(CUR_X, (short)x1t);
                            outw(CUR_Y, (short)y1);
                            outw(MAJ_AXIS_PCNT, (short)(x2t-x1t-1));
                            outw(CMD, CMD_LINE | DRAW | LINETYPE | PLANAR |
                                      WRTDATA);
                        }
                        nbox--;
                        pbox++;
                    }
                }
                x2 = ppt->x + xorg;
            }
            else        /* sloped line */
            {
                cmd2 = cmd;
                signdx = 1;
                if ((adx = x2 - x1) < 0)
                {
                    adx = -adx;
                    signdx = -1;
                    fix = 0;
                }
                else
                {
                    cmd2 |= INC_X;
                    fix = -1;
                }
                signdy = 1;
                if ((ady = y2 - y1) < 0)
                {
                    ady = -ady;
                    signdy = -1;
                }
                else
                {
                    cmd2 |= INC_Y;
                }

                if (adx > ady)
                {
                    axis = X_AXIS;
                    e1 = ady << 1;
                    e2 = e1 - (adx << 1);
                    e = e1 - adx;
                }
                else
                {
                    axis = Y_AXIS;
                    e1 = adx << 1;
                    e2 = e1 - (ady << 1);
                    e = e1 - ady;
                    cmd2 |= YMAJAXIS;
                }

                /* we have bresenham parameters and two points.
                   all we have to do now is clip and draw.
                */

                while(nbox--)
                {
                    oc1 = 0;
                    oc2 = 0;
                    OUTCODES(oc1, x1, y1, pbox);
                    OUTCODES(oc2, x2, y2, pbox);
                    if ((oc1 | oc2) == 0)
                    {
                        if (axis == X_AXIS)
                            len = adx;
                        else
                            len = ady;

                        /* NOTE:  The 8514/A hardware routines for generating
                           lines do not match the software generated lines
                           of mi, cfb, and mfb.  This is a problem, and if I
                           ever get time, I'll figure out the 8514/A algorithm
                           and implement it in software for mi, cfb, and mfb.
                           14-sep-93 TCG: apparently only change needed is
                                          addition of 'fix' stuff in cfbline.c
                           */
                        WaitQueue(7);
                        outw(CUR_X, (short)x1);
                        outw(CUR_Y, (short)y1);
                        outw(ERR_TERM, (short)(e + fix));
                        outw(DESTY_AXSTP, (short)e1);
                        outw(DESTX_DIASTP, (short)e2);
                        outw(MAJ_AXIS_PCNT, (short)len);
                        outw(CMD, cmd2);

                        break;
                    }
                    else if (oc1 & oc2)
                    {
                        pbox++;
                    }
                    else
                    {
                        /*
                         * let the mfb helper routine do our work;
                         * better than duplicating code...
                         */
                        BoxRec box;
                        DDXPointRec pt1Copy; /* clipped start point */
                        DDXPointRec pt2Copy; /* clipped end point */
                        int err;             /* modified bresenham error term */
                        int clip1, clip2;    /* clippedness of the endpoints */
                        int clipdx, clipdy;  /* difference between clipped and
                                                unclipped start point */
                        DDXPointRec pt1;


                        pt1.x = pt1Copy.x = x1;
                        pt1.y = pt1Copy.y = y1;
                        pt2Copy.x = x2;
                        pt2Copy.y = y2;
                        box.x1 = pbox->x1;
                        box.y1 = pbox->y1;
                        box.x2 = pbox->x2-1;
                        box.y2 = pbox->y2-1;
                        clip1 = 0;
                        clip2 = 0;

                        if (mfbClipLine (pbox, box,
                                         &pt1, &pt1Copy, &pt2Copy, 
                                         adx, ady, signdx, signdy, axis,
                                         &clip1, &clip2) == 1)
                        {
                            if (axis == X_AXIS)
                                len = abs(pt2Copy.x - pt1Copy.x);
                            else
                                len = abs(pt2Copy.y - pt1Copy.y);
    
                            len += (clip2 != 0);
                            if (len)
                            {
                                /* unwind bresenham error term to first point */
                                if (clip1)
                                {
                                    clipdx = abs(pt1Copy.x - x1);
                                    clipdy = abs(pt1Copy.y - y1);
                                    if (axis == X_AXIS)
                                    err = e+((clipdy*e2) + ((clipdx-clipdy)*e1));
                                    else
                                    err = e+((clipdx*e2) + ((clipdy-clipdx)*e1));
                                }
                                else
                                    err = e;

                                WaitQueue(7);
                                outw(CUR_X, (short)pt1Copy.x);
                                outw(CUR_Y, (short)pt1Copy.y);
                                outw(ERR_TERM, (short)(err + fix));
                                outw(DESTY_AXSTP, (short)e1);
                                outw(DESTX_DIASTP, (short)e2);
                                outw(MAJ_AXIS_PCNT, (short)len);
                                outw(CMD, cmd2);
                            }
                        }
                        pbox++;
                    }
                } /* while (nbox--) */
            } /* sloped line */
        } /* while (--npt) */

        /* paint the last point if the end style isn't CapNotLast.
           (Assume that a projecting, butt, or round cap that is one
            pixel wide is the same as the single pixel of the endpoint.)
        */

        if ((pGC->capStyle != CapNotLast) &&
            ((ppt->x + xorg != pptInit->x + pDrawable->x) ||
             (ppt->y + yorg != pptInit->y + pDrawable->y) ||
             (ppt == pptInit + 1)))
        {
            nbox = nboxInit;
            pbox = pboxInit;
            while (nbox--)
            {
                if ((x2 >= pbox->x1) &&
                    (y2 >= pbox->y1) &&
                    (x2 <  pbox->x2) &&
                    (y2 <  pbox->y2))
                {
                    WaitQueue(4);
                    outw(CUR_X, (short)x2);
                    outw(CUR_Y, (short)y2);
                    outw(MAJ_AXIS_PCNT, 0);
                    outw(CMD, CMD_LINE | DRAW | LINETYPE | PLANAR | WRTDATA);

                    break;
                }
                else
                    pbox++;
            }
        }

        WaitQueue(2);
        outw(FRGD_MIX, FSS_FRGDCOL | MIX_SRC);
        outw(BKGD_MIX, BSS_BKGDCOL | MIX_SRC);
    }
}
