#include <stdio.h>
#include <getopt.h>
#include "config.h"
#include "man.h"

extern char *strdup (), *getenv(), *strchr(), *getval();
extern char *pager, *roff_directive;
extern char *colon_sep_section_list;
extern int debug, apropos, whatis, findall, print_where, do_troff;

#ifdef ALT_SYSTEMS
static int alt_system;
static char *alt_system_name;
#endif

static char short_opts[] = "C:M:P:S:adfhkm:p:tw?";

static const struct option long_opts[] = {
    { "path",       no_argument,            NULL, 'w' },
    { NULL, 0, NULL, 0 }
};

/*
 * Get options from the command line and user environment.
 * Also reads the configuration file.
 */

void
man_getopt (argc, argv)
     register int argc;
     register char **argv;
{
  register int c;
  register char *p;
  register char *end;
  register struct dir *mp;
  char *config_file = NULL;
  char *manp = NULL;
  extern char *optarg;
  extern int getopt_long ();
  extern void manpath ();

  while ((c = getopt_long (argc, argv, short_opts, long_opts, NULL)) != -1) {
      switch (c) {
	case 'C':
	  config_file = strdup (optarg);
	  break;
	case 'M':
	  manp = strdup (optarg);
	  break;
	case 'P':
	  pager = strdup (optarg);
	  break;
	case 'S':
	  colon_sep_section_list = strdup (optarg); 
	  break;
	case 'a':
	  findall++;
	  break;
	case 'd':
	  debug++;
	  break;
	case 'f':
	  if (do_troff)
	    gripe_incompatible ("-f and -t");
	  if (apropos)
	    gripe_incompatible ("-f and -k");
	  if (print_where)
	    gripe_incompatible ("-f and -w");
	  whatis++;
	  break;
	case 'k':
	  if (do_troff)
	    gripe_incompatible ("-k and -t");
	  if (whatis)
	    gripe_incompatible ("-k and -f");
	  if (print_where)
	    gripe_incompatible ("-k and -w");
	  apropos++;
	  break;
	case 'm':
#ifdef ALT_SYSTEMS
	  alt_system++;
	  alt_system_name = strdup (optarg);
	  break;
#else
	  fprintf (stderr, "Sorry - no support for alternate systems compiled in\n");
	  exit(1);
#endif
	case 'p':
	  roff_directive = strdup (optarg);
	  break;
	case 't':
	  if (apropos)
	    gripe_incompatible ("-t and -k");
	  if (whatis)
	    gripe_incompatible ("-t and -f");
	  if (print_where)
	    gripe_incompatible ("-t and -w");
	  do_troff++;
	  break;
	case 'w':
	  if (apropos)
	    gripe_incompatible ("-w and -k");
	  if (whatis)
	    gripe_incompatible ("-w and -f");
	  if (do_troff)
	    gripe_incompatible ("-w and -t");
	  print_where++;
	  break;
	case 'h':
	case '?':
	default:
	  usage();
	  break;
      }
  }

  read_config_file (config_file);

  if (pager == NULL || *pager == '\0')
    if ((pager = getenv ("PAGER")) == NULL)
      pager = getval ("PAGER");

  if (debug)
    fprintf (stderr, "\nusing %s as pager\n", pager);

  manpath (manp, 0);		/* 0: no error printout */

#ifdef ALT_SYSTEMS
  if (alt_system_name == NULL || *alt_system_name == '\0')
    if ((alt_system_name = getenv ("SYSTEM")) != NULL)
      alt_system_name = strdup (alt_system_name);
#endif

}
