.\" Man page for man
.\"
.\" Copyright (c) 1991, John W. Eaton.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the README file that comes with the man 1.0
.\" distribution.  
.\"
.\" John W. Eaton
.\" jwe@che.utexas.edu
.\" Department of Chemical Engineering
.\" The University of Texas at Austin
.\" Austin, Texas  78712
.\"
.TH man 1 "Jan 5, 1991"
.LO 1
.SH NAME
man \- format and display the on-line manual pages
.SH SYNOPSIS
man [\-afhkt] [\-M path] [\-P pager] [\-S system] [section] name ...
.SH DESCRIPTION
man formats and displays the on-line manual pages.  This version knows
about the MANPATH and PAGER environment variables, so you can have
your own set(s) of personal man pages and choose whatever program you
like to display the formatted pages.  If section is specified, man
only looks in that section of the manual.
.SH OPTIONS
.TP
.B \-\^P " pager"
Specify which pager to use.  By default,
.B man
uses
.B less,
which has the ability to backup on files and pipes, so you can go
backwards while reading the manual.  This option overrides the
.B PAGER
environment variable.
.TP
.B \-\^M " path"
Specify an alternate manpath.  By default, man uses
.B manpath
to determine the path to search.  This option overrides the
.B MANPATH
environment variable.
.TP
.B \-\^a
By default,
.B man
will exit after displaying the first manual page it finds.  Using this
option forces
.B man
to display all the manual pages that match
.B name, 
not just the first.  
.TP
.B \-\^f
Equivalent to
.B whatis.
.TP
.B \-\^h
Print a one line help message and exit.
.TP
.B \-\^k
Equivalent to
.B apropos.
.TP
.B \-\^t
Use
.B troff
to format the manual page, passing the output to 
.B stdout.
Normally the output from
.B troff
will need to be passed through some filter or another before being
printed.
.SH ENVIRONMENT
.TP \w'MANPATH\ \ 'u
.B MANPATH
If
.B MANPATH
is set,
.B man
uses its value as the path to search for manual pages.
.TP
.B PAGER
If
.B PAGER
is set,
.B man
uses its value as the name of the program to use to display the man
page.  By default,
.B less
is used.
.SH "SEE ALSO"
apropos(1), whatis(1), manpath(1), less(1), nroff(1), troff(1), psdit(1).
.SH BUGS
The
.B \-t
option only works if
.B troff
is installed.
.PP
.B less
is sometimes confused by underlined text.
