-----------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                       A D A . C H A R A C T E R S                        --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.4 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------


package Ada.Characters is
   pragma Pure (Ada.Characters);

   ----------------------------------------
   -- Character Classification Functions --
   ----------------------------------------

   function Is_Control (Item : in Character) return Boolean;
   pragma Inline (Is_Control);

   function Is_Graphic (Item : in Character) return Boolean;
   pragma Inline (Is_Graphic);

   function Is_Letter (Item : in Character) return Boolean;
   pragma Inline (Is_Letter);

   function Is_Lower (Item : in Character) return Boolean;
   pragma Inline (Is_Lower);

   function Is_Upper (Item : in Character) return Boolean;
   pragma Inline (Is_Upper);

   function Is_Basic (Item : in Character) return Boolean;
   pragma Inline (Is_Basic);

   function Is_Digit (Item : in Character) return Boolean;
   pragma Inline (Is_Digit);

   function Is_Decimal_Digit (Item : in Character) return Boolean
     renames Is_Digit;

   function Is_Hexadecimal_Digit (Item : in Character) return Boolean;
   pragma Inline (Is_Hexadecimal_Digit);

   function Is_Alphanumeric (Item : in Character) return Boolean;
   pragma Inline (Is_Alphanumeric);

   function Is_Special_Graphic (Item : in Character) return Boolean;
   pragma Inline (Is_Special_Graphic);

   ------------------------------------
   -- Character Conversion Functions --
   ------------------------------------

   function To_Lower (Item : in Character) return Character;
   pragma Inline (To_Lower);

   function To_Upper (Item : in Character) return Character;
   pragma Inline (To_Upper);

   function To_Basic (Item : in Character) return Character;
   pragma Inline (To_Basic);

   ---------------------------------
   -- String Conversion Functions --
   ---------------------------------

   function To_Lower (Item : in String) return String;
   function To_Upper (Item : in String) return String;
   function To_Basic (Item : in String) return String;

   ----------------------------------------------------------------------
   -- Classifications of and Conversions Between Character and ISO 646 --
   ----------------------------------------------------------------------

   subtype ISO_646 is
     Character range Character'Val (0) .. Character'Val (127);

   function Is_ISO_646 (Item : in Character) return Boolean;
   pragma Inline (Is_ISO_646);

   function Is_ISO_646 (Item : in String)    return Boolean;

   function To_ISO_646 (
     Item       : in Character;
     Substitute : in ISO_646 := ' ')
     return ISO_646;
   pragma Inline (To_ISO_646);

   function To_ISO_646 (Item : in String; Substitute : in ISO_646 := ' ')
     return String;

   ------------------------------------------------------
   -- Classifications of Wide_Character and Characters --
   ------------------------------------------------------

   function Is_Character (Item : in Wide_Character) return Boolean;
   pragma Inline (Is_Character);

   function Is_String (Item : in Wide_String)    return Boolean;

   ------------------------------------------------------
   -- Conversions between Wide_Character and Character --
   ------------------------------------------------------

   function To_Character (
     Item       : in Wide_Character;
     Substitute : in Character := ' ')
     return Character;
   pragma Inline (To_Character);

   function To_String (
     Item       : in Wide_String;
     Substitute : in Character := ' ')
     return String;

   function To_Wide_Character (Item : in Character) return Wide_Character;
   pragma Inline (To_Wide_Character);

   function To_Wide_String (Item : in String) return Wide_String;

end Ada.Characters;
