/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                             A - S N A M E S                              */
/*                                                                          */
/*                              C Header File                               */
/*                                                                          */
/*                            $Revision: 1.5 $                              */
/*                                                                          */
/*           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/* This is the C file that corresponds to the Ada package specification
   Snames. It was created manually from the file snames.ads.

/* Name_Id values */

#define Name_uParent First_Name_Id + 256
#define Name_uTag    First_Name_Id + 256 + 017

/* Define the function to return one of the numeric values below.  Note
   that it actually returns a char since an enumeration value of less
   than 256 entries is represented that way in Ada.  The operand is a Chars
   field value.  */

#define Get_Attribute_Id snames__get_attribute_id
extern char Get_Attribute_Id PROTO ((int));

/* Define the numeric values for the attributes.  */

#define  Attr_Abort_Signal                  0
#define  Attr_Access                        1
#define  Attr_Address                       2
#define  Attr_Address_Size                  3
#define  Attr_Adjacent                      4
#define  Attr_Aft                           5
#define  Attr_Alignment                     6
#define  Attr_Bit_Order                     7
#define  Attr_Body_Version                  8
#define  Attr_Callable                      9
#define  Attr_Caller                        10
#define  Attr_Ceiling                       11
#define  Attr_Component_Size                12
#define  Attr_Compose                       13
#define  Attr_Constrained                   14
#define  Attr_Copy_Sign                     15
#define  Attr_Count                         16
#define  Attr_Definite                      17
#define  Attr_Delta                         18
#define  Attr_Denorm                        19
#define  Attr_Digits                        20
#define  Attr_Emax                          21
#define  Attr_Epsilon                       22
#define  Attr_Exponent                      23
#define  Attr_External_Tag                  24
#define  Attr_First                         25
#define  Attr_First_Bit                     26
#define  Attr_Floor                         27
#define  Attr_Fore                          28
#define  Attr_Fraction                      29
#define  Attr_Identity                      30
#define  Attr_Image                         31
#define  Attr_Input                         32
#define  Attr_Large                         33
#define  Attr_Last                          34
#define  Attr_Last_Bit                      35
#define  Attr_Leading_Part                  36
#define  Attr_Length                        37
#define  Attr_Machine                       38
#define  Attr_Machine_Emax                  39
#define  Attr_Machine_Emin                  40
#define  Attr_Machine_Mantissa              41
#define  Attr_Machine_Overflows             42
#define  Attr_Machine_Radix                 43
#define  Attr_Machine_Rounds                44
#define  Attr_Mantissa                      45
#define  Attr_Max                           46
#define  Attr_Max_Interrupt_Priority        47
#define  Attr_Max_Priority                  48
#define  Attr_Max_Size_In_Storage_Elements  49
#define  Attr_Min                           50
#define  Attr_Model                         51
#define  Attr_Model_Emin                    52
#define  Attr_Model_Epsilon                 53
#define  Attr_Model_Mantissa                54
#define  Attr_Model_Small                   55
#define  Attr_Output                        56
#define  Attr_Pos                           57
#define  Attr_Position                      58
#define  Attr_Pred                          59
#define  Attr_Range                         60
#define  Attr_Read                          61
#define  Attr_Remainder                     62
#define  Attr_Round                         63
#define  Attr_Rounding                      64
#define  Attr_Safe_Emax                     65
#define  Attr_Safe_First                    66
#define  Attr_Safe_Large                    67
#define  Attr_Safe_Last                     68
#define  Attr_Safe_Small                    69
#define  Attr_Scale                         70
#define  Attr_Scaling                       71
#define  Attr_Signed_Zeros                  72
#define  Attr_Size                          73
#define  Attr_Small                         74
#define  Attr_Storage_Pool                  75
#define  Attr_Storage_Size                  76
#define  Attr_Storage_Unit                  77
#define  Attr_Succ                          78
#define  Attr_Tag                           79
#define  Attr_Terminated                    80
#define  Attr_Tick                          81
#define  Attr_Truncation                    82
#define  Attr_Unbiased_Rounding             83
#define  Attr_Unchecked_Access              84
#define  Attr_Universal_Literal_String      85
#define  Attr_Unrestricted_Access           86
#define  Attr_Val                           87
#define  Attr_Valid                         88
#define  Attr_Value                         89
#define  Attr_Version                       90
#define  Attr_Wide_Image                    91
#define  Attr_Wide_Value                    92
#define  Attr_Width                         93
#define  Attr_Word_Size                     94
#define  Attr_Write                         95

#define  Attribute_Base                     96
#define  Attribute_Class                    97

/* End of a-snames.h (C version of Snames package spec) */
