------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              T R E E P R S                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                Generated by xtreeprs revision 1.21 using                 --
--                         sinfo.ads revision 1.180                          --
--                        treeprs.adt revision 1.10                          --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------


--  This package contains the declaration of the string used by the Tree_Print
--  package. It must be updated whenever the arrangements of the field names
--  in package Sinfo is changed. The utility program XTREEPRS is used to
--  do this update correctly using the template treeprs.adt as input.

with Sinfo; use Sinfo;

package Treeprs is

   --------------------------------
   -- String Data for Node Print --
   --------------------------------

   --  String data for print out. The Pchars array is a long string with the
   --  the entry for each node type consisting of a single blank, followed by
   --  a series of entries, one for each Op or Flag field used for the node.
   --  Each entry has a single character which identifies the field, followed
   --  by the synonym name. The starting location for a given node type is
   --  found from the corresponding entry in the Pchars_Pos_Array.

   --  The following characters identify the field. These are characters
   --  which  could never occur in a field name, so they also mark the
   --  end of the previous name.

   subtype Fchar is Character range '#' .. '7';

   F_Field1     : constant Fchar := '#'; -- Character'Val (16#23#)
   F_Field2     : constant Fchar := '$'; -- Character'Val (16#24#)
   F_Field3     : constant Fchar := '%'; -- Character'Val (16#25#)
   F_Field4     : constant Fchar := '&'; -- Character'Val (16#26#)
   F_Field5     : constant Fchar := '''; -- Character'Val (16#27#)
   F_Flag1      : constant Fchar := '('; -- Character'Val (16#28#)
   F_Flag2      : constant Fchar := ')'; -- Character'Val (16#29#)
   F_Flag3      : constant Fchar := '*'; -- Character'Val (16#2A#)
   F_Flag4      : constant Fchar := '+'; -- Character'Val (16#2B#)
   F_Flag5      : constant Fchar := ','; -- Character'Val (16#2C#)
   F_Flag6      : constant Fchar := '-'; -- Character'Val (16#2D#)
   F_Flag7      : constant Fchar := '.'; -- Character'Val (16#2E#)
   F_Flag8      : constant Fchar := '/'; -- Character'Val (16#2F#)
   F_Flag9      : constant Fchar := '0'; -- Character'Val (16#30#)
   F_Flag10     : constant Fchar := '1'; -- Character'Val (16#31#)
   F_Flag11     : constant Fchar := '2'; -- Character'Val (16#32#)
   F_Flag12     : constant Fchar := '3'; -- Character'Val (16#33#)
   F_Flag13     : constant Fchar := '4'; -- Character'Val (16#34#)
   F_Flag14     : constant Fchar := '5'; -- Character'Val (16#35#)
   F_Flag15     : constant Fchar := '6'; -- Character'Val (16#36#)
   F_Flag16     : constant Fchar := '7'; -- Character'Val (16#37#)

   --  Note this table does not include entity field and flags whose access
   --  functions are in Einfo (these are handled by the Print_Entity_Info
   --  procedure in Treepr, which uses the routines in Einfo to get the
   --  proper symbolic information). In addition, the following fields are
   --  handled by Treepr, and do not appear in the Pchars array:

   --    Analyzed
   --    Chars
   --    Comes_From_Source
   --    Error_Posted
   --    Etype
   --    Has_No_Side_Effects
   --    Is_Folded
   --    Is_Overloaded
   --    Is_Static
   --    Left_Opnd
   --    Must_Check_Expr
   --    No_Overflow_Expr
   --    Paren_Count
   --    Right_Opnd

   Pchars : constant String :=
      --  Unused_At_Start
      "" &
      --  At_Clause
      "#Identifier%Expression" &
      --  Component_Clause
      "#Component_Name$Position%First_Bit&Last_Bit" &
      --  Enumeration_Representation_Clause
      "#Identifier&Array_Aggregate" &
      --  Mod_Clause
      "%Expression" &
      --  Record_Representation_Clause
      "#Identifier$Mod_Clause%Component_Clauses" &
      --  Attribute_Definition_Clause
      "$Name%Expression" &
      --  Empty
      "" &
      --  Error
      "" &
      --  Pragma
      "$Pragma_Argument_Associations%Debug_Statement" &
      --  Pragma_Argument_Association
      "%Expression" &
      --  Defining_Character_Literal
      "$Next_Entity%Scope&Homonym)Comes_From_Source" &
      --  Defining_Identifier
      "$Next_Entity%Scope&Homonym)Comes_From_Source" &
      --  Defining_Operator_Symbol
      "$Next_Entity%Scope&Homonym)Comes_From_Source" &
      --  Expanded_Name
      "%Prefix$Selector_Name&Entity*Redundant_Use2Has_Private_View" &
      --  Identifier
      "&Entity*Redundant_Use2Has_Private_View)Comes_From_Source" &
      --  Character_Literal
      "$Char_Literal_Value&Entity2Has_Private_View)Comes_From_Source" &
      --  Operator_Symbol
      "%Strval&Entity2Has_Private_View)Comes_From_Source" &
      --  Op_Add
      "" &
      --  Op_And
      "+Do_Length_Check" &
      --  Op_And_Then
      "" &
      --  Op_Concat
      "" &
      --  Op_Divide
      "*Do_Division_Check" &
      --  Op_Eq
      "" &
      --  Op_Expon
      "" &
      --  Op_Ge
      "" &
      --  Op_Gt
      "" &
      --  Op_In
      "" &
      --  Op_Le
      "" &
      --  Op_Lt
      "" &
      --  Op_Mod
      "*Do_Division_Check" &
      --  Op_Multiply
      "" &
      --  Op_Ne
      "" &
      --  Op_Not_In
      "" &
      --  Op_Or
      "+Do_Length_Check" &
      --  Op_Or_Else
      "" &
      --  Op_Rem
      "*Do_Division_Check" &
      --  Op_Subtract
      "" &
      --  Op_Xor
      "+Do_Length_Check" &
      --  Op_Rotate_Left
      "" &
      --  Op_Rotate_Right
      "" &
      --  Op_Shift_Left
      "" &
      --  Op_Shift_Right
      "" &
      --  Op_Shift_Right_Arithmetic
      "" &
      --  Op_Abs
      "" &
      --  Op_Minus
      "" &
      --  Op_Not
      "" &
      --  Op_Plus
      "" &
      --  Attribute_Reference
      "%Prefix$Attribute_Name#Expressions&Entity)Do_Access_Check" &
      --  Concat_Multiple
      "#Expressions" &
      --  Conditional_Expression
      "#Expressions" &
      --  Explicit_Dereference
      "%Prefix)Do_Access_Check" &
      --  Extension_Aggregate
      "%Expression&Component_Associations)Null_Record_Present" &
      --  Function_Call
      "$Name%Parameter_Associations&First_Named_Actual#Controlling_Argument)" &
         "Do_Elaboration_Check*Do_Tag_Check" &
      --  Indexed_Component
      "%Prefix#Expressions)Do_Access_Check" &
      --  Integer_Literal
      "%Intval)Comes_From_Source" &
      --  Null
      "" &
      --  Procedure_Call_Statement
      "$Name%Parameter_Associations&First_Named_Actual#Controlling_Argument)" &
         "Do_Elaboration_Check*Do_Tag_Check" &
      --  Qualified_Expression
      "&Subtype_Mark%Expression" &
      --  Range
      "#Low_Bound$High_Bound" &
      --  Real_Literal
      "%Numerator&Denominator*Decimal)Comes_From_Source" &
      --  Selected_Component
      "%Prefix$Selector_Name)Do_Access_Check*Do_Discriminant_Check" &
      --  Type_Conversion
      "&Subtype_Mark%Expression)Do_Overflow_Check*Do_Tag_Check+Do_Length_Che" &
         "ck" &
      --  Unchecked_Type_Conversion
      "&Subtype_Mark%Expression" &
      --  Allocator
      "%Expression#Storage_Pool&Procedure_To_Call)Do_Storage_Check$First_Ity" &
         "pe5Has_Dynamic_Itype" &
      --  Aggregate
      "#Expressions&Component_Associations)Null_Record_Present$First_Itype5H" &
         "as_Dynamic_Itype" &
      --  Expression_Actions
      "#Actions%Expression$First_Itype5Has_Dynamic_Itype" &
      --  Reference
      "%Prefix$First_Itype5Has_Dynamic_Itype" &
      --  Slice
      "%Prefix&Discrete_Range)Do_Access_Check$First_Itype5Has_Dynamic_Itype" &
      --  String_Literal
      "%Strval$First_Itype5Has_Dynamic_Itype)Comes_From_Source" &
      --  Subtype_Indication
      "&Subtype_Mark%Constraint$First_Itype5Has_Dynamic_Itype" &
      --  Component_Declaration
      "#Defining_Identifier(Aliased_Present'Subtype_Indication%Expression,Mo" &
         "re_Ids-Prev_Ids$First_Itype5Has_Dynamic_Itype" &
      --  Entry_Body
      "#Defining_Identifier'Entry_Body_Formal_Part%Declarations&Handled_Stat" &
         "ement_Sequence$First_Itype5Has_Dynamic_Itype" &
      --  Entry_Declaration
      "#Defining_Identifier&Discrete_Subtype_Definition%Parameter_Specificat" &
         "ions$First_Itype5Has_Dynamic_Itype" &
      --  Formal_Object_Declaration
      "#Defining_Identifier(In_Present)Out_Present&Subtype_Mark%Expression,M" &
         "ore_Ids-Prev_Ids$First_Itype5Has_Dynamic_Itype" &
      --  Formal_Type_Declaration
      "#Defining_Identifier%Formal_Type_Definition&Discriminant_Specificatio" &
         "ns$First_Itype*Has_Unknown_Discriminants" &
      --  Freeze_Entity
      "&Entity$First_Itype5Has_Dynamic_Itype" &
      --  Full_Type_Declaration
      "#Defining_Identifier&Discriminant_Specifications%Type_Definition$Firs" &
         "t_Itype5Has_Dynamic_Itype" &
      --  Incomplete_Type_Declaration
      "#Defining_Identifier&Discriminant_Specifications*Has_Unknown_Discrimi" &
         "nants$First_Itype5Has_Dynamic_Itype" &
      --  Implicit_Types
      "$First_Itype" &
      --  Iteration_Scheme
      "'Condition#Loop_Parameter_Specification$First_Itype5Has_Dynamic_Itype" &
      --  Object_Declaration
      "#Defining_Identifier(Aliased_Present)Constant_Present&Object_Definiti" &
         "on%Expression,More_Ids-Prev_Ids$First_Itype5Has_Dynamic_Itype" &
      --  Subtype_Declaration
      "#Defining_Identifier'Subtype_Indication" &
      --  Function_Specification
      "#Defining_Unit_Name%Parameter_Specifications&Subtype_Mark'Generic_Par" &
         "ent$First_Itype5Has_Dynamic_Itype" &
      --  Procedure_Specification
      "#Defining_Unit_Name%Parameter_Specifications'Generic_Parent$First_Ity" &
         "pe5Has_Dynamic_Itype" &
      --  Accept_Statement
      "#Entry_Direct_Name'Entry_Index%Parameter_Specifications&Handled_State" &
         "ment_Sequence$First_Itype5Has_Dynamic_Itype" &
      --  Abort_Statement
      "$Names" &
      --  Assignment_Statement
      "$Name%Expression*Do_Tag_Check+Do_Length_Check" &
      --  Block_Statement
      "#Identifier%Declarations&Handled_Statement_Sequence,Is_Task_Master$Ac" &
         "tivation_Chain_Entity(Has_Created_Identifier" &
      --  Case_Statement
      "%Expression&Alternatives" &
      --  Code_Statement
      "%Expression" &
      --  Delay_Relative_Statement
      "%Expression" &
      --  Delay_Until_Statement
      "%Expression" &
      --  Entry_Call_Statement
      "$Name%Parameter_Associations&First_Named_Actual)Do_Elaboration_Check" &
      --  Exit_Statement
      "$Name'Condition" &
      --  Free_Statement
      "%Expression#Storage_Pool&Procedure_To_Call" &
      --  Goto_Statement
      "$Name" &
      --  If_Statement
      "'Condition$Then_Statements%Elsif_Parts&Else_Statements" &
      --  Loop_Statement
      "#Identifier$Iteration_Scheme%Statements(Has_Created_Identifier" &
      --  Null_Statement
      "" &
      --  Raise_Statement
      "$Name(No_Defer" &
      --  Requeue_Statement
      "$Name(Abort_Present" &
      --  Return_Statement
      "%Expression*Do_Tag_Check#Return_Type" &
      --  Access_Function_Definition
      "(Protected_Present%Parameter_Specifications&Subtype_Mark" &
      --  Access_Procedure_Definition
      "(Protected_Present%Parameter_Specifications" &
      --  Constrained_Array_Definition
      "$Discrete_Subtype_Definitions(Aliased_Present'Subtype_Indication" &
      --  Unconstrained_Array_Definition
      "$Subtype_Marks(Aliased_Present'Subtype_Indication" &
      --  Package_Body_Stub
      "#Defining_Identifier&Library_Unit'Corresponding_Body" &
      --  Protected_Body_Stub
      "#Defining_Identifier&Library_Unit'Corresponding_Body" &
      --  Subprogram_Body_Stub
      "#Specification&Library_Unit'Corresponding_Body" &
      --  Task_Body_Stub
      "#Defining_Identifier&Library_Unit'Corresponding_Body" &
      --  Function_Instantiation
      "#Defining_Unit_Name$Name%Generic_Associations&Parent_Spec" &
      --  Package_Instantiation
      "#Defining_Unit_Name$Name&Parent_Spec%Generic_Associations" &
      --  Procedure_Instantiation
      "#Defining_Unit_Name$Name&Parent_Spec%Generic_Associations" &
      --  Package_Body
      "#Defining_Unit_Name%Declarations&Handled_Statement_Sequence'Correspon" &
         "ding_Spec" &
      --  Subprogram_Body
      "#Specification%Declarations&Handled_Statement_Sequence(Bad_Is_Detecte" &
         "d'Corresponding_Spec+Acts_As_Spec)Do_Storage_Check,Is_Task_Master$" &
         "Activation_Chain_Entity-Has_Priority_Pragma" &
      --  Implicit_Label_Declaration
      "#Defining_Identifier$Label" &
      --  Package_Declaration
      "#Specification'Corresponding_Body&Parent_Spec$Activation_Chain_Entity" &
      --  Single_Task_Declaration
      "#Defining_Identifier%Task_Definition" &
      --  Subprogram_Declaration
      "#Specification'Corresponding_Body&Parent_Spec" &
      --  Task_Body
      "#Defining_Identifier%Declarations&Handled_Statement_Sequence,Is_Task_" &
         "Master$Activation_Chain_Entity'Corresponding_Spec" &
      --  Task_Type_Declaration
      "#Defining_Identifier&Discriminant_Specifications%Task_Definition" &
      --  Use_Package_Clause
      "$Names" &
      --  Generic_Package_Declaration
      "#Specification'Corresponding_Body%Generic_Formal_Declarations&Parent_" &
         "Spec$Activation_Chain_Entity" &
      --  Generic_Subprogram_Declaration
      "#Specification'Corresponding_Body%Generic_Formal_Declarations&Parent_" &
         "Spec" &
      --  Exception_Renaming_Declaration
      "#Defining_Identifier$Name" &
      --  Object_Renaming_Declaration
      "#Defining_Identifier&Subtype_Mark$Name" &
      --  Package_Renaming_Declaration
      "#Defining_Unit_Name$Name&Parent_Spec" &
      --  Subprogram_Renaming_Declaration
      "#Specification$Name&Parent_Spec'Corresponding_Spec" &
      --  Generic_Function_Renaming_Declaration
      "#Defining_Unit_Name$Name&Parent_Spec" &
      --  Generic_Package_Renaming_Declaration
      "#Defining_Unit_Name$Name&Parent_Spec" &
      --  Generic_Procedure_Renaming_Declaration
      "#Defining_Unit_Name$Name&Parent_Spec" &
      --  Abortable_Part
      "%Statements" &
      --  Abstract_Subprogram_Declaration
      "#Specification" &
      --  Accept_Alternative
      "$Accept_Statement'Condition%Statements" &
      --  Access_Definition
      "&Subtype_Mark" &
      --  Access_To_Object_Definition
      "(All_Present'Subtype_Indication)Constant_Present" &
      --  Asynchronous_Select
      "#Triggering_Alternative$Abortable_Part" &
      --  Case_Statement_Alternative
      "&Discrete_Choices%Statements" &
      --  Compilation_Unit
      "&Library_Unit#Context_Items(Private_Present$Unit%Following_Pragmas)Pr" &
         "eelaborable*Body_Required+Acts_As_Spec.Elaborate_Body_Present" &
      --  Component_Association
      "#Choices%Expression" &
      --  Component_List
      "%Component_Declarations&Variant_Part*Null_Present" &
      --  Conditional_Entry_Call
      "#Entry_Call_Alternative&Else_Statements" &
      --  Derived_Type_Definition
      "+Abstract_Present'Subtype_Indication%Record_Extension_Part" &
      --  Decimal_Fixed_Point_Definition
      "%Delta_Expression$Digits_Expression&Real_Range_Specification" &
      --  Defining_Program_Unit_Name
      "$Name#Defining_Identifier" &
      --  Delay_Alternative
      "$Delay_Statement'Condition%Statements" &
      --  Delta_Constraint
      "%Delta_Expression&Range_Constraint" &
      --  Designator
      "$Name#Identifier" &
      --  Digits_Constraint
      "$Digits_Expression&Range_Constraint" &
      --  Discriminant_Association
      "#Selector_Names%Expression" &
      --  Discriminant_Specification
      "#Defining_Identifier$Discriminant_Type%Expression,More_Ids-Prev_Ids" &
      --  Elsif_Part
      "'Condition$Then_Statements" &
      --  Enumeration_Type_Definition
      "#Literals" &
      --  Entry_Body_Formal_Part
      "#Entry_Index_Specification%Parameter_Specifications'Condition" &
      --  Entry_Call_Alternative
      "#Entry_Call_Statement%Statements" &
      --  Entry_Index_Specification
      "#Defining_Identifier&Discrete_Subtype_Definition" &
      --  Exception_Declaration
      "#Defining_Identifier,More_Ids-Prev_Ids" &
      --  Exception_Handler
      "$Choice_Parameter&Exception_Choices%Statements" &
      --  Floating_Point_Definition
      "$Digits_Expression&Real_Range_Specification" &
      --  Formal_Decimal_Fixed_Point_Definition
      "" &
      --  Formal_Derived_Type_Definition
      "&Subtype_Mark(Private_Present" &
      --  Formal_Discrete_Type_Definition
      "" &
      --  Formal_Floating_Point_Definition
      "" &
      --  Formal_Modular_Type_Definition
      "" &
      --  Formal_Ordinary_Fixed_Point_Definition
      "" &
      --  Formal_Package_Declaration
      "#Defining_Identifier$Name%Generic_Associations(Box_Present" &
      --  Formal_Private_Type_Definition
      "+Abstract_Present(Tagged_Present)Limited_Present" &
      --  Formal_Signed_Integer_Type_Definition
      "" &
      --  Formal_Subprogram_Declaration
      "#Specification$Default_Name(Box_Present" &
      --  Generic_Association
      "$Selector_Name#Explicit_Generic_Actual_Parameter" &
      --  Handled_Sequence_Of_Statements
      "%Statements&Exception_Handlers#Identifier" &
      --  Index_Or_Discriminant_Constraint
      "#Constraints" &
      --  Label
      "#Identifier" &
      --  Loop_Parameter_Specification
      "#Defining_Identifier(Reverse_Present&Discrete_Subtype_Definition" &
      --  Modular_Type_Definition
      "%Expression" &
      --  Number_Declaration
      "#Defining_Identifier%Expression,More_Ids-Prev_Ids" &
      --  Ordinary_Fixed_Point_Definition
      "%Delta_Expression&Real_Range_Specification" &
      --  Others_Choice
      "#Others_Discrete_Choices" &
      --  Package_Specification
      "#Defining_Unit_Name$Visible_Declarations&Private_Declarations'Generic" &
         "_Parent" &
      --  Parameter_Association
      "$Selector_Name%Actual_Parameter&Next_Named_Actual" &
      --  Parameter_Specification
      "#Defining_Identifier(In_Present)Out_Present$Parameter_Type%Expression" &
         "*Do_Accessibility_Check,More_Ids-Prev_Ids" &
      --  Private_Extension_Declaration
      "#Defining_Identifier&Discriminant_Specifications*Has_Unknown_Discrimi" &
         "nants+Abstract_Present'Subtype_Indication" &
      --  Private_Type_Declaration
      "#Defining_Identifier&Discriminant_Specifications*Has_Unknown_Discrimi" &
         "nants+Abstract_Present(Tagged_Present)Limited_Present" &
      --  Protected_Body
      "#Defining_Identifier%Declarations" &
      --  Protected_Definition
      "$Visible_Declarations&Private_Declarations-Has_Priority_Pragma" &
      --  Protected_Type_Declaration
      "#Defining_Identifier&Discriminant_Specifications%Protected_Definition" &
      --  Range_Constraint
      "&Range_Expression" &
      --  Real_Range_Specification
      "#Low_Bound$High_Bound" &
      --  Record_Definition
      "+Abstract_Present(Tagged_Present)Limited_Present#Component_List*Null_" &
         "Present" &
      --  Selective_Accept
      "#Selective_Accept_Alternatives&Else_Statements" &
      --  Signed_Integer_Type_Definition
      "#Low_Bound$High_Bound" &
      --  Single_Protected_Declaration
      "#Defining_Identifier%Protected_Definition" &
      --  Subunit
      "$Name#Proper_Body" &
      --  Task_Definition
      "$Visible_Declarations&Private_Declarations-Has_Priority_Pragma,Has_St" &
         "orage_Size_Pragma" &
      --  Terminate_Alternative
      "'Condition" &
      --  Timed_Entry_Call
      "#Entry_Call_Alternative&Delay_Alternative" &
      --  Triggering_Alternative
      "#Triggering_Statement%Statements" &
      --  Use_Type_Clause
      "$Subtype_Marks" &
      --  Variant
      "&Discrete_Choices#Component_List$Enclosing_Variant" &
      --  Variant_Part
      "$Name#Variants" &
      --  With_Clause
      "$Name&Library_Unit'Corresponding_Spec,First_Name-Last_Name*Context_In" &
         "stalled+Elaborate_Present(Elaborate_All_Present)Implicit_With" &
      --  Unused_At_End
      "";

   type Pchar_Pos_Array is array (Node_Kind) of Positive;
   Pchar_Pos : constant Pchar_Pos_Array := Pchar_Pos_Array'(
      N_Unused_At_Start                        => 1,
      N_At_Clause                              => 1,
      N_Component_Clause                       => 23,
      N_Enumeration_Representation_Clause      => 66,
      N_Mod_Clause                             => 93,
      N_Record_Representation_Clause           => 104,
      N_Attribute_Definition_Clause            => 144,
      N_Empty                                  => 160,
      N_Error                                  => 160,
      N_Pragma                                 => 160,
      N_Pragma_Argument_Association            => 205,
      N_Defining_Character_Literal             => 216,
      N_Defining_Identifier                    => 260,
      N_Defining_Operator_Symbol               => 304,
      N_Expanded_Name                          => 348,
      N_Identifier                             => 407,
      N_Character_Literal                      => 463,
      N_Operator_Symbol                        => 524,
      N_Op_Add                                 => 573,
      N_Op_And                                 => 573,
      N_Op_And_Then                            => 589,
      N_Op_Concat                              => 589,
      N_Op_Divide                              => 589,
      N_Op_Eq                                  => 607,
      N_Op_Expon                               => 607,
      N_Op_Ge                                  => 607,
      N_Op_Gt                                  => 607,
      N_Op_In                                  => 607,
      N_Op_Le                                  => 607,
      N_Op_Lt                                  => 607,
      N_Op_Mod                                 => 607,
      N_Op_Multiply                            => 625,
      N_Op_Ne                                  => 625,
      N_Op_Not_In                              => 625,
      N_Op_Or                                  => 625,
      N_Op_Or_Else                             => 641,
      N_Op_Rem                                 => 641,
      N_Op_Subtract                            => 659,
      N_Op_Xor                                 => 659,
      N_Op_Rotate_Left                         => 675,
      N_Op_Rotate_Right                        => 675,
      N_Op_Shift_Left                          => 675,
      N_Op_Shift_Right                         => 675,
      N_Op_Shift_Right_Arithmetic              => 675,
      N_Op_Abs                                 => 675,
      N_Op_Minus                               => 675,
      N_Op_Not                                 => 675,
      N_Op_Plus                                => 675,
      N_Attribute_Reference                    => 675,
      N_Concat_Multiple                        => 732,
      N_Conditional_Expression                 => 744,
      N_Explicit_Dereference                   => 756,
      N_Extension_Aggregate                    => 779,
      N_Function_Call                          => 833,
      N_Indexed_Component                      => 935,
      N_Integer_Literal                        => 970,
      N_Null                                   => 995,
      N_Procedure_Call_Statement               => 995,
      N_Qualified_Expression                   => 1097,
      N_Range                                  => 1121,
      N_Real_Literal                           => 1142,
      N_Selected_Component                     => 1190,
      N_Type_Conversion                        => 1249,
      N_Unchecked_Type_Conversion              => 1320,
      N_Allocator                              => 1344,
      N_Aggregate                              => 1433,
      N_Expression_Actions                     => 1518,
      N_Reference                              => 1567,
      N_Slice                                  => 1604,
      N_String_Literal                         => 1672,
      N_Subtype_Indication                     => 1727,
      N_Component_Declaration                  => 1781,
      N_Entry_Body                             => 1895,
      N_Entry_Declaration                      => 2008,
      N_Formal_Object_Declaration              => 2111,
      N_Formal_Type_Declaration                => 2226,
      N_Freeze_Entity                          => 2335,
      N_Full_Type_Declaration                  => 2372,
      N_Incomplete_Type_Declaration            => 2466,
      N_Implicit_Types                         => 2570,
      N_Iteration_Scheme                       => 2582,
      N_Object_Declaration                     => 2651,
      N_Subtype_Declaration                    => 2781,
      N_Function_Specification                 => 2820,
      N_Procedure_Specification                => 2922,
      N_Accept_Statement                       => 3011,
      N_Abort_Statement                        => 3123,
      N_Assignment_Statement                   => 3129,
      N_Block_Statement                        => 3174,
      N_Case_Statement                         => 3287,
      N_Code_Statement                         => 3311,
      N_Delay_Relative_Statement               => 3322,
      N_Delay_Until_Statement                  => 3333,
      N_Entry_Call_Statement                   => 3344,
      N_Exit_Statement                         => 3412,
      N_Free_Statement                         => 3427,
      N_Goto_Statement                         => 3469,
      N_If_Statement                           => 3474,
      N_Loop_Statement                         => 3528,
      N_Null_Statement                         => 3590,
      N_Raise_Statement                        => 3590,
      N_Requeue_Statement                      => 3604,
      N_Return_Statement                       => 3623,
      N_Access_Function_Definition             => 3659,
      N_Access_Procedure_Definition            => 3715,
      N_Constrained_Array_Definition           => 3758,
      N_Unconstrained_Array_Definition         => 3822,
      N_Package_Body_Stub                      => 3871,
      N_Protected_Body_Stub                    => 3923,
      N_Subprogram_Body_Stub                   => 3975,
      N_Task_Body_Stub                         => 4021,
      N_Function_Instantiation                 => 4073,
      N_Package_Instantiation                  => 4130,
      N_Procedure_Instantiation                => 4187,
      N_Package_Body                           => 4244,
      N_Subprogram_Body                        => 4322,
      N_Implicit_Label_Declaration             => 4500,
      N_Package_Declaration                    => 4526,
      N_Single_Task_Declaration                => 4595,
      N_Subprogram_Declaration                 => 4631,
      N_Task_Body                              => 4676,
      N_Task_Type_Declaration                  => 4794,
      N_Use_Package_Clause                     => 4858,
      N_Generic_Package_Declaration            => 4864,
      N_Generic_Subprogram_Declaration         => 4961,
      N_Exception_Renaming_Declaration         => 5034,
      N_Object_Renaming_Declaration            => 5059,
      N_Package_Renaming_Declaration           => 5097,
      N_Subprogram_Renaming_Declaration        => 5133,
      N_Generic_Function_Renaming_Declaration  => 5183,
      N_Generic_Package_Renaming_Declaration   => 5219,
      N_Generic_Procedure_Renaming_Declaration => 5255,
      N_Abortable_Part                         => 5291,
      N_Abstract_Subprogram_Declaration        => 5302,
      N_Accept_Alternative                     => 5316,
      N_Access_Definition                      => 5354,
      N_Access_To_Object_Definition            => 5367,
      N_Asynchronous_Select                    => 5415,
      N_Case_Statement_Alternative             => 5453,
      N_Compilation_Unit                       => 5481,
      N_Component_Association                  => 5611,
      N_Component_List                         => 5630,
      N_Conditional_Entry_Call                 => 5679,
      N_Derived_Type_Definition                => 5718,
      N_Decimal_Fixed_Point_Definition         => 5776,
      N_Defining_Program_Unit_Name             => 5836,
      N_Delay_Alternative                      => 5861,
      N_Delta_Constraint                       => 5898,
      N_Designator                             => 5932,
      N_Digits_Constraint                      => 5948,
      N_Discriminant_Association               => 5983,
      N_Discriminant_Specification             => 6009,
      N_Elsif_Part                             => 6076,
      N_Enumeration_Type_Definition            => 6102,
      N_Entry_Body_Formal_Part                 => 6111,
      N_Entry_Call_Alternative                 => 6172,
      N_Entry_Index_Specification              => 6204,
      N_Exception_Declaration                  => 6252,
      N_Exception_Handler                      => 6290,
      N_Floating_Point_Definition              => 6336,
      N_Formal_Decimal_Fixed_Point_Definition  => 6379,
      N_Formal_Derived_Type_Definition         => 6379,
      N_Formal_Discrete_Type_Definition        => 6408,
      N_Formal_Floating_Point_Definition       => 6408,
      N_Formal_Modular_Type_Definition         => 6408,
      N_Formal_Ordinary_Fixed_Point_Definition => 6408,
      N_Formal_Package_Declaration             => 6408,
      N_Formal_Private_Type_Definition         => 6466,
      N_Formal_Signed_Integer_Type_Definition  => 6514,
      N_Formal_Subprogram_Declaration          => 6514,
      N_Generic_Association                    => 6553,
      N_Handled_Sequence_Of_Statements         => 6601,
      N_Index_Or_Discriminant_Constraint       => 6642,
      N_Label                                  => 6654,
      N_Loop_Parameter_Specification           => 6665,
      N_Modular_Type_Definition                => 6729,
      N_Number_Declaration                     => 6740,
      N_Ordinary_Fixed_Point_Definition        => 6789,
      N_Others_Choice                          => 6831,
      N_Package_Specification                  => 6855,
      N_Parameter_Association                  => 6931,
      N_Parameter_Specification                => 6980,
      N_Private_Extension_Declaration          => 7090,
      N_Private_Type_Declaration               => 7200,
      N_Protected_Body                         => 7322,
      N_Protected_Definition                   => 7355,
      N_Protected_Type_Declaration             => 7417,
      N_Range_Constraint                       => 7486,
      N_Real_Range_Specification               => 7503,
      N_Record_Definition                      => 7524,
      N_Selective_Accept                       => 7600,
      N_Signed_Integer_Type_Definition         => 7646,
      N_Single_Protected_Declaration           => 7667,
      N_Subunit                                => 7708,
      N_Task_Definition                        => 7725,
      N_Terminate_Alternative                  => 7811,
      N_Timed_Entry_Call                       => 7821,
      N_Triggering_Alternative                 => 7862,
      N_Use_Type_Clause                        => 7894,
      N_Variant                                => 7908,
      N_Variant_Part                           => 7958,
      N_With_Clause                            => 7972,
      N_Unused_At_End                          => 8102);

end Treeprs;
