.TH DPV 1
.SH NAME
dpv \- ditroff output previewer
.SH SYNOPSIS
.B dpv
[
.B \-d
]
[
.BI + page
]
.I file
.SH DESCRIPTION
.I Dpv
is a previewer for
.IR ditroff (1)
output.
There must be exactly one file argument, specifying a file produced by
ditroff.
The
.B \-d
option turns some debugging output on (if compiled in).
The
.BI + page
option selects the initial page to display (default 1).
.SH MENUS
There are two menus.
The
.B Control
menu contains commands to move around in the file, and a Quit command to
leave the program.
The
.B Print
menu contains commands to spool the file to various printers queues.
Some checks are made that the file is compatible with the printer.
.SH KEYBOARD CONTROL
The following characters typed at the keyboard are interpreted as commands.
A number
.I N
followed by a Carriage Return moves to page
.I N.
Carriage Return without preceding number moves one page forward.
`.' with preceding number is equivalent to Carriage Return;
without preceding number it redraws the current page.
`N' moves to the next page, `P' moves to the previous page.
A number
.I N
followed by `N' or `P' moves
.I N
pages forward or backward.
Up arrow and backspace are equivalent to `P';
`+', down arrow and space are equivalent to `N'.
`-' is a toggle: it jumps to the previous page that was shown.
`^' or `F' moves to the first page; `$' or `L' to the last.
`G' without preceding number also moves to the last page;
with a preceding number
.I N
it moves to page
.I N.
`Q' quits from the program.
Lower case letters are equivalent to their upper case counterparts.
.SH DIAGNOSTICS
Complaints about missing files, unknown fonts and what have you are
written to stderr.
.SH FILES
funnytab, /usr/local/lib/funnytab, /userfs3/amoeba/lib/funnytab
\- funny character translation table search path
.SH SEE ALSO
ditroff(1)
.SH AUTHOR
Guido van Rossum
.SH BUGS
May crash on malformed input (not generated by ditroff).
.br
Arcs and splines are replaced by straight lines (because I don't have
the necessary mathematics at hand), so output from
.IR pic (1)
or other graphics preprocessors may be unrecognizable.
.br
Doesn't know all funny characters.
Unknown characters are silently suppressed.
.br
Doesn't know all fonts, or all sizes.
Unknown fonts and sizes are replaced by known ones.
.br
The current X11 version uses Adobe bitmap fonts which don't match very
well with the width tables for the Harris.
.br
Character and line spacing are scaled, but it believes that it should
use characters in the point sizes specified in the input.
This may cause the output to look a bit cramped.
.br
It assumes page numbers always start at 1; it doesn't know about the
true page numbers (even though these are present in the ditroff output).
.br
There should be an argument to specify an alternate funny character
translation table file.
.br
The font translation table should be read from a file as well.
.br
If it can't find the funny character translation table file, it should
fall back on a reasonable default.
.br
The Print menu is very CWI-specific; it, too should be customizable
instead of being wired in.
.br
Errors in the input are handled ungracefully.
.br
STDWIN prints a warning to stderr for every font change if a font in the
translation table doesn't exist (e.g., if you are using the X11 Release
3 version of dpv with a Release 2 server, or vice versa; or if you have
botched your font directory or font path).  needless to say this can be
annoying.
