/*************************************/
/* Section 2.  Function declarations */
/*************************************/


extern void wargs _ARGS((int *pargc, char ***pargv));
extern void winit _ARGS((void));
extern void winitargs _ARGS((int *pargc, char ***pargv));
extern void wdone _ARGS((void));

extern void wgetscrsize _ARGS((int *pwidth, int *pheight));
extern void wgetscrmm _ARGS((int *pmmwidth, int *pmmheight));
extern int wgetmouseconfig _ARGS((void));

extern void wsetmaxwinsize _ARGS((int width, int height));
extern void wsetdefwinsize _ARGS((int width, int height));
extern void wgetdefwinsize _ARGS((int *pwidth, int *pheight));
extern void wsetdefwinpos _ARGS((int h, int v));
extern void wgetdefwinpos _ARGS((int *ph, int *pv));
extern void wsetdefscrollbars _ARGS((bool hbar, bool vbar));
extern void wgetdefscrollbars _ARGS((bool *phbar, bool *pvbar));

extern WINDOW *wopen _ARGS((char *title,
                void (*drawproc)(/*WINDOW *win,
                                int left, int top, int right, int bottom*/)));
extern void wclose _ARGS((WINDOW *win));
#define wgettag(win) (((_FAKEWINDOW *)(win)) -> tag)
#define wsettag(win, newtag) (((_FAKEWINDOW *)(win)) -> tag = (newtag))
extern void wsetactive _ARGS((WINDOW *win));
extern WINDOW *wgetactive _ARGS((void));
extern void wgetwinsize _ARGS((WINDOW *win, int *width, int *height));
extern void wgetwinpos _ARGS((WINDOW *win, int *h, int *v));
extern void wsetdocsize _ARGS((WINDOW *win, int width, int height));
extern void wgetdocsize _ARGS((WINDOW *win, int *width, int *height));
extern void wsettitle _ARGS((WINDOW *win, char *title));
extern char *wgettitle _ARGS((WINDOW *win)); /* Returns pointer to static data */

extern void wsetorigin _ARGS((WINDOW *win, int h, int v));
extern void wgetorigin _ARGS((WINDOW *win, int *h, int *v));
extern void wshow _ARGS((WINDOW *win, int left, int top, int right, int bottom));
extern void wchange _ARGS((WINDOW *win, int left, int top, int right, int bottom));
extern void wscroll _ARGS((WINDOW *win, int left, int top, int right, int bottom,
        int dh, int dv));

extern void wfleep _ARGS((void));
extern void wmessage _ARGS((char *str));
extern void wperror _ARGS((char *name));
extern bool waskstr _ARGS((char *prompt, char *buf, int buflen));
extern int waskync _ARGS((char *question, int dflt));
extern bool waskfile _ARGS((char *prompt, char *buf, int buflen, bool newfile));

extern void wsetcaret _ARGS((WINDOW *win, int h, int v));
extern void wnocaret _ARGS((WINDOW *win));

extern void wsettimer _ARGS((WINDOW *win, int deciseconds));

extern MENU *wmenucreate _ARGS((int id, char *title));
extern void wmenudelete _ARGS((MENU *mp));
extern int wmenuadditem _ARGS((MENU *mp, char *text, int shortcut));
extern void wmenusetitem _ARGS((MENU *mp, int i, char *text));
extern void wmenusetdeflocal _ARGS((bool localp));
extern void wmenuattach _ARGS((WINDOW *win, MENU *mp));
extern void wmenudetach _ARGS((WINDOW *win, MENU *mp));
extern void wmenuenable _ARGS((MENU *mp, int item, int flag));
extern void wmenucheck _ARGS((MENU *mp, int item, int flag));

/* The following is only available in termcap stdwin: */
extern void wsetshortcut _ARGS((int id, int item, char *keys));

extern void wgetevent _ARGS((EVENT *ep));
extern bool wpollevent _ARGS((EVENT *ep));
extern void wungetevent _ARGS((EVENT *ep));
extern void wupdate _ARGS((WINDOW *win));
extern void wbegindrawing _ARGS((WINDOW *win));
extern void wenddrawing _ARGS((WINDOW *win));
extern void wflush _ARGS((void));

extern void wdrawline _ARGS((int h1, int v1, int h2, int v2));
extern void wxorline _ARGS((int h1, int v1, int h2, int v2));

extern void wdrawbox _ARGS((int left, int top, int right, int bottom));
extern void wpaint _ARGS((int left, int top, int right, int bottom));
extern void winvert _ARGS((int left, int top, int right, int bottom));
extern void werase _ARGS((int left, int top, int right, int bottom));
extern void wshade _ARGS((int left, int top, int right, int bottom, int percent));

extern void wdrawcircle _ARGS((int h, int v, int radius));
extern void wfillcircle _ARGS((int h, int v, int radius));
extern void wxorcircle _ARGS((int h, int v, int radius));

extern void wdrawelarc _ARGS((int h, int v, int hrad, int vrad, int ang1, int ang2));
extern void wfillelarc _ARGS((int h, int v, int hrad, int vrad, int ang1, int ang2));
extern void wxorelarc _ARGS((int h, int v, int hrad, int vrad, int ang1, int ang2));

extern void wdrawpoly _ARGS((int n, POINT points[]));
extern void wfillpoly _ARGS((int n, POINT points[]));
extern void wxorpoly _ARGS((int n, POINT points[]));

extern void wcliprect _ARGS((int left, int top, int right, int bottom));
extern void wnoclip _ARGS((void));

extern void wdrawtext _ARGS((int h, int v, char *str, int len));
extern void wdrawchar _ARGS((int h, int v, int c));
extern int wlineheight _ARGS((void));
extern int wbaseline _ARGS((void));
extern int wtextwidth _ARGS((char *str, int len));
extern int wcharwidth _ARGS((int c));
extern int wtextbreak _ARGS((char *str, int len, int width));

extern void wgettextattr _ARGS((TEXTATTR *attr));
extern void wsettextattr _ARGS((TEXTATTR *attr));
extern void wgetwintextattr _ARGS((WINDOW *win, TEXTATTR *attr));
extern void wsetwintextattr _ARGS((WINDOW *win, TEXTATTR *attr));

extern void wsetplain _ARGS((void));
extern void wsethilite _ARGS((void));
extern void wsetinverse _ARGS((void));
extern void wsetitalic _ARGS((void));
extern void wsetbold _ARGS((void));
extern void wsetbolditalic _ARGS((void));
extern void wsetunderline _ARGS((void));

extern void wsetfont _ARGS((char *fontname));
extern void wsetsize _ARGS((int pointsize));

/* Colors */
extern COLOR wfetchcolor _ARGS((char *colorname));
extern void wsetfgcolor _ARGS((COLOR color));
extern COLOR wgetfgcolor _ARGS((void));
extern void wsetbgcolor _ARGS((COLOR color));
extern COLOR wgetbgcolor _ARGS((void));

/* Setting the mouse cursor for a window */
extern CURSOR *wfetchcursor _ARGS((char *name));
extern void wsetwincursor _ARGS((WINDOW *win, CURSOR *cursor));

/* X11 Selection interface */
extern bool wsetselection _ARGS((WINDOW *, int, char *, int));
extern void wresetselection _ARGS((int));
extern char *wgetselection _ARGS((int, int *));

/* Cut buffer interface */
extern void wsetcutbuffer _ARGS((int, char *, int));
extern char *wgetcutbuffer _ARGS((int, int *));
extern void wrotatecutbuffers _ARGS((int));
extern void wsetclip _ARGS((char *, int));
extern char *wgetclip _ARGS((void));

