#include "window.h"
#include "style.h"

extern int      vdi_handle ;

extern bool     mouseoff ;

extern WINDOW   *active ;
static WINDOW   *drawing = (WINDOW *) NULL ;

static TEXTATTR savetextattr ;

void    showcaret () ;
void    rmcaret () ;

static int      extrah ;
static int      extrav ;

static int      curr_interior = -1 ;
static int      curr_color = -1 ;
static int      curr_mode = -1 ;

void
wsetwintextattr (win, attr)
        WINDOW  *win ;
        TEXTATTR        *attr ;
{
        if (win == NULL) {
                wdebug ("wsetwintextattr: illegal window pointer") ;
                return ;
        }

        win->attr = *attr ;
}

void
wgetwintextattr (win, attr)
        WINDOW  *win ;
        TEXTATTR        *attr ;
{
        if (win == NULL) {
                wdebug ("wgetwintextattr: illegal window pointer") ;
                return ;
        }

        *attr = win->attr ;
}

void
wbegindrawing (win)
        WINDOW  *win ;
{
        int     left ;
        int     top ;
        int     right ;
        int     bottom ;
        int     dummy ;

        if (drawing != NULL)
                wenddrawing (drawing) ;

        rmcaret () ;

        drawing = win ;

        extrah = win->h - win->orgh ;
        extrav = win->v - win->orgv ;

        wgettextattr (&savetextattr) ;
        wsettextattr (&win->attr) ;

        if (!mouseoff) {
                int     status ;
                int     m_h ;
                int     m_v ;

                vq_mouse (vdi_handle, &status, &m_h, &m_v) ;

                if (m_h > win->h - wlineheight () &&
                    m_h < win->h + win->width + wlineheight () &&
                    m_v > win->v - 2 * wcharwidth ('m') &&
                    m_v < win->v + win->height + 2 * wcharwidth ('m')) {
                        mouseoff = TRUE ;
                        graf_mouse (M_OFF, &dummy) ;
                }
        }

        wind_update (BEG_UPDATE) ;

        left = win->orgh ;
        top = win->orgv ;
        right = left + win->width ;
        bottom = top + win->height ;

        setclip (win, 1, left, top, right, bottom) ;
}

void
wenddrawing (win)
        WINDOW  *win ;
{
        int     left ;
        int     top ;
        int     right ;
        int     bottom ;
        int     dummy = 0 ;

        if (drawing == NULL || drawing != win)
                return ;

        left = win->orgh ;
        top = win->orgv ;
        right = left + win->width ;
        bottom = top + win->height ;

        setclip (win, 0, left, top, right, bottom) ;

        wind_update (END_UPDATE) ;

        wsettextattr (&savetextattr) ;

        extrah = extrav = 0 ;

        drawing = (WINDOW *) NULL ;

        showcaret () ;
}

int
wdrawtext (h, v, str, len)
        int     h ;
        int     v ;
        char    *str ;
        int     len ;
{
        TEXTATTR        attr ;
        int     scr_h ;
        int     scr_v ;
        int     save ;
        int     str_len = (len != -1 ? len : strlen (str)) ;

        if (drawing == NULL) {
                wdebug ("wdrawtext outside draw procedure") ;
                return (h) ;
        }

        wgettextattr (&attr) ;

        if (curr_mode != 1) {
                vswr_mode (vdi_handle, 1) ;
                curr_mode = 1 ;
        }

        scr_h = h + extrah ;
        scr_v = v + extrav ;

        save = str[str_len] ;
        str[str_len] = 0 ;

        v_gtext (vdi_handle, scr_h, scr_v, str) ;

        str[str_len] = save ;

        if (attr.style & INVERSE) {
                int     left = h ;
                int     top = v ;
                int     right ;
                int     bottom ;

                right = h + wtextwidth (str, len) ;
                bottom = v + wlineheight () ;

                winvert (left, top, right, bottom) ;
        }

        return (h + wtextwidth (str, len)) ;
}

int
wdrawchar (h, v, c)
        int     h ;
        int     v ;
        int     c ;
{
        char    buf[2] ;

        buf[0] = c ;
        buf[1] = '\0' ;
        return (wdrawtext (h, v, buf, 1)) ;
}

void
wdrawline (beg_h, beg_v, end_h, end_v)
        int     beg_h ;
        int     beg_v ;
        int     end_h ;
        int     end_v ;
{
        int     line[4] ;

        if (drawing == NULL) {
                wdebug ("wdrawline called outside draw procedure") ;
                return ;
        }

        line[0] = beg_h + extrah ;
        line[1] = beg_v + extrav ;
        line[2] = end_h + extrah ;
        line[3] = end_v + extrav ;

        if (curr_mode != 1) {
                vswr_mode (vdi_handle, 1) ;
                curr_mode = 1 ;
        }

        v_pline (vdi_handle, 2, line) ;
}

void
wxorline (beg_h, beg_v, end_h, end_v)
        int     beg_h ;
        int     beg_v ;
        int     end_h ;
        int     end_v ;
{
        int     line[4] ;

        if (drawing == NULL) {
                wdebug ("wxorline called outside draw procedure") ;
                return ;
        }

        line[0] = beg_h + extrah ;
        line[1] = beg_v + extrav ;
        line[2] = end_h + extrah ;
        line[3] = end_v + extrav ;

        if (curr_mode != 3) {
                vswr_mode (vdi_handle, 3) ;
                curr_mode = 3 ;
        }

        v_pline (vdi_handle, 2, line) ;
}

void
wdrawbox (left, top, right, bottom)
        int     left ;
        int     top ;
        int     right ;
        int     bottom ;
{
        int     box[10] ;

        if (drawing == NULL) {
                wdebug ("wdrawbox called outside draw procedure") ;
                return ;
        }

        if (left >= right || top >= bottom)
                return ; /* Empty box */

        box[0] = box[6] = box[8] = left + extrah ;
        box[1] = box[3] = box[9] = top + extrav ;
        box[2] = box[4] = right + extrah - 1 ;
        box[5] = box[7] = bottom + extrav - 1 ;

        if (curr_mode != 1) {
                vswr_mode (vdi_handle, 1) ;
                curr_mode = 1 ;
        }

        v_pline (vdi_handle, 5, box) ;
}

void
wdrawcircle (h, v, radius)
        int     h ;
        int     v ;
        int     radius ;
{
        int     scr_h ;
        int     scr_v ;

        if (drawing == NULL) {
                wdebug ("wdrawline called outside draw procedure") ;
                return ;
        }

        scr_h = h + extrah ;
        scr_v = v + extrav ;

        if (curr_interior != 0) {
                vsf_interior (vdi_handle, 0) ;
                curr_interior = 0 ;
        }
        if (curr_color != 1) {
                vsf_color (vdi_handle, 1) ;
                curr_color = 1 ;
        }
        if (curr_mode != 1) {
                vswr_mode (vdi_handle, 1) ;
                curr_mode = 1 ;
        }

        v_circle (vdi_handle, scr_h, scr_v, radius) ;
}

void
werase (left, top, right, bottom)
        int     left ;
        int     top ;
        int     right ;
        int     bottom ;
{
        int     area[4] ;

/*      wdebug ("wer: l:%d, t:%d, r:%d, b:%d", left, top, right, bottom) ;
*/
        if (drawing == NULL) {
                wdebug ("werase called outside draw procedure") ;
                return ;
        }

        if (right <= left || bottom <= top)
                return ; /* Empty box */

        area[0] = left + extrah ;
        area[1] = top + extrav ;
        area[2] = right + extrah - 1 ;
        area[3] = bottom + extrav - 1 ;

        if (curr_interior != 1) {
                vsf_interior (vdi_handle, 1) ;
                curr_interior = 1 ;
        }
        if (curr_color != 0) {
                vsf_color (vdi_handle, 0) ;
                curr_color = 0 ;
        }
        if (curr_mode != 1) {
                vswr_mode (vdi_handle, 1) ;
                curr_mode = 1 ;
        }

        vr_recfl (vdi_handle, area) ;
}

void
wpaint (left, top, right, bottom)
        int     left ;
        int     top ;
        int     right ;
        int     bottom ;
{
        int     area[4] ;

        if (drawing == NULL) {
                wdebug ("wpaint called outside draw procedure") ;
                return ;
        }

        if (right <= left || bottom <= top)
                return ; /* Empty box */

        area[0] = left + extrah ;
        area[1] = top + extrav ;
        area[2] = right + extrah - 1 ;
        area[3] = bottom + extrav - 1 ;

        if (curr_interior != 1) {
                vsf_interior (vdi_handle, 1) ;
                curr_interior = 1 ;
        }
        if (curr_color != 1) {
                vsf_color (vdi_handle, 1) ;
                curr_color = 1 ;
        }
        if (curr_mode != 2) {
                vswr_mode (vdi_handle, 2) ;
                curr_mode = 2 ;
        }

        vr_recfl (vdi_handle, area) ;
}

void
wshade (left, top, right, bottom, perc)
        int     left ;
        int     top ;
        int     right ;
        int     bottom ;
        int     perc ;
{
        int     area[4] ;

        if (drawing == NULL) {
                wdebug ("wshade called outside draw procedure") ;
                return ;
        }

        if (right <= left || bottom <= top)
                return ; /* Empty box */

        area[0] = left + extrah ;
        area[1] = top + extrav ;
        area[2] = right + extrah - 1 ;
        area[3] = bottom + extrav - 1 ;

        if (curr_interior != 2) {
                vsf_interior (vdi_handle, 2) ;
                curr_interior = 2 ;
        }
        if (curr_color != 1) {
                vsf_color (vdi_handle, 1) ;
                curr_color = 1 ;
        }
        if (curr_mode != 2) {
                vswr_mode (vdi_handle, 2) ;
                curr_mode = 2 ;
        }
        vsf_style (vdi_handle, (perc * 10) / 125) ;

        vr_recfl (vdi_handle, area) ;
}

static void
invertrect (win, left, top, right, bottom)
        WINDOW  *win ;
        int     left ;
        int     top ;
        int     right ;
        int     bottom ;
{
        int     area[4] ;

        if (right <= left || bottom <= top)
                return ; /* Empty box */

        DOCTOSCR (win, left, top, area[0], area[1]) ;
        DOCTOSCR (win, right - 1, bottom - 1 , area[2], area[3]) ;

        if (curr_interior != 1) {
                vsf_interior (vdi_handle, 1) ;
                curr_interior = 1 ;
        }
        if (curr_color != 1) {
                vsf_color (vdi_handle, 1) ;
                curr_color = 1 ;
        }
        if (curr_mode != 3) {
                vswr_mode (vdi_handle, 3) ;
                curr_mode = 3 ;
        }

        vr_recfl (vdi_handle, area) ;
}

void
winvert (left, top, right, bottom)
        int     left ;
        int     top ;
        int     right ;
        int     bottom ;
{
        if (drawing == NULL) {
                wdebug ("winvert called outside draw procedure") ;
                return ;
        }

        invertrect (drawing, left, top, right, bottom) ;
}

/*
**      CARET HANDLING
**
**      The caret postion can be find in the structure members caret_h, caret_v.
**      These two contains (-1, -1) if the window doesn't have a caret, and the
**      structure member careton tells if the caret is currently drawn or not
*/

static void
drawcaret (win)
        WINDOW  *win ;
{
        int     dummy ;
        int     left ;
        int     top ;
        int     right ;
        int     bottom ;

        if (win->caret_h < 0 || win->caret_v < 0)
                return ;

        if (!graf_mouse (M_OFF, &dummy))
                wdebug ("drawcaret: mouse off") ;

        setclip (win, 1, win->orgh, win->orgv, win->orgh + win->width,
                                                win->orgv + win->height) ;
        left = win->caret_h ;
        top = win->caret_v ;
        right = win->caret_h + 1 ;
        bottom = win->caret_v + wlineheight () ;
        invertrect (win, left, top, right, bottom) ;

        setclip (win, 0, win->orgh, win->orgv, win->orgh + win->width,
                                                win->orgv + win->height) ;

        if (!graf_mouse (M_ON, &dummy))
                wdebug ("drawcaret: mouse on") ;
}

void
showcaret ()
{
        WINDOW  *win = active ;

        if (win == NULL)
                return ;

        if (win->caret_h < 0 || win->caret_v < 0)
                return ;

        if (!win->careton) {
                drawcaret (win) ;
                win->careton = TRUE ;
        }
}

void
rmcaret ()
{
        WINDOW  *win = active ;

        if (win == NULL)
                return ;

        if (win->careton) {
                drawcaret (win) ;
                win->careton = FALSE ;
        }
}

void
wsetcaret (win, h, v)
        WINDOW  *win ;
        int     h ;
        int     v ;
{
        if (win == active)
                rmcaret () ;

        win->caret_h = h ;
        win->caret_v = v ;

        if (win == active)
                showcaret () ;
}

void
wnocaret (win)
        WINDOW  *win ;
{
        if (win == active)
                rmcaret () ;

        win->caret_h = win->caret_v = -1 ;
}
