/*
	Routine sets up a text for information about the application.

	The text is copied to local memory to avoid problems with the user.
*/

#include "window.h"

char *w_about;
static char empty_string[] = "";

void
wsetabout(title,argc,argv)
char *title;
int argc;
char **argv;
{
	int i = 1, imax = 0, j, jmax, totnum, k;
	char **av = argv, *s, *ss, *t;
	int ac;
	TEDINFO *ted;
	OBJECT *o;

	if ( w_u_about != 0 ) return;	/* Too late. */

	if ( argc > 10 ) argc = 10;
	ac = argc;
	s = title;
	while ( *s++ ) i++;
	while ( --ac >= 0 ) {		/* Compute size of the combined strings */
		s = *av++;
		j = 0;
		while ( *s++ ) j++;
		if ( j > imax ) imax = j;
		i += j + 1;
	}
	if ( imax > 30 ) imax = 30;
	imax += 6;		/* Margins */
	imax *= 8;		/* Number of pixels */
	jmax = argc*20 + 50;
	j = 8;
/*
	We need now i + argc*sizeof(TEDINFO) + (argc+3)*sizeof(OBJECT) bytes
*/
	totnum = i + argc*sizeof(TEDINFO) + (argc+3)*sizeof(OBJECT);
	w_u_about = (OBJECT *)malloc(totnum);
	if ( w_u_about == 0 ) return;
	ted = (TEDINFO *)(w_u_about + (argc + 3));
	ss = (char *)(ted+argc);

	w_about = ss;
	s = title;
	while ( ( *ss++ = *s++ ) != 0 );

	o = w_u_about;
/*
	Fill the root object
*/
	o->ob_next   = -1;
	o->ob_head   =
	o->ob_tail   = 1;
	o->ob_type   = G_BOX;
	o->ob_flags  = NONE;
	o->ob_state  = OUTLINED;
	o->ob_spec.obspec.character   = 0;
	o->ob_spec.obspec.framesize   = 2;
	o->ob_spec.obspec.framecol    = 1;
	o->ob_spec.obspec.textcol     = 1;
	o->ob_spec.obspec.textmode    = 0;
	o->ob_spec.obspec.fillpattern = 0;
	o->ob_spec.obspec.interiorcol = 0;
	o->ob_x      = 0;
	o->ob_y      = 0;
	o->ob_width  = imax;
	o->ob_height = jmax;

	o++;
	o->ob_next   = 0;
	o->ob_head   = 2;
	o->ob_tail   = argc+2;
	o->ob_type   = G_IBOX;
	o->ob_flags  = NONE;
	o->ob_state  = OUTLINED;
	o->ob_spec.obspec.character   = 0;
	o->ob_spec.obspec.framesize   = 1;
	o->ob_spec.obspec.framecol    = 1;
	o->ob_spec.obspec.textcol     = 1;
	o->ob_spec.obspec.textmode    = 0;
	o->ob_spec.obspec.fillpattern = 0;
	o->ob_spec.obspec.interiorcol = 0;
	o->ob_x      = 0;
	o->ob_y      = 0;
	o->ob_width  = imax;
	o->ob_height = jmax;

	for ( ac = 0; ac < argc; ac++ ) {
		s = *argv++;

		o++;
		o->ob_next   = ac+3;
		o->ob_head   = -1;
		o->ob_tail   = -1;
		o->ob_type   = G_TEXT;
		o->ob_flags  = NONE;
		o->ob_state  = NORMAL;
		o->ob_spec.tedinfo = ted;
		o->ob_x      = 0;
		o->ob_y      = j;
		o->ob_width  = imax;
		o->ob_height = 16;
		j += 20;
        ted->te_ptext = t = ss;

		k = 30;
		while ( --k >= 0 && ( *t = *s ) != 0 ) { t++; s++; };
		while ( *s++ );
		*t++ = 0;

        ted->te_ptmplt = empty_string;
        ted->te_pvalid = empty_string;
        ted->te_font = 3;				/* font */
        ted->te_junk1 = 6;				/* junk int */
        ted->te_just = 2;				/* justification */
        ted->te_color = 0x1180;			/* color information */
        ted->te_junk2 = 0;				/* junk int */
        ted->te_thickness = -1;			/* border thickness */
        ted->te_txtlen = t - ss - 1;	/* text string length */
        ted->te_tmplen = 0;				/* template string length */
		ss = t;
		ted++;
	}

	j += 10;
	o++;
	o->ob_next   = 1;
	o->ob_head   = -1;
	o->ob_tail   = -1;
	o->ob_type   = G_BUTTON;
	o->ob_flags  = LASTOB | EXIT | DEFAULT | SELECTABLE;
	o->ob_state  = NORMAL;
	o->ob_spec.free_string = " Ok ";
	o->ob_x      = (imax - 32) >> 1;
	o->ob_y      = j;
	o->ob_width  = 32;
	o->ob_height = 16;
}
