/* Some defines to make x-window data structures palatable. */

/* Copyright (C) 1988, 1990, 1992  Free Software Foundation, Inc.

   This file is part of GNU Finger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


/* Define a button with NAME that calls FUNCTION, and has LABEL displayed
   as the text.

   Here is a sample:

   DEFBUTTON (quit_button, "Quit", Quit);
   ....
   ...
   void
   Quit ()
   {
     exit (0);
   }

   Note that FUNCTION should be declared as "void". */

typedef struct {
  char *widget_label;
  XtCallbackRec callback[4];
  int arglen;
  Arg args[2];
} BUTTON;

#define DEFBUTTON(label, name, func) \
void func ();\
BUTTON name = {\
  label,\
  { { func, NULL }, { NULL, NULL } },\
  2,\
  { { XtNcallback, (XtArgVal)&name.callback[0] },\
    { XtNlabel, (XtArgVal)label } }\
}

#define BUTTON_LABEL(button) ((button).args[1].value)

#define SET_BUTTON_LABEL(button, label) \
  (BUTTON_LABEL(button) = (XtArgVal)(label))
