#ifndef _IBCS_UNISTD_H
#define _IBCS_UNISTD_H

/*
 * This file contains the system call numbers and the syscallX
 * macros
 */

#define __IBCS_setup		    0	/* used only by init.S */
#define __IBCS_exit		    1
#define __IBCS_fork		    2
#define __IBCS_read		    3
#define __IBCS_write		    4
#define __IBCS_open		    5
#define __IBCS_close		    6
#define __IBCS_wait		    7
#define __IBCS_waitpid		    7
#define __IBCS_creat		    8
#define __IBCS_link		    9
#define __IBCS_unlink		   10
#define __IBCS_exec		   11
#define __IBCS_chdir		   12
#define __IBCS_time		   13
#define __IBCS_mknod		   14
#define __IBCS_chmod		   15
#define __IBCS_chown		   16
#define __IBCS_brk		   17
#define __IBCS_stat		   18
#define __IBCS_lseek		   19
#define __IBCS_getpid		   20
#define __IBCS_getppid		   20
#define __IBCS_mount		   21
#define __IBCS_umount		   22
#define __IBCS_setuid		   23
#define __IBCS_geteuid		   24
#define __IBCS_getuid		   24
#define __IBCS_stime		   25
#define __IBCS_ptrace		   26
#define __IBCS_alarm		   27
#define __IBCS_fstat		   28
#define __IBCS_pause		   29
#define __IBCS_utime		   30
#define __IBCS_stty		   31
#define __IBCS_gtty		   32
#define __IBCS_access		   33
#define __IBCS_nice		   34
#define __IBCS_statfs		   35
#define __IBCS_sync		   36
#define __IBCS_kill		   37
#define __IBCS_fstatfs		   38
#define __IBCS_setpgid		   39
#define __IBCS_getpgrp		   39
#define __IBCS_setpgrp		   39
#define __IBCS_setsid		   39
#define __IBCS_dup		   41
#define __IBCS_pipe		   42
#define __IBCS_times		   43
#define __IBCS_profil		   44
#define __IBCS_plock		   45
#define __IBCS_setgid		   46
#define __IBCS_getgid		   47
#define __IBCS_getegid		   47
#define __IBCS_signal		   48
#define __IBCS_sighold		   48
#define __IBCS_sigignore	   48
#define __IBCS_sigpause		   48
#define __IBCS_sigrelse		   48
#define __IBCS_sigset		   48
#define __IBCS_msgctl		   49
#define __IBCS_sysi86		   50
#define __IBCS_acct		   51
#define __IBCS_shmctl		   52
#define __IBCS_shmat		   52
#define __IBCS_shmdt		   52
#define __IBCS_shmget		   52
#define __IBCS_semctl		   53
#define __IBCS_ioctl		   54
#define __IBCS_uadmin		   55

#define __IBCS_uname		   57
#define __IBCS_ustat		   57

#define __IBCS_fsync		   58 /* Defined in SVr4, but not in iBCS2 */

#define __IBCS_execve		   59
#define __IBCS_umask		   60
#define __IBCS_chroot		   61
#define __IBCS_fcntl		   62
#define __IBCS_ulimit		   63

#define __IBCS_rmdir		   79
#define __IBCS_mkdir		   80
#define __IBCS_getdents		   81

#define __IBCS_sysfs		   84
#define __IBCS_getmsg		   85
#define __IBCS_putmsg		   86
#define __IBCS_poll		   87

#ifndef ELF_LIBRARY
#define __IBCS_fpathconf	12072
#define __IBCS_getgroups	11048
#define __IBCS_pathconf		11816
#define __IBCS_rename		12328
#define __IBCS_setgroups	11304
#define __IBCS_sigaction	10024
#define __IBCS_sigpending	10536
#define __IBCS_sigprocmask	10280
#define __IBCS_sigsuspend	10792
#define __IBCS_sysconf		11560
#endif

/* These are extensions found on SVr4 */
#ifdef ELF_LIBRARY
#define __IBCS_lstat  88 
#define __IBCS_symlink  89 
#define __IBCS_readlink  90 
#define __IBCS_setgroups  91  
#define __IBCS_getgroups  92  
#define __IBCS_fchmod  93 
#define __IBCS_fchown  94 
#define __IBCS_sigprocmask  95 
#define __IBCS_sigsuspend  96  
#define __IBCS_sigaltstack  97 
#define __IBCS_sigaction  98 
#define __IBCS_sigpending  99 
#define __IBCS_context  100 
#define __IBCS_evsys  101 
#define __IBCS_evtrapret  102 
#define __IBCS_statvfs  103 
#define __IBCS_fstatvfs  104 
#define __IBCS_nfssys  106 
#define __IBCS_waitsys  107 
#define __IBCS_sigsendsys  108 
#define __IBCS_hrtsys  109 
#define __IBCS_acancel  110 
#define __IBCS_async  111 
#define __IBCS_priocntlsys  112 
#define __IBCS_pathconf  113 
#define __IBCS_mincore  114 
#define __IBCS_mmap  115 
#define __IBCS_mprotect  116 
#define __IBCS_munmap  117 
#define __IBCS_fpathconf  118 
#define __IBCS_vfork  119 
#define __IBCS_fchdir  120 
#define __IBCS_readv  121 
#define __IBCS_writev  122 
#define __IBCS_xstat  123 
#define __IBCS_lxstat  124 
#define __IBCS_fxstat  125 
#define __IBCS_xmknod  126 
#define __IBCS_clocal  127 
#define __IBCS_setrlimit  128 
#define __IBCS_getrlimit  129 
#define __IBCS_lchown  130 
#define __IBCS_memcntl  131 
#define __IBCS_getpmsg  132 
#define __IBCS_putpmsg  133 
#define __IBCS_rename  134
#define __IBCS_nuname  135 
#define __IBCS_setegid  136 
#define __IBCS_sysconfig  137 
#define __IBCS_adjtime  138 
#define __IBCS_systeminfo  139 
#define __IBCS_seteuid  141 

/* The following are not iBCS2 compliant, but allow us to tap into
   the socket functions that Wyse TCP uses. */

#define WYSE_TCP_SYSCALL(X) 0x##X##fe

#define __IBCS_socket		WYSE_TCP_SYSCALL(1)
#define __IBCS_connect		WYSE_TCP_SYSCALL(2)
#define __IBCS_accept		WYSE_TCP_SYSCALL(3)
#define __IBCS_send		WYSE_TCP_SYSCALL(4)
#define __IBCS_recv		WYSE_TCP_SYSCALL(5)
#define __IBCS_bind		WYSE_TCP_SYSCALL(6)
#define __IBCS_setsockopt	WYSE_TCP_SYSCALL(7)
#define __IBCS_listen		WYSE_TCP_SYSCALL(8)
#define __IBCS_recvmsg		WYSE_TCP_SYSCALL(9)
#define __IBCS_sendmsg		WYSE_TCP_SYSCALL(a)
#define __IBCS_getsockopt	WYSE_TCP_SYSCALL(b)
#define __IBCS_recvfrom		WYSE_TCP_SYSCALL(c)
#define __IBCS_sendto		WYSE_TCP_SYSCALL(d)
#define __IBCS_shutdown		WYSE_TCP_SYSCALL(e)
#define __IBCS_socketpair	WYSE_TCP_SYSCALL(f)
#define __IBCS_trace		WYSE_TCP_SYSCALL(10)
#define __IBCS_getpeername	WYSE_TCP_SYSCALL(11)
#define __IBCS_getsockname	WYSE_TCP_SYSCALL(12)

#endif

/* XXX - _foo needs to be __foo, while __IBCS_bar could be _NR_bar. */
/* WARNING - THESE ONLY WORK WITH -fomit-frame-pointer */

#define _syscall0(type,name) \
type name(void) \
{ \
long __res; \
extern int errno; \
__asm__ volatile (".byte 0x9a, 0, 0, 0, 0, 7, 0\n" \
		  "\tjc 1f\n\txorl %%eax,%%eax\n" \
		  "\tjmp 2f\n" \
		  "1:\n" \
		  "\tmovl %%eax,_errno\n" \
		  "\tmovl $-1,%%eax\n" \
		  "2:\n" \
	: "=a" (__res) \
	: "0" (__IBCS_##name)); \
return __res; \
}

#define _syscall1(type,name,atype,a) \
type name(atype a) \
{ \
long __res; \
extern int errno; \
__asm__ volatile (".byte 0x9a, 0, 0, 0, 0, 7, 0\n" \
		  "\tjc 1f\n\txorl %%eax,%%eax\n" \
		  "\tjmp 2f\n" \
		  "1:\n" \
		  "\tmovl %%eax,_errno\n" \
		  "\tmovl $-1,%%eax\n" \
		  "2:\n" \
	: "=a" (__res) \
	: "0" (__IBCS_##name)); \
return __res; \
}

#define _syscall2(type,name,atype,a,btype,b) \
type name(atype a,btype b) \
{ \
long __res; \
extern int errno; \
__asm__ volatile (".byte 0x9a, 0, 0, 0, 0, 7, 0\n" \
		  "\tjc 1f\n\txorl %%eax,%%eax\n" \
		  "\tjmp 2f\n" \
		  "1:\n" \
		  "\tmovl %%eax,_errno\n" \
		  "\tmovl $-1,%%eax\n" \
		  "2:\n" \
	: "=a" (__res) \
	: "0" (__IBCS_##name)); \
return __res; \
}

#define _syscall3(type,name,atype,a,btype,b,ctype,c) \
type name(atype a,btype b,ctype c) \
{ \
long __res; \
extern int errno; \
__asm__ volatile (".byte 0x9a, 0, 0, 0, 0, 7, 0\n" \
		  "\tjc 1f\n\txorl %%eax,%%eax\n" \
		  "\tjmp 2f\n" \
		  "1:\n" \
		  "\tmovl %%eax,_errno\n" \
		  "\tmovl $-1,%%eax\n" \
		  "2:\n" \
	: "=a" (__res) \
	: "0" (__IBCS_##name)); \
return __res; \
}

#endif /* _LINUX_UNISTD_H */
