/*
 *	SVRDEFS.H  --   this C header file contains definitions required
 *			by the server side of the POP2 protocol handler.
 *
 *      (C) Copyright 1991 Regents of the University of California
 *
 *      Permission to use, copy, modify, and distribute this program
 *      for any purpose and without fee is hereby granted, provided
 *      that this copyright and permission notice appear on all copies
 *      and supporting documentation, the name of University of California
 *      not be used in advertising or publicity pertaining to distribution
 *      of the program without specific prior permission, and notice be
 *      given in supporting documentation that copying and distribution is
 *      by permission of the University of California.
 *      The University of California makes no representations about
 *      the suitability of this software for any purpose.  It is provided
 *      "as is" without express or implied warranty.
 *
 *	REVISIONS:
 *			12-87	[ks]	original implementation
 *		1.000	 5-88	[ks]
 *		1.001	 2-89	[ks]
 *
 */

#define SVR_LSTN_STATE		0x00		/* Possible POP2server states */
#define SVR_AUTH_STATE		0x01
#define SVR_MBOX_STATE		0x02
#define SVR_ITEM_STATE		0x03
#define SVR_NEXT_STATE		0x04
#define SVR_DONE_STATE		0x05
#define SVR_MAXSTATES		0x06

#define SVR_OPEN_INPUT		0x00		/* Possible server inputs */
#define SVR_HOST_INPUT		0x01
#define SVR_HELO_INPUT		0x02
#define SVR_FOLD_INPUT		0x03
#define SVR_READ_INPUT		0x04
#define SVR_RETR_INPUT		0x05
#define SVR_ACKS_INPUT		0x06
#define SVR_ACKD_INPUT		0x07
#define SVR_NACK_INPUT		0x08
#define SVR_QUIT_INPUT		0x09
#define SVR_UNKN_INPUT		0x0a
#define SVR_MAXVERBS		0x0b

#define SVR_GARB_ACTION		0x00		/* Possible server responses */
#define SVR_GREE_ACTION		0x01
#define SVR_AUTH_ACTION		0x02
#define SVR_BBYE_ACTION		0x03
#define SVR_MCNT_ACTION		0x04
#define SVR_BCNT_ACTION		0x05
#define SVR_DATA_ACTION		0x06
#define SVR_AKNK_ACTION		0x07
#define SVR_CLOS_ACTION		0x08
#define SVR_HOST_ACTION		0x09


						/* Directory prefixes */
#define DEF_OS_POP2DIR		"/usr/spool/pop"
#define DEF_OS_MAILDIR 		"/usr/spool/mail"
#define TMPFILE			"/tmp/pop2XXXXXX"
#define DEF_DIR_DELIM		"/"

#define DEF_MSGDELIM		"From "		/* UNIX msg delimiter line */
#define DEF_F_POP2		"X-Pop2-Rcpt:"	/* An RFC822 message header */ 

#define DEF_MSG_HOLD		16		/* MOD for array alloc */

#define STAT_DELETED		0x01		/* Status bit for msg delete */

#define CMD_BUFSIZ		1024		/* 1K data buffers */
#define POP2_BUFSIZ		998		/* 1000 chars including CRLF */

#define SVR_SEND_TIMEOUT	120
#define SVR_TIMEOUT_BASE	120		/* #secs to wait for client */
						/*   command before timeout */
						/*   (POP2 T2 timer)        */

	/* Constants for fseek() */
#define FSEEK_BEGIN		0x00		/* Relative to start of file */
#define FSEEK_CURRENT		0x01		/* Rel to current position */
#define FSEEK_END		0x02		/* Relative to end of file */
