------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              E X P _ C H 5                               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.38 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Atree;    use Atree;
with Einfo;    use Einfo;
with Exp_Ch4;  use Exp_Ch4;
with Exp_Ch7;  use Exp_Ch7;
with Exp_Ch9;  use Exp_Ch9;
with Exp_Util; use Exp_Util;
with Nlists;   use Nlists;
with Nmake;    use Nmake;
with Rtsfind;  use Rtsfind;
with Sinfo;    use Sinfo;
with Sem;      use Sem;
with Sem_Res;  use Sem_Res;
with Sem_Util; use Sem_Util;
with Snames;   use Snames;
with Stand;    use Stand;
with Tbuild;   use Tbuild;
with Ttypes;   use Ttypes;
with Uintp;    use Uintp;
with Urealp;   use Urealp;

package body Exp_Ch5 is

   -----------------------------------
   -- Expand_N_Assignment_Statement --
   -----------------------------------

   --  For tagged types, create a record type C with a size equivalent to the
   --  the one of the type to be copied. If the target is class wide (i.e.
   --  dynamically tagged) the construction of this type involves a dispatch
   --  call to the size attribute. Only the last field of this record will be
   --  copied in order to avoid copying the tag and the finalization chain
   --  pointers which are not technically part of the value).
   --  For fixed point types, with a real literal node as expression, this
   --  literal is converted into the corresponding integer value and an
   --  unchecked type conversion is made into the expected fixed point type.

   procedure Expand_N_Assignment_Statement (N : Node_Id) is
      Loc : constant Source_Ptr := Sloc (N);
      Lhs : constant Node_Id    := Name (N);
      Rhs : constant Node_Id    := Expression (N);
      Typ : constant Entity_Id  := Underlying_Type (Etype (Lhs));

      Node     : Node_Id;
      L_Entity : Entity_Id;
      R_Entity : Entity_Id;
      L        : List_Id;

   begin

      --  Generate the code:

      --  (lines marked <CTRL> only concern controlled types)
      --
      --    <Evaluation of rhs and lhs>
      --    Finalize (lhs);                                        <CTRL>
      --
      --    <if Lhs is class-wide and Tag_Checks are on>
      --        if Lhs._Tag /= Rhs._Tag then
      --           raise constraint_Error;
      --        end if;
      --
      --    <tagged_copy> (Lhs, Rhs);
      --    Adjust (lhs);                                          <CTRL>

      if Is_Tagged_Type (Typ) then
         Prepare_Multi_Use_Of_Expr (Rhs, R_Entity, L);

         if Present (L) then
            Insert_List_Before_And_Analyze (N, L);
         end if;

         Prepare_Multi_Use_Of_Expr (Lhs, L_Entity, L);

         if Present (L) then
            Insert_List_Before_And_Analyze (N, L);
         end if;

         Replace_Substitute_Tree (N,
           Make_Tagged_Copy (Loc, L_Entity, R_Entity, Typ));

         --  generate tag equality check for class-wide targets

         if Is_Class_Wide_Type (Typ)
           and then (not Tag_Checks_Suppressed (Typ))
         then

            --  <if lhs is class-wide and Tag_Checks are on>
            --      if lhs._tag /= rhs._Tag then
            --         raise constraint_Error;
            --      end if;

            Node :=
              Make_If_Statement (Loc,
                Condition =>
                  Make_Op_Ne (Loc,
                    Left_Opnd =>
                      Make_Selected_Component (Loc,
                        Prefix => New_Ref_To_Expr (L_Entity, Loc),
                        Selector_Name => Make_Identifier (Loc, Name_uTag)),
                    Right_Opnd =>
                      Make_Selected_Component (Loc,
                        Prefix => New_Ref_To_Expr (R_Entity, Loc),
                        Selector_Name => Make_Identifier (Loc, Name_uTag))),
                Then_Statements => New_List (New_Constraint_Error (Loc)));

            Insert_Before (N, Node);
            Analyze (Node);
         end if;

         if Is_Controlled (Typ) then
            Node := Make_Finalize_Call (New_Ref_To_Expr (L_Entity, Loc), Typ);
            Insert_Before (N, Node);
            Analyze (Node);
            Insert_After (N,
              Make_Adjust_Call (New_Ref_To_Expr (L_Entity, Loc), Typ));
         end if;

         Analyze (N);
      end if;

      if Is_Fixed_Point_Type (Typ) then
         Expand_Literal_To_Fixed (Rhs, Typ);
      end if;

   end Expand_N_Assignment_Statement;

   -----------------------------
   -- Expand_N_Case_Statement --
   -----------------------------

   --  If the last alternative is not an Others choice replace it with an
   --  N_Others_Choice. Note that we do not bother to call Analyze on the
   --  modified case statement, since it's only effect would be to compute
   --  the contents of the Others_Discrete_Choices node laboriously, and of
   --  course we already know the list of choices that corresponds to the
   --  others choice (it's the list we are replacing!)

   procedure Expand_N_Case_Statement (N : Node_Id) is
      Altnode     : constant Node_Id := Last (Alternatives (N));
      Others_Node : Node_Id;

   begin
      if Nkind (First (Discrete_Choices (Altnode))) /= N_Others_Choice then
         Others_Node := Make_Others_Choice (Sloc (Altnode));
         Set_Others_Discrete_Choices
           (Others_Node, Discrete_Choices (Altnode));
         Set_Discrete_Choices (Altnode, New_List (Others_Node));
      end if;
   end Expand_N_Case_Statement;

end Exp_Ch5;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.36
--  date: Thu Aug 18 16:26:06 1994;  author: comar
--  (Expand_N_Assignment_Statement): Use Prepare_Multi_Use_Of_Expr /
--   New_Ref_To_Expr instead of Evaluate_Once which was not appropriate.
--   fix bug reported by jam@@rubens.jeol.com (finalization problem) on July 29
--  ----------------------------
--  revision 1.37
--  date: Thu Aug 18 20:08:46 1994;  author: dewar
--  Minor reformatting
--  ----------------------------
--  revision 1.38
--  date: Fri Aug 26 22:29:53 1994;  author: comar
--  (Expand_N_Assignment_Statement): Use underlying type so that private types
--   with happen to be hiddenly tagged or/and controlled are dealt with
--   properly
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
