/*
 * @(#)io.c	1.5 91/09/05
 */

#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/uio.h>

#include "defs.h"

int
sys_read(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%u, ", tcp->u_args[0]);
	} else {
		if (syserror(tcp))
			fprintf(outf, "%#x", tcp->u_args[1]);
		else
			printstr(tcp->pid, tcp->u_args[1], tcp->u_rval);
		fprintf(outf, ", %u", tcp->u_args[2]);
	}
	return 0;
}

int
sys_write(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		fprintf(outf, "%u, ", tcp->u_args[0]);
		printstr(tcp->pid, tcp->u_args[1], tcp->u_args[2]);
		fprintf(outf, ", %u", tcp->u_args[2]);
	}
	return 0;
}

#ifndef linux
int
sys_readv(tcp)
struct tcb *tcp;
{
	struct iovec *iov;
	int i, len;

	if (entering(tcp)) {
		fprintf(outf, "%u, ", tcp->u_args[0]);
	} else {
		if (syserror(tcp)) {
			fprintf(outf, "%#x, %u",
					tcp->u_args[1], tcp->u_args[2]);
			return 0;
		}
		len = tcp->u_args[2];
		if ((iov = (struct iovec *)malloc(len * sizeof *iov)) == NULL) {
			fprintf(stderr, "No memory");
			return 0;
		}
		if (umove(tcp->pid, tcp->u_args[1],
				len * sizeof *iov, (char *)iov) < 0) {
			fprintf(outf, "%#x", tcp->u_args[1]);
		} else {
			for (i = 0; i < len; i++) {
				printstr(tcp->pid, iov[i].iov_base,
							iov[i].iov_len);
			}
		}
		free((char *)iov);
		fprintf(outf, ", %u", tcp->u_args[2]);
	}
	return 0;
}

int
sys_writev(tcp)
struct tcb *tcp;
{
	struct iovec *iov;
	int i, len;

	if (entering(tcp)) {
		fprintf(outf, "%u, ", tcp->u_args[0]);
		len = tcp->u_args[2];
		if ((iov = (struct iovec *)malloc(len * sizeof *iov)) == NULL) {
			fprintf(stderr, "No memory");
			return 0;
		}
		if (umove(tcp->pid, tcp->u_args[1],
				len * sizeof *iov, (char *)iov) < 0) {
			fprintf(outf, "%#x", tcp->u_args[1]);
		} else {
			for (i = 0; i < len; i++) {
				printstr(tcp->pid, iov[i].iov_base,
							iov[i].iov_len);
			}
		}
		free((char *)iov);
		fprintf(outf, ", %u", tcp->u_args[2]);
	}
	return 0;
}
#endif

int
sys_ioctl(tcp)
struct tcb *tcp;
{
	char *symbol, *ioctl_lookup();
	int ioctl_decode();

	if (entering(tcp)) {
		fprintf(outf, "%u, ", tcp->u_args[0]);
		symbol = ioctl_lookup(tcp->u_args[1]);
		if (symbol)
			fprintf(outf, "%s, ", symbol);
		else
			fprintf(outf, "%#x, ", tcp->u_args[1]);

	}
	else {
		if (ioctl_decode(tcp, tcp->u_args[1], tcp->u_args[2]) == 0)
			fprintf(outf, "%#x", tcp->u_args[2]);
	}
	return 0;
}
