#include <stdio.h>
#include <sys/types.h>
#include <termios.h>
#include "defs.h"

static Xlat tcxonc_options[] = {
	TCOOFF,		"TCOOFF",
	TCOON,		"TCOON",
	TCIOFF,		"TCIOFF",
	TCION,		"TCION",
	0,		NULL,
};

static Xlat tcflsh_options[] = {
	TCIFLUSH,	"TCIFLUSH",
	TCOFLUSH,	"TCOFLUSH",
	TCIOFLUSH, 	"TCIOFLUSH",
	0,		NULL,
};

int
term_ioctl(tcp, code, arg)
struct tcb *tcp;
unsigned code, arg;
{
	struct termios tios;
	struct termio tio;
	struct winsize ws;
	int val;

	switch (code) {
	case TCGETS:
		if (syserror(tcp))
			return 0;
	case TCSETS:
	case TCSETSW:
	case TCSETSF:
		if (umove(tcp->pid, (char *) arg,
		    sizeof (struct termios), (char *) &tios) < 0)
			return 0;
		fprintf(outf, "{i %#x o %#x c %#x l %#x ld %#x",
			tios.c_iflag, tios.c_oflag, tios.c_cflag, tios.c_lflag,
			tios.c_line);
		if (!(tios.c_lflag & ICANON))
			fprintf(outf, " min %d time %d",
				tios.c_cc[VMIN], tios.c_cc[VTIME]);
		fprintf(outf, " ...");
		fprintf(outf, "}");
		return 1;
	case TCGETA:
		if (syserror(tcp))
			return 0;
	case TCSETA:
	case TCSETAW:
	case TCSETAF:
		if (umove(tcp->pid, arg, sizeof (struct termio), (char *) &tio) < 0)
			return 0;
		fprintf(outf, "{i %#x o %#x c %#x l %#x ld %#x",
			tio.c_iflag, tio.c_oflag, tio.c_cflag, tio.c_lflag,
			tio.c_line);
		if (!(tio.c_lflag & ICANON))
			fprintf(outf, " min %d time %d",
				tio.c_cc[VMIN], tio.c_cc[VTIME]);
		fprintf(outf, " ...");
		fprintf(outf, "}");
		return 1;
	case TCXONC:
		printxval(tcxonc_options, arg, "TC???");
		return 1;
	case TCFLSH:
		printxval(tcflsh_options, arg, "TC???");
		return 1;
	case TIOCGWINSZ:
		if (syserror(tcp))
			return 0;
	case TIOCSWINSZ:
		if (umove(tcp->pid, arg, sizeof (struct winsize), (char *) &ws) < 0)
			return 0;
		fprintf(outf, "{row %d col %d xpixel %d ypixel %d}",
			ws.ws_row, ws.ws_col, ws.ws_xpixel, ws.ws_ypixel);
		return 1;
	case TIOCSPGRP:
	case TIOCGPGRP:
	case TIOCINQ:
	case TIOCOUTQ:
	case FIONBIO:
	case TIOCSCTTY:
	case TIOCGETD:
	case TIOCSETD:
	case TIOCPKT:
		printnum(tcp->pid, arg, "%d");
		return 1;
	case TIOCMGET:
	case TIOCMBIS:
	case TIOCMBIC:
	case TIOCMSET:
		printnum(tcp->pid, arg, "%#x");
		return 1;
	default:
		return 0;
	}
}

