dnl aclocal.m4 -- custom autoconf macros for the Universal NFS server
dnl
define(AC_PROG_RPCGEN,
[AC_PROGRAMS_CHECK(RPCGEN, rpcgen.new rpcgen, rpcgen)])dnl
dnl
define(AC_RPCGEN_C,
[echo checking for rpcgen -C
if $RPCGEN -C -c </dev/null >/dev/null 2>/dev/null
then
  RPCGEN_C=-C
else
  RPCGEN_C=
fi
AC_SUBST(RPCGEN_C)
test -n "$RPCGEN_C" && AC_DEFINE(HAVE_RPCGEN_C)
])dnl
dnl
define(AC_RPCGEN_I,
[echo checking for rpcgen -I
if $RPCGEN -I -c </dev/null >/dev/null 2>/dev/null
then
  RPCGEN_I=-I
else
  RPCGEN_I=
fi
AC_SUBST(RPCGEN_I)
test -n "$RPCGEN_I" && AC_DEFINE(HAVE_RPCGEN_I)
])dnl
dnl
define(AC_NOBODY,
[echo checking for the uid and gid of nobody
rm -f confout
AC_TEST_PROGRAM([#include <stdio.h>
#include <pwd.h>
main()
{
	struct passwd *pw;
	struct passwd *getpwnam();
	FILE *ofp;

	pw = getpwnam("nobody");
	if (pw) {
		ofp = fopen("confout", "w");
		if (ofp) {
			fprintf(ofp, "NOBODY_UID=%d NOBODY_GID=%d\n",
				pw->pw_uid, pw->pw_gid);
			exit(0);
		}
	}
	exit(1);
}
],
[eval `cat confout`])
rm -f core confout
test -n "$NOBODY_UID" && AC_DEFINE_UNQUOTED(NOBODY_UID, $NOBODY_UID)
test -n "$NOBODY_GID" && AC_DEFINE_UNQUOTED(NOBODY_GID, $NOBODY_GID)
])dnl
dnl
define(AC_MOUNTLIST,
[echo checking how to get list of mounted filesystems
mounted=

# DEC Alpha running OSF/1.
AC_COMPILE_CHECK(, [
#include <sys/types.h>
#include <sys/mount.h>
#include <sys/fs_types.h>],
[struct statfs *stats;
numsys = getfsstat ((struct statfs *)0, 0L, MNT_WAIT); ],
  AC_DEFINE(MOUNTED_GETFSSTAT) mounted=1)
if test -z "$mounted"; then
# SVR4
AC_HEADER_EGREP(getmntent, sys/mnttab.h,
  AC_DEFINE(MOUNTED_GETMNTENT2) mounted=1)
fi
if test -z "$mounted"; then
# AIX.
AC_TEST_CPP([#include <fshelp.h>], 
  AC_DEFINE(MOUNTED_VMOUNT) mounted=1)
fi
if test -z "$mounted"; then
# SVR3
AC_TEST_CPP([#include <sys/statfs.h>
#include <sys/fstyp.h>
#include <mnttab.h>], 
  AC_DEFINE(MOUNTED_FREAD_FSTYP) mounted=1)
fi
if test -z "$mounted"; then
# 4.3BSD
AC_TEST_CPP([#include <mntent.h>], 
  AC_DEFINE(MOUNTED_GETMNTENT1) mounted=1)
fi
if test -z "$mounted"; then
# 4.4BSD and DEC OSF/1.
AC_HEADER_EGREP(f_type;, sys/mount.h,  
  AC_DEFINE(MOUNTED_GETMNTINFO) mounted=1)
fi
if test -z "$mounted"; then
# Ultrix
AC_TEST_CPP([#include <sys/fs_types.h>
#include <sys/mount.h>],
  AC_DEFINE(MOUNTED_GETMNT) mounted=1)
fi
if test -z "$mounted"; then
# SVR2
AC_TEST_CPP([#include <mnttab.h>],
  AC_DEFINE(MOUNTED_FREAD) mounted=1)
fi
])dnl
define(AC_FSUSAGE,
[echo checking how to get filesystem space usage
space= 

# DEC Alpha running OSF/1
AC_TEST_PROGRAM([
#include <sys/types.h>
#include <sys/mount.h>
main ()
{
struct statfs fsd;
exit (statfs (".", &fsd, sizeof (struct statfs)));
}], AC_DEFINE(STATFS_OSF1) space=1)
if test -z "$space"; then
# SVR4
AC_TEST_CPP([#include <sys/statvfs.h>
#include <sys/fstyp.h>], AC_DEFINE(STAT_STATVFS) space=1)
fi
if test -z "$space"; then
# AIX
AC_HEADER_EGREP(f_nlsdirtype, sys/statfs.h, 
  AC_DEFINE(STAT_STATFS2_BSIZE) space=1)
fi
if test -z "$space"; then
# SVR3
AC_TEST_CPP([#include <sys/statfs.h>], 
  AC_DEFINE(STAT_STATFS4) space=1)
fi
if test -z "$space"; then
# 4.3BSD
AC_TEST_CPP([#include <sys/vfs.h>],
  AC_DEFINE(STAT_STATFS2_BSIZE) space=1)
fi
if test -z "$space"; then
# 4.4BSD
AC_HEADER_EGREP(MOUNT_UFS, sys/mount.h,
  AC_DEFINE(STAT_STATFS2_FSIZE) space=1)
fi
if test -z "$space"; then
# SVR2
AC_TEST_CPP([#include <sys/filsys.h>],
  AC_DEFINE(STAT_READ) space=1)
fi
if test -z "$space"; then
# Ultrix
AC_TEST_CPP([#include <sys/mount.h>],
  AC_DEFINE(STAT_STATFS2_FS_DATA) space=1)
fi
])dnl
