/* Widget based utility functions.
   Copyright (C) 1994 Miguel de Icaza

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
static char rcsid [] = "$Id: wtools.c,v 1.2 1995/01/27 02:36:59 miguel Exp $";
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include <ncurses.h>
#include <stdarg.h>
#include "mad.h"
#include "global.h"
#include "win.h"
#include "color.h"
#include "util.h"
#include "input.h"
#include "mouse.h"
#include "dlg.h"
#include "widget.h"
#include "menu.h"
#include "wtools.h"
#include "key.h"	/* For mi_getch() */
#include "dialog.h"	/* For do_refresh() and my_wputs() */

static chtype listbox_colors[4];

/* Listbox utility functions */
Listbox *create_listbox_window (int cols, int lines, char *title, char *help)
{
    int xpos, ypos;
    Listbox  *listbox = xmalloc (sizeof (Listbox), "create_listbox_window");

    /* The 0 index is unused by the listbox widget */
    listbox_colors [0] = COLOR_NORMAL;
    listbox_colors [1] = COLOR_FOCUS;
    listbox_colors [2] = COLOR_HOT_NORMAL;
    listbox_colors [3] = COLOR_HOT_FOCUS;

    /* Adjust sizes */
    lines = (lines > LINES-6) ? lines = LINES - 6 : lines;
    cols = cols > COLS-6 ? COLS - 6 : cols;

    /* I'm not sure if this -2 is safe, should test it */
    xpos = (COLS-cols)/2;
    ypos = (LINES-lines)/2 - 2;

    /* Create components */
    listbox->w = newwin (lines+4, cols+4, ypos, xpos);
    listbox->dlg = dlg_new (listbox->w, listbox_colors, 0, ypos, xpos, help);
    listbox->list = listbox_new (2, 2, cols, lines, listbox_finish, 0);

    add_widget (listbox->dlg, listbox->list);
    
    /* Draw the screen */
    wattrset (listbox->w, COLOR_NORMAL);
    wclr (listbox->w);
    draw_box (listbox->w, 1, 1, lines+2, cols+2);
    wattrset (listbox->w, COLOR_HOT_NORMAL);
    mvwprintw (listbox->w, 1, (cols-strlen (title))/2, "%s", title);
    return listbox;
}

/* Returns the number of the item selected */
int run_listbox (Listbox *l)
{
    int val;
    
    run_dlg (l->dlg);
    if (l->dlg->ret_value == B_CANCEL)
	val = -1;
    else
	val = l->list->pos;
    destroy_dlg (l->dlg);
    delwin (l->w);
    free (l);
    do_refresh ();
    return val;
}

int query_dialog (char *header, char *text, int flags, int count, ...)
{
    va_list ap;
    Dlg_head *query_dlg;
    WINDOW *query_win;
    int win_len = 0;
    int i;
    int result = -1;
    int xpos, ypos, cols, lines;
    char *cur_name;
    chtype query_colors [4];
                                       /* set dialog colors */
    query_colors [1] = (flags & BAR_ERROR) ? REVERSE_COLOR : Q_SELECTED_COLOR;
    query_colors [0] = (flags & BAR_ERROR) ? ERROR_COLOR : Q_UNSELECTED_COLOR;
    
    if (count > 0){
	va_start (ap, count);
	for (i = 0; i < count; i++)
	    win_len += strlen (va_arg (ap, char *)) + 2;
	va_end(ap);
    }

    /* count coordinates */
    cols = 4 + max (win_len+1, max (strlen (header), msglen (text, &lines)));
    lines += 6;

    xpos = COLS/2 - cols/2;
    ypos = LINES/3 - (lines-3)/2;
    
    /* designate window */
    query_win = newwin (lines, cols, ypos, xpos);
    leaveok (query_win, TRUE);
    wattrset (query_win, query_colors [0]);
    wclr (query_win);
    draw_box (query_win, 1, 1, lines-2, cols-2);
    mvwprintw (query_win, 1, (cols-strlen (header))/2, "%s", header);
    my_wputs (query_win, 2, 2, text);
    
    /* prepare dialog */
    if (count > 0){
	query_dlg = dlg_new(query_win, query_colors, std_callback, ypos, xpos,
			    "[QueryBox]");
	query_dlg->direction = DIR_BACKWARD;

	cols = (cols-win_len-2)/2 + 2;
	va_start (ap, count);
	for (i = 0; i < count; i++){
	    cur_name = va_arg (ap, char *);
	    xpos = strlen (cur_name)+2;
	    if (flags & WITH_HOTKEYS)
		add_widget (query_dlg, button_new
			    (lines-3, cols, B_USER+i, cur_name+1,
			     cur_name [0], -1, 0, 0));
	    else
		add_widget (query_dlg, button_new
			    (lines-3, cols, B_USER+i, cur_name,
			     cur_name [1], -1, 0, 0));
	    cols += xpos;
	}
	va_end (ap);
	
	/* run dialog and make result */
	run_dlg (query_dlg);
	switch (query_dlg->ret_value){
	case B_CANCEL:
	    break;
	default:
	    result = query_dlg->ret_value-B_USER;
	}

	/* free used memory */
	destroy_dlg (query_dlg);
    } else
	mi_getch ();
    
    delwin (query_win);
    do_refresh ();
    
    return result;
}

void init_box_colors (chtype colors [4])
{
    colors [0] = COLOR_NORMAL;
    colors [1] = COLOR_FOCUS;
    colors [2] = COLOR_HOT_NORMAL;
    colors [3] = COLOR_HOT_FOCUS;
}

